/* secret-mediator.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from secret-mediator.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-client-46.0.h"
#include <gio/gio.h>
#include "geary-engine.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <libsecret/secret.h>
#include <glib-object.h>

#define SECRET_MEDIATOR_ATTR_LOGIN "login"
#define SECRET_MEDIATOR_ATTR_HOST "host"
#define SECRET_MEDIATOR_ATTR_PROTO "proto"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SECRET_MEDIATOR_0_PROPERTY,
	SECRET_MEDIATOR_NUM_PROPERTIES
};
static GParamSpec* secret_mediator_properties[SECRET_MEDIATOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SecretMediatorNewData SecretMediatorNewData;
typedef struct _SecretMediatorLoadTokenData SecretMediatorLoadTokenData;
typedef struct _SecretMediatorUpdateTokenData SecretMediatorUpdateTokenData;
typedef struct _SecretMediatorClearTokenData SecretMediatorClearTokenData;
typedef struct _SecretMediatorCheckUnlockedData SecretMediatorCheckUnlockedData;
typedef struct _SecretMediatorDoStoreData SecretMediatorDoStoreData;
typedef struct _SecretMediatorMigrateOldPasswordData SecretMediatorMigrateOldPasswordData;

struct _SecretMediatorNewData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GType object_type;
	SecretMediator* self;
	ApplicationClient* application;
	GCancellable* cancellable;
	gboolean _tmp0_;
	gboolean _tmp1_;
	SecretSchema* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GError* _inner_error0_;
};

struct _SecretMediatorLoadTokenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SecretMediator* self;
	GearyAccountInformation* account;
	GearyServiceInformation* service;
	GCancellable* cancellable;
	gboolean result;
	gboolean loaded;
	GearyCredentials* _tmp0_;
	GearyCredentials* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gchar* password;
	SecretSchema* _tmp4_;
	GHashTable* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	GearyCredentials* _tmp12_;
	GearyCredentials* _tmp13_;
	const gchar* _tmp14_;
	GearyCredentials* _tmp15_;
	GearyCredentials* _tmp16_;
	GearyCredentials* _tmp17_;
	GearyCredentials* _tmp18_;
	GError* _inner_error0_;
};

struct _SecretMediatorUpdateTokenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SecretMediator* self;
	GearyAccountInformation* account;
	GearyServiceInformation* service;
	GCancellable* cancellable;
	GearyCredentials* _tmp0_;
	GearyCredentials* _tmp1_;
	GearyCredentials* _tmp2_;
	GearyCredentials* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GError* _inner_error0_;
};

struct _SecretMediatorClearTokenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SecretMediator* self;
	GearyAccountInformation* account;
	GearyServiceInformation* service;
	GCancellable* cancellable;
	GearyCredentials* _tmp0_;
	GearyCredentials* _tmp1_;
	SecretSchema* _tmp2_;
	GHashTable* _tmp3_;
	SecretSchema* _tmp4_;
	GearyRFC822MailboxAddress* _tmp5_;
	GearyRFC822MailboxAddress* _tmp6_;
	GearyRFC822MailboxAddress* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	SecretSchema* _tmp12_;
	GearyCredentials* _tmp13_;
	GearyCredentials* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GError* _inner_error0_;
};

struct _SecretMediatorCheckUnlockedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SecretMediator* self;
	GCancellable* cancellable;
	SecretService* service;
	SecretService* _tmp0_;
	SecretCollection* collection;
	SecretService* _tmp1_;
	SecretCollection* _tmp2_;
	gboolean _tmp3_;
	SecretCollection* _tmp4_;
	SecretCollection* _tmp5_;
	GList* to_lock;
	SecretCollection* _tmp6_;
	SecretCollection* _tmp7_;
	GList* unlocked;
	SecretService* _tmp8_;
	GList* _tmp9_;
	GList* _tmp10_;
	GList* _tmp11_;
	GError* _inner_error0_;
};

struct _SecretMediatorDoStoreData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SecretMediator* self;
	GearyServiceInformation* service;
	gchar* password;
	GCancellable* cancellable;
	SecretSchema* _tmp0_;
	GHashTable* _tmp1_;
	GearyProtocol _tmp2_;
	GearyProtocol _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GError* _inner_error0_;
};

struct _SecretMediatorMigrateOldPasswordData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SecretMediator* self;
	GearyServiceInformation* service;
	GCancellable* cancellable;
	gchar* result;
	gchar* user;
	GearyCredentials* _tmp0_;
	GearyCredentials* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* password;
	SecretSchema* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	SecretSchema* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	GError* _inner_error0_;
};

static gpointer secret_mediator_parent_class = NULL;
static SecretSchema* secret_mediator_schema;
static SecretSchema* secret_mediator_schema = NULL;
static SecretSchema* secret_mediator_compat_schema;
static SecretSchema* secret_mediator_compat_schema = NULL;
static GearyCredentialsMediatorIface * secret_mediator_geary_credentials_mediator_parent_iface = NULL;

static void secret_mediator_construct_data_free (gpointer _data);
static gboolean secret_mediator_construct_co (SecretMediatorNewData* _data_);
static void secret_mediator_check_unlocked (SecretMediator* self,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
static void secret_mediator_check_unlocked_finish (SecretMediator* self,
                                            GAsyncResult* _res_,
                                            GError** error);
static void secret_mediator_new_ready (GObject* source_object,
                                GAsyncResult* _res_,
                                gpointer _user_data_);
static void secret_mediator_real_load_token_data_free (gpointer _data);
static void secret_mediator_real_load_token (SecretMediator* self,
                                      GearyAccountInformation* account,
                                      GearyServiceInformation* service,
                                      GCancellable* cancellable,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static gboolean secret_mediator_real_load_token_co (SecretMediatorLoadTokenData* _data_);
static GHashTable* secret_mediator_new_attrs (SecretMediator* self,
                                       GearyServiceInformation* service);
static void secret_mediator_load_token_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
static void secret_mediator_migrate_old_password (SecretMediator* self,
                                           GearyServiceInformation* service,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static gchar* secret_mediator_migrate_old_password_finish (SecretMediator* self,
                                                    GAsyncResult* _res_,
                                                    GError** error);
static void secret_mediator_update_token_data_free (gpointer _data);
static gboolean secret_mediator_update_token_co (SecretMediatorUpdateTokenData* _data_);
static void secret_mediator_do_store (SecretMediator* self,
                               GearyServiceInformation* service,
                               const gchar* password,
                               GCancellable* cancellable,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
static void secret_mediator_do_store_finish (SecretMediator* self,
                                      GAsyncResult* _res_,
                                      GError** error);
static void secret_mediator_update_token_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
static void secret_mediator_clear_token_data_free (gpointer _data);
static gboolean secret_mediator_clear_token_co (SecretMediatorClearTokenData* _data_);
static void secret_mediator_clear_token_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_);
static gchar* secret_mediator_get_legacy_user (SecretMediator* self,
                                        GearyServiceInformation* service,
                                        const gchar* user);
static void secret_mediator_check_unlocked_data_free (gpointer _data);
static gboolean secret_mediator_check_unlocked_co (SecretMediatorCheckUnlockedData* _data_);
static void secret_mediator_check_unlocked_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void secret_mediator_do_store_data_free (gpointer _data);
static gboolean secret_mediator_do_store_co (SecretMediatorDoStoreData* _data_);
static inline gchar* secret_mediator_to_proto_value (SecretMediator* self,
                                       GearyProtocol protocol);
static void secret_mediator_do_store_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_);
static void _g_free0_ (gpointer var);
static void secret_mediator_migrate_old_password_data_free (gpointer _data);
static gboolean secret_mediator_migrate_old_password_co (SecretMediatorMigrateOldPasswordData* _data_);
static void secret_mediator_migrate_old_password_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static void secret_mediator_finalize (GObject * obj);
static GType secret_mediator_get_type_once (void);

static void
secret_mediator_construct_data_free (gpointer _data)
{
	SecretMediatorNewData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->application);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SecretMediatorNewData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
secret_mediator_construct (GType object_type,
                           ApplicationClient* application,
                           GCancellable* cancellable,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_)
{
	SecretMediatorNewData* _data_;
	ApplicationClient* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (APPLICATION_IS_CLIENT (application));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (SecretMediatorNewData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, secret_mediator_construct_data_free);
	_data_->object_type = object_type;
	_tmp0_ = _g_object_ref0 (application);
	_g_object_unref0 (_data_->application);
	_data_->application = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	secret_mediator_construct_co (_data_);
}

SecretMediator*
secret_mediator_construct_finish (GAsyncResult* _res_,
                                  GError** error)
{
	SecretMediator* result;
	SecretMediatorNewData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->self;
	_data_->self = NULL;
	return result;
}

static void
secret_mediator_new_ready (GObject* source_object,
                           GAsyncResult* _res_,
                           gpointer _user_data_)
{
	SecretMediatorNewData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	secret_mediator_construct_co (_data_);
}

static gboolean
secret_mediator_construct_co (SecretMediatorNewData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->self = (SecretMediator*) g_object_new (_data_->object_type, NULL);
	_data_->_state_ = 1;
	secret_mediator_check_unlocked (_data_->self, _data_->cancellable, secret_mediator_new_ready, _data_);
	return FALSE;
	_state_1:
	secret_mediator_check_unlocked_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = application_client_get_is_flatpak_sandboxed (_data_->application);
	_data_->_tmp1_ = _data_->_tmp0_;
	if (_data_->_tmp1_) {
		_data_->_tmp2_ = secret_mediator_schema;
		_data_->_state_ = 2;
		secret_password_lookup (_data_->_tmp2_, _data_->cancellable, secret_mediator_new_ready, _data_, SECRET_MEDIATOR_ATTR_LOGIN, "", NULL);
		return FALSE;
		_state_2:
		_data_->_tmp3_ = secret_password_lookup_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_g_free0 (_data_->_tmp4_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
secret_mediator_new (ApplicationClient* application,
                     GCancellable* cancellable,
                     GAsyncReadyCallback _callback_,
                     gpointer _user_data_)
{
	secret_mediator_construct (TYPE_SECRET_MEDIATOR, application, cancellable, _callback_, _user_data_);
}

SecretMediator*
secret_mediator_new_finish (GAsyncResult* _res_,
                            GError** error)
{
	return secret_mediator_construct_finish (_res_, error);
}

static void
secret_mediator_real_load_token_data_free (gpointer _data)
{
	SecretMediatorLoadTokenData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	_g_object_unref0 (_data_->service);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SecretMediatorLoadTokenData, _data_);
}

static void
secret_mediator_real_load_token (SecretMediator* self,
                                 GearyAccountInformation* account,
                                 GearyServiceInformation* service,
                                 GCancellable* cancellable,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	SecretMediatorLoadTokenData* _data_;
	SecretMediator* _tmp0_;
	GearyAccountInformation* _tmp1_;
	GearyServiceInformation* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT_INFORMATION));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (service, GEARY_TYPE_SERVICE_INFORMATION));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (SecretMediatorLoadTokenData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, secret_mediator_real_load_token_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (account);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = _g_object_ref0 (service);
	_g_object_unref0 (_data_->service);
	_data_->service = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	secret_mediator_real_load_token_co (_data_);
}

static gboolean
secret_mediator_real_load_token_finish (SecretMediator* self,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	gboolean result;
	SecretMediatorLoadTokenData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
secret_mediator_load_token_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	SecretMediatorLoadTokenData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	secret_mediator_real_load_token_co (_data_);
}

static gboolean
secret_mediator_real_load_token_co (SecretMediatorLoadTokenData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->loaded = FALSE;
	_data_->_tmp0_ = geary_service_information_get_credentials (_data_->service);
	_data_->_tmp1_ = _data_->_tmp0_;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = geary_service_information_get_remember_password (_data_->service);
		_data_->_tmp3_ = _data_->_tmp2_;
		if (_data_->_tmp3_) {
			_data_->_tmp4_ = secret_mediator_schema;
			_data_->_tmp5_ = secret_mediator_new_attrs (_data_->self, _data_->service);
			_data_->_state_ = 1;
			secret_password_lookupv (_data_->_tmp4_, _data_->_tmp5_, _data_->cancellable, secret_mediator_load_token_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp6_ = secret_password_lookup_finish (_data_->_res_, &_data_->_inner_error0_);
			_data_->password = _data_->_tmp6_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp7_ = _data_->password;
			if (_data_->_tmp7_ == NULL) {
				_data_->_state_ = 2;
				secret_mediator_migrate_old_password (_data_->self, _data_->service, _data_->cancellable, secret_mediator_load_token_ready, _data_);
				return FALSE;
				_state_2:
				_data_->_tmp9_ = secret_mediator_migrate_old_password_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
				_data_->_tmp8_ = _data_->_tmp9_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					_g_free0 (_data_->password);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp10_ = _data_->_tmp8_;
				_data_->_tmp8_ = NULL;
				_g_free0 (_data_->password);
				_data_->password = _data_->_tmp10_;
				_g_free0 (_data_->_tmp8_);
			}
			_data_->_tmp11_ = _data_->password;
			if (_data_->_tmp11_ != NULL) {
				_data_->_tmp12_ = geary_service_information_get_credentials (_data_->service);
				_data_->_tmp13_ = _data_->_tmp12_;
				_data_->_tmp14_ = _data_->password;
				_data_->_tmp15_ = geary_credentials_copy_with_token (_data_->_tmp13_, _data_->_tmp14_);
				_data_->_tmp16_ = _data_->_tmp15_;
				geary_service_information_set_credentials (_data_->service, _data_->_tmp16_);
				_g_object_unref0 (_data_->_tmp16_);
				_data_->loaded = TRUE;
			}
			_g_free0 (_data_->password);
		} else {
			_data_->_tmp17_ = geary_service_information_get_credentials (_data_->service);
			_data_->_tmp18_ = _data_->_tmp17_;
			_data_->loaded = geary_credentials_is_complete (_data_->_tmp18_);
		}
	}
	_data_->result = _data_->loaded;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
secret_mediator_load_token (SecretMediator* self,
                            GearyAccountInformation* account,
                            GearyServiceInformation* service,
                            GCancellable* cancellable,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	SecretMediatorClass* _klass_;
	_klass_ = SECRET_MEDIATOR_GET_CLASS (self);
	if (_klass_->load_token) {
		_klass_->load_token (self, account, service, cancellable, _callback_, _user_data_);
	}
}

gboolean
secret_mediator_load_token_finish (SecretMediator* self,
                                   GAsyncResult* _res_,
                                   GError** error)
{
	SecretMediatorClass* _klass_;
	_klass_ = SECRET_MEDIATOR_GET_CLASS (self);
	if (_klass_->load_token_finish) {
		return _klass_->load_token_finish (self, _res_, error);
	}
	return FALSE;
}

static void
secret_mediator_update_token_data_free (gpointer _data)
{
	SecretMediatorUpdateTokenData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	_g_object_unref0 (_data_->service);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SecretMediatorUpdateTokenData, _data_);
}

void
secret_mediator_update_token (SecretMediator* self,
                              GearyAccountInformation* account,
                              GearyServiceInformation* service,
                              GCancellable* cancellable,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	SecretMediatorUpdateTokenData* _data_;
	SecretMediator* _tmp0_;
	GearyAccountInformation* _tmp1_;
	GearyServiceInformation* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (IS_SECRET_MEDIATOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT_INFORMATION));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (service, GEARY_TYPE_SERVICE_INFORMATION));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (SecretMediatorUpdateTokenData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, secret_mediator_update_token_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (account);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = _g_object_ref0 (service);
	_g_object_unref0 (_data_->service);
	_data_->service = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	secret_mediator_update_token_co (_data_);
}

void
secret_mediator_update_token_finish (SecretMediator* self,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	SecretMediatorUpdateTokenData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
secret_mediator_update_token_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	SecretMediatorUpdateTokenData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	secret_mediator_update_token_co (_data_);
}

static gboolean
secret_mediator_update_token_co (SecretMediatorUpdateTokenData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_service_information_get_credentials (_data_->service);
	_data_->_tmp1_ = _data_->_tmp0_;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = geary_service_information_get_credentials (_data_->service);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = geary_credentials_get_token (_data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_state_ = 1;
		secret_mediator_do_store (_data_->self, _data_->service, _data_->_tmp5_, _data_->cancellable, secret_mediator_update_token_ready, _data_);
		return FALSE;
		_state_1:
		secret_mediator_do_store_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
secret_mediator_clear_token_data_free (gpointer _data)
{
	SecretMediatorClearTokenData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	_g_object_unref0 (_data_->service);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SecretMediatorClearTokenData, _data_);
}

void
secret_mediator_clear_token (SecretMediator* self,
                             GearyAccountInformation* account,
                             GearyServiceInformation* service,
                             GCancellable* cancellable,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	SecretMediatorClearTokenData* _data_;
	SecretMediator* _tmp0_;
	GearyAccountInformation* _tmp1_;
	GearyServiceInformation* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (IS_SECRET_MEDIATOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT_INFORMATION));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (service, GEARY_TYPE_SERVICE_INFORMATION));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (SecretMediatorClearTokenData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, secret_mediator_clear_token_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (account);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = _g_object_ref0 (service);
	_g_object_unref0 (_data_->service);
	_data_->service = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	secret_mediator_clear_token_co (_data_);
}

void
secret_mediator_clear_token_finish (SecretMediator* self,
                                    GAsyncResult* _res_,
                                    GError** error)
{
	SecretMediatorClearTokenData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
secret_mediator_clear_token_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_)
{
	SecretMediatorClearTokenData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	secret_mediator_clear_token_co (_data_);
}

static gboolean
secret_mediator_clear_token_co (SecretMediatorClearTokenData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_service_information_get_credentials (_data_->service);
	_data_->_tmp1_ = _data_->_tmp0_;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = secret_mediator_schema;
		_data_->_tmp3_ = secret_mediator_new_attrs (_data_->self, _data_->service);
		_data_->_state_ = 1;
		secret_password_clearv (_data_->_tmp2_, _data_->_tmp3_, _data_->cancellable, secret_mediator_clear_token_ready, _data_);
		return FALSE;
		_state_1:
		secret_password_clear_finish (_data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp4_ = secret_mediator_compat_schema;
		_data_->_tmp5_ = geary_account_information_get_primary_mailbox (_data_->account);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp8_ = geary_rf_c822_mailbox_address_get_address (_data_->_tmp7_);
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp10_ = secret_mediator_get_legacy_user (_data_->self, _data_->service, _data_->_tmp9_);
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_state_ = 2;
		secret_password_clear (_data_->_tmp4_, _data_->cancellable, secret_mediator_clear_token_ready, _data_, "user", _data_->_tmp11_, NULL);
		return FALSE;
		_state_2:
		secret_password_clear_finish (_data_->_res_, &_data_->_inner_error0_);
		_g_free0 (_data_->_tmp11_);
		_g_object_unref0 (_data_->_tmp7_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp12_ = secret_mediator_compat_schema;
		_data_->_tmp13_ = geary_service_information_get_credentials (_data_->service);
		_data_->_tmp14_ = _data_->_tmp13_;
		_data_->_tmp15_ = geary_credentials_get_user (_data_->_tmp14_);
		_data_->_tmp16_ = _data_->_tmp15_;
		_data_->_tmp17_ = secret_mediator_get_legacy_user (_data_->self, _data_->service, _data_->_tmp16_);
		_data_->_tmp18_ = _data_->_tmp17_;
		_data_->_state_ = 3;
		secret_password_clear (_data_->_tmp12_, _data_->cancellable, secret_mediator_clear_token_ready, _data_, "user", _data_->_tmp18_, NULL);
		return FALSE;
		_state_3:
		secret_password_clear_finish (_data_->_res_, &_data_->_inner_error0_);
		_g_free0 (_data_->_tmp18_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
secret_mediator_check_unlocked_data_free (gpointer _data)
{
	SecretMediatorCheckUnlockedData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SecretMediatorCheckUnlockedData, _data_);
}

static void
secret_mediator_check_unlocked (SecretMediator* self,
                                GCancellable* cancellable,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	SecretMediatorCheckUnlockedData* _data_;
	SecretMediator* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (IS_SECRET_MEDIATOR (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (SecretMediatorCheckUnlockedData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, secret_mediator_check_unlocked_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	secret_mediator_check_unlocked_co (_data_);
}

static void
secret_mediator_check_unlocked_finish (SecretMediator* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	SecretMediatorCheckUnlockedData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
secret_mediator_check_unlocked_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	SecretMediatorCheckUnlockedData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	secret_mediator_check_unlocked_co (_data_);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
secret_mediator_check_unlocked_co (SecretMediatorCheckUnlockedData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	secret_service_get (SECRET_SERVICE_OPEN_SESSION, _data_->cancellable, secret_mediator_check_unlocked_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = secret_service_get_finish (_data_->_res_, &_data_->_inner_error0_);
	_data_->service = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->service;
	_data_->_state_ = 2;
	secret_collection_for_alias (_data_->_tmp1_, SECRET_COLLECTION_DEFAULT, SECRET_COLLECTION_NONE, _data_->cancellable, secret_mediator_check_unlocked_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp2_ = secret_collection_for_alias_finish (_data_->_res_, &_data_->_inner_error0_);
	_data_->collection = _data_->_tmp2_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->service);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->collection;
	if (_data_->_tmp4_ != NULL) {
		_data_->_tmp5_ = _data_->collection;
		_data_->_tmp3_ = secret_collection_get_locked (_data_->_tmp5_);
	} else {
		_data_->_tmp3_ = FALSE;
	}
	if (_data_->_tmp3_) {
		_data_->to_lock = NULL;
		_data_->_tmp6_ = _data_->collection;
		_data_->_tmp7_ = _g_object_ref0 (_data_->_tmp6_);
		_data_->to_lock = g_list_append (_data_->to_lock, _data_->_tmp7_);
		_data_->_tmp8_ = _data_->service;
		_data_->_tmp9_ = _data_->to_lock;
		_data_->_tmp10_ = NULL;
		_data_->_state_ = 3;
		secret_service_unlock (_data_->_tmp8_, _data_->_tmp9_, _data_->cancellable, secret_mediator_check_unlocked_ready, _data_);
		return FALSE;
		_state_3:
		secret_service_unlock_finish (_data_->_tmp8_, _data_->_res_, &_data_->_tmp10_, &_data_->_inner_error0_);
		(_data_->unlocked == NULL) ? NULL : (_data_->unlocked = (_g_list_free__g_object_unref0_ (_data_->unlocked), NULL));
		_data_->unlocked = _data_->_tmp10_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			(_data_->unlocked == NULL) ? NULL : (_data_->unlocked = (_g_list_free__g_object_unref0_ (_data_->unlocked), NULL));
			(_data_->to_lock == NULL) ? NULL : (_data_->to_lock = (_g_list_free__g_object_unref0_ (_data_->to_lock), NULL));
			_g_object_unref0 (_data_->collection);
			_g_object_unref0 (_data_->service);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp11_ = _data_->unlocked;
		if (g_list_length (_data_->_tmp11_) != ((guint) 0)) {
		}
		(_data_->unlocked == NULL) ? NULL : (_data_->unlocked = (_g_list_free__g_object_unref0_ (_data_->unlocked), NULL));
		(_data_->to_lock == NULL) ? NULL : (_data_->to_lock = (_g_list_free__g_object_unref0_ (_data_->to_lock), NULL));
	}
	_g_object_unref0 (_data_->collection);
	_g_object_unref0 (_data_->service);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
secret_mediator_do_store_data_free (gpointer _data)
{
	SecretMediatorDoStoreData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->service);
	_g_free0 (_data_->password);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SecretMediatorDoStoreData, _data_);
}

static void
secret_mediator_do_store (SecretMediator* self,
                          GearyServiceInformation* service,
                          const gchar* password,
                          GCancellable* cancellable,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	SecretMediatorDoStoreData* _data_;
	SecretMediator* _tmp0_;
	GearyServiceInformation* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (IS_SECRET_MEDIATOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (service, GEARY_TYPE_SERVICE_INFORMATION));
	g_return_if_fail (password != NULL);
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (SecretMediatorDoStoreData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, secret_mediator_do_store_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (service);
	_g_object_unref0 (_data_->service);
	_data_->service = _tmp1_;
	_tmp2_ = g_strdup (password);
	_g_free0 (_data_->password);
	_data_->password = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	secret_mediator_do_store_co (_data_);
}

static void
secret_mediator_do_store_finish (SecretMediator* self,
                                 GAsyncResult* _res_,
                                 GError** error)
{
	SecretMediatorDoStoreData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
secret_mediator_do_store_ready (GObject* source_object,
                                GAsyncResult* _res_,
                                gpointer _user_data_)
{
	SecretMediatorDoStoreData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	secret_mediator_do_store_co (_data_);
}

static gboolean
secret_mediator_do_store_co (SecretMediatorDoStoreData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = secret_mediator_schema;
	_data_->_tmp1_ = secret_mediator_new_attrs (_data_->self, _data_->service);
	_data_->_tmp2_ = geary_service_information_get_protocol (_data_->service);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = secret_mediator_to_proto_value (_data_->self, _data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = g_strdup_printf ("Geary %s password", _data_->_tmp5_);
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_state_ = 1;
	secret_password_storev (_data_->_tmp0_, _data_->_tmp1_, SECRET_COLLECTION_DEFAULT, _data_->_tmp7_, _data_->password, _data_->cancellable, secret_mediator_do_store_ready, _data_);
	return FALSE;
	_state_1:
	secret_password_store_finish (_data_->_res_, &_data_->_inner_error0_);
	_g_free0 (_data_->_tmp7_);
	_g_free0 (_data_->_tmp5_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static GHashTable*
secret_mediator_new_attrs (SecretMediator* self,
                           GearyServiceInformation* service)
{
	GHashTable* table = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	gchar* _tmp3_;
	GearyProtocol _tmp4_;
	GearyProtocol _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GearyCredentials* _tmp12_;
	GearyCredentials* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	GHashTable* result;
	g_return_val_if_fail (IS_SECRET_MEDIATOR (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (service, GEARY_TYPE_SERVICE_INFORMATION), NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	table = _tmp2_;
	_tmp3_ = g_strdup (SECRET_MEDIATOR_ATTR_PROTO);
	_tmp4_ = geary_service_information_get_protocol (service);
	_tmp5_ = _tmp4_;
	_tmp6_ = secret_mediator_to_proto_value (self, _tmp5_);
	g_hash_table_insert (table, _tmp3_, _tmp6_);
	_tmp7_ = g_strdup (SECRET_MEDIATOR_ATTR_HOST);
	_tmp8_ = geary_service_information_get_host (service);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strdup (_tmp9_);
	g_hash_table_insert (table, _tmp7_, _tmp10_);
	_tmp11_ = g_strdup (SECRET_MEDIATOR_ATTR_LOGIN);
	_tmp12_ = geary_service_information_get_credentials (service);
	_tmp13_ = _tmp12_;
	_tmp14_ = geary_credentials_get_user (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strdup (_tmp15_);
	g_hash_table_insert (table, _tmp11_, _tmp16_);
	result = table;
	return result;
}

static inline gchar*
secret_mediator_to_proto_value (SecretMediator* self,
                                GearyProtocol protocol)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (IS_SECRET_MEDIATOR (self), NULL);
	_tmp0_ = geary_protocol_to_value (protocol);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_ascii_strup (_tmp1_, (gssize) -1);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static void
secret_mediator_migrate_old_password_data_free (gpointer _data)
{
	SecretMediatorMigrateOldPasswordData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->service);
	_g_object_unref0 (_data_->cancellable);
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (SecretMediatorMigrateOldPasswordData, _data_);
}

static void
secret_mediator_migrate_old_password (SecretMediator* self,
                                      GearyServiceInformation* service,
                                      GCancellable* cancellable,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	SecretMediatorMigrateOldPasswordData* _data_;
	SecretMediator* _tmp0_;
	GearyServiceInformation* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (IS_SECRET_MEDIATOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (service, GEARY_TYPE_SERVICE_INFORMATION));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (SecretMediatorMigrateOldPasswordData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, secret_mediator_migrate_old_password_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (service);
	_g_object_unref0 (_data_->service);
	_data_->service = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	secret_mediator_migrate_old_password_co (_data_);
}

static gchar*
secret_mediator_migrate_old_password_finish (SecretMediator* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	gchar* result;
	SecretMediatorMigrateOldPasswordData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
secret_mediator_migrate_old_password_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	SecretMediatorMigrateOldPasswordData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	secret_mediator_migrate_old_password_co (_data_);
}

static gboolean
secret_mediator_migrate_old_password_co (SecretMediatorMigrateOldPasswordData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_service_information_get_credentials (_data_->service);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = geary_credentials_get_user (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = secret_mediator_get_legacy_user (_data_->self, _data_->service, _data_->_tmp3_);
	_data_->user = _data_->_tmp4_;
	_data_->_tmp5_ = secret_mediator_compat_schema;
	_data_->_tmp6_ = _data_->user;
	_data_->_state_ = 1;
	secret_password_lookup (_data_->_tmp5_, _data_->cancellable, secret_mediator_migrate_old_password_ready, _data_, "user", _data_->_tmp6_, NULL);
	return FALSE;
	_state_1:
	_data_->_tmp7_ = secret_password_lookup_finish (_data_->_res_, &_data_->_inner_error0_);
	_data_->password = _data_->_tmp7_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->user);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = _data_->password;
	if (_data_->_tmp8_ != NULL) {
		_data_->_tmp9_ = secret_mediator_compat_schema;
		_data_->_tmp10_ = _data_->user;
		_data_->_state_ = 2;
		secret_password_clear (_data_->_tmp9_, _data_->cancellable, secret_mediator_migrate_old_password_ready, _data_, "user", _data_->_tmp10_, NULL);
		return FALSE;
		_state_2:
		secret_password_clear_finish (_data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->password);
			_g_free0 (_data_->user);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp11_ = _data_->password;
		_data_->_state_ = 3;
		secret_mediator_do_store (_data_->self, _data_->service, _data_->_tmp11_, _data_->cancellable, secret_mediator_migrate_old_password_ready, _data_);
		return FALSE;
		_state_3:
		secret_mediator_do_store_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->password);
			_g_free0 (_data_->user);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->result = _data_->password;
	_g_free0 (_data_->user);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
secret_mediator_get_legacy_user (SecretMediator* self,
                                 GearyServiceInformation* service,
                                 const gchar* user)
{
	GearyProtocol _tmp0_;
	GearyProtocol _tmp1_;
	gchar* result;
	g_return_val_if_fail (IS_SECRET_MEDIATOR (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (service, GEARY_TYPE_SERVICE_INFORMATION), NULL);
	g_return_val_if_fail (user != NULL, NULL);
	_tmp0_ = geary_service_information_get_protocol (service);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case GEARY_PROTOCOL_IMAP:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strconcat ("org.yorba.geary imap_username:", user, NULL);
			result = _tmp2_;
			return result;
		}
		case GEARY_PROTOCOL_SMTP:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strconcat ("org.yorba.geary smtp_username:", user, NULL);
			result = _tmp3_;
			return result;
		}
		default:
		{
			gchar* _tmp4_;
			g_warning ("secret-mediator.vala:211: Unknown service type");
			_tmp4_ = g_strdup ("");
			result = _tmp4_;
			return result;
		}
	}
}

static void
secret_mediator_class_init (SecretMediatorClass * klass,
                            gpointer klass_data)
{
	SecretSchema* _tmp0_;
	SecretSchema* _tmp1_;
	secret_mediator_parent_class = g_type_class_peek_parent (klass);
	((SecretMediatorClass *) klass)->load_token = (void (*) (SecretMediator*, GearyAccountInformation*, GearyServiceInformation*, GCancellable*, GAsyncReadyCallback, gpointer)) secret_mediator_real_load_token;
	((SecretMediatorClass *) klass)->load_token_finish = (gboolean (*) (SecretMediator*, GAsyncResult*, GError**)) secret_mediator_real_load_token_finish;
	G_OBJECT_CLASS (klass)->finalize = secret_mediator_finalize;
	_tmp0_ = secret_schema_new (APPLICATION_CLIENT_SCHEMA_ID, SECRET_SCHEMA_NONE, SECRET_MEDIATOR_ATTR_LOGIN, SECRET_SCHEMA_ATTRIBUTE_STRING, SECRET_MEDIATOR_ATTR_HOST, SECRET_SCHEMA_ATTRIBUTE_STRING, SECRET_MEDIATOR_ATTR_PROTO, SECRET_SCHEMA_ATTRIBUTE_STRING, NULL, NULL);
	secret_mediator_schema = _tmp0_;
	_tmp1_ = secret_schema_new ("org.gnome.keyring.NetworkPassword", SECRET_SCHEMA_NONE, "user", SECRET_SCHEMA_ATTRIBUTE_STRING, "domain", SECRET_SCHEMA_ATTRIBUTE_STRING, "object", SECRET_SCHEMA_ATTRIBUTE_STRING, "protocol", SECRET_SCHEMA_ATTRIBUTE_STRING, "port", SECRET_SCHEMA_ATTRIBUTE_INTEGER, "server", SECRET_SCHEMA_ATTRIBUTE_STRING, "authtype", SECRET_SCHEMA_ATTRIBUTE_STRING, NULL, NULL);
	secret_mediator_compat_schema = _tmp1_;
}

static void
secret_mediator_geary_credentials_mediator_interface_init (GearyCredentialsMediatorIface * iface,
                                                           gpointer iface_data)
{
	secret_mediator_geary_credentials_mediator_parent_iface = g_type_interface_peek_parent (iface);
	iface->load_token = (void (*) (GearyCredentialsMediator*, GearyAccountInformation*, GearyServiceInformation*, GCancellable*, GAsyncReadyCallback, gpointer)) secret_mediator_load_token;
	iface->load_token_finish = (gboolean (*) (GearyCredentialsMediator*, GAsyncResult*, GError**)) secret_mediator_load_token_finish;
}

static void
secret_mediator_instance_init (SecretMediator * self,
                               gpointer klass)
{
}

static void
secret_mediator_finalize (GObject * obj)
{
	SecretMediator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SECRET_MEDIATOR, SecretMediator);
	G_OBJECT_CLASS (secret_mediator_parent_class)->finalize (obj);
}

/** LibSecret password adapter. */
static GType
secret_mediator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SecretMediatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) secret_mediator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SecretMediator), 0, (GInstanceInitFunc) secret_mediator_instance_init, NULL };
	static const GInterfaceInfo geary_credentials_mediator_info = { (GInterfaceInitFunc) secret_mediator_geary_credentials_mediator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType secret_mediator_type_id;
	secret_mediator_type_id = g_type_register_static (G_TYPE_OBJECT, "SecretMediator", &g_define_type_info, 0);
	g_type_add_interface_static (secret_mediator_type_id, GEARY_TYPE_CREDENTIALS_MEDIATOR, &geary_credentials_mediator_info);
	return secret_mediator_type_id;
}

GType
secret_mediator_get_type (void)
{
	static volatile gsize secret_mediator_type_id__once = 0;
	if (g_once_init_enter (&secret_mediator_type_id__once)) {
		GType secret_mediator_type_id;
		secret_mediator_type_id = secret_mediator_get_type_once ();
		g_once_init_leave (&secret_mediator_type_id__once, secret_mediator_type_id);
	}
	return secret_mediator_type_id__once;
}

