/* db.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from db.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include "geary-engine.h"
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef gint (*GearyDbSqliteExecOperation) (gpointer user_data);
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

gint sqlite3_enable_shared_cache (gint enabled);
VALA_EXTERN void geary_db_check_cancelled (const gchar* method,
                               GCancellable* cancellable,
                               GError** error);
VALA_EXTERN gint geary_db_throw_on_error (GearyDbContext* ctx,
                              const gchar* method,
                              gint _result_,
                              const gchar* raw,
                              GError** error);
VALA_EXTERN GearyDbDatabase* geary_db_context_get_database (GearyDbContext* self);
VALA_EXTERN GearyDbDatabaseConnection* geary_db_context_get_connection (GearyDbContext* self);
VALA_EXTERN sqlite3* geary_db_connection_get_db (GearyDbConnection* self);
VALA_EXTERN GearyDbStatement* geary_db_context_get_statement (GearyDbContext* self);

 G_GNUC_NO_INLINE static GType
geary_db_database_flags_get_type_once (void)
{
	static const GFlagsValue values[] = {{GEARY_DB_DATABASE_FLAGS_NONE, "GEARY_DB_DATABASE_FLAGS_NONE", "none"}, {GEARY_DB_DATABASE_FLAGS_CREATE_DIRECTORY, "GEARY_DB_DATABASE_FLAGS_CREATE_DIRECTORY", "create-directory"}, {GEARY_DB_DATABASE_FLAGS_CREATE_FILE, "GEARY_DB_DATABASE_FLAGS_CREATE_FILE", "create-file"}, {GEARY_DB_DATABASE_FLAGS_READ_ONLY, "GEARY_DB_DATABASE_FLAGS_READ_ONLY", "read-only"}, {GEARY_DB_DATABASE_FLAGS_CHECK_CORRUPTION, "GEARY_DB_DATABASE_FLAGS_CHECK_CORRUPTION", "check-corruption"}, {0, NULL, NULL}};
	GType geary_db_database_flags_type_id;
	geary_db_database_flags_type_id = g_flags_register_static ("GearyDbDatabaseFlags", values);
	return geary_db_database_flags_type_id;
}

GType
geary_db_database_flags_get_type (void)
{
	static gsize geary_db_database_flags_type_id__once = 0;
	if (g_once_init_enter (&geary_db_database_flags_type_id__once)) {
		GType geary_db_database_flags_type_id;
		geary_db_database_flags_type_id = geary_db_database_flags_get_type_once ();
		g_once_init_leave (&geary_db_database_flags_type_id__once, geary_db_database_flags_type_id);
	}
	return geary_db_database_flags_type_id__once;
}

 G_GNUC_NO_INLINE static GType
geary_db_reset_scope_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_DB_RESET_SCOPE_SAVE_BINDINGS, "GEARY_DB_RESET_SCOPE_SAVE_BINDINGS", "save-bindings"}, {GEARY_DB_RESET_SCOPE_CLEAR_BINDINGS, "GEARY_DB_RESET_SCOPE_CLEAR_BINDINGS", "clear-bindings"}, {0, NULL, NULL}};
	GType geary_db_reset_scope_type_id;
	geary_db_reset_scope_type_id = g_enum_register_static ("GearyDbResetScope", values);
	return geary_db_reset_scope_type_id;
}

GType
geary_db_reset_scope_get_type (void)
{
	static gsize geary_db_reset_scope_type_id__once = 0;
	if (g_once_init_enter (&geary_db_reset_scope_type_id__once)) {
		GType geary_db_reset_scope_type_id;
		geary_db_reset_scope_type_id = geary_db_reset_scope_get_type_once ();
		g_once_init_leave (&geary_db_reset_scope_type_id__once, geary_db_reset_scope_type_id);
	}
	return geary_db_reset_scope_type_id__once;
}

/**
 * See [[http://www.sqlite.org/c3ref/threadsafe.html]]
 */
gboolean
geary_db_threadsafe (void)
{
	gboolean result;
	result = sqlite3_threadsafe () != 0;
	return result;
}

/**
 * See [[http://www.sqlite.org/c3ref/libversion.html]]
 */
const gchar*
geary_db_sqlite_version (void)
{
	const gchar* _tmp0_;
	const gchar* result;
	_tmp0_ = sqlite3_libversion ();
	result = _tmp0_;
	return result;
}

/**
 * See [[http://www.sqlite.org/c3ref/libversion.html]]
 */
gint
geary_db_sqlite_version_number (void)
{
	gint result;
	result = sqlite3_libversion_number ();
	return result;
}

/**
 * See [[http://www.sqlite.org/c3ref/enable_shared_cache.html]]
 */
gboolean
geary_db_set_shared_cache_mode (gboolean enabled)
{
	gint _tmp0_ = 0;
	gboolean result;
	if (enabled) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	result = sqlite3_enable_shared_cache (_tmp0_) == SQLITE_OK;
	return result;
}

/** Standard transformation for case-insensitive string values. */
inline gchar*
geary_db_normalise_case_insensitive_query (const gchar* text)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = g_utf8_normalize (text, (gssize) -1, G_NORMALIZE_DEFAULT);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_utf8_casefold (_tmp1_, (gssize) -1);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

void
geary_db_check_cancelled (const gchar* method,
                          GCancellable* cancellable,
                          GError** error)
{
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	if (cancellable != NULL) {
		_tmp0_ = g_cancellable_is_cancelled (cancellable);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_;
		if (!geary_string_is_empty (method)) {
			_tmp1_ = method;
		} else {
			_tmp1_ = "Operation";
		}
		_tmp2_ = g_error_new (G_IO_ERROR, G_IO_ERROR_CANCELLED, "%s cancelled", _tmp1_);
		_inner_error0_ = _tmp2_;
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

gint
geary_db_throw_on_error (GearyDbContext* ctx,
                         const gchar* method,
                         gint _result_,
                         const gchar* raw,
                         GError** error)
{
	gchar* _tmp0_ = NULL;
	gchar* location = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	GearyDbDatabaseConnection* _tmp13_;
	GearyDbDatabaseConnection* _tmp14_;
	gboolean _tmp15_;
	gchar* errmsg = NULL;
	gchar* _tmp23_;
	gchar* sql = NULL;
	GearyDbStatement* statement = NULL;
	GearyDbStatement* _tmp24_;
	GearyDbStatement* _tmp25_;
	gchar* msg = NULL;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (GEARY_DB_IS_CONTEXT (ctx), 0);
	switch (_result_) {
		case SQLITE_OK:
		case SQLITE_DONE:
		case SQLITE_ROW:
		{
			result = _result_;
			return result;
		}
		default:
		break;
	}
	if (!geary_string_is_empty (method)) {
		GearyDbDatabase* _tmp1_;
		GearyDbDatabase* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = geary_db_context_get_database (ctx);
		_tmp2_ = _tmp1_;
		_tmp3_ = geary_db_database_get_path (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("(%s %s) ", method, _tmp4_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
		_g_object_unref0 (_tmp2_);
	} else {
		GearyDbDatabase* _tmp6_;
		GearyDbDatabase* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp6_ = geary_db_context_get_database (ctx);
		_tmp7_ = _tmp6_;
		_tmp8_ = geary_db_database_get_path (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup_printf ("(%s) ", _tmp9_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp10_;
		_g_object_unref0 (_tmp7_);
	}
	_tmp11_ = g_strdup (_tmp0_);
	location = _tmp11_;
	_tmp13_ = geary_db_context_get_connection (ctx);
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_ != NULL;
	_g_object_unref0 (_tmp14_);
	if (_tmp15_) {
		GearyDbDatabaseConnection* _tmp16_;
		GearyDbDatabaseConnection* _tmp17_;
		sqlite3* _tmp18_;
		sqlite3* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp16_ = geary_db_context_get_connection (ctx);
		_tmp17_ = _tmp16_;
		_tmp18_ = geary_db_connection_get_db (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEARY_DB_TYPE_CONNECTION, GearyDbConnection));
		_tmp19_ = _tmp18_;
		_tmp20_ = sqlite3_errmsg (_tmp19_);
		_tmp21_ = g_strdup_printf (" - %s", _tmp20_);
		_g_free0 (_tmp12_);
		_tmp12_ = _tmp21_;
		_g_object_unref0 (_tmp17_);
	} else {
		gchar* _tmp22_;
		_tmp22_ = g_strdup ("");
		_g_free0 (_tmp12_);
		_tmp12_ = _tmp22_;
	}
	_tmp23_ = g_strdup (_tmp12_);
	errmsg = _tmp23_;
	sql = NULL;
	_tmp24_ = geary_db_context_get_statement (ctx);
	statement = _tmp24_;
	_tmp25_ = statement;
	if (_tmp25_ != NULL) {
		GearyDbStatement* _tmp26_;
		gchar* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		_tmp26_ = statement;
		_tmp27_ = geary_db_statement_get_expanded_sql (_tmp26_);
		_g_free0 (sql);
		sql = _tmp27_;
		_tmp28_ = sql;
		if (_tmp28_ == NULL) {
			GearyDbStatement* _tmp29_;
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			gchar* _tmp32_;
			_tmp29_ = statement;
			_tmp30_ = geary_db_statement_get_sql (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = g_strdup (_tmp31_);
			_g_free0 (sql);
			sql = _tmp32_;
		}
		_tmp33_ = sql;
		_tmp34_ = g_strdup_printf (" (%s)", _tmp33_);
		_g_free0 (sql);
		sql = _tmp34_;
	} else {
		if (!geary_string_is_empty (raw)) {
			gchar* _tmp35_;
			_tmp35_ = g_strdup_printf (" (%s)", raw);
			_g_free0 (sql);
			sql = _tmp35_;
		} else {
			gchar* _tmp36_;
			_tmp36_ = g_strdup ("");
			_g_free0 (sql);
			sql = _tmp36_;
		}
	}
	_tmp37_ = location;
	_tmp38_ = errmsg;
	_tmp39_ = sql;
	_tmp40_ = g_strdup_printf ("%s[err=%d]%s%s", _tmp37_, _result_, _tmp38_, _tmp39_);
	msg = _tmp40_;
	switch (_result_) {
		case SQLITE_BUSY:
		case SQLITE_LOCKED:
		{
			const gchar* _tmp41_;
			GError* _tmp42_;
			_tmp41_ = msg;
			_tmp42_ = g_error_new_literal (GEARY_DATABASE_ERROR, GEARY_DATABASE_ERROR_BUSY, _tmp41_);
			_inner_error0_ = _tmp42_;
			if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
				gint _tmp43_ = -1;
				g_propagate_error (error, _inner_error0_);
				_g_free0 (msg);
				_g_object_unref0 (statement);
				_g_free0 (sql);
				_g_free0 (errmsg);
				_g_free0 (_tmp12_);
				_g_free0 (location);
				_g_free0 (_tmp0_);
				return _tmp43_;
			} else {
				gint _tmp44_ = -1;
				_g_free0 (msg);
				_g_object_unref0 (statement);
				_g_free0 (sql);
				_g_free0 (errmsg);
				_g_free0 (_tmp12_);
				_g_free0 (location);
				_g_free0 (_tmp0_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp44_;
			}
		}
		case SQLITE_IOERR:
		case SQLITE_PERM:
		case SQLITE_READONLY:
		case SQLITE_CANTOPEN:
		case SQLITE_NOLFS:
		case SQLITE_AUTH:
		{
			const gchar* _tmp45_;
			GError* _tmp46_;
			_tmp45_ = msg;
			_tmp46_ = g_error_new_literal (GEARY_DATABASE_ERROR, GEARY_DATABASE_ERROR_ACCESS, _tmp45_);
			_inner_error0_ = _tmp46_;
			if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
				gint _tmp47_ = -1;
				g_propagate_error (error, _inner_error0_);
				_g_free0 (msg);
				_g_object_unref0 (statement);
				_g_free0 (sql);
				_g_free0 (errmsg);
				_g_free0 (_tmp12_);
				_g_free0 (location);
				_g_free0 (_tmp0_);
				return _tmp47_;
			} else {
				gint _tmp48_ = -1;
				_g_free0 (msg);
				_g_object_unref0 (statement);
				_g_free0 (sql);
				_g_free0 (errmsg);
				_g_free0 (_tmp12_);
				_g_free0 (location);
				_g_free0 (_tmp0_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp48_;
			}
		}
		case SQLITE_CORRUPT:
		case SQLITE_FORMAT:
		case SQLITE_NOTADB:
		{
			const gchar* _tmp49_;
			GError* _tmp50_;
			_tmp49_ = msg;
			_tmp50_ = g_error_new_literal (GEARY_DATABASE_ERROR, GEARY_DATABASE_ERROR_CORRUPT, _tmp49_);
			_inner_error0_ = _tmp50_;
			if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
				gint _tmp51_ = -1;
				g_propagate_error (error, _inner_error0_);
				_g_free0 (msg);
				_g_object_unref0 (statement);
				_g_free0 (sql);
				_g_free0 (errmsg);
				_g_free0 (_tmp12_);
				_g_free0 (location);
				_g_free0 (_tmp0_);
				return _tmp51_;
			} else {
				gint _tmp52_ = -1;
				_g_free0 (msg);
				_g_object_unref0 (statement);
				_g_free0 (sql);
				_g_free0 (errmsg);
				_g_free0 (_tmp12_);
				_g_free0 (location);
				_g_free0 (_tmp0_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp52_;
			}
		}
		case SQLITE_NOMEM:
		{
			const gchar* _tmp53_;
			GError* _tmp54_;
			_tmp53_ = msg;
			_tmp54_ = g_error_new_literal (GEARY_DATABASE_ERROR, GEARY_DATABASE_ERROR_MEMORY, _tmp53_);
			_inner_error0_ = _tmp54_;
			if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
				gint _tmp55_ = -1;
				g_propagate_error (error, _inner_error0_);
				_g_free0 (msg);
				_g_object_unref0 (statement);
				_g_free0 (sql);
				_g_free0 (errmsg);
				_g_free0 (_tmp12_);
				_g_free0 (location);
				_g_free0 (_tmp0_);
				return _tmp55_;
			} else {
				gint _tmp56_ = -1;
				_g_free0 (msg);
				_g_object_unref0 (statement);
				_g_free0 (sql);
				_g_free0 (errmsg);
				_g_free0 (_tmp12_);
				_g_free0 (location);
				_g_free0 (_tmp0_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp56_;
			}
		}
		case SQLITE_ABORT:
		{
			const gchar* _tmp57_;
			GError* _tmp58_;
			_tmp57_ = msg;
			_tmp58_ = g_error_new_literal (GEARY_DATABASE_ERROR, GEARY_DATABASE_ERROR_ABORT, _tmp57_);
			_inner_error0_ = _tmp58_;
			if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
				gint _tmp59_ = -1;
				g_propagate_error (error, _inner_error0_);
				_g_free0 (msg);
				_g_object_unref0 (statement);
				_g_free0 (sql);
				_g_free0 (errmsg);
				_g_free0 (_tmp12_);
				_g_free0 (location);
				_g_free0 (_tmp0_);
				return _tmp59_;
			} else {
				gint _tmp60_ = -1;
				_g_free0 (msg);
				_g_object_unref0 (statement);
				_g_free0 (sql);
				_g_free0 (errmsg);
				_g_free0 (_tmp12_);
				_g_free0 (location);
				_g_free0 (_tmp0_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp60_;
			}
		}
		case SQLITE_INTERRUPT:
		{
			const gchar* _tmp61_;
			GError* _tmp62_;
			_tmp61_ = msg;
			_tmp62_ = g_error_new_literal (GEARY_DATABASE_ERROR, GEARY_DATABASE_ERROR_INTERRUPT, _tmp61_);
			_inner_error0_ = _tmp62_;
			if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
				gint _tmp63_ = -1;
				g_propagate_error (error, _inner_error0_);
				_g_free0 (msg);
				_g_object_unref0 (statement);
				_g_free0 (sql);
				_g_free0 (errmsg);
				_g_free0 (_tmp12_);
				_g_free0 (location);
				_g_free0 (_tmp0_);
				return _tmp63_;
			} else {
				gint _tmp64_ = -1;
				_g_free0 (msg);
				_g_object_unref0 (statement);
				_g_free0 (sql);
				_g_free0 (errmsg);
				_g_free0 (_tmp12_);
				_g_free0 (location);
				_g_free0 (_tmp0_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp64_;
			}
		}
		case SQLITE_FULL:
		case SQLITE_EMPTY:
		case SQLITE_TOOBIG:
		case SQLITE_CONSTRAINT:
		case SQLITE_RANGE:
		{
			const gchar* _tmp65_;
			GError* _tmp66_;
			_tmp65_ = msg;
			_tmp66_ = g_error_new_literal (GEARY_DATABASE_ERROR, GEARY_DATABASE_ERROR_LIMITS, _tmp65_);
			_inner_error0_ = _tmp66_;
			if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
				gint _tmp67_ = -1;
				g_propagate_error (error, _inner_error0_);
				_g_free0 (msg);
				_g_object_unref0 (statement);
				_g_free0 (sql);
				_g_free0 (errmsg);
				_g_free0 (_tmp12_);
				_g_free0 (location);
				_g_free0 (_tmp0_);
				return _tmp67_;
			} else {
				gint _tmp68_ = -1;
				_g_free0 (msg);
				_g_object_unref0 (statement);
				_g_free0 (sql);
				_g_free0 (errmsg);
				_g_free0 (_tmp12_);
				_g_free0 (location);
				_g_free0 (_tmp0_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp68_;
			}
		}
		case SQLITE_SCHEMA:
		case SQLITE_MISMATCH:
		{
			const gchar* _tmp69_;
			GError* _tmp70_;
			_tmp69_ = msg;
			_tmp70_ = g_error_new_literal (GEARY_DATABASE_ERROR, GEARY_DATABASE_ERROR_TYPESPEC, _tmp69_);
			_inner_error0_ = _tmp70_;
			if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
				gint _tmp71_ = -1;
				g_propagate_error (error, _inner_error0_);
				_g_free0 (msg);
				_g_object_unref0 (statement);
				_g_free0 (sql);
				_g_free0 (errmsg);
				_g_free0 (_tmp12_);
				_g_free0 (location);
				_g_free0 (_tmp0_);
				return _tmp71_;
			} else {
				gint _tmp72_ = -1;
				_g_free0 (msg);
				_g_object_unref0 (statement);
				_g_free0 (sql);
				_g_free0 (errmsg);
				_g_free0 (_tmp12_);
				_g_free0 (location);
				_g_free0 (_tmp0_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp72_;
			}
		}
		default:
		case SQLITE_ERROR:
		case SQLITE_INTERNAL:
		case SQLITE_MISUSE:
		{
			const gchar* _tmp73_;
			GError* _tmp74_;
			_tmp73_ = msg;
			_tmp74_ = g_error_new_literal (GEARY_DATABASE_ERROR, GEARY_DATABASE_ERROR_GENERAL, _tmp73_);
			_inner_error0_ = _tmp74_;
			if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
				gint _tmp75_ = -1;
				g_propagate_error (error, _inner_error0_);
				_g_free0 (msg);
				_g_object_unref0 (statement);
				_g_free0 (sql);
				_g_free0 (errmsg);
				_g_free0 (_tmp12_);
				_g_free0 (location);
				_g_free0 (_tmp0_);
				return _tmp75_;
			} else {
				gint _tmp76_ = -1;
				_g_free0 (msg);
				_g_object_unref0 (statement);
				_g_free0 (sql);
				_g_free0 (errmsg);
				_g_free0 (_tmp12_);
				_g_free0 (location);
				_g_free0 (_tmp0_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp76_;
			}
		}
	}
}

