/* imap-list-parameter.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from imap-list-parameter.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_IMAP_LIST_PARAMETER_0_PROPERTY,
	GEARY_IMAP_LIST_PARAMETER_SIZE_PROPERTY,
	GEARY_IMAP_LIST_PARAMETER_NUM_PROPERTIES
};
static GParamSpec* geary_imap_list_parameter_properties[GEARY_IMAP_LIST_PARAMETER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _GearyImapListParameterPrivate {
	GeeList* list;
};

static gint GearyImapListParameter_private_offset;
static gpointer geary_imap_list_parameter_parent_class = NULL;

static gchar* geary_imap_list_parameter_real_to_string (GearyImapParameter* base);
static void geary_imap_list_parameter_real_serialize (GearyImapParameter* base,
                                               GearyImapSerializer* ser,
                                               GCancellable* cancellable,
                                               GError** error);
static void geary_imap_list_parameter_finalize (GObject * obj);
static GType geary_imap_list_parameter_get_type_once (void);
static void _vala_geary_imap_list_parameter_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);

static inline gpointer
geary_imap_list_parameter_get_instance_private (GearyImapListParameter* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapListParameter_private_offset);
}

gint
geary_imap_list_parameter_get_size (GearyImapListParameter* self)
{
	gint result;
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (self), 0);
	_tmp0_ = self->priv->list;
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

/** Constructs a new, empty list. */
GearyImapListParameter*
geary_imap_list_parameter_construct (GType object_type)
{
	GearyImapListParameter * self = NULL;
	self = (GearyImapListParameter*) geary_imap_parameter_construct (object_type);
	return self;
}

GearyImapListParameter*
geary_imap_list_parameter_new (void)
{
	return geary_imap_list_parameter_construct (GEARY_IMAP_TYPE_LIST_PARAMETER);
}

/** Constructs a new list with a single parameter. */
GearyImapListParameter*
geary_imap_list_parameter_construct_single (GType object_type,
                                            GearyImapParameter* param)
{
	GearyImapListParameter * self = NULL;
	g_return_val_if_fail (GEARY_IMAP_IS_PARAMETER (param), NULL);
	self = (GearyImapListParameter*) geary_imap_parameter_construct (object_type);
	geary_imap_list_parameter_add (self, param);
	return self;
}

GearyImapListParameter*
geary_imap_list_parameter_new_single (GearyImapParameter* param)
{
	return geary_imap_list_parameter_construct_single (GEARY_IMAP_TYPE_LIST_PARAMETER, param);
}

/**
     * Appends a parameter to the end of this list.
     *
     * The same {@link Parameter} can't be added more than once to the
     * same {@link ListParameter}.  There are no other restrictions,
     * however.
     *
     * @return true if added.
     */
gboolean
geary_imap_list_parameter_add (GearyImapListParameter* self,
                               GearyImapParameter* param)
{
	GeeList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (self), FALSE);
	g_return_val_if_fail (GEARY_IMAP_IS_PARAMETER (param), FALSE);
	_tmp0_ = self->priv->list;
	result = gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), param);
	return result;
}

/**
     * Adds all parameters in the given collection to this list.
     *
     * The same {@link Parameter} can't be added more than once to the
     * same {@link ListParameter}.  There are no other restrictions,
     * however.
     *
     * @return number of Parameters added.
     */
gint
geary_imap_list_parameter_add_all (GearyImapListParameter* self,
                                   GeeCollection* params)
{
	gint count = 0;
	gint result;
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (self), 0);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (params, GEE_TYPE_COLLECTION), 0);
	count = 0;
	{
		GeeIterator* _param_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (params, GEE_TYPE_ITERABLE, GeeIterable));
		_param_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			GearyImapParameter* param = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			gint _tmp4_ = 0;
			GearyImapParameter* _tmp5_;
			_tmp1_ = _param_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _param_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			param = (GearyImapParameter*) _tmp3_;
			_tmp5_ = param;
			if (geary_imap_list_parameter_add (self, _tmp5_)) {
				_tmp4_ = 1;
			} else {
				_tmp4_ = 0;
			}
			count += _tmp4_;
			_g_object_unref0 (param);
		}
		_g_object_unref0 (_param_it);
	}
	result = count;
	return result;
}

/**
     * Adds all elements in the given list to the end of this list.
     *
     * The difference between this call and {@link add} is that add() will simply insert the
     * {@link Parameter} to the tail of the list.  Thus, add(ListParameter) will add a child list
     * inside this list, i.e. add(ListParameter("three")):
     *
     * (one two (three))
     *
     * Instead, extend(ListParameter("three")) adds each element of the ListParameter to this one, not
     * creating a child:
     *
     * (one two three)
     *
     * @return Number of added elements. This will not abort if an
     * element fails to be added.
     */
gint
geary_imap_list_parameter_extend (GearyImapListParameter* self,
                                  GearyImapListParameter* listp)
{
	GeeList* _tmp0_;
	gint result;
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (self), 0);
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (listp), 0);
	_tmp0_ = listp->priv->list;
	result = geary_imap_list_parameter_add_all (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	return result;
}

/**
     * Clears the {@link ListParameter} of all its children.
     */
void
geary_imap_list_parameter_clear (GearyImapListParameter* self)
{
	GeeList* _tmp0_;
	g_return_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (self));
	_tmp0_ = self->priv->list;
	gee_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
}

/**
     * Returns the {@link Parameter} at the index in the list, null if index is out of range.
     *
     * TODO: This call can cause memory leaks when used with the "as" operator until the following
     * Vala bug is fixed (probably in version 0.19.1).
     * [[https://bugzilla.gnome.org/show_bug.cgi?id=695671]]
     */
GearyImapParameter*
geary_imap_list_parameter_get (GearyImapListParameter* self,
                               gint index)
{
	GearyImapParameter* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GearyImapParameter* result;
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (self), NULL);
	if (index >= 0) {
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->list;
		_tmp3_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp4_ = _tmp3_;
		_tmp1_ = index < _tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GeeList* _tmp5_;
		gpointer _tmp6_;
		_tmp5_ = self->priv->list;
		_tmp6_ = gee_list_get (_tmp5_, index);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = (GearyImapParameter*) _tmp6_;
	} else {
		_g_object_unref0 (_tmp0_);
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

/**
     * Returns the Parameter at the index.  Throws an ImapError.TYPE_ERROR if the index is out of
     * range.
     *
     * TODO: This call can cause memory leaks when used with the "as" operator until the following
     * Vala bug is fixed (probably in version 0.19.1).
     * [[https://bugzilla.gnome.org/show_bug.cgi?id=695671]]
     */
GearyImapParameter*
geary_imap_list_parameter_get_required (GearyImapListParameter* self,
                                        gint index,
                                        GError** error)
{
	gboolean _tmp0_ = FALSE;
	GearyImapParameter* param = NULL;
	GeeList* _tmp5_;
	gpointer _tmp6_;
	GearyImapParameter* _tmp7_;
	GError* _inner_error0_ = NULL;
	GearyImapParameter* result;
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (self), NULL);
	if (index < 0) {
		_tmp0_ = TRUE;
	} else {
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->priv->list;
		_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp3_ = _tmp2_;
		_tmp0_ = index >= _tmp3_;
	}
	if (_tmp0_) {
		GError* _tmp4_;
		_tmp4_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_TYPE_ERROR, "No parameter at index %d", index);
		_inner_error0_ = _tmp4_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = self->priv->list;
	_tmp6_ = gee_list_get (_tmp5_, index);
	param = (GearyImapParameter*) _tmp6_;
	_tmp7_ = param;
	if (_tmp7_ == NULL) {
		GError* _tmp8_;
		_tmp8_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_TYPE_ERROR, "No parameter at index %d", index);
		_inner_error0_ = _tmp8_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (param);
			return NULL;
		} else {
			_g_object_unref0 (param);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = param;
	return result;
}

/**
     * Returns {@link Parameter} at index if in range and of Type type, otherwise throws an
     * {@link ImapError.TYPE_ERROR}.
     *
     * type must be of type Parameter.
     */
GearyImapParameter*
geary_imap_list_parameter_get_as (GearyImapListParameter* self,
                                  gint index,
                                  GType type,
                                  GError** error)
{
	GearyImapParameter* param = NULL;
	GearyImapParameter* _tmp1_;
	GearyImapParameter* _tmp2_;
	GError* _inner_error0_ = NULL;
	GearyImapParameter* result;
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (self), NULL);
	if (!g_type_is_a (type, GEARY_IMAP_TYPE_PARAMETER)) {
		GError* _tmp0_;
		_tmp0_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_TYPE_ERROR, "Attempting to cast non-Parameter at index %d", index);
		_inner_error0_ = _tmp0_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = geary_imap_list_parameter_get_required (self, index, &_inner_error0_);
	param = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = param;
	if (!g_type_is_a (G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, G_TYPE_OBJECT, GObject)), type)) {
		const gchar* _tmp3_;
		GearyImapParameter* _tmp4_;
		const gchar* _tmp5_;
		GError* _tmp6_;
		_tmp3_ = g_type_name (type);
		_tmp4_ = param;
		_tmp5_ = g_type_name (G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, G_TYPE_OBJECT, GObject)));
		_tmp6_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_TYPE_ERROR, "Parameter %d is not of type %s (is %s)", index, _tmp3_, _tmp5_);
		_inner_error0_ = _tmp6_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (param);
			return NULL;
		} else {
			_g_object_unref0 (param);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = param;
	return result;
}

/**
     * Like {@link get_as}, but returns null if the {@link Parameter} at index is a
     * {@link NilParameter}.
     *
     * type must be of type Parameter.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GearyImapParameter*
geary_imap_list_parameter_get_as_nullable (GearyImapListParameter* self,
                                           gint index,
                                           GType type,
                                           GError** error)
{
	GearyImapParameter* param = NULL;
	GearyImapParameter* _tmp1_;
	GearyImapParameter* _tmp2_;
	GearyImapStringParameter* stringp = NULL;
	GearyImapParameter* _tmp3_;
	GearyImapStringParameter* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GearyImapStringParameter* _tmp6_;
	GearyImapParameter* _tmp8_;
	GError* _inner_error0_ = NULL;
	GearyImapParameter* result;
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (self), NULL);
	if (!g_type_is_a (type, GEARY_IMAP_TYPE_PARAMETER)) {
		GError* _tmp0_;
		_tmp0_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_TYPE_ERROR, "Attempting to cast non-Parameter at index %d", index);
		_inner_error0_ = _tmp0_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = geary_imap_list_parameter_get_required (self, index, &_inner_error0_);
	param = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = param;
	if (GEARY_IMAP_IS_NIL_PARAMETER (_tmp2_)) {
		result = NULL;
		_g_object_unref0 (param);
		return result;
	}
	_tmp3_ = param;
	_tmp4_ = _g_object_ref0 (GEARY_IMAP_IS_STRING_PARAMETER (_tmp3_) ? ((GearyImapStringParameter*) _tmp3_) : NULL);
	stringp = _tmp4_;
	_tmp6_ = stringp;
	if (_tmp6_ != NULL) {
		GearyImapStringParameter* _tmp7_;
		_tmp7_ = stringp;
		_tmp5_ = geary_imap_nil_parameter_is_nil (_tmp7_);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		result = NULL;
		_g_object_unref0 (stringp);
		_g_object_unref0 (param);
		return result;
	}
	_tmp8_ = param;
	if (!g_type_is_a (G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, G_TYPE_OBJECT, GObject)), type)) {
		const gchar* _tmp9_;
		GearyImapParameter* _tmp10_;
		const gchar* _tmp11_;
		GError* _tmp12_;
		_tmp9_ = g_type_name (type);
		_tmp10_ = param;
		_tmp11_ = g_type_name (G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, G_TYPE_OBJECT, GObject)));
		_tmp12_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_TYPE_ERROR, "Parameter %d is not of type %s (is %s)", index, _tmp9_, _tmp11_);
		_inner_error0_ = _tmp12_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (stringp);
			_g_object_unref0 (param);
			return NULL;
		} else {
			_g_object_unref0 (stringp);
			_g_object_unref0 (param);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = param;
	_g_object_unref0 (stringp);
	return result;
}

/**
     * Like {@link get}, but returns null if {@link Parameter} at index is not of the specified type.
     *
     * type must be of type Parameter.
     */
GearyImapParameter*
geary_imap_list_parameter_get_if (GearyImapListParameter* self,
                                  gint index,
                                  GType type)
{
	GearyImapParameter* param = NULL;
	GearyImapParameter* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GearyImapParameter* _tmp2_;
	GearyImapParameter* result;
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (self), NULL);
	if (!g_type_is_a (type, GEARY_IMAP_TYPE_PARAMETER)) {
		result = NULL;
		return result;
	}
	_tmp0_ = geary_imap_list_parameter_get (self, index);
	param = _tmp0_;
	_tmp2_ = param;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		GearyImapParameter* _tmp3_;
		_tmp3_ = param;
		_tmp1_ = !g_type_is_a (G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, G_TYPE_OBJECT, GObject)), type);
	}
	if (_tmp1_) {
		result = NULL;
		_g_object_unref0 (param);
		return result;
	}
	result = param;
	return result;
}

/**
     * Returns a {@link StringParameter} only if the {@link Parameter} at index is a StringParameter.
     *
     * Compare to {@link get_as_nullable_string}.
     */
GearyImapStringParameter*
geary_imap_list_parameter_get_if_string (GearyImapListParameter* self,
                                         gint index)
{
	GearyImapParameter* _tmp0_;
	GearyImapStringParameter* result;
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (self), NULL);
	_tmp0_ = geary_imap_list_parameter_get_if (self, index, GEARY_IMAP_TYPE_STRING_PARAMETER);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_IMAP_TYPE_STRING_PARAMETER, GearyImapStringParameter);
	return result;
}

/**
     * Returns a {@link StringParameter} for the value at the index only if the {@link Parameter}
     * is a StringParameter or a {@link LiteralParameter} with a length less than or equal to
     * {@link MAX_STRING_LITERAL_LENGTH}.
     *
     * Because literal data is being coerced into a StringParameter, the result may not be suitable
     * for transmission as-is.
     *
     * @see get_as_nullable_string
     * @throws ImapError.TYPE_ERROR if no StringParameter at index or the literal is longer than
     * MAX_STRING_LITERAL_LENGTH.
     */
GearyImapStringParameter*
geary_imap_list_parameter_get_as_string (GearyImapListParameter* self,
                                         gint index,
                                         GError** error)
{
	GearyImapParameter* param = NULL;
	GearyImapParameter* _tmp0_;
	GearyImapStringParameter* stringp = NULL;
	GearyImapParameter* _tmp1_;
	GearyImapStringParameter* _tmp2_;
	GearyImapStringParameter* _tmp3_;
	GearyImapLiteralParameter* literalp = NULL;
	GearyImapParameter* _tmp4_;
	GearyImapLiteralParameter* _tmp5_;
	gboolean _tmp6_ = FALSE;
	GearyImapLiteralParameter* _tmp7_;
	GearyImapParameter* _tmp15_;
	const gchar* _tmp16_;
	GError* _tmp17_;
	GError* _inner_error0_ = NULL;
	GearyImapStringParameter* result;
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (self), NULL);
	_tmp0_ = geary_imap_list_parameter_get_required (self, index, &_inner_error0_);
	param = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = param;
	_tmp2_ = _g_object_ref0 (GEARY_IMAP_IS_STRING_PARAMETER (_tmp1_) ? ((GearyImapStringParameter*) _tmp1_) : NULL);
	stringp = _tmp2_;
	_tmp3_ = stringp;
	if (_tmp3_ != NULL) {
		result = stringp;
		_g_object_unref0 (param);
		return result;
	}
	_tmp4_ = param;
	_tmp5_ = _g_object_ref0 (GEARY_IMAP_IS_LITERAL_PARAMETER (_tmp4_) ? ((GearyImapLiteralParameter*) _tmp4_) : NULL);
	literalp = _tmp5_;
	_tmp7_ = literalp;
	if (_tmp7_ != NULL) {
		GearyImapLiteralParameter* _tmp8_;
		GearyMemoryBuffer* _tmp9_;
		GearyMemoryBuffer* _tmp10_;
		gsize _tmp11_;
		gsize _tmp12_;
		_tmp8_ = literalp;
		_tmp9_ = geary_imap_literal_parameter_get_value (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = geary_memory_buffer_get_size (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp6_ = _tmp12_ <= ((gsize) GEARY_IMAP_LIST_PARAMETER_MAX_STRING_LITERAL_LENGTH);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		GearyImapLiteralParameter* _tmp13_;
		GearyImapStringParameter* _tmp14_;
		_tmp13_ = literalp;
		_tmp14_ = geary_imap_literal_parameter_coerce_to_string_parameter (_tmp13_);
		result = _tmp14_;
		_g_object_unref0 (literalp);
		_g_object_unref0 (stringp);
		_g_object_unref0 (param);
		return result;
	}
	_tmp15_ = param;
	_tmp16_ = g_type_name (G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, G_TYPE_OBJECT, GObject)));
	_tmp17_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_TYPE_ERROR, "Parameter %d not of type string or literal (is %s)", index, _tmp16_);
	_inner_error0_ = _tmp17_;
	if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (literalp);
		_g_object_unref0 (stringp);
		_g_object_unref0 (param);
		return NULL;
	} else {
		_g_object_unref0 (literalp);
		_g_object_unref0 (stringp);
		_g_object_unref0 (param);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

/**
     * Returns a {@link StringParameter} for the value at the index only if the {@link Parameter}
     * is a StringParameter or a {@link LiteralParameter} with a length less than or equal to
     * {@link MAX_STRING_LITERAL_LENGTH}.
     *
     * Because literal data is being coerced into a StringParameter, the result may not be suitable
     * for transmission as-is.
     *
     * @return null if no StringParameter or LiteralParameter at index.
     * @see get_as_string
     * @throws ImapError.TYPE_ERROR if literal is longer than MAX_STRING_LITERAL_LENGTH.
     */
GearyImapStringParameter*
geary_imap_list_parameter_get_as_nullable_string (GearyImapListParameter* self,
                                                  gint index,
                                                  GError** error)
{
	GearyImapParameter* param = NULL;
	GearyImapParameter* _tmp0_;
	GearyImapParameter* _tmp1_;
	GearyImapStringParameter* stringp = NULL;
	GearyImapParameter* _tmp2_;
	GearyImapStringParameter* _tmp3_;
	GearyImapStringParameter* _tmp4_;
	GearyImapLiteralParameter* literalp = NULL;
	GearyImapParameter* _tmp5_;
	GearyImapLiteralParameter* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GearyImapLiteralParameter* _tmp8_;
	GearyImapParameter* _tmp16_;
	const gchar* _tmp17_;
	GError* _tmp18_;
	GError* _inner_error0_ = NULL;
	GearyImapStringParameter* result;
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (self), NULL);
	_tmp0_ = geary_imap_list_parameter_get_as_nullable (self, index, GEARY_IMAP_TYPE_PARAMETER, &_inner_error0_);
	param = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = param;
	if (_tmp1_ == NULL) {
		result = NULL;
		_g_object_unref0 (param);
		return result;
	}
	_tmp2_ = param;
	_tmp3_ = _g_object_ref0 (GEARY_IMAP_IS_STRING_PARAMETER (_tmp2_) ? ((GearyImapStringParameter*) _tmp2_) : NULL);
	stringp = _tmp3_;
	_tmp4_ = stringp;
	if (_tmp4_ != NULL) {
		result = stringp;
		_g_object_unref0 (param);
		return result;
	}
	_tmp5_ = param;
	_tmp6_ = _g_object_ref0 (GEARY_IMAP_IS_LITERAL_PARAMETER (_tmp5_) ? ((GearyImapLiteralParameter*) _tmp5_) : NULL);
	literalp = _tmp6_;
	_tmp8_ = literalp;
	if (_tmp8_ != NULL) {
		GearyImapLiteralParameter* _tmp9_;
		GearyMemoryBuffer* _tmp10_;
		GearyMemoryBuffer* _tmp11_;
		gsize _tmp12_;
		gsize _tmp13_;
		_tmp9_ = literalp;
		_tmp10_ = geary_imap_literal_parameter_get_value (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = geary_memory_buffer_get_size (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp7_ = _tmp13_ <= ((gsize) GEARY_IMAP_LIST_PARAMETER_MAX_STRING_LITERAL_LENGTH);
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		GearyImapLiteralParameter* _tmp14_;
		GearyImapStringParameter* _tmp15_;
		_tmp14_ = literalp;
		_tmp15_ = geary_imap_literal_parameter_coerce_to_string_parameter (_tmp14_);
		result = _tmp15_;
		_g_object_unref0 (literalp);
		_g_object_unref0 (stringp);
		_g_object_unref0 (param);
		return result;
	}
	_tmp16_ = param;
	_tmp17_ = g_type_name (G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, G_TYPE_OBJECT, GObject)));
	_tmp18_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_TYPE_ERROR, "Parameter %d not of type string or literal (is %s)", index, _tmp17_);
	_inner_error0_ = _tmp18_;
	if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (literalp);
		_g_object_unref0 (stringp);
		_g_object_unref0 (param);
		return NULL;
	} else {
		_g_object_unref0 (literalp);
		_g_object_unref0 (stringp);
		_g_object_unref0 (param);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

/**
     * Much like get_as_nullable_string() but returns an empty StringParameter (rather than null)
     * if the parameter at index is a NilParameter.
     */
GearyImapStringParameter*
geary_imap_list_parameter_get_as_empty_string (GearyImapListParameter* self,
                                               gint index,
                                               GError** error)
{
	GearyImapStringParameter* stringp = NULL;
	GearyImapStringParameter* _tmp0_;
	GearyImapStringParameter* _tmp1_ = NULL;
	GearyImapStringParameter* _tmp2_;
	GearyImapStringParameter* _tmp3_;
	GearyImapStringParameter* _tmp5_;
	GError* _inner_error0_ = NULL;
	GearyImapStringParameter* result;
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (self), NULL);
	_tmp0_ = geary_imap_list_parameter_get_as_nullable_string (self, index, &_inner_error0_);
	stringp = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = stringp;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_tmp1_ = _tmp3_;
	if (_tmp1_ == NULL) {
		GearyImapStringParameter* _tmp4_;
		_tmp4_ = geary_imap_string_parameter_get_best_for ("", &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (_tmp1_);
				_g_object_unref0 (stringp);
				return NULL;
			} else {
				_g_object_unref0 (_tmp1_);
				_g_object_unref0 (stringp);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	_tmp5_ = _tmp1_;
	_tmp1_ = NULL;
	result = _tmp5_;
	_g_object_unref0 (_tmp1_);
	_g_object_unref0 (stringp);
	return result;
}

/**
     * Returns a {@link NumberParameter} at index, null if not of that type.
     *
     * @see get_if
     */
GearyImapNumberParameter*
geary_imap_list_parameter_get_if_number (GearyImapListParameter* self,
                                         gint index)
{
	GearyImapParameter* _tmp0_;
	GearyImapNumberParameter* result;
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (self), NULL);
	_tmp0_ = geary_imap_list_parameter_get_if (self, index, GEARY_IMAP_TYPE_NUMBER_PARAMETER);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_IMAP_TYPE_NUMBER_PARAMETER, GearyImapNumberParameter);
	return result;
}

/**
     * Returns a {@link NumberParameter} at index.
     *
     * Like {@link get_as_string}, this method will attempt some coercion.  In this case,
     * {@link QuotedStringParameter} and {@link UnquotedStringParameter}s will be converted to
     * NumberParameter, if appropriate.
     */
GearyImapNumberParameter*
geary_imap_list_parameter_get_as_number (GearyImapListParameter* self,
                                         gint index,
                                         GError** error)
{
	GearyImapParameter* param = NULL;
	GearyImapParameter* _tmp0_;
	GearyImapNumberParameter* numberp = NULL;
	GearyImapParameter* _tmp1_;
	GearyImapNumberParameter* _tmp2_;
	GearyImapNumberParameter* _tmp3_;
	GearyImapStringParameter* stringp = NULL;
	GearyImapParameter* _tmp4_;
	GearyImapStringParameter* _tmp5_;
	GearyImapStringParameter* _tmp6_;
	GearyImapParameter* _tmp10_;
	const gchar* _tmp11_;
	GError* _tmp12_;
	GError* _inner_error0_ = NULL;
	GearyImapNumberParameter* result;
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (self), NULL);
	_tmp0_ = geary_imap_list_parameter_get_required (self, index, &_inner_error0_);
	param = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = param;
	_tmp2_ = _g_object_ref0 (GEARY_IMAP_IS_NUMBER_PARAMETER (_tmp1_) ? ((GearyImapNumberParameter*) _tmp1_) : NULL);
	numberp = _tmp2_;
	_tmp3_ = numberp;
	if (_tmp3_ != NULL) {
		result = numberp;
		_g_object_unref0 (param);
		return result;
	}
	_tmp4_ = param;
	_tmp5_ = _g_object_ref0 (GEARY_IMAP_IS_STRING_PARAMETER (_tmp4_) ? ((GearyImapStringParameter*) _tmp4_) : NULL);
	stringp = _tmp5_;
	_tmp6_ = stringp;
	if (_tmp6_ != NULL) {
		GearyImapStringParameter* _tmp7_;
		GearyImapNumberParameter* _tmp8_;
		GearyImapNumberParameter* _tmp9_;
		_tmp7_ = stringp;
		_tmp8_ = geary_imap_string_parameter_coerce_to_number_parameter (_tmp7_);
		_g_object_unref0 (numberp);
		numberp = _tmp8_;
		_tmp9_ = numberp;
		if (_tmp9_ != NULL) {
			result = numberp;
			_g_object_unref0 (stringp);
			_g_object_unref0 (param);
			return result;
		}
	}
	_tmp10_ = param;
	_tmp11_ = g_type_name (G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, G_TYPE_OBJECT, GObject)));
	_tmp12_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_TYPE_ERROR, "Parameter %d not of type number or string (is %s)", index, _tmp11_);
	_inner_error0_ = _tmp12_;
	if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stringp);
		_g_object_unref0 (numberp);
		_g_object_unref0 (param);
		return NULL;
	} else {
		_g_object_unref0 (stringp);
		_g_object_unref0 (numberp);
		_g_object_unref0 (param);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

/**
     * Returns a {@link ListParameter} at index.
     *
     * @see get_as
     */
GearyImapListParameter*
geary_imap_list_parameter_get_as_list (GearyImapListParameter* self,
                                       gint index,
                                       GError** error)
{
	GearyImapParameter* _tmp0_ = NULL;
	GearyImapParameter* _tmp1_;
	GearyImapListParameter* _tmp2_;
	GError* _inner_error0_ = NULL;
	GearyImapListParameter* result;
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (self), NULL);
	_tmp1_ = geary_imap_list_parameter_get_as (self, index, GEARY_IMAP_TYPE_LIST_PARAMETER, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter));
	result = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return result;
}

/**
     * Returns a {@link ListParameter} at index, null if NIL.
     *
     * @see get_as_nullable
     */
GearyImapListParameter*
geary_imap_list_parameter_get_as_nullable_list (GearyImapListParameter* self,
                                                gint index,
                                                GError** error)
{
	GearyImapParameter* _tmp0_ = NULL;
	GearyImapParameter* _tmp1_;
	GearyImapListParameter* _tmp2_;
	GError* _inner_error0_ = NULL;
	GearyImapListParameter* result;
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (self), NULL);
	_tmp1_ = geary_imap_list_parameter_get_as_nullable (self, index, GEARY_IMAP_TYPE_LIST_PARAMETER, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter));
	result = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return result;
}

/**
     * Returns {@link ListParameter} at index, an empty list if NIL.
     */
GearyImapListParameter*
geary_imap_list_parameter_get_as_empty_list (GearyImapListParameter* self,
                                             gint index,
                                             GError** error)
{
	GearyImapListParameter* param = NULL;
	GearyImapListParameter* _tmp0_;
	GearyImapListParameter* _tmp1_ = NULL;
	GearyImapListParameter* _tmp2_;
	GearyImapListParameter* _tmp4_;
	GError* _inner_error0_ = NULL;
	GearyImapListParameter* result;
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (self), NULL);
	_tmp0_ = geary_imap_list_parameter_get_as_nullable_list (self, index, &_inner_error0_);
	param = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = _g_object_ref0 (param);
	_tmp1_ = _tmp2_;
	if (_tmp1_ == NULL) {
		GearyImapListParameter* _tmp3_;
		_tmp3_ = geary_imap_list_parameter_new ();
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp3_;
	}
	_tmp4_ = _tmp1_;
	_tmp1_ = NULL;
	result = _tmp4_;
	_g_object_unref0 (_tmp1_);
	_g_object_unref0 (param);
	return result;
}

/**
     * Returns a {@link ListParameter} at index, null if not a list.
     *
     * @see get_if
     */
GearyImapListParameter*
geary_imap_list_parameter_get_if_list (GearyImapListParameter* self,
                                       gint index)
{
	GearyImapParameter* _tmp0_;
	GearyImapListParameter* result;
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (self), NULL);
	_tmp0_ = geary_imap_list_parameter_get_if (self, index, GEARY_IMAP_TYPE_LIST_PARAMETER);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter);
	return result;
}

/**
     * Returns a {@link LiteralParameter} at index.
     *
     * @see get_as
     */
GearyImapLiteralParameter*
geary_imap_list_parameter_get_as_literal (GearyImapListParameter* self,
                                          gint index,
                                          GError** error)
{
	GearyImapParameter* _tmp0_ = NULL;
	GearyImapParameter* _tmp1_;
	GearyImapLiteralParameter* _tmp2_;
	GError* _inner_error0_ = NULL;
	GearyImapLiteralParameter* result;
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (self), NULL);
	_tmp1_ = geary_imap_list_parameter_get_as (self, index, GEARY_IMAP_TYPE_LITERAL_PARAMETER, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_IMAP_TYPE_LITERAL_PARAMETER, GearyImapLiteralParameter));
	result = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return result;
}

/**
     * Returns a {@link LiteralParameter} at index, null if NIL.
     *
     * @see get_as_nullable
     */
GearyImapLiteralParameter*
geary_imap_list_parameter_get_as_nullable_literal (GearyImapListParameter* self,
                                                   gint index,
                                                   GError** error)
{
	GearyImapParameter* _tmp0_ = NULL;
	GearyImapParameter* _tmp1_;
	GearyImapLiteralParameter* _tmp2_;
	GError* _inner_error0_ = NULL;
	GearyImapLiteralParameter* result;
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (self), NULL);
	_tmp1_ = geary_imap_list_parameter_get_as_nullable (self, index, GEARY_IMAP_TYPE_LITERAL_PARAMETER, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_IMAP_TYPE_LITERAL_PARAMETER, GearyImapLiteralParameter));
	result = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return result;
}

/**
     * Returns a {@link LiteralParameter} at index, null if not a list.
     *
     * @see get_if
     */
GearyImapLiteralParameter*
geary_imap_list_parameter_get_if_literal (GearyImapListParameter* self,
                                          gint index)
{
	GearyImapParameter* _tmp0_;
	GearyImapLiteralParameter* result;
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (self), NULL);
	_tmp0_ = geary_imap_list_parameter_get_if (self, index, GEARY_IMAP_TYPE_LITERAL_PARAMETER);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_IMAP_TYPE_LITERAL_PARAMETER, GearyImapLiteralParameter);
	return result;
}

/**
     * Returns [@link LiteralParameter} at index, an empty list if NIL.
     */
GearyImapLiteralParameter*
geary_imap_list_parameter_get_as_empty_literal (GearyImapListParameter* self,
                                                gint index,
                                                GError** error)
{
	GearyImapLiteralParameter* param = NULL;
	GearyImapLiteralParameter* _tmp0_;
	GearyImapLiteralParameter* _tmp1_ = NULL;
	GearyImapLiteralParameter* _tmp2_;
	GearyImapLiteralParameter* _tmp6_;
	GError* _inner_error0_ = NULL;
	GearyImapLiteralParameter* result;
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (self), NULL);
	_tmp0_ = geary_imap_list_parameter_get_as_nullable_literal (self, index, &_inner_error0_);
	param = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = _g_object_ref0 (param);
	_tmp1_ = _tmp2_;
	if (_tmp1_ == NULL) {
		GearyMemoryEmptyBuffer* _tmp3_;
		GearyMemoryEmptyBuffer* _tmp4_;
		GearyImapLiteralParameter* _tmp5_;
		_tmp3_ = geary_memory_empty_buffer_get_instance ();
		_tmp4_ = _tmp3_;
		_tmp5_ = geary_imap_literal_parameter_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer));
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp5_;
	}
	_tmp6_ = _tmp1_;
	_tmp1_ = NULL;
	result = _tmp6_;
	_g_object_unref0 (_tmp1_);
	_g_object_unref0 (param);
	return result;
}

/**
     * Returns a {@link Memory.Buffer} for the {@link Parameter} at position index.
     *
     * Only converts {@link StringParameter} and {@link LiteralParameter}.  All other types return
     * null.
     */
GearyMemoryBuffer*
geary_imap_list_parameter_get_as_nullable_buffer (GearyImapListParameter* self,
                                                  gint index,
                                                  GError** error)
{
	GearyImapLiteralParameter* literalp = NULL;
	GearyImapLiteralParameter* _tmp0_;
	GearyImapLiteralParameter* _tmp1_;
	GearyImapStringParameter* stringp = NULL;
	GearyImapStringParameter* _tmp6_;
	GearyImapStringParameter* _tmp7_;
	GearyMemoryBuffer* result;
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (self), NULL);
	_tmp0_ = geary_imap_list_parameter_get_if_literal (self, index);
	literalp = _tmp0_;
	_tmp1_ = literalp;
	if (_tmp1_ != NULL) {
		GearyImapLiteralParameter* _tmp2_;
		GearyMemoryBuffer* _tmp3_;
		GearyMemoryBuffer* _tmp4_;
		GearyMemoryBuffer* _tmp5_;
		_tmp2_ = literalp;
		_tmp3_ = geary_imap_literal_parameter_get_value (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		result = _tmp5_;
		_g_object_unref0 (literalp);
		return result;
	}
	_tmp6_ = geary_imap_list_parameter_get_if_string (self, index);
	stringp = _tmp6_;
	_tmp7_ = stringp;
	if (_tmp7_ != NULL) {
		GearyImapStringParameter* _tmp8_;
		GearyMemoryBuffer* _tmp9_;
		_tmp8_ = stringp;
		_tmp9_ = geary_imap_string_parameter_as_buffer (_tmp8_);
		result = _tmp9_;
		_g_object_unref0 (stringp);
		_g_object_unref0 (literalp);
		return result;
	}
	result = NULL;
	_g_object_unref0 (stringp);
	_g_object_unref0 (literalp);
	return result;
}

/**
     * Returns a {@link Memory.Buffer} for the {@link Parameter} at position index.
     *
     * Only converts {@link StringParameter} and {@link LiteralParameter}.  All other types return
     * as an empty buffer.
     */
GearyMemoryBuffer*
geary_imap_list_parameter_get_as_empty_buffer (GearyImapListParameter* self,
                                               gint index,
                                               GError** error)
{
	GearyMemoryBuffer* _tmp0_ = NULL;
	GearyMemoryBuffer* _tmp1_;
	GearyMemoryBuffer* _tmp2_ = NULL;
	GearyMemoryBuffer* _tmp3_;
	GearyMemoryBuffer* _tmp7_;
	GError* _inner_error0_ = NULL;
	GearyMemoryBuffer* result;
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (self), NULL);
	_tmp1_ = geary_imap_list_parameter_get_as_nullable_buffer (self, index, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	_tmp2_ = _tmp3_;
	if (_tmp2_ == NULL) {
		GearyMemoryEmptyBuffer* _tmp4_;
		GearyMemoryEmptyBuffer* _tmp5_;
		GearyMemoryBuffer* _tmp6_;
		_tmp4_ = geary_memory_empty_buffer_get_instance ();
		_tmp5_ = _tmp4_;
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer));
		_g_object_unref0 (_tmp2_);
		_tmp2_ = _tmp6_;
	}
	_tmp7_ = _tmp2_;
	_tmp2_ = NULL;
	result = _tmp7_;
	_g_object_unref0 (_tmp2_);
	_g_object_unref0 (_tmp0_);
	return result;
}

/**
     * Returns a read-only List of {@link Parameter}s.
     */
GeeList*
geary_imap_list_parameter_get_all (GearyImapListParameter* self)
{
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GeeList* result;
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (self), NULL);
	_tmp0_ = self->priv->list;
	_tmp1_ = gee_list_get_read_only_view (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

/**
     * Returns the replaced Parameter.  Throws ImapError.TYPE_ERROR if no Parameter exists at the
     * index.
     */
GearyImapParameter*
geary_imap_list_parameter_replace (GearyImapListParameter* self,
                                   gint index,
                                   GearyImapParameter* parameter,
                                   GError** error)
{
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GearyImapParameter* old = NULL;
	GeeList* _tmp4_;
	gpointer _tmp5_;
	GeeList* _tmp6_;
	GError* _inner_error0_ = NULL;
	GearyImapParameter* result;
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (self), NULL);
	g_return_val_if_fail (GEARY_IMAP_IS_PARAMETER (parameter), NULL);
	_tmp0_ = self->priv->list;
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	if (_tmp2_ <= index) {
		GError* _tmp3_;
		_tmp3_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_TYPE_ERROR, "No parameter at index %d", index);
		_inner_error0_ = _tmp3_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp4_ = self->priv->list;
	_tmp5_ = gee_list_get (_tmp4_, index);
	old = (GearyImapParameter*) _tmp5_;
	_tmp6_ = self->priv->list;
	gee_list_set (_tmp6_, index, parameter);
	result = old;
	return result;
}

/**
     * Moves all child parameters from the supplied list into this list, clearing this list first.
     *
     * The supplied list will be "stripped" of its children.  This ListParameter is cleared prior
     * to adopting the new children.
     */
void
geary_imap_list_parameter_adopt_children (GearyImapListParameter* self,
                                          GearyImapListParameter* src)
{
	GeeList* src_children = NULL;
	GeeArrayList* _tmp0_;
	GeeList* _tmp1_;
	g_return_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (self));
	g_return_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (src));
	geary_imap_list_parameter_clear (self);
	_tmp0_ = gee_array_list_new (GEARY_IMAP_TYPE_PARAMETER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	src_children = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
	_tmp1_ = src->priv->list;
	gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (src_children, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
	geary_imap_list_parameter_clear (src);
	geary_imap_list_parameter_add_all (self, G_TYPE_CHECK_INSTANCE_CAST (src_children, GEE_TYPE_COLLECTION, GeeCollection));
	_g_object_unref0 (src_children);
}

gchar*
geary_imap_list_parameter_stringize_list (GearyImapListParameter* self)
{
	GString* builder = NULL;
	GString* _tmp0_;
	gint length = 0;
	GeeList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GString* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* result;
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (self), NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = self->priv->list;
	_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp3_ = _tmp2_;
	length = _tmp3_;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				GString* _tmp6_;
				GeeList* _tmp7_;
				gpointer _tmp8_;
				GearyImapParameter* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = ctr;
					ctr = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (!(ctr < length)) {
					break;
				}
				_tmp6_ = builder;
				_tmp7_ = self->priv->list;
				_tmp8_ = gee_list_get (_tmp7_, ctr);
				_tmp9_ = (GearyImapParameter*) _tmp8_;
				_tmp10_ = geary_imap_parameter_to_string (_tmp9_);
				_tmp11_ = _tmp10_;
				g_string_append (_tmp6_, _tmp11_);
				_g_free0 (_tmp11_);
				_g_object_unref0 (_tmp9_);
				if (ctr < (length - 1)) {
					GString* _tmp12_;
					_tmp12_ = builder;
					g_string_append_c (_tmp12_, ' ');
				}
			}
		}
	}
	_tmp13_ = builder;
	_tmp14_ = _tmp13_->str;
	_tmp15_ = g_strdup (_tmp14_);
	result = _tmp15_;
	_g_string_free0 (builder);
	return result;
}

/**
     * {@inheritDoc}
     */
static gchar*
geary_imap_list_parameter_real_to_string (GearyImapParameter* base)
{
	GearyImapListParameter * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter);
	_tmp0_ = geary_imap_list_parameter_stringize_list (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("(%s)", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

/**
     * {@inheritDoc}
     */
static void
geary_imap_list_parameter_real_serialize (GearyImapParameter* base,
                                          GearyImapSerializer* ser,
                                          GCancellable* cancellable,
                                          GError** error)
{
	GearyImapListParameter * self;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter);
	g_return_if_fail (GEARY_IMAP_IS_SERIALIZER (ser));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	geary_imap_serializer_push_ascii (ser, '(', cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	geary_imap_list_parameter_serialize_list (self, ser, cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	geary_imap_serializer_push_ascii (ser, ')', cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

void
geary_imap_list_parameter_serialize_list (GearyImapListParameter* self,
                                          GearyImapSerializer* ser,
                                          GCancellable* cancellable,
                                          GError** error)
{
	gint length = 0;
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (self));
	g_return_if_fail (GEARY_IMAP_IS_SERIALIZER (ser));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_tmp0_ = self->priv->list;
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	length = _tmp2_;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GeeList* _tmp5_;
				gpointer _tmp6_;
				GearyImapParameter* _tmp7_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = ctr;
					ctr = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (!(ctr < length)) {
					break;
				}
				_tmp5_ = self->priv->list;
				_tmp6_ = gee_list_get (_tmp5_, ctr);
				_tmp7_ = (GearyImapParameter*) _tmp6_;
				geary_imap_parameter_serialize (_tmp7_, ser, cancellable, &_inner_error0_);
				_g_object_unref0 (_tmp7_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					return;
				}
				if (ctr < (length - 1)) {
					geary_imap_serializer_push_space (ser, cancellable, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						return;
					}
				}
			}
		}
	}
}

static void
geary_imap_list_parameter_class_init (GearyImapListParameterClass * klass,
                                      gpointer klass_data)
{
	geary_imap_list_parameter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapListParameter_private_offset);
	((GearyImapParameterClass *) klass)->to_string = (gchar* (*) (GearyImapParameter*)) geary_imap_list_parameter_real_to_string;
	((GearyImapParameterClass *) klass)->serialize = (void (*) (GearyImapParameter*, GearyImapSerializer*, GCancellable*, GError**)) geary_imap_list_parameter_real_serialize;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_list_parameter_get_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_list_parameter_finalize;
	/**
	     * Returns the number of {@link Parameter}s held in this {@link ListParameter}.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_LIST_PARAMETER_SIZE_PROPERTY, geary_imap_list_parameter_properties[GEARY_IMAP_LIST_PARAMETER_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_imap_list_parameter_instance_init (GearyImapListParameter * self,
                                         gpointer klass)
{
	GeeArrayList* _tmp0_;
	self->priv = geary_imap_list_parameter_get_instance_private (self);
	_tmp0_ = gee_array_list_new (GEARY_IMAP_TYPE_PARAMETER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->list = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
}

static void
geary_imap_list_parameter_finalize (GObject * obj)
{
	GearyImapListParameter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter);
	_g_object_unref0 (self->priv->list);
	G_OBJECT_CLASS (geary_imap_list_parameter_parent_class)->finalize (obj);
}

/**
 * The representation of an IMAP parenthesized list.
 *
 * See [[http://tools.ietf.org/html/rfc3501#section-4.4]]
 */
 G_GNUC_NO_INLINE static GType
geary_imap_list_parameter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapListParameterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_list_parameter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapListParameter), 0, (GInstanceInitFunc) geary_imap_list_parameter_instance_init, NULL };
	GType geary_imap_list_parameter_type_id;
	geary_imap_list_parameter_type_id = g_type_register_static (GEARY_IMAP_TYPE_PARAMETER, "GearyImapListParameter", &g_define_type_info, 0);
	GearyImapListParameter_private_offset = g_type_add_instance_private (geary_imap_list_parameter_type_id, sizeof (GearyImapListParameterPrivate));
	return geary_imap_list_parameter_type_id;
}

GType
geary_imap_list_parameter_get_type (void)
{
	static gsize geary_imap_list_parameter_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_list_parameter_type_id__once)) {
		GType geary_imap_list_parameter_type_id;
		geary_imap_list_parameter_type_id = geary_imap_list_parameter_get_type_once ();
		g_once_init_leave (&geary_imap_list_parameter_type_id__once, geary_imap_list_parameter_type_id);
	}
	return geary_imap_list_parameter_type_id__once;
}

static void
_vala_geary_imap_list_parameter_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	GearyImapListParameter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter);
	switch (property_id) {
		case GEARY_IMAP_LIST_PARAMETER_SIZE_PROPERTY:
		g_value_set_int (value, geary_imap_list_parameter_get_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

