/* gnome-boxes-search-provider.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gnome-boxes-search-provider.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "common.h"
#include <stdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOXES_TYPE_SEARCH_PROVIDER (boxes_search_provider_get_type ())
#define BOXES_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_SEARCH_PROVIDER, BoxesSearchProvider))
#define BOXES_SEARCH_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_SEARCH_PROVIDER, BoxesSearchProviderClass))
#define BOXES_IS_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_SEARCH_PROVIDER))
#define BOXES_IS_SEARCH_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_SEARCH_PROVIDER))
#define BOXES_SEARCH_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_SEARCH_PROVIDER, BoxesSearchProviderClass))

typedef struct _BoxesSearchProvider BoxesSearchProvider;
typedef struct _BoxesSearchProviderClass BoxesSearchProviderClass;
typedef struct _BoxesSearchProviderPrivate BoxesSearchProviderPrivate;

#define BOXES_TYPE_SEARCH_PROVIDER_APP (boxes_search_provider_app_get_type ())
#define BOXES_SEARCH_PROVIDER_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_SEARCH_PROVIDER_APP, BoxesSearchProviderApp))
#define BOXES_SEARCH_PROVIDER_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_SEARCH_PROVIDER_APP, BoxesSearchProviderAppClass))
#define BOXES_IS_SEARCH_PROVIDER_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_SEARCH_PROVIDER_APP))
#define BOXES_IS_SEARCH_PROVIDER_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_SEARCH_PROVIDER_APP))
#define BOXES_SEARCH_PROVIDER_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_SEARCH_PROVIDER_APP, BoxesSearchProviderAppClass))

typedef struct _BoxesSearchProviderApp BoxesSearchProviderApp;
typedef struct _BoxesSearchProviderAppClass BoxesSearchProviderAppClass;
enum  {
	BOXES_SEARCH_PROVIDER_0_PROPERTY,
	BOXES_SEARCH_PROVIDER_LOADED_PROPERTY,
	BOXES_SEARCH_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* boxes_search_provider_properties[BOXES_SEARCH_PROVIDER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
typedef struct _BoxesSearchProviderLoadData BoxesSearchProviderLoadData;
typedef struct _Block2Data Block2Data;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _BoxesSearchProviderSearchData BoxesSearchProviderSearchData;
typedef struct _boxes_search_provider_GetInitialResultSetData boxes_search_provider_GetInitialResultSetData;
typedef struct _boxes_search_provider_GetSubsearchResultSetData boxes_search_provider_GetSubsearchResultSetData;
typedef struct _BoxesSearchProviderGetMetasData BoxesSearchProviderGetMetasData;
typedef struct _boxes_search_provider_GetResultMetasData boxes_search_provider_GetResultMetasData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _boxes_search_provider_GetInitialResultSetReadyData boxes_search_provider_GetInitialResultSetReadyData;
typedef struct _boxes_search_provider_GetSubsearchResultSetReadyData boxes_search_provider_GetSubsearchResultSetReadyData;
typedef struct _BoxesSearchProviderGetMetasReadyData BoxesSearchProviderGetMetasReadyData;
typedef struct _boxes_search_provider_GetResultMetasReadyData boxes_search_provider_GetResultMetasReadyData;
typedef struct _BoxesSearchProviderAppPrivate BoxesSearchProviderAppPrivate;
enum  {
	BOXES_SEARCH_PROVIDER_APP_0_PROPERTY,
	BOXES_SEARCH_PROVIDER_APP_NUM_PROPERTIES
};
static GParamSpec* boxes_search_provider_app_properties[BOXES_SEARCH_PROVIDER_APP_NUM_PROPERTIES];

struct _BoxesSearchProvider {
	GObject parent_instance;
	BoxesSearchProviderPrivate * priv;
};

struct _BoxesSearchProviderClass {
	GObjectClass parent_class;
};

struct _BoxesSearchProviderPrivate {
	BoxesSearchProviderApp* app;
	gboolean loading;
	gboolean _loaded;
	GHashTable* boxes;
	guint next_id;
};

struct _Block1Data {
	int _ref_count_;
	BoxesSearchProvider* self;
	gpointer _async_data_;
};

struct _BoxesSearchProviderLoadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesSearchProvider* self;
	Block1Data* _data1_;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gulong wait;
	gulong _tmp2_;
	gboolean _tmp3_;
	GFile* dir;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
};

struct _Block2Data {
	int _ref_count_;
	GPtrArray* self;
	GCompareFunc compare_func;
};

struct _BoxesSearchProviderSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesSearchProvider* self;
	gchar** terms;
	gint terms_length1;
	gchar** result;
	gint result_length1;
	BoxesSearchProviderApp* _tmp0_;
	gchar** normalized_terms;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gint normalized_terms_length1;
	gint _normalized_terms_size_;
	GPtrArray* matches;
	GPtrArray* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gboolean _tmp11_;
	GHashTable* _tmp12_;
	GList* _tmp13_;
	GList* box_collection;
	GList* box_it;
	BoxesBoxConfig* box;
	BoxesBoxConfig* _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	GPtrArray* _tmp16_;
	BoxesBoxConfig* _tmp17_;
	BoxesBoxConfig* _tmp18_;
	GPtrArray* _tmp19_;
	gchar** results;
	GPtrArray* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gchar** _tmp23_;
	gint results_length1;
	gint _results_size_;
	gint i;
	gboolean _tmp24_;
	gint _tmp25_;
	GPtrArray* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	GPtrArray* _tmp30_;
	gconstpointer _tmp31_;
	gconstpointer _tmp32_;
	gchar* _tmp33_;
	BoxesSearchProviderApp* _tmp34_;
	gchar** _tmp35_;
	gint _tmp35__length1;
};

struct _boxes_search_provider_GetInitialResultSetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesSearchProvider* self;
	gchar** terms;
	gint terms_length1;
	gchar** result;
	gint result_length1;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
};

struct _boxes_search_provider_GetSubsearchResultSetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesSearchProvider* self;
	gchar** previous_results;
	gint previous_results_length1;
	gchar** new_terms;
	gint new_terms_length1;
	gchar** result;
	gint result_length1;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
};

struct _BoxesSearchProviderGetMetasData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesSearchProvider* self;
	gchar** ids;
	gint ids_length1;
	GHashTable** result;
	gint result_length1;
	GHashTable** metas;
	GHashTable** _tmp0_;
	gint metas_length1;
	gint _metas_size_;
	BoxesSearchProviderApp* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	guint n;
	gchar** id_collection;
	gint id_collection_length1;
	gint _id_collection_size_;
	gint id_it;
	gchar* _tmp4_;
	gchar* id;
	BoxesBoxConfig* box;
	GHashTable* _tmp5_;
	const gchar* _tmp6_;
	gconstpointer _tmp7_;
	BoxesBoxConfig* _tmp8_;
	BoxesBoxConfig* _tmp9_;
	GHashTable* meta;
	GHashFunc _tmp10_;
	GEqualFunc _tmp11_;
	GHashTable* _tmp12_;
	GHashTable** _tmp13_;
	gint _tmp13__length1;
	GHashTable* _tmp14_;
	GHashTable* _tmp15_;
	guint _tmp16_;
	GHashTable* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	GVariant* _tmp20_;
	GHashTable* _tmp21_;
	gchar* _tmp22_;
	BoxesBoxConfig* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GVariant* _tmp27_;
	GFile* file;
	BoxesBoxConfig* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	GFile* _tmp34_;
	GFile* _tmp35_;
	GFileInfo* info;
	GFileInfo* _tmp36_;
	GFile* _tmp37_;
	GFileInfo* _tmp38_;
	GFileInfo* _tmp39_;
	GFileInfo* _tmp40_;
	GFileIcon* icon;
	GFile* _tmp41_;
	GFileIcon* _tmp42_;
	GHashTable* _tmp43_;
	gchar* _tmp44_;
	GFileIcon* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	GVariant* _tmp48_;
	GHashTable* _tmp49_;
	gchar* _tmp50_;
	GThemedIcon* _tmp51_;
	GThemedIcon* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	GVariant* _tmp55_;
	BoxesSearchProviderApp* _tmp56_;
	GHashTable** _tmp57_;
	gint _tmp57__length1;
	GHashTable** _tmp58_;
	gint _tmp58__length1;
	GHashTable** _tmp59_;
	gint _tmp59__length1;
	GError* _inner_error0_;
};

struct _boxes_search_provider_GetResultMetasData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesSearchProvider* self;
	gchar** ids;
	gint ids_length1;
	GHashTable** result;
	gint result_length1;
	GHashTable** _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	GHashTable** _tmp3_;
	gint _tmp0__length1;
	gint __tmp0__size_;
	GHashTable** _tmp4_;
	gint _tmp4__length1;
	GHashTable** _tmp5_;
	gint _tmp5__length1;
	GError* _inner_error0_;
};

struct _boxes_search_provider_GetInitialResultSetReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar** terms;
	gint terms_length1;
};

struct _boxes_search_provider_GetSubsearchResultSetReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar** previous_results;
	gint previous_results_length1;
	gchar** new_terms;
	gint new_terms_length1;
};

struct _BoxesSearchProviderGetMetasReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar** ids;
	gint ids_length1;
};

struct _boxes_search_provider_GetResultMetasReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar** ids;
	gint ids_length1;
};

struct _BoxesSearchProviderApp {
	GApplication parent_instance;
	BoxesSearchProviderAppPrivate * priv;
};

struct _BoxesSearchProviderAppClass {
	GApplicationClass parent_class;
};

static gint BoxesSearchProvider_private_offset;
static gpointer boxes_search_provider_parent_class = NULL;
static gpointer boxes_search_provider_app_parent_class = NULL;

VALA_EXTERN GType boxes_search_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesSearchProvider, g_object_unref)
VALA_EXTERN guint boxes_search_provider_register_object (void* object,
                                             GDBusConnection* connection,
                                             const gchar* path,
                                             GError** error);
VALA_EXTERN GType boxes_search_provider_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesSearchProviderApp, g_object_unref)
VALA_EXTERN BoxesSearchProvider* boxes_search_provider_new (BoxesSearchProviderApp* app);
VALA_EXTERN BoxesSearchProvider* boxes_search_provider_construct (GType object_type,
                                                      BoxesSearchProviderApp* app);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void boxes_search_provider_add_box (BoxesSearchProvider* self,
                                    BoxesBoxConfig* box);
static void boxes_search_provider_load_data_free (gpointer _data);
static void boxes_search_provider_load (BoxesSearchProvider* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
static void boxes_search_provider_load_finish (BoxesSearchProvider* self,
                                        GAsyncResult* _res_);
static gboolean boxes_search_provider_load_co (BoxesSearchProviderLoadData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
VALA_EXTERN gboolean boxes_search_provider_get_loaded (BoxesSearchProvider* self);
static void ___lambda4_ (Block1Data* _data1_);
static void ____lambda4__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static gboolean __lambda5_ (BoxesSearchProvider* self,
                     const gchar* filename,
                     GError** error);
static gboolean ___lambda5__boxes_foreach_filename_from_dir_func (const gchar* filename,
                                                           gpointer self,
                                                           GError** error);
static void boxes_search_provider_load_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
VALA_EXTERN void boxes_search_provider_set_loaded (BoxesSearchProvider* self,
                                       gboolean value);
static void boxes_search_provider_search_data_free (gpointer _data);
static void boxes_search_provider_search (BoxesSearchProvider* self,
                                   gchar** terms,
                                   gint terms_length1,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
static gchar** boxes_search_provider_search_finish (BoxesSearchProvider* self,
                                             GAsyncResult* _res_,
                                             gint* result_length1);
static gboolean boxes_search_provider_search_co (BoxesSearchProviderSearchData* _data_);
static void boxes_search_provider_search_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gint ___lambda0__gcompare_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self);
static gint __lambda6_ (BoxesBoxConfig* a,
                 BoxesBoxConfig* b);
static gint ___lambda6__gcompare_func (gconstpointer a,
                                gconstpointer b);
static void boxes_search_provider_GetInitialResultSet_data_free (gpointer _data);
VALA_EXTERN void boxes_search_provider_GetInitialResultSet (BoxesSearchProvider* self,
                                                gchar** terms,
                                                gint terms_length1,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
VALA_EXTERN gchar** boxes_search_provider_GetInitialResultSet_finish (BoxesSearchProvider* self,
                                                          GAsyncResult* _res_,
                                                          gint* result_length1,
                                                          GError** error);
static gboolean boxes_search_provider_GetInitialResultSet_co (boxes_search_provider_GetInitialResultSetData* _data_);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void boxes_search_provider_GetInitialResultSet_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static void boxes_search_provider_GetSubsearchResultSet_data_free (gpointer _data);
VALA_EXTERN void boxes_search_provider_GetSubsearchResultSet (BoxesSearchProvider* self,
                                                  gchar** previous_results,
                                                  gint previous_results_length1,
                                                  gchar** new_terms,
                                                  gint new_terms_length1,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
VALA_EXTERN gchar** boxes_search_provider_GetSubsearchResultSet_finish (BoxesSearchProvider* self,
                                                            GAsyncResult* _res_,
                                                            gint* result_length1,
                                                            GError** error);
static gboolean boxes_search_provider_GetSubsearchResultSet_co (boxes_search_provider_GetSubsearchResultSetData* _data_);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static void boxes_search_provider_GetSubsearchResultSet_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_);
static void boxes_search_provider_get_metas_data_free (gpointer _data);
VALA_EXTERN void boxes_search_provider_get_metas (BoxesSearchProvider* self,
                                      gchar** ids,
                                      gint ids_length1,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
VALA_EXTERN GHashTable** boxes_search_provider_get_metas_finish (BoxesSearchProvider* self,
                                                     GAsyncResult* _res_,
                                                     gint* result_length1,
                                                     GError** error);
static gboolean boxes_search_provider_get_metas_co (BoxesSearchProviderGetMetasData* _data_);
static void _g_variant_unref0_ (gpointer var);
static void boxes_search_provider_get_metas_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static GHashTable** _vala_array_dup3 (GHashTable** self,
                               gssize length);
static void boxes_search_provider_GetResultMetas_data_free (gpointer _data);
VALA_EXTERN void boxes_search_provider_GetResultMetas (BoxesSearchProvider* self,
                                           gchar** ids,
                                           gint ids_length1,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
VALA_EXTERN GHashTable** boxes_search_provider_GetResultMetas_finish (BoxesSearchProvider* self,
                                                          GAsyncResult* _res_,
                                                          gint* result_length1,
                                                          GError** error);
static gboolean boxes_search_provider_GetResultMetas_co (boxes_search_provider_GetResultMetasData* _data_);
static gchar** _vala_array_dup4 (gchar** self,
                          gssize length);
static void boxes_search_provider_GetResultMetas_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
VALA_EXTERN void boxes_search_provider_ActivateResult (BoxesSearchProvider* self,
                                           const gchar* search_id,
                                           gchar** terms,
                                           gint terms_length1,
                                           guint32 timestamp,
                                           GError** error);
VALA_EXTERN void boxes_search_provider_LaunchSearch (BoxesSearchProvider* self,
                                         gchar** terms,
                                         gint terms_length1,
                                         guint32 timestamp,
                                         GError** error);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void boxes_search_provider_finalize (GObject * obj);
static GType boxes_search_provider_get_type_once (void);
static void _vala_boxes_search_provider_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_boxes_search_provider_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static void _dbus_boxes_search_provider_GetInitialResultSet (BoxesSearchProvider* self,
                                                      GVariant* _parameters_,
                                                      GDBusMethodInvocation* invocation);
static void _dbus_boxes_search_provider_GetInitialResultSet_ready (GObject * source_object,
                                                            GAsyncResult * _res_,
                                                            gpointer _user_data_);
static void _dbus_boxes_search_provider_GetSubsearchResultSet (BoxesSearchProvider* self,
                                                        GVariant* _parameters_,
                                                        GDBusMethodInvocation* invocation);
static void _dbus_boxes_search_provider_GetSubsearchResultSet_ready (GObject * source_object,
                                                              GAsyncResult * _res_,
                                                              gpointer _user_data_);
static void _dbus_boxes_search_provider_get_metas (BoxesSearchProvider* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation);
static void _dbus_boxes_search_provider_get_metas_ready (GObject * source_object,
                                                  GAsyncResult * _res_,
                                                  gpointer _user_data_);
static void _dbus_boxes_search_provider_GetResultMetas (BoxesSearchProvider* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_boxes_search_provider_GetResultMetas_ready (GObject * source_object,
                                                       GAsyncResult * _res_,
                                                       gpointer _user_data_);
static void _dbus_boxes_search_provider_ActivateResult (BoxesSearchProvider* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_boxes_search_provider_LaunchSearch (BoxesSearchProvider* self,
                                               GVariant* _parameters_,
                                               GDBusMethodInvocation* invocation);
static void boxes_search_provider_dbus_interface_method_call (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* method_name,
                                                       GVariant* parameters,
                                                       GDBusMethodInvocation* invocation,
                                                       gpointer user_data);
static GVariant* boxes_search_provider_dbus_interface_get_property (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* property_name,
                                                             GError** error,
                                                             gpointer user_data);
static GVariant* _dbus_boxes_search_provider_get_loaded (BoxesSearchProvider* self);
static gboolean boxes_search_provider_dbus_interface_set_property (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* property_name,
                                                            GVariant* value,
                                                            GError** error,
                                                            gpointer user_data);
static void _dbus_boxes_search_provider_set_loaded (BoxesSearchProvider* self,
                                             GVariant* _value);
static void _boxes_search_provider_unregister_object (gpointer user_data);
VALA_EXTERN BoxesSearchProviderApp* boxes_search_provider_app_new (void);
VALA_EXTERN BoxesSearchProviderApp* boxes_search_provider_app_construct (GType object_type);
static gboolean boxes_search_provider_app_real_dbus_register (GApplication* base,
                                                       GDBusConnection* connection,
                                                       const gchar* object_path,
                                                       GError** error);
static void boxes_search_provider_app_real_startup (GApplication* base);
static GType boxes_search_provider_app_get_type_once (void);
static gint _vala_main (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GDBusArgInfo _boxes_search_provider_dbus_arg_info_GetInitialResultSet_terms = {-1, "terms", "as", NULL};
static const GDBusArgInfo _boxes_search_provider_dbus_arg_info_GetInitialResultSet_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _boxes_search_provider_dbus_arg_info_GetInitialResultSet_in[] = {&_boxes_search_provider_dbus_arg_info_GetInitialResultSet_terms, NULL};
static const GDBusArgInfo * const _boxes_search_provider_dbus_arg_info_GetInitialResultSet_out[] = {&_boxes_search_provider_dbus_arg_info_GetInitialResultSet_result, NULL};
static const GDBusMethodInfo _boxes_search_provider_dbus_method_info_GetInitialResultSet = {-1, "GetInitialResultSet", (GDBusArgInfo **) (&_boxes_search_provider_dbus_arg_info_GetInitialResultSet_in), (GDBusArgInfo **) (&_boxes_search_provider_dbus_arg_info_GetInitialResultSet_out), NULL};
static const GDBusArgInfo _boxes_search_provider_dbus_arg_info_GetSubsearchResultSet_previous_results = {-1, "previous_results", "as", NULL};
static const GDBusArgInfo _boxes_search_provider_dbus_arg_info_GetSubsearchResultSet_new_terms = {-1, "new_terms", "as", NULL};
static const GDBusArgInfo _boxes_search_provider_dbus_arg_info_GetSubsearchResultSet_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _boxes_search_provider_dbus_arg_info_GetSubsearchResultSet_in[] = {&_boxes_search_provider_dbus_arg_info_GetSubsearchResultSet_previous_results, &_boxes_search_provider_dbus_arg_info_GetSubsearchResultSet_new_terms, NULL};
static const GDBusArgInfo * const _boxes_search_provider_dbus_arg_info_GetSubsearchResultSet_out[] = {&_boxes_search_provider_dbus_arg_info_GetSubsearchResultSet_result, NULL};
static const GDBusMethodInfo _boxes_search_provider_dbus_method_info_GetSubsearchResultSet = {-1, "GetSubsearchResultSet", (GDBusArgInfo **) (&_boxes_search_provider_dbus_arg_info_GetSubsearchResultSet_in), (GDBusArgInfo **) (&_boxes_search_provider_dbus_arg_info_GetSubsearchResultSet_out), NULL};
static const GDBusArgInfo _boxes_search_provider_dbus_arg_info_get_metas_ids = {-1, "ids", "as", NULL};
static const GDBusArgInfo _boxes_search_provider_dbus_arg_info_get_metas_result = {-1, "result", "aa{sv}", NULL};
static const GDBusArgInfo * const _boxes_search_provider_dbus_arg_info_get_metas_in[] = {&_boxes_search_provider_dbus_arg_info_get_metas_ids, NULL};
static const GDBusArgInfo * const _boxes_search_provider_dbus_arg_info_get_metas_out[] = {&_boxes_search_provider_dbus_arg_info_get_metas_result, NULL};
static const GDBusMethodInfo _boxes_search_provider_dbus_method_info_get_metas = {-1, "GetMetas", (GDBusArgInfo **) (&_boxes_search_provider_dbus_arg_info_get_metas_in), (GDBusArgInfo **) (&_boxes_search_provider_dbus_arg_info_get_metas_out), NULL};
static const GDBusArgInfo _boxes_search_provider_dbus_arg_info_GetResultMetas_ids = {-1, "ids", "as", NULL};
static const GDBusArgInfo _boxes_search_provider_dbus_arg_info_GetResultMetas_result = {-1, "result", "aa{sv}", NULL};
static const GDBusArgInfo * const _boxes_search_provider_dbus_arg_info_GetResultMetas_in[] = {&_boxes_search_provider_dbus_arg_info_GetResultMetas_ids, NULL};
static const GDBusArgInfo * const _boxes_search_provider_dbus_arg_info_GetResultMetas_out[] = {&_boxes_search_provider_dbus_arg_info_GetResultMetas_result, NULL};
static const GDBusMethodInfo _boxes_search_provider_dbus_method_info_GetResultMetas = {-1, "GetResultMetas", (GDBusArgInfo **) (&_boxes_search_provider_dbus_arg_info_GetResultMetas_in), (GDBusArgInfo **) (&_boxes_search_provider_dbus_arg_info_GetResultMetas_out), NULL};
static const GDBusArgInfo _boxes_search_provider_dbus_arg_info_ActivateResult_search_id = {-1, "search_id", "s", NULL};
static const GDBusArgInfo _boxes_search_provider_dbus_arg_info_ActivateResult_terms = {-1, "terms", "as", NULL};
static const GDBusArgInfo _boxes_search_provider_dbus_arg_info_ActivateResult_timestamp = {-1, "timestamp", "u", NULL};
static const GDBusArgInfo * const _boxes_search_provider_dbus_arg_info_ActivateResult_in[] = {&_boxes_search_provider_dbus_arg_info_ActivateResult_search_id, &_boxes_search_provider_dbus_arg_info_ActivateResult_terms, &_boxes_search_provider_dbus_arg_info_ActivateResult_timestamp, NULL};
static const GDBusArgInfo * const _boxes_search_provider_dbus_arg_info_ActivateResult_out[] = {NULL};
static const GDBusMethodInfo _boxes_search_provider_dbus_method_info_ActivateResult = {-1, "ActivateResult", (GDBusArgInfo **) (&_boxes_search_provider_dbus_arg_info_ActivateResult_in), (GDBusArgInfo **) (&_boxes_search_provider_dbus_arg_info_ActivateResult_out), NULL};
static const GDBusArgInfo _boxes_search_provider_dbus_arg_info_LaunchSearch_terms = {-1, "terms", "as", NULL};
static const GDBusArgInfo _boxes_search_provider_dbus_arg_info_LaunchSearch_timestamp = {-1, "timestamp", "u", NULL};
static const GDBusArgInfo * const _boxes_search_provider_dbus_arg_info_LaunchSearch_in[] = {&_boxes_search_provider_dbus_arg_info_LaunchSearch_terms, &_boxes_search_provider_dbus_arg_info_LaunchSearch_timestamp, NULL};
static const GDBusArgInfo * const _boxes_search_provider_dbus_arg_info_LaunchSearch_out[] = {NULL};
static const GDBusMethodInfo _boxes_search_provider_dbus_method_info_LaunchSearch = {-1, "LaunchSearch", (GDBusArgInfo **) (&_boxes_search_provider_dbus_arg_info_LaunchSearch_in), (GDBusArgInfo **) (&_boxes_search_provider_dbus_arg_info_LaunchSearch_out), NULL};
static const GDBusMethodInfo * const _boxes_search_provider_dbus_method_info[] = {&_boxes_search_provider_dbus_method_info_GetInitialResultSet, &_boxes_search_provider_dbus_method_info_GetSubsearchResultSet, &_boxes_search_provider_dbus_method_info_get_metas, &_boxes_search_provider_dbus_method_info_GetResultMetas, &_boxes_search_provider_dbus_method_info_ActivateResult, &_boxes_search_provider_dbus_method_info_LaunchSearch, NULL};
static const GDBusSignalInfo * const _boxes_search_provider_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _boxes_search_provider_dbus_property_info_loaded = {-1, "Loaded", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo * const _boxes_search_provider_dbus_property_info[] = {&_boxes_search_provider_dbus_property_info_loaded, NULL};
static const GDBusInterfaceInfo _boxes_search_provider_dbus_interface_info = {-1, "org.gnome.Shell.SearchProvider2", (GDBusMethodInfo **) (&_boxes_search_provider_dbus_method_info), (GDBusSignalInfo **) (&_boxes_search_provider_dbus_signal_info), (GDBusPropertyInfo **) (&_boxes_search_provider_dbus_property_info), NULL};
static const GDBusInterfaceVTable _boxes_search_provider_dbus_interface_vtable = {boxes_search_provider_dbus_interface_method_call, boxes_search_provider_dbus_interface_get_property, boxes_search_provider_dbus_interface_set_property};

static inline gpointer
boxes_search_provider_get_instance_private (BoxesSearchProvider* self)
{
	return G_STRUCT_MEMBER_P (self, BoxesSearchProvider_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

BoxesSearchProvider*
boxes_search_provider_construct (GType object_type,
                                 BoxesSearchProviderApp* app)
{
	BoxesSearchProvider * self = NULL;
	BoxesSearchProviderApp* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	g_return_val_if_fail (app != NULL, NULL);
	self = (BoxesSearchProvider*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (app);
	_g_object_unref0 (self->priv->app);
	self->priv->app = _tmp0_;
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->boxes);
	self->priv->boxes = _tmp3_;
	return self;
}

BoxesSearchProvider*
boxes_search_provider_new (BoxesSearchProviderApp* app)
{
	return boxes_search_provider_construct (BOXES_TYPE_SEARCH_PROVIDER, app);
}

static void
boxes_search_provider_add_box (BoxesSearchProvider* self,
                               BoxesBoxConfig* box)
{
	gchar* id = NULL;
	guint _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GHashTable* _tmp3_;
	gchar* _tmp4_;
	BoxesBoxConfig* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (box != NULL);
	_tmp0_ = self->priv->next_id;
	self->priv->next_id = _tmp0_ + 1;
	_tmp1_ = g_strdup_printf ("%u", _tmp0_);
	id = _tmp1_;
	_tmp2_ = g_strdup (id);
	g_object_set_data_full ((GObject*) box, "search-id", _tmp2_, g_free);
	_tmp3_ = self->priv->boxes;
	_tmp4_ = g_strdup (id);
	_tmp5_ = _g_object_ref0 (box);
	g_hash_table_insert (_tmp3_, _tmp4_, _tmp5_);
	_g_free0 (id);
}

static void
boxes_search_provider_load_data_free (gpointer _data)
{
	BoxesSearchProviderLoadData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesSearchProviderLoadData, _data_);
}

static void
boxes_search_provider_load (BoxesSearchProvider* self,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	BoxesSearchProviderLoadData* _data_;
	BoxesSearchProvider* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BoxesSearchProviderLoadData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_search_provider_load_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	boxes_search_provider_load_co (_data_);
}

static void
boxes_search_provider_load_finish (BoxesSearchProvider* self,
                                   GAsyncResult* _res_)
{
	BoxesSearchProviderLoadData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		BoxesSearchProvider* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
___lambda4_ (Block1Data* _data1_)
{
	BoxesSearchProvider* self;
	self = _data1_->self;
	boxes_search_provider_load_co (_data1_->_async_data_);
}

static void
____lambda4__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	___lambda4_ (self);
}

static gboolean
__lambda5_ (BoxesSearchProvider* self,
            const gchar* filename,
            GError** error)
{
	BoxesCollectionSource* source = NULL;
	BoxesCollectionSource* _tmp0_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gint _tmp4_ = 0;
	gchar** _tmp5_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (filename != NULL, FALSE);
	_tmp0_ = boxes_collection_source_new_with_file (filename, &_inner_error0_);
	source = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	_tmp2_ = boxes_collection_source_get_enabled (source);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		result = FALSE;
		_g_object_unref0 (source);
		return result;
	}
	_tmp5_ = boxes_iconfig_get_groups ((BoxesIConfig*) source, "display", &_tmp4_);
	{
		gchar** group_collection = NULL;
		gint group_collection_length1 = 0;
		gint _group_collection_size_ = 0;
		gint group_it = 0;
		group_collection = _tmp5_;
		group_collection_length1 = _tmp4_;
		for (group_it = 0; group_it < group_collection_length1; group_it = group_it + 1) {
			gchar* _tmp6_;
			gchar* group = NULL;
			_tmp6_ = g_strdup (group_collection[group_it]);
			group = _tmp6_;
			{
				BoxesBoxConfig* box = NULL;
				const gchar* _tmp7_;
				BoxesBoxConfig* _tmp8_;
				BoxesBoxConfig* _tmp9_;
				_tmp7_ = group;
				_tmp8_ = boxes_box_config_new_with_group (source, _tmp7_);
				box = _tmp8_;
				_tmp9_ = box;
				boxes_search_provider_add_box (self, _tmp9_);
				_g_object_unref0 (box);
				_g_free0 (group);
			}
		}
		group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = FALSE;
	_g_object_unref0 (source);
	return result;
}

static gboolean
___lambda5__boxes_foreach_filename_from_dir_func (const gchar* filename,
                                                  gpointer self,
                                                  GError** error)
{
	gboolean result;
	result = __lambda5_ ((BoxesSearchProvider*) self, filename, error);
	return result;
}

static void
boxes_search_provider_load_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	BoxesSearchProviderLoadData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_search_provider_load_co (_data_);
}

static gboolean
boxes_search_provider_load_co (BoxesSearchProviderLoadData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_data1_->_async_data_ = _data_;
	while (TRUE) {
		_data_->_tmp1_ = _data_->self->priv->_loaded;
		if (!_data_->_tmp1_) {
			_data_->_tmp0_ = _data_->self->priv->loading;
		} else {
			_data_->_tmp0_ = FALSE;
		}
		if (!_data_->_tmp0_) {
			break;
		}
		_data_->_tmp2_ = g_signal_connect_data ((GObject*) _data_->self, "notify::loaded", (GCallback) ____lambda4__g_object_notify, block1_data_ref (_data_->_data1_), (GClosureNotify) block1_data_unref, 0);
		_data_->wait = _data_->_tmp2_;
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		g_signal_handler_disconnect ((GObject*) _data_->self, _data_->wait);
		_data_->_tmp3_ = _data_->self->priv->_loaded;
		if (_data_->_tmp3_) {
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->self->priv->loading = TRUE;
	_data_->_tmp4_ = boxes_get_user_pkgconfig_source (NULL);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = g_file_new_for_path (_data_->_tmp5_);
	_data_->_tmp7_ = _data_->_tmp6_;
	_g_free0 (_data_->_tmp5_);
	_data_->dir = _data_->_tmp7_;
	_data_->_tmp8_ = _data_->dir;
	_data_->_state_ = 2;
	boxes_foreach_filename_from_dir (_data_->_tmp8_, ___lambda5__boxes_foreach_filename_from_dir_func, _data_->self, boxes_search_provider_load_ready, _data_);
	return FALSE;
	_state_2:
	boxes_foreach_filename_from_dir_finish (_data_->_res_);
	boxes_search_provider_set_loaded (_data_->self, TRUE);
	_data_->self->priv->loading = FALSE;
	_g_object_unref0 (_data_->dir);
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
boxes_search_provider_search_data_free (gpointer _data)
{
	BoxesSearchProviderSearchData* _data_;
	_data_ = _data;
	_data_->terms = (_vala_array_free (_data_->terms, _data_->terms_length1, (GDestroyNotify) g_free), NULL);
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesSearchProviderSearchData, _data_);
}

static void
boxes_search_provider_search (BoxesSearchProvider* self,
                              gchar** terms,
                              gint terms_length1,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	BoxesSearchProviderSearchData* _data_;
	BoxesSearchProvider* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BoxesSearchProviderSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_search_provider_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->terms = (_vala_array_free (_data_->terms, _data_->terms_length1, (GDestroyNotify) g_free), NULL);
	_data_->terms = terms;
	_data_->terms_length1 = terms_length1;
	boxes_search_provider_search_co (_data_);
}

static gchar**
boxes_search_provider_search_finish (BoxesSearchProvider* self,
                                     GAsyncResult* _res_,
                                     gint* result_length1)
{
	gchar** result;
	BoxesSearchProviderSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static void
boxes_search_provider_search_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	BoxesSearchProviderSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_search_provider_search_co (_data_);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		GPtrArray* self;
		self = _data2_->self;
		_g_ptr_array_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gint
__lambda0_ (Block2Data* _data2_,
            gconstpointer** a,
            gconstpointer** b)
{
	GPtrArray* self;
	gint result;
	self = _data2_->self;
	result = _data2_->compare_func ((gconstpointer**) (*a), (gconstpointer**) (*b));
	return result;
}

static gint
___lambda0__gcompare_data_func (gconstpointer a,
                                gconstpointer b,
                                gpointer self)
{
	gint result;
	result = __lambda0_ (self, a, b);
	return result;
}

static void
vala_g_ptr_array_sort (GPtrArray* self,
                       GCompareFunc compare_func)
{
	Block2Data* _data2_;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_ptr_array_ref (self);
	_data2_->compare_func = compare_func;
	g_ptr_array_sort_with_data (self, ___lambda0__gcompare_data_func, _data2_);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static gint
__lambda6_ (BoxesBoxConfig* a,
            BoxesBoxConfig* b)
{
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	result = boxes_box_config_compare (a, b);
	return result;
}

static gint
___lambda6__gcompare_func (gconstpointer a,
                           gconstpointer b)
{
	gint result;
	result = __lambda6_ ((BoxesBoxConfig*) a, (BoxesBoxConfig*) b);
	return result;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static gboolean
boxes_search_provider_search_co (BoxesSearchProviderSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->app;
	g_application_hold ((GApplication*) _data_->_tmp0_);
	_data_->_tmp1_ = _vala_g_strjoinv (" ", _data_->terms, (gint) _data_->terms_length1);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = boxes_canonicalize_for_search (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp6_ = _data_->_tmp5_ = g_strsplit (_data_->_tmp4_, " ", 0);
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp7__length1 = _vala_array_length (_data_->_tmp5_);
	_g_free0 (_data_->_tmp4_);
	_g_free0 (_data_->_tmp2_);
	_data_->normalized_terms = _data_->_tmp7_;
	_data_->normalized_terms_length1 = _data_->_tmp7__length1;
	_data_->_normalized_terms_size_ = _data_->normalized_terms_length1;
	_data_->_tmp8_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_data_->matches = _data_->_tmp8_;
	_data_->_tmp9_ = _vala_g_strjoinv (", ", _data_->terms, (gint) _data_->terms_length1);
	_data_->_tmp10_ = _data_->_tmp9_;
	g_debug ("gnome-boxes-search-provider.vala:61: search (%s)", _data_->_tmp10_);
	_g_free0 (_data_->_tmp10_);
	_data_->_tmp11_ = _data_->self->priv->_loaded;
	if (!_data_->_tmp11_) {
		_data_->_state_ = 1;
		boxes_search_provider_load (_data_->self, boxes_search_provider_search_ready, _data_);
		return FALSE;
		_state_1:
		boxes_search_provider_load_finish (_data_->self, _data_->_res_);
	}
	_data_->_tmp12_ = _data_->self->priv->boxes;
	_data_->_tmp13_ = g_hash_table_get_values (_data_->_tmp12_);
	{
		_data_->box_collection = _data_->_tmp13_;
		for (_data_->box_it = _data_->box_collection; _data_->box_it != NULL; _data_->box_it = _data_->box_it->next) {
			_data_->box = (BoxesBoxConfig*) _data_->box_it->data;
			{
				_data_->_tmp14_ = _data_->box;
				_data_->_tmp15_ = _data_->normalized_terms;
				_data_->_tmp15__length1 = _data_->normalized_terms_length1;
				if (boxes_box_config_contains_strings (_data_->_tmp14_, _data_->_tmp15_, (gint) _data_->_tmp15__length1)) {
					_data_->_tmp16_ = _data_->matches;
					_data_->_tmp17_ = _data_->box;
					_data_->_tmp18_ = _g_object_ref0 (_data_->_tmp17_);
					g_ptr_array_add (_data_->_tmp16_, _data_->_tmp18_);
				}
			}
		}
		(_data_->box_collection == NULL) ? NULL : (_data_->box_collection = (g_list_free (_data_->box_collection), NULL));
	}
	_data_->_tmp19_ = _data_->matches;
	vala_g_ptr_array_sort (_data_->_tmp19_, ___lambda6__gcompare_func);
	_data_->_tmp20_ = _data_->matches;
	_data_->_tmp21_ = vala_g_ptr_array_get_length (_data_->_tmp20_);
	_data_->_tmp22_ = _data_->_tmp21_;
	_data_->_tmp23_ = g_new0 (gchar*, _data_->_tmp22_ + 1);
	_data_->results = _data_->_tmp23_;
	_data_->results_length1 = _data_->_tmp22_;
	_data_->_results_size_ = _data_->results_length1;
	{
		_data_->i = 0;
		{
			_data_->_tmp24_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp24_) {
					_data_->_tmp25_ = _data_->i;
					_data_->i = _data_->_tmp25_ + 1;
				}
				_data_->_tmp24_ = FALSE;
				_data_->_tmp26_ = _data_->matches;
				_data_->_tmp27_ = vala_g_ptr_array_get_length (_data_->_tmp26_);
				_data_->_tmp28_ = _data_->_tmp27_;
				if (!(_data_->i < _data_->_tmp28_)) {
					break;
				}
				_data_->_tmp29_ = _data_->results;
				_data_->_tmp29__length1 = _data_->results_length1;
				_data_->_tmp30_ = _data_->matches;
				_data_->_tmp31_ = g_ptr_array_index (_data_->_tmp30_, (guint) _data_->i);
				_data_->_tmp32_ = g_object_get_data ((GObject*) ((BoxesBoxConfig*) _data_->_tmp31_), "search-id");
				_data_->_tmp33_ = g_strdup ((const gchar*) _data_->_tmp32_);
				_g_free0 (_data_->_tmp29_[_data_->i]);
				_data_->_tmp29_[_data_->i] = _data_->_tmp33_;
			}
		}
	}
	_data_->_tmp34_ = _data_->self->priv->app;
	g_application_release ((GApplication*) _data_->_tmp34_);
	_data_->_tmp35_ = _data_->results;
	_data_->_tmp35__length1 = _data_->results_length1;
	_data_->result_length1 = _data_->_tmp35__length1;
	_data_->result = _data_->_tmp35_;
	_g_ptr_array_unref0 (_data_->matches);
	_data_->normalized_terms = (_vala_array_free (_data_->normalized_terms, _data_->normalized_terms_length1, (GDestroyNotify) g_free), NULL);
	_data_->terms = (_vala_array_free (_data_->terms, _data_->terms_length1, (GDestroyNotify) g_free), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
boxes_search_provider_GetInitialResultSet_data_free (gpointer _data)
{
	boxes_search_provider_GetInitialResultSetData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (boxes_search_provider_GetInitialResultSetData, _data_);
}

void
boxes_search_provider_GetInitialResultSet (BoxesSearchProvider* self,
                                           gchar** terms,
                                           gint terms_length1,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	boxes_search_provider_GetInitialResultSetData* _data_;
	BoxesSearchProvider* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (boxes_search_provider_GetInitialResultSetData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_search_provider_GetInitialResultSet_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->terms = terms;
	_data_->terms_length1 = terms_length1;
	boxes_search_provider_GetInitialResultSet_co (_data_);
}

gchar**
boxes_search_provider_GetInitialResultSet_finish (BoxesSearchProvider* self,
                                                  GAsyncResult* _res_,
                                                  gint* result_length1,
                                                  GError** error)
{
	gchar** result;
	boxes_search_provider_GetInitialResultSetData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
boxes_search_provider_GetInitialResultSet_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	boxes_search_provider_GetInitialResultSetData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_search_provider_GetInitialResultSet_co (_data_);
}

static gboolean
boxes_search_provider_GetInitialResultSet_co (boxes_search_provider_GetInitialResultSetData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = (_data_->terms != NULL) ? _vala_array_dup1 (_data_->terms, _data_->terms_length1) : _data_->terms;
	_data_->_tmp0__length1 = _data_->terms_length1;
	_data_->_tmp1_ = 0;
	_data_->_state_ = 1;
	boxes_search_provider_search (_data_->self, _data_->_tmp0_, (gint) _data_->_tmp0__length1, boxes_search_provider_GetInitialResultSet_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = boxes_search_provider_search_finish (_data_->self, _data_->_res_, &_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp3__length1 = _data_->_tmp1_;
	_data_->result_length1 = _data_->_tmp3__length1;
	_data_->result = _data_->_tmp3_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
boxes_search_provider_GetSubsearchResultSet_data_free (gpointer _data)
{
	boxes_search_provider_GetSubsearchResultSetData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (boxes_search_provider_GetSubsearchResultSetData, _data_);
}

void
boxes_search_provider_GetSubsearchResultSet (BoxesSearchProvider* self,
                                             gchar** previous_results,
                                             gint previous_results_length1,
                                             gchar** new_terms,
                                             gint new_terms_length1,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	boxes_search_provider_GetSubsearchResultSetData* _data_;
	BoxesSearchProvider* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (boxes_search_provider_GetSubsearchResultSetData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_search_provider_GetSubsearchResultSet_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->previous_results = previous_results;
	_data_->previous_results_length1 = previous_results_length1;
	_data_->new_terms = new_terms;
	_data_->new_terms_length1 = new_terms_length1;
	boxes_search_provider_GetSubsearchResultSet_co (_data_);
}

gchar**
boxes_search_provider_GetSubsearchResultSet_finish (BoxesSearchProvider* self,
                                                    GAsyncResult* _res_,
                                                    gint* result_length1,
                                                    GError** error)
{
	gchar** result;
	boxes_search_provider_GetSubsearchResultSetData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
boxes_search_provider_GetSubsearchResultSet_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_)
{
	boxes_search_provider_GetSubsearchResultSetData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_search_provider_GetSubsearchResultSet_co (_data_);
}

static gboolean
boxes_search_provider_GetSubsearchResultSet_co (boxes_search_provider_GetSubsearchResultSetData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = (_data_->new_terms != NULL) ? _vala_array_dup2 (_data_->new_terms, _data_->new_terms_length1) : _data_->new_terms;
	_data_->_tmp0__length1 = _data_->new_terms_length1;
	_data_->_tmp1_ = 0;
	_data_->_state_ = 1;
	boxes_search_provider_search (_data_->self, _data_->_tmp0_, (gint) _data_->_tmp0__length1, boxes_search_provider_GetSubsearchResultSet_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = boxes_search_provider_search_finish (_data_->self, _data_->_res_, &_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp3__length1 = _data_->_tmp1_;
	_data_->result_length1 = _data_->_tmp3__length1;
	_data_->result = _data_->_tmp3_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
boxes_search_provider_get_metas_data_free (gpointer _data)
{
	BoxesSearchProviderGetMetasData* _data_;
	_data_ = _data;
	_data_->ids = (_vala_array_free (_data_->ids, _data_->ids_length1, (GDestroyNotify) g_free), NULL);
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesSearchProviderGetMetasData, _data_);
}

void
boxes_search_provider_get_metas (BoxesSearchProvider* self,
                                 gchar** ids,
                                 gint ids_length1,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	BoxesSearchProviderGetMetasData* _data_;
	BoxesSearchProvider* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BoxesSearchProviderGetMetasData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_search_provider_get_metas_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->ids = (_vala_array_free (_data_->ids, _data_->ids_length1, (GDestroyNotify) g_free), NULL);
	_data_->ids = ids;
	_data_->ids_length1 = ids_length1;
	boxes_search_provider_get_metas_co (_data_);
}

GHashTable**
boxes_search_provider_get_metas_finish (BoxesSearchProvider* self,
                                        GAsyncResult* _res_,
                                        gint* result_length1,
                                        GError** error)
{
	GHashTable** result;
	BoxesSearchProviderGetMetasData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static void
boxes_search_provider_get_metas_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	BoxesSearchProviderGetMetasData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_search_provider_get_metas_co (_data_);
}

static GHashTable**
_vala_array_dup3 (GHashTable** self,
                  gssize length)
{
	if (length >= 0) {
		GHashTable** result;
		gssize i;
		result = g_new0 (GHashTable*, length + 1);
		for (i = 0; i < length; i++) {
			GHashTable* _tmp0_;
			_tmp0_ = _g_hash_table_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gboolean
boxes_search_provider_get_metas_co (BoxesSearchProviderGetMetasData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_new0 (GHashTable*, _data_->ids_length1 + 1);
	_data_->metas = _data_->_tmp0_;
	_data_->metas_length1 = _data_->ids_length1;
	_data_->_metas_size_ = _data_->metas_length1;
	_data_->_tmp1_ = _data_->self->priv->app;
	g_application_hold ((GApplication*) _data_->_tmp1_);
	_data_->_tmp2_ = _vala_g_strjoinv (", ", _data_->ids, (gint) _data_->ids_length1);
	_data_->_tmp3_ = _data_->_tmp2_;
	g_debug ("gnome-boxes-search-provider.vala:92: GetResultMetas (%s)", _data_->_tmp3_);
	_g_free0 (_data_->_tmp3_);
	_data_->n = (guint) 0;
	{
		_data_->id_collection_length1 = 0;
		_data_->_id_collection_size_ = 0;
		_data_->id_collection = _data_->ids;
		_data_->id_collection_length1 = _data_->ids_length1;
		for (_data_->id_it = 0; _data_->id_it < _data_->id_collection_length1; _data_->id_it = _data_->id_it + 1) {
			_data_->_tmp4_ = g_strdup (_data_->id_collection[_data_->id_it]);
			_data_->id = _data_->_tmp4_;
			{
				_data_->_tmp5_ = _data_->self->priv->boxes;
				_data_->_tmp6_ = _data_->id;
				_data_->_tmp7_ = g_hash_table_lookup (_data_->_tmp5_, _data_->_tmp6_);
				_data_->_tmp8_ = _g_object_ref0 ((BoxesBoxConfig*) _data_->_tmp7_);
				_data_->box = _data_->_tmp8_;
				_data_->_tmp9_ = _data_->box;
				if (_data_->_tmp9_ == NULL) {
					_g_object_unref0 (_data_->box);
					_g_free0 (_data_->id);
					continue;
				}
				_data_->_tmp10_ = g_str_hash;
				_data_->_tmp11_ = g_str_equal;
				_data_->_tmp12_ = g_hash_table_new_full (_data_->_tmp10_, _data_->_tmp11_, _g_free0_, _g_variant_unref0_);
				_data_->meta = _data_->_tmp12_;
				_data_->_tmp13_ = _data_->metas;
				_data_->_tmp13__length1 = _data_->metas_length1;
				_data_->_tmp14_ = _data_->meta;
				_data_->_tmp15_ = _g_hash_table_ref0 (_data_->_tmp14_);
				_g_hash_table_unref0 (_data_->_tmp13_[_data_->n]);
				_data_->_tmp13_[_data_->n] = _data_->_tmp15_;
				_data_->_tmp16_ = _data_->n;
				_data_->n = _data_->_tmp16_ + 1;
				_data_->_tmp17_ = _data_->meta;
				_data_->_tmp18_ = g_strdup ("id");
				_data_->_tmp19_ = _data_->id;
				_data_->_tmp20_ = g_variant_new_string (_data_->_tmp19_);
				g_variant_ref_sink (_data_->_tmp20_);
				g_hash_table_insert (_data_->_tmp17_, _data_->_tmp18_, _data_->_tmp20_);
				_data_->_tmp21_ = _data_->meta;
				_data_->_tmp22_ = g_strdup ("name");
				_data_->_tmp23_ = _data_->box;
				_data_->_tmp24_ = boxes_box_config_get_last_seen_name (_data_->_tmp23_);
				_data_->_tmp25_ = _data_->_tmp24_;
				_data_->_tmp26_ = _data_->_tmp25_;
				_data_->_tmp27_ = g_variant_new_string (_data_->_tmp26_);
				g_variant_ref_sink (_data_->_tmp27_);
				g_hash_table_insert (_data_->_tmp21_, _data_->_tmp22_, _data_->_tmp27_);
				_g_free0 (_data_->_tmp26_);
				_data_->_tmp28_ = _data_->box;
				_data_->_tmp29_ = boxes_box_config_get_uuid (_data_->_tmp28_);
				_data_->_tmp30_ = _data_->_tmp29_;
				_data_->_tmp31_ = _data_->_tmp30_;
				_data_->_tmp32_ = boxes_get_screenshot_filename (_data_->_tmp31_);
				_data_->_tmp33_ = _data_->_tmp32_;
				_data_->_tmp34_ = g_file_new_for_path (_data_->_tmp33_);
				_data_->_tmp35_ = _data_->_tmp34_;
				_g_free0 (_data_->_tmp33_);
				_g_free0 (_data_->_tmp31_);
				_data_->file = _data_->_tmp35_;
				_data_->info = NULL;
				{
					_data_->_tmp37_ = _data_->file;
					_data_->_state_ = 1;
					g_file_query_info_async (_data_->_tmp37_, G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, boxes_search_provider_get_metas_ready, _data_);
					return FALSE;
					_state_1:
					_data_->_tmp38_ = g_file_query_info_finish (_data_->_tmp37_, _data_->_res_, &_data_->_inner_error0_);
					_data_->_tmp36_ = _data_->_tmp38_;
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_data_->_tmp39_ = _data_->_tmp36_;
					_data_->_tmp36_ = NULL;
					_g_object_unref0 (_data_->info);
					_data_->info = _data_->_tmp39_;
					_g_object_unref0 (_data_->_tmp36_);
				}
				goto __finally0;
				__catch0_g_error:
				{
					g_clear_error (&_data_->_inner_error0_);
				}
				__finally0:
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					_g_object_unref0 (_data_->info);
					_g_object_unref0 (_data_->file);
					_g_hash_table_unref0 (_data_->meta);
					_g_object_unref0 (_data_->box);
					_g_free0 (_data_->id);
					_data_->metas = (_vala_array_free (_data_->metas, _data_->metas_length1, (GDestroyNotify) g_hash_table_unref), NULL);
					_data_->ids = (_vala_array_free (_data_->ids, _data_->ids_length1, (GDestroyNotify) g_free), NULL);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp40_ = _data_->info;
				if (_data_->_tmp40_ != NULL) {
					_data_->_tmp41_ = _data_->file;
					_data_->_tmp42_ = (GFileIcon*) g_file_icon_new (_data_->_tmp41_);
					_data_->icon = _data_->_tmp42_;
					_data_->_tmp43_ = _data_->meta;
					_data_->_tmp44_ = g_strdup ("gicon");
					_data_->_tmp45_ = _data_->icon;
					_data_->_tmp46_ = g_icon_to_string ((GIcon*) _data_->_tmp45_);
					_data_->_tmp47_ = _data_->_tmp46_;
					_data_->_tmp48_ = g_variant_new_string (_data_->_tmp47_);
					g_variant_ref_sink (_data_->_tmp48_);
					g_hash_table_insert (_data_->_tmp43_, _data_->_tmp44_, _data_->_tmp48_);
					_g_free0 (_data_->_tmp47_);
					_g_object_unref0 (_data_->icon);
				} else {
					_data_->_tmp49_ = _data_->meta;
					_data_->_tmp50_ = g_strdup ("gicon");
					_data_->_tmp51_ = (GThemedIcon*) g_themed_icon_new ("gnome-boxes");
					_data_->_tmp52_ = _data_->_tmp51_;
					_data_->_tmp53_ = g_icon_to_string ((GIcon*) _data_->_tmp52_);
					_data_->_tmp54_ = _data_->_tmp53_;
					_data_->_tmp55_ = g_variant_new_string (_data_->_tmp54_);
					g_variant_ref_sink (_data_->_tmp55_);
					g_hash_table_insert (_data_->_tmp49_, _data_->_tmp50_, _data_->_tmp55_);
					_g_free0 (_data_->_tmp54_);
					_g_object_unref0 (_data_->_tmp52_);
				}
				_g_object_unref0 (_data_->info);
				_g_object_unref0 (_data_->file);
				_g_hash_table_unref0 (_data_->meta);
				_g_object_unref0 (_data_->box);
				_g_free0 (_data_->id);
			}
		}
	}
	_data_->_tmp56_ = _data_->self->priv->app;
	g_application_release ((GApplication*) _data_->_tmp56_);
	_data_->_tmp57_ = _data_->metas;
	_data_->_tmp57__length1 = _data_->metas_length1;
	_data_->_tmp58_ = (_data_->_tmp57_ != NULL) ? _vala_array_dup3 (_data_->_tmp57_ + 0, ((gint) _data_->n) - 0) : _data_->_tmp57_;
	_data_->_tmp58__length1 = ((gint) _data_->n) - 0;
	_data_->_tmp59_ = _data_->_tmp58_;
	_data_->_tmp59__length1 = _data_->_tmp58__length1;
	_data_->result_length1 = _data_->_tmp59__length1;
	_data_->result = _data_->_tmp59_;
	_data_->metas = (_vala_array_free (_data_->metas, _data_->metas_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	_data_->ids = (_vala_array_free (_data_->ids, _data_->ids_length1, (GDestroyNotify) g_free), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
boxes_search_provider_GetResultMetas_data_free (gpointer _data)
{
	boxes_search_provider_GetResultMetasData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (boxes_search_provider_GetResultMetasData, _data_);
}

void
boxes_search_provider_GetResultMetas (BoxesSearchProvider* self,
                                      gchar** ids,
                                      gint ids_length1,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	boxes_search_provider_GetResultMetasData* _data_;
	BoxesSearchProvider* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (boxes_search_provider_GetResultMetasData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_search_provider_GetResultMetas_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->ids = ids;
	_data_->ids_length1 = ids_length1;
	boxes_search_provider_GetResultMetas_co (_data_);
}

GHashTable**
boxes_search_provider_GetResultMetas_finish (BoxesSearchProvider* self,
                                             GAsyncResult* _res_,
                                             gint* result_length1,
                                             GError** error)
{
	GHashTable** result;
	boxes_search_provider_GetResultMetasData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static gchar**
_vala_array_dup4 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
boxes_search_provider_GetResultMetas_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	boxes_search_provider_GetResultMetasData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_search_provider_GetResultMetas_co (_data_);
}

static gboolean
boxes_search_provider_GetResultMetas_co (boxes_search_provider_GetResultMetasData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = (_data_->ids != NULL) ? _vala_array_dup4 (_data_->ids, _data_->ids_length1) : _data_->ids;
	_data_->_tmp1__length1 = _data_->ids_length1;
	_data_->_tmp2_ = 0;
	_data_->_state_ = 1;
	boxes_search_provider_get_metas (_data_->self, _data_->_tmp1_, (gint) _data_->_tmp1__length1, boxes_search_provider_GetResultMetas_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp3_ = boxes_search_provider_get_metas_finish (_data_->self, _data_->_res_, &_data_->_tmp2_, &_data_->_inner_error0_);
	_data_->_tmp0_ = _data_->_tmp3_;
	_data_->_tmp0__length1 = _data_->_tmp2_;
	_data_->__tmp0__size_ = _data_->_tmp0__length1;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->_tmp0_;
	_data_->_tmp4__length1 = _data_->_tmp0__length1;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0__length1 = 0;
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp5__length1 = _data_->_tmp4__length1;
	_data_->result_length1 = _data_->_tmp5__length1;
	_data_->result = _data_->_tmp5_;
	_data_->_tmp0_ = (_vala_array_free (_data_->_tmp0_, _data_->_tmp0__length1, (GDestroyNotify) g_hash_table_unref), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
boxes_search_provider_ActivateResult (BoxesSearchProvider* self,
                                      const gchar* search_id,
                                      gchar** terms,
                                      gint terms_length1,
                                      guint32 timestamp,
                                      GError** error)
{
	BoxesSearchProviderApp* _tmp0_;
	BoxesBoxConfig* box = NULL;
	GHashTable* _tmp1_;
	gconstpointer _tmp2_;
	BoxesBoxConfig* _tmp3_;
	BoxesBoxConfig* _tmp4_;
	gchar* uuid = NULL;
	BoxesBoxConfig* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	BoxesSearchProviderApp* _tmp21_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (search_id != NULL);
	_tmp0_ = self->priv->app;
	g_application_hold ((GApplication*) _tmp0_);
	g_debug ("gnome-boxes-search-provider.vala:133: ActivateResult (%s)", search_id);
	_tmp1_ = self->priv->boxes;
	_tmp2_ = g_hash_table_lookup (_tmp1_, search_id);
	_tmp3_ = _g_object_ref0 ((BoxesBoxConfig*) _tmp2_);
	box = _tmp3_;
	_tmp4_ = box;
	if (_tmp4_ == NULL) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		BoxesSearchProviderApp* _tmp7_;
		_tmp5_ = g_strconcat ("Can't find id: ", search_id, NULL);
		_tmp6_ = _tmp5_;
		g_warning ("gnome-boxes-search-provider.vala:137: %s", _tmp6_);
		_g_free0 (_tmp6_);
		_tmp7_ = self->priv->app;
		g_application_release ((GApplication*) _tmp7_);
		_g_object_unref0 (box);
		return;
	}
	_tmp8_ = box;
	_tmp9_ = boxes_box_config_get_uuid (_tmp8_);
	_tmp10_ = _tmp9_;
	uuid = _tmp10_;
	{
		gchar* cmd = NULL;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gboolean _tmp13_ = FALSE;
		const gchar* _tmp14_;
		_tmp11_ = uuid;
		_tmp12_ = g_strconcat ("gnome-boxes --open-uuid ", _tmp11_, NULL);
		cmd = _tmp12_;
		_tmp14_ = cmd;
		_tmp13_ = g_spawn_command_line_async (_tmp14_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (cmd);
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			_g_free0 (uuid);
			_g_object_unref0 (box);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		if (!_tmp13_) {
			FILE* _tmp15_;
			const gchar* _tmp16_;
			_tmp15_ = stderr;
			_tmp16_ = uuid;
			fprintf (_tmp15_, "Failed to launch Boxes with uuid '%s'\n", _tmp16_);
		}
		_g_free0 (cmd);
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* _error_ = NULL;
		FILE* _tmp17_;
		const gchar* _tmp18_;
		GError* _tmp19_;
		const gchar* _tmp20_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = stderr;
		_tmp18_ = uuid;
		fprintf (_tmp17_, "Failed to launch Boxes with uuid '%s'\n", _tmp18_);
		_tmp19_ = _error_;
		_tmp20_ = _tmp19_->message;
		g_warning ("gnome-boxes-search-provider.vala:149: %s", _tmp20_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (uuid);
		_g_object_unref0 (box);
		return;
	}
	_tmp21_ = self->priv->app;
	g_application_release ((GApplication*) _tmp21_);
	_g_free0 (uuid);
	_g_object_unref0 (box);
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
boxes_search_provider_LaunchSearch (BoxesSearchProvider* self,
                                    gchar** terms,
                                    gint terms_length1,
                                    guint32 timestamp,
                                    GError** error)
{
	BoxesSearchProviderApp* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	BoxesSearchProviderApp* _tmp15_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->app;
	g_application_hold ((GApplication*) _tmp0_);
	_tmp1_ = _vala_g_strjoinv (", ", terms, (gint) terms_length1);
	_tmp2_ = _tmp1_;
	g_debug ("gnome-boxes-search-provider.vala:158: LaunchSearch (%s)", _tmp2_);
	_g_free0 (_tmp2_);
	{
		gchar** args = NULL;
		gchar** _tmp3_;
		gint args_length1;
		gint _args_size_;
		gchar* _tmp4_;
		gboolean _tmp9_ = FALSE;
		gchar** _tmp10_;
		gint _tmp10__length1;
		_tmp3_ = g_new0 (gchar*, 0 + 1);
		args = _tmp3_;
		args_length1 = 0;
		_args_size_ = args_length1;
		_tmp4_ = g_strdup ("gnome-boxes");
		_vala_array_add1 (&args, &args_length1, &_args_size_, _tmp4_);
		{
			gchar** term_collection = NULL;
			gint term_collection_length1 = 0;
			gint _term_collection_size_ = 0;
			gint term_it = 0;
			term_collection = terms;
			term_collection_length1 = terms_length1;
			for (term_it = 0; term_it < term_collection_length1; term_it = term_it + 1) {
				gchar* _tmp5_;
				gchar* term = NULL;
				_tmp5_ = g_strdup (term_collection[term_it]);
				term = _tmp5_;
				{
					gchar* _tmp6_;
					const gchar* _tmp7_;
					gchar* _tmp8_;
					_tmp6_ = g_strdup ("--search");
					_vala_array_add2 (&args, &args_length1, &_args_size_, _tmp6_);
					_tmp7_ = term;
					_tmp8_ = g_strdup (_tmp7_);
					_vala_array_add3 (&args, &args_length1, &_args_size_, _tmp8_);
					_g_free0 (term);
				}
			}
		}
		_tmp10_ = args;
		_tmp10__length1 = args_length1;
		_tmp9_ = g_spawn_async (NULL, _tmp10_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		if (!_tmp9_) {
			FILE* _tmp11_;
			_tmp11_ = stderr;
			fprintf (_tmp11_, "Failed to launch Boxes for search\n");
		}
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* _error_ = NULL;
		FILE* _tmp12_;
		GError* _tmp13_;
		const gchar* _tmp14_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = stderr;
		fprintf (_tmp12_, "Failed to launch Boxes for search\n");
		_tmp13_ = _error_;
		_tmp14_ = _tmp13_->message;
		g_warning ("gnome-boxes-search-provider.vala:171: %s", _tmp14_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp15_ = self->priv->app;
	g_application_release ((GApplication*) _tmp15_);
}

gboolean
boxes_search_provider_get_loaded (BoxesSearchProvider* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_loaded;
	return result;
}

void
boxes_search_provider_set_loaded (BoxesSearchProvider* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = boxes_search_provider_get_loaded (self);
	if (old_value != value) {
		self->priv->_loaded = value;
		g_object_notify_by_pspec ((GObject *) self, boxes_search_provider_properties[BOXES_SEARCH_PROVIDER_LOADED_PROPERTY]);
	}
}

static void
boxes_search_provider_class_init (BoxesSearchProviderClass * klass,
                                  gpointer klass_data)
{
	boxes_search_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BoxesSearchProvider_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_boxes_search_provider_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_boxes_search_provider_set_property;
	G_OBJECT_CLASS (klass)->finalize = boxes_search_provider_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_SEARCH_PROVIDER_LOADED_PROPERTY, boxes_search_provider_properties[BOXES_SEARCH_PROVIDER_LOADED_PROPERTY] = g_param_spec_boolean ("loaded", "loaded", "loaded", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
boxes_search_provider_instance_init (BoxesSearchProvider * self,
                                     gpointer klass)
{
	self->priv = boxes_search_provider_get_instance_private (self);
}

static void
boxes_search_provider_finalize (GObject * obj)
{
	BoxesSearchProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_SEARCH_PROVIDER, BoxesSearchProvider);
	_g_object_unref0 (self->priv->app);
	_g_hash_table_unref0 (self->priv->boxes);
	G_OBJECT_CLASS (boxes_search_provider_parent_class)->finalize (obj);
}

static GType
boxes_search_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BoxesSearchProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_search_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesSearchProvider), 0, (GInstanceInitFunc) boxes_search_provider_instance_init, NULL };
	GType boxes_search_provider_type_id;
	boxes_search_provider_type_id = g_type_register_static (G_TYPE_OBJECT, "BoxesSearchProvider", &g_define_type_info, 0);
	g_type_set_qdata (boxes_search_provider_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) boxes_search_provider_register_object);
	BoxesSearchProvider_private_offset = g_type_add_instance_private (boxes_search_provider_type_id, sizeof (BoxesSearchProviderPrivate));
	return boxes_search_provider_type_id;
}

GType
boxes_search_provider_get_type (void)
{
	static volatile gsize boxes_search_provider_type_id__once = 0;
	if (g_once_init_enter (&boxes_search_provider_type_id__once)) {
		GType boxes_search_provider_type_id;
		boxes_search_provider_type_id = boxes_search_provider_get_type_once ();
		g_once_init_leave (&boxes_search_provider_type_id__once, boxes_search_provider_type_id);
	}
	return boxes_search_provider_type_id__once;
}

static void
_vala_boxes_search_provider_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	BoxesSearchProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_SEARCH_PROVIDER, BoxesSearchProvider);
	switch (property_id) {
		case BOXES_SEARCH_PROVIDER_LOADED_PROPERTY:
		g_value_set_boolean (value, boxes_search_provider_get_loaded (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_boxes_search_provider_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	BoxesSearchProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_SEARCH_PROVIDER, BoxesSearchProvider);
	switch (property_id) {
		case BOXES_SEARCH_PROVIDER_LOADED_PROPERTY:
		boxes_search_provider_set_loaded (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_dbus_boxes_search_provider_GetInitialResultSet (BoxesSearchProvider* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	boxes_search_provider_GetInitialResultSetReadyData* _ready_data;
	GVariant* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length;
	gint _tmp1__size;
	gint _tmp1__length1;
	GVariantIter _tmp2_;
	GVariant* _tmp3_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (boxes_search_provider_GetInitialResultSetReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp1_ = g_new (gchar*, 5);
	_tmp1__length = 0;
	_tmp1__size = 4;
	_tmp1__length1 = 0;
	g_variant_iter_init (&_tmp2_, _tmp0_);
	for (; (_tmp3_ = g_variant_iter_next_value (&_tmp2_)) != NULL; _tmp1__length1++) {
		if (_tmp1__size == _tmp1__length) {
			_tmp1__size = 2 * _tmp1__size;
			_tmp1_ = g_renew (gchar*, _tmp1_, _tmp1__size + 1);
		}
		_tmp1_[_tmp1__length++] = g_variant_dup_string (_tmp3_, NULL);
		g_variant_unref (_tmp3_);
	}
	_ready_data->terms_length1 = _tmp1__length1;
	_tmp1_[_tmp1__length] = NULL;
	_ready_data->terms = _tmp1_;
	g_variant_unref (_tmp0_);
	boxes_search_provider_GetInitialResultSet (self, _ready_data->terms, _ready_data->terms_length1, (GAsyncReadyCallback) _dbus_boxes_search_provider_GetInitialResultSet_ready, _ready_data);
	_error:
	;
}

static void
_dbus_boxes_search_provider_GetInitialResultSet_ready (GObject * source_object,
                                                       GAsyncResult * _res_,
                                                       gpointer _user_data_)
{
	boxes_search_provider_GetInitialResultSetReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp4_;
	GVariantBuilder _tmp5_;
	gint _tmp6_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = boxes_search_provider_GetInitialResultSet_finish ((BoxesSearchProvider*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp4_ = result;
	g_variant_builder_init (&_tmp5_, G_VARIANT_TYPE ("as"));
	for (_tmp6_ = 0; _tmp6_ < result_length1; _tmp6_++) {
		g_variant_builder_add_value (&_tmp5_, g_variant_new_string (*_tmp4_));
		_tmp4_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp5_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_ready_data->terms = (_vala_array_free (_ready_data->terms, _ready_data->terms_length1, (GDestroyNotify) g_free), NULL);
	g_slice_free (boxes_search_provider_GetInitialResultSetReadyData, _ready_data);
}

static void
_dbus_boxes_search_provider_GetSubsearchResultSet (BoxesSearchProvider* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	boxes_search_provider_GetSubsearchResultSetReadyData* _ready_data;
	GVariant* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length;
	gint _tmp8__size;
	gint _tmp8__length1;
	GVariantIter _tmp9_;
	GVariant* _tmp10_;
	GVariant* _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length;
	gint _tmp12__size;
	gint _tmp12__length1;
	GVariantIter _tmp13_;
	GVariant* _tmp14_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (boxes_search_provider_GetSubsearchResultSetReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp8_ = g_new (gchar*, 5);
	_tmp8__length = 0;
	_tmp8__size = 4;
	_tmp8__length1 = 0;
	g_variant_iter_init (&_tmp9_, _tmp7_);
	for (; (_tmp10_ = g_variant_iter_next_value (&_tmp9_)) != NULL; _tmp8__length1++) {
		if (_tmp8__size == _tmp8__length) {
			_tmp8__size = 2 * _tmp8__size;
			_tmp8_ = g_renew (gchar*, _tmp8_, _tmp8__size + 1);
		}
		_tmp8_[_tmp8__length++] = g_variant_dup_string (_tmp10_, NULL);
		g_variant_unref (_tmp10_);
	}
	_ready_data->previous_results_length1 = _tmp8__length1;
	_tmp8_[_tmp8__length] = NULL;
	_ready_data->previous_results = _tmp8_;
	g_variant_unref (_tmp7_);
	_tmp11_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp12_ = g_new (gchar*, 5);
	_tmp12__length = 0;
	_tmp12__size = 4;
	_tmp12__length1 = 0;
	g_variant_iter_init (&_tmp13_, _tmp11_);
	for (; (_tmp14_ = g_variant_iter_next_value (&_tmp13_)) != NULL; _tmp12__length1++) {
		if (_tmp12__size == _tmp12__length) {
			_tmp12__size = 2 * _tmp12__size;
			_tmp12_ = g_renew (gchar*, _tmp12_, _tmp12__size + 1);
		}
		_tmp12_[_tmp12__length++] = g_variant_dup_string (_tmp14_, NULL);
		g_variant_unref (_tmp14_);
	}
	_ready_data->new_terms_length1 = _tmp12__length1;
	_tmp12_[_tmp12__length] = NULL;
	_ready_data->new_terms = _tmp12_;
	g_variant_unref (_tmp11_);
	boxes_search_provider_GetSubsearchResultSet (self, _ready_data->previous_results, _ready_data->previous_results_length1, _ready_data->new_terms, _ready_data->new_terms_length1, (GAsyncReadyCallback) _dbus_boxes_search_provider_GetSubsearchResultSet_ready, _ready_data);
	_error:
	;
}

static void
_dbus_boxes_search_provider_GetSubsearchResultSet_ready (GObject * source_object,
                                                         GAsyncResult * _res_,
                                                         gpointer _user_data_)
{
	boxes_search_provider_GetSubsearchResultSetReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp15_;
	GVariantBuilder _tmp16_;
	gint _tmp17_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = boxes_search_provider_GetSubsearchResultSet_finish ((BoxesSearchProvider*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp15_ = result;
	g_variant_builder_init (&_tmp16_, G_VARIANT_TYPE ("as"));
	for (_tmp17_ = 0; _tmp17_ < result_length1; _tmp17_++) {
		g_variant_builder_add_value (&_tmp16_, g_variant_new_string (*_tmp15_));
		_tmp15_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp16_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_ready_data->previous_results = (_vala_array_free (_ready_data->previous_results, _ready_data->previous_results_length1, (GDestroyNotify) g_free), NULL);
	_ready_data->new_terms = (_vala_array_free (_ready_data->new_terms, _ready_data->new_terms_length1, (GDestroyNotify) g_free), NULL);
	g_slice_free (boxes_search_provider_GetSubsearchResultSetReadyData, _ready_data);
}

static void
_dbus_boxes_search_provider_get_metas (BoxesSearchProvider* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	BoxesSearchProviderGetMetasReadyData* _ready_data;
	GVariant* _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length;
	gint _tmp19__size;
	gint _tmp19__length1;
	GVariantIter _tmp20_;
	GVariant* _tmp21_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (BoxesSearchProviderGetMetasReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp18_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp19_ = g_new (gchar*, 5);
	_tmp19__length = 0;
	_tmp19__size = 4;
	_tmp19__length1 = 0;
	g_variant_iter_init (&_tmp20_, _tmp18_);
	for (; (_tmp21_ = g_variant_iter_next_value (&_tmp20_)) != NULL; _tmp19__length1++) {
		if (_tmp19__size == _tmp19__length) {
			_tmp19__size = 2 * _tmp19__size;
			_tmp19_ = g_renew (gchar*, _tmp19_, _tmp19__size + 1);
		}
		_tmp19_[_tmp19__length++] = g_variant_dup_string (_tmp21_, NULL);
		g_variant_unref (_tmp21_);
	}
	_ready_data->ids_length1 = _tmp19__length1;
	_tmp19_[_tmp19__length] = NULL;
	_ready_data->ids = _tmp19_;
	g_variant_unref (_tmp18_);
	boxes_search_provider_get_metas (self, _ready_data->ids, _ready_data->ids_length1, (GAsyncReadyCallback) _dbus_boxes_search_provider_get_metas_ready, _ready_data);
	_error:
	;
}

static void
_dbus_boxes_search_provider_get_metas_ready (GObject * source_object,
                                             GAsyncResult * _res_,
                                             gpointer _user_data_)
{
	BoxesSearchProviderGetMetasReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GHashTable** result;
	gint result_length1 = 0;
	GHashTable** _tmp22_;
	GVariantBuilder _tmp23_;
	gint _tmp24_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = boxes_search_provider_get_metas_finish ((BoxesSearchProvider*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp22_ = result;
	g_variant_builder_init (&_tmp23_, G_VARIANT_TYPE ("aa{sv}"));
	for (_tmp24_ = 0; _tmp24_ < result_length1; _tmp24_++) {
		GVariantBuilder _tmp25_;
		GHashTableIter _tmp26_;
		gpointer _tmp27_;
		gpointer _tmp28_;
		g_hash_table_iter_init (&_tmp26_, *_tmp22_);
		g_variant_builder_init (&_tmp25_, G_VARIANT_TYPE ("a{sv}"));
		while (g_hash_table_iter_next (&_tmp26_, &_tmp27_, &_tmp28_)) {
			gchar* _key;
			GVariant* _value;
			_key = (gchar*) _tmp27_;
			_value = (GVariant*) _tmp28_;
			g_variant_builder_add (&_tmp25_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
		}
		g_variant_builder_add_value (&_tmp23_, g_variant_builder_end (&_tmp25_));
		_tmp22_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp23_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_ready_data->ids = (_vala_array_free (_ready_data->ids, _ready_data->ids_length1, (GDestroyNotify) g_free), NULL);
	g_slice_free (BoxesSearchProviderGetMetasReadyData, _ready_data);
}

static void
_dbus_boxes_search_provider_GetResultMetas (BoxesSearchProvider* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	boxes_search_provider_GetResultMetasReadyData* _ready_data;
	GVariant* _tmp29_;
	gchar** _tmp30_;
	gint _tmp30__length;
	gint _tmp30__size;
	gint _tmp30__length1;
	GVariantIter _tmp31_;
	GVariant* _tmp32_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (boxes_search_provider_GetResultMetasReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp29_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp30_ = g_new (gchar*, 5);
	_tmp30__length = 0;
	_tmp30__size = 4;
	_tmp30__length1 = 0;
	g_variant_iter_init (&_tmp31_, _tmp29_);
	for (; (_tmp32_ = g_variant_iter_next_value (&_tmp31_)) != NULL; _tmp30__length1++) {
		if (_tmp30__size == _tmp30__length) {
			_tmp30__size = 2 * _tmp30__size;
			_tmp30_ = g_renew (gchar*, _tmp30_, _tmp30__size + 1);
		}
		_tmp30_[_tmp30__length++] = g_variant_dup_string (_tmp32_, NULL);
		g_variant_unref (_tmp32_);
	}
	_ready_data->ids_length1 = _tmp30__length1;
	_tmp30_[_tmp30__length] = NULL;
	_ready_data->ids = _tmp30_;
	g_variant_unref (_tmp29_);
	boxes_search_provider_GetResultMetas (self, _ready_data->ids, _ready_data->ids_length1, (GAsyncReadyCallback) _dbus_boxes_search_provider_GetResultMetas_ready, _ready_data);
	_error:
	;
}

static void
_dbus_boxes_search_provider_GetResultMetas_ready (GObject * source_object,
                                                  GAsyncResult * _res_,
                                                  gpointer _user_data_)
{
	boxes_search_provider_GetResultMetasReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GHashTable** result;
	gint result_length1 = 0;
	GHashTable** _tmp33_;
	GVariantBuilder _tmp34_;
	gint _tmp35_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = boxes_search_provider_GetResultMetas_finish ((BoxesSearchProvider*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp33_ = result;
	g_variant_builder_init (&_tmp34_, G_VARIANT_TYPE ("aa{sv}"));
	for (_tmp35_ = 0; _tmp35_ < result_length1; _tmp35_++) {
		GVariantBuilder _tmp36_;
		GHashTableIter _tmp37_;
		gpointer _tmp38_;
		gpointer _tmp39_;
		g_hash_table_iter_init (&_tmp37_, *_tmp33_);
		g_variant_builder_init (&_tmp36_, G_VARIANT_TYPE ("a{sv}"));
		while (g_hash_table_iter_next (&_tmp37_, &_tmp38_, &_tmp39_)) {
			gchar* _key;
			GVariant* _value;
			_key = (gchar*) _tmp38_;
			_value = (GVariant*) _tmp39_;
			g_variant_builder_add (&_tmp36_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
		}
		g_variant_builder_add_value (&_tmp34_, g_variant_builder_end (&_tmp36_));
		_tmp33_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp34_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_ready_data->ids = (_vala_array_free (_ready_data->ids, _ready_data->ids_length1, (GDestroyNotify) g_free), NULL);
	g_slice_free (boxes_search_provider_GetResultMetasReadyData, _ready_data);
}

static void
_dbus_boxes_search_provider_ActivateResult (BoxesSearchProvider* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* search_id = NULL;
	GVariant* _tmp40_;
	gchar** terms = NULL;
	gint terms_length1 = 0;
	GVariant* _tmp41_;
	gchar** _tmp42_;
	gint _tmp42__length;
	gint _tmp42__size;
	gint _tmp42__length1;
	GVariantIter _tmp43_;
	GVariant* _tmp44_;
	guint32 timestamp = 0U;
	GVariant* _tmp45_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp40_ = g_variant_iter_next_value (&_arguments_iter);
	search_id = g_variant_dup_string (_tmp40_, NULL);
	g_variant_unref (_tmp40_);
	_tmp41_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp42_ = g_new (gchar*, 5);
	_tmp42__length = 0;
	_tmp42__size = 4;
	_tmp42__length1 = 0;
	g_variant_iter_init (&_tmp43_, _tmp41_);
	for (; (_tmp44_ = g_variant_iter_next_value (&_tmp43_)) != NULL; _tmp42__length1++) {
		if (_tmp42__size == _tmp42__length) {
			_tmp42__size = 2 * _tmp42__size;
			_tmp42_ = g_renew (gchar*, _tmp42_, _tmp42__size + 1);
		}
		_tmp42_[_tmp42__length++] = g_variant_dup_string (_tmp44_, NULL);
		g_variant_unref (_tmp44_);
	}
	terms_length1 = _tmp42__length1;
	_tmp42_[_tmp42__length] = NULL;
	terms = _tmp42_;
	g_variant_unref (_tmp41_);
	_tmp45_ = g_variant_iter_next_value (&_arguments_iter);
	timestamp = g_variant_get_uint32 (_tmp45_);
	g_variant_unref (_tmp45_);
	boxes_search_provider_ActivateResult (self, search_id, terms, terms_length1, timestamp, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (search_id);
	terms = (_vala_array_free (terms, terms_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
_dbus_boxes_search_provider_LaunchSearch (BoxesSearchProvider* self,
                                          GVariant* _parameters_,
                                          GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar** terms = NULL;
	gint terms_length1 = 0;
	GVariant* _tmp46_;
	gchar** _tmp47_;
	gint _tmp47__length;
	gint _tmp47__size;
	gint _tmp47__length1;
	GVariantIter _tmp48_;
	GVariant* _tmp49_;
	guint32 timestamp = 0U;
	GVariant* _tmp50_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp46_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp47_ = g_new (gchar*, 5);
	_tmp47__length = 0;
	_tmp47__size = 4;
	_tmp47__length1 = 0;
	g_variant_iter_init (&_tmp48_, _tmp46_);
	for (; (_tmp49_ = g_variant_iter_next_value (&_tmp48_)) != NULL; _tmp47__length1++) {
		if (_tmp47__size == _tmp47__length) {
			_tmp47__size = 2 * _tmp47__size;
			_tmp47_ = g_renew (gchar*, _tmp47_, _tmp47__size + 1);
		}
		_tmp47_[_tmp47__length++] = g_variant_dup_string (_tmp49_, NULL);
		g_variant_unref (_tmp49_);
	}
	terms_length1 = _tmp47__length1;
	_tmp47_[_tmp47__length] = NULL;
	terms = _tmp47_;
	g_variant_unref (_tmp46_);
	_tmp50_ = g_variant_iter_next_value (&_arguments_iter);
	timestamp = g_variant_get_uint32 (_tmp50_);
	g_variant_unref (_tmp50_);
	boxes_search_provider_LaunchSearch (self, terms, terms_length1, timestamp, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	terms = (_vala_array_free (terms, terms_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
boxes_search_provider_dbus_interface_method_call (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* method_name,
                                                  GVariant* parameters,
                                                  GDBusMethodInvocation* invocation,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetInitialResultSet") == 0) {
		_dbus_boxes_search_provider_GetInitialResultSet (object, parameters, invocation);
	} else if (strcmp (method_name, "GetSubsearchResultSet") == 0) {
		_dbus_boxes_search_provider_GetSubsearchResultSet (object, parameters, invocation);
	} else if (strcmp (method_name, "GetMetas") == 0) {
		_dbus_boxes_search_provider_get_metas (object, parameters, invocation);
	} else if (strcmp (method_name, "GetResultMetas") == 0) {
		_dbus_boxes_search_provider_GetResultMetas (object, parameters, invocation);
	} else if (strcmp (method_name, "ActivateResult") == 0) {
		_dbus_boxes_search_provider_ActivateResult (object, parameters, invocation);
	} else if (strcmp (method_name, "LaunchSearch") == 0) {
		_dbus_boxes_search_provider_LaunchSearch (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
_dbus_boxes_search_provider_get_loaded (BoxesSearchProvider* self)
{
	gboolean result;
	GVariant* _reply;
	result = boxes_search_provider_get_loaded (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
boxes_search_provider_dbus_interface_get_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GError** error,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Loaded") == 0) {
		return _dbus_boxes_search_provider_get_loaded (object);
	}
	return NULL;
}

static void
_dbus_boxes_search_provider_set_loaded (BoxesSearchProvider* self,
                                        GVariant* _value)
{
	gboolean value = FALSE;
	value = g_variant_get_boolean (_value);
	boxes_search_provider_set_loaded (self, value);
}

static gboolean
boxes_search_provider_dbus_interface_set_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GVariant* value,
                                                   GError** error,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Loaded") == 0) {
		_dbus_boxes_search_provider_set_loaded (object, value);
		return TRUE;
	}
	return FALSE;
}

guint
boxes_search_provider_register_object (gpointer object,
                                       GDBusConnection* connection,
                                       const gchar* path,
                                       GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_boxes_search_provider_dbus_interface_info), &_boxes_search_provider_dbus_interface_vtable, data, _boxes_search_provider_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_boxes_search_provider_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

BoxesSearchProviderApp*
boxes_search_provider_app_construct (GType object_type)
{
	BoxesSearchProviderApp * self = NULL;
	self = (BoxesSearchProviderApp*) g_object_new (object_type, "application-id", "org.gnome.Boxes.SearchProvider", "flags", G_APPLICATION_IS_SERVICE, "inactivity-timeout", 10000, NULL);
	return self;
}

BoxesSearchProviderApp*
boxes_search_provider_app_new (void)
{
	return boxes_search_provider_app_construct (BOXES_TYPE_SEARCH_PROVIDER_APP);
}

static gboolean
boxes_search_provider_app_real_dbus_register (GApplication* base,
                                              GDBusConnection* connection,
                                              const gchar* object_path,
                                              GError** error)
{
	BoxesSearchProviderApp * self;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (BoxesSearchProviderApp*) base;
	g_return_val_if_fail (connection != NULL, FALSE);
	g_return_val_if_fail (object_path != NULL, FALSE);
	{
		BoxesSearchProvider* _tmp0_;
		BoxesSearchProvider* _tmp1_;
		_tmp0_ = boxes_search_provider_new (self);
		_tmp1_ = _tmp0_;
		boxes_search_provider_register_object (_tmp1_, connection, object_path, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp2_ = FALSE;
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* _error_ = NULL;
		FILE* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = stderr;
		_tmp4_ = _error_;
		_tmp5_ = _tmp4_->message;
		fprintf (_tmp3_, "Could not register service: %s", _tmp5_);
		g_application_quit ((GApplication*) self);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp6_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp6_;
	}
	result = TRUE;
	return result;
}

static void
boxes_search_provider_app_real_startup (GApplication* base)
{
	BoxesSearchProviderApp * self;
	const gchar* _tmp0_;
	self = (BoxesSearchProviderApp*) base;
	_tmp0_ = g_getenv ("BOXES_SEARCH_PROVIDER_PERSIST");
	if (_tmp0_ != NULL) {
		g_application_hold ((GApplication*) self);
	}
	G_APPLICATION_CLASS (boxes_search_provider_app_parent_class)->startup (G_TYPE_CHECK_INSTANCE_CAST (self, g_application_get_type (), GApplication));
}

static void
boxes_search_provider_app_class_init (BoxesSearchProviderAppClass * klass,
                                      gpointer klass_data)
{
	boxes_search_provider_app_parent_class = g_type_class_peek_parent (klass);
	((GApplicationClass *) klass)->dbus_register = (gboolean (*) (GApplication*, GDBusConnection*, const gchar*, GError**)) boxes_search_provider_app_real_dbus_register;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) boxes_search_provider_app_real_startup;
}

static void
boxes_search_provider_app_instance_init (BoxesSearchProviderApp * self,
                                         gpointer klass)
{
}

static GType
boxes_search_provider_app_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BoxesSearchProviderAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_search_provider_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesSearchProviderApp), 0, (GInstanceInitFunc) boxes_search_provider_app_instance_init, NULL };
	GType boxes_search_provider_app_type_id;
	boxes_search_provider_app_type_id = g_type_register_static (g_application_get_type (), "BoxesSearchProviderApp", &g_define_type_info, 0);
	return boxes_search_provider_app_type_id;
}

GType
boxes_search_provider_app_get_type (void)
{
	static volatile gsize boxes_search_provider_app_type_id__once = 0;
	if (g_once_init_enter (&boxes_search_provider_app_type_id__once)) {
		GType boxes_search_provider_app_type_id;
		boxes_search_provider_app_type_id = boxes_search_provider_app_get_type_once ();
		g_once_init_leave (&boxes_search_provider_app_type_id__once, boxes_search_provider_app_type_id);
	}
	return boxes_search_provider_app_type_id__once;
}

static gint
_vala_main (void)
{
	BoxesSearchProviderApp* _tmp0_;
	BoxesSearchProviderApp* _tmp1_;
	gint _tmp2_;
	gint result;
	_tmp0_ = boxes_search_provider_app_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_application_run ((GApplication*) _tmp1_, (gint) 0, NULL);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

int
main (int argc,
      char ** argv)
{
	return _vala_main ();
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

