/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the AMDGPU target                          *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 153;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(AMDGPUInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(AMDGPUInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static AMDGPUInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static AMDGPUInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testMOPredicate_MO(unsigned PredicateID, const MachineOperand &MO, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(6),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_p0s64,
  GILLT_p1s64,
  GILLT_p2s32,
  GILLT_p3s32,
  GILLT_p4s64,
  GILLT_p5s32,
  GILLT_p6s32,
  GILLT_s1,
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_v2s16,
  GILLT_v2s32,
  GILLT_v2s64,
  GILLT_v3s32,
  GILLT_v3s64,
  GILLT_v4s16,
  GILLT_v4s32,
  GILLT_v4s64,
  GILLT_v5s32,
  GILLT_v6s32,
  GILLT_v7s32,
  GILLT_v8s16,
  GILLT_v8s32,
  GILLT_v8s64,
  GILLT_v9s32,
  GILLT_v10s32,
  GILLT_v11s32,
  GILLT_v12s32,
  GILLT_v16s16,
  GILLT_v16s32,
  GILLT_v16s64,
  GILLT_v32s16,
  GILLT_v32s32,
};
const static size_t NumTypeObjects = 34;
const static LLT TypeObjects[] = {
  LLT::pointer(0, 64),
  LLT::pointer(1, 64),
  LLT::pointer(2, 32),
  LLT::pointer(3, 32),
  LLT::pointer(4, 64),
  LLT::pointer(5, 32),
  LLT::pointer(6, 32),
  LLT::scalar(1),
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::vector(ElementCount::getFixed(2), 16),
  LLT::vector(ElementCount::getFixed(2), 32),
  LLT::vector(ElementCount::getFixed(2), 64),
  LLT::vector(ElementCount::getFixed(3), 32),
  LLT::vector(ElementCount::getFixed(3), 64),
  LLT::vector(ElementCount::getFixed(4), 16),
  LLT::vector(ElementCount::getFixed(4), 32),
  LLT::vector(ElementCount::getFixed(4), 64),
  LLT::vector(ElementCount::getFixed(5), 32),
  LLT::vector(ElementCount::getFixed(6), 32),
  LLT::vector(ElementCount::getFixed(7), 32),
  LLT::vector(ElementCount::getFixed(8), 16),
  LLT::vector(ElementCount::getFixed(8), 32),
  LLT::vector(ElementCount::getFixed(8), 64),
  LLT::vector(ElementCount::getFixed(9), 32),
  LLT::vector(ElementCount::getFixed(10), 32),
  LLT::vector(ElementCount::getFixed(11), 32),
  LLT::vector(ElementCount::getFixed(12), 32),
  LLT::vector(ElementCount::getFixed(16), 16),
  LLT::vector(ElementCount::getFixed(16), 32),
  LLT::vector(ElementCount::getFixed(16), 64),
  LLT::vector(ElementCount::getFixed(32), 16),
  LLT::vector(ElementCount::getFixed(32), 32),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_FalsePredicateBit = 137,
  Feature_isGFX6Bit = 61,
  Feature_isGFX6GFX7Bit = 12,
  Feature_isGFX6GFX7GFX10Bit = 134,
  Feature_isGFX7OnlyBit = 102,
  Feature_isGFX7GFX10GFX11Bit = 116,
  Feature_isGFX7GFX8GFX9Bit = 56,
  Feature_isGFX6GFX7GFX8GFX9Bit = 77,
  Feature_isGFX6GFX7GFX8GFX9GFX10Bit = 149,
  Feature_isNotGFX12PlusBit = 26,
  Feature_isGFX8GFX9GFX10GFX11Bit = 28,
  Feature_isGFX7PlusBit = 18,
  Feature_isGFX8PlusBit = 4,
  Feature_isGFX8OnlyBit = 29,
  Feature_isGFX9PlusBit = 0,
  Feature_isNotGFX9PlusBit = 67,
  Feature_isGFX90APlusBit = 49,
  Feature_isNotGFX90APlusBit = 30,
  Feature_isGFX908orGFX90ABit = 50,
  Feature_isGFX940PlusBit = 51,
  Feature_isNotGFX940PlusBit = 62,
  Feature_HasGFX950InstsBit = 35,
  Feature_isGFX8GFX9Bit = 21,
  Feature_isGFX10OnlyBit = 20,
  Feature_isGFX10PlusBit = 9,
  Feature_isGFX9GFX10Bit = 68,
  Feature_isGFX11OnlyBit = 74,
  Feature_isGFX11PlusBit = 1,
  Feature_isGFX12OnlyBit = 75,
  Feature_isGFX12PlusBit = 3,
  Feature_isGFX12PlusNot12_50Bit = 73,
  Feature_isGFX125xOnlyBit = 36,
  Feature_isGFX1250PlusBit = 8,
  Feature_isNotGFX1250PlusBit = 5,
  Feature_HasIEEEMinimumMaximumInstsBit = 23,
  Feature_HasMinimum3Maximum3F32Bit = 27,
  Feature_HasMinimum3Maximum3F16Bit = 32,
  Feature_HasMin3Max3PKF16Bit = 42,
  Feature_HasMinimum3Maximum3PKF16Bit = 43,
  Feature_HasFlatAddressSpaceBit = 104,
  Feature_HasFlatBufferGlobalAtomicFaddF64InstBit = 122,
  Feature_HasAtomicFMinFMaxF32GlobalInstsBit = 130,
  Feature_HasAtomicFMinFMaxF64GlobalInstsBit = 121,
  Feature_HasAtomicFMinFMaxF32FlatInstsBit = 111,
  Feature_HasAtomicFMinFMaxF64FlatInstsBit = 112,
  Feature_HasLdsAtomicAddF64Bit = 152,
  Feature_HasFlatGlobalInstsBit = 106,
  Feature_HasFlatScratchInstsBit = 109,
  Feature_HasD16LoadStoreBit = 114,
  Feature_HasFlatScratchSVSModeBit = 110,
  Feature_HasFlatGVSModeBit = 105,
  Feature_HasGFX10_BEncodingBit = 60,
  Feature_HasUnpackedD16VMemBit = 128,
  Feature_HasPackedD16VMemBit = 129,
  Feature_HasUnrestrictedSOffsetBit = 126,
  Feature_D16PreservesUnusedBitsBit = 107,
  Feature_LDSRequiresM0InitBit = 144,
  Feature_NotLDSRequiresM0InitBit = 145,
  Feature_HasMTBUFInstsBit = 132,
  Feature_HasFormattedMUBUFInstsBit = 127,
  Feature_HasExportInstsBit = 11,
  Feature_HasLDSFPAtomicAddF32Bit = 151,
  Feature_HasAddNoCarryInstsBit = 76,
  Feature_NotHasAddNoCarryInstsBit = 142,
  Feature_HasXNACKEnabledBit = 101,
  Feature_Has16BitInstsBit = 13,
  Feature_NotHasTrue16BitInstsBit = 14,
  Feature_UseRealTrue16InstsBit = 15,
  Feature_UseFakeTrue16InstsBit = 16,
  Feature_HasVOP3PInstsBit = 93,
  Feature_HasMed3_16Bit = 143,
  Feature_HasMinMaxDenormModesBit = 136,
  Feature_NotHasMinMaxDenormModesBit = 138,
  Feature_HasSDWABit = 72,
  Feature_HasPackedFP32OpsBit = 54,
  Feature_HasAddMinMaxInstsBit = 87,
  Feature_HasPkAddMinMaxInstsBit = 97,
  Feature_HasPkMinMax3InstsBit = 98,
  Feature_HasSGetShaderCyclesInstBit = 7,
  Feature_HasImageInstsBit = 10,
  Feature_HasIntClampBit = 82,
  Feature_HasMadMixInstsBit = 94,
  Feature_HasScalarStoresBit = 57,
  Feature_has16BankLDSBit = 63,
  Feature_has32BankLDSBit = 31,
  Feature_HasFmaMixInstsBit = 96,
  Feature_HasDLInstsBit = 22,
  Feature_HasFmacF64InstBit = 141,
  Feature_HasDot1InstsBit = 47,
  Feature_HasDot2InstsBit = 44,
  Feature_HasDot3InstsBit = 81,
  Feature_HasDot4InstsBit = 80,
  Feature_HasDot5InstsBit = 78,
  Feature_HasDot6InstsBit = 79,
  Feature_HasDot7InstsBit = 46,
  Feature_HasDot8InstsBit = 99,
  Feature_HasDot9InstsBit = 39,
  Feature_HasDot10InstsBit = 45,
  Feature_HasDot11InstsBit = 100,
  Feature_HasGetWaveIdInstBit = 59,
  Feature_HasMAIInstsBit = 48,
  Feature_HasSMemRealTimeBit = 58,
  Feature_HasSMemTimeInstBit = 55,
  Feature_HasShaderCyclesRegisterBit = 103,
  Feature_HasShaderCyclesHiLoRegistersBit = 65,
  Feature_HasFP8InstsBit = 53,
  Feature_HasFP8ConversionInstsBit = 70,
  Feature_HasFP8E5M3InstsBit = 83,
  Feature_NotHasFP8E5M3InstsBit = 84,
  Feature_HasMadMacF32InstsBit = 24,
  Feature_HasFmaLegacy32Bit = 25,
  Feature_HasAtomicDsPkAdd16InstsBit = 150,
  Feature_HasAtomicFlatPkAdd16InstsBit = 124,
  Feature_HasAtomicFaddRtnInstsBit = 119,
  Feature_HasAtomicFaddNoRtnInstsBit = 117,
  Feature_HasAtomicBufferGlobalPkAddF16NoRtnInstsBit = 118,
  Feature_HasAtomicBufferGlobalPkAddF16InstsBit = 120,
  Feature_HasFlatAtomicFaddF32InstBit = 123,
  Feature_EnableFlatScratchBit = 108,
  Feature_DisableFlatScratchBit = 131,
  Feature_HasUnalignedAccessModeBit = 148,
  Feature_HasMADIntraFwdBugBit = 89,
  Feature_HasNotMADIntraFwdBugBit = 88,
  Feature_HasSALUFloatInstsBit = 2,
  Feature_NotHasSALUFloatInstsBit = 133,
  Feature_HasPseudoScalarTransBit = 40,
  Feature_HasBitOp3InstsBit = 91,
  Feature_HasTanhInstsBit = 17,
  Feature_HasTensorCvtLutInstsBit = 38,
  Feature_HasTransposeLoadF4F6InstsBit = 115,
  Feature_HasPrngInstBit = 19,
  Feature_Has64BitLiteralsBit = 66,
  Feature_HasFP6BF6ConversionScaleInstsBit = 33,
  Feature_HasF16BF16ToFP6BF6ConversionScaleInstsBit = 34,
  Feature_HasCvtPkF16F32InstBit = 90,
  Feature_HasF32ToF16BF16ConversionSRInstsBit = 92,
  Feature_HasGDSBit = 146,
  Feature_HasCvtFP8VOP1BugBit = 69,
  Feature_HasNoCvtFP8VOP1BugBit = 71,
  Feature_HasAtomicCSubNoRtnInstsBit = 113,
  Feature_HasXF32InstsBit = 52,
  Feature_HasVmemPrefInstsBit = 125,
  Feature_HasAshrPkInstsBit = 41,
  Feature_HasLshlAddU64InstBit = 86,
  Feature_HasMadU32InstBit = 85,
  Feature_HasLdsBarrierArriveAtomicBit = 147,
  Feature_HasSetPrioIncWgInstBit = 6,
  Feature_FP16DenormalsBit = 140,
  Feature_FP64DenormalsBit = 139,
  Feature_NoFP32DenormalsBit = 95,
  Feature_IEEEModeDisabledBit = 135,
  Feature_isWave32Bit = 37,
  Feature_isWave64Bit = 64,
};

PredicateBitset AMDGPUInstructionSelector::
computeAvailableModuleFeatures(const AMDGPUSubtarget *Subtarget) const {
  PredicateBitset Features{};
  if (false)
    Features.set(Feature_FalsePredicateBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS)
    Features.set(Feature_isGFX6Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
    Features.set(Feature_isGFX6GFX7Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX6GFX7GFX10Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
    Features.set(Feature_isGFX7OnlyBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX10 ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX11)
    Features.set(Feature_isGFX7GFX10GFX11Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX7GFX8GFX9Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX6GFX7GFX8GFX9Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9 ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX6GFX7GFX8GFX9GFX10Bit);
  if (Subtarget->getGeneration() <= AMDGPUSubtarget::GFX11)
    Features.set(Feature_isNotGFX12PlusBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9 ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX10 ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX11)
    Features.set(Feature_isGFX8GFX9GFX10GFX11Bit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::SEA_ISLANDS)
    Features.set(Feature_isGFX7PlusBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
    Features.set(Feature_isGFX8PlusBit);
  if (Subtarget->getGeneration() ==AMDGPUSubtarget::VOLCANIC_ISLANDS)
    Features.set(Feature_isGFX8OnlyBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX9PlusBit);
  if (Subtarget->getGeneration() < AMDGPUSubtarget::GFX9)
    Features.set(Feature_isNotGFX9PlusBit);
  if (Subtarget->hasGFX90AInsts())
    Features.set(Feature_isGFX90APlusBit);
  if (!Subtarget->hasGFX90AInsts())
    Features.set(Feature_isNotGFX90APlusBit);
  if (Subtarget->hasMAIInsts() && !Subtarget->hasGFX940Insts())
    Features.set(Feature_isGFX908orGFX90ABit);
  if (Subtarget->hasGFX940Insts())
    Features.set(Feature_isGFX940PlusBit);
  if (!Subtarget->hasGFX940Insts())
    Features.set(Feature_isNotGFX940PlusBit);
  if (Subtarget->hasGFX950Insts())
    Features.set(Feature_HasGFX950InstsBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX8GFX9Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX10OnlyBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX10PlusBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::GFX9 ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX9GFX10Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::GFX11)
    Features.set(Feature_isGFX11OnlyBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX11)
    Features.set(Feature_isGFX11PlusBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::GFX12)
    Features.set(Feature_isGFX12OnlyBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX12)
    Features.set(Feature_isGFX12PlusBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX12 && !Subtarget->hasGFX1250Insts())
    Features.set(Feature_isGFX12PlusNot12_50Bit);
  if (Subtarget->hasGFX1250Insts())
    Features.set(Feature_isGFX125xOnlyBit);
  if (Subtarget->hasGFX1250Insts())
    Features.set(Feature_isGFX1250PlusBit);
  if (!Subtarget->hasGFX1250Insts())
    Features.set(Feature_isNotGFX1250PlusBit);
  if (Subtarget->hasIEEEMinimumMaximumInsts())
    Features.set(Feature_HasIEEEMinimumMaximumInstsBit);
  if (Subtarget->hasMinimum3Maximum3F32())
    Features.set(Feature_HasMinimum3Maximum3F32Bit);
  if (Subtarget->hasMinimum3Maximum3F16())
    Features.set(Feature_HasMinimum3Maximum3F16Bit);
  if (Subtarget->hasMin3Max3PKF16())
    Features.set(Feature_HasMin3Max3PKF16Bit);
  if (Subtarget->hasMinimum3Maximum3PKF16())
    Features.set(Feature_HasMinimum3Maximum3PKF16Bit);
  if (Subtarget->hasFlatAddressSpace())
    Features.set(Feature_HasFlatAddressSpaceBit);
  if (Subtarget->hasFlatBufferGlobalAtomicFaddF64Inst())
    Features.set(Feature_HasFlatBufferGlobalAtomicFaddF64InstBit);
  if (Subtarget->hasAtomicFMinFMaxF32GlobalInsts())
    Features.set(Feature_HasAtomicFMinFMaxF32GlobalInstsBit);
  if (Subtarget->hasAtomicFMinFMaxF64GlobalInsts())
    Features.set(Feature_HasAtomicFMinFMaxF64GlobalInstsBit);
  if (Subtarget->hasAtomicFMinFMaxF32FlatInsts())
    Features.set(Feature_HasAtomicFMinFMaxF32FlatInstsBit);
  if (Subtarget->hasAtomicFMinFMaxF64FlatInsts())
    Features.set(Feature_HasAtomicFMinFMaxF64FlatInstsBit);
  if (Subtarget->hasLdsAtomicAddF64())
    Features.set(Feature_HasLdsAtomicAddF64Bit);
  if (Subtarget->hasFlatGlobalInsts())
    Features.set(Feature_HasFlatGlobalInstsBit);
  if (Subtarget->hasFlatScratchInsts())
    Features.set(Feature_HasFlatScratchInstsBit);
  if (Subtarget->hasD16LoadStore())
    Features.set(Feature_HasD16LoadStoreBit);
  if (Subtarget->hasFlatScratchSVSMode())
    Features.set(Feature_HasFlatScratchSVSModeBit);
  if (Subtarget->hasFlatGVSMode())
    Features.set(Feature_HasFlatGVSModeBit);
  if (Subtarget->hasGFX10_BEncoding())
    Features.set(Feature_HasGFX10_BEncodingBit);
  if (Subtarget->hasUnpackedD16VMem())
    Features.set(Feature_HasUnpackedD16VMemBit);
  if (!Subtarget->hasUnpackedD16VMem())
    Features.set(Feature_HasPackedD16VMemBit);
  if (!Subtarget->hasRestrictedSOffset())
    Features.set(Feature_HasUnrestrictedSOffsetBit);
  if (Subtarget->d16PreservesUnusedBits())
    Features.set(Feature_D16PreservesUnusedBitsBit);
  if (Subtarget->ldsRequiresM0Init())
    Features.set(Feature_LDSRequiresM0InitBit);
  if (!Subtarget->ldsRequiresM0Init())
    Features.set(Feature_NotLDSRequiresM0InitBit);
  if (Subtarget->hasMTBUFInsts())
    Features.set(Feature_HasMTBUFInstsBit);
  if (Subtarget->hasFormattedMUBUFInsts())
    Features.set(Feature_HasFormattedMUBUFInstsBit);
  if (Subtarget->hasExportInsts())
    Features.set(Feature_HasExportInstsBit);
  if (Subtarget->hasLDSFPAtomicAddF32())
    Features.set(Feature_HasLDSFPAtomicAddF32Bit);
  if (Subtarget->hasAddNoCarry())
    Features.set(Feature_HasAddNoCarryInstsBit);
  if (!Subtarget->hasAddNoCarry())
    Features.set(Feature_NotHasAddNoCarryInstsBit);
  if (Subtarget->isXNACKEnabled())
    Features.set(Feature_HasXNACKEnabledBit);
  if (Subtarget->has16BitInsts())
    Features.set(Feature_Has16BitInstsBit);
  if (!Subtarget->hasTrue16BitInsts())
    Features.set(Feature_NotHasTrue16BitInstsBit);
  if (Subtarget->useRealTrue16Insts())
    Features.set(Feature_UseRealTrue16InstsBit);
  if (Subtarget->hasTrue16BitInsts() && !Subtarget->useRealTrue16Insts())
    Features.set(Feature_UseFakeTrue16InstsBit);
  if (Subtarget->hasVOP3PInsts())
    Features.set(Feature_HasVOP3PInstsBit);
  if (Subtarget->hasMed3_16())
    Features.set(Feature_HasMed3_16Bit);
  if (Subtarget->supportsMinMaxDenormModes())
    Features.set(Feature_HasMinMaxDenormModesBit);
  if (!Subtarget->supportsMinMaxDenormModes())
    Features.set(Feature_NotHasMinMaxDenormModesBit);
  if (Subtarget->hasSDWA())
    Features.set(Feature_HasSDWABit);
  if (Subtarget->hasPackedFP32Ops())
    Features.set(Feature_HasPackedFP32OpsBit);
  if (Subtarget->hasAddMinMaxInsts())
    Features.set(Feature_HasAddMinMaxInstsBit);
  if (Subtarget->hasPkAddMinMaxInsts())
    Features.set(Feature_HasPkAddMinMaxInstsBit);
  if (Subtarget->hasPkMinMax3Insts())
    Features.set(Feature_HasPkMinMax3InstsBit);
  if (Subtarget->hasSGetShaderCyclesInst())
    Features.set(Feature_HasSGetShaderCyclesInstBit);
  if (Subtarget->hasImageInsts())
    Features.set(Feature_HasImageInstsBit);
  if (Subtarget->hasIntClamp())
    Features.set(Feature_HasIntClampBit);
  if (Subtarget->hasMadMixInsts())
    Features.set(Feature_HasMadMixInstsBit);
  if (Subtarget->hasScalarStores())
    Features.set(Feature_HasScalarStoresBit);
  if (Subtarget->getLDSBankCount() == 16)
    Features.set(Feature_has16BankLDSBit);
  if (Subtarget->getLDSBankCount() == 32)
    Features.set(Feature_has32BankLDSBit);
  if (Subtarget->hasFmaMixInsts())
    Features.set(Feature_HasFmaMixInstsBit);
  if (Subtarget->hasDLInsts())
    Features.set(Feature_HasDLInstsBit);
  if (Subtarget->hasFmacF64Inst())
    Features.set(Feature_HasFmacF64InstBit);
  if (Subtarget->hasDot1Insts())
    Features.set(Feature_HasDot1InstsBit);
  if (Subtarget->hasDot2Insts())
    Features.set(Feature_HasDot2InstsBit);
  if (Subtarget->hasDot3Insts())
    Features.set(Feature_HasDot3InstsBit);
  if (Subtarget->hasDot4Insts())
    Features.set(Feature_HasDot4InstsBit);
  if (Subtarget->hasDot5Insts())
    Features.set(Feature_HasDot5InstsBit);
  if (Subtarget->hasDot6Insts())
    Features.set(Feature_HasDot6InstsBit);
  if (Subtarget->hasDot7Insts())
    Features.set(Feature_HasDot7InstsBit);
  if (Subtarget->hasDot8Insts())
    Features.set(Feature_HasDot8InstsBit);
  if (Subtarget->hasDot9Insts())
    Features.set(Feature_HasDot9InstsBit);
  if (Subtarget->hasDot10Insts())
    Features.set(Feature_HasDot10InstsBit);
  if (Subtarget->hasDot11Insts())
    Features.set(Feature_HasDot11InstsBit);
  if (Subtarget->hasGetWaveIdInst())
    Features.set(Feature_HasGetWaveIdInstBit);
  if (Subtarget->hasMAIInsts())
    Features.set(Feature_HasMAIInstsBit);
  if (Subtarget->hasSMemRealTime())
    Features.set(Feature_HasSMemRealTimeBit);
  if (Subtarget->hasSMemTimeInst())
    Features.set(Feature_HasSMemTimeInstBit);
  if (Subtarget->hasShaderCyclesRegister())
    Features.set(Feature_HasShaderCyclesRegisterBit);
  if (Subtarget->hasShaderCyclesHiLoRegisters())
    Features.set(Feature_HasShaderCyclesHiLoRegistersBit);
  if (Subtarget->hasFP8Insts())
    Features.set(Feature_HasFP8InstsBit);
  if (Subtarget->hasFP8ConversionInsts())
    Features.set(Feature_HasFP8ConversionInstsBit);
  if (Subtarget->hasFP8E5M3Insts())
    Features.set(Feature_HasFP8E5M3InstsBit);
  if (!Subtarget->hasFP8E5M3Insts())
    Features.set(Feature_NotHasFP8E5M3InstsBit);
  if (Subtarget->hasMadMacF32Insts())
    Features.set(Feature_HasMadMacF32InstsBit);
  if (Subtarget->hasGFX10_3Insts())
    Features.set(Feature_HasFmaLegacy32Bit);
  if (Subtarget->hasAtomicDsPkAdd16Insts())
    Features.set(Feature_HasAtomicDsPkAdd16InstsBit);
  if (Subtarget->hasAtomicFlatPkAdd16Insts())
    Features.set(Feature_HasAtomicFlatPkAdd16InstsBit);
  if (Subtarget->hasAtomicFaddRtnInsts())
    Features.set(Feature_HasAtomicFaddRtnInstsBit);
  if (Subtarget->hasAtomicFaddNoRtnInsts())
    Features.set(Feature_HasAtomicFaddNoRtnInstsBit);
  if (Subtarget->hasAtomicBufferGlobalPkAddF16NoRtnInsts() || Subtarget->hasAtomicBufferGlobalPkAddF16Insts())
    Features.set(Feature_HasAtomicBufferGlobalPkAddF16NoRtnInstsBit);
  if (Subtarget->hasAtomicBufferGlobalPkAddF16Insts())
    Features.set(Feature_HasAtomicBufferGlobalPkAddF16InstsBit);
  if (Subtarget->hasFlatAtomicFaddF32Inst())
    Features.set(Feature_HasFlatAtomicFaddF32InstBit);
  if (Subtarget->enableFlatScratch())
    Features.set(Feature_EnableFlatScratchBit);
  if (!Subtarget->enableFlatScratch())
    Features.set(Feature_DisableFlatScratchBit);
  if (Subtarget->hasUnalignedAccessMode())
    Features.set(Feature_HasUnalignedAccessModeBit);
  if (Subtarget->hasMADIntraFwdBug())
    Features.set(Feature_HasMADIntraFwdBugBit);
  if (!Subtarget->hasMADIntraFwdBug())
    Features.set(Feature_HasNotMADIntraFwdBugBit);
  if (Subtarget->hasSALUFloatInsts())
    Features.set(Feature_HasSALUFloatInstsBit);
  if (!Subtarget->hasSALUFloatInsts())
    Features.set(Feature_NotHasSALUFloatInstsBit);
  if (Subtarget->hasPseudoScalarTrans())
    Features.set(Feature_HasPseudoScalarTransBit);
  if (Subtarget->hasBitOp3Insts())
    Features.set(Feature_HasBitOp3InstsBit);
  if (Subtarget->hasTanhInsts())
    Features.set(Feature_HasTanhInstsBit);
  if (Subtarget->hasTensorCvtLutInsts())
    Features.set(Feature_HasTensorCvtLutInstsBit);
  if (Subtarget->hasTransposeLoadF4F6Insts())
    Features.set(Feature_HasTransposeLoadF4F6InstsBit);
  if (Subtarget->hasPrngInst())
    Features.set(Feature_HasPrngInstBit);
  if (Subtarget->has64BitLiterals())
    Features.set(Feature_Has64BitLiteralsBit);
  if (Subtarget->hasFP6BF6ConversionScaleInsts())
    Features.set(Feature_HasFP6BF6ConversionScaleInstsBit);
  if (Subtarget->hasF16BF16ToFP6BF6ConversionScaleInsts())
    Features.set(Feature_HasF16BF16ToFP6BF6ConversionScaleInstsBit);
  if (Subtarget->hasCvtPkF16F32Inst())
    Features.set(Feature_HasCvtPkF16F32InstBit);
  if (Subtarget->hasF32ToF16BF16ConversionSRInsts())
    Features.set(Feature_HasF32ToF16BF16ConversionSRInstsBit);
  if (Subtarget->hasGDS())
    Features.set(Feature_HasGDSBit);
  if (Subtarget->hasCvtFP8VOP1Bug())
    Features.set(Feature_HasCvtFP8VOP1BugBit);
  if (!Subtarget->hasCvtFP8VOP1Bug())
    Features.set(Feature_HasNoCvtFP8VOP1BugBit);
  if (Subtarget->hasAtomicCSubNoRtnInsts())
    Features.set(Feature_HasAtomicCSubNoRtnInstsBit);
  if (Subtarget->hasXF32Insts())
    Features.set(Feature_HasXF32InstsBit);
  if (Subtarget->hasVmemPrefInsts())
    Features.set(Feature_HasVmemPrefInstsBit);
  if (Subtarget->hasAshrPkInsts())
    Features.set(Feature_HasAshrPkInstsBit);
  if (Subtarget->hasLshlAddU64Inst())
    Features.set(Feature_HasLshlAddU64InstBit);
  if (Subtarget->hasMadU32Inst())
    Features.set(Feature_HasMadU32InstBit);
  if (Subtarget->hasLdsBarrierArriveAtomic())
    Features.set(Feature_HasLdsBarrierArriveAtomicBit);
  if (Subtarget->hasSetPrioIncWgInst())
    Features.set(Feature_HasSetPrioIncWgInstBit);
  if (Subtarget->isWave32())
    Features.set(Feature_isWave32Bit);
  if (Subtarget->isWave64())
    Features.set(Feature_isWave64Bit);
  return Features;
}

void AMDGPUInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const AMDGPUSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset AMDGPUInstructionSelector::
computeAvailableFunctionFeatures(const AMDGPUSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  if (MF->getInfo<SIMachineFunctionInfo>()->getMode().FP64FP16Denormals != DenormalMode::getPreserveSign())
    Features.set(Feature_FP16DenormalsBit);
  if (MF->getInfo<SIMachineFunctionInfo>()->getMode().FP64FP16Denormals != DenormalMode::getPreserveSign())
    Features.set(Feature_FP64DenormalsBit);
  if (MF->getInfo<SIMachineFunctionInfo>()->getMode().FP32Denormals == DenormalMode::getPreserveSign())
    Features.set(Feature_NoFP32DenormalsBit);
  if (!MF->getInfo<SIMachineFunctionInfo>()->getMode().IEEE)
    Features.set(Feature_IEEEModeDisabledBit);
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_D16PreservesUnusedBits,
  GIFBS_DisableFlatScratch,
  GIFBS_Has16BitInsts,
  GIFBS_HasAddMinMaxInsts,
  GIFBS_HasAddNoCarryInsts,
  GIFBS_HasAshrPkInsts,
  GIFBS_HasAtomicBufferGlobalPkAddF16Insts,
  GIFBS_HasAtomicBufferGlobalPkAddF16NoRtnInsts,
  GIFBS_HasAtomicCSubNoRtnInsts,
  GIFBS_HasAtomicDsPkAdd16Insts,
  GIFBS_HasAtomicFMinFMaxF32FlatInsts,
  GIFBS_HasAtomicFMinFMaxF32GlobalInsts,
  GIFBS_HasAtomicFMinFMaxF64FlatInsts,
  GIFBS_HasAtomicFMinFMaxF64GlobalInsts,
  GIFBS_HasAtomicFaddNoRtnInsts,
  GIFBS_HasAtomicFaddRtnInsts,
  GIFBS_HasAtomicFlatPkAdd16Insts,
  GIFBS_HasBitOp3Insts,
  GIFBS_HasCvtPkF16F32Inst,
  GIFBS_HasD16LoadStore,
  GIFBS_HasDLInsts,
  GIFBS_HasDot10Insts,
  GIFBS_HasDot1Insts,
  GIFBS_HasDot2Insts,
  GIFBS_HasDot3Insts,
  GIFBS_HasDot4Insts,
  GIFBS_HasDot5Insts,
  GIFBS_HasDot6Insts,
  GIFBS_HasDot7Insts,
  GIFBS_HasDot8Insts,
  GIFBS_HasF16BF16ToFP6BF6ConversionScaleInsts,
  GIFBS_HasF32ToF16BF16ConversionSRInsts,
  GIFBS_HasFP6BF6ConversionScaleInsts,
  GIFBS_HasFP8Insts,
  GIFBS_HasFlatAddressSpace,
  GIFBS_HasFlatAtomicFaddF32Inst,
  GIFBS_HasFlatBufferGlobalAtomicFaddF64Inst,
  GIFBS_HasFlatGVSMode,
  GIFBS_HasFlatGlobalInsts,
  GIFBS_HasFmaLegacy32,
  GIFBS_HasFmaMixInsts,
  GIFBS_HasFmacF64Inst,
  GIFBS_HasFormattedMUBUFInsts,
  GIFBS_HasGDS,
  GIFBS_HasGFX10_BEncoding,
  GIFBS_HasGFX950Insts,
  GIFBS_HasGetWaveIdInst,
  GIFBS_HasIEEEMinimumMaximumInsts,
  GIFBS_HasIntClamp,
  GIFBS_HasLdsAtomicAddF64,
  GIFBS_HasLshlAddU64Inst,
  GIFBS_HasMAIInsts,
  GIFBS_HasMTBUFInsts,
  GIFBS_HasMadMacF32Insts,
  GIFBS_HasMadU32Inst,
  GIFBS_HasMinMaxDenormModes,
  GIFBS_HasMinimum3Maximum3F32,
  GIFBS_HasMinimum3Maximum3PKF16,
  GIFBS_HasPackedFP32Ops,
  GIFBS_HasPkAddMinMaxInsts,
  GIFBS_HasPkMinMax3Insts,
  GIFBS_HasPrngInst,
  GIFBS_HasPseudoScalarTrans,
  GIFBS_HasSALUFloatInsts,
  GIFBS_HasSGetShaderCyclesInst,
  GIFBS_HasSMemRealTime,
  GIFBS_HasSMemTimeInst,
  GIFBS_HasSetPrioIncWgInst,
  GIFBS_HasShaderCyclesHiLoRegisters,
  GIFBS_HasShaderCyclesRegister,
  GIFBS_HasTanhInsts,
  GIFBS_HasTensorCvtLutInsts,
  GIFBS_HasUnrestrictedSOffset,
  GIFBS_HasVOP3PInsts,
  GIFBS_HasVmemPrefInsts,
  GIFBS_HasXF32Insts,
  GIFBS_HasXNACKEnabled,
  GIFBS_IEEEModeDisabled,
  GIFBS_LDSRequiresM0Init,
  GIFBS_NotHasAddNoCarryInsts,
  GIFBS_NotHasTrue16BitInsts,
  GIFBS_NotLDSRequiresM0Init,
  GIFBS_UseFakeTrue16Insts,
  GIFBS_UseRealTrue16Insts,
  GIFBS_isGFX10Only,
  GIFBS_isGFX10Plus,
  GIFBS_isGFX11Only,
  GIFBS_isGFX11Plus,
  GIFBS_isGFX1250Plus,
  GIFBS_isGFX125xOnly,
  GIFBS_isGFX12Only,
  GIFBS_isGFX12Plus,
  GIFBS_isGFX12PlusNot12_50,
  GIFBS_isGFX6,
  GIFBS_isGFX6GFX7,
  GIFBS_isGFX6GFX7GFX8GFX9,
  GIFBS_isGFX7GFX10GFX11,
  GIFBS_isGFX7GFX8GFX9,
  GIFBS_isGFX7Only,
  GIFBS_isGFX7Plus,
  GIFBS_isGFX8GFX9,
  GIFBS_isGFX8GFX9GFX10GFX11,
  GIFBS_isGFX8Plus,
  GIFBS_isGFX908orGFX90A,
  GIFBS_isGFX90APlus,
  GIFBS_isGFX940Plus,
  GIFBS_isGFX9GFX10,
  GIFBS_isGFX9Plus,
  GIFBS_isNotGFX1250Plus,
  GIFBS_isNotGFX12Plus,
  GIFBS_isNotGFX90APlus,
  GIFBS_isNotGFX940Plus,
  GIFBS_isNotGFX9Plus,
  GIFBS_isWave32,
  GIFBS_isWave64,
  GIFBS_D16PreservesUnusedBits_DisableFlatScratch,
  GIFBS_D16PreservesUnusedBits_HasFlatGVSMode,
  GIFBS_D16PreservesUnusedBits_UseRealTrue16Insts,
  GIFBS_DisableFlatScratch_HasD16LoadStore,
  GIFBS_DisableFlatScratch_HasUnrestrictedSOffset,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts,
  GIFBS_FP16Denormals_NotHasMinMaxDenormModes,
  GIFBS_FalsePredicate_NotHasMinMaxDenormModes,
  GIFBS_Has16BitInsts_HasIntClamp,
  GIFBS_Has16BitInsts_NotHasTrue16BitInsts,
  GIFBS_Has16BitInsts_UseFakeTrue16Insts,
  GIFBS_Has16BitInsts_UseRealTrue16Insts,
  GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9,
  GIFBS_Has16BitInsts_isGFX8GFX9,
  GIFBS_Has16BitInsts_isGFX8Only,
  GIFBS_Has16BitInsts_isNotGFX90APlus,
  GIFBS_HasAddNoCarryInsts_HasIntClamp,
  GIFBS_HasAtomicBufferGlobalPkAddF16Insts_HasUnrestrictedSOffset,
  GIFBS_HasAtomicBufferGlobalPkAddF16NoRtnInsts_HasUnrestrictedSOffset,
  GIFBS_HasAtomicCSubNoRtnInsts_HasFlatGVSMode,
  GIFBS_HasAtomicCSubNoRtnInsts_isGFX12Plus,
  GIFBS_HasAtomicFMinFMaxF32FlatInsts_HasFlatGVSMode,
  GIFBS_HasAtomicFMinFMaxF32GlobalInsts_HasUnrestrictedSOffset,
  GIFBS_HasAtomicFMinFMaxF64FlatInsts_HasFlatGVSMode,
  GIFBS_HasAtomicFMinFMaxF64GlobalInsts_HasUnrestrictedSOffset,
  GIFBS_HasAtomicFaddNoRtnInsts_HasUnrestrictedSOffset,
  GIFBS_HasAtomicFaddRtnInsts_HasUnrestrictedSOffset,
  GIFBS_HasAtomicFlatPkAdd16Insts_HasFlatGVSMode,
  GIFBS_HasBitOp3Insts_isGFX940Plus,
  GIFBS_HasCvtFP8VOP1Bug_HasFP8ConversionInsts,
  GIFBS_HasD16LoadStore_HasFlatGVSMode,
  GIFBS_HasD16LoadStore_HasFlatGlobalInsts,
  GIFBS_HasDot11Insts_isGFX12Plus,
  GIFBS_HasDot9Insts_NotHasTrue16BitInsts,
  GIFBS_HasDot9Insts_UseFakeTrue16Insts,
  GIFBS_HasDot9Insts_UseRealTrue16Insts,
  GIFBS_HasExportInsts_isGFX12Plus,
  GIFBS_HasFP8ConversionInsts_HasSDWA,
  GIFBS_HasFP8ConversionInsts_isGFX125xOnly,
  GIFBS_HasFP8ConversionInsts_isGFX12Plus,
  GIFBS_HasFP8ConversionInsts_isGFX12PlusNot12_50,
  GIFBS_HasFP8ConversionInsts_isGFX940Plus,
  GIFBS_HasFP8Insts_isGFX90APlus,
  GIFBS_HasFlatAddressSpace_HasFlatGVSMode,
  GIFBS_HasFlatAddressSpace_NotHasTrue16BitInsts,
  GIFBS_HasFlatAddressSpace_UseFakeTrue16Insts,
  GIFBS_HasFlatAtomicFaddF32Inst_HasFlatGVSMode,
  GIFBS_HasFlatBufferGlobalAtomicFaddF64Inst_HasFlatGVSMode,
  GIFBS_HasFlatBufferGlobalAtomicFaddF64Inst_HasUnrestrictedSOffset,
  GIFBS_HasFlatGVSMode_NotHasTrue16BitInsts,
  GIFBS_HasFlatGVSMode_UseFakeTrue16Insts,
  GIFBS_HasFlatGVSMode_isGFX12Only,
  GIFBS_HasFlatGVSMode_isGFX12Plus,
  GIFBS_HasFlatGVSMode_isGFX7GFX10GFX11,
  GIFBS_HasFlatGlobalInsts_NotHasTrue16BitInsts,
  GIFBS_HasFlatGlobalInsts_UseFakeTrue16Insts,
  GIFBS_HasFmaMixInsts_NotHasTrue16BitInsts,
  GIFBS_HasFmaMixInsts_UseFakeTrue16Insts,
  GIFBS_HasFmaMixInsts_UseRealTrue16Insts,
  GIFBS_HasFormattedMUBUFInsts_HasPackedD16VMem,
  GIFBS_HasFormattedMUBUFInsts_HasUnpackedD16VMem,
  GIFBS_HasFormattedMUBUFInsts_HasUnrestrictedSOffset,
  GIFBS_HasGDS_HasLDSFPAtomicAddF32,
  GIFBS_HasGDS_isGFX11Plus,
  GIFBS_HasGDS_isGFX6GFX7GFX8GFX9GFX10,
  GIFBS_HasGFX950Insts_isGFX90APlus,
  GIFBS_HasIEEEMinimumMaximumInsts_NotHasTrue16BitInsts,
  GIFBS_HasIEEEMinimumMaximumInsts_UseFakeTrue16Insts,
  GIFBS_HasIEEEMinimumMaximumInsts_UseRealTrue16Insts,
  GIFBS_HasImageInsts_isGFX12Plus,
  GIFBS_HasLDSFPAtomicAddF32_LDSRequiresM0Init,
  GIFBS_HasLDSFPAtomicAddF32_NotLDSRequiresM0Init,
  GIFBS_HasLdsBarrierArriveAtomic_isGFX1250Plus,
  GIFBS_HasMADIntraFwdBug_isGFX11Only,
  GIFBS_HasMAIInsts_isGFX90APlus,
  GIFBS_HasMTBUFInsts_HasPackedD16VMem,
  GIFBS_HasMTBUFInsts_HasUnpackedD16VMem,
  GIFBS_HasMTBUFInsts_HasUnrestrictedSOffset,
  GIFBS_HasMadMacF32Insts_NoFP32Denormals,
  GIFBS_HasMadMixInsts_NoFP32Denormals,
  GIFBS_HasMed3_16_NotHasTrue16BitInsts,
  GIFBS_HasMed3_16_UseFakeTrue16Insts,
  GIFBS_HasMed3_16_UseRealTrue16Insts,
  GIFBS_HasMinMaxDenormModes_isGFX12Plus,
  GIFBS_HasMinMaxDenormModes_isNotGFX12Plus,
  GIFBS_HasNotMADIntraFwdBug_isGFX9Plus,
  GIFBS_HasScalarStores_isGFX8Plus,
  GIFBS_HasTanhInsts_UseFakeTrue16Insts,
  GIFBS_HasTanhInsts_UseRealTrue16Insts,
  GIFBS_HasTransposeLoadF4F6Insts_isWave32,
  GIFBS_HasUnalignedAccessMode_LDSRequiresM0Init,
  GIFBS_HasUnalignedAccessMode_NotLDSRequiresM0Init,
  GIFBS_HasVOP3PInsts_IEEEModeDisabled,
  GIFBS_HasVOP3PInsts_NotHasTrue16BitInsts,
  GIFBS_HasVOP3PInsts_UseFakeTrue16Insts,
  GIFBS_HasVOP3PInsts_UseRealTrue16Insts,
  GIFBS_HasXF32Insts_isGFX90APlus,
  GIFBS_HasXNACKEnabled_isGFX7Only,
  GIFBS_HasXNACKEnabled_isGFX9Plus,
  GIFBS_HasXNACKEnabled_isNotGFX9Plus,
  GIFBS_LDSRequiresM0Init_isGFX6GFX7GFX8GFX9GFX10,
  GIFBS_LDSRequiresM0Init_isGFX7Plus,
  GIFBS_NotHasTrue16BitInsts_NotLDSRequiresM0Init,
  GIFBS_NotHasTrue16BitInsts_isGFX10Plus,
  GIFBS_NotHasTrue16BitInsts_isGFX125xOnly,
  GIFBS_NotHasTrue16BitInsts_isGFX8Plus,
  GIFBS_NotHasTrue16BitInsts_isGFX9GFX10,
  GIFBS_NotHasTrue16BitInsts_isGFX9Plus,
  GIFBS_NotHasTrue16BitInsts_isNotGFX9Plus,
  GIFBS_NotLDSRequiresM0Init_UseFakeTrue16Insts,
  GIFBS_NotLDSRequiresM0Init_UseRealTrue16Insts,
  GIFBS_NotLDSRequiresM0Init_isGFX6GFX7GFX8GFX9GFX10,
  GIFBS_NotLDSRequiresM0Init_isGFX7Plus,
  GIFBS_UseFakeTrue16Insts_isGFX10Plus,
  GIFBS_UseFakeTrue16Insts_isGFX1250Plus,
  GIFBS_UseFakeTrue16Insts_isGFX125xOnly,
  GIFBS_UseFakeTrue16Insts_isGFX8Plus,
  GIFBS_UseFakeTrue16Insts_isGFX9Plus,
  GIFBS_UseRealTrue16Insts_isGFX10Plus,
  GIFBS_UseRealTrue16Insts_isGFX1250Plus,
  GIFBS_UseRealTrue16Insts_isGFX125xOnly,
  GIFBS_UseRealTrue16Insts_isGFX8Plus,
  GIFBS_UseRealTrue16Insts_isGFX9Plus,
  GIFBS_has16BankLDS_isNotGFX90APlus,
  GIFBS_has32BankLDS_isNotGFX90APlus,
  GIFBS_isGFX11Only_isWave32,
  GIFBS_isGFX11Only_isWave64,
  GIFBS_isGFX1250Plus_isWave32,
  GIFBS_isGFX125xOnly_isWave32,
  GIFBS_isGFX12Plus_isWave32,
  GIFBS_isGFX12PlusNot12_50_isWave32,
  GIFBS_isGFX12PlusNot12_50_isWave64,
  GIFBS_isGFX90APlus_isGFX908orGFX90A,
  GIFBS_isGFX90APlus_isGFX940Plus,
  GIFBS_D16PreservesUnusedBits_DisableFlatScratch_HasUnrestrictedSOffset,
  GIFBS_D16PreservesUnusedBits_EnableFlatScratch_HasFlatScratchInsts,
  GIFBS_D16PreservesUnusedBits_HasFlatAddressSpace_UseRealTrue16Insts,
  GIFBS_DisableFlatScratch_HasD16LoadStore_HasUnrestrictedSOffset,
  GIFBS_EnableFlatScratch_HasD16LoadStore_HasFlatScratchInsts,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts_HasFlatScratchSVSMode,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts_NotHasTrue16BitInsts,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts_UseFakeTrue16Insts,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts_UseRealTrue16Insts,
  GIFBS_FP64Denormals_NotHasMinMaxDenormModes_isGFX12Plus,
  GIFBS_FP64Denormals_NotHasMinMaxDenormModes_isNotGFX12Plus,
  GIFBS_Has16BitInsts_HasMinMaxDenormModes_NotHasTrue16BitInsts,
  GIFBS_Has16BitInsts_HasMinMaxDenormModes_UseFakeTrue16Insts,
  GIFBS_Has16BitInsts_HasMinMaxDenormModes_UseRealTrue16Insts,
  GIFBS_Has16BitInsts_HasTanhInsts_NotHasTrue16BitInsts,
  GIFBS_Has16BitInsts_IEEEModeDisabled_NotHasTrue16BitInsts,
  GIFBS_Has16BitInsts_IEEEModeDisabled_UseFakeTrue16Insts,
  GIFBS_Has16BitInsts_IEEEModeDisabled_UseRealTrue16Insts,
  GIFBS_Has16BitInsts_NotHasTrue16BitInsts_isGFX10Only,
  GIFBS_Has16BitInsts_NotHasTrue16BitInsts_isGFX10Plus,
  GIFBS_Has16BitInsts_NotHasTrue16BitInsts_isGFX1250Plus,
  GIFBS_Has16BitInsts_has32BankLDS_isNotGFX90APlus,
  GIFBS_HasBitOp3Insts_UseFakeTrue16Insts_isGFX1250Plus,
  GIFBS_HasBitOp3Insts_UseRealTrue16Insts_isGFX1250Plus,
  GIFBS_HasFP8ConversionInsts_HasFP8E5M3Insts_isGFX12Plus,
  GIFBS_HasFP8ConversionInsts_HasNoCvtFP8VOP1Bug_HasSDWA,
  GIFBS_HasFP8ConversionInsts_NotHasFP8E5M3Insts_isGFX12Plus,
  GIFBS_HasFP8ConversionInsts_NotHasTrue16BitInsts_isGFX9Plus,
  GIFBS_HasFP8ConversionInsts_UseFakeTrue16Insts_isGFX9Plus,
  GIFBS_HasFormattedMUBUFInsts_HasPackedD16VMem_HasUnrestrictedSOffset,
  GIFBS_HasMTBUFInsts_HasPackedD16VMem_HasUnrestrictedSOffset,
  GIFBS_HasMadMacF32Insts_NoFP32Denormals_isGFX6GFX7GFX10,
  GIFBS_HasMadMixInsts_NoFP32Denormals_NotHasTrue16BitInsts,
  GIFBS_HasMadMixInsts_NoFP32Denormals_UseFakeTrue16Insts,
  GIFBS_HasMadMixInsts_NoFP32Denormals_UseRealTrue16Insts,
  GIFBS_HasTransposeLoadF4F6Insts_isGFX1250Plus_isWave32,
  GIFBS_D16PreservesUnusedBits_EnableFlatScratch_HasFlatScratchInsts_HasFlatScratchSVSMode,
  GIFBS_D16PreservesUnusedBits_HasFlatAddressSpace_HasFlatGVSMode_UseRealTrue16Insts,
  GIFBS_EnableFlatScratch_HasD16LoadStore_HasFlatScratchInsts_HasFlatScratchSVSMode,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts_HasFlatScratchSVSMode_NotHasTrue16BitInsts,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts_HasFlatScratchSVSMode_UseFakeTrue16Insts,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts_HasFlatScratchSVSMode_UseRealTrue16Insts,
  GIFBS_FP16Denormals_Has16BitInsts_NotHasMinMaxDenormModes_NotHasTrue16BitInsts,
  GIFBS_FP16Denormals_Has16BitInsts_NotHasMinMaxDenormModes_UseFakeTrue16Insts,
  GIFBS_FP16Denormals_Has16BitInsts_NotHasMinMaxDenormModes_UseRealTrue16Insts,
  GIFBS_HasFP8ConversionInsts_HasFP8E5M3Insts_UseFakeTrue16Insts_isGFX9Plus,
  GIFBS_HasFP8ConversionInsts_NotHasFP8E5M3Insts_NotHasTrue16BitInsts_isGFX9Plus,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_D16PreservesUnusedBitsBit, },
  {Feature_DisableFlatScratchBit, },
  {Feature_Has16BitInstsBit, },
  {Feature_HasAddMinMaxInstsBit, },
  {Feature_HasAddNoCarryInstsBit, },
  {Feature_HasAshrPkInstsBit, },
  {Feature_HasAtomicBufferGlobalPkAddF16InstsBit, },
  {Feature_HasAtomicBufferGlobalPkAddF16NoRtnInstsBit, },
  {Feature_HasAtomicCSubNoRtnInstsBit, },
  {Feature_HasAtomicDsPkAdd16InstsBit, },
  {Feature_HasAtomicFMinFMaxF32FlatInstsBit, },
  {Feature_HasAtomicFMinFMaxF32GlobalInstsBit, },
  {Feature_HasAtomicFMinFMaxF64FlatInstsBit, },
  {Feature_HasAtomicFMinFMaxF64GlobalInstsBit, },
  {Feature_HasAtomicFaddNoRtnInstsBit, },
  {Feature_HasAtomicFaddRtnInstsBit, },
  {Feature_HasAtomicFlatPkAdd16InstsBit, },
  {Feature_HasBitOp3InstsBit, },
  {Feature_HasCvtPkF16F32InstBit, },
  {Feature_HasD16LoadStoreBit, },
  {Feature_HasDLInstsBit, },
  {Feature_HasDot10InstsBit, },
  {Feature_HasDot1InstsBit, },
  {Feature_HasDot2InstsBit, },
  {Feature_HasDot3InstsBit, },
  {Feature_HasDot4InstsBit, },
  {Feature_HasDot5InstsBit, },
  {Feature_HasDot6InstsBit, },
  {Feature_HasDot7InstsBit, },
  {Feature_HasDot8InstsBit, },
  {Feature_HasF16BF16ToFP6BF6ConversionScaleInstsBit, },
  {Feature_HasF32ToF16BF16ConversionSRInstsBit, },
  {Feature_HasFP6BF6ConversionScaleInstsBit, },
  {Feature_HasFP8InstsBit, },
  {Feature_HasFlatAddressSpaceBit, },
  {Feature_HasFlatAtomicFaddF32InstBit, },
  {Feature_HasFlatBufferGlobalAtomicFaddF64InstBit, },
  {Feature_HasFlatGVSModeBit, },
  {Feature_HasFlatGlobalInstsBit, },
  {Feature_HasFmaLegacy32Bit, },
  {Feature_HasFmaMixInstsBit, },
  {Feature_HasFmacF64InstBit, },
  {Feature_HasFormattedMUBUFInstsBit, },
  {Feature_HasGDSBit, },
  {Feature_HasGFX10_BEncodingBit, },
  {Feature_HasGFX950InstsBit, },
  {Feature_HasGetWaveIdInstBit, },
  {Feature_HasIEEEMinimumMaximumInstsBit, },
  {Feature_HasIntClampBit, },
  {Feature_HasLdsAtomicAddF64Bit, },
  {Feature_HasLshlAddU64InstBit, },
  {Feature_HasMAIInstsBit, },
  {Feature_HasMTBUFInstsBit, },
  {Feature_HasMadMacF32InstsBit, },
  {Feature_HasMadU32InstBit, },
  {Feature_HasMinMaxDenormModesBit, },
  {Feature_HasMinimum3Maximum3F32Bit, },
  {Feature_HasMinimum3Maximum3PKF16Bit, },
  {Feature_HasPackedFP32OpsBit, },
  {Feature_HasPkAddMinMaxInstsBit, },
  {Feature_HasPkMinMax3InstsBit, },
  {Feature_HasPrngInstBit, },
  {Feature_HasPseudoScalarTransBit, },
  {Feature_HasSALUFloatInstsBit, },
  {Feature_HasSGetShaderCyclesInstBit, },
  {Feature_HasSMemRealTimeBit, },
  {Feature_HasSMemTimeInstBit, },
  {Feature_HasSetPrioIncWgInstBit, },
  {Feature_HasShaderCyclesHiLoRegistersBit, },
  {Feature_HasShaderCyclesRegisterBit, },
  {Feature_HasTanhInstsBit, },
  {Feature_HasTensorCvtLutInstsBit, },
  {Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasVOP3PInstsBit, },
  {Feature_HasVmemPrefInstsBit, },
  {Feature_HasXF32InstsBit, },
  {Feature_HasXNACKEnabledBit, },
  {Feature_IEEEModeDisabledBit, },
  {Feature_LDSRequiresM0InitBit, },
  {Feature_NotHasAddNoCarryInstsBit, },
  {Feature_NotHasTrue16BitInstsBit, },
  {Feature_NotLDSRequiresM0InitBit, },
  {Feature_UseFakeTrue16InstsBit, },
  {Feature_UseRealTrue16InstsBit, },
  {Feature_isGFX10OnlyBit, },
  {Feature_isGFX10PlusBit, },
  {Feature_isGFX11OnlyBit, },
  {Feature_isGFX11PlusBit, },
  {Feature_isGFX1250PlusBit, },
  {Feature_isGFX125xOnlyBit, },
  {Feature_isGFX12OnlyBit, },
  {Feature_isGFX12PlusBit, },
  {Feature_isGFX12PlusNot12_50Bit, },
  {Feature_isGFX6Bit, },
  {Feature_isGFX6GFX7Bit, },
  {Feature_isGFX6GFX7GFX8GFX9Bit, },
  {Feature_isGFX7GFX10GFX11Bit, },
  {Feature_isGFX7GFX8GFX9Bit, },
  {Feature_isGFX7OnlyBit, },
  {Feature_isGFX7PlusBit, },
  {Feature_isGFX8GFX9Bit, },
  {Feature_isGFX8GFX9GFX10GFX11Bit, },
  {Feature_isGFX8PlusBit, },
  {Feature_isGFX908orGFX90ABit, },
  {Feature_isGFX90APlusBit, },
  {Feature_isGFX940PlusBit, },
  {Feature_isGFX9GFX10Bit, },
  {Feature_isGFX9PlusBit, },
  {Feature_isNotGFX1250PlusBit, },
  {Feature_isNotGFX12PlusBit, },
  {Feature_isNotGFX90APlusBit, },
  {Feature_isNotGFX940PlusBit, },
  {Feature_isNotGFX9PlusBit, },
  {Feature_isWave32Bit, },
  {Feature_isWave64Bit, },
  {Feature_D16PreservesUnusedBitsBit, Feature_DisableFlatScratchBit, },
  {Feature_D16PreservesUnusedBitsBit, Feature_HasFlatGVSModeBit, },
  {Feature_D16PreservesUnusedBitsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_DisableFlatScratchBit, Feature_HasD16LoadStoreBit, },
  {Feature_DisableFlatScratchBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, },
  {Feature_FP16DenormalsBit, Feature_NotHasMinMaxDenormModesBit, },
  {Feature_FalsePredicateBit, Feature_NotHasMinMaxDenormModesBit, },
  {Feature_Has16BitInstsBit, Feature_HasIntClampBit, },
  {Feature_Has16BitInstsBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_Has16BitInstsBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_Has16BitInstsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_Has16BitInstsBit, Feature_isGFX6GFX7GFX8GFX9Bit, },
  {Feature_Has16BitInstsBit, Feature_isGFX8GFX9Bit, },
  {Feature_Has16BitInstsBit, Feature_isGFX8OnlyBit, },
  {Feature_Has16BitInstsBit, Feature_isNotGFX90APlusBit, },
  {Feature_HasAddNoCarryInstsBit, Feature_HasIntClampBit, },
  {Feature_HasAtomicBufferGlobalPkAddF16InstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicBufferGlobalPkAddF16NoRtnInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicCSubNoRtnInstsBit, Feature_HasFlatGVSModeBit, },
  {Feature_HasAtomicCSubNoRtnInstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasAtomicFMinFMaxF32FlatInstsBit, Feature_HasFlatGVSModeBit, },
  {Feature_HasAtomicFMinFMaxF32GlobalInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicFMinFMaxF64FlatInstsBit, Feature_HasFlatGVSModeBit, },
  {Feature_HasAtomicFMinFMaxF64GlobalInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicFaddNoRtnInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicFaddRtnInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicFlatPkAdd16InstsBit, Feature_HasFlatGVSModeBit, },
  {Feature_HasBitOp3InstsBit, Feature_isGFX940PlusBit, },
  {Feature_HasCvtFP8VOP1BugBit, Feature_HasFP8ConversionInstsBit, },
  {Feature_HasD16LoadStoreBit, Feature_HasFlatGVSModeBit, },
  {Feature_HasD16LoadStoreBit, Feature_HasFlatGlobalInstsBit, },
  {Feature_HasDot11InstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasDot9InstsBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_HasDot9InstsBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasDot9InstsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_HasExportInstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_HasSDWABit, },
  {Feature_HasFP8ConversionInstsBit, Feature_isGFX125xOnlyBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_isGFX12PlusNot12_50Bit, },
  {Feature_HasFP8ConversionInstsBit, Feature_isGFX940PlusBit, },
  {Feature_HasFP8InstsBit, Feature_isGFX90APlusBit, },
  {Feature_HasFlatAddressSpaceBit, Feature_HasFlatGVSModeBit, },
  {Feature_HasFlatAddressSpaceBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_HasFlatAddressSpaceBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasFlatAtomicFaddF32InstBit, Feature_HasFlatGVSModeBit, },
  {Feature_HasFlatBufferGlobalAtomicFaddF64InstBit, Feature_HasFlatGVSModeBit, },
  {Feature_HasFlatBufferGlobalAtomicFaddF64InstBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasFlatGVSModeBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_HasFlatGVSModeBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasFlatGVSModeBit, Feature_isGFX12OnlyBit, },
  {Feature_HasFlatGVSModeBit, Feature_isGFX12PlusBit, },
  {Feature_HasFlatGVSModeBit, Feature_isGFX7GFX10GFX11Bit, },
  {Feature_HasFlatGlobalInstsBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_HasFlatGlobalInstsBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasFmaMixInstsBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_HasFmaMixInstsBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasFmaMixInstsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_HasFormattedMUBUFInstsBit, Feature_HasPackedD16VMemBit, },
  {Feature_HasFormattedMUBUFInstsBit, Feature_HasUnpackedD16VMemBit, },
  {Feature_HasFormattedMUBUFInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasGDSBit, Feature_HasLDSFPAtomicAddF32Bit, },
  {Feature_HasGDSBit, Feature_isGFX11PlusBit, },
  {Feature_HasGDSBit, Feature_isGFX6GFX7GFX8GFX9GFX10Bit, },
  {Feature_HasGFX950InstsBit, Feature_isGFX90APlusBit, },
  {Feature_HasIEEEMinimumMaximumInstsBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_HasIEEEMinimumMaximumInstsBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasIEEEMinimumMaximumInstsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_HasImageInstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasLDSFPAtomicAddF32Bit, Feature_LDSRequiresM0InitBit, },
  {Feature_HasLDSFPAtomicAddF32Bit, Feature_NotLDSRequiresM0InitBit, },
  {Feature_HasLdsBarrierArriveAtomicBit, Feature_isGFX1250PlusBit, },
  {Feature_HasMADIntraFwdBugBit, Feature_isGFX11OnlyBit, },
  {Feature_HasMAIInstsBit, Feature_isGFX90APlusBit, },
  {Feature_HasMTBUFInstsBit, Feature_HasPackedD16VMemBit, },
  {Feature_HasMTBUFInstsBit, Feature_HasUnpackedD16VMemBit, },
  {Feature_HasMTBUFInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasMadMacF32InstsBit, Feature_NoFP32DenormalsBit, },
  {Feature_HasMadMixInstsBit, Feature_NoFP32DenormalsBit, },
  {Feature_HasMed3_16Bit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_HasMed3_16Bit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasMed3_16Bit, Feature_UseRealTrue16InstsBit, },
  {Feature_HasMinMaxDenormModesBit, Feature_isGFX12PlusBit, },
  {Feature_HasMinMaxDenormModesBit, Feature_isNotGFX12PlusBit, },
  {Feature_HasNotMADIntraFwdBugBit, Feature_isGFX9PlusBit, },
  {Feature_HasScalarStoresBit, Feature_isGFX8PlusBit, },
  {Feature_HasTanhInstsBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasTanhInstsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_HasTransposeLoadF4F6InstsBit, Feature_isWave32Bit, },
  {Feature_HasUnalignedAccessModeBit, Feature_LDSRequiresM0InitBit, },
  {Feature_HasUnalignedAccessModeBit, Feature_NotLDSRequiresM0InitBit, },
  {Feature_HasVOP3PInstsBit, Feature_IEEEModeDisabledBit, },
  {Feature_HasVOP3PInstsBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_HasVOP3PInstsBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasVOP3PInstsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_HasXF32InstsBit, Feature_isGFX90APlusBit, },
  {Feature_HasXNACKEnabledBit, Feature_isGFX7OnlyBit, },
  {Feature_HasXNACKEnabledBit, Feature_isGFX9PlusBit, },
  {Feature_HasXNACKEnabledBit, Feature_isNotGFX9PlusBit, },
  {Feature_LDSRequiresM0InitBit, Feature_isGFX6GFX7GFX8GFX9GFX10Bit, },
  {Feature_LDSRequiresM0InitBit, Feature_isGFX7PlusBit, },
  {Feature_NotHasTrue16BitInstsBit, Feature_NotLDSRequiresM0InitBit, },
  {Feature_NotHasTrue16BitInstsBit, Feature_isGFX10PlusBit, },
  {Feature_NotHasTrue16BitInstsBit, Feature_isGFX125xOnlyBit, },
  {Feature_NotHasTrue16BitInstsBit, Feature_isGFX8PlusBit, },
  {Feature_NotHasTrue16BitInstsBit, Feature_isGFX9GFX10Bit, },
  {Feature_NotHasTrue16BitInstsBit, Feature_isGFX9PlusBit, },
  {Feature_NotHasTrue16BitInstsBit, Feature_isNotGFX9PlusBit, },
  {Feature_NotLDSRequiresM0InitBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_NotLDSRequiresM0InitBit, Feature_UseRealTrue16InstsBit, },
  {Feature_NotLDSRequiresM0InitBit, Feature_isGFX6GFX7GFX8GFX9GFX10Bit, },
  {Feature_NotLDSRequiresM0InitBit, Feature_isGFX7PlusBit, },
  {Feature_UseFakeTrue16InstsBit, Feature_isGFX10PlusBit, },
  {Feature_UseFakeTrue16InstsBit, Feature_isGFX1250PlusBit, },
  {Feature_UseFakeTrue16InstsBit, Feature_isGFX125xOnlyBit, },
  {Feature_UseFakeTrue16InstsBit, Feature_isGFX8PlusBit, },
  {Feature_UseFakeTrue16InstsBit, Feature_isGFX9PlusBit, },
  {Feature_UseRealTrue16InstsBit, Feature_isGFX10PlusBit, },
  {Feature_UseRealTrue16InstsBit, Feature_isGFX1250PlusBit, },
  {Feature_UseRealTrue16InstsBit, Feature_isGFX125xOnlyBit, },
  {Feature_UseRealTrue16InstsBit, Feature_isGFX8PlusBit, },
  {Feature_UseRealTrue16InstsBit, Feature_isGFX9PlusBit, },
  {Feature_has16BankLDSBit, Feature_isNotGFX90APlusBit, },
  {Feature_has32BankLDSBit, Feature_isNotGFX90APlusBit, },
  {Feature_isGFX11OnlyBit, Feature_isWave32Bit, },
  {Feature_isGFX11OnlyBit, Feature_isWave64Bit, },
  {Feature_isGFX1250PlusBit, Feature_isWave32Bit, },
  {Feature_isGFX125xOnlyBit, Feature_isWave32Bit, },
  {Feature_isGFX12PlusBit, Feature_isWave32Bit, },
  {Feature_isGFX12PlusNot12_50Bit, Feature_isWave32Bit, },
  {Feature_isGFX12PlusNot12_50Bit, Feature_isWave64Bit, },
  {Feature_isGFX90APlusBit, Feature_isGFX908orGFX90ABit, },
  {Feature_isGFX90APlusBit, Feature_isGFX940PlusBit, },
  {Feature_D16PreservesUnusedBitsBit, Feature_DisableFlatScratchBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_D16PreservesUnusedBitsBit, Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, },
  {Feature_D16PreservesUnusedBitsBit, Feature_HasFlatAddressSpaceBit, Feature_UseRealTrue16InstsBit, },
  {Feature_DisableFlatScratchBit, Feature_HasD16LoadStoreBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_EnableFlatScratchBit, Feature_HasD16LoadStoreBit, Feature_HasFlatScratchInstsBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, Feature_HasFlatScratchSVSModeBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_FP64DenormalsBit, Feature_NotHasMinMaxDenormModesBit, Feature_isGFX12PlusBit, },
  {Feature_FP64DenormalsBit, Feature_NotHasMinMaxDenormModesBit, Feature_isNotGFX12PlusBit, },
  {Feature_Has16BitInstsBit, Feature_HasMinMaxDenormModesBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_Has16BitInstsBit, Feature_HasMinMaxDenormModesBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_Has16BitInstsBit, Feature_HasMinMaxDenormModesBit, Feature_UseRealTrue16InstsBit, },
  {Feature_Has16BitInstsBit, Feature_HasTanhInstsBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_Has16BitInstsBit, Feature_IEEEModeDisabledBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_Has16BitInstsBit, Feature_IEEEModeDisabledBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_Has16BitInstsBit, Feature_IEEEModeDisabledBit, Feature_UseRealTrue16InstsBit, },
  {Feature_Has16BitInstsBit, Feature_NotHasTrue16BitInstsBit, Feature_isGFX10OnlyBit, },
  {Feature_Has16BitInstsBit, Feature_NotHasTrue16BitInstsBit, Feature_isGFX10PlusBit, },
  {Feature_Has16BitInstsBit, Feature_NotHasTrue16BitInstsBit, Feature_isGFX1250PlusBit, },
  {Feature_Has16BitInstsBit, Feature_has32BankLDSBit, Feature_isNotGFX90APlusBit, },
  {Feature_HasBitOp3InstsBit, Feature_UseFakeTrue16InstsBit, Feature_isGFX1250PlusBit, },
  {Feature_HasBitOp3InstsBit, Feature_UseRealTrue16InstsBit, Feature_isGFX1250PlusBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_HasFP8E5M3InstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_HasNoCvtFP8VOP1BugBit, Feature_HasSDWABit, },
  {Feature_HasFP8ConversionInstsBit, Feature_NotHasFP8E5M3InstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_NotHasTrue16BitInstsBit, Feature_isGFX9PlusBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_UseFakeTrue16InstsBit, Feature_isGFX9PlusBit, },
  {Feature_HasFormattedMUBUFInstsBit, Feature_HasPackedD16VMemBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasMTBUFInstsBit, Feature_HasPackedD16VMemBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasMadMacF32InstsBit, Feature_NoFP32DenormalsBit, Feature_isGFX6GFX7GFX10Bit, },
  {Feature_HasMadMixInstsBit, Feature_NoFP32DenormalsBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_HasMadMixInstsBit, Feature_NoFP32DenormalsBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasMadMixInstsBit, Feature_NoFP32DenormalsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_HasTransposeLoadF4F6InstsBit, Feature_isGFX1250PlusBit, Feature_isWave32Bit, },
  {Feature_D16PreservesUnusedBitsBit, Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, Feature_HasFlatScratchSVSModeBit, },
  {Feature_D16PreservesUnusedBitsBit, Feature_HasFlatAddressSpaceBit, Feature_HasFlatGVSModeBit, Feature_UseRealTrue16InstsBit, },
  {Feature_EnableFlatScratchBit, Feature_HasD16LoadStoreBit, Feature_HasFlatScratchInstsBit, Feature_HasFlatScratchSVSModeBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, Feature_HasFlatScratchSVSModeBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, Feature_HasFlatScratchSVSModeBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, Feature_HasFlatScratchSVSModeBit, Feature_UseRealTrue16InstsBit, },
  {Feature_FP16DenormalsBit, Feature_Has16BitInstsBit, Feature_NotHasMinMaxDenormModesBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_FP16DenormalsBit, Feature_Has16BitInstsBit, Feature_NotHasMinMaxDenormModesBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_FP16DenormalsBit, Feature_Has16BitInstsBit, Feature_NotHasMinMaxDenormModesBit, Feature_UseRealTrue16InstsBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_HasFP8E5M3InstsBit, Feature_UseFakeTrue16InstsBit, Feature_isGFX9PlusBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_NotHasFP8E5M3InstsBit, Feature_NotHasTrue16BitInstsBit, Feature_isGFX9PlusBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
  GICP_gi_buf_soffset,
  GICP_gi_ds_128bit_8byte_aligned,
  GICP_gi_ds_1addr_1offset,
  GICP_gi_ds_64bit_4byte_aligned,
  GICP_gi_flat_offset,
  GICP_gi_flat_scratch_offset,
  GICP_gi_flat_scratch_saddr,
  GICP_gi_flat_scratch_svaddr,
  GICP_gi_global_offset,
  GICP_gi_global_saddr,
  GICP_gi_global_saddr_cpol,
  GICP_gi_global_saddr_cpol_m0,
  GICP_gi_global_saddr_glc,
  GICP_gi_global_saddr_no_ioffset,
  GICP_gi_global_saddr_no_ioffset_m0,
  GICP_gi_mubuf_addr64,
  GICP_gi_mubuf_offset,
  GICP_gi_mubuf_scratch_offen,
  GICP_gi_mubuf_scratch_offset,
  GICP_gi_smrd_buffer_imm,
  GICP_gi_smrd_buffer_imm32,
  GICP_gi_smrd_buffer_sgpr_imm,
  GICP_gi_smrd_imm,
  GICP_gi_smrd_imm32,
  GICP_gi_smrd_sgpr,
  GICP_gi_smrd_sgpr_imm,
  GICP_gi_swmmacindex16,
  GICP_gi_swmmacindex32,
  GICP_gi_swmmacindex8,
  GICP_gi_vcsrc,
  GICP_gi_vinterpmods,
  GICP_gi_vinterpmods_hi,
  GICP_gi_vop3_mad_mix_mods,
  GICP_gi_vop3_mad_mix_mods_ext,
  GICP_gi_vop3_no_mods,
  GICP_gi_vop3mods,
  GICP_gi_vop3mods0,
  GICP_gi_vop3modsnoncanonicalizing,
  GICP_gi_vop3omods,
  GICP_gi_vop3opsel,
  GICP_gi_vop3opselmods,
  GICP_gi_vop3pmods,
  GICP_gi_vop3pmodsdot,
  GICP_gi_vsrc0,
  GICP_gi_wmmamods,
  GICP_gi_wmmamodsf16Neg,
  GICP_gi_wmmamodsf16NegAbs,
  GICP_gi_wmmaopselvop3pmods,
  GICP_gi_wmmavisrc,
};
// See constructor for table contents

AMDGPUInstructionSelector::ComplexMatcherMemFn
AMDGPUInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
  &AMDGPUInstructionSelector::selectBUFSOffset, // gi_buf_soffset
  &AMDGPUInstructionSelector::selectDS128Bit8ByteAligned, // gi_ds_128bit_8byte_aligned
  &AMDGPUInstructionSelector::selectDS1Addr1Offset, // gi_ds_1addr_1offset
  &AMDGPUInstructionSelector::selectDS64Bit4ByteAligned, // gi_ds_64bit_4byte_aligned
  &AMDGPUInstructionSelector::selectFlatOffset, // gi_flat_offset
  &AMDGPUInstructionSelector::selectScratchOffset, // gi_flat_scratch_offset
  &AMDGPUInstructionSelector::selectScratchSAddr, // gi_flat_scratch_saddr
  &AMDGPUInstructionSelector::selectScratchSVAddr, // gi_flat_scratch_svaddr
  &AMDGPUInstructionSelector::selectGlobalOffset, // gi_global_offset
  &AMDGPUInstructionSelector::selectGlobalSAddr, // gi_global_saddr
  &AMDGPUInstructionSelector::selectGlobalSAddrCPol, // gi_global_saddr_cpol
  &AMDGPUInstructionSelector::selectGlobalSAddrCPolM0, // gi_global_saddr_cpol_m0
  &AMDGPUInstructionSelector::selectGlobalSAddrGLC, // gi_global_saddr_glc
  &AMDGPUInstructionSelector::selectGlobalSAddrNoIOffset, // gi_global_saddr_no_ioffset
  &AMDGPUInstructionSelector::selectGlobalSAddrNoIOffsetM0, // gi_global_saddr_no_ioffset_m0
  &AMDGPUInstructionSelector::selectMUBUFAddr64, // gi_mubuf_addr64
  &AMDGPUInstructionSelector::selectMUBUFOffset, // gi_mubuf_offset
  &AMDGPUInstructionSelector::selectMUBUFScratchOffen, // gi_mubuf_scratch_offen
  &AMDGPUInstructionSelector::selectMUBUFScratchOffset, // gi_mubuf_scratch_offset
  &AMDGPUInstructionSelector::selectSMRDBufferImm, // gi_smrd_buffer_imm
  &AMDGPUInstructionSelector::selectSMRDBufferImm32, // gi_smrd_buffer_imm32
  &AMDGPUInstructionSelector::selectSMRDBufferSgprImm, // gi_smrd_buffer_sgpr_imm
  &AMDGPUInstructionSelector::selectSmrdImm, // gi_smrd_imm
  &AMDGPUInstructionSelector::selectSmrdImm32, // gi_smrd_imm32
  &AMDGPUInstructionSelector::selectSmrdSgpr, // gi_smrd_sgpr
  &AMDGPUInstructionSelector::selectSmrdSgprImm, // gi_smrd_sgpr_imm
  &AMDGPUInstructionSelector::selectSWMMACIndex16, // gi_swmmacindex16
  &AMDGPUInstructionSelector::selectSWMMACIndex32, // gi_swmmacindex32
  &AMDGPUInstructionSelector::selectSWMMACIndex8, // gi_swmmacindex8
  &AMDGPUInstructionSelector::selectVCSRC, // gi_vcsrc
  &AMDGPUInstructionSelector::selectVINTERPMods, // gi_vinterpmods
  &AMDGPUInstructionSelector::selectVINTERPModsHi, // gi_vinterpmods_hi
  &AMDGPUInstructionSelector::selectVOP3PMadMixMods, // gi_vop3_mad_mix_mods
  &AMDGPUInstructionSelector::selectVOP3PMadMixModsExt, // gi_vop3_mad_mix_mods_ext
  &AMDGPUInstructionSelector::selectVOP3NoMods, // gi_vop3_no_mods
  &AMDGPUInstructionSelector::selectVOP3Mods, // gi_vop3mods
  &AMDGPUInstructionSelector::selectVOP3Mods0, // gi_vop3mods0
  &AMDGPUInstructionSelector::selectVOP3ModsNonCanonicalizing, // gi_vop3modsnoncanonicalizing
  &AMDGPUInstructionSelector::selectVOP3OMods, // gi_vop3omods
  &AMDGPUInstructionSelector::selectVOP3OpSelMods, // gi_vop3opsel
  &AMDGPUInstructionSelector::selectVOP3OpSelMods, // gi_vop3opselmods
  &AMDGPUInstructionSelector::selectVOP3PMods, // gi_vop3pmods
  &AMDGPUInstructionSelector::selectVOP3PModsDOT, // gi_vop3pmodsdot
  &AMDGPUInstructionSelector::selectVSRC0, // gi_vsrc0
  &AMDGPUInstructionSelector::selectWMMAModsF32NegAbs, // gi_wmmamods
  &AMDGPUInstructionSelector::selectWMMAModsF16Neg, // gi_wmmamodsf16Neg
  &AMDGPUInstructionSelector::selectWMMAModsF16NegAbs, // gi_wmmamodsf16NegAbs
  &AMDGPUInstructionSelector::selectWMMAOpSelVOP3PMods, // gi_wmmaopselvop3pmods
  &AMDGPUInstructionSelector::selectWMMAVISrc, // gi_wmmavisrc
};

// PatFrag predicates.
enum {
  GICXXPred_MI_Predicate_aligned_smrd_load = GICXXPred_Invalid + 1,
  GICXXPred_MI_Predicate_anonymous_16615,
  GICXXPred_MI_Predicate_anonymous_16618,
  GICXXPred_MI_Predicate_anonymous_16619,
  GICXXPred_MI_Predicate_anonymous_16620,
  GICXXPred_MI_Predicate_anonymous_16621,
  GICXXPred_MI_Predicate_anonymous_16622,
  GICXXPred_MI_Predicate_anonymous_16625,
  GICXXPred_MI_Predicate_anonymous_16626,
  GICXXPred_MI_Predicate_anonymous_16627,
  GICXXPred_MI_Predicate_anonymous_16628,
  GICXXPred_MI_Predicate_anonymous_16629,
  GICXXPred_MI_Predicate_anonymous_16630,
  GICXXPred_MI_Predicate_anonymous_16631,
  GICXXPred_MI_Predicate_anonymous_16632,
  GICXXPred_MI_Predicate_anonymous_16633,
  GICXXPred_MI_Predicate_anonymous_16634,
  GICXXPred_MI_Predicate_anonymous_16635,
  GICXXPred_MI_Predicate_anonymous_16636,
  GICXXPred_MI_Predicate_anonymous_16637,
  GICXXPred_MI_Predicate_anonymous_16638,
  GICXXPred_MI_Predicate_anonymous_16639,
  GICXXPred_MI_Predicate_anonymous_16640,
  GICXXPred_MI_Predicate_anonymous_16641,
  GICXXPred_MI_Predicate_anonymous_16642,
  GICXXPred_MI_Predicate_anonymous_16643,
  GICXXPred_MI_Predicate_anonymous_16644,
  GICXXPred_MI_Predicate_anonymous_16645,
  GICXXPred_MI_Predicate_anonymous_16646,
  GICXXPred_MI_Predicate_anonymous_16647,
  GICXXPred_MI_Predicate_anonymous_16648,
  GICXXPred_MI_Predicate_anonymous_16649,
  GICXXPred_MI_Predicate_anonymous_16650,
  GICXXPred_MI_Predicate_anonymous_16651,
  GICXXPred_MI_Predicate_anonymous_16652,
  GICXXPred_MI_Predicate_anonymous_16653,
  GICXXPred_MI_Predicate_anonymous_16654,
  GICXXPred_MI_Predicate_anonymous_16655,
  GICXXPred_MI_Predicate_anonymous_16656,
  GICXXPred_MI_Predicate_anonymous_16657,
  GICXXPred_MI_Predicate_anonymous_16658,
  GICXXPred_MI_Predicate_anonymous_16659,
  GICXXPred_MI_Predicate_anonymous_16660,
  GICXXPred_MI_Predicate_anonymous_16661,
  GICXXPred_MI_Predicate_anonymous_16662,
  GICXXPred_MI_Predicate_anonymous_16663,
  GICXXPred_MI_Predicate_anonymous_16664,
  GICXXPred_MI_Predicate_anonymous_16665,
  GICXXPred_MI_Predicate_anonymous_16666,
  GICXXPred_MI_Predicate_anonymous_16667,
  GICXXPred_MI_Predicate_anonymous_16668,
  GICXXPred_MI_Predicate_anonymous_16678,
  GICXXPred_MI_Predicate_anonymous_16690,
  GICXXPred_MI_Predicate_anonymous_21321,
  GICXXPred_MI_Predicate_anonymous_22617,
  GICXXPred_MI_Predicate_anonymous_22619,
  GICXXPred_MI_Predicate_anonymous_22623,
  GICXXPred_MI_Predicate_anonymous_22625,
  GICXXPred_MI_Predicate_anonymous_22968,
  GICXXPred_MI_Predicate_anonymous_23030,
  GICXXPred_MI_Predicate_anonymous_23032,
  GICXXPred_MI_Predicate_anonymous_23034,
  GICXXPred_MI_Predicate_anonymous_23036,
  GICXXPred_MI_Predicate_anonymous_23038,
  GICXXPred_MI_Predicate_anonymous_23042,
  GICXXPred_MI_Predicate_anonymous_23044,
  GICXXPred_MI_Predicate_anonymous_23046,
  GICXXPred_MI_Predicate_anonymous_23048,
  GICXXPred_MI_Predicate_anonymous_23050,
  GICXXPred_MI_Predicate_anonymous_23316,
  GICXXPred_MI_Predicate_anonymous_23318,
  GICXXPred_MI_Predicate_anonymous_23777,
  GICXXPred_MI_Predicate_anonymous_24379,
  GICXXPred_MI_Predicate_anonymous_24382,
  GICXXPred_MI_Predicate_anonymous_24385,
  GICXXPred_MI_Predicate_anonymous_24387,
  GICXXPred_MI_Predicate_anonymous_24390,
  GICXXPred_MI_Predicate_anonymous_24392,
  GICXXPred_MI_Predicate_anonymous_24395,
  GICXXPred_MI_Predicate_anonymous_24398,
  GICXXPred_MI_Predicate_anonymous_24401,
  GICXXPred_MI_Predicate_anonymous_24405,
  GICXXPred_MI_Predicate_anonymous_24408,
  GICXXPred_MI_Predicate_anonymous_24410,
  GICXXPred_MI_Predicate_anonymous_24412,
  GICXXPred_MI_Predicate_anonymous_24414,
  GICXXPred_MI_Predicate_anonymous_24416,
  GICXXPred_MI_Predicate_anonymous_24869,
  GICXXPred_MI_Predicate_anonymous_25774,
  GICXXPred_MI_Predicate_anonymous_25777,
  GICXXPred_MI_Predicate_anonymous_25779,
  GICXXPred_MI_Predicate_anonymous_25781,
  GICXXPred_MI_Predicate_anonymous_25783,
  GICXXPred_MI_Predicate_anonymous_25785,
  GICXXPred_MI_Predicate_anonymous_25787,
  GICXXPred_MI_Predicate_anonymous_26075,
  GICXXPred_MI_Predicate_anonymous_26078,
  GICXXPred_MI_Predicate_anonymous_26081,
  GICXXPred_MI_Predicate_anonymous_26084,
  GICXXPred_MI_Predicate_anonymous_27591,
  GICXXPred_MI_Predicate_anonymous_27593,
  GICXXPred_MI_Predicate_anonymous_27597,
  GICXXPred_MI_Predicate_anonymous_27599,
  GICXXPred_MI_Predicate_anonymous_27601,
  GICXXPred_MI_Predicate_anonymous_27603,
  GICXXPred_MI_Predicate_anonymous_27607,
  GICXXPred_MI_Predicate_anonymous_27609,
  GICXXPred_MI_Predicate_anonymous_27611,
  GICXXPred_MI_Predicate_anonymous_27613,
  GICXXPred_MI_Predicate_anonymous_27615,
  GICXXPred_MI_Predicate_anonymous_27617,
  GICXXPred_MI_Predicate_anonymous_27619,
  GICXXPred_MI_Predicate_anonymous_27621,
  GICXXPred_MI_Predicate_anonymous_27625,
  GICXXPred_MI_Predicate_anonymous_27627,
  GICXXPred_MI_Predicate_anonymous_27629,
  GICXXPred_MI_Predicate_anonymous_27631,
  GICXXPred_MI_Predicate_anonymous_27635,
  GICXXPred_MI_Predicate_anonymous_27637,
  GICXXPred_MI_Predicate_anonymous_27641,
  GICXXPred_MI_Predicate_anonymous_27643,
  GICXXPred_MI_Predicate_anonymous_27645,
  GICXXPred_MI_Predicate_anonymous_27647,
  GICXXPred_MI_Predicate_anonymous_27651,
  GICXXPred_MI_Predicate_anonymous_27653,
  GICXXPred_MI_Predicate_anonymous_27655,
  GICXXPred_MI_Predicate_anonymous_27657,
  GICXXPred_MI_Predicate_anonymous_27659,
  GICXXPred_MI_Predicate_anonymous_27661,
  GICXXPred_MI_Predicate_anonymous_27663,
  GICXXPred_MI_Predicate_anonymous_27665,
  GICXXPred_MI_Predicate_anonymous_27669,
  GICXXPred_MI_Predicate_anonymous_27671,
  GICXXPred_MI_Predicate_anonymous_27673,
  GICXXPred_MI_Predicate_anonymous_27675,
  GICXXPred_MI_Predicate_anonymous_27679,
  GICXXPred_MI_Predicate_anonymous_27681,
  GICXXPred_MI_Predicate_anonymous_27683,
  GICXXPred_MI_Predicate_anonymous_27685,
  GICXXPred_MI_Predicate_anonymous_27687,
  GICXXPred_MI_Predicate_anonymous_27689,
  GICXXPred_MI_Predicate_anonymous_27693,
  GICXXPred_MI_Predicate_anonymous_27695,
  GICXXPred_MI_Predicate_anonymous_27697,
  GICXXPred_MI_Predicate_anonymous_27699,
  GICXXPred_MI_Predicate_anonymous_27701,
  GICXXPred_MI_Predicate_anonymous_27703,
  GICXXPred_MI_Predicate_anonymous_27707,
  GICXXPred_MI_Predicate_anonymous_27709,
  GICXXPred_MI_Predicate_anonymous_27713,
  GICXXPred_MI_Predicate_anonymous_27715,
  GICXXPred_MI_Predicate_anonymous_27717,
  GICXXPred_MI_Predicate_anonymous_27719,
  GICXXPred_MI_Predicate_anonymous_27739,
  GICXXPred_MI_Predicate_anonymous_27741,
  GICXXPred_MI_Predicate_anonymous_27775,
  GICXXPred_MI_Predicate_anonymous_27777,
  GICXXPred_MI_Predicate_anonymous_27797,
  GICXXPred_MI_Predicate_anonymous_27799,
  GICXXPred_MI_Predicate_anonymous_27837,
  GICXXPred_MI_Predicate_anonymous_27839,
  GICXXPred_MI_Predicate_anonymous_27843,
  GICXXPred_MI_Predicate_anonymous_27845,
  GICXXPred_MI_Predicate_anonymous_27847,
  GICXXPred_MI_Predicate_anonymous_27849,
  GICXXPred_MI_Predicate_anonymous_27851,
  GICXXPred_MI_Predicate_anonymous_27853,
  GICXXPred_MI_Predicate_anonymous_27855,
  GICXXPred_MI_Predicate_anonymous_27857,
  GICXXPred_MI_Predicate_anonymous_27861,
  GICXXPred_MI_Predicate_anonymous_27863,
  GICXXPred_MI_Predicate_anonymous_27865,
  GICXXPred_MI_Predicate_anonymous_27867,
  GICXXPred_MI_Predicate_anonymous_27871,
  GICXXPred_MI_Predicate_anonymous_27873,
  GICXXPred_MI_Predicate_anonymous_27875,
  GICXXPred_MI_Predicate_anonymous_27877,
  GICXXPred_MI_Predicate_anonymous_27879,
  GICXXPred_MI_Predicate_anonymous_27881,
  GICXXPred_MI_Predicate_anonymous_27885,
  GICXXPred_MI_Predicate_anonymous_27887,
  GICXXPred_MI_Predicate_anonymous_27889,
  GICXXPred_MI_Predicate_anonymous_27891,
  GICXXPred_MI_Predicate_anonymous_27893,
  GICXXPred_MI_Predicate_anonymous_27895,
  GICXXPred_MI_Predicate_anonymous_27897,
  GICXXPred_MI_Predicate_anonymous_27899,
  GICXXPred_MI_Predicate_anonymous_27901,
  GICXXPred_MI_Predicate_anonymous_27903,
  GICXXPred_MI_Predicate_anonymous_27907,
  GICXXPred_MI_Predicate_anonymous_27909,
  GICXXPred_MI_Predicate_anonymous_27911,
  GICXXPred_MI_Predicate_anonymous_27913,
  GICXXPred_MI_Predicate_anonymous_27915,
  GICXXPred_MI_Predicate_anonymous_27917,
  GICXXPred_MI_Predicate_anonymous_27919,
  GICXXPred_MI_Predicate_anonymous_27921,
  GICXXPred_MI_Predicate_anonymous_40326,
  GICXXPred_MI_Predicate_anonymous_40331,
  GICXXPred_MI_Predicate_anonymous_40333,
  GICXXPred_MI_Predicate_anonymous_40782,
  GICXXPred_MI_Predicate_anonymous_40784,
  GICXXPred_MI_Predicate_anonymous_40837,
  GICXXPred_MI_Predicate_anonymous_40872,
  GICXXPred_MI_Predicate_anonymous_40873,
  GICXXPred_MI_Predicate_anonymous_40876,
  GICXXPred_MI_Predicate_anonymous_40879,
  GICXXPred_MI_Predicate_anonymous_40882,
  GICXXPred_MI_Predicate_anonymous_40886,
  GICXXPred_MI_Predicate_anonymous_40889,
  GICXXPred_MI_Predicate_anonymous_40892,
  GICXXPred_MI_Predicate_anonymous_40894,
  GICXXPred_MI_Predicate_anonymous_40895,
  GICXXPred_MI_Predicate_anonymous_40904,
  GICXXPred_MI_Predicate_anonymous_40906,
  GICXXPred_MI_Predicate_anonymous_40914,
  GICXXPred_MI_Predicate_anonymous_40919,
  GICXXPred_MI_Predicate_anonymous_40923,
  GICXXPred_MI_Predicate_anonymous_40927,
  GICXXPred_MI_Predicate_anonymous_40937,
  GICXXPred_MI_Predicate_anonymous_41099,
  GICXXPred_MI_Predicate_anonymous_41102,
  GICXXPred_MI_Predicate_anonymous_41121,
  GICXXPred_MI_Predicate_anonymous_41188,
  GICXXPred_MI_Predicate_anonymous_41190,
  GICXXPred_MI_Predicate_anonymous_41266,
  GICXXPred_MI_Predicate_anonymous_41302,
  GICXXPred_MI_Predicate_anonymous_41304,
  GICXXPred_MI_Predicate_anonymous_41333,
  GICXXPred_MI_Predicate_anonymous_41335,
  GICXXPred_MI_Predicate_anonymous_41337,
  GICXXPred_MI_Predicate_anonymous_41339,
  GICXXPred_MI_Predicate_anonymous_41341,
  GICXXPred_MI_Predicate_anonymous_41371,
  GICXXPred_MI_Predicate_anonymous_41373,
  GICXXPred_MI_Predicate_bf16_fpround,
  GICXXPred_MI_Predicate_csh_mask_16,
  GICXXPred_MI_Predicate_csh_mask_32,
  GICXXPred_MI_Predicate_csh_mask_64,
  GICXXPred_MI_Predicate_fmaxnum_like_nnan,
  GICXXPred_MI_Predicate_fminnum_like_nnan,
  GICXXPred_MI_Predicate_is_canonicalized,
  GICXXPred_MI_Predicate_load_align_less_than_4_local,
  GICXXPred_MI_Predicate_load_align_less_than_4_local_m0,
  GICXXPred_MI_Predicate_or_disjoint,
  GICXXPred_MI_Predicate_prefetch_flat,
  GICXXPred_MI_Predicate_prefetch_global,
  GICXXPred_MI_Predicate_shl1_add,
  GICXXPred_MI_Predicate_shl2_add,
  GICXXPred_MI_Predicate_shl3_add,
  GICXXPred_MI_Predicate_shl4_add,
  GICXXPred_MI_Predicate_shl_0_to_4,
  GICXXPred_MI_Predicate_smrd_extloadi8,
  GICXXPred_MI_Predicate_smrd_extloadi16,
  GICXXPred_MI_Predicate_smrd_load,
  GICXXPred_MI_Predicate_smrd_prefetch,
  GICXXPred_MI_Predicate_smrd_sextloadi8,
  GICXXPred_MI_Predicate_smrd_sextloadi16,
  GICXXPred_MI_Predicate_smrd_zextloadi8,
  GICXXPred_MI_Predicate_smrd_zextloadi16,
  GICXXPred_MI_Predicate_store_align_less_than_4_local,
  GICXXPred_MI_Predicate_store_align_less_than_4_local_m0,
};
bool AMDGPUInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  switch (PredicateID) {
  case GICXXPred_MI_Predicate_aligned_smrd_load: {
    
      auto &Ld = cast<GLoad>(MI);
      TypeSize Size = Ld.getMMO().getSize().getValue();
      return Size <= 4 || Ld.getMMO().getAlign().value() >= Size;
      
    llvm_unreachable("aligned_smrd_load should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_16615: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16618: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16619: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16620: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16621: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16622: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16625: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16626: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16627: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16628: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16629: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16630: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16631: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16632: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16633: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16634: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16635: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16636: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16637: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16638: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16639: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16640: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16641: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16642: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16643: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16644: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16645: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16646: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16647: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16648: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16649: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16650: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16651: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16652: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16653: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16654: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16655: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16656: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16657: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16658: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16659: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16660: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16661: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16662: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16663: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16664: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16665: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16666: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16667: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16668: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16678: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_16690: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_21321: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_22617: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_22619: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_22623: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_22625: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_22968: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23030: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23032: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23034: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23036: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23038: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23042: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23044: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23046: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23048: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23050: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23316: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23318: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23777: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_24379: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24379 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24382: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24382 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24385: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24385 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24387: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24387 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24390: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24390 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24392: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24392 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24395: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24395 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24398: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24398 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24401: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24401 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24405: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24405 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24408: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24408 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24410: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24410 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24412: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24412 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24414: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24414 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24416: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24416 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24869: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24869 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_25774: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_25777: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_25779: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_25781: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_25783: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_25785: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_25787: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_26075: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_26075 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_26078: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_26078 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_26081: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_26081 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_26084: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_26084 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_27591: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27593: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27597: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27599: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27601: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27603: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27607: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27609: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27611: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27613: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27615: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27617: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27619: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27621: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27625: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27627: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27629: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27631: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27635: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27637: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27641: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27643: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27645: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27647: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27651: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27653: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27655: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27657: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27659: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27661: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27663: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27665: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27669: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27671: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27673: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27675: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27679: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27681: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27683: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27685: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27687: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27689: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27693: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27695: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27697: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27699: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27701: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27703: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27707: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27709: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27713: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27715: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27717: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27719: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27739: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27741: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27775: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27777: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27797: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27799: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27837: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27839: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27843: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27845: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27847: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27849: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27851: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27853: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27855: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27857: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27861: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27863: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27865: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27867: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27871: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27873: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27875: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27877: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27879: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27881: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27885: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27887: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27889: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27891: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27893: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27895: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27897: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27899: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27901: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27903: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27907: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27909: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27911: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27913: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27915: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27917: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27919: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_27921: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_40326: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40331: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40333: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40782: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40784: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40837: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40872: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40873: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40876: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40879: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40882: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40886: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40889: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40892: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40894: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40895: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40904: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40906: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40914: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40919: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40923: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40927: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_40937: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_41099: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_41102: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_41121: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_41188: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_41190: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_41266: {
    
        const SITargetLowering *TLI = static_cast<const SITargetLowering *>(
          MF.getSubtarget().getTargetLowering());
    
        return TLI->isCanonicalized(MI.getOperand(1).getReg(), MF) &&
          TLI->isCanonicalized(MI.getOperand(2).getReg(), MF);
      
    llvm_unreachable("anonymous_41266 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_41302: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_41304: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_41333: {
    
        const SITargetLowering *TLI = static_cast<const SITargetLowering *>(
          MF.getSubtarget().getTargetLowering());
    
        return TLI->isCanonicalized(MI.getOperand(1).getReg(), MF);
      
    llvm_unreachable("anonymous_41333 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_41335: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_41337: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_41339: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_41341: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_41371: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_41373: {
    return true;
  }
  case GICXXPred_MI_Predicate_bf16_fpround: {
    return false;
  }
  case GICXXPred_MI_Predicate_csh_mask_16: {
     return isUnneededShiftMask(MI, 4); 
  }
  case GICXXPred_MI_Predicate_csh_mask_32: {
     return isUnneededShiftMask(MI, 5); 
  }
  case GICXXPred_MI_Predicate_csh_mask_64: {
     return isUnneededShiftMask(MI, 6); 
  }
  case GICXXPred_MI_Predicate_fmaxnum_like_nnan: {
    
        return isKnownNeverNaN(MI.getOperand(0).getReg(), MRI);
      
  }
  case GICXXPred_MI_Predicate_fminnum_like_nnan: {
    
        return isKnownNeverNaN(MI.getOperand(0).getReg(), MRI);
      
  }
  case GICXXPred_MI_Predicate_is_canonicalized: {
    
        const SITargetLowering *TLI = static_cast<const SITargetLowering *>(
            MF.getSubtarget().getTargetLowering());
        const MachineOperand &Dst = MI.getOperand(0);
        assert(Dst.isDef());
        return TLI->isCanonicalized(Dst.getReg(), MF);
       
    llvm_unreachable("is_canonicalized should have returned");
  }
  case GICXXPred_MI_Predicate_load_align_less_than_4_local: {
    return (*MI.memoperands_begin())->getAlign() < 4;
  }
  case GICXXPred_MI_Predicate_load_align_less_than_4_local_m0: {
    return (*MI.memoperands_begin())->getAlign() < 4;
  }
  case GICXXPred_MI_Predicate_or_disjoint: {
    
        return MI.getFlag(MachineInstr::Disjoint);
      
  }
  case GICXXPred_MI_Predicate_prefetch_flat: {
    
        return (*MI.memoperands_begin())->getAddrSpace() == AMDGPUAS::FLAT_ADDRESS;
      
  }
  case GICXXPred_MI_Predicate_prefetch_global: {
    
        return (*MI.memoperands_begin())->getAddrSpace() == AMDGPUAS::GLOBAL_ADDRESS ||
                ((*MI.memoperands_begin())->getAddrSpace() == AMDGPUAS::CONSTANT_ADDRESS &&
                 !Subtarget->hasSafeSmemPrefetch());
      
  }
  case GICXXPred_MI_Predicate_shl1_add: {
    return true;
  }
  case GICXXPred_MI_Predicate_shl2_add: {
    return true;
  }
  case GICXXPred_MI_Predicate_shl3_add: {
    return true;
  }
  case GICXXPred_MI_Predicate_shl4_add: {
    return true;
  }
  case GICXXPred_MI_Predicate_shl_0_to_4: {
    
        int64_t Imm = 0;
        if (!mi_match(MI.getOperand(2).getReg(), MRI, m_ICst(Imm)) &&
            !mi_match(MI.getOperand(2).getReg(), MRI, m_Copy(m_ICst(Imm))))
          return false;
        return (uint64_t)Imm <= 4;
      
    llvm_unreachable("shl_0_to_4 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_extloadi8: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_extloadi8 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_extloadi16: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_extloadi16 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_load: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_load should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_prefetch: {
    
        return isInstrUniform(MI) && Subtarget->hasSafeSmemPrefetch();
      
  }
  case GICXXPred_MI_Predicate_smrd_sextloadi8: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_sextloadi8 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_sextloadi16: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_sextloadi16 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_zextloadi8: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_zextloadi8 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_zextloadi16: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_zextloadi16 should have returned");
  }
  case GICXXPred_MI_Predicate_store_align_less_than_4_local: {
    return (*MI.memoperands_begin())->getAlign() < 4;
  }
  case GICXXPred_MI_Predicate_store_align_less_than_4_local_m0: {
    return (*MI.memoperands_begin())->getAlign() < 4;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool AMDGPUInstructionSelector::testMOPredicate_MO(unsigned PredicateID, const MachineOperand & MO, const MatcherState &State) const {
  const auto &Operands = State.RecordedOperands;
  Register Reg = MO.getReg();
  (void)Operands;
  (void)Reg;
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_I64_Predicate_IMMZeroBasedBitfieldMask = GICXXPred_Invalid + 1,
  GICXXPred_I64_Predicate_MFMALdScaleModifierOp,
  GICXXPred_I64_Predicate_NegSubInlineConst32,
  GICXXPred_I64_Predicate_NegSubInlineIntConst16,
  GICXXPred_I64_Predicate_SIMM16bit,
  GICXXPred_I64_Predicate_ShiftAmt32Imm,
  GICXXPred_I64_Predicate_SupportedRoundMode,
  GICXXPred_I64_Predicate_i32imm_one,
  GICXXPred_I64_Predicate_i32imm_zero,
  GICXXPred_I64_Predicate_i64imm_32bit,
};
bool AMDGPUInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GICXXPred_I64_Predicate_IMMZeroBasedBitfieldMask: {
    
      return isMask_32(Imm);
    
  }
  case GICXXPred_I64_Predicate_MFMALdScaleModifierOp: {
    
      return isUInt<2>(Imm);
    
  }
  case GICXXPred_I64_Predicate_NegSubInlineConst32: {
    
      return Imm < -16 && Imm >= -64;
    
  }
  case GICXXPred_I64_Predicate_NegSubInlineIntConst16: {
    
      return Imm < -16 && Imm >= -64;
    
  }
  case GICXXPred_I64_Predicate_SIMM16bit: {
    return isInt<16>(Imm) || isUInt<16>(Imm);
  }
  case GICXXPred_I64_Predicate_ShiftAmt32Imm: {
    
      return Imm < 32;
    
  }
  case GICXXPred_I64_Predicate_SupportedRoundMode: {
    
      return Imm == (int)RoundingMode::TowardZero ||
             Imm == (int)RoundingMode::NearestTiesToEven ||
             Imm == (int)RoundingMode::TowardPositive ||
             Imm == (int)RoundingMode::TowardNegative;
    
  }
  case GICXXPred_I64_Predicate_i32imm_one: {
    
      return Imm == 1;
    
  }
  case GICXXPred_I64_Predicate_i32imm_zero: {
    
      return Imm == 0;
    
  }
  case GICXXPred_I64_Predicate_i64imm_32bit: {
    
      return (Imm & 0xffffffffULL) == static_cast<uint64_t>(Imm);
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APFloat_Predicate_InlineImmFP32 = GICXXPred_Invalid + 1,
  GICXXPred_APFloat_Predicate_InlineImmFP64,
  GICXXPred_APFloat_Predicate_fpimm_neg_pow2_prefer_ldexp_f64,
  GICXXPred_APFloat_Predicate_fpimm_pos_pow2_prefer_ldexp_f64,
};
bool AMDGPUInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APFloat_Predicate_InlineImmFP32: {
    
      return isInlineImmediate(Imm);
    
  }
  case GICXXPred_APFloat_Predicate_InlineImmFP64: {
    
      return isInlineImmediate(Imm);
    
  }
  case GICXXPred_APFloat_Predicate_fpimm_neg_pow2_prefer_ldexp_f64: {
    
        if (!Imm.isNegative())
          return false;
        int Exp = Imm.getExactLog2Abs();
        // Prefer leaving the FP inline immediates as they are.
        // 0.5, 1.0, 2.0, 4.0
    
        // For f64 ldexp is always better than materializing a 64-bit
        // constant.
        return Exp != INT_MIN && (Exp < -1 || Exp > 2);
      
    llvm_unreachable("fpimm_neg_pow2_prefer_ldexp_f64 should have returned");
  }
  case GICXXPred_APFloat_Predicate_fpimm_pos_pow2_prefer_ldexp_f64: {
    
        if (Imm.isNegative())
          return false;
    
        int Exp = Imm.getExactLog2Abs();
        // Prefer leaving the FP inline immediates as they are.
        // 0.5, 1.0, 2.0, 4.0
    
        // For f64 ldexp is always better than materializing a 64-bit
        // constant.
        return Exp != INT_MIN && (Exp < -1 || Exp > 2);
      
    llvm_unreachable("fpimm_pos_pow2_prefer_ldexp_f64 should have returned");
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APInt_Predicate_InlineImm64 = GICXXPred_Invalid + 1,
};
bool AMDGPUInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APInt_Predicate_InlineImm64: {
    
      return isInlineImmediate(Imm);
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AMDGPUInstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("AMDGPUInstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
  GICR_renderBitcastFPImm32,
  GICR_renderBitcastFPImm64,
  GICR_renderDstSelToOpSel3XFormXForm,
  GICR_renderDstSelToOpSelXForm,
  GICR_renderExtractCPol,
  GICR_renderExtractCpolSetGLC,
  GICR_renderExtractSWZ,
  GICR_renderFPPow2ToExponent,
  GICR_renderFrameIndex,
  GICR_renderNegateImm,
  GICR_renderOpSelTImm,
  GICR_renderPopcntImm,
  GICR_renderPrefetchLoc,
  GICR_renderRoundMode,
  GICR_renderScaledMAIIntrinsicOperand,
  GICR_renderSrcAndDstSelToOpSelXForm_0_0,
  GICR_renderSrcAndDstSelToOpSelXForm_0_1,
  GICR_renderSrcAndDstSelToOpSelXForm_1_0,
  GICR_renderSrcAndDstSelToOpSelXForm_1_1,
  GICR_renderSrcAndDstSelToOpSelXForm_2_0,
  GICR_renderSrcSelToOpSelXForm,
  GICR_renderTruncTImm,
  GICR_renderVOP3PModsNeg,
  GICR_renderVOP3PModsNegAbs,
  GICR_renderVOP3PModsNegs,
  GICR_renderZextBoolTImm,
};
AMDGPUInstructionSelector::CustomRendererFn
AMDGPUInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
  &AMDGPUInstructionSelector::renderBitcastFPImm32,
  &AMDGPUInstructionSelector::renderBitcastFPImm64,
  &AMDGPUInstructionSelector::renderDstSelToOpSel3XFormXForm,
  &AMDGPUInstructionSelector::renderDstSelToOpSelXForm,
  &AMDGPUInstructionSelector::renderExtractCPol,
  &AMDGPUInstructionSelector::renderExtractCpolSetGLC,
  &AMDGPUInstructionSelector::renderExtractSWZ,
  &AMDGPUInstructionSelector::renderFPPow2ToExponent,
  &AMDGPUInstructionSelector::renderFrameIndex,
  &AMDGPUInstructionSelector::renderNegateImm,
  &AMDGPUInstructionSelector::renderOpSelTImm,
  &AMDGPUInstructionSelector::renderPopcntImm,
  &AMDGPUInstructionSelector::renderPrefetchLoc,
  &AMDGPUInstructionSelector::renderRoundMode,
  &AMDGPUInstructionSelector::renderScaledMAIIntrinsicOperand,
  &AMDGPUInstructionSelector::renderSrcAndDstSelToOpSelXForm_0_0,
  &AMDGPUInstructionSelector::renderSrcAndDstSelToOpSelXForm_0_1,
  &AMDGPUInstructionSelector::renderSrcAndDstSelToOpSelXForm_1_0,
  &AMDGPUInstructionSelector::renderSrcAndDstSelToOpSelXForm_1_1,
  &AMDGPUInstructionSelector::renderSrcAndDstSelToOpSelXForm_2_0,
  &AMDGPUInstructionSelector::renderSrcSelToOpSelXForm,
  &AMDGPUInstructionSelector::renderTruncTImm,
  &AMDGPUInstructionSelector::renderVOP3PModsNeg,
  &AMDGPUInstructionSelector::renderVOP3PModsNegAbs,
  &AMDGPUInstructionSelector::renderVOP3PModsNegs,
  &AMDGPUInstructionSelector::renderZextBoolTImm,
};

bool AMDGPUInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

bool AMDGPUInstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("AMDGPUInstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((Val) >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((Val) >> 8), uint8_t((Val) >> 16), uint8_t((Val) >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((Val) >> 8), uint8_t((Val) >> 16), uint8_t((Val) >> 24),  uint8_t(uint64_t(Val) >> 32), uint8_t(uint64_t(Val) >> 40), uint8_t(uint64_t(Val) >> 48), uint8_t(uint64_t(Val) >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((Val) >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((Val) >> 24), uint8_t((Val) >> 16), uint8_t((Val) >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t(uint64_t(Val) >> 56), uint8_t(uint64_t(Val) >> 48), uint8_t(uint64_t(Val) >> 40), uint8_t(uint64_t(Val) >> 32),  uint8_t((Val) >> 24), uint8_t((Val) >> 16), uint8_t((Val) >> 8), uint8_t(Val)
#endif
const uint8_t *AMDGPUInstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
     /*      0 */ GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(53), GIMT_Encode2(4046), /*)*//*default:*//*Label 176*/ GIMT_Encode4(839656),
     /*     10 */ /*TargetOpcode::G_ADD*//*Label 0*/ GIMT_Encode4(15982),
     /*     14 */ /*TargetOpcode::G_SUB*//*Label 1*/ GIMT_Encode4(39546),
     /*     18 */ /*TargetOpcode::G_MUL*//*Label 2*/ GIMT_Encode4(40169), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*     46 */ /*TargetOpcode::G_AND*//*Label 3*/ GIMT_Encode4(40607),
     /*     50 */ /*TargetOpcode::G_OR*//*Label 4*/ GIMT_Encode4(42604),
     /*     54 */ /*TargetOpcode::G_XOR*//*Label 5*/ GIMT_Encode4(58696), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*     74 */ /*TargetOpcode::G_FRAME_INDEX*//*Label 6*/ GIMT_Encode4(65994), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    106 */ /*TargetOpcode::G_BUILD_VECTOR*//*Label 7*/ GIMT_Encode4(66049), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    126 */ /*TargetOpcode::G_BITCAST*//*Label 8*/ GIMT_Encode4(72026), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    138 */ /*TargetOpcode::G_INTRINSIC_FPTRUNC_ROUND*//*Label 9*/ GIMT_Encode4(81190),
     /*    142 */ /*TargetOpcode::G_INTRINSIC_TRUNC*//*Label 10*/ GIMT_Encode4(81385), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    158 */ /*TargetOpcode::G_INTRINSIC_ROUNDEVEN*//*Label 11*/ GIMT_Encode4(81713),
     /*    162 */ /*TargetOpcode::G_READCYCLECOUNTER*//*Label 12*/ GIMT_Encode4(82041),
     /*    166 */ /*TargetOpcode::G_READSTEADYCOUNTER*//*Label 13*/ GIMT_Encode4(82202),
     /*    170 */ /*TargetOpcode::G_LOAD*//*Label 14*/ GIMT_Encode4(82260),
     /*    174 */ /*TargetOpcode::G_SEXTLOAD*//*Label 15*/ GIMT_Encode4(155213),
     /*    178 */ /*TargetOpcode::G_ZEXTLOAD*//*Label 16*/ GIMT_Encode4(163311), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    194 */ /*TargetOpcode::G_STORE*//*Label 17*/ GIMT_Encode4(172086), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    206 */ /*TargetOpcode::G_ATOMIC_CMPXCHG*//*Label 18*/ GIMT_Encode4(210838),
     /*    210 */ /*TargetOpcode::G_ATOMICRMW_XCHG*//*Label 19*/ GIMT_Encode4(211964),
     /*    214 */ /*TargetOpcode::G_ATOMICRMW_ADD*//*Label 20*/ GIMT_Encode4(214676),
     /*    218 */ /*TargetOpcode::G_ATOMICRMW_SUB*//*Label 21*/ GIMT_Encode4(217688),
     /*    222 */ /*TargetOpcode::G_ATOMICRMW_AND*//*Label 22*/ GIMT_Encode4(220700), GIMT_Encode4(0),
     /*    230 */ /*TargetOpcode::G_ATOMICRMW_OR*//*Label 23*/ GIMT_Encode4(223712),
     /*    234 */ /*TargetOpcode::G_ATOMICRMW_XOR*//*Label 24*/ GIMT_Encode4(226724),
     /*    238 */ /*TargetOpcode::G_ATOMICRMW_MAX*//*Label 25*/ GIMT_Encode4(229736),
     /*    242 */ /*TargetOpcode::G_ATOMICRMW_MIN*//*Label 26*/ GIMT_Encode4(232748),
     /*    246 */ /*TargetOpcode::G_ATOMICRMW_UMAX*//*Label 27*/ GIMT_Encode4(235760),
     /*    250 */ /*TargetOpcode::G_ATOMICRMW_UMIN*//*Label 28*/ GIMT_Encode4(238772),
     /*    254 */ /*TargetOpcode::G_ATOMICRMW_FADD*//*Label 29*/ GIMT_Encode4(241784), GIMT_Encode4(0),
     /*    262 */ /*TargetOpcode::G_ATOMICRMW_FMAX*//*Label 30*/ GIMT_Encode4(243965),
     /*    266 */ /*TargetOpcode::G_ATOMICRMW_FMIN*//*Label 31*/ GIMT_Encode4(247235), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    278 */ /*TargetOpcode::G_ATOMICRMW_UINC_WRAP*//*Label 32*/ GIMT_Encode4(250505),
     /*    282 */ /*TargetOpcode::G_ATOMICRMW_UDEC_WRAP*//*Label 33*/ GIMT_Encode4(253517), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    294 */ /*TargetOpcode::G_FENCE*//*Label 34*/ GIMT_Encode4(256529),
     /*    298 */ /*TargetOpcode::G_PREFETCH*//*Label 35*/ GIMT_Encode4(256548), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    314 */ /*TargetOpcode::G_INTRINSIC*//*Label 36*/ GIMT_Encode4(257561),
     /*    318 */ /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 37*/ GIMT_Encode4(279128),
     /*    322 */ /*TargetOpcode::G_INTRINSIC_CONVERGENT*//*Label 38*/ GIMT_Encode4(286248),
     /*    326 */ /*TargetOpcode::G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS*//*Label 39*/ GIMT_Encode4(321658),
     /*    330 */ /*TargetOpcode::G_ANYEXT*//*Label 40*/ GIMT_Encode4(324804),
     /*    334 */ /*TargetOpcode::G_TRUNC*//*Label 41*/ GIMT_Encode4(325458), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    350 */ /*TargetOpcode::G_CONSTANT*//*Label 42*/ GIMT_Encode4(325791),
     /*    354 */ /*TargetOpcode::G_FCONSTANT*//*Label 43*/ GIMT_Encode4(326517), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    366 */ /*TargetOpcode::G_SEXT*//*Label 44*/ GIMT_Encode4(326805), GIMT_Encode4(0),
     /*    374 */ /*TargetOpcode::G_ZEXT*//*Label 45*/ GIMT_Encode4(328240),
     /*    378 */ /*TargetOpcode::G_SHL*//*Label 46*/ GIMT_Encode4(331794),
     /*    382 */ /*TargetOpcode::G_LSHR*//*Label 47*/ GIMT_Encode4(333478),
     /*    386 */ /*TargetOpcode::G_ASHR*//*Label 48*/ GIMT_Encode4(334788), GIMT_Encode4(0),
     /*    394 */ /*TargetOpcode::G_FSHR*//*Label 49*/ GIMT_Encode4(336098),
     /*    398 */ /*TargetOpcode::G_ROTR*//*Label 50*/ GIMT_Encode4(336396), GIMT_Encode4(0),
     /*    406 */ /*TargetOpcode::G_ICMP*//*Label 51*/ GIMT_Encode4(336509),
     /*    410 */ /*TargetOpcode::G_FCMP*//*Label 52*/ GIMT_Encode4(338101), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    422 */ /*TargetOpcode::G_SELECT*//*Label 53*/ GIMT_Encode4(342264), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    466 */ /*TargetOpcode::G_UMULH*//*Label 54*/ GIMT_Encode4(342608),
     /*    470 */ /*TargetOpcode::G_SMULH*//*Label 55*/ GIMT_Encode4(342717),
     /*    474 */ /*TargetOpcode::G_UADDSAT*//*Label 56*/ GIMT_Encode4(342826),
     /*    478 */ /*TargetOpcode::G_SADDSAT*//*Label 57*/ GIMT_Encode4(343214),
     /*    482 */ /*TargetOpcode::G_USUBSAT*//*Label 58*/ GIMT_Encode4(343540),
     /*    486 */ /*TargetOpcode::G_SSUBSAT*//*Label 59*/ GIMT_Encode4(343928), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    530 */ /*TargetOpcode::G_FADD*//*Label 60*/ GIMT_Encode4(344254),
     /*    534 */ /*TargetOpcode::G_FSUB*//*Label 61*/ GIMT_Encode4(345612),
     /*    538 */ /*TargetOpcode::G_FMUL*//*Label 62*/ GIMT_Encode4(345976),
     /*    542 */ /*TargetOpcode::G_FMA*//*Label 63*/ GIMT_Encode4(347362),
     /*    546 */ /*TargetOpcode::G_FMAD*//*Label 64*/ GIMT_Encode4(349231), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    558 */ /*TargetOpcode::G_FPOW*//*Label 65*/ GIMT_Encode4(350177), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    570 */ /*TargetOpcode::G_FEXP2*//*Label 66*/ GIMT_Encode4(350295), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    582 */ /*TargetOpcode::G_FLOG2*//*Label 67*/ GIMT_Encode4(350518), GIMT_Encode4(0),
     /*    590 */ /*TargetOpcode::G_FLDEXP*//*Label 68*/ GIMT_Encode4(350741), GIMT_Encode4(0),
     /*    598 */ /*TargetOpcode::G_FNEG*//*Label 69*/ GIMT_Encode4(351104),
     /*    602 */ /*TargetOpcode::G_FPEXT*//*Label 70*/ GIMT_Encode4(352967),
     /*    606 */ /*TargetOpcode::G_FPTRUNC*//*Label 71*/ GIMT_Encode4(353367),
     /*    610 */ /*TargetOpcode::G_FPTOSI*//*Label 72*/ GIMT_Encode4(354303),
     /*    614 */ /*TargetOpcode::G_FPTOUI*//*Label 73*/ GIMT_Encode4(355029),
     /*    618 */ /*TargetOpcode::G_SITOFP*//*Label 74*/ GIMT_Encode4(355755),
     /*    622 */ /*TargetOpcode::G_UITOFP*//*Label 75*/ GIMT_Encode4(356488), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    634 */ /*TargetOpcode::G_FABS*//*Label 76*/ GIMT_Encode4(357221),
     /*    638 */ /*TargetOpcode::G_FCOPYSIGN*//*Label 77*/ GIMT_Encode4(358022),
     /*    642 */ /*TargetOpcode::G_IS_FPCLASS*//*Label 78*/ GIMT_Encode4(359100),
     /*    646 */ /*TargetOpcode::G_FCANONICALIZE*//*Label 79*/ GIMT_Encode4(359431),
     /*    650 */ /*TargetOpcode::G_FMINNUM*//*Label 80*/ GIMT_Encode4(360899),
     /*    654 */ /*TargetOpcode::G_FMAXNUM*//*Label 81*/ GIMT_Encode4(432678),
     /*    658 */ /*TargetOpcode::G_FMINNUM_IEEE*//*Label 82*/ GIMT_Encode4(504457),
     /*    662 */ /*TargetOpcode::G_FMAXNUM_IEEE*//*Label 83*/ GIMT_Encode4(576236),
     /*    666 */ /*TargetOpcode::G_FMINIMUM*//*Label 84*/ GIMT_Encode4(648015),
     /*    670 */ /*TargetOpcode::G_FMAXIMUM*//*Label 85*/ GIMT_Encode4(650130),
     /*    674 */ /*TargetOpcode::G_FMINIMUMNUM*//*Label 86*/ GIMT_Encode4(652245),
     /*    678 */ /*TargetOpcode::G_FMAXIMUMNUM*//*Label 87*/ GIMT_Encode4(652673), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    694 */ /*TargetOpcode::G_GET_FPMODE*//*Label 88*/ GIMT_Encode4(653101), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    710 */ /*TargetOpcode::G_PTR_ADD*//*Label 89*/ GIMT_Encode4(653225), GIMT_Encode4(0),
     /*    718 */ /*TargetOpcode::G_SMIN*//*Label 90*/ GIMT_Encode4(653749),
     /*    722 */ /*TargetOpcode::G_SMAX*//*Label 91*/ GIMT_Encode4(660715),
     /*    726 */ /*TargetOpcode::G_UMIN*//*Label 92*/ GIMT_Encode4(667849),
     /*    730 */ /*TargetOpcode::G_UMAX*//*Label 93*/ GIMT_Encode4(674815),
     /*    734 */ /*TargetOpcode::G_ABS*//*Label 94*/ GIMT_Encode4(681781), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    746 */ /*TargetOpcode::G_BR*//*Label 95*/ GIMT_Encode4(681918), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    794 */ /*TargetOpcode::G_CTTZ_ZERO_UNDEF*//*Label 96*/ GIMT_Encode4(681952), GIMT_Encode4(0),
     /*    802 */ /*TargetOpcode::G_CTLZ_ZERO_UNDEF*//*Label 97*/ GIMT_Encode4(682051),
     /*    806 */ /*TargetOpcode::G_CTPOP*//*Label 98*/ GIMT_Encode4(682153),
     /*    810 */ /*TargetOpcode::G_BSWAP*//*Label 99*/ GIMT_Encode4(682368),
     /*    814 */ /*TargetOpcode::G_BITREVERSE*//*Label 100*/ GIMT_Encode4(684117),
     /*    818 */ /*TargetOpcode::G_FCEIL*//*Label 101*/ GIMT_Encode4(684365), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    866 */ /*TargetOpcode::G_FSQRT*//*Label 102*/ GIMT_Encode4(684693),
     /*    870 */ /*TargetOpcode::G_FFLOOR*//*Label 103*/ GIMT_Encode4(684985), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    906 */ /*TargetOpcode::G_STRICT_FADD*//*Label 104*/ GIMT_Encode4(685499),
     /*    910 */ /*TargetOpcode::G_STRICT_FSUB*//*Label 105*/ GIMT_Encode4(686461),
     /*    914 */ /*TargetOpcode::G_STRICT_FMUL*//*Label 106*/ GIMT_Encode4(686825), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    926 */ /*TargetOpcode::G_STRICT_FMA*//*Label 107*/ GIMT_Encode4(688093), GIMT_Encode4(0),
     /*    934 */ /*TargetOpcode::G_STRICT_FLDEXP*//*Label 108*/ GIMT_Encode4(689139), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  15646 */ /*AMDGPU::G_AMDGPU_ATOMIC_CMPXCHG*//*Label 109*/ GIMT_Encode4(689502),
     /*  15650 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_ADD*//*Label 110*/ GIMT_Encode4(692306),
     /*  15654 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_AND*//*Label 111*/ GIMT_Encode4(694690),
     /*  15658 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_CMPSWAP*//*Label 112*/ GIMT_Encode4(697074),
     /*  15662 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_COND_SUB_U32*//*Label 113*/ GIMT_Encode4(701368),
     /*  15666 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_DEC*//*Label 114*/ GIMT_Encode4(701985),
     /*  15670 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_FADD*//*Label 115*/ GIMT_Encode4(704369),
     /*  15674 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_FMAX*//*Label 116*/ GIMT_Encode4(708011),
     /*  15678 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_FMIN*//*Label 117*/ GIMT_Encode4(711627),
     /*  15682 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_INC*//*Label 118*/ GIMT_Encode4(715243),
     /*  15686 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_OR*//*Label 119*/ GIMT_Encode4(717627),
     /*  15690 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_SMAX*//*Label 120*/ GIMT_Encode4(720011),
     /*  15694 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_SMIN*//*Label 121*/ GIMT_Encode4(722395),
     /*  15698 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_SUB*//*Label 122*/ GIMT_Encode4(724779),
     /*  15702 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_SWAP*//*Label 123*/ GIMT_Encode4(727163),
     /*  15706 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_UMAX*//*Label 124*/ GIMT_Encode4(730707),
     /*  15710 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_UMIN*//*Label 125*/ GIMT_Encode4(733091),
     /*  15714 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_XOR*//*Label 126*/ GIMT_Encode4(735475),
     /*  15718 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD*//*Label 127*/ GIMT_Encode4(737859),
     /*  15722 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_FORMAT*//*Label 128*/ GIMT_Encode4(753231),
     /*  15726 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_FORMAT_D16*//*Label 129*/ GIMT_Encode4(758235),
     /*  15730 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_FORMAT_TFE*//*Label 130*/ GIMT_Encode4(765980),
     /*  15734 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_SBYTE*//*Label 131*/ GIMT_Encode4(768548),
     /*  15738 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_SBYTE_TFE*//*Label 132*/ GIMT_Encode4(769154),
     /*  15742 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_SSHORT*//*Label 133*/ GIMT_Encode4(769760),
     /*  15746 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_SSHORT_TFE*//*Label 134*/ GIMT_Encode4(770366),
     /*  15750 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_TFE*//*Label 135*/ GIMT_Encode4(770972),
     /*  15754 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_UBYTE*//*Label 136*/ GIMT_Encode4(773492),
     /*  15758 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_UBYTE_TFE*//*Label 137*/ GIMT_Encode4(774098),
     /*  15762 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_USHORT*//*Label 138*/ GIMT_Encode4(774704),
     /*  15766 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_USHORT_TFE*//*Label 139*/ GIMT_Encode4(775310),
     /*  15770 */ /*AMDGPU::G_AMDGPU_BUFFER_STORE*//*Label 140*/ GIMT_Encode4(775916),
     /*  15774 */ /*AMDGPU::G_AMDGPU_BUFFER_STORE_BYTE*//*Label 141*/ GIMT_Encode4(791224),
     /*  15778 */ /*AMDGPU::G_AMDGPU_BUFFER_STORE_FORMAT*//*Label 142*/ GIMT_Encode4(791826),
     /*  15782 */ /*AMDGPU::G_AMDGPU_BUFFER_STORE_FORMAT_D16*//*Label 143*/ GIMT_Encode4(796814),
     /*  15786 */ /*AMDGPU::G_AMDGPU_BUFFER_STORE_SHORT*//*Label 144*/ GIMT_Encode4(804407), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  15802 */ /*AMDGPU::G_AMDGPU_CLAMP*//*Label 145*/ GIMT_Encode4(805009), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  15814 */ /*AMDGPU::G_AMDGPU_CVT_F32_UBYTE0*//*Label 146*/ GIMT_Encode4(805948),
     /*  15818 */ /*AMDGPU::G_AMDGPU_CVT_F32_UBYTE1*//*Label 147*/ GIMT_Encode4(805993),
     /*  15822 */ /*AMDGPU::G_AMDGPU_CVT_F32_UBYTE2*//*Label 148*/ GIMT_Encode4(806038),
     /*  15826 */ /*AMDGPU::G_AMDGPU_CVT_F32_UBYTE3*//*Label 149*/ GIMT_Encode4(806083),
     /*  15830 */ /*AMDGPU::G_AMDGPU_CVT_PK_I16_I32*//*Label 150*/ GIMT_Encode4(806128),
     /*  15834 */ /*AMDGPU::G_AMDGPU_FFBH_U32*//*Label 151*/ GIMT_Encode4(806158),
     /*  15838 */ /*AMDGPU::G_AMDGPU_FFBL_B32*//*Label 152*/ GIMT_Encode4(806260),
     /*  15842 */ /*AMDGPU::G_AMDGPU_FMAX_LEGACY*//*Label 153*/ GIMT_Encode4(806359),
     /*  15846 */ /*AMDGPU::G_AMDGPU_FMED3*//*Label 154*/ GIMT_Encode4(806432),
     /*  15850 */ /*AMDGPU::G_AMDGPU_FMIN_LEGACY*//*Label 155*/ GIMT_Encode4(806792), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  15874 */ /*AMDGPU::G_AMDGPU_LOAD_D16_HI*//*Label 156*/ GIMT_Encode4(806865),
     /*  15878 */ /*AMDGPU::G_AMDGPU_LOAD_D16_HI_I8*//*Label 157*/ GIMT_Encode4(808069),
     /*  15882 */ /*AMDGPU::G_AMDGPU_LOAD_D16_HI_U8*//*Label 158*/ GIMT_Encode4(809273),
     /*  15886 */ /*AMDGPU::G_AMDGPU_LOAD_D16_LO*//*Label 159*/ GIMT_Encode4(810477),
     /*  15890 */ /*AMDGPU::G_AMDGPU_LOAD_D16_LO_I8*//*Label 160*/ GIMT_Encode4(811681),
     /*  15894 */ /*AMDGPU::G_AMDGPU_LOAD_D16_LO_U8*//*Label 161*/ GIMT_Encode4(812885), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  15906 */ /*AMDGPU::G_AMDGPU_RCP_IFLAG*//*Label 162*/ GIMT_Encode4(814089), GIMT_Encode4(0),
     /*  15914 */ /*AMDGPU::G_AMDGPU_SMED3*//*Label 163*/ GIMT_Encode4(814139),
     /*  15918 */ /*AMDGPU::G_AMDGPU_S_BUFFER_LOAD*//*Label 164*/ GIMT_Encode4(814445),
     /*  15922 */ /*AMDGPU::G_AMDGPU_S_BUFFER_LOAD_SBYTE*//*Label 165*/ GIMT_Encode4(816747),
     /*  15926 */ /*AMDGPU::G_AMDGPU_S_BUFFER_LOAD_SSHORT*//*Label 166*/ GIMT_Encode4(816885),
     /*  15930 */ /*AMDGPU::G_AMDGPU_S_BUFFER_LOAD_UBYTE*//*Label 167*/ GIMT_Encode4(817023),
     /*  15934 */ /*AMDGPU::G_AMDGPU_S_BUFFER_LOAD_USHORT*//*Label 168*/ GIMT_Encode4(817161),
     /*  15938 */ /*AMDGPU::G_AMDGPU_S_BUFFER_PREFETCH*//*Label 169*/ GIMT_Encode4(817299), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  15950 */ /*AMDGPU::G_AMDGPU_TBUFFER_LOAD_FORMAT*//*Label 170*/ GIMT_Encode4(817406),
     /*  15954 */ /*AMDGPU::G_AMDGPU_TBUFFER_LOAD_FORMAT_D16*//*Label 171*/ GIMT_Encode4(822986),
     /*  15958 */ /*AMDGPU::G_AMDGPU_TBUFFER_STORE_FORMAT*//*Label 172*/ GIMT_Encode4(828415),
     /*  15962 */ /*AMDGPU::G_AMDGPU_TBUFFER_STORE_FORMAT_D16*//*Label 173*/ GIMT_Encode4(833979),
     /*  15966 */ /*AMDGPU::G_AMDGPU_UMED3*//*Label 174*/ GIMT_Encode4(839320), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  15978 */ /*AMDGPU::G_AMDGPU_WHOLE_WAVE_FUNC_SETUP*//*Label 175*/ GIMT_Encode4(839626),
     /*  15982 */ // Label 0: @15982
     /*  15982 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(7), GIMT_Encode2(12), /*)*//*default:*//*Label 182*/ GIMT_Encode4(39545),
     /*  15993 */ /*GILLT_s1*//*Label 177*/ GIMT_Encode4(16013),
     /*  15997 */ /*GILLT_s16*//*Label 178*/ GIMT_Encode4(16132),
     /*  16001 */ /*GILLT_s32*//*Label 179*/ GIMT_Encode4(17123),
     /*  16005 */ /*GILLT_s64*//*Label 180*/ GIMT_Encode4(38804),
     /*  16009 */ /*GILLT_v2s16*//*Label 181*/ GIMT_Encode4(39275),
     /*  16013 */ // Label 177: @16013
     /*  16013 */ GIM_Try, /*On fail goto*//*Label 183*/ GIMT_Encode4(16131),
     /*  16018 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
     /*  16021 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
     /*  16024 */   GIM_Try, /*On fail goto*//*Label 184*/ GIMT_Encode4(16052), // Rule ID 8223 //
     /*  16029 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
     /*  16032 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  16036 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 255,
     /*  16040 */     // (add:{ *:[i1] } i1:{ *:[i1] }:$src0, -1:{ *:[i1] })  =>  (S_NOT_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0)
     /*  16040 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_NOT_B64),
     /*  16043 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  16045 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  16047 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  16050 */     GIR_RootConstrainSelectedInstOperands,
     /*  16051 */     // GIR_Coverage, 8223,
     /*  16051 */     GIR_EraseRootFromParent_Done,
     /*  16052 */   // Label 184: @16052
     /*  16052 */   GIM_Try, /*On fail goto*//*Label 185*/ GIMT_Encode4(16080), // Rule ID 8230 //
     /*  16057 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
     /*  16060 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  16064 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 255,
     /*  16068 */     // (add:{ *:[i1] } i1:{ *:[i1] }:$src0, -1:{ *:[i1] })  =>  (S_NOT_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0)
     /*  16068 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_NOT_B32),
     /*  16071 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  16073 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  16075 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  16078 */     GIR_RootConstrainSelectedInstOperands,
     /*  16079 */     // GIR_Coverage, 8230,
     /*  16079 */     GIR_EraseRootFromParent_Done,
     /*  16080 */   // Label 185: @16080
     /*  16080 */   GIM_Try, /*On fail goto*//*Label 186*/ GIMT_Encode4(16105), // Rule ID 8221 //
     /*  16085 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
     /*  16088 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  16092 */     // (add:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_XOR_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
     /*  16092 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_XOR_B64),
     /*  16097 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  16103 */     GIR_RootConstrainSelectedInstOperands,
     /*  16104 */     // GIR_Coverage, 8221,
     /*  16104 */     GIR_Done,
     /*  16105 */   // Label 186: @16105
     /*  16105 */   GIM_Try, /*On fail goto*//*Label 187*/ GIMT_Encode4(16130), // Rule ID 8228 //
     /*  16110 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
     /*  16113 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  16117 */     // (add:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_XOR_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
     /*  16117 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_XOR_B32),
     /*  16122 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  16128 */     GIR_RootConstrainSelectedInstOperands,
     /*  16129 */     // GIR_Coverage, 8228,
     /*  16129 */     GIR_Done,
     /*  16130 */   // Label 187: @16130
     /*  16130 */   GIM_Reject,
     /*  16131 */ // Label 183: @16131
     /*  16131 */ GIM_Reject,
     /*  16132 */ // Label 178: @16132
     /*  16132 */ GIM_Try, /*On fail goto*//*Label 188*/ GIMT_Encode4(17122),
     /*  16137 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
     /*  16140 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
     /*  16143 */   GIM_Try, /*On fail goto*//*Label 189*/ GIMT_Encode4(16195), // Rule ID 7672 //
     /*  16148 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  16152 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16156 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /*  16160 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  16164 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  16168 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CTPOP),
     /*  16172 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  16176 */     GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_40326),
     /*  16180 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  16182 */     // (add:{ *:[i16] } (trunc:{ *:[i16] } (ctpop:{ *:[i32] } i32:{ *:[i32] }:$popcnt)<<P:Predicate_anonymous_40326>>), i16:{ *:[i16] }:$val)  =>  (V_BCNT_U32_B32_e64:{ *:[i16] } ?:{ *:[i32] }:$popcnt, ?:{ *:[i16] }:$val)
     /*  16182 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BCNT_U32_B32_e64),
     /*  16185 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16187 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // popcnt
     /*  16191 */     GIR_RootToRootCopy, /*OpIdx*/2, // val
     /*  16193 */     GIR_RootConstrainSelectedInstOperands,
     /*  16194 */     // GIR_Coverage, 7672,
     /*  16194 */     GIR_EraseRootFromParent_Done,
     /*  16195 */   // Label 189: @16195
     /*  16195 */   GIM_Try, /*On fail goto*//*Label 190*/ GIMT_Encode4(16247), // Rule ID 12007 //
     /*  16200 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  16204 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16208 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /*  16212 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  16216 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  16220 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CTPOP),
     /*  16224 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  16228 */     GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_40326),
     /*  16232 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  16234 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$val, (trunc:{ *:[i16] } (ctpop:{ *:[i32] } i32:{ *:[i32] }:$popcnt)<<P:Predicate_anonymous_40326>>))  =>  (V_BCNT_U32_B32_e64:{ *:[i16] } ?:{ *:[i32] }:$popcnt, ?:{ *:[i16] }:$val)
     /*  16234 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BCNT_U32_B32_e64),
     /*  16237 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16239 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // popcnt
     /*  16243 */     GIR_RootToRootCopy, /*OpIdx*/1, // val
     /*  16245 */     GIR_RootConstrainSelectedInstOperands,
     /*  16246 */     // GIR_Coverage, 12007,
     /*  16246 */     GIR_EraseRootFromParent_Done,
     /*  16247 */   // Label 190: @16247
     /*  16247 */   GIM_Try, /*On fail goto*//*Label 191*/ GIMT_Encode4(16290), // Rule ID 2645 //
     /*  16252 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_isGFX8GFX9),
     /*  16255 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  16259 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16263 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  16267 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineIntConst16),
     /*  16271 */     // MIs[1] Operand 1
     /*  16271 */     // No operand predicates
     /*  16271 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16273 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>><<X:NegateImm>>:$src1)  =>  (V_SUB_U16_e64:{ *:[i16] } VSrc_b16:{ *:[i16] }:$src0, (NegateImm:{ *:[i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>>:$src1))
     /*  16273 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_U16_e64),
     /*  16276 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16278 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  16280 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
     /*  16285 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16288 */     GIR_RootConstrainSelectedInstOperands,
     /*  16289 */     // GIR_Coverage, 2645,
     /*  16289 */     GIR_EraseRootFromParent_Done,
     /*  16290 */   // Label 191: @16290
     /*  16290 */   GIM_Try, /*On fail goto*//*Label 192*/ GIMT_Encode4(16342), // Rule ID 2819 //
     /*  16295 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotHasTrue16BitInsts_isGFX10Plus),
     /*  16298 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  16302 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16306 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  16310 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineIntConst16),
     /*  16314 */     // MIs[1] Operand 1
     /*  16314 */     // No operand predicates
     /*  16314 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16316 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>><<X:NegateImm>>:$src1)  =>  (V_SUB_NC_U16_e64:{ *:[i16] } 0:{ *:[i32] }, VSrc_b16:{ *:[i16] }:$src0, 0:{ *:[i32] }, (NegateImm:{ *:[i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>>:$src1), 0:{ *:[i1] }, 0:{ *:[i32] })
     /*  16316 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_NC_U16_e64),
     /*  16319 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16321 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16324 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  16326 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16329 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
     /*  16334 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16337 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16340 */     GIR_RootConstrainSelectedInstOperands,
     /*  16341 */     // GIR_Coverage, 2819,
     /*  16341 */     GIR_EraseRootFromParent_Done,
     /*  16342 */   // Label 192: @16342
     /*  16342 */   GIM_Try, /*On fail goto*//*Label 193*/ GIMT_Encode4(16394), // Rule ID 2822 //
     /*  16347 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseRealTrue16Insts),
     /*  16350 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
     /*  16354 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16358 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  16362 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineIntConst16),
     /*  16366 */     // MIs[1] Operand 1
     /*  16366 */     // No operand predicates
     /*  16366 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16368 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>><<X:NegateImm>>:$src1)  =>  (V_SUB_NC_U16_t16_e64:{ *:[i16] } 0:{ *:[i32] }, VSrc_b16:{ *:[i16] }:$src0, 0:{ *:[i32] }, (NegateImm:{ *:[i16 bf16 f16] } (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>>:$src1), 0:{ *:[i1] }, 0:{ *:[i32] })
     /*  16368 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_NC_U16_t16_e64),
     /*  16371 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16373 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16376 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  16378 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16381 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
     /*  16386 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16389 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16392 */     GIR_RootConstrainSelectedInstOperands,
     /*  16393 */     // GIR_Coverage, 2822,
     /*  16393 */     GIR_EraseRootFromParent_Done,
     /*  16394 */   // Label 193: @16394
     /*  16394 */   GIM_Try, /*On fail goto*//*Label 194*/ GIMT_Encode4(16446), // Rule ID 2825 //
     /*  16399 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts),
     /*  16402 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  16406 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16410 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  16414 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineIntConst16),
     /*  16418 */     // MIs[1] Operand 1
     /*  16418 */     // No operand predicates
     /*  16418 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16420 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>><<X:NegateImm>>:$src1)  =>  (V_SUB_NC_U16_fake16_e64:{ *:[i16] } 0:{ *:[i32] }, VSrc_b16:{ *:[i16] }:$src0, 0:{ *:[i32] }, (NegateImm:{ *:[i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>>:$src1), 0:{ *:[i1] }, 0:{ *:[i32] })
     /*  16420 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_NC_U16_fake16_e64),
     /*  16423 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16425 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16428 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  16430 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16433 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
     /*  16438 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16441 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16444 */     GIR_RootConstrainSelectedInstOperands,
     /*  16445 */     // GIR_Coverage, 2825,
     /*  16445 */     GIR_EraseRootFromParent_Done,
     /*  16446 */   // Label 194: @16446
     /*  16446 */   GIM_Try, /*On fail goto*//*Label 195*/ GIMT_Encode4(16496), // Rule ID 2690 //
     /*  16451 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9),
     /*  16454 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  16458 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16462 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  16466 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  16470 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  16474 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16476 */     // (add:{ *:[i16] } (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1), i16:{ *:[i16] }:$src2)  =>  (V_MAD_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, i16:{ *:[i16] }:$src2, 0:{ *:[i1] })
     /*  16476 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_e64),
     /*  16479 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16481 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  16485 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  16489 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  16491 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16494 */     GIR_RootConstrainSelectedInstOperands,
     /*  16495 */     // GIR_Coverage, 2690,
     /*  16495 */     GIR_EraseRootFromParent_Done,
     /*  16496 */   // Label 195: @16496
     /*  16496 */   GIM_Try, /*On fail goto*//*Label 196*/ GIMT_Encode4(16558), // Rule ID 2691 //
     /*  16501 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseRealTrue16Insts),
     /*  16504 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
     /*  16508 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16512 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  16516 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  16520 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  16524 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16526 */     // (add:{ *:[i16] } (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1), i16:{ *:[i16] }:$src2)  =>  (V_MAD_U16_gfx9_t16_e64:{ *:[i16] } 0:{ *:[i32] }, ?:{ *:[i16] }:$src0, 0:{ *:[i32] }, ?:{ *:[i16] }:$src1, 0:{ *:[i32] }, ?:{ *:[i16] }:$src2, 0:{ *:[i1] })
     /*  16526 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_gfx9_t16_e64),
     /*  16529 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16531 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16534 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  16538 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16541 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  16545 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16548 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  16550 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16553 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16556 */     GIR_RootConstrainSelectedInstOperands,
     /*  16557 */     // GIR_Coverage, 2691,
     /*  16557 */     GIR_EraseRootFromParent_Done,
     /*  16558 */   // Label 196: @16558
     /*  16558 */   GIM_Try, /*On fail goto*//*Label 197*/ GIMT_Encode4(16620), // Rule ID 2692 //
     /*  16563 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts),
     /*  16566 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  16570 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16574 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  16578 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  16582 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  16586 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16588 */     // (add:{ *:[i16] } (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1), i16:{ *:[i16] }:$src2)  =>  (V_MAD_U16_gfx9_fake16_e64:{ *:[i16] } 0:{ *:[i32] }, ?:{ *:[i16] }:$src0, 0:{ *:[i32] }, ?:{ *:[i16] }:$src1, 0:{ *:[i32] }, ?:{ *:[i16] }:$src2, 0:{ *:[i1] })
     /*  16588 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_gfx9_fake16_e64),
     /*  16591 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16593 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16596 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  16600 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16603 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  16607 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16610 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  16612 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16615 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16618 */     GIR_RootConstrainSelectedInstOperands,
     /*  16619 */     // GIR_Coverage, 2692,
     /*  16619 */     GIR_EraseRootFromParent_Done,
     /*  16620 */   // Label 197: @16620
     /*  16620 */   GIM_Try, /*On fail goto*//*Label 198*/ GIMT_Encode4(16682), // Rule ID 2693 //
     /*  16625 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_NotHasTrue16BitInsts_isGFX10Plus),
     /*  16628 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  16632 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16636 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  16640 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  16644 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  16648 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16650 */     // (add:{ *:[i16] } (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1), i16:{ *:[i16] }:$src2)  =>  (V_MAD_U16_gfx9_e64:{ *:[i16] } 0:{ *:[i32] }, ?:{ *:[i16] }:$src0, 0:{ *:[i32] }, ?:{ *:[i16] }:$src1, 0:{ *:[i32] }, ?:{ *:[i16] }:$src2, 0:{ *:[i1] })
     /*  16650 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_gfx9_e64),
     /*  16653 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16655 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16658 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  16662 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16665 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  16669 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16672 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  16674 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16677 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16680 */     GIR_RootConstrainSelectedInstOperands,
     /*  16681 */     // GIR_Coverage, 2693,
     /*  16681 */     GIR_EraseRootFromParent_Done,
     /*  16682 */   // Label 198: @16682
     /*  16682 */   GIM_Try, /*On fail goto*//*Label 199*/ GIMT_Encode4(16732), // Rule ID 9330 //
     /*  16687 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9),
     /*  16690 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  16694 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16698 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  16702 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  16706 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  16710 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16712 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src2, (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1))  =>  (V_MAD_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, i16:{ *:[i16] }:$src2, 0:{ *:[i1] })
     /*  16712 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_e64),
     /*  16715 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16717 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  16721 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  16725 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  16727 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16730 */     GIR_RootConstrainSelectedInstOperands,
     /*  16731 */     // GIR_Coverage, 9330,
     /*  16731 */     GIR_EraseRootFromParent_Done,
     /*  16732 */   // Label 199: @16732
     /*  16732 */   GIM_Try, /*On fail goto*//*Label 200*/ GIMT_Encode4(16794), // Rule ID 9331 //
     /*  16737 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseRealTrue16Insts),
     /*  16740 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
     /*  16744 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16748 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  16752 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  16756 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  16760 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16762 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src2, (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1))  =>  (V_MAD_U16_gfx9_t16_e64:{ *:[i16] } 0:{ *:[i32] }, ?:{ *:[i16] }:$src0, 0:{ *:[i32] }, ?:{ *:[i16] }:$src1, 0:{ *:[i32] }, ?:{ *:[i16] }:$src2, 0:{ *:[i1] })
     /*  16762 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_gfx9_t16_e64),
     /*  16765 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16767 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16770 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  16774 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16777 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  16781 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16784 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  16786 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16789 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16792 */     GIR_RootConstrainSelectedInstOperands,
     /*  16793 */     // GIR_Coverage, 9331,
     /*  16793 */     GIR_EraseRootFromParent_Done,
     /*  16794 */   // Label 200: @16794
     /*  16794 */   GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(16856), // Rule ID 9332 //
     /*  16799 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts),
     /*  16802 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  16806 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16810 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  16814 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  16818 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  16822 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16824 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src2, (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1))  =>  (V_MAD_U16_gfx9_fake16_e64:{ *:[i16] } 0:{ *:[i32] }, ?:{ *:[i16] }:$src0, 0:{ *:[i32] }, ?:{ *:[i16] }:$src1, 0:{ *:[i32] }, ?:{ *:[i16] }:$src2, 0:{ *:[i1] })
     /*  16824 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_gfx9_fake16_e64),
     /*  16827 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16829 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16832 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  16836 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16839 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  16843 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16846 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  16848 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16851 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16854 */     GIR_RootConstrainSelectedInstOperands,
     /*  16855 */     // GIR_Coverage, 9332,
     /*  16855 */     GIR_EraseRootFromParent_Done,
     /*  16856 */   // Label 201: @16856
     /*  16856 */   GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(16918), // Rule ID 9333 //
     /*  16861 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_NotHasTrue16BitInsts_isGFX10Plus),
     /*  16864 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  16868 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16872 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  16876 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  16880 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  16884 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16886 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src2, (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1))  =>  (V_MAD_U16_gfx9_e64:{ *:[i16] } 0:{ *:[i32] }, ?:{ *:[i16] }:$src0, 0:{ *:[i32] }, ?:{ *:[i16] }:$src1, 0:{ *:[i32] }, ?:{ *:[i16] }:$src2, 0:{ *:[i1] })
     /*  16886 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_gfx9_e64),
     /*  16889 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16891 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16894 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  16898 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16901 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  16905 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16908 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  16910 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16913 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16916 */     GIR_RootConstrainSelectedInstOperands,
     /*  16917 */     // GIR_Coverage, 9333,
     /*  16917 */     GIR_EraseRootFromParent_Done,
     /*  16918 */   // Label 202: @16918
     /*  16918 */   GIM_Try, /*On fail goto*//*Label 203*/ GIMT_Encode4(16977), // Rule ID 1105 //
     /*  16923 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotHasTrue16BitInsts_isGFX10Plus),
     /*  16926 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  16930 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opsel),
     /*  16937 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opsel),
     /*  16944 */     // (add:{ *:[i16] } (VOP3OpSel:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSel:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_ADD_NC_U16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  16944 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_NC_U16_e64),
     /*  16947 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16949 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  16954 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  16959 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  16964 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  16969 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16972 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16975 */     GIR_RootConstrainSelectedInstOperands,
     /*  16976 */     // GIR_Coverage, 1105,
     /*  16976 */     GIR_EraseRootFromParent_Done,
     /*  16977 */   // Label 203: @16977
     /*  16977 */   GIM_Try, /*On fail goto*//*Label 204*/ GIMT_Encode4(17036), // Rule ID 1106 //
     /*  16982 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseRealTrue16Insts_isGFX10Plus),
     /*  16985 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
     /*  16989 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  16996 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  17003 */     // (add:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_ADD_NC_U16_t16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  17003 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_NC_U16_t16_e64),
     /*  17006 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  17008 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  17013 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  17018 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  17023 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  17028 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  17031 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  17034 */     GIR_RootConstrainSelectedInstOperands,
     /*  17035 */     // GIR_Coverage, 1106,
     /*  17035 */     GIR_EraseRootFromParent_Done,
     /*  17036 */   // Label 204: @17036
     /*  17036 */   GIM_Try, /*On fail goto*//*Label 205*/ GIMT_Encode4(17095), // Rule ID 1107 //
     /*  17041 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts_isGFX10Plus),
     /*  17044 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  17048 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  17055 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  17062 */     // (add:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_ADD_NC_U16_fake16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  17062 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_NC_U16_fake16_e64),
     /*  17065 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  17067 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  17072 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  17077 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  17082 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  17087 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  17090 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  17093 */     GIR_RootConstrainSelectedInstOperands,
     /*  17094 */     // GIR_Coverage, 1107,
     /*  17094 */     GIR_EraseRootFromParent_Done,
     /*  17095 */   // Label 205: @17095
     /*  17095 */   GIM_Try, /*On fail goto*//*Label 206*/ GIMT_Encode4(17121), // Rule ID 944 //
     /*  17100 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX8GFX9),
     /*  17103 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  17107 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_ADD_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
     /*  17107 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_U16_e64),
     /*  17110 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  17112 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  17114 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  17116 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  17119 */     GIR_RootConstrainSelectedInstOperands,
     /*  17120 */     // GIR_Coverage, 944,
     /*  17120 */     GIR_EraseRootFromParent_Done,
     /*  17121 */   // Label 206: @17121
     /*  17121 */   GIM_Reject,
     /*  17122 */ // Label 188: @17122
     /*  17122 */ GIM_Reject,
     /*  17123 */ // Label 179: @17123
     /*  17123 */ GIM_Try, /*On fail goto*//*Label 207*/ GIMT_Encode4(38803),
     /*  17128 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  17131 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  17134 */   GIM_Try, /*On fail goto*//*Label 208*/ GIMT_Encode4(17639), // Rule ID 9452 //
     /*  17139 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  17142 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  17144 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  17148 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17152 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  17156 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  17159 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  17164 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  17168 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  17172 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  17174 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  17178 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17182 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  17186 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  17190 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  17194 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  17198 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17202 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  17206 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  17210 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  17214 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  17218 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  17222 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  17226 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  17230 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  17232 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  17236 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  17240 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  17243 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  17248 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  17252 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  17256 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  17258 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  17262 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17266 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  17270 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  17274 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  17278 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17282 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  17286 */     // MIs[7] src0
     /*  17286 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  17291 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  17295 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
     /*  17306 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
     /*  17310 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17314 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  17318 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  17322 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  17326 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17330 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  17334 */     // MIs[9] src1
     /*  17334 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  17339 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
     /*  17343 */     GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
     /*  17354 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
     /*  17358 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  17362 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  17366 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  17370 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  17372 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  17376 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  17380 */     GIM_CheckNumOperands, /*MI*/11, /*Expected*/4,
     /*  17383 */     GIM_CheckIntrinsicID, /*MI*/11, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  17388 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  17392 */     GIM_CheckType, /*MI*/11, /*Op*/3, /*Type*/GILLT_s32,
     /*  17396 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  17398 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
     /*  17402 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17406 */     GIM_CheckType, /*MI*/12, /*Op*/1, /*Type*/GILLT_s32,
     /*  17410 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  17414 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/1, // MIs[13]
     /*  17418 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17422 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  17426 */     // MIs[13] src0
     /*  17426 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  17431 */     GIM_CheckConstantInt8, /*MI*/13, /*Op*/2, 8,
     /*  17435 */     GIM_CheckConstantInt, /*MI*/12, /*Op*/2, GIMT_Encode8(255),
     /*  17446 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/11, /*OpIdx*/3, // MIs[14]
     /*  17450 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17454 */     GIM_CheckType, /*MI*/14, /*Op*/1, /*Type*/GILLT_s32,
     /*  17458 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  17462 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/1, // MIs[15]
     /*  17466 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17470 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  17474 */     // MIs[15] src1
     /*  17474 */     GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  17479 */     GIM_CheckConstantInt8, /*MI*/15, /*Op*/2, 8,
     /*  17483 */     GIM_CheckConstantInt, /*MI*/14, /*Op*/2, GIMT_Encode8(255),
     /*  17494 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/10, /*OpIdx*/2, // MIs[16]
     /*  17498 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  17502 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  17506 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  17510 */     GIM_CheckHasOneUse, /*MI*/16,
     /*  17512 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  17516 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  17520 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  17523 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  17528 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  17532 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  17536 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  17538 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  17542 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17546 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  17550 */     // MIs[18] src0
     /*  17550 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  17555 */     GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
     /*  17566 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  17570 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17574 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  17578 */     // MIs[19] src1
     /*  17578 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  17583 */     GIM_CheckConstantInt, /*MI*/19, /*Op*/2, GIMT_Encode8(255),
     /*  17594 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  17596 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  17596 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  17599 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  17601 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  17604 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  17608 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  17611 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  17615 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  17618 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/16, /*OpIdx*/2, // src2
     /*  17622 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  17625 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  17628 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  17631 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  17634 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  17637 */     GIR_RootConstrainSelectedInstOperands,
     /*  17638 */     // GIR_Coverage, 9452,
     /*  17638 */     GIR_EraseRootFromParent_Done,
     /*  17639 */   // Label 208: @17639
     /*  17639 */   GIM_Try, /*On fail goto*//*Label 209*/ GIMT_Encode4(18144), // Rule ID 9451 //
     /*  17644 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  17647 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  17649 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  17653 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17657 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  17661 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  17664 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  17669 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  17673 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  17677 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  17679 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  17683 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17687 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  17691 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  17695 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  17699 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  17703 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17707 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  17711 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  17715 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  17719 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  17723 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  17727 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  17731 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  17735 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  17737 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  17741 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  17745 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  17748 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  17753 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  17757 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  17761 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  17763 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  17767 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17771 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  17775 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  17779 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  17783 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17787 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  17791 */     // MIs[7] src0
     /*  17791 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  17796 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  17800 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
     /*  17811 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
     /*  17815 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17819 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  17823 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  17827 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  17831 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17835 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  17839 */     // MIs[9] src1
     /*  17839 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  17844 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
     /*  17848 */     GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
     /*  17859 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
     /*  17863 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  17867 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  17871 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  17875 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  17877 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  17881 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  17885 */     GIM_CheckNumOperands, /*MI*/11, /*Expected*/4,
     /*  17888 */     GIM_CheckIntrinsicID, /*MI*/11, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  17893 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  17897 */     GIM_CheckType, /*MI*/11, /*Op*/3, /*Type*/GILLT_s32,
     /*  17901 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  17903 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
     /*  17907 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17911 */     GIM_CheckType, /*MI*/12, /*Op*/1, /*Type*/GILLT_s32,
     /*  17915 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  17919 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/1, // MIs[13]
     /*  17923 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17927 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  17931 */     // MIs[13] src0
     /*  17931 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  17936 */     GIM_CheckConstantInt8, /*MI*/13, /*Op*/2, 8,
     /*  17940 */     GIM_CheckConstantInt, /*MI*/12, /*Op*/2, GIMT_Encode8(255),
     /*  17951 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/11, /*OpIdx*/3, // MIs[14]
     /*  17955 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17959 */     GIM_CheckType, /*MI*/14, /*Op*/1, /*Type*/GILLT_s32,
     /*  17963 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  17967 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/1, // MIs[15]
     /*  17971 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17975 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  17979 */     // MIs[15] src1
     /*  17979 */     GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  17984 */     GIM_CheckConstantInt8, /*MI*/15, /*Op*/2, 8,
     /*  17988 */     GIM_CheckConstantInt, /*MI*/14, /*Op*/2, GIMT_Encode8(255),
     /*  17999 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/10, /*OpIdx*/2, // MIs[16]
     /*  18003 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18007 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  18011 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  18015 */     GIM_CheckHasOneUse, /*MI*/16,
     /*  18017 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/2, // MIs[17]
     /*  18021 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18025 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  18028 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  18033 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  18037 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  18041 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  18043 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  18047 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18051 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  18055 */     // MIs[18] src0
     /*  18055 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  18060 */     GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
     /*  18071 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  18075 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18079 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  18083 */     // MIs[19] src1
     /*  18083 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  18088 */     GIM_CheckConstantInt, /*MI*/19, /*Op*/2, GIMT_Encode8(255),
     /*  18099 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  18101 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  18101 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  18104 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  18106 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  18109 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  18113 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  18116 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  18120 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  18123 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/16, /*OpIdx*/1, // src2
     /*  18127 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18130 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18133 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18136 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18139 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18142 */     GIR_RootConstrainSelectedInstOperands,
     /*  18143 */     // GIR_Coverage, 9451,
     /*  18143 */     GIR_EraseRootFromParent_Done,
     /*  18144 */   // Label 209: @18144
     /*  18144 */   GIM_Try, /*On fail goto*//*Label 210*/ GIMT_Encode4(18649), // Rule ID 9450 //
     /*  18149 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  18152 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  18154 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  18158 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18162 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18166 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  18169 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  18174 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  18178 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  18182 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  18184 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  18188 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18192 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  18196 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  18200 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  18204 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  18208 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18212 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  18216 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  18220 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  18224 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  18228 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18232 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  18236 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  18240 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  18242 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  18246 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18250 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  18253 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  18258 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  18262 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  18266 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  18268 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  18272 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18276 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  18280 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  18284 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  18288 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18292 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  18296 */     // MIs[7] src0
     /*  18296 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  18301 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  18305 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
     /*  18316 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
     /*  18320 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18324 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  18328 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  18332 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  18336 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18340 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  18344 */     // MIs[9] src1
     /*  18344 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  18349 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
     /*  18353 */     GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
     /*  18364 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
     /*  18368 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18372 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  18376 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  18380 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  18382 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  18386 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18390 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  18394 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  18398 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  18400 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  18404 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18408 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  18411 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  18416 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  18420 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  18424 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  18426 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  18430 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18434 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  18438 */     // MIs[13] src0
     /*  18438 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  18443 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  18454 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
     /*  18458 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18462 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  18466 */     // MIs[14] src1
     /*  18466 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  18471 */     GIM_CheckConstantInt, /*MI*/14, /*Op*/2, GIMT_Encode8(255),
     /*  18482 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/10, /*OpIdx*/2, // MIs[15]
     /*  18486 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18490 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  18493 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  18498 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  18502 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  18506 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  18508 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  18512 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18516 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  18520 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  18524 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  18528 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18532 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  18536 */     // MIs[17] src0
     /*  18536 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  18541 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 8,
     /*  18545 */     GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
     /*  18556 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  18560 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18564 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  18568 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  18572 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  18576 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18580 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  18584 */     // MIs[19] src1
     /*  18584 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  18589 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 8,
     /*  18593 */     GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
     /*  18604 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  18606 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  18606 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  18609 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  18611 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  18614 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  18618 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  18621 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  18625 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  18628 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/2, // src2
     /*  18632 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18635 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18638 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18641 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18644 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18647 */     GIR_RootConstrainSelectedInstOperands,
     /*  18648 */     // GIR_Coverage, 9450,
     /*  18648 */     GIR_EraseRootFromParent_Done,
     /*  18649 */   // Label 210: @18649
     /*  18649 */   GIM_Try, /*On fail goto*//*Label 211*/ GIMT_Encode4(19154), // Rule ID 9449 //
     /*  18654 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  18657 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  18659 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  18663 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18667 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18671 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  18674 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  18679 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  18683 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  18687 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  18689 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  18693 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18697 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  18701 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  18705 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  18709 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  18713 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18717 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  18721 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  18725 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  18729 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  18733 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18737 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  18741 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  18745 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  18747 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  18751 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18755 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  18758 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  18763 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  18767 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  18771 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  18773 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  18777 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18781 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  18785 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  18789 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  18793 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18797 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  18801 */     // MIs[7] src0
     /*  18801 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  18806 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  18810 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
     /*  18821 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
     /*  18825 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18829 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  18833 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  18837 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  18841 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18845 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  18849 */     // MIs[9] src1
     /*  18849 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  18854 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
     /*  18858 */     GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
     /*  18869 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
     /*  18873 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18877 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  18881 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  18885 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  18887 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  18891 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18895 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  18899 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  18903 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  18905 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
     /*  18909 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18913 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  18916 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  18921 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  18925 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  18929 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  18931 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  18935 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18939 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  18943 */     // MIs[13] src0
     /*  18943 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  18948 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  18959 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
     /*  18963 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18967 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  18971 */     // MIs[14] src1
     /*  18971 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  18976 */     GIM_CheckConstantInt, /*MI*/14, /*Op*/2, GIMT_Encode8(255),
     /*  18987 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/10, /*OpIdx*/2, // MIs[15]
     /*  18991 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18995 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  18998 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  19003 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  19007 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  19011 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  19013 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  19017 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19021 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  19025 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  19029 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  19033 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19037 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  19041 */     // MIs[17] src0
     /*  19041 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  19046 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 8,
     /*  19050 */     GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
     /*  19061 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  19065 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19069 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  19073 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  19077 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  19081 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19085 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  19089 */     // MIs[19] src1
     /*  19089 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  19094 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 8,
     /*  19098 */     GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
     /*  19109 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  19111 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  19111 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  19114 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  19116 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  19119 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  19123 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  19126 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  19130 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  19133 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/1, // src2
     /*  19137 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  19140 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  19143 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  19146 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  19149 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  19152 */     GIR_RootConstrainSelectedInstOperands,
     /*  19153 */     // GIR_Coverage, 9449,
     /*  19153 */     GIR_EraseRootFromParent_Done,
     /*  19154 */   // Label 211: @19154
     /*  19154 */   GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(19659), // Rule ID 9448 //
     /*  19159 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  19162 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  19164 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  19168 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19172 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  19176 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  19179 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  19184 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  19188 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  19192 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  19194 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  19198 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19202 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  19206 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  19210 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  19214 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  19218 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19222 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  19226 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  19230 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  19234 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  19238 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  19242 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  19246 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  19250 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  19252 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  19256 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  19260 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  19264 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  19268 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  19270 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  19274 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  19278 */     GIM_CheckNumOperands, /*MI*/6, /*Expected*/4,
     /*  19281 */     GIM_CheckIntrinsicID, /*MI*/6, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  19286 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  19290 */     GIM_CheckType, /*MI*/6, /*Op*/3, /*Type*/GILLT_s32,
     /*  19294 */     GIM_CheckHasOneUse, /*MI*/6,
     /*  19296 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/2, // MIs[7]
     /*  19300 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19304 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  19308 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  19312 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  19316 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19320 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  19324 */     // MIs[8] src0
     /*  19324 */     GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  19329 */     GIM_CheckConstantInt8, /*MI*/8, /*Op*/2, 8,
     /*  19333 */     GIM_CheckConstantInt, /*MI*/7, /*Op*/2, GIMT_Encode8(255),
     /*  19344 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/6, /*OpIdx*/3, // MIs[9]
     /*  19348 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19352 */     GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
     /*  19356 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  19360 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
     /*  19364 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19368 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  19372 */     // MIs[10] src1
     /*  19372 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  19377 */     GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
     /*  19381 */     GIM_CheckConstantInt, /*MI*/9, /*Op*/2, GIMT_Encode8(255),
     /*  19392 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/5, /*OpIdx*/2, // MIs[11]
     /*  19396 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  19400 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  19404 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  19408 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  19410 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  19414 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  19418 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  19421 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  19426 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  19430 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  19434 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  19436 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  19440 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19444 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  19448 */     // MIs[13] src0
     /*  19448 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  19453 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  19464 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
     /*  19468 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19472 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  19476 */     // MIs[14] src1
     /*  19476 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  19481 */     GIM_CheckConstantInt, /*MI*/14, /*Op*/2, GIMT_Encode8(255),
     /*  19492 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
     /*  19496 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  19500 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  19503 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  19508 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  19512 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  19516 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  19518 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  19522 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19526 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  19530 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  19534 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  19538 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19542 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  19546 */     // MIs[17] src0
     /*  19546 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  19551 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
     /*  19555 */     GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
     /*  19566 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  19570 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19574 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  19578 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  19582 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  19586 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19590 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  19594 */     // MIs[19] src1
     /*  19594 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  19599 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
     /*  19603 */     GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
     /*  19614 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  19616 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  19616 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  19619 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  19621 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  19624 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  19628 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  19631 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  19635 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  19638 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/2, // src2
     /*  19642 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  19645 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  19648 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  19651 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  19654 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  19657 */     GIR_RootConstrainSelectedInstOperands,
     /*  19658 */     // GIR_Coverage, 9448,
     /*  19658 */     GIR_EraseRootFromParent_Done,
     /*  19659 */   // Label 212: @19659
     /*  19659 */   GIM_Try, /*On fail goto*//*Label 213*/ GIMT_Encode4(20164), // Rule ID 9447 //
     /*  19664 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  19667 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  19669 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  19673 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19677 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  19681 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  19684 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  19689 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  19693 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  19697 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  19699 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  19703 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19707 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  19711 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  19715 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  19719 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  19723 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19727 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  19731 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  19735 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  19739 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  19743 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  19747 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  19751 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  19755 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  19757 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  19761 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  19765 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  19769 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  19773 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  19775 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  19779 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  19783 */     GIM_CheckNumOperands, /*MI*/6, /*Expected*/4,
     /*  19786 */     GIM_CheckIntrinsicID, /*MI*/6, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  19791 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  19795 */     GIM_CheckType, /*MI*/6, /*Op*/3, /*Type*/GILLT_s32,
     /*  19799 */     GIM_CheckHasOneUse, /*MI*/6,
     /*  19801 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/2, // MIs[7]
     /*  19805 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19809 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  19813 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  19817 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  19821 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19825 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  19829 */     // MIs[8] src0
     /*  19829 */     GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  19834 */     GIM_CheckConstantInt8, /*MI*/8, /*Op*/2, 8,
     /*  19838 */     GIM_CheckConstantInt, /*MI*/7, /*Op*/2, GIMT_Encode8(255),
     /*  19849 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/6, /*OpIdx*/3, // MIs[9]
     /*  19853 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19857 */     GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
     /*  19861 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  19865 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
     /*  19869 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19873 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  19877 */     // MIs[10] src1
     /*  19877 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  19882 */     GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
     /*  19886 */     GIM_CheckConstantInt, /*MI*/9, /*Op*/2, GIMT_Encode8(255),
     /*  19897 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/5, /*OpIdx*/2, // MIs[11]
     /*  19901 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  19905 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  19909 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  19913 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  19915 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
     /*  19919 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  19923 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  19926 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  19931 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  19935 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  19939 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  19941 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  19945 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19949 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  19953 */     // MIs[13] src0
     /*  19953 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  19958 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  19969 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
     /*  19973 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19977 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  19981 */     // MIs[14] src1
     /*  19981 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  19986 */     GIM_CheckConstantInt, /*MI*/14, /*Op*/2, GIMT_Encode8(255),
     /*  19997 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
     /*  20001 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20005 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  20008 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  20013 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  20017 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  20021 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  20023 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  20027 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20031 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  20035 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  20039 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  20043 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20047 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  20051 */     // MIs[17] src0
     /*  20051 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  20056 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
     /*  20060 */     GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
     /*  20071 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  20075 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20079 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  20083 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  20087 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  20091 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20095 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  20099 */     // MIs[19] src1
     /*  20099 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  20104 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
     /*  20108 */     GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
     /*  20119 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  20121 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  20121 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  20124 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  20126 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  20129 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  20133 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  20136 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  20140 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  20143 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/1, // src2
     /*  20147 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  20150 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  20153 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  20156 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  20159 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  20162 */     GIR_RootConstrainSelectedInstOperands,
     /*  20163 */     // GIR_Coverage, 9447,
     /*  20163 */     GIR_EraseRootFromParent_Done,
     /*  20164 */   // Label 213: @20164
     /*  20164 */   GIM_Try, /*On fail goto*//*Label 214*/ GIMT_Encode4(20669), // Rule ID 9446 //
     /*  20169 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  20172 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  20174 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  20178 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20182 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20186 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  20189 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  20194 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  20198 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  20202 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  20204 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  20208 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20212 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  20216 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  20220 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  20224 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  20228 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20232 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  20236 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  20240 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  20244 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  20248 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  20252 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  20256 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  20260 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  20262 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  20266 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  20270 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  20274 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  20278 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  20280 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  20284 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  20288 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  20292 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  20296 */     GIM_CheckHasOneUse, /*MI*/6,
     /*  20298 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  20302 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20306 */     GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
     /*  20309 */     GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  20314 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  20318 */     GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
     /*  20322 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  20324 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
     /*  20328 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20332 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  20336 */     // MIs[8] src0
     /*  20336 */     GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  20341 */     GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
     /*  20352 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/7, /*OpIdx*/3, // MIs[9]
     /*  20356 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20360 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  20364 */     // MIs[9] src1
     /*  20364 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  20369 */     GIM_CheckConstantInt, /*MI*/9, /*Op*/2, GIMT_Encode8(255),
     /*  20380 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/5, /*OpIdx*/2, // MIs[10]
     /*  20384 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20388 */     GIM_CheckNumOperands, /*MI*/10, /*Expected*/4,
     /*  20391 */     GIM_CheckIntrinsicID, /*MI*/10, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  20396 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  20400 */     GIM_CheckType, /*MI*/10, /*Op*/3, /*Type*/GILLT_s32,
     /*  20404 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  20406 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/2, // MIs[11]
     /*  20410 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20414 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  20418 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  20422 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  20426 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20430 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  20434 */     // MIs[12] src0
     /*  20434 */     GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  20439 */     GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
     /*  20443 */     GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
     /*  20454 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/10, /*OpIdx*/3, // MIs[13]
     /*  20458 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20462 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  20466 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  20470 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  20474 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20478 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  20482 */     // MIs[14] src1
     /*  20482 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  20487 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
     /*  20491 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  20502 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
     /*  20506 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20510 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  20513 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  20518 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  20522 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  20526 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  20528 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  20532 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20536 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  20540 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  20544 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  20548 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20552 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  20556 */     // MIs[17] src0
     /*  20556 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  20561 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
     /*  20565 */     GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
     /*  20576 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  20580 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20584 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  20588 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  20592 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  20596 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20600 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  20604 */     // MIs[19] src1
     /*  20604 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  20609 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
     /*  20613 */     GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
     /*  20624 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  20626 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  20626 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  20629 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  20631 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  20634 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  20638 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  20641 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  20645 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  20648 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/2, // src2
     /*  20652 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  20655 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  20658 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  20661 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  20664 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  20667 */     GIR_RootConstrainSelectedInstOperands,
     /*  20668 */     // GIR_Coverage, 9446,
     /*  20668 */     GIR_EraseRootFromParent_Done,
     /*  20669 */   // Label 214: @20669
     /*  20669 */   GIM_Try, /*On fail goto*//*Label 215*/ GIMT_Encode4(21174), // Rule ID 9445 //
     /*  20674 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  20677 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  20679 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  20683 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20687 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20691 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  20694 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  20699 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  20703 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  20707 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  20709 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  20713 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20717 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  20721 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  20725 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  20729 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  20733 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20737 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  20741 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  20745 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  20749 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  20753 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  20757 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  20761 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  20765 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  20767 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  20771 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  20775 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  20779 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  20783 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  20785 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  20789 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  20793 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  20797 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  20801 */     GIM_CheckHasOneUse, /*MI*/6,
     /*  20803 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/2, // MIs[7]
     /*  20807 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20811 */     GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
     /*  20814 */     GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  20819 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  20823 */     GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
     /*  20827 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  20829 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
     /*  20833 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20837 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  20841 */     // MIs[8] src0
     /*  20841 */     GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  20846 */     GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
     /*  20857 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/7, /*OpIdx*/3, // MIs[9]
     /*  20861 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20865 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  20869 */     // MIs[9] src1
     /*  20869 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  20874 */     GIM_CheckConstantInt, /*MI*/9, /*Op*/2, GIMT_Encode8(255),
     /*  20885 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/5, /*OpIdx*/2, // MIs[10]
     /*  20889 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20893 */     GIM_CheckNumOperands, /*MI*/10, /*Expected*/4,
     /*  20896 */     GIM_CheckIntrinsicID, /*MI*/10, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  20901 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  20905 */     GIM_CheckType, /*MI*/10, /*Op*/3, /*Type*/GILLT_s32,
     /*  20909 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  20911 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/2, // MIs[11]
     /*  20915 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20919 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  20923 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  20927 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  20931 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20935 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  20939 */     // MIs[12] src0
     /*  20939 */     GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  20944 */     GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
     /*  20948 */     GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
     /*  20959 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/10, /*OpIdx*/3, // MIs[13]
     /*  20963 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20967 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  20971 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  20975 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  20979 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20983 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  20987 */     // MIs[14] src1
     /*  20987 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  20992 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
     /*  20996 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  21007 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
     /*  21011 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  21015 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  21018 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  21023 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  21027 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  21031 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  21033 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  21037 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21041 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  21045 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  21049 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  21053 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21057 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  21061 */     // MIs[17] src0
     /*  21061 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  21066 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
     /*  21070 */     GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
     /*  21081 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  21085 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21089 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  21093 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  21097 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  21101 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21105 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  21109 */     // MIs[19] src1
     /*  21109 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  21114 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
     /*  21118 */     GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
     /*  21129 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  21131 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  21131 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  21134 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  21136 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  21139 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  21143 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  21146 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  21150 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  21153 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src2
     /*  21157 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21160 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21163 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21166 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21169 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21172 */     GIR_RootConstrainSelectedInstOperands,
     /*  21173 */     // GIR_Coverage, 9445,
     /*  21173 */     GIR_EraseRootFromParent_Done,
     /*  21174 */   // Label 215: @21174
     /*  21174 */   GIM_Try, /*On fail goto*//*Label 216*/ GIMT_Encode4(21679), // Rule ID 9444 //
     /*  21179 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  21182 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  21184 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  21188 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21192 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  21196 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  21200 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  21204 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  21206 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  21210 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  21214 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  21217 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  21222 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  21226 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  21230 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  21232 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  21236 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21240 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  21244 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  21248 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  21252 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21256 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  21260 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  21264 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  21268 */     GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(255),
     /*  21279 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
     /*  21283 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21287 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  21291 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  21295 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  21299 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21303 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  21307 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  21311 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  21315 */     GIM_CheckConstantInt, /*MI*/5, /*Op*/2, GIMT_Encode8(255),
     /*  21326 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
     /*  21330 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  21334 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  21338 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  21342 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  21344 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  21348 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  21352 */     GIM_CheckNumOperands, /*MI*/8, /*Expected*/4,
     /*  21355 */     GIM_CheckIntrinsicID, /*MI*/8, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  21360 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  21364 */     GIM_CheckType, /*MI*/8, /*Op*/3, /*Type*/GILLT_s32,
     /*  21368 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  21370 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
     /*  21374 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21378 */     GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
     /*  21382 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  21386 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
     /*  21390 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21394 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  21398 */     // MIs[10] src0
     /*  21398 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  21403 */     GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
     /*  21407 */     GIM_CheckConstantInt, /*MI*/9, /*Op*/2, GIMT_Encode8(255),
     /*  21418 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/8, /*OpIdx*/3, // MIs[11]
     /*  21422 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21426 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  21430 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  21434 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  21438 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21442 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  21446 */     // MIs[12] src1
     /*  21446 */     GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  21451 */     GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
     /*  21455 */     GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
     /*  21466 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/7, /*OpIdx*/2, // MIs[13]
     /*  21470 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  21474 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  21478 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  21482 */     GIM_CheckHasOneUse, /*MI*/13,
     /*  21484 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  21488 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  21492 */     GIM_CheckNumOperands, /*MI*/14, /*Expected*/4,
     /*  21495 */     GIM_CheckIntrinsicID, /*MI*/14, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  21500 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  21504 */     GIM_CheckType, /*MI*/14, /*Op*/3, /*Type*/GILLT_s32,
     /*  21508 */     GIM_CheckHasOneUse, /*MI*/14,
     /*  21510 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/2, // MIs[15]
     /*  21514 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21518 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  21522 */     // MIs[15] src0
     /*  21522 */     GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  21527 */     GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
     /*  21538 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/14, /*OpIdx*/3, // MIs[16]
     /*  21542 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21546 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  21550 */     // MIs[16] src1
     /*  21550 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  21555 */     GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
     /*  21566 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  21570 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  21574 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  21577 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  21582 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  21586 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  21590 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  21592 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  21596 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21600 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  21604 */     // MIs[18] src0
     /*  21604 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  21609 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  21613 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  21617 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21621 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  21625 */     // MIs[19] src1
     /*  21625 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  21630 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  21634 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  21636 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  21636 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  21639 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  21641 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  21644 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
     /*  21648 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  21651 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  21655 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  21658 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/13, /*OpIdx*/2, // src2
     /*  21662 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21665 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21668 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21671 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21674 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21677 */     GIR_RootConstrainSelectedInstOperands,
     /*  21678 */     // GIR_Coverage, 9444,
     /*  21678 */     GIR_EraseRootFromParent_Done,
     /*  21679 */   // Label 216: @21679
     /*  21679 */   GIM_Try, /*On fail goto*//*Label 217*/ GIMT_Encode4(22184), // Rule ID 9443 //
     /*  21684 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  21687 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  21689 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  21693 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21697 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  21701 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  21705 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  21709 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  21711 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  21715 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  21719 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  21722 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  21727 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  21731 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  21735 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  21737 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  21741 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21745 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  21749 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  21753 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  21757 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21761 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  21765 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  21769 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  21773 */     GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(255),
     /*  21784 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
     /*  21788 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21792 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  21796 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  21800 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  21804 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21808 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  21812 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  21816 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  21820 */     GIM_CheckConstantInt, /*MI*/5, /*Op*/2, GIMT_Encode8(255),
     /*  21831 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
     /*  21835 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  21839 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  21843 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  21847 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  21849 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  21853 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  21857 */     GIM_CheckNumOperands, /*MI*/8, /*Expected*/4,
     /*  21860 */     GIM_CheckIntrinsicID, /*MI*/8, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  21865 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  21869 */     GIM_CheckType, /*MI*/8, /*Op*/3, /*Type*/GILLT_s32,
     /*  21873 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  21875 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
     /*  21879 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21883 */     GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
     /*  21887 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  21891 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
     /*  21895 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21899 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  21903 */     // MIs[10] src0
     /*  21903 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  21908 */     GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
     /*  21912 */     GIM_CheckConstantInt, /*MI*/9, /*Op*/2, GIMT_Encode8(255),
     /*  21923 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/8, /*OpIdx*/3, // MIs[11]
     /*  21927 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21931 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  21935 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  21939 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  21943 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21947 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  21951 */     // MIs[12] src1
     /*  21951 */     GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  21956 */     GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
     /*  21960 */     GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
     /*  21971 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/7, /*OpIdx*/2, // MIs[13]
     /*  21975 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  21979 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  21983 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  21987 */     GIM_CheckHasOneUse, /*MI*/13,
     /*  21989 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/2, // MIs[14]
     /*  21993 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  21997 */     GIM_CheckNumOperands, /*MI*/14, /*Expected*/4,
     /*  22000 */     GIM_CheckIntrinsicID, /*MI*/14, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22005 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  22009 */     GIM_CheckType, /*MI*/14, /*Op*/3, /*Type*/GILLT_s32,
     /*  22013 */     GIM_CheckHasOneUse, /*MI*/14,
     /*  22015 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/2, // MIs[15]
     /*  22019 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22023 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  22027 */     // MIs[15] src0
     /*  22027 */     GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  22032 */     GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
     /*  22043 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/14, /*OpIdx*/3, // MIs[16]
     /*  22047 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22051 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  22055 */     // MIs[16] src1
     /*  22055 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  22060 */     GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
     /*  22071 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  22075 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  22079 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  22082 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22087 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  22091 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  22095 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  22097 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  22101 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22105 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  22109 */     // MIs[18] src0
     /*  22109 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  22114 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  22118 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  22122 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22126 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  22130 */     // MIs[19] src1
     /*  22130 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  22135 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  22139 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  22141 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  22141 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  22144 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  22146 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  22149 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
     /*  22153 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  22156 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  22160 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  22163 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/13, /*OpIdx*/1, // src2
     /*  22167 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  22170 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  22173 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  22176 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  22179 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  22182 */     GIR_RootConstrainSelectedInstOperands,
     /*  22183 */     // GIR_Coverage, 9443,
     /*  22183 */     GIR_EraseRootFromParent_Done,
     /*  22184 */   // Label 217: @22184
     /*  22184 */   GIM_Try, /*On fail goto*//*Label 218*/ GIMT_Encode4(22689), // Rule ID 9442 //
     /*  22189 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  22192 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  22194 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  22198 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22202 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  22206 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  22210 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  22214 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  22216 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  22220 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  22224 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  22227 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22232 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  22236 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  22240 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  22242 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  22246 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22250 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  22254 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  22258 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  22262 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22266 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  22270 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  22274 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  22278 */     GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(255),
     /*  22289 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
     /*  22293 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22297 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  22301 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  22305 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  22309 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22313 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  22317 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  22321 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  22325 */     GIM_CheckConstantInt, /*MI*/5, /*Op*/2, GIMT_Encode8(255),
     /*  22336 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
     /*  22340 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  22344 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  22348 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  22352 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  22354 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  22358 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  22362 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  22366 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  22370 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  22372 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  22376 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  22380 */     GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
     /*  22383 */     GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22388 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  22392 */     GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
     /*  22396 */     GIM_CheckHasOneUse, /*MI*/9,
     /*  22398 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
     /*  22402 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22406 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  22410 */     // MIs[10] src0
     /*  22410 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  22415 */     GIM_CheckConstantInt, /*MI*/10, /*Op*/2, GIMT_Encode8(255),
     /*  22426 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
     /*  22430 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22434 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  22438 */     // MIs[11] src1
     /*  22438 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  22443 */     GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
     /*  22454 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/7, /*OpIdx*/2, // MIs[12]
     /*  22458 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  22462 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  22465 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22470 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  22474 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  22478 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  22480 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  22484 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22488 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  22492 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  22496 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  22500 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22504 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  22508 */     // MIs[14] src0
     /*  22508 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  22513 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
     /*  22517 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  22528 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  22532 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22536 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  22540 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  22544 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  22548 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22552 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  22556 */     // MIs[16] src1
     /*  22556 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  22561 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 8,
     /*  22565 */     GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
     /*  22576 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  22580 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  22584 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  22587 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22592 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  22596 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  22600 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  22602 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  22606 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22610 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  22614 */     // MIs[18] src0
     /*  22614 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  22619 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  22623 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  22627 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22631 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  22635 */     // MIs[19] src1
     /*  22635 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  22640 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  22644 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  22646 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  22646 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  22649 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  22651 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  22654 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
     /*  22658 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  22661 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  22665 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  22668 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/2, // src2
     /*  22672 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  22675 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  22678 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  22681 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  22684 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  22687 */     GIR_RootConstrainSelectedInstOperands,
     /*  22688 */     // GIR_Coverage, 9442,
     /*  22688 */     GIR_EraseRootFromParent_Done,
     /*  22689 */   // Label 218: @22689
     /*  22689 */   GIM_Try, /*On fail goto*//*Label 219*/ GIMT_Encode4(23194), // Rule ID 9441 //
     /*  22694 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  22697 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  22699 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  22703 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22707 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  22711 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  22715 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  22719 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  22721 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  22725 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  22729 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  22732 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22737 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  22741 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  22745 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  22747 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  22751 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22755 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  22759 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  22763 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  22767 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22771 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  22775 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  22779 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  22783 */     GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(255),
     /*  22794 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
     /*  22798 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22802 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  22806 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  22810 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  22814 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22818 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  22822 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  22826 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  22830 */     GIM_CheckConstantInt, /*MI*/5, /*Op*/2, GIMT_Encode8(255),
     /*  22841 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
     /*  22845 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  22849 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  22853 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  22857 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  22859 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  22863 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  22867 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  22871 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  22875 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  22877 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
     /*  22881 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  22885 */     GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
     /*  22888 */     GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22893 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  22897 */     GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
     /*  22901 */     GIM_CheckHasOneUse, /*MI*/9,
     /*  22903 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
     /*  22907 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22911 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  22915 */     // MIs[10] src0
     /*  22915 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  22920 */     GIM_CheckConstantInt, /*MI*/10, /*Op*/2, GIMT_Encode8(255),
     /*  22931 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
     /*  22935 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22939 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  22943 */     // MIs[11] src1
     /*  22943 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  22948 */     GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
     /*  22959 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/7, /*OpIdx*/2, // MIs[12]
     /*  22963 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  22967 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  22970 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22975 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  22979 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  22983 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  22985 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  22989 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22993 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  22997 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  23001 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  23005 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23009 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  23013 */     // MIs[14] src0
     /*  23013 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  23018 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
     /*  23022 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  23033 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  23037 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23041 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  23045 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  23049 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  23053 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23057 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  23061 */     // MIs[16] src1
     /*  23061 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  23066 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 8,
     /*  23070 */     GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
     /*  23081 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  23085 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  23089 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  23092 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  23097 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  23101 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  23105 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  23107 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  23111 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23115 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  23119 */     // MIs[18] src0
     /*  23119 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  23124 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  23128 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  23132 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23136 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  23140 */     // MIs[19] src1
     /*  23140 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  23145 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  23149 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  23151 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  23151 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  23154 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  23156 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  23159 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
     /*  23163 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  23166 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  23170 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  23173 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/1, // src2
     /*  23177 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23180 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23183 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23186 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23189 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23192 */     GIR_RootConstrainSelectedInstOperands,
     /*  23193 */     // GIR_Coverage, 9441,
     /*  23193 */     GIR_EraseRootFromParent_Done,
     /*  23194 */   // Label 219: @23194
     /*  23194 */   GIM_Try, /*On fail goto*//*Label 220*/ GIMT_Encode4(23699), // Rule ID 9440 //
     /*  23199 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  23202 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  23204 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  23208 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  23212 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  23216 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  23220 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  23224 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  23226 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  23230 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  23234 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  23238 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  23242 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  23244 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  23248 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  23252 */     GIM_CheckNumOperands, /*MI*/3, /*Expected*/4,
     /*  23255 */     GIM_CheckIntrinsicID, /*MI*/3, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  23260 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  23264 */     GIM_CheckType, /*MI*/3, /*Op*/3, /*Type*/GILLT_s32,
     /*  23268 */     GIM_CheckHasOneUse, /*MI*/3,
     /*  23270 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  23274 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23278 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  23282 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  23286 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  23290 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23294 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  23298 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  23302 */     GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 8,
     /*  23306 */     GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(255),
     /*  23317 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/3, // MIs[6]
     /*  23321 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23325 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  23329 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  23333 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  23337 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23341 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  23345 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  23349 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 8,
     /*  23353 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
     /*  23364 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/2, // MIs[8]
     /*  23368 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  23372 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  23376 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  23380 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  23382 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  23386 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  23390 */     GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
     /*  23393 */     GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  23398 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  23402 */     GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
     /*  23406 */     GIM_CheckHasOneUse, /*MI*/9,
     /*  23408 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
     /*  23412 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23416 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  23420 */     // MIs[10] src0
     /*  23420 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  23425 */     GIM_CheckConstantInt, /*MI*/10, /*Op*/2, GIMT_Encode8(255),
     /*  23436 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
     /*  23440 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23444 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  23448 */     // MIs[11] src1
     /*  23448 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  23453 */     GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
     /*  23464 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
     /*  23468 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  23472 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  23475 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  23480 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  23484 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  23488 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  23490 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  23494 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23498 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  23502 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  23506 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  23510 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23514 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  23518 */     // MIs[14] src0
     /*  23518 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  23523 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
     /*  23527 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  23538 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  23542 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23546 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  23550 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  23554 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  23558 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23562 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  23566 */     // MIs[16] src1
     /*  23566 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  23571 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
     /*  23575 */     GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
     /*  23586 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  23590 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  23594 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  23597 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  23602 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  23606 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  23610 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  23612 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  23616 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23620 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  23624 */     // MIs[18] src0
     /*  23624 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  23629 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  23633 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  23637 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23641 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  23645 */     // MIs[19] src1
     /*  23645 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  23650 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  23654 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  23656 */     // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  23656 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  23659 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  23661 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  23664 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  23668 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  23671 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/7, /*OpIdx*/1, // src1
     /*  23675 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  23678 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/2, // src2
     /*  23682 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23685 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23688 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23691 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23694 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23697 */     GIR_RootConstrainSelectedInstOperands,
     /*  23698 */     // GIR_Coverage, 9440,
     /*  23698 */     GIR_EraseRootFromParent_Done,
     /*  23699 */   // Label 220: @23699
     /*  23699 */   GIM_Try, /*On fail goto*//*Label 221*/ GIMT_Encode4(24204), // Rule ID 9439 //
     /*  23704 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  23707 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  23709 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  23713 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  23717 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  23721 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  23725 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  23729 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  23731 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  23735 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  23739 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  23743 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  23747 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  23749 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  23753 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  23757 */     GIM_CheckNumOperands, /*MI*/3, /*Expected*/4,
     /*  23760 */     GIM_CheckIntrinsicID, /*MI*/3, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  23765 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  23769 */     GIM_CheckType, /*MI*/3, /*Op*/3, /*Type*/GILLT_s32,
     /*  23773 */     GIM_CheckHasOneUse, /*MI*/3,
     /*  23775 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  23779 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23783 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  23787 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  23791 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  23795 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23799 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  23803 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  23807 */     GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 8,
     /*  23811 */     GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(255),
     /*  23822 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/3, // MIs[6]
     /*  23826 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23830 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  23834 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  23838 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  23842 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23846 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  23850 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  23854 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 8,
     /*  23858 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
     /*  23869 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/2, // MIs[8]
     /*  23873 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  23877 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  23881 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  23885 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  23887 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
     /*  23891 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  23895 */     GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
     /*  23898 */     GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  23903 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  23907 */     GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
     /*  23911 */     GIM_CheckHasOneUse, /*MI*/9,
     /*  23913 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
     /*  23917 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23921 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  23925 */     // MIs[10] src0
     /*  23925 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  23930 */     GIM_CheckConstantInt, /*MI*/10, /*Op*/2, GIMT_Encode8(255),
     /*  23941 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
     /*  23945 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23949 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  23953 */     // MIs[11] src1
     /*  23953 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  23958 */     GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
     /*  23969 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
     /*  23973 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  23977 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  23980 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  23985 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  23989 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  23993 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  23995 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  23999 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24003 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  24007 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  24011 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  24015 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24019 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  24023 */     // MIs[14] src0
     /*  24023 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  24028 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
     /*  24032 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  24043 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  24047 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24051 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  24055 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  24059 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  24063 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24067 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  24071 */     // MIs[16] src1
     /*  24071 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  24076 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
     /*  24080 */     GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
     /*  24091 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  24095 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24099 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  24102 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  24107 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  24111 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  24115 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  24117 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  24121 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24125 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  24129 */     // MIs[18] src0
     /*  24129 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  24134 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  24138 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  24142 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24146 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  24150 */     // MIs[19] src1
     /*  24150 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  24155 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  24159 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  24161 */     // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  24161 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  24164 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  24166 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  24169 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  24173 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  24176 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/7, /*OpIdx*/1, // src1
     /*  24180 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  24183 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/1, // src2
     /*  24187 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24190 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24193 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24196 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24199 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24202 */     GIR_RootConstrainSelectedInstOperands,
     /*  24203 */     // GIR_Coverage, 9439,
     /*  24203 */     GIR_EraseRootFromParent_Done,
     /*  24204 */   // Label 221: @24204
     /*  24204 */   GIM_Try, /*On fail goto*//*Label 222*/ GIMT_Encode4(24709), // Rule ID 9438 //
     /*  24209 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  24212 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  24214 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  24218 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24222 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  24226 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  24230 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  24234 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  24236 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  24240 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  24244 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  24248 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  24252 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  24254 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  24258 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  24262 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  24266 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  24270 */     GIM_CheckHasOneUse, /*MI*/3,
     /*  24272 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  24276 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24280 */     GIM_CheckNumOperands, /*MI*/4, /*Expected*/4,
     /*  24283 */     GIM_CheckIntrinsicID, /*MI*/4, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  24288 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  24292 */     GIM_CheckType, /*MI*/4, /*Op*/3, /*Type*/GILLT_s32,
     /*  24296 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  24298 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  24302 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24306 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  24310 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  24314 */     GIM_CheckConstantInt, /*MI*/5, /*Op*/2, GIMT_Encode8(255),
     /*  24325 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/4, /*OpIdx*/3, // MIs[6]
     /*  24329 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24333 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  24337 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  24341 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
     /*  24352 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/2, // MIs[7]
     /*  24356 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24360 */     GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
     /*  24363 */     GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  24368 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  24372 */     GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
     /*  24376 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  24378 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
     /*  24382 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24386 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  24390 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  24394 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  24398 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24402 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  24406 */     // MIs[9] src0
     /*  24406 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  24411 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 8,
     /*  24415 */     GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
     /*  24426 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/7, /*OpIdx*/3, // MIs[10]
     /*  24430 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24434 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  24438 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  24442 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  24446 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24450 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  24454 */     // MIs[11] src1
     /*  24454 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  24459 */     GIM_CheckConstantInt8, /*MI*/11, /*Op*/2, 8,
     /*  24463 */     GIM_CheckConstantInt, /*MI*/10, /*Op*/2, GIMT_Encode8(255),
     /*  24474 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
     /*  24478 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24482 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  24485 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  24490 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  24494 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  24498 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  24500 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  24504 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24508 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  24512 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  24516 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  24520 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24524 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  24528 */     // MIs[14] src0
     /*  24528 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  24533 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
     /*  24537 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  24548 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  24552 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24556 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  24560 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  24564 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  24568 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24572 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  24576 */     // MIs[16] src1
     /*  24576 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  24581 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
     /*  24585 */     GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
     /*  24596 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  24600 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24604 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  24607 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  24612 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  24616 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  24620 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  24622 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  24626 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24630 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  24634 */     // MIs[18] src0
     /*  24634 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  24639 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  24643 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  24647 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24651 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  24655 */     // MIs[19] src1
     /*  24655 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  24660 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  24664 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  24666 */     // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  24666 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  24669 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  24671 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  24674 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  24678 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  24681 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  24685 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  24688 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // src2
     /*  24692 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24695 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24698 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24701 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24704 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24707 */     GIR_RootConstrainSelectedInstOperands,
     /*  24708 */     // GIR_Coverage, 9438,
     /*  24708 */     GIR_EraseRootFromParent_Done,
     /*  24709 */   // Label 222: @24709
     /*  24709 */   GIM_Try, /*On fail goto*//*Label 223*/ GIMT_Encode4(25214), // Rule ID 2935 //
     /*  24714 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  24717 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  24719 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  24723 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24727 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  24731 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  24735 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  24739 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  24741 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  24745 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  24749 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  24753 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  24757 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  24759 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  24763 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  24767 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  24771 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  24775 */     GIM_CheckHasOneUse, /*MI*/3,
     /*  24777 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  24781 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24785 */     GIM_CheckNumOperands, /*MI*/4, /*Expected*/4,
     /*  24788 */     GIM_CheckIntrinsicID, /*MI*/4, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  24793 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  24797 */     GIM_CheckType, /*MI*/4, /*Op*/3, /*Type*/GILLT_s32,
     /*  24801 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  24803 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  24807 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24811 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  24815 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  24819 */     GIM_CheckConstantInt, /*MI*/5, /*Op*/2, GIMT_Encode8(255),
     /*  24830 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/4, /*OpIdx*/3, // MIs[6]
     /*  24834 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24838 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  24842 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  24846 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
     /*  24857 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/2, // MIs[7]
     /*  24861 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24865 */     GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
     /*  24868 */     GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  24873 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  24877 */     GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
     /*  24881 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  24883 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
     /*  24887 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24891 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  24895 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  24899 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  24903 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24907 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  24911 */     // MIs[9] src0
     /*  24911 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  24916 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 8,
     /*  24920 */     GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
     /*  24931 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/7, /*OpIdx*/3, // MIs[10]
     /*  24935 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24939 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  24943 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  24947 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  24951 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24955 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  24959 */     // MIs[11] src1
     /*  24959 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  24964 */     GIM_CheckConstantInt8, /*MI*/11, /*Op*/2, 8,
     /*  24968 */     GIM_CheckConstantInt, /*MI*/10, /*Op*/2, GIMT_Encode8(255),
     /*  24979 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
     /*  24983 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24987 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  24990 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  24995 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  24999 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  25003 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  25005 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  25009 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  25013 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  25017 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  25021 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  25025 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25029 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  25033 */     // MIs[14] src0
     /*  25033 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  25038 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
     /*  25042 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  25053 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  25057 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
     /*  25061 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  25065 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  25069 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  25073 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25077 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  25081 */     // MIs[16] src1
     /*  25081 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  25086 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
     /*  25090 */     GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
     /*  25101 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  25105 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  25109 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  25112 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  25117 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  25121 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  25125 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  25127 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  25131 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25135 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  25139 */     // MIs[18] src0
     /*  25139 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  25144 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  25148 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  25152 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25156 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  25160 */     // MIs[19] src1
     /*  25160 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  25165 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  25169 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  25171 */     // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  25171 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  25174 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  25176 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  25179 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  25183 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  25186 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  25190 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  25193 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src2
     /*  25197 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25200 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25203 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25206 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25209 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25212 */     GIR_RootConstrainSelectedInstOperands,
     /*  25213 */     // GIR_Coverage, 2935,
     /*  25213 */     GIR_EraseRootFromParent_Done,
     /*  25214 */   // Label 223: @25214
     /*  25214 */   GIM_Try, /*On fail goto*//*Label 224*/ GIMT_Encode4(25695), // Rule ID 10732 //
     /*  25219 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  25222 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  25224 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  25228 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  25232 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  25236 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  25239 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  25244 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  25248 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  25252 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  25254 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  25258 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  25262 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  25266 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  25270 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  25274 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  25278 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  25282 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  25286 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  25290 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  25294 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  25298 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  25302 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  25306 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  25310 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  25312 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  25316 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  25320 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  25323 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  25328 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  25332 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  25336 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  25338 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  25342 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25346 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  25350 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  25354 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25358 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  25362 */     // MIs[7] src0
     /*  25362 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  25367 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  25371 */     // MIs[6] Operand 2
     /*  25371 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
     /*  25382 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
     /*  25386 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25390 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  25394 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  25398 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25402 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  25406 */     // MIs[9] src1
     /*  25406 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  25411 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
     /*  25415 */     // MIs[8] Operand 2
     /*  25415 */     GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
     /*  25426 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
     /*  25430 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  25434 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  25438 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  25442 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  25444 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  25448 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  25452 */     GIM_CheckNumOperands, /*MI*/11, /*Expected*/4,
     /*  25455 */     GIM_CheckIntrinsicID, /*MI*/11, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  25460 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  25464 */     GIM_CheckType, /*MI*/11, /*Op*/3, /*Type*/GILLT_s32,
     /*  25468 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  25470 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
     /*  25474 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25478 */     GIM_CheckType, /*MI*/12, /*Op*/1, /*Type*/GILLT_s32,
     /*  25482 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/1, // MIs[13]
     /*  25486 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25490 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  25494 */     // MIs[13] src0
     /*  25494 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  25499 */     GIM_CheckConstantInt8, /*MI*/13, /*Op*/2, 8,
     /*  25503 */     // MIs[12] Operand 2
     /*  25503 */     GIM_CheckLiteralInt, /*MI*/12, /*Op*/2, GIMT_Encode8(8),
     /*  25514 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/11, /*OpIdx*/3, // MIs[14]
     /*  25518 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25522 */     GIM_CheckType, /*MI*/14, /*Op*/1, /*Type*/GILLT_s32,
     /*  25526 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/1, // MIs[15]
     /*  25530 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25534 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  25538 */     // MIs[15] src1
     /*  25538 */     GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  25543 */     GIM_CheckConstantInt8, /*MI*/15, /*Op*/2, 8,
     /*  25547 */     // MIs[14] Operand 2
     /*  25547 */     GIM_CheckLiteralInt, /*MI*/14, /*Op*/2, GIMT_Encode8(8),
     /*  25558 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/10, /*OpIdx*/2, // MIs[16]
     /*  25562 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  25566 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  25570 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  25574 */     GIM_CheckHasOneUse, /*MI*/16,
     /*  25576 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  25580 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  25584 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  25587 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  25592 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  25596 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  25600 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  25602 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  25606 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25610 */     // MIs[18] src0
     /*  25610 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  25615 */     // MIs[18] Operand 2
     /*  25615 */     GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
     /*  25626 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  25630 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25634 */     // MIs[19] src1
     /*  25634 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  25639 */     // MIs[19] Operand 2
     /*  25639 */     GIM_CheckLiteralInt, /*MI*/19, /*Op*/2, GIMT_Encode8(8),
     /*  25650 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  25652 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  25652 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  25655 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  25657 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  25660 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  25664 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  25667 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  25671 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  25674 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/16, /*OpIdx*/2, // src2
     /*  25678 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25681 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25684 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25687 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25690 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25693 */     GIR_RootConstrainSelectedInstOperands,
     /*  25694 */     // GIR_Coverage, 10732,
     /*  25694 */     GIR_EraseRootFromParent_Done,
     /*  25695 */   // Label 224: @25695
     /*  25695 */   GIM_Try, /*On fail goto*//*Label 225*/ GIMT_Encode4(26176), // Rule ID 10731 //
     /*  25700 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  25703 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  25705 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  25709 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  25713 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  25717 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  25720 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  25725 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  25729 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  25733 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  25735 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  25739 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  25743 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  25747 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  25751 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  25755 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  25759 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  25763 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  25767 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  25771 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  25775 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  25779 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  25783 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  25787 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  25791 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  25793 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  25797 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  25801 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  25804 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  25809 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  25813 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  25817 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  25819 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  25823 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25827 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  25831 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  25835 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25839 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  25843 */     // MIs[7] src0
     /*  25843 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  25848 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  25852 */     // MIs[6] Operand 2
     /*  25852 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
     /*  25863 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
     /*  25867 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25871 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  25875 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  25879 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25883 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  25887 */     // MIs[9] src1
     /*  25887 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  25892 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
     /*  25896 */     // MIs[8] Operand 2
     /*  25896 */     GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
     /*  25907 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
     /*  25911 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  25915 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  25919 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  25923 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  25925 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  25929 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  25933 */     GIM_CheckNumOperands, /*MI*/11, /*Expected*/4,
     /*  25936 */     GIM_CheckIntrinsicID, /*MI*/11, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  25941 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  25945 */     GIM_CheckType, /*MI*/11, /*Op*/3, /*Type*/GILLT_s32,
     /*  25949 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  25951 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
     /*  25955 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25959 */     GIM_CheckType, /*MI*/12, /*Op*/1, /*Type*/GILLT_s32,
     /*  25963 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/1, // MIs[13]
     /*  25967 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25971 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  25975 */     // MIs[13] src0
     /*  25975 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  25980 */     GIM_CheckConstantInt8, /*MI*/13, /*Op*/2, 8,
     /*  25984 */     // MIs[12] Operand 2
     /*  25984 */     GIM_CheckLiteralInt, /*MI*/12, /*Op*/2, GIMT_Encode8(8),
     /*  25995 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/11, /*OpIdx*/3, // MIs[14]
     /*  25999 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26003 */     GIM_CheckType, /*MI*/14, /*Op*/1, /*Type*/GILLT_s32,
     /*  26007 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/1, // MIs[15]
     /*  26011 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  26015 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  26019 */     // MIs[15] src1
     /*  26019 */     GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  26024 */     GIM_CheckConstantInt8, /*MI*/15, /*Op*/2, 8,
     /*  26028 */     // MIs[14] Operand 2
     /*  26028 */     GIM_CheckLiteralInt, /*MI*/14, /*Op*/2, GIMT_Encode8(8),
     /*  26039 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/10, /*OpIdx*/2, // MIs[16]
     /*  26043 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  26047 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  26051 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  26055 */     GIM_CheckHasOneUse, /*MI*/16,
     /*  26057 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/2, // MIs[17]
     /*  26061 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26065 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  26068 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26073 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  26077 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  26081 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  26083 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  26087 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26091 */     // MIs[18] src0
     /*  26091 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  26096 */     // MIs[18] Operand 2
     /*  26096 */     GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
     /*  26107 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  26111 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26115 */     // MIs[19] src1
     /*  26115 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  26120 */     // MIs[19] Operand 2
     /*  26120 */     GIM_CheckLiteralInt, /*MI*/19, /*Op*/2, GIMT_Encode8(8),
     /*  26131 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  26133 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  26133 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  26136 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  26138 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  26141 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  26145 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  26148 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  26152 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  26155 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/16, /*OpIdx*/1, // src2
     /*  26159 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  26162 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  26165 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  26168 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  26171 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  26174 */     GIR_RootConstrainSelectedInstOperands,
     /*  26175 */     // GIR_Coverage, 10731,
     /*  26175 */     GIR_EraseRootFromParent_Done,
     /*  26176 */   // Label 225: @26176
     /*  26176 */   GIM_Try, /*On fail goto*//*Label 226*/ GIMT_Encode4(26657), // Rule ID 10730 //
     /*  26181 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  26184 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  26186 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  26190 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26194 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26198 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  26201 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26206 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  26210 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  26214 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  26216 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  26220 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  26224 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  26228 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  26232 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  26236 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  26240 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  26244 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  26248 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  26252 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  26256 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  26260 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  26264 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  26268 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  26272 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  26274 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  26278 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26282 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  26285 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26290 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  26294 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  26298 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  26300 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  26304 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26308 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  26312 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  26316 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  26320 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  26324 */     // MIs[7] src0
     /*  26324 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  26329 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  26333 */     // MIs[6] Operand 2
     /*  26333 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
     /*  26344 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
     /*  26348 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26352 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  26356 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  26360 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  26364 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  26368 */     // MIs[9] src1
     /*  26368 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  26373 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
     /*  26377 */     // MIs[8] Operand 2
     /*  26377 */     GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
     /*  26388 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
     /*  26392 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  26396 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  26400 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  26404 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  26406 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  26410 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  26414 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  26418 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  26422 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  26424 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  26428 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26432 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  26435 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26440 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  26444 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  26448 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  26450 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  26454 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26458 */     // MIs[13] src0
     /*  26458 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  26463 */     // MIs[13] Operand 2
     /*  26463 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  26474 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
     /*  26478 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26482 */     // MIs[14] src1
     /*  26482 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  26487 */     // MIs[14] Operand 2
     /*  26487 */     GIM_CheckLiteralInt, /*MI*/14, /*Op*/2, GIMT_Encode8(8),
     /*  26498 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/10, /*OpIdx*/2, // MIs[15]
     /*  26502 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26506 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  26509 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26514 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  26518 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  26522 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  26524 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  26528 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26532 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  26536 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  26540 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  26544 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  26548 */     // MIs[17] src0
     /*  26548 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  26553 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 8,
     /*  26557 */     // MIs[16] Operand 2
     /*  26557 */     GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
     /*  26568 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  26572 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26576 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  26580 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  26584 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  26588 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  26592 */     // MIs[19] src1
     /*  26592 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  26597 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 8,
     /*  26601 */     // MIs[18] Operand 2
     /*  26601 */     GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
     /*  26612 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  26614 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  26614 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  26617 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  26619 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  26622 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  26626 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  26629 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  26633 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  26636 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/2, // src2
     /*  26640 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  26643 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  26646 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  26649 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  26652 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  26655 */     GIR_RootConstrainSelectedInstOperands,
     /*  26656 */     // GIR_Coverage, 10730,
     /*  26656 */     GIR_EraseRootFromParent_Done,
     /*  26657 */   // Label 226: @26657
     /*  26657 */   GIM_Try, /*On fail goto*//*Label 227*/ GIMT_Encode4(27138), // Rule ID 10729 //
     /*  26662 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  26665 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  26667 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  26671 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26675 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26679 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  26682 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26687 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  26691 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  26695 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  26697 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  26701 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  26705 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  26709 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  26713 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  26717 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  26721 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  26725 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  26729 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  26733 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  26737 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  26741 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  26745 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  26749 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  26753 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  26755 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  26759 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26763 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  26766 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26771 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  26775 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  26779 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  26781 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  26785 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26789 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  26793 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  26797 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  26801 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  26805 */     // MIs[7] src0
     /*  26805 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  26810 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  26814 */     // MIs[6] Operand 2
     /*  26814 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
     /*  26825 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
     /*  26829 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26833 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  26837 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  26841 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  26845 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  26849 */     // MIs[9] src1
     /*  26849 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  26854 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
     /*  26858 */     // MIs[8] Operand 2
     /*  26858 */     GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
     /*  26869 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
     /*  26873 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  26877 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  26881 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  26885 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  26887 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  26891 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  26895 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  26899 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  26903 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  26905 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
     /*  26909 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26913 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  26916 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26921 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  26925 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  26929 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  26931 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  26935 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26939 */     // MIs[13] src0
     /*  26939 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  26944 */     // MIs[13] Operand 2
     /*  26944 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  26955 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
     /*  26959 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26963 */     // MIs[14] src1
     /*  26963 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  26968 */     // MIs[14] Operand 2
     /*  26968 */     GIM_CheckLiteralInt, /*MI*/14, /*Op*/2, GIMT_Encode8(8),
     /*  26979 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/10, /*OpIdx*/2, // MIs[15]
     /*  26983 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26987 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  26990 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26995 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  26999 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  27003 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  27005 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  27009 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27013 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  27017 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  27021 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27025 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  27029 */     // MIs[17] src0
     /*  27029 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  27034 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 8,
     /*  27038 */     // MIs[16] Operand 2
     /*  27038 */     GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
     /*  27049 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  27053 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27057 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  27061 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  27065 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27069 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  27073 */     // MIs[19] src1
     /*  27073 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  27078 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 8,
     /*  27082 */     // MIs[18] Operand 2
     /*  27082 */     GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
     /*  27093 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  27095 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  27095 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  27098 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  27100 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  27103 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  27107 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  27110 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  27114 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  27117 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/1, // src2
     /*  27121 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  27124 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  27127 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  27130 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  27133 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  27136 */     GIR_RootConstrainSelectedInstOperands,
     /*  27137 */     // GIR_Coverage, 10729,
     /*  27137 */     GIR_EraseRootFromParent_Done,
     /*  27138 */   // Label 227: @27138
     /*  27138 */   GIM_Try, /*On fail goto*//*Label 228*/ GIMT_Encode4(27619), // Rule ID 10728 //
     /*  27143 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  27146 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  27148 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  27152 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27156 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  27160 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  27163 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27168 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  27172 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  27176 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  27178 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  27182 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  27186 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  27190 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  27194 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  27198 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  27202 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  27206 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  27210 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  27214 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  27218 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  27222 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27226 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  27230 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  27234 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  27236 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  27240 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27244 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  27248 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  27252 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  27254 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  27258 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  27262 */     GIM_CheckNumOperands, /*MI*/6, /*Expected*/4,
     /*  27265 */     GIM_CheckIntrinsicID, /*MI*/6, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27270 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  27274 */     GIM_CheckType, /*MI*/6, /*Op*/3, /*Type*/GILLT_s32,
     /*  27278 */     GIM_CheckHasOneUse, /*MI*/6,
     /*  27280 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/2, // MIs[7]
     /*  27284 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27288 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  27292 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  27296 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27300 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  27304 */     // MIs[8] src0
     /*  27304 */     GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  27309 */     GIM_CheckConstantInt8, /*MI*/8, /*Op*/2, 8,
     /*  27313 */     // MIs[7] Operand 2
     /*  27313 */     GIM_CheckLiteralInt, /*MI*/7, /*Op*/2, GIMT_Encode8(8),
     /*  27324 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/6, /*OpIdx*/3, // MIs[9]
     /*  27328 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27332 */     GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
     /*  27336 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
     /*  27340 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27344 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  27348 */     // MIs[10] src1
     /*  27348 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  27353 */     GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
     /*  27357 */     // MIs[9] Operand 2
     /*  27357 */     GIM_CheckLiteralInt, /*MI*/9, /*Op*/2, GIMT_Encode8(8),
     /*  27368 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/5, /*OpIdx*/2, // MIs[11]
     /*  27372 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27376 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  27380 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  27384 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  27386 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  27390 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  27394 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  27397 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27402 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  27406 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  27410 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  27412 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  27416 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27420 */     // MIs[13] src0
     /*  27420 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  27425 */     // MIs[13] Operand 2
     /*  27425 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  27436 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
     /*  27440 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27444 */     // MIs[14] src1
     /*  27444 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  27449 */     // MIs[14] Operand 2
     /*  27449 */     GIM_CheckLiteralInt, /*MI*/14, /*Op*/2, GIMT_Encode8(8),
     /*  27460 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
     /*  27464 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  27468 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  27471 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27476 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  27480 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  27484 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  27486 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  27490 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27494 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  27498 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  27502 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27506 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  27510 */     // MIs[17] src0
     /*  27510 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  27515 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
     /*  27519 */     // MIs[16] Operand 2
     /*  27519 */     GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
     /*  27530 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  27534 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27538 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  27542 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  27546 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27550 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  27554 */     // MIs[19] src1
     /*  27554 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  27559 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
     /*  27563 */     // MIs[18] Operand 2
     /*  27563 */     GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
     /*  27574 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  27576 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  27576 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  27579 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  27581 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  27584 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  27588 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  27591 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  27595 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  27598 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/2, // src2
     /*  27602 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  27605 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  27608 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  27611 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  27614 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  27617 */     GIR_RootConstrainSelectedInstOperands,
     /*  27618 */     // GIR_Coverage, 10728,
     /*  27618 */     GIR_EraseRootFromParent_Done,
     /*  27619 */   // Label 228: @27619
     /*  27619 */   GIM_Try, /*On fail goto*//*Label 229*/ GIMT_Encode4(28100), // Rule ID 10727 //
     /*  27624 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  27627 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  27629 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  27633 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27637 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  27641 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  27644 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27649 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  27653 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  27657 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  27659 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  27663 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  27667 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  27671 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  27675 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  27679 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  27683 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  27687 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  27691 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  27695 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  27699 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  27703 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27707 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  27711 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  27715 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  27717 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  27721 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27725 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  27729 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  27733 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  27735 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  27739 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  27743 */     GIM_CheckNumOperands, /*MI*/6, /*Expected*/4,
     /*  27746 */     GIM_CheckIntrinsicID, /*MI*/6, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27751 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  27755 */     GIM_CheckType, /*MI*/6, /*Op*/3, /*Type*/GILLT_s32,
     /*  27759 */     GIM_CheckHasOneUse, /*MI*/6,
     /*  27761 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/2, // MIs[7]
     /*  27765 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27769 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  27773 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  27777 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27781 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  27785 */     // MIs[8] src0
     /*  27785 */     GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  27790 */     GIM_CheckConstantInt8, /*MI*/8, /*Op*/2, 8,
     /*  27794 */     // MIs[7] Operand 2
     /*  27794 */     GIM_CheckLiteralInt, /*MI*/7, /*Op*/2, GIMT_Encode8(8),
     /*  27805 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/6, /*OpIdx*/3, // MIs[9]
     /*  27809 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27813 */     GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
     /*  27817 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
     /*  27821 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27825 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  27829 */     // MIs[10] src1
     /*  27829 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  27834 */     GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
     /*  27838 */     // MIs[9] Operand 2
     /*  27838 */     GIM_CheckLiteralInt, /*MI*/9, /*Op*/2, GIMT_Encode8(8),
     /*  27849 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/5, /*OpIdx*/2, // MIs[11]
     /*  27853 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27857 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  27861 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  27865 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  27867 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
     /*  27871 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  27875 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  27878 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27883 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  27887 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  27891 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  27893 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  27897 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27901 */     // MIs[13] src0
     /*  27901 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  27906 */     // MIs[13] Operand 2
     /*  27906 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  27917 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
     /*  27921 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27925 */     // MIs[14] src1
     /*  27925 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  27930 */     // MIs[14] Operand 2
     /*  27930 */     GIM_CheckLiteralInt, /*MI*/14, /*Op*/2, GIMT_Encode8(8),
     /*  27941 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
     /*  27945 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  27949 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  27952 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27957 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  27961 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  27965 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  27967 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  27971 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27975 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  27979 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  27983 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27987 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  27991 */     // MIs[17] src0
     /*  27991 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  27996 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
     /*  28000 */     // MIs[16] Operand 2
     /*  28000 */     GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
     /*  28011 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  28015 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28019 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  28023 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  28027 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28031 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  28035 */     // MIs[19] src1
     /*  28035 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  28040 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
     /*  28044 */     // MIs[18] Operand 2
     /*  28044 */     GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
     /*  28055 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  28057 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  28057 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  28060 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  28062 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  28065 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  28069 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  28072 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  28076 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  28079 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/1, // src2
     /*  28083 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28086 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28089 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28092 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28095 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28098 */     GIR_RootConstrainSelectedInstOperands,
     /*  28099 */     // GIR_Coverage, 10727,
     /*  28099 */     GIR_EraseRootFromParent_Done,
     /*  28100 */   // Label 229: @28100
     /*  28100 */   GIM_Try, /*On fail goto*//*Label 230*/ GIMT_Encode4(28581), // Rule ID 10726 //
     /*  28105 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  28108 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  28110 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  28114 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28118 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28122 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  28125 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  28130 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  28134 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  28138 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  28140 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  28144 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  28148 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  28152 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  28156 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  28160 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  28164 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  28168 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  28172 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  28176 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  28180 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  28184 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28188 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  28192 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  28196 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  28198 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  28202 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28206 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  28210 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  28214 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  28216 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  28220 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28224 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  28228 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  28232 */     GIM_CheckHasOneUse, /*MI*/6,
     /*  28234 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  28238 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28242 */     GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
     /*  28245 */     GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  28250 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  28254 */     GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
     /*  28258 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  28260 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
     /*  28264 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28268 */     // MIs[8] src0
     /*  28268 */     GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  28273 */     // MIs[8] Operand 2
     /*  28273 */     GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
     /*  28284 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/7, /*OpIdx*/3, // MIs[9]
     /*  28288 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28292 */     // MIs[9] src1
     /*  28292 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  28297 */     // MIs[9] Operand 2
     /*  28297 */     GIM_CheckLiteralInt, /*MI*/9, /*Op*/2, GIMT_Encode8(8),
     /*  28308 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/5, /*OpIdx*/2, // MIs[10]
     /*  28312 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28316 */     GIM_CheckNumOperands, /*MI*/10, /*Expected*/4,
     /*  28319 */     GIM_CheckIntrinsicID, /*MI*/10, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  28324 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  28328 */     GIM_CheckType, /*MI*/10, /*Op*/3, /*Type*/GILLT_s32,
     /*  28332 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  28334 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/2, // MIs[11]
     /*  28338 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28342 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  28346 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  28350 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28354 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  28358 */     // MIs[12] src0
     /*  28358 */     GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  28363 */     GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
     /*  28367 */     // MIs[11] Operand 2
     /*  28367 */     GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
     /*  28378 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/10, /*OpIdx*/3, // MIs[13]
     /*  28382 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28386 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  28390 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  28394 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28398 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  28402 */     // MIs[14] src1
     /*  28402 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  28407 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
     /*  28411 */     // MIs[13] Operand 2
     /*  28411 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  28422 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
     /*  28426 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28430 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  28433 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  28438 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  28442 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  28446 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  28448 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  28452 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28456 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  28460 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  28464 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28468 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  28472 */     // MIs[17] src0
     /*  28472 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  28477 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
     /*  28481 */     // MIs[16] Operand 2
     /*  28481 */     GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
     /*  28492 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  28496 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28500 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  28504 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  28508 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28512 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  28516 */     // MIs[19] src1
     /*  28516 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  28521 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
     /*  28525 */     // MIs[18] Operand 2
     /*  28525 */     GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
     /*  28536 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  28538 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  28538 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  28541 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  28543 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  28546 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  28550 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  28553 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  28557 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  28560 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/2, // src2
     /*  28564 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28567 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28570 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28573 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28576 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28579 */     GIR_RootConstrainSelectedInstOperands,
     /*  28580 */     // GIR_Coverage, 10726,
     /*  28580 */     GIR_EraseRootFromParent_Done,
     /*  28581 */   // Label 230: @28581
     /*  28581 */   GIM_Try, /*On fail goto*//*Label 231*/ GIMT_Encode4(29062), // Rule ID 10725 //
     /*  28586 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  28589 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  28591 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  28595 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28599 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28603 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  28606 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  28611 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  28615 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  28619 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  28621 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  28625 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  28629 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  28633 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  28637 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  28641 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  28645 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  28649 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  28653 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  28657 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  28661 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  28665 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28669 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  28673 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  28677 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  28679 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  28683 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28687 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  28691 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  28695 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  28697 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  28701 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28705 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  28709 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  28713 */     GIM_CheckHasOneUse, /*MI*/6,
     /*  28715 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/2, // MIs[7]
     /*  28719 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28723 */     GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
     /*  28726 */     GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  28731 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  28735 */     GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
     /*  28739 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  28741 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
     /*  28745 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28749 */     // MIs[8] src0
     /*  28749 */     GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  28754 */     // MIs[8] Operand 2
     /*  28754 */     GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
     /*  28765 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/7, /*OpIdx*/3, // MIs[9]
     /*  28769 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28773 */     // MIs[9] src1
     /*  28773 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  28778 */     // MIs[9] Operand 2
     /*  28778 */     GIM_CheckLiteralInt, /*MI*/9, /*Op*/2, GIMT_Encode8(8),
     /*  28789 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/5, /*OpIdx*/2, // MIs[10]
     /*  28793 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28797 */     GIM_CheckNumOperands, /*MI*/10, /*Expected*/4,
     /*  28800 */     GIM_CheckIntrinsicID, /*MI*/10, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  28805 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  28809 */     GIM_CheckType, /*MI*/10, /*Op*/3, /*Type*/GILLT_s32,
     /*  28813 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  28815 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/2, // MIs[11]
     /*  28819 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28823 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  28827 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  28831 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28835 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  28839 */     // MIs[12] src0
     /*  28839 */     GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  28844 */     GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
     /*  28848 */     // MIs[11] Operand 2
     /*  28848 */     GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
     /*  28859 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/10, /*OpIdx*/3, // MIs[13]
     /*  28863 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28867 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  28871 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  28875 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28879 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  28883 */     // MIs[14] src1
     /*  28883 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  28888 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
     /*  28892 */     // MIs[13] Operand 2
     /*  28892 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  28903 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
     /*  28907 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28911 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  28914 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  28919 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  28923 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  28927 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  28929 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  28933 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28937 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  28941 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  28945 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28949 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  28953 */     // MIs[17] src0
     /*  28953 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  28958 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
     /*  28962 */     // MIs[16] Operand 2
     /*  28962 */     GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
     /*  28973 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  28977 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28981 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  28985 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  28989 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28993 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  28997 */     // MIs[19] src1
     /*  28997 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  29002 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
     /*  29006 */     // MIs[18] Operand 2
     /*  29006 */     GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
     /*  29017 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  29019 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  29019 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  29022 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  29024 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  29027 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  29031 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  29034 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  29038 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  29041 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src2
     /*  29045 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29048 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29051 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29054 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29057 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29060 */     GIR_RootConstrainSelectedInstOperands,
     /*  29061 */     // GIR_Coverage, 10725,
     /*  29061 */     GIR_EraseRootFromParent_Done,
     /*  29062 */   // Label 231: @29062
     /*  29062 */   GIM_Try, /*On fail goto*//*Label 232*/ GIMT_Encode4(29543), // Rule ID 10724 //
     /*  29067 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  29070 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  29072 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  29076 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  29080 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  29084 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  29088 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  29092 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  29094 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  29098 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29102 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  29105 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  29110 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  29114 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  29118 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  29120 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  29124 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29128 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  29132 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  29136 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  29140 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  29144 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  29148 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  29152 */     // MIs[3] Operand 2
     /*  29152 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(8),
     /*  29163 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
     /*  29167 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29171 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  29175 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  29179 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  29183 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  29187 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  29191 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  29195 */     // MIs[5] Operand 2
     /*  29195 */     GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, GIMT_Encode8(8),
     /*  29206 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
     /*  29210 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  29214 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  29218 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  29222 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  29224 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  29228 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29232 */     GIM_CheckNumOperands, /*MI*/8, /*Expected*/4,
     /*  29235 */     GIM_CheckIntrinsicID, /*MI*/8, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  29240 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  29244 */     GIM_CheckType, /*MI*/8, /*Op*/3, /*Type*/GILLT_s32,
     /*  29248 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  29250 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
     /*  29254 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29258 */     GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
     /*  29262 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
     /*  29266 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  29270 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  29274 */     // MIs[10] src0
     /*  29274 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  29279 */     GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
     /*  29283 */     // MIs[9] Operand 2
     /*  29283 */     GIM_CheckLiteralInt, /*MI*/9, /*Op*/2, GIMT_Encode8(8),
     /*  29294 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/8, /*OpIdx*/3, // MIs[11]
     /*  29298 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29302 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  29306 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  29310 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  29314 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  29318 */     // MIs[12] src1
     /*  29318 */     GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  29323 */     GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
     /*  29327 */     // MIs[11] Operand 2
     /*  29327 */     GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
     /*  29338 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/7, /*OpIdx*/2, // MIs[13]
     /*  29342 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  29346 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  29350 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  29354 */     GIM_CheckHasOneUse, /*MI*/13,
     /*  29356 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  29360 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29364 */     GIM_CheckNumOperands, /*MI*/14, /*Expected*/4,
     /*  29367 */     GIM_CheckIntrinsicID, /*MI*/14, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  29372 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  29376 */     GIM_CheckType, /*MI*/14, /*Op*/3, /*Type*/GILLT_s32,
     /*  29380 */     GIM_CheckHasOneUse, /*MI*/14,
     /*  29382 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/2, // MIs[15]
     /*  29386 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29390 */     // MIs[15] src0
     /*  29390 */     GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  29395 */     // MIs[15] Operand 2
     /*  29395 */     GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
     /*  29406 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/14, /*OpIdx*/3, // MIs[16]
     /*  29410 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29414 */     // MIs[16] src1
     /*  29414 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  29419 */     // MIs[16] Operand 2
     /*  29419 */     GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
     /*  29430 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  29434 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29438 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  29441 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  29446 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  29450 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  29454 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  29456 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  29460 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  29464 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  29468 */     // MIs[18] src0
     /*  29468 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  29473 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  29477 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  29481 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  29485 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  29489 */     // MIs[19] src1
     /*  29489 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  29494 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  29498 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  29500 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  29500 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  29503 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  29505 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  29508 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
     /*  29512 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  29515 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  29519 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  29522 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/13, /*OpIdx*/2, // src2
     /*  29526 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29529 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29532 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29535 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29538 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29541 */     GIR_RootConstrainSelectedInstOperands,
     /*  29542 */     // GIR_Coverage, 10724,
     /*  29542 */     GIR_EraseRootFromParent_Done,
     /*  29543 */   // Label 232: @29543
     /*  29543 */   GIM_Try, /*On fail goto*//*Label 233*/ GIMT_Encode4(30024), // Rule ID 10723 //
     /*  29548 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  29551 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  29553 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  29557 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  29561 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  29565 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  29569 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  29573 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  29575 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  29579 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29583 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  29586 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  29591 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  29595 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  29599 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  29601 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  29605 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29609 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  29613 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  29617 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  29621 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  29625 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  29629 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  29633 */     // MIs[3] Operand 2
     /*  29633 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(8),
     /*  29644 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
     /*  29648 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29652 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  29656 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  29660 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  29664 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  29668 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  29672 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  29676 */     // MIs[5] Operand 2
     /*  29676 */     GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, GIMT_Encode8(8),
     /*  29687 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
     /*  29691 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  29695 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  29699 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  29703 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  29705 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  29709 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29713 */     GIM_CheckNumOperands, /*MI*/8, /*Expected*/4,
     /*  29716 */     GIM_CheckIntrinsicID, /*MI*/8, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  29721 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  29725 */     GIM_CheckType, /*MI*/8, /*Op*/3, /*Type*/GILLT_s32,
     /*  29729 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  29731 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
     /*  29735 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29739 */     GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
     /*  29743 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
     /*  29747 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  29751 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  29755 */     // MIs[10] src0
     /*  29755 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  29760 */     GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
     /*  29764 */     // MIs[9] Operand 2
     /*  29764 */     GIM_CheckLiteralInt, /*MI*/9, /*Op*/2, GIMT_Encode8(8),
     /*  29775 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/8, /*OpIdx*/3, // MIs[11]
     /*  29779 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29783 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  29787 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  29791 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  29795 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  29799 */     // MIs[12] src1
     /*  29799 */     GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  29804 */     GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
     /*  29808 */     // MIs[11] Operand 2
     /*  29808 */     GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
     /*  29819 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/7, /*OpIdx*/2, // MIs[13]
     /*  29823 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  29827 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  29831 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  29835 */     GIM_CheckHasOneUse, /*MI*/13,
     /*  29837 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/2, // MIs[14]
     /*  29841 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29845 */     GIM_CheckNumOperands, /*MI*/14, /*Expected*/4,
     /*  29848 */     GIM_CheckIntrinsicID, /*MI*/14, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  29853 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  29857 */     GIM_CheckType, /*MI*/14, /*Op*/3, /*Type*/GILLT_s32,
     /*  29861 */     GIM_CheckHasOneUse, /*MI*/14,
     /*  29863 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/2, // MIs[15]
     /*  29867 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29871 */     // MIs[15] src0
     /*  29871 */     GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  29876 */     // MIs[15] Operand 2
     /*  29876 */     GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
     /*  29887 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/14, /*OpIdx*/3, // MIs[16]
     /*  29891 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29895 */     // MIs[16] src1
     /*  29895 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  29900 */     // MIs[16] Operand 2
     /*  29900 */     GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
     /*  29911 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  29915 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29919 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  29922 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  29927 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  29931 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  29935 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  29937 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  29941 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  29945 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  29949 */     // MIs[18] src0
     /*  29949 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  29954 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  29958 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  29962 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  29966 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  29970 */     // MIs[19] src1
     /*  29970 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  29975 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  29979 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  29981 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  29981 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  29984 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  29986 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  29989 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
     /*  29993 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  29996 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  30000 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  30003 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/13, /*OpIdx*/1, // src2
     /*  30007 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30010 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30013 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30016 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30019 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30022 */     GIR_RootConstrainSelectedInstOperands,
     /*  30023 */     // GIR_Coverage, 10723,
     /*  30023 */     GIR_EraseRootFromParent_Done,
     /*  30024 */   // Label 233: @30024
     /*  30024 */   GIM_Try, /*On fail goto*//*Label 234*/ GIMT_Encode4(30505), // Rule ID 10722 //
     /*  30029 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  30032 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  30034 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  30038 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30042 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  30046 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  30050 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  30054 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  30056 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  30060 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30064 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  30067 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  30072 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  30076 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  30080 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  30082 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  30086 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30090 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  30094 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  30098 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  30102 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  30106 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  30110 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  30114 */     // MIs[3] Operand 2
     /*  30114 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(8),
     /*  30125 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
     /*  30129 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30133 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  30137 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  30141 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  30145 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  30149 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  30153 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  30157 */     // MIs[5] Operand 2
     /*  30157 */     GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, GIMT_Encode8(8),
     /*  30168 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
     /*  30172 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  30176 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  30180 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  30184 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  30186 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  30190 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  30194 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  30198 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  30202 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  30204 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  30208 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30212 */     GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
     /*  30215 */     GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  30220 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  30224 */     GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
     /*  30228 */     GIM_CheckHasOneUse, /*MI*/9,
     /*  30230 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
     /*  30234 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30238 */     // MIs[10] src0
     /*  30238 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  30243 */     // MIs[10] Operand 2
     /*  30243 */     GIM_CheckLiteralInt, /*MI*/10, /*Op*/2, GIMT_Encode8(8),
     /*  30254 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
     /*  30258 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30262 */     // MIs[11] src1
     /*  30262 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  30267 */     // MIs[11] Operand 2
     /*  30267 */     GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
     /*  30278 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/7, /*OpIdx*/2, // MIs[12]
     /*  30282 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30286 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  30289 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  30294 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  30298 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  30302 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  30304 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  30308 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30312 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  30316 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  30320 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  30324 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  30328 */     // MIs[14] src0
     /*  30328 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  30333 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
     /*  30337 */     // MIs[13] Operand 2
     /*  30337 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  30348 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  30352 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30356 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  30360 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  30364 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  30368 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  30372 */     // MIs[16] src1
     /*  30372 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  30377 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 8,
     /*  30381 */     // MIs[15] Operand 2
     /*  30381 */     GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
     /*  30392 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  30396 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30400 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  30403 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  30408 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  30412 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  30416 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  30418 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  30422 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  30426 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  30430 */     // MIs[18] src0
     /*  30430 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  30435 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  30439 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  30443 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  30447 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  30451 */     // MIs[19] src1
     /*  30451 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  30456 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  30460 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  30462 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  30462 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  30465 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  30467 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  30470 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
     /*  30474 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  30477 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  30481 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  30484 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/2, // src2
     /*  30488 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30491 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30494 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30497 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30500 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30503 */     GIR_RootConstrainSelectedInstOperands,
     /*  30504 */     // GIR_Coverage, 10722,
     /*  30504 */     GIR_EraseRootFromParent_Done,
     /*  30505 */   // Label 234: @30505
     /*  30505 */   GIM_Try, /*On fail goto*//*Label 235*/ GIMT_Encode4(30986), // Rule ID 10721 //
     /*  30510 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  30513 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  30515 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  30519 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30523 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  30527 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  30531 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  30535 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  30537 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  30541 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30545 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  30548 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  30553 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  30557 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  30561 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  30563 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  30567 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30571 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  30575 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  30579 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  30583 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  30587 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  30591 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  30595 */     // MIs[3] Operand 2
     /*  30595 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(8),
     /*  30606 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
     /*  30610 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30614 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  30618 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  30622 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  30626 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  30630 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  30634 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  30638 */     // MIs[5] Operand 2
     /*  30638 */     GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, GIMT_Encode8(8),
     /*  30649 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
     /*  30653 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  30657 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  30661 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  30665 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  30667 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  30671 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  30675 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  30679 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  30683 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  30685 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
     /*  30689 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30693 */     GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
     /*  30696 */     GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  30701 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  30705 */     GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
     /*  30709 */     GIM_CheckHasOneUse, /*MI*/9,
     /*  30711 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
     /*  30715 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30719 */     // MIs[10] src0
     /*  30719 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  30724 */     // MIs[10] Operand 2
     /*  30724 */     GIM_CheckLiteralInt, /*MI*/10, /*Op*/2, GIMT_Encode8(8),
     /*  30735 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
     /*  30739 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30743 */     // MIs[11] src1
     /*  30743 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  30748 */     // MIs[11] Operand 2
     /*  30748 */     GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
     /*  30759 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/7, /*OpIdx*/2, // MIs[12]
     /*  30763 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30767 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  30770 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  30775 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  30779 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  30783 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  30785 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  30789 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30793 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  30797 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  30801 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  30805 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  30809 */     // MIs[14] src0
     /*  30809 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  30814 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
     /*  30818 */     // MIs[13] Operand 2
     /*  30818 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  30829 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  30833 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30837 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  30841 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  30845 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  30849 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  30853 */     // MIs[16] src1
     /*  30853 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  30858 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 8,
     /*  30862 */     // MIs[15] Operand 2
     /*  30862 */     GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
     /*  30873 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  30877 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30881 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  30884 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  30889 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  30893 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  30897 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  30899 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  30903 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  30907 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  30911 */     // MIs[18] src0
     /*  30911 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  30916 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  30920 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  30924 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  30928 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  30932 */     // MIs[19] src1
     /*  30932 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  30937 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  30941 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  30943 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  30943 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  30946 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  30948 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  30951 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
     /*  30955 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  30958 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  30962 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  30965 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/1, // src2
     /*  30969 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30972 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30975 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30978 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30981 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30984 */     GIR_RootConstrainSelectedInstOperands,
     /*  30985 */     // GIR_Coverage, 10721,
     /*  30985 */     GIR_EraseRootFromParent_Done,
     /*  30986 */   // Label 235: @30986
     /*  30986 */   GIM_Try, /*On fail goto*//*Label 236*/ GIMT_Encode4(31467), // Rule ID 10720 //
     /*  30991 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  30994 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  30996 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  31000 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31004 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  31008 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  31012 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  31016 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  31018 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  31022 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  31026 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  31030 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  31034 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  31036 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  31040 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31044 */     GIM_CheckNumOperands, /*MI*/3, /*Expected*/4,
     /*  31047 */     GIM_CheckIntrinsicID, /*MI*/3, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  31052 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  31056 */     GIM_CheckType, /*MI*/3, /*Op*/3, /*Type*/GILLT_s32,
     /*  31060 */     GIM_CheckHasOneUse, /*MI*/3,
     /*  31062 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  31066 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31070 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  31074 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  31078 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31082 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  31086 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  31090 */     GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 8,
     /*  31094 */     // MIs[4] Operand 2
     /*  31094 */     GIM_CheckLiteralInt, /*MI*/4, /*Op*/2, GIMT_Encode8(8),
     /*  31105 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/3, // MIs[6]
     /*  31109 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31113 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  31117 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  31121 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31125 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  31129 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  31133 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 8,
     /*  31137 */     // MIs[6] Operand 2
     /*  31137 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
     /*  31148 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/2, // MIs[8]
     /*  31152 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  31156 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  31160 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  31164 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  31166 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  31170 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31174 */     GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
     /*  31177 */     GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  31182 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  31186 */     GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
     /*  31190 */     GIM_CheckHasOneUse, /*MI*/9,
     /*  31192 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
     /*  31196 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31200 */     // MIs[10] src0
     /*  31200 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  31205 */     // MIs[10] Operand 2
     /*  31205 */     GIM_CheckLiteralInt, /*MI*/10, /*Op*/2, GIMT_Encode8(8),
     /*  31216 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
     /*  31220 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31224 */     // MIs[11] src1
     /*  31224 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  31229 */     // MIs[11] Operand 2
     /*  31229 */     GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
     /*  31240 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
     /*  31244 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31248 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  31251 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  31256 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  31260 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  31264 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  31266 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  31270 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31274 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  31278 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  31282 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31286 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  31290 */     // MIs[14] src0
     /*  31290 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  31295 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
     /*  31299 */     // MIs[13] Operand 2
     /*  31299 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  31310 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  31314 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31318 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  31322 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  31326 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31330 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  31334 */     // MIs[16] src1
     /*  31334 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  31339 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
     /*  31343 */     // MIs[15] Operand 2
     /*  31343 */     GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
     /*  31354 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  31358 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31362 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  31365 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  31370 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  31374 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  31378 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  31380 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  31384 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  31388 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  31392 */     // MIs[18] src0
     /*  31392 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  31397 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  31401 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  31405 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  31409 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  31413 */     // MIs[19] src1
     /*  31413 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  31418 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  31422 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  31424 */     // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  31424 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  31427 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  31429 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  31432 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  31436 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  31439 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/7, /*OpIdx*/1, // src1
     /*  31443 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  31446 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/2, // src2
     /*  31450 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31453 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31456 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31459 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31462 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31465 */     GIR_RootConstrainSelectedInstOperands,
     /*  31466 */     // GIR_Coverage, 10720,
     /*  31466 */     GIR_EraseRootFromParent_Done,
     /*  31467 */   // Label 236: @31467
     /*  31467 */   GIM_Try, /*On fail goto*//*Label 237*/ GIMT_Encode4(31948), // Rule ID 10719 //
     /*  31472 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  31475 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  31477 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  31481 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31485 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  31489 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  31493 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  31497 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  31499 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  31503 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  31507 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  31511 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  31515 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  31517 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  31521 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31525 */     GIM_CheckNumOperands, /*MI*/3, /*Expected*/4,
     /*  31528 */     GIM_CheckIntrinsicID, /*MI*/3, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  31533 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  31537 */     GIM_CheckType, /*MI*/3, /*Op*/3, /*Type*/GILLT_s32,
     /*  31541 */     GIM_CheckHasOneUse, /*MI*/3,
     /*  31543 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  31547 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31551 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  31555 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  31559 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31563 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  31567 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  31571 */     GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 8,
     /*  31575 */     // MIs[4] Operand 2
     /*  31575 */     GIM_CheckLiteralInt, /*MI*/4, /*Op*/2, GIMT_Encode8(8),
     /*  31586 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/3, // MIs[6]
     /*  31590 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31594 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  31598 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  31602 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31606 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  31610 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  31614 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 8,
     /*  31618 */     // MIs[6] Operand 2
     /*  31618 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
     /*  31629 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/2, // MIs[8]
     /*  31633 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  31637 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  31641 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  31645 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  31647 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
     /*  31651 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31655 */     GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
     /*  31658 */     GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  31663 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  31667 */     GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
     /*  31671 */     GIM_CheckHasOneUse, /*MI*/9,
     /*  31673 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
     /*  31677 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31681 */     // MIs[10] src0
     /*  31681 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  31686 */     // MIs[10] Operand 2
     /*  31686 */     GIM_CheckLiteralInt, /*MI*/10, /*Op*/2, GIMT_Encode8(8),
     /*  31697 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
     /*  31701 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31705 */     // MIs[11] src1
     /*  31705 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  31710 */     // MIs[11] Operand 2
     /*  31710 */     GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
     /*  31721 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
     /*  31725 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31729 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  31732 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  31737 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  31741 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  31745 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  31747 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  31751 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31755 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  31759 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  31763 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31767 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  31771 */     // MIs[14] src0
     /*  31771 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  31776 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
     /*  31780 */     // MIs[13] Operand 2
     /*  31780 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  31791 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  31795 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31799 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  31803 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  31807 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31811 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  31815 */     // MIs[16] src1
     /*  31815 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  31820 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
     /*  31824 */     // MIs[15] Operand 2
     /*  31824 */     GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
     /*  31835 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  31839 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31843 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  31846 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  31851 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  31855 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  31859 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  31861 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  31865 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  31869 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  31873 */     // MIs[18] src0
     /*  31873 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  31878 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  31882 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  31886 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  31890 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  31894 */     // MIs[19] src1
     /*  31894 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  31899 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  31903 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  31905 */     // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  31905 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  31908 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  31910 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  31913 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  31917 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  31920 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/7, /*OpIdx*/1, // src1
     /*  31924 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  31927 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/1, // src2
     /*  31931 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31934 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31937 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31940 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31943 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31946 */     GIR_RootConstrainSelectedInstOperands,
     /*  31947 */     // GIR_Coverage, 10719,
     /*  31947 */     GIR_EraseRootFromParent_Done,
     /*  31948 */   // Label 237: @31948
     /*  31948 */   GIM_Try, /*On fail goto*//*Label 238*/ GIMT_Encode4(32429), // Rule ID 10718 //
     /*  31953 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  31956 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  31958 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  31962 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31966 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  31970 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  31974 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  31978 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  31980 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  31984 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  31988 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  31992 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  31996 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  31998 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  32002 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  32006 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  32010 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  32014 */     GIM_CheckHasOneUse, /*MI*/3,
     /*  32016 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  32020 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32024 */     GIM_CheckNumOperands, /*MI*/4, /*Expected*/4,
     /*  32027 */     GIM_CheckIntrinsicID, /*MI*/4, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  32032 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  32036 */     GIM_CheckType, /*MI*/4, /*Op*/3, /*Type*/GILLT_s32,
     /*  32040 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  32042 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  32046 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  32050 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  32054 */     // MIs[5] Operand 2
     /*  32054 */     GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, GIMT_Encode8(8),
     /*  32065 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/4, /*OpIdx*/3, // MIs[6]
     /*  32069 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  32073 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  32077 */     // MIs[6] Operand 2
     /*  32077 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
     /*  32088 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/2, // MIs[7]
     /*  32092 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32096 */     GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
     /*  32099 */     GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  32104 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  32108 */     GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
     /*  32112 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  32114 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
     /*  32118 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  32122 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  32126 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  32130 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  32134 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  32138 */     // MIs[9] src0
     /*  32138 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  32143 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 8,
     /*  32147 */     // MIs[8] Operand 2
     /*  32147 */     GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
     /*  32158 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/7, /*OpIdx*/3, // MIs[10]
     /*  32162 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  32166 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  32170 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  32174 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  32178 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  32182 */     // MIs[11] src1
     /*  32182 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  32187 */     GIM_CheckConstantInt8, /*MI*/11, /*Op*/2, 8,
     /*  32191 */     // MIs[10] Operand 2
     /*  32191 */     GIM_CheckLiteralInt, /*MI*/10, /*Op*/2, GIMT_Encode8(8),
     /*  32202 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
     /*  32206 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32210 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  32213 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  32218 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  32222 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  32226 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  32228 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  32232 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  32236 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  32240 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  32244 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  32248 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  32252 */     // MIs[14] src0
     /*  32252 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  32257 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
     /*  32261 */     // MIs[13] Operand 2
     /*  32261 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  32272 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  32276 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  32280 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  32284 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  32288 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  32292 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  32296 */     // MIs[16] src1
     /*  32296 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  32301 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
     /*  32305 */     // MIs[15] Operand 2
     /*  32305 */     GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
     /*  32316 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  32320 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32324 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  32327 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  32332 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  32336 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  32340 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  32342 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  32346 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  32350 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  32354 */     // MIs[18] src0
     /*  32354 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  32359 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  32363 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  32367 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  32371 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  32375 */     // MIs[19] src1
     /*  32375 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  32380 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  32384 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  32386 */     // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  32386 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  32389 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  32391 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32394 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  32398 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32401 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  32405 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32408 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // src2
     /*  32412 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32415 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32418 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32421 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32424 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32427 */     GIR_RootConstrainSelectedInstOperands,
     /*  32428 */     // GIR_Coverage, 10718,
     /*  32428 */     GIR_EraseRootFromParent_Done,
     /*  32429 */   // Label 238: @32429
     /*  32429 */   GIM_Try, /*On fail goto*//*Label 239*/ GIMT_Encode4(32910), // Rule ID 2951 //
     /*  32434 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  32437 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  32439 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  32443 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32447 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  32451 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  32455 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  32459 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  32461 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  32465 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  32469 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  32473 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  32477 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  32479 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  32483 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  32487 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  32491 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  32495 */     GIM_CheckHasOneUse, /*MI*/3,
     /*  32497 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  32501 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32505 */     GIM_CheckNumOperands, /*MI*/4, /*Expected*/4,
     /*  32508 */     GIM_CheckIntrinsicID, /*MI*/4, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  32513 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  32517 */     GIM_CheckType, /*MI*/4, /*Op*/3, /*Type*/GILLT_s32,
     /*  32521 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  32523 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  32527 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  32531 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  32535 */     // MIs[5] Operand 2
     /*  32535 */     GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, GIMT_Encode8(8),
     /*  32546 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/4, /*OpIdx*/3, // MIs[6]
     /*  32550 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  32554 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  32558 */     // MIs[6] Operand 2
     /*  32558 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
     /*  32569 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/2, // MIs[7]
     /*  32573 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32577 */     GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
     /*  32580 */     GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  32585 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  32589 */     GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
     /*  32593 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  32595 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
     /*  32599 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  32603 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  32607 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  32611 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  32615 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  32619 */     // MIs[9] src0
     /*  32619 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  32624 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 8,
     /*  32628 */     // MIs[8] Operand 2
     /*  32628 */     GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
     /*  32639 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/7, /*OpIdx*/3, // MIs[10]
     /*  32643 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  32647 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  32651 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  32655 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  32659 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  32663 */     // MIs[11] src1
     /*  32663 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  32668 */     GIM_CheckConstantInt8, /*MI*/11, /*Op*/2, 8,
     /*  32672 */     // MIs[10] Operand 2
     /*  32672 */     GIM_CheckLiteralInt, /*MI*/10, /*Op*/2, GIMT_Encode8(8),
     /*  32683 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
     /*  32687 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32691 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  32694 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  32699 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  32703 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  32707 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  32709 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  32713 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  32717 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  32721 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  32725 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  32729 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  32733 */     // MIs[14] src0
     /*  32733 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  32738 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
     /*  32742 */     // MIs[13] Operand 2
     /*  32742 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  32753 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  32757 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  32761 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  32765 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  32769 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  32773 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  32777 */     // MIs[16] src1
     /*  32777 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  32782 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
     /*  32786 */     // MIs[15] Operand 2
     /*  32786 */     GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
     /*  32797 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  32801 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32805 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  32808 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  32813 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  32817 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  32821 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  32823 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  32827 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  32831 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  32835 */     // MIs[18] src0
     /*  32835 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  32840 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  32844 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  32848 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  32852 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  32856 */     // MIs[19] src1
     /*  32856 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  32861 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  32865 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  32867 */     // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  32867 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  32870 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  32872 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32875 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  32879 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32882 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  32886 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32889 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src2
     /*  32893 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32896 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32899 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32902 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32905 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32908 */     GIR_RootConstrainSelectedInstOperands,
     /*  32909 */     // GIR_Coverage, 2951,
     /*  32909 */     GIR_EraseRootFromParent_Done,
     /*  32910 */   // Label 239: @32910
     /*  32910 */   GIM_Try, /*On fail goto*//*Label 240*/ GIMT_Encode4(33133), // Rule ID 9375 //
     /*  32915 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
     /*  32918 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  32922 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32926 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32930 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  32933 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  32938 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  32942 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  32946 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  32948 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  32952 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  32956 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  32960 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  32964 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
     /*  32975 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  32979 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  32983 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  32987 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  32991 */     GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(65535),
     /*  33002 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  33006 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  33010 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  33014 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  33018 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  33020 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  33024 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  33028 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  33031 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  33036 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  33040 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  33044 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  33046 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  33050 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  33054 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  33058 */     // MIs[6] src0
     /*  33058 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  33063 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  33067 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
     /*  33071 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  33075 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  33079 */     // MIs[7] src1
     /*  33079 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  33084 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  33088 */     GIM_CheckIsSafeToFold, /*NumInsns*/7,
     /*  33090 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 65535:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 65535:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)  =>  (V_DOT2_U32_U16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  33090 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_U32_U16),
     /*  33093 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  33095 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33098 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  33102 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33105 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  33109 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33112 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // src2
     /*  33116 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33119 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33122 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33125 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33128 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33131 */     GIR_RootConstrainSelectedInstOperands,
     /*  33132 */     // GIR_Coverage, 9375,
     /*  33132 */     GIR_EraseRootFromParent_Done,
     /*  33133 */   // Label 240: @33133
     /*  33133 */   GIM_Try, /*On fail goto*//*Label 241*/ GIMT_Encode4(33356), // Rule ID 9376 //
     /*  33138 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
     /*  33141 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  33145 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33149 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  33153 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  33156 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  33161 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  33165 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  33169 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  33171 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  33175 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  33179 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  33183 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  33187 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
     /*  33198 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  33202 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  33206 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  33210 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  33214 */     GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(65535),
     /*  33225 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  33229 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  33233 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  33237 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  33241 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  33243 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  33247 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  33251 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  33254 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  33259 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  33263 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  33267 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  33269 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  33273 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  33277 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  33281 */     // MIs[6] src0
     /*  33281 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  33286 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  33290 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
     /*  33294 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  33298 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  33302 */     // MIs[7] src1
     /*  33302 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  33307 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  33311 */     GIM_CheckIsSafeToFold, /*NumInsns*/7,
     /*  33313 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 65535:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 65535:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)  =>  (V_DOT2_U32_U16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  33313 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_U32_U16),
     /*  33316 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  33318 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33321 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  33325 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33328 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  33332 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33335 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src2
     /*  33339 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33342 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33345 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33348 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33351 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33354 */     GIR_RootConstrainSelectedInstOperands,
     /*  33355 */     // GIR_Coverage, 9376,
     /*  33355 */     GIR_EraseRootFromParent_Done,
     /*  33356 */   // Label 241: @33356
     /*  33356 */   GIM_Try, /*On fail goto*//*Label 242*/ GIMT_Encode4(33579), // Rule ID 2927 //
     /*  33361 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
     /*  33364 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  33368 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33372 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  33376 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  33380 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  33384 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  33386 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  33390 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  33394 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  33397 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  33402 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  33406 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  33410 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  33412 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  33416 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  33420 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  33424 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  33428 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
     /*  33432 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/3, // MIs[4]
     /*  33436 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  33440 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  33444 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  33448 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  33452 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  33456 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  33460 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  33463 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  33468 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  33472 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  33476 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  33478 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  33482 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  33486 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  33490 */     // MIs[6] src0
     /*  33490 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  33495 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(65535),
     /*  33506 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
     /*  33510 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_AND),
     /*  33514 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  33518 */     // MIs[7] src1
     /*  33518 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  33523 */     GIM_CheckConstantInt, /*MI*/7, /*Op*/2, GIMT_Encode8(65535),
     /*  33534 */     GIM_CheckIsSafeToFold, /*NumInsns*/7,
     /*  33536 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 65535:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 65535:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)  =>  (V_DOT2_U32_U16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  33536 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_U32_U16),
     /*  33539 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  33541 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33544 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src0
     /*  33548 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33551 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
     /*  33555 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33558 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  33562 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33565 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33568 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33571 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33574 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33577 */     GIR_RootConstrainSelectedInstOperands,
     /*  33578 */     // GIR_Coverage, 2927,
     /*  33578 */     GIR_EraseRootFromParent_Done,
     /*  33579 */   // Label 242: @33579
     /*  33579 */   GIM_Try, /*On fail goto*//*Label 243*/ GIMT_Encode4(33802), // Rule ID 9374 //
     /*  33584 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
     /*  33587 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  33591 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33595 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  33599 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  33603 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  33607 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  33609 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  33613 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  33617 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  33620 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  33625 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  33629 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  33633 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  33635 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  33639 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  33643 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  33647 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  33651 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
     /*  33655 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/3, // MIs[4]
     /*  33659 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  33663 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  33667 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  33671 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  33675 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  33679 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  33683 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  33686 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  33691 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  33695 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  33699 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  33701 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  33705 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  33709 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  33713 */     // MIs[6] src0
     /*  33713 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  33718 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(65535),
     /*  33729 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
     /*  33733 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_AND),
     /*  33737 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  33741 */     // MIs[7] src1
     /*  33741 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  33746 */     GIM_CheckConstantInt, /*MI*/7, /*Op*/2, GIMT_Encode8(65535),
     /*  33757 */     GIM_CheckIsSafeToFold, /*NumInsns*/7,
     /*  33759 */     // (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 65535:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 65535:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)  =>  (V_DOT2_U32_U16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  33759 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_U32_U16),
     /*  33762 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  33764 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33767 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src0
     /*  33771 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33774 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
     /*  33778 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33781 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
     /*  33785 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33788 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33791 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33794 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33797 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33800 */     GIR_RootConstrainSelectedInstOperands,
     /*  33801 */     // GIR_Coverage, 9374,
     /*  33801 */     GIR_EraseRootFromParent_Done,
     /*  33802 */   // Label 243: @33802
     /*  33802 */   GIM_Try, /*On fail goto*//*Label 244*/ GIMT_Encode4(34017), // Rule ID 9407 //
     /*  33807 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
     /*  33810 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  33814 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33818 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  33822 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  33825 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  33830 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  33834 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  33838 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  33840 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  33844 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  33848 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  33852 */     // MIs[2] Operand 2
     /*  33852 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
     /*  33863 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  33867 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  33871 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  33875 */     // MIs[3] Operand 2
     /*  33875 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(16),
     /*  33886 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  33890 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  33894 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  33898 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  33902 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  33904 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  33908 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  33912 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  33915 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  33920 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  33924 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  33928 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  33930 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  33934 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  33938 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  33942 */     // MIs[6] src0
     /*  33942 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  33947 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  33951 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
     /*  33955 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  33959 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  33963 */     // MIs[7] src1
     /*  33963 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  33968 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  33972 */     GIM_CheckIsSafeToFold, /*NumInsns*/7,
     /*  33974 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i16:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i16:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)  =>  (V_DOT2_I32_I16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  33974 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_I32_I16),
     /*  33977 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  33979 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33982 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  33986 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33989 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  33993 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33996 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // src2
     /*  34000 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34003 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34006 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34009 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34012 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34015 */     GIR_RootConstrainSelectedInstOperands,
     /*  34016 */     // GIR_Coverage, 9407,
     /*  34016 */     GIR_EraseRootFromParent_Done,
     /*  34017 */   // Label 244: @34017
     /*  34017 */   GIM_Try, /*On fail goto*//*Label 245*/ GIMT_Encode4(34232), // Rule ID 9408 //
     /*  34022 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
     /*  34025 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  34029 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34033 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  34037 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  34040 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  34045 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34049 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  34053 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34055 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  34059 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  34063 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  34067 */     // MIs[2] Operand 2
     /*  34067 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
     /*  34078 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  34082 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  34086 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  34090 */     // MIs[3] Operand 2
     /*  34090 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(16),
     /*  34101 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  34105 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  34109 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  34113 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  34117 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  34119 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  34123 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  34127 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  34130 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  34135 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  34139 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  34143 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  34145 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  34149 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  34153 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  34157 */     // MIs[6] src0
     /*  34157 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  34162 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  34166 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
     /*  34170 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  34174 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  34178 */     // MIs[7] src1
     /*  34178 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  34183 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  34187 */     GIM_CheckIsSafeToFold, /*NumInsns*/7,
     /*  34189 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i16:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i16:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)  =>  (V_DOT2_I32_I16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  34189 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_I32_I16),
     /*  34192 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  34194 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  34197 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  34201 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  34204 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  34208 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  34211 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src2
     /*  34215 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34218 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34221 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34224 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34227 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34230 */     GIR_RootConstrainSelectedInstOperands,
     /*  34231 */     // GIR_Coverage, 9408,
     /*  34231 */     GIR_EraseRootFromParent_Done,
     /*  34232 */   // Label 245: @34232
     /*  34232 */   GIM_Try, /*On fail goto*//*Label 246*/ GIMT_Encode4(34447), // Rule ID 2931 //
     /*  34237 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
     /*  34240 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  34244 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34248 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  34252 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34256 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34260 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34262 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  34266 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  34270 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  34273 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  34278 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  34282 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  34286 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  34288 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  34292 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  34296 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  34300 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  34304 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
     /*  34308 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/3, // MIs[4]
     /*  34312 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  34316 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  34320 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  34324 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  34328 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  34332 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  34336 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  34339 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  34344 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  34348 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  34352 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  34354 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  34358 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  34362 */     // MIs[6] src0
     /*  34362 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  34367 */     // MIs[6] Operand 2
     /*  34367 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(16),
     /*  34378 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
     /*  34382 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  34386 */     // MIs[7] src1
     /*  34386 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  34391 */     // MIs[7] Operand 2
     /*  34391 */     GIM_CheckLiteralInt, /*MI*/7, /*Op*/2, GIMT_Encode8(16),
     /*  34402 */     GIM_CheckIsSafeToFold, /*NumInsns*/7,
     /*  34404 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i16:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i16:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)  =>  (V_DOT2_I32_I16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  34404 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_I32_I16),
     /*  34407 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  34409 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  34412 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src0
     /*  34416 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  34419 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
     /*  34423 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  34426 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  34430 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34433 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34436 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34439 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34442 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34445 */     GIR_RootConstrainSelectedInstOperands,
     /*  34446 */     // GIR_Coverage, 2931,
     /*  34446 */     GIR_EraseRootFromParent_Done,
     /*  34447 */   // Label 246: @34447
     /*  34447 */   GIM_Try, /*On fail goto*//*Label 247*/ GIMT_Encode4(34662), // Rule ID 9406 //
     /*  34452 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
     /*  34455 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  34459 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34463 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  34467 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34471 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34475 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34477 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  34481 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  34485 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  34488 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  34493 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  34497 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  34501 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  34503 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  34507 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  34511 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  34515 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  34519 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
     /*  34523 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/3, // MIs[4]
     /*  34527 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  34531 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  34535 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  34539 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  34543 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  34547 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  34551 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  34554 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  34559 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  34563 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  34567 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  34569 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  34573 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  34577 */     // MIs[6] src0
     /*  34577 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  34582 */     // MIs[6] Operand 2
     /*  34582 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(16),
     /*  34593 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
     /*  34597 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  34601 */     // MIs[7] src1
     /*  34601 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  34606 */     // MIs[7] Operand 2
     /*  34606 */     GIM_CheckLiteralInt, /*MI*/7, /*Op*/2, GIMT_Encode8(16),
     /*  34617 */     GIM_CheckIsSafeToFold, /*NumInsns*/7,
     /*  34619 */     // (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i16:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i16:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)  =>  (V_DOT2_I32_I16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  34619 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_I32_I16),
     /*  34622 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  34624 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  34627 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src0
     /*  34631 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  34634 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
     /*  34638 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  34641 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
     /*  34645 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34648 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34651 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34654 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34657 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34660 */     GIR_RootConstrainSelectedInstOperands,
     /*  34661 */     // GIR_Coverage, 9406,
     /*  34661 */     GIR_EraseRootFromParent_Done,
     /*  34662 */   // Label 247: @34662
     /*  34662 */   GIM_Try, /*On fail goto*//*Label 248*/ GIMT_Encode4(34727), // Rule ID 2737 //
     /*  34667 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMadU32Inst),
     /*  34670 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  34674 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34678 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  34682 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34686 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34690 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34692 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:9:x
     /*  34696 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:9:y
     /*  34700 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:9:z
     /*  34704 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24401),
     /*  34708 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  34710 */     // (add:{ *:[i32] } (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:9:x, i32:{ *:[i32] }:$src1:$pred:9:y)<<P:Predicate_anonymous_24402>>, i32:{ *:[i32] }:$src2:$pred:9:z)<<P:9:Predicate_anonymous_24401>>  =>  (V_MAD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  34710 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U32_e64),
     /*  34713 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  34715 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  34719 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  34723 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  34725 */     GIR_RootConstrainSelectedInstOperands,
     /*  34726 */     // GIR_Coverage, 2737,
     /*  34726 */     GIR_EraseRootFromParent_Done,
     /*  34727 */   // Label 248: @34727
     /*  34727 */   GIM_Try, /*On fail goto*//*Label 249*/ GIMT_Encode4(34792), // Rule ID 9342 //
     /*  34732 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMadU32Inst),
     /*  34735 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  34739 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:9:z
     /*  34743 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  34747 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  34751 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34755 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34759 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34761 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:9:x
     /*  34765 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:9:y
     /*  34769 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24401),
     /*  34773 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  34775 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:9:z, (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:9:x, i32:{ *:[i32] }:$src1:$pred:9:y)<<P:Predicate_anonymous_24402>>)<<P:9:Predicate_anonymous_24401>>  =>  (V_MAD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  34775 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U32_e64),
     /*  34778 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  34780 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  34784 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  34788 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  34790 */     GIR_RootConstrainSelectedInstOperands,
     /*  34791 */     // GIR_Coverage, 9342,
     /*  34791 */     GIR_EraseRootFromParent_Done,
     /*  34792 */   // Label 249: @34792
     /*  34792 */   GIM_Try, /*On fail goto*//*Label 250*/ GIMT_Encode4(34845), // Rule ID 8405 //
     /*  34797 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  34801 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34805 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  34809 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34813 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34817 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
     /*  34821 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 255,
     /*  34825 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16636),
     /*  34829 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  34831 */     // (add:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, i32:{ *:[i32] }:$a), -1:{ *:[i32] })<<P:Predicate_anonymous_16636>>  =>  (S_BFM_B32:{ *:[i32] } ?:{ *:[i32] }:$a, 0:{ *:[i32] })
     /*  34831 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_BFM_B32),
     /*  34834 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  34836 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // a
     /*  34840 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34843 */     GIR_RootConstrainSelectedInstOperands,
     /*  34844 */     // GIR_Coverage, 8405,
     /*  34844 */     GIR_EraseRootFromParent_Done,
     /*  34845 */   // Label 250: @34845
     /*  34845 */   GIM_Try, /*On fail goto*//*Label 251*/ GIMT_Encode4(34898), // Rule ID 8407 //
     /*  34850 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  34854 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34858 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  34862 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34866 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34870 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
     /*  34874 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 255,
     /*  34878 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23036),
     /*  34882 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  34884 */     // (add:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, i32:{ *:[i32] }:$a), -1:{ *:[i32] })<<P:Predicate_anonymous_23036>>  =>  (V_BFM_B32_e64:{ *:[i32] } ?:{ *:[i32] }:$a, 0:{ *:[i32] })
     /*  34884 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFM_B32_e64),
     /*  34887 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  34889 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // a
     /*  34893 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34896 */     GIR_RootConstrainSelectedInstOperands,
     /*  34897 */     // GIR_Coverage, 8407,
     /*  34897 */     GIR_EraseRootFromParent_Done,
     /*  34898 */   // Label 251: @34898
     /*  34898 */   GIM_Try, /*On fail goto*//*Label 252*/ GIMT_Encode4(35008), // Rule ID 8180 //
     /*  34903 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  34907 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34911 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /*  34915 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
     /*  34919 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34923 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  34927 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34929 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  34933 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ICMP),
     /*  34937 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  34941 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  34945 */     // MIs[2] Operand 1
     /*  34945 */     GIM_CheckCmpPredicate, /*MI*/2, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_UGT),
     /*  34950 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  34954 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  34958 */     // MIs[3] src0
     /*  34958 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  34963 */     // MIs[3] src1
     /*  34963 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/3,
     /*  34968 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/3, // MIs[4]
     /*  34972 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  34976 */     // MIs[4] src1
     /*  34976 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/3,
     /*  34981 */     // MIs[4] src0
     /*  34981 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  34986 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  34988 */     // (add:{ *:[i32] } (select:{ *:[i32] } (setcc:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, SETUGT:{ *:[Other] }), (sub:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), (sub:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0))<<P:Predicate_select_oneuse>>, i32:{ *:[i32] }:$src2)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  34988 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  34991 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  34993 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src0
     /*  34997 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // src1
     /*  35001 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  35003 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  35006 */     GIR_RootConstrainSelectedInstOperands,
     /*  35007 */     // GIR_Coverage, 8180,
     /*  35007 */     GIR_EraseRootFromParent_Done,
     /*  35008 */   // Label 252: @35008
     /*  35008 */   GIM_Try, /*On fail goto*//*Label 253*/ GIMT_Encode4(35118), // Rule ID 12059 //
     /*  35013 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35017 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  35021 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /*  35025 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
     /*  35029 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35033 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  35037 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35039 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  35043 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ICMP),
     /*  35047 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  35051 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  35055 */     // MIs[2] Operand 1
     /*  35055 */     GIM_CheckCmpPredicate, /*MI*/2, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_UGT),
     /*  35060 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  35064 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  35068 */     // MIs[3] src0
     /*  35068 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  35073 */     // MIs[3] src1
     /*  35073 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/3,
     /*  35078 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/3, // MIs[4]
     /*  35082 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  35086 */     // MIs[4] src1
     /*  35086 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/3,
     /*  35091 */     // MIs[4] src0
     /*  35091 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  35096 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  35098 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (select:{ *:[i32] } (setcc:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, SETUGT:{ *:[Other] }), (sub:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), (sub:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0))<<P:Predicate_select_oneuse>>)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  35098 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  35101 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  35103 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src0
     /*  35107 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // src1
     /*  35111 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  35113 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  35116 */     GIR_RootConstrainSelectedInstOperands,
     /*  35117 */     // GIR_Coverage, 12059,
     /*  35117 */     GIR_EraseRootFromParent_Done,
     /*  35118 */   // Label 253: @35118
     /*  35118 */   GIM_Try, /*On fail goto*//*Label 254*/ GIMT_Encode4(35211), // Rule ID 2727 //
     /*  35123 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  35126 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35130 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35134 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  35138 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35142 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35146 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35148 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
     /*  35152 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  35156 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  35160 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  35164 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  35168 */     GIM_RecordNamedOperand, /*MI*/2, /*Op*/1, /*StoreIdx*/1, // Name : pred:1:y
     /*  35172 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  35176 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  35180 */     // MIs[3] Operand 1
     /*  35180 */     // No operand predicates
     /*  35180 */     GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_csh_mask_32),
     /*  35184 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:1:z
     /*  35188 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24379),
     /*  35192 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  35194 */     // (add:{ *:[i32] } (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:1:x, (and:{ *:[i32] } i32:{ *:[i32] }:$src1:$pred:1:y, (imm:{ *:[i32] }))<<P:Predicate_csh_mask_32>>)<<P:Predicate_anonymous_24380>>, i32:{ *:[i32] }:$src2:$pred:1:z)<<P:1:Predicate_anonymous_24379>>  =>  (V_LSHL_ADD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  35194 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U32_e64),
     /*  35197 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  35199 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  35203 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  35207 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  35209 */     GIR_RootConstrainSelectedInstOperands,
     /*  35210 */     // GIR_Coverage, 2727,
     /*  35210 */     GIR_EraseRootFromParent_Done,
     /*  35211 */   // Label 254: @35211
     /*  35211 */   GIM_Try, /*On fail goto*//*Label 255*/ GIMT_Encode4(35304), // Rule ID 9335 //
     /*  35216 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  35219 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35223 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:1:z
     /*  35227 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  35231 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  35235 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35239 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35243 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35245 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
     /*  35249 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  35253 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  35257 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  35261 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  35265 */     GIM_RecordNamedOperand, /*MI*/2, /*Op*/1, /*StoreIdx*/1, // Name : pred:1:y
     /*  35269 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  35273 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  35277 */     // MIs[3] Operand 1
     /*  35277 */     // No operand predicates
     /*  35277 */     GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_csh_mask_32),
     /*  35281 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24379),
     /*  35285 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  35287 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:1:z, (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:1:x, (and:{ *:[i32] } i32:{ *:[i32] }:$src1:$pred:1:y, (imm:{ *:[i32] }))<<P:Predicate_csh_mask_32>>)<<P:Predicate_anonymous_24380>>)<<P:1:Predicate_anonymous_24379>>  =>  (V_LSHL_ADD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  35287 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U32_e64),
     /*  35290 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  35292 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  35296 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  35300 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  35302 */     GIR_RootConstrainSelectedInstOperands,
     /*  35303 */     // GIR_Coverage, 9335,
     /*  35303 */     GIR_EraseRootFromParent_Done,
     /*  35304 */   // Label 255: @35304
     /*  35304 */   GIM_Try, /*On fail goto*//*Label 256*/ GIMT_Encode4(35359), // Rule ID 8111 //
     /*  35309 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35313 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35317 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  35321 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  35324 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  35329 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35333 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  35337 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35339 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), i32:{ *:[i32] }:$src2)  =>  (V_MAD_I32_I24_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  35339 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_I32_I24_e64),
     /*  35342 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  35344 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
     /*  35348 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
     /*  35352 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  35354 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  35357 */     GIR_RootConstrainSelectedInstOperands,
     /*  35358 */     // GIR_Coverage, 8111,
     /*  35358 */     GIR_EraseRootFromParent_Done,
     /*  35359 */   // Label 256: @35359
     /*  35359 */   GIM_Try, /*On fail goto*//*Label 257*/ GIMT_Encode4(35414), // Rule ID 8113 //
     /*  35364 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35368 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35372 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  35376 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  35379 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  35384 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35388 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  35392 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35394 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), i32:{ *:[i32] }:$src2)  =>  (V_MAD_U32_U24_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  35394 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U32_U24_e64),
     /*  35397 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  35399 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
     /*  35403 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
     /*  35407 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  35409 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  35412 */     GIR_RootConstrainSelectedInstOperands,
     /*  35413 */     // GIR_Coverage, 8113,
     /*  35413 */     GIR_EraseRootFromParent_Done,
     /*  35414 */   // Label 257: @35414
     /*  35414 */   GIM_Try, /*On fail goto*//*Label 258*/ GIMT_Encode4(35479), // Rule ID 82 //
     /*  35419 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  35422 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35426 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35430 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  35434 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35438 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35442 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35444 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35449 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*  35453 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35457 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl1_add),
     /*  35461 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35463 */     // (add:{ *:[i32] } (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 1:{ *:[i32] })<<P:Predicate_shl_oneuse>>, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_shl1_add>>  =>  (S_LSHL1_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  35463 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL1_ADD_U32),
     /*  35466 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  35468 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  35472 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  35474 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  35477 */     GIR_RootConstrainSelectedInstOperands,
     /*  35478 */     // GIR_Coverage, 82,
     /*  35478 */     GIR_EraseRootFromParent_Done,
     /*  35479 */   // Label 258: @35479
     /*  35479 */   GIM_Try, /*On fail goto*//*Label 259*/ GIMT_Encode4(35544), // Rule ID 83 //
     /*  35484 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  35487 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35491 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35495 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  35499 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35503 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35507 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35509 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35514 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
     /*  35518 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35522 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl2_add),
     /*  35526 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35528 */     // (add:{ *:[i32] } (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 2:{ *:[i32] })<<P:Predicate_shl_oneuse>>, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_shl2_add>>  =>  (S_LSHL2_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  35528 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL2_ADD_U32),
     /*  35531 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  35533 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  35537 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  35539 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  35542 */     GIR_RootConstrainSelectedInstOperands,
     /*  35543 */     // GIR_Coverage, 83,
     /*  35543 */     GIR_EraseRootFromParent_Done,
     /*  35544 */   // Label 259: @35544
     /*  35544 */   GIM_Try, /*On fail goto*//*Label 260*/ GIMT_Encode4(35609), // Rule ID 84 //
     /*  35549 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  35552 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35556 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35560 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  35564 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35568 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35572 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35574 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35579 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
     /*  35583 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35587 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl3_add),
     /*  35591 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35593 */     // (add:{ *:[i32] } (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 3:{ *:[i32] })<<P:Predicate_shl_oneuse>>, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_shl3_add>>  =>  (S_LSHL3_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  35593 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL3_ADD_U32),
     /*  35596 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  35598 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  35602 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  35604 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  35607 */     GIR_RootConstrainSelectedInstOperands,
     /*  35608 */     // GIR_Coverage, 84,
     /*  35608 */     GIR_EraseRootFromParent_Done,
     /*  35609 */   // Label 260: @35609
     /*  35609 */   GIM_Try, /*On fail goto*//*Label 261*/ GIMT_Encode4(35674), // Rule ID 85 //
     /*  35614 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  35617 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35621 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35625 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  35629 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35633 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35637 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35639 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35644 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 4,
     /*  35648 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35652 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl4_add),
     /*  35656 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35658 */     // (add:{ *:[i32] } (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 4:{ *:[i32] })<<P:Predicate_shl_oneuse>>, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_shl4_add>>  =>  (S_LSHL4_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  35658 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL4_ADD_U32),
     /*  35661 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  35663 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  35667 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  35669 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  35672 */     GIR_RootConstrainSelectedInstOperands,
     /*  35673 */     // GIR_Coverage, 85,
     /*  35673 */     GIR_EraseRootFromParent_Done,
     /*  35674 */   // Label 261: @35674
     /*  35674 */   GIM_Try, /*On fail goto*//*Label 262*/ GIMT_Encode4(35757), // Rule ID 8179 //
     /*  35679 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35683 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35687 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  35691 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35695 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35699 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35701 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  35705 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
     /*  35709 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  35713 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  35717 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  35721 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
     /*  35725 */     // MIs[3] src0
     /*  35725 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  35730 */     // MIs[3] src1
     /*  35730 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  35735 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  35737 */     // (add:{ *:[i32] } (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), (umin:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))<<P:Predicate_sub_oneuse>>, i32:{ *:[i32] }:$src2)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  35737 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  35740 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  35742 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  35746 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src1
     /*  35750 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  35752 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  35755 */     GIR_RootConstrainSelectedInstOperands,
     /*  35756 */     // GIR_Coverage, 8179,
     /*  35756 */     GIR_EraseRootFromParent_Done,
     /*  35757 */   // Label 262: @35757
     /*  35757 */   GIM_Try, /*On fail goto*//*Label 263*/ GIMT_Encode4(35840), // Rule ID 12052 //
     /*  35762 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35766 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35770 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  35774 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35778 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35782 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35784 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  35788 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
     /*  35792 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  35796 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  35800 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  35804 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
     /*  35808 */     // MIs[3] src1
     /*  35808 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  35813 */     // MIs[3] src0
     /*  35813 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  35818 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  35820 */     // (add:{ *:[i32] } (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), (umin:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0))<<P:Predicate_sub_oneuse>>, i32:{ *:[i32] }:$src2)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  35820 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  35823 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  35825 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  35829 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src1
     /*  35833 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  35835 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  35838 */     GIR_RootConstrainSelectedInstOperands,
     /*  35839 */     // GIR_Coverage, 12052,
     /*  35839 */     GIR_EraseRootFromParent_Done,
     /*  35840 */   // Label 263: @35840
     /*  35840 */   GIM_Try, /*On fail goto*//*Label 264*/ GIMT_Encode4(35923), // Rule ID 12053 //
     /*  35845 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35849 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35853 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  35857 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35861 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35865 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35867 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  35871 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
     /*  35875 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  35879 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  35883 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  35887 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
     /*  35891 */     // MIs[3] src0
     /*  35891 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  35896 */     // MIs[3] src1
     /*  35896 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  35901 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  35903 */     // (add:{ *:[i32] } (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0), (umin:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))<<P:Predicate_sub_oneuse>>, i32:{ *:[i32] }:$src2)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  35903 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  35906 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  35908 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src0
     /*  35912 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  35916 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  35918 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  35921 */     GIR_RootConstrainSelectedInstOperands,
     /*  35922 */     // GIR_Coverage, 12053,
     /*  35922 */     GIR_EraseRootFromParent_Done,
     /*  35923 */   // Label 264: @35923
     /*  35923 */   GIM_Try, /*On fail goto*//*Label 265*/ GIMT_Encode4(36006), // Rule ID 12054 //
     /*  35928 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35932 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35936 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  35940 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35944 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35948 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35950 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  35954 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
     /*  35958 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  35962 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  35966 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  35970 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
     /*  35974 */     // MIs[3] src1
     /*  35974 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  35979 */     // MIs[3] src0
     /*  35979 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  35984 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  35986 */     // (add:{ *:[i32] } (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0), (umin:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0))<<P:Predicate_sub_oneuse>>, i32:{ *:[i32] }:$src2)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  35986 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  35989 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  35991 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src0
     /*  35995 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  35999 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  36001 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  36004 */     GIR_RootConstrainSelectedInstOperands,
     /*  36005 */     // GIR_Coverage, 12054,
     /*  36005 */     GIR_EraseRootFromParent_Done,
     /*  36006 */   // Label 265: @36006
     /*  36006 */   GIM_Try, /*On fail goto*//*Label 266*/ GIMT_Encode4(36071), // Rule ID 9248 //
     /*  36011 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  36014 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  36018 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  36022 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36026 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  36030 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36034 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36038 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36040 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  36045 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*  36049 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl1_add),
     /*  36053 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36055 */     // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src1, (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 1:{ *:[i32] })<<P:Predicate_shl_oneuse>>)<<P:Predicate_shl1_add>>  =>  (S_LSHL1_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  36055 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL1_ADD_U32),
     /*  36058 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  36060 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  36064 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  36066 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  36069 */     GIR_RootConstrainSelectedInstOperands,
     /*  36070 */     // GIR_Coverage, 9248,
     /*  36070 */     GIR_EraseRootFromParent_Done,
     /*  36071 */   // Label 266: @36071
     /*  36071 */   GIM_Try, /*On fail goto*//*Label 267*/ GIMT_Encode4(36136), // Rule ID 9249 //
     /*  36076 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  36079 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  36083 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  36087 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36091 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  36095 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36099 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36103 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36105 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  36110 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
     /*  36114 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl2_add),
     /*  36118 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36120 */     // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src1, (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 2:{ *:[i32] })<<P:Predicate_shl_oneuse>>)<<P:Predicate_shl2_add>>  =>  (S_LSHL2_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  36120 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL2_ADD_U32),
     /*  36123 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  36125 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  36129 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  36131 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  36134 */     GIR_RootConstrainSelectedInstOperands,
     /*  36135 */     // GIR_Coverage, 9249,
     /*  36135 */     GIR_EraseRootFromParent_Done,
     /*  36136 */   // Label 267: @36136
     /*  36136 */   GIM_Try, /*On fail goto*//*Label 268*/ GIMT_Encode4(36201), // Rule ID 9250 //
     /*  36141 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  36144 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  36148 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  36152 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36156 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  36160 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36164 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36168 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36170 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  36175 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
     /*  36179 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl3_add),
     /*  36183 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36185 */     // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src1, (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 3:{ *:[i32] })<<P:Predicate_shl_oneuse>>)<<P:Predicate_shl3_add>>  =>  (S_LSHL3_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  36185 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL3_ADD_U32),
     /*  36188 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  36190 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  36194 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  36196 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  36199 */     GIR_RootConstrainSelectedInstOperands,
     /*  36200 */     // GIR_Coverage, 9250,
     /*  36200 */     GIR_EraseRootFromParent_Done,
     /*  36201 */   // Label 268: @36201
     /*  36201 */   GIM_Try, /*On fail goto*//*Label 269*/ GIMT_Encode4(36266), // Rule ID 9251 //
     /*  36206 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  36209 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  36213 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  36217 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36221 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  36225 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36229 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36233 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36235 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  36240 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 4,
     /*  36244 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl4_add),
     /*  36248 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36250 */     // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src1, (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 4:{ *:[i32] })<<P:Predicate_shl_oneuse>>)<<P:Predicate_shl4_add>>  =>  (S_LSHL4_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  36250 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL4_ADD_U32),
     /*  36253 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  36255 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  36259 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  36261 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  36264 */     GIR_RootConstrainSelectedInstOperands,
     /*  36265 */     // GIR_Coverage, 9251,
     /*  36265 */     GIR_EraseRootFromParent_Done,
     /*  36266 */   // Label 269: @36266
     /*  36266 */   GIM_Try, /*On fail goto*//*Label 270*/ GIMT_Encode4(36321), // Rule ID 12008 //
     /*  36271 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36275 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36279 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  36283 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  36286 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  36291 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36295 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  36299 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36301 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3287:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))  =>  (V_MAD_I32_I24_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  36301 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_I32_I24_e64),
     /*  36304 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  36306 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
     /*  36310 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
     /*  36314 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  36316 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  36319 */     GIR_RootConstrainSelectedInstOperands,
     /*  36320 */     // GIR_Coverage, 12008,
     /*  36320 */     GIR_EraseRootFromParent_Done,
     /*  36321 */   // Label 270: @36321
     /*  36321 */   GIM_Try, /*On fail goto*//*Label 271*/ GIMT_Encode4(36376), // Rule ID 12010 //
     /*  36326 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36330 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36334 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  36338 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  36341 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  36346 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36350 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  36354 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36356 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3288:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))  =>  (V_MAD_U32_U24_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  36356 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U32_U24_e64),
     /*  36359 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  36361 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
     /*  36365 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
     /*  36369 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  36371 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  36374 */     GIR_RootConstrainSelectedInstOperands,
     /*  36375 */     // GIR_Coverage, 12010,
     /*  36375 */     GIR_EraseRootFromParent_Done,
     /*  36376 */   // Label 271: @36376
     /*  36376 */   GIM_Try, /*On fail goto*//*Label 272*/ GIMT_Encode4(36459), // Rule ID 12055 //
     /*  36381 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36385 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36389 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  36393 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36397 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36401 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36403 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  36407 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
     /*  36411 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  36415 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  36419 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  36423 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
     /*  36427 */     // MIs[3] src0
     /*  36427 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  36432 */     // MIs[3] src1
     /*  36432 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  36437 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  36439 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), (umin:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))<<P:Predicate_sub_oneuse>>)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  36439 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  36442 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  36444 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  36448 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src1
     /*  36452 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  36454 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  36457 */     GIR_RootConstrainSelectedInstOperands,
     /*  36458 */     // GIR_Coverage, 12055,
     /*  36458 */     GIR_EraseRootFromParent_Done,
     /*  36459 */   // Label 272: @36459
     /*  36459 */   GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(36542), // Rule ID 12056 //
     /*  36464 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36468 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36472 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  36476 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36480 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36484 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36486 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  36490 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
     /*  36494 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  36498 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  36502 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  36506 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
     /*  36510 */     // MIs[3] src1
     /*  36510 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  36515 */     // MIs[3] src0
     /*  36515 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  36520 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  36522 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), (umin:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0))<<P:Predicate_sub_oneuse>>)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  36522 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  36525 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  36527 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  36531 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src1
     /*  36535 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  36537 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  36540 */     GIR_RootConstrainSelectedInstOperands,
     /*  36541 */     // GIR_Coverage, 12056,
     /*  36541 */     GIR_EraseRootFromParent_Done,
     /*  36542 */   // Label 273: @36542
     /*  36542 */   GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(36625), // Rule ID 12057 //
     /*  36547 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36551 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36555 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  36559 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36563 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36567 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36569 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  36573 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
     /*  36577 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  36581 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  36585 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  36589 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
     /*  36593 */     // MIs[3] src0
     /*  36593 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  36598 */     // MIs[3] src1
     /*  36598 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  36603 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  36605 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0), (umin:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))<<P:Predicate_sub_oneuse>>)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  36605 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  36608 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  36610 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src0
     /*  36614 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  36618 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  36620 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  36623 */     GIR_RootConstrainSelectedInstOperands,
     /*  36624 */     // GIR_Coverage, 12057,
     /*  36624 */     GIR_EraseRootFromParent_Done,
     /*  36625 */   // Label 274: @36625
     /*  36625 */   GIM_Try, /*On fail goto*//*Label 275*/ GIMT_Encode4(36708), // Rule ID 12058 //
     /*  36630 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36634 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36638 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  36642 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36646 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36650 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36652 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  36656 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
     /*  36660 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  36664 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  36668 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  36672 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
     /*  36676 */     // MIs[3] src1
     /*  36676 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  36681 */     // MIs[3] src0
     /*  36681 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  36686 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  36688 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0), (umin:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0))<<P:Predicate_sub_oneuse>>)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  36688 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  36691 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  36693 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src0
     /*  36697 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  36701 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  36703 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  36706 */     GIR_RootConstrainSelectedInstOperands,
     /*  36707 */     // GIR_Coverage, 12058,
     /*  36707 */     GIR_EraseRootFromParent_Done,
     /*  36708 */   // Label 275: @36708
     /*  36708 */   GIM_Try, /*On fail goto*//*Label 276*/ GIMT_Encode4(36873), // Rule ID 9350 //
     /*  36713 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
     /*  36716 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36720 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:17:z
     /*  36724 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36728 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36732 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  36736 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36740 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36744 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36746 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:17:x
     /*  36750 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:17:y
     /*  36754 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24401),
     /*  36758 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36760 */     // (add:{ *:[i32] } VGPR_32:{ *:[i32] }:$src2:$pred:17:z, (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:17:x, i32:{ *:[i32] }:$src1:$pred:17:y)<<P:Predicate_anonymous_24402>>)<<P:17:Predicate_anonymous_24401>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
     /*  36760 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /*  36763 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  36767 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  36772 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  36774 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*  36777 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  36781 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  36786 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src2
     /*  36790 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
     /*  36793 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
     /*  36796 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
     /*  36799 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  36804 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36809 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36814 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
     /*  36817 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  36820 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
     /*  36824 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  36829 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  36834 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  36838 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  36842 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  36845 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  36848 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  36850 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  36853 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  36855 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
     /*  36862 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36867 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  36872 */     // GIR_Coverage, 9350,
     /*  36872 */     GIR_EraseRootFromParent_Done,
     /*  36873 */   // Label 276: @36873
     /*  36873 */   GIM_Try, /*On fail goto*//*Label 277*/ GIMT_Encode4(37038), // Rule ID 9354 //
     /*  36878 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
     /*  36881 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36885 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:20:z
     /*  36889 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36893 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36897 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  36901 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36905 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36909 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36911 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:20:x
     /*  36915 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:20:y
     /*  36919 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24401),
     /*  36923 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36925 */     // (add:{ *:[i32] } VGPR_32:{ *:[i32] }:$src2:$pred:20:z, (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:20:x, i32:{ *:[i32] }:$src1:$pred:20:y)<<P:Predicate_anonymous_24402>>)<<P:20:Predicate_anonymous_24401>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
     /*  36925 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /*  36928 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  36932 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  36937 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  36939 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*  36942 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  36946 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  36951 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src2
     /*  36955 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
     /*  36958 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
     /*  36961 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
     /*  36964 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  36969 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36974 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36979 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
     /*  36982 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  36985 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
     /*  36989 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  36994 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  36999 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  37003 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  37007 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  37010 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  37013 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  37015 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  37018 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  37020 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
     /*  37027 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37032 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  37037 */     // GIR_Coverage, 9354,
     /*  37037 */     GIR_EraseRootFromParent_Done,
     /*  37038 */   // Label 277: @37038
     /*  37038 */   GIM_Try, /*On fail goto*//*Label 278*/ GIMT_Encode4(37103), // Rule ID 2730 //
     /*  37043 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  37046 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37050 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  37054 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  37058 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  37062 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  37066 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  37068 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:3:x
     /*  37072 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:3:y
     /*  37076 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:3:z
     /*  37080 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24385),
     /*  37084 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37086 */     // (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:3:x, i32:{ *:[i32] }:$src1:$pred:3:y)<<P:Predicate_anonymous_24383>>, i32:{ *:[i32] }:$src2:$pred:3:z)<<P:3:Predicate_anonymous_24385>>  =>  (V_ADD3_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  37086 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD3_U32_e64),
     /*  37089 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37091 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  37095 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  37099 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  37101 */     GIR_RootConstrainSelectedInstOperands,
     /*  37102 */     // GIR_Coverage, 2730,
     /*  37102 */     GIR_EraseRootFromParent_Done,
     /*  37103 */   // Label 278: @37103
     /*  37103 */   GIM_Try, /*On fail goto*//*Label 279*/ GIMT_Encode4(37268), // Rule ID 2756 //
     /*  37108 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
     /*  37111 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37115 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  37119 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  37123 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  37127 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  37131 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  37133 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:17:x
     /*  37137 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:17:y
     /*  37141 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:17:z
     /*  37145 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37149 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24401),
     /*  37153 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37155 */     // (add:{ *:[i32] } (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:17:x, i32:{ *:[i32] }:$src1:$pred:17:y)<<P:Predicate_anonymous_24402>>, VGPR_32:{ *:[i32] }:$src2:$pred:17:z)<<P:17:Predicate_anonymous_24401>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
     /*  37155 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /*  37158 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  37162 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  37167 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  37169 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*  37172 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  37176 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  37181 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  37185 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
     /*  37188 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
     /*  37191 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
     /*  37194 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  37199 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37204 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37209 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
     /*  37212 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  37215 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
     /*  37219 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  37224 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  37229 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  37233 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  37237 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  37240 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  37243 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  37245 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  37248 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  37250 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
     /*  37257 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37262 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  37267 */     // GIR_Coverage, 2756,
     /*  37267 */     GIR_EraseRootFromParent_Done,
     /*  37268 */   // Label 279: @37268
     /*  37268 */   GIM_Try, /*On fail goto*//*Label 280*/ GIMT_Encode4(37433), // Rule ID 2765 //
     /*  37273 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
     /*  37276 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37280 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  37284 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  37288 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  37292 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  37296 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  37298 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:20:x
     /*  37302 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:20:y
     /*  37306 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:20:z
     /*  37310 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37314 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24401),
     /*  37318 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37320 */     // (add:{ *:[i32] } (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:20:x, i32:{ *:[i32] }:$src1:$pred:20:y)<<P:Predicate_anonymous_24402>>, VGPR_32:{ *:[i32] }:$src2:$pred:20:z)<<P:20:Predicate_anonymous_24401>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
     /*  37320 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /*  37323 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  37327 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  37332 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  37334 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*  37337 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  37341 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  37346 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  37350 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
     /*  37353 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
     /*  37356 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
     /*  37359 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  37364 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37369 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37374 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
     /*  37377 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  37380 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
     /*  37384 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  37389 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  37394 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  37398 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  37402 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  37405 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  37408 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  37410 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  37413 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  37415 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
     /*  37422 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37427 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  37432 */     // GIR_Coverage, 2765,
     /*  37432 */     GIR_EraseRootFromParent_Done,
     /*  37433 */   // Label 280: @37433
     /*  37433 */   GIM_Try, /*On fail goto*//*Label 281*/ GIMT_Encode4(37594), // Rule ID 2755 //
     /*  37438 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
     /*  37441 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37445 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  37449 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  37453 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  37457 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  37461 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  37463 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:16:x
     /*  37467 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:16:y
     /*  37471 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:16:z
     /*  37475 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24401),
     /*  37479 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37481 */     // (add:{ *:[i32] } (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:16:x, i32:{ *:[i32] }:$src1:$pred:16:y)<<P:Predicate_anonymous_24402>>, i32:{ *:[i32] }:$src2:$pred:16:z)<<P:16:Predicate_anonymous_24401>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } SReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
     /*  37481 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /*  37484 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  37488 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  37493 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  37495 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*  37498 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  37502 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  37507 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  37511 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
     /*  37514 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
     /*  37517 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
     /*  37520 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  37525 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::SReg_32_XEXEC_HI_and_SReg_32_XM0RegClassID),
     /*  37530 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::SReg_32_XM0RegClassID),
     /*  37535 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
     /*  37538 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  37541 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
     /*  37545 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  37550 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  37555 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  37559 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  37563 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  37566 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  37569 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  37571 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  37574 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  37576 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
     /*  37583 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37588 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  37593 */     // GIR_Coverage, 2755,
     /*  37593 */     GIR_EraseRootFromParent_Done,
     /*  37594 */   // Label 281: @37594
     /*  37594 */   GIM_Try, /*On fail goto*//*Label 282*/ GIMT_Encode4(37755), // Rule ID 2764 //
     /*  37599 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
     /*  37602 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37606 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  37610 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  37614 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  37618 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  37622 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  37624 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:19:x
     /*  37628 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:19:y
     /*  37632 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:19:z
     /*  37636 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24401),
     /*  37640 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37642 */     // (add:{ *:[i32] } (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:19:x, i32:{ *:[i32] }:$src1:$pred:19:y)<<P:Predicate_anonymous_24402>>, i32:{ *:[i32] }:$src2:$pred:19:z)<<P:19:Predicate_anonymous_24401>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } SReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
     /*  37642 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /*  37645 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  37649 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  37654 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  37656 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*  37659 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  37663 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  37668 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  37672 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
     /*  37675 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
     /*  37678 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
     /*  37681 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  37686 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::SReg_32_XEXEC_HI_and_SReg_32_XM0RegClassID),
     /*  37691 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::SReg_32_XM0RegClassID),
     /*  37696 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
     /*  37699 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  37702 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
     /*  37706 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  37711 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  37716 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  37720 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  37724 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  37727 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  37730 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  37732 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  37735 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  37737 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
     /*  37744 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37749 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  37754 */     // GIR_Coverage, 2764,
     /*  37754 */     GIR_EraseRootFromParent_Done,
     /*  37755 */   // Label 282: @37755
     /*  37755 */   GIM_Try, /*On fail goto*//*Label 283*/ GIMT_Encode4(37820), // Rule ID 2726 //
     /*  37760 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  37763 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37767 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  37771 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  37775 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  37779 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  37783 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  37785 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
     /*  37789 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:1:y
     /*  37793 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:1:z
     /*  37797 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24379),
     /*  37801 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37803 */     // (add:{ *:[i32] } (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:1:x, i32:{ *:[i32] }:$src1:$pred:1:y)<<P:Predicate_anonymous_24380>>, i32:{ *:[i32] }:$src2:$pred:1:z)<<P:1:Predicate_anonymous_24379>>  =>  (V_LSHL_ADD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  37803 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U32_e64),
     /*  37806 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37808 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  37812 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  37816 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  37818 */     GIR_RootConstrainSelectedInstOperands,
     /*  37819 */     // GIR_Coverage, 2726,
     /*  37819 */     GIR_EraseRootFromParent_Done,
     /*  37820 */   // Label 283: @37820
     /*  37820 */   GIM_Try, /*On fail goto*//*Label 284*/ GIMT_Encode4(37885), // Rule ID 2736 //
     /*  37825 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  37828 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37832 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  37836 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  37840 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  37844 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  37848 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  37850 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:8:x
     /*  37854 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:8:y
     /*  37858 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:8:z
     /*  37862 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24398),
     /*  37866 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37868 */     // (add:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:8:x, i32:{ *:[i32] }:$src1:$pred:8:y)<<P:Predicate_anonymous_24399>>, i32:{ *:[i32] }:$src2:$pred:8:z)<<P:8:Predicate_anonymous_24398>>  =>  (V_XAD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  37868 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_XAD_U32_e64),
     /*  37871 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37873 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  37877 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  37881 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  37883 */     GIR_RootConstrainSelectedInstOperands,
     /*  37884 */     // GIR_Coverage, 2736,
     /*  37884 */     GIR_EraseRootFromParent_Done,
     /*  37885 */   // Label 284: @37885
     /*  37885 */   GIM_Try, /*On fail goto*//*Label 285*/ GIMT_Encode4(37925), // Rule ID 7670 //
     /*  37890 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37894 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  37898 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CTPOP),
     /*  37902 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  37906 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_40326),
     /*  37910 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37912 */     // (add:{ *:[i32] } (ctpop:{ *:[i32] } i32:{ *:[i32] }:$popcnt)<<P:Predicate_anonymous_40326>>, i32:{ *:[i32] }:$val)  =>  (V_BCNT_U32_B32_e64:{ *:[i32] } ?:{ *:[i32] }:$popcnt, ?:{ *:[i32] }:$val)
     /*  37912 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BCNT_U32_B32_e64),
     /*  37915 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37917 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // popcnt
     /*  37921 */     GIR_RootToRootCopy, /*OpIdx*/2, // val
     /*  37923 */     GIR_RootConstrainSelectedInstOperands,
     /*  37924 */     // GIR_Coverage, 7670,
     /*  37924 */     GIR_EraseRootFromParent_Done,
     /*  37925 */   // Label 285: @37925
     /*  37925 */   GIM_Try, /*On fail goto*//*Label 286*/ GIMT_Encode4(37990), // Rule ID 9336 //
     /*  37930 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  37933 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37937 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:3:z
     /*  37941 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  37945 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  37949 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  37953 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  37957 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  37959 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:3:x
     /*  37963 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:3:y
     /*  37967 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24385),
     /*  37971 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37973 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:3:z, (add:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:3:x, i32:{ *:[i32] }:$src1:$pred:3:y)<<P:Predicate_anonymous_24383>>)<<P:3:Predicate_anonymous_24385>>  =>  (V_ADD3_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  37973 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD3_U32_e64),
     /*  37976 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37978 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  37982 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  37986 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  37988 */     GIR_RootConstrainSelectedInstOperands,
     /*  37989 */     // GIR_Coverage, 9336,
     /*  37989 */     GIR_EraseRootFromParent_Done,
     /*  37990 */   // Label 286: @37990
     /*  37990 */   GIM_Try, /*On fail goto*//*Label 287*/ GIMT_Encode4(38151), // Rule ID 9349 //
     /*  37995 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
     /*  37998 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38002 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:16:z
     /*  38006 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  38010 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  38014 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  38018 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  38022 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  38024 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:16:x
     /*  38028 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:16:y
     /*  38032 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24401),
     /*  38036 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  38038 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:16:z, (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:16:x, i32:{ *:[i32] }:$src1:$pred:16:y)<<P:Predicate_anonymous_24402>>)<<P:16:Predicate_anonymous_24401>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } SReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
     /*  38038 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /*  38041 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  38045 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  38050 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  38052 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*  38055 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  38059 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  38064 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src2
     /*  38068 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
     /*  38071 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
     /*  38074 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
     /*  38077 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  38082 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::SReg_32_XEXEC_HI_and_SReg_32_XM0RegClassID),
     /*  38087 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::SReg_32_XM0RegClassID),
     /*  38092 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
     /*  38095 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  38098 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
     /*  38102 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  38107 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  38112 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  38116 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  38120 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  38123 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  38126 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  38128 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  38131 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  38133 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
     /*  38140 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38145 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  38150 */     // GIR_Coverage, 9349,
     /*  38150 */     GIR_EraseRootFromParent_Done,
     /*  38151 */   // Label 287: @38151
     /*  38151 */   GIM_Try, /*On fail goto*//*Label 288*/ GIMT_Encode4(38312), // Rule ID 9353 //
     /*  38156 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
     /*  38159 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38163 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:19:z
     /*  38167 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  38171 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  38175 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  38179 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  38183 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  38185 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:19:x
     /*  38189 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:19:y
     /*  38193 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24401),
     /*  38197 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  38199 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:19:z, (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:19:x, i32:{ *:[i32] }:$src1:$pred:19:y)<<P:Predicate_anonymous_24402>>)<<P:19:Predicate_anonymous_24401>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } SReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
     /*  38199 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /*  38202 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  38206 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  38211 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  38213 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*  38216 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  38220 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  38225 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src2
     /*  38229 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
     /*  38232 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
     /*  38235 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
     /*  38238 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  38243 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::SReg_32_XEXEC_HI_and_SReg_32_XM0RegClassID),
     /*  38248 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::SReg_32_XM0RegClassID),
     /*  38253 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
     /*  38256 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  38259 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
     /*  38263 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  38268 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  38273 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  38277 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  38281 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  38284 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  38287 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  38289 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  38292 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  38294 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
     /*  38301 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38306 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  38311 */     // GIR_Coverage, 9353,
     /*  38311 */     GIR_EraseRootFromParent_Done,
     /*  38312 */   // Label 288: @38312
     /*  38312 */   GIM_Try, /*On fail goto*//*Label 289*/ GIMT_Encode4(38377), // Rule ID 9334 //
     /*  38317 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  38320 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38324 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:1:z
     /*  38328 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  38332 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  38336 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  38340 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  38344 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  38346 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
     /*  38350 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:1:y
     /*  38354 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24379),
     /*  38358 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  38360 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:1:z, (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:1:x, i32:{ *:[i32] }:$src1:$pred:1:y)<<P:Predicate_anonymous_24380>>)<<P:1:Predicate_anonymous_24379>>  =>  (V_LSHL_ADD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  38360 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U32_e64),
     /*  38363 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38365 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  38369 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  38373 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  38375 */     GIR_RootConstrainSelectedInstOperands,
     /*  38376 */     // GIR_Coverage, 9334,
     /*  38376 */     GIR_EraseRootFromParent_Done,
     /*  38377 */   // Label 289: @38377
     /*  38377 */   GIM_Try, /*On fail goto*//*Label 290*/ GIMT_Encode4(38442), // Rule ID 9341 //
     /*  38382 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  38385 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38389 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:8:z
     /*  38393 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  38397 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  38401 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  38405 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  38409 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  38411 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:8:x
     /*  38415 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:8:y
     /*  38419 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24398),
     /*  38423 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  38425 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:8:z, (xor:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:8:x, i32:{ *:[i32] }:$src1:$pred:8:y)<<P:Predicate_anonymous_24399>>)<<P:8:Predicate_anonymous_24398>>  =>  (V_XAD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  38425 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_XAD_U32_e64),
     /*  38428 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38430 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  38434 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  38438 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  38440 */     GIR_RootConstrainSelectedInstOperands,
     /*  38441 */     // GIR_Coverage, 9341,
     /*  38441 */     GIR_EraseRootFromParent_Done,
     /*  38442 */   // Label 290: @38442
     /*  38442 */   GIM_Try, /*On fail goto*//*Label 291*/ GIMT_Encode4(38482), // Rule ID 12006 //
     /*  38447 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38451 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  38455 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CTPOP),
     /*  38459 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  38463 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_40326),
     /*  38467 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  38469 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$val, (ctpop:{ *:[i32] } i32:{ *:[i32] }:$popcnt)<<P:Predicate_anonymous_40326>>)  =>  (V_BCNT_U32_B32_e64:{ *:[i32] } ?:{ *:[i32] }:$popcnt, ?:{ *:[i32] }:$val)
     /*  38469 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BCNT_U32_B32_e64),
     /*  38472 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38474 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // popcnt
     /*  38478 */     GIR_RootToRootCopy, /*OpIdx*/1, // val
     /*  38480 */     GIR_RootConstrainSelectedInstOperands,
     /*  38481 */     // GIR_Coverage, 12006,
     /*  38481 */     GIR_EraseRootFromParent_Done,
     /*  38482 */   // Label 291: @38482
     /*  38482 */   GIM_Try, /*On fail goto*//*Label 292*/ GIMT_Encode4(38526), // Rule ID 8400 //
     /*  38487 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  38491 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  38495 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  38499 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineConst32),
     /*  38503 */     // MIs[1] Operand 1
     /*  38503 */     // No operand predicates
     /*  38503 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16636),
     /*  38507 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  38509 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>><<X:NegateImm>>:$src1)<<P:Predicate_anonymous_16636>>  =>  (S_SUB_I32:{ *:[i32] }:{ *:[i1] } SReg_32:{ *:[i32] }:$src0, (NegateImm:{ *:[i1 i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>>:$src1))
     /*  38509 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_SUB_I32),
     /*  38512 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  38514 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  38516 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
     /*  38521 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  38524 */     GIR_RootConstrainSelectedInstOperands,
     /*  38525 */     // GIR_Coverage, 8400,
     /*  38525 */     GIR_EraseRootFromParent_Done,
     /*  38526 */   // Label 292: @38526
     /*  38526 */   GIM_Try, /*On fail goto*//*Label 293*/ GIMT_Encode4(38573), // Rule ID 8401 //
     /*  38531 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAddNoCarryInsts),
     /*  38534 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38538 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  38542 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  38546 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineConst32),
     /*  38550 */     // MIs[1] Operand 1
     /*  38550 */     // No operand predicates
     /*  38550 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23036),
     /*  38554 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  38556 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>><<X:NegateImm>>:$src1)<<P:Predicate_anonymous_23036>>  =>  (V_SUB_U32_e64:{ *:[i32] } VS_32:{ *:[i32] }:$src0, (NegateImm:{ *:[i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>>:$src1))
     /*  38556 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_U32_e64),
     /*  38559 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38561 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  38563 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
     /*  38568 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38571 */     GIR_RootConstrainSelectedInstOperands,
     /*  38572 */     // GIR_Coverage, 8401,
     /*  38572 */     GIR_EraseRootFromParent_Done,
     /*  38573 */   // Label 293: @38573
     /*  38573 */   GIM_Try, /*On fail goto*//*Label 294*/ GIMT_Encode4(38628), // Rule ID 8402 //
     /*  38578 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotHasAddNoCarryInsts),
     /*  38581 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38585 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  38589 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  38593 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineConst32),
     /*  38597 */     // MIs[1] Operand 1
     /*  38597 */     // No operand predicates
     /*  38597 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23036),
     /*  38601 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  38603 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>><<X:NegateImm>>:$src1)<<P:Predicate_anonymous_23036>>  =>  (V_SUB_CO_U32_e64:{ *:[i32] }:{ *:[i1] } VS_32:{ *:[i32] }:$src0, (NegateImm:{ *:[i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>>:$src1))
     /*  38603 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
     /*  38606 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_CO_U32_e64),
     /*  38609 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38611 */     GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  38616 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  38618 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
     /*  38623 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38626 */     GIR_RootConstrainSelectedInstOperands,
     /*  38627 */     // GIR_Coverage, 8402,
     /*  38627 */     GIR_EraseRootFromParent_Done,
     /*  38628 */   // Label 294: @38628
     /*  38628 */   GIM_Try, /*On fail goto*//*Label 295*/ GIMT_Encode4(38662), // Rule ID 43 //
     /*  38633 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  38637 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  38641 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  38645 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16636),
     /*  38649 */     // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_16636>>  =>  (S_ADD_I32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  38649 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_ADD_I32),
     /*  38654 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  38660 */     GIR_RootConstrainSelectedInstOperands,
     /*  38661 */     // GIR_Coverage, 43,
     /*  38661 */     GIR_Done,
     /*  38662 */   // Label 295: @38662
     /*  38662 */   GIM_Try, /*On fail goto*//*Label 296*/ GIMT_Encode4(38692), // Rule ID 2603 //
     /*  38667 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAddNoCarryInsts),
     /*  38670 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38674 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23036),
     /*  38678 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_23036>>  =>  (V_ADD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, 0:{ *:[i1] })
     /*  38678 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_U32_e64),
     /*  38681 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38683 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  38685 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  38687 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38690 */     GIR_RootConstrainSelectedInstOperands,
     /*  38691 */     // GIR_Coverage, 2603,
     /*  38691 */     GIR_EraseRootFromParent_Done,
     /*  38692 */   // Label 296: @38692
     /*  38692 */   GIM_Try, /*On fail goto*//*Label 297*/ GIMT_Encode4(38730), // Rule ID 2605 //
     /*  38697 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX6GFX7GFX8GFX9),
     /*  38700 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38704 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23036),
     /*  38708 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_23036>>  =>  (V_ADD_CO_U32_e64:{ *:[i32] }:{ *:[i1] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, 0:{ *:[i1] })
     /*  38708 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
     /*  38711 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_CO_U32_e64),
     /*  38714 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38716 */     GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  38721 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  38723 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  38725 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38728 */     GIR_RootConstrainSelectedInstOperands,
     /*  38729 */     // GIR_Coverage, 2605,
     /*  38729 */     GIR_EraseRootFromParent_Done,
     /*  38730 */   // Label 297: @38730
     /*  38730 */   GIM_Try, /*On fail goto*//*Label 298*/ GIMT_Encode4(38766), // Rule ID 841 //
     /*  38735 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38739 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  38743 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CTPOP),
     /*  38747 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  38751 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  38753 */     // (add:{ *:[i32] } (ctpop:{ *:[i32] } i32:{ *:[i32] }:$src0), i32:{ *:[i32] }:$src1)  =>  (V_BCNT_U32_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  38753 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BCNT_U32_B32_e64),
     /*  38756 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38758 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  38762 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  38764 */     GIR_RootConstrainSelectedInstOperands,
     /*  38765 */     // GIR_Coverage, 841,
     /*  38765 */     GIR_EraseRootFromParent_Done,
     /*  38766 */   // Label 298: @38766
     /*  38766 */   GIM_Try, /*On fail goto*//*Label 299*/ GIMT_Encode4(38802), // Rule ID 9263 //
     /*  38771 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38775 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  38779 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CTPOP),
     /*  38783 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  38787 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  38789 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src1, (ctpop:{ *:[i32] } i32:{ *:[i32] }:$src0))  =>  (V_BCNT_U32_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  38789 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BCNT_U32_B32_e64),
     /*  38792 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38794 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  38798 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  38800 */     GIR_RootConstrainSelectedInstOperands,
     /*  38801 */     // GIR_Coverage, 9263,
     /*  38801 */     GIR_EraseRootFromParent_Done,
     /*  38802 */   // Label 299: @38802
     /*  38802 */   GIM_Reject,
     /*  38803 */ // Label 207: @38803
     /*  38803 */ GIM_Reject,
     /*  38804 */ // Label 180: @38804
     /*  38804 */ GIM_Try, /*On fail goto*//*Label 300*/ GIMT_Encode4(39274),
     /*  38809 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  38812 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  38815 */   GIM_Try, /*On fail goto*//*Label 301*/ GIMT_Encode4(38881), // Rule ID 2758 //
     /*  38820 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
     /*  38823 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  38827 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  38831 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  38835 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  38838 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  38843 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  38847 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  38851 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  38853 */     // (add:{ *:[i64] } (intrinsic_wo_chain:{ *:[i64] } 3288:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), i64:{ *:[i64] }:$src2)  =>  (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i64] }:$src2, 0:{ *:[i1] })
     /*  38853 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
     /*  38856 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
     /*  38859 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38861 */     GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  38866 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
     /*  38870 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
     /*  38874 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  38876 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38879 */     GIR_RootConstrainSelectedInstOperands,
     /*  38880 */     // GIR_Coverage, 2758,
     /*  38880 */     GIR_EraseRootFromParent_Done,
     /*  38881 */   // Label 301: @38881
     /*  38881 */   GIM_Try, /*On fail goto*//*Label 302*/ GIMT_Encode4(38947), // Rule ID 2767 //
     /*  38886 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
     /*  38889 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  38893 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  38897 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  38901 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  38904 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  38909 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  38913 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  38917 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  38919 */     // (add:{ *:[i64] } (intrinsic_wo_chain:{ *:[i64] } 3288:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), i64:{ *:[i64] }:$src2)  =>  (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i64] }:$src2, 0:{ *:[i1] })
     /*  38919 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
     /*  38922 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
     /*  38925 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38927 */     GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  38932 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
     /*  38936 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
     /*  38940 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  38942 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38945 */     GIR_RootConstrainSelectedInstOperands,
     /*  38946 */     // GIR_Coverage, 2767,
     /*  38946 */     GIR_EraseRootFromParent_Done,
     /*  38947 */   // Label 302: @38947
     /*  38947 */   GIM_Try, /*On fail goto*//*Label 303*/ GIMT_Encode4(39013), // Rule ID 9351 //
     /*  38952 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
     /*  38955 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  38959 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  38963 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  38967 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  38970 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  38975 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  38979 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  38983 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  38985 */     // (add:{ *:[i64] } i64:{ *:[i64] }:$src2, (intrinsic_wo_chain:{ *:[i64] } 3288:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))  =>  (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i64] }:$src2, 0:{ *:[i1] })
     /*  38985 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
     /*  38988 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
     /*  38991 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38993 */     GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  38998 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
     /*  39002 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
     /*  39006 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  39008 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39011 */     GIR_RootConstrainSelectedInstOperands,
     /*  39012 */     // GIR_Coverage, 9351,
     /*  39012 */     GIR_EraseRootFromParent_Done,
     /*  39013 */   // Label 303: @39013
     /*  39013 */   GIM_Try, /*On fail goto*//*Label 304*/ GIMT_Encode4(39079), // Rule ID 9355 //
     /*  39018 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
     /*  39021 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  39025 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  39029 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  39033 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  39036 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  39041 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  39045 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  39049 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  39051 */     // (add:{ *:[i64] } i64:{ *:[i64] }:$src2, (intrinsic_wo_chain:{ *:[i64] } 3288:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))  =>  (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i64] }:$src2, 0:{ *:[i1] })
     /*  39051 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
     /*  39054 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
     /*  39057 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39059 */     GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  39064 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
     /*  39068 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
     /*  39072 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  39074 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39077 */     GIR_RootConstrainSelectedInstOperands,
     /*  39078 */     // GIR_Coverage, 9355,
     /*  39078 */     GIR_EraseRootFromParent_Done,
     /*  39079 */   // Label 304: @39079
     /*  39079 */   GIM_Try, /*On fail goto*//*Label 305*/ GIMT_Encode4(39148), // Rule ID 2739 //
     /*  39084 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasLshlAddU64Inst),
     /*  39087 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  39091 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  39095 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  39099 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  39103 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  39107 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  39109 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:10:x
     /*  39113 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:10:y
     /*  39117 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl_0_to_4),
     /*  39121 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:10:z
     /*  39125 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24405),
     /*  39129 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  39131 */     // (add:{ *:[i64] } (shl:{ *:[i64] } i64:{ *:[i64] }:$src0:$pred:10:x, i32:{ *:[i32] }:$src1:$pred:10:y)<<P:Predicate_shl_0_to_4>><<P:Predicate_anonymous_24406>>, i64:{ *:[i64] }:$src2:$pred:10:z)<<P:10:Predicate_anonymous_24405>>  =>  (V_LSHL_ADD_U64_e64:{ *:[i64] } VSrc_b64:{ *:[i64] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b64:{ *:[i64] }:$src2)
     /*  39131 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U64_e64),
     /*  39134 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39136 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  39140 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  39144 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  39146 */     GIR_RootConstrainSelectedInstOperands,
     /*  39147 */     // GIR_Coverage, 2739,
     /*  39147 */     GIR_EraseRootFromParent_Done,
     /*  39148 */   // Label 305: @39148
     /*  39148 */   GIM_Try, /*On fail goto*//*Label 306*/ GIMT_Encode4(39217), // Rule ID 9343 //
     /*  39153 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasLshlAddU64Inst),
     /*  39156 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  39160 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:10:z
     /*  39164 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  39168 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  39172 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  39176 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  39180 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  39182 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:10:x
     /*  39186 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:10:y
     /*  39190 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl_0_to_4),
     /*  39194 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24405),
     /*  39198 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  39200 */     // (add:{ *:[i64] } i64:{ *:[i64] }:$src2:$pred:10:z, (shl:{ *:[i64] } i64:{ *:[i64] }:$src0:$pred:10:x, i32:{ *:[i32] }:$src1:$pred:10:y)<<P:Predicate_shl_0_to_4>><<P:Predicate_anonymous_24406>>)<<P:10:Predicate_anonymous_24405>>  =>  (V_LSHL_ADD_U64_e64:{ *:[i64] } VSrc_b64:{ *:[i64] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b64:{ *:[i64] }:$src2)
     /*  39200 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U64_e64),
     /*  39203 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39205 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  39209 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  39213 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  39215 */     GIR_RootConstrainSelectedInstOperands,
     /*  39216 */     // GIR_Coverage, 9343,
     /*  39216 */     GIR_EraseRootFromParent_Done,
     /*  39217 */   // Label 306: @39217
     /*  39217 */   GIM_Try, /*On fail goto*//*Label 307*/ GIMT_Encode4(39247), // Rule ID 1435 //
     /*  39222 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  39226 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23036),
     /*  39230 */     // (add:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_23036>>  =>  (V_ADD_U64_PSEUDO:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  39230 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_U64_PSEUDO),
     /*  39235 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::VCC), GIMT_Encode2(RegState::Dead),
     /*  39241 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  39245 */     GIR_RootConstrainSelectedInstOperands,
     /*  39246 */     // GIR_Coverage, 1435,
     /*  39246 */     GIR_Done,
     /*  39247 */   // Label 307: @39247
     /*  39247 */   GIM_Try, /*On fail goto*//*Label 308*/ GIMT_Encode4(39273), // Rule ID 1437 //
     /*  39252 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  39256 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16636),
     /*  39260 */     // (add:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_16636>>  =>  (S_ADD_U64_PSEUDO:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  39260 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_ADD_U64_PSEUDO),
     /*  39265 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  39271 */     GIR_RootConstrainSelectedInstOperands,
     /*  39272 */     // GIR_Coverage, 1437,
     /*  39272 */     GIR_Done,
     /*  39273 */   // Label 308: @39273
     /*  39273 */   GIM_Reject,
     /*  39274 */ // Label 300: @39274
     /*  39274 */ GIM_Reject,
     /*  39275 */ // Label 181: @39275
     /*  39275 */ GIM_Try, /*On fail goto*//*Label 309*/ GIMT_Encode4(39544),
     /*  39280 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  39283 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  39286 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  39290 */   GIM_Try, /*On fail goto*//*Label 310*/ GIMT_Encode4(39386), // Rule ID 9317 //
     /*  39295 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  39299 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  39303 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  39307 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  39311 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  39313 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  39320 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  39327 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(2), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  39334 */     // (add:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src2, i32:{ *:[i32] }:$src2_modifiers), (mul:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers)))  =>  (V_PK_MAD_U16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src2_modifiers, v2i16:{ *:[v2i16] }:$src2)
     /*  39334 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PK_MAD_U16),
     /*  39337 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39339 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src0_modifiers
     /*  39344 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src0
     /*  39349 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/1, // src1_modifiers
     /*  39354 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/0, // src1
     /*  39359 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src2_modifiers
     /*  39364 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src2
     /*  39369 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39372 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39375 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39378 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39381 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39384 */     GIR_RootConstrainSelectedInstOperands,
     /*  39385 */     // GIR_Coverage, 9317,
     /*  39385 */     GIR_EraseRootFromParent_Done,
     /*  39386 */   // Label 310: @39386
     /*  39386 */   GIM_Try, /*On fail goto*//*Label 311*/ GIMT_Encode4(39482), // Rule ID 1166 //
     /*  39391 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  39395 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  39399 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  39403 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  39407 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  39409 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(2), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  39416 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  39423 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  39430 */     // (add:{ *:[v2i16] } (mul:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers)), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src2, i32:{ *:[i32] }:$src2_modifiers))  =>  (V_PK_MAD_U16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src2_modifiers, v2i16:{ *:[v2i16] }:$src2)
     /*  39430 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PK_MAD_U16),
     /*  39433 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39435 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  39440 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  39445 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  39450 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  39455 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/1, // src2_modifiers
     /*  39460 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/0, // src2
     /*  39465 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39468 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39471 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39474 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39477 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39480 */     GIR_RootConstrainSelectedInstOperands,
     /*  39481 */     // GIR_Coverage, 1166,
     /*  39481 */     GIR_EraseRootFromParent_Done,
     /*  39482 */   // Label 311: @39482
     /*  39482 */   GIM_Try, /*On fail goto*//*Label 312*/ GIMT_Encode4(39543), // Rule ID 1177 //
     /*  39487 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  39494 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  39501 */     // (add:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_PK_ADD_U16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1)
     /*  39501 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PK_ADD_U16),
     /*  39504 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39506 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  39511 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  39516 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  39521 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  39526 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39529 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39532 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39535 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39538 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39541 */     GIR_RootConstrainSelectedInstOperands,
     /*  39542 */     // GIR_Coverage, 1177,
     /*  39542 */     GIR_EraseRootFromParent_Done,
     /*  39543 */   // Label 312: @39543
     /*  39543 */   GIM_Reject,
     /*  39544 */ // Label 309: @39544
     /*  39544 */ GIM_Reject,
     /*  39545 */ // Label 182: @39545
     /*  39545 */ GIM_Reject,
     /*  39546 */ // Label 1: @39546
     /*  39546 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(7), GIMT_Encode2(12), /*)*//*default:*//*Label 318*/ GIMT_Encode4(40168),
     /*  39557 */ /*GILLT_s1*//*Label 313*/ GIMT_Encode4(39577),
     /*  39561 */ /*GILLT_s16*//*Label 314*/ GIMT_Encode4(39696),
     /*  39565 */ /*GILLT_s32*//*Label 315*/ GIMT_Encode4(39912),
     /*  39569 */ /*GILLT_s64*//*Label 316*/ GIMT_Encode4(40027),
     /*  39573 */ /*GILLT_v2s16*//*Label 317*/ GIMT_Encode4(40096),
     /*  39577 */ // Label 313: @39577
     /*  39577 */ GIM_Try, /*On fail goto*//*Label 319*/ GIMT_Encode4(39695),
     /*  39582 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
     /*  39585 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
     /*  39588 */   GIM_Try, /*On fail goto*//*Label 320*/ GIMT_Encode4(39616), // Rule ID 8224 //
     /*  39593 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
     /*  39596 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  39600 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 255,
     /*  39604 */     // (sub:{ *:[i1] } i1:{ *:[i1] }:$src0, -1:{ *:[i1] })  =>  (S_NOT_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0)
     /*  39604 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_NOT_B64),
     /*  39607 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  39609 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  39611 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  39614 */     GIR_RootConstrainSelectedInstOperands,
     /*  39615 */     // GIR_Coverage, 8224,
     /*  39615 */     GIR_EraseRootFromParent_Done,
     /*  39616 */   // Label 320: @39616
     /*  39616 */   GIM_Try, /*On fail goto*//*Label 321*/ GIMT_Encode4(39644), // Rule ID 8231 //
     /*  39621 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
     /*  39624 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  39628 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 255,
     /*  39632 */     // (sub:{ *:[i1] } i1:{ *:[i1] }:$src0, -1:{ *:[i1] })  =>  (S_NOT_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0)
     /*  39632 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_NOT_B32),
     /*  39635 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  39637 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  39639 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  39642 */     GIR_RootConstrainSelectedInstOperands,
     /*  39643 */     // GIR_Coverage, 8231,
     /*  39643 */     GIR_EraseRootFromParent_Done,
     /*  39644 */   // Label 321: @39644
     /*  39644 */   GIM_Try, /*On fail goto*//*Label 322*/ GIMT_Encode4(39669), // Rule ID 8222 //
     /*  39649 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
     /*  39652 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  39656 */     // (sub:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_XOR_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
     /*  39656 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_XOR_B64),
     /*  39661 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  39667 */     GIR_RootConstrainSelectedInstOperands,
     /*  39668 */     // GIR_Coverage, 8222,
     /*  39668 */     GIR_Done,
     /*  39669 */   // Label 322: @39669
     /*  39669 */   GIM_Try, /*On fail goto*//*Label 323*/ GIMT_Encode4(39694), // Rule ID 8229 //
     /*  39674 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
     /*  39677 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  39681 */     // (sub:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_XOR_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
     /*  39681 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_XOR_B32),
     /*  39686 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  39692 */     GIR_RootConstrainSelectedInstOperands,
     /*  39693 */     // GIR_Coverage, 8229,
     /*  39693 */     GIR_Done,
     /*  39694 */   // Label 323: @39694
     /*  39694 */   GIM_Reject,
     /*  39695 */ // Label 319: @39695
     /*  39695 */ GIM_Reject,
     /*  39696 */ // Label 314: @39696
     /*  39696 */ GIM_Try, /*On fail goto*//*Label 324*/ GIMT_Encode4(39911),
     /*  39701 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
     /*  39704 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
     /*  39707 */   GIM_Try, /*On fail goto*//*Label 325*/ GIMT_Encode4(39766), // Rule ID 1108 //
     /*  39712 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotHasTrue16BitInsts_isGFX10Plus),
     /*  39715 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  39719 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opsel),
     /*  39726 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opsel),
     /*  39733 */     // (sub:{ *:[i16] } (VOP3OpSel:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSel:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_SUB_NC_U16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  39733 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_NC_U16_e64),
     /*  39736 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39738 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  39743 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  39748 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  39753 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  39758 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39761 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39764 */     GIR_RootConstrainSelectedInstOperands,
     /*  39765 */     // GIR_Coverage, 1108,
     /*  39765 */     GIR_EraseRootFromParent_Done,
     /*  39766 */   // Label 325: @39766
     /*  39766 */   GIM_Try, /*On fail goto*//*Label 326*/ GIMT_Encode4(39825), // Rule ID 1109 //
     /*  39771 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseRealTrue16Insts_isGFX10Plus),
     /*  39774 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
     /*  39778 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  39785 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  39792 */     // (sub:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_SUB_NC_U16_t16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  39792 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_NC_U16_t16_e64),
     /*  39795 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39797 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  39802 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  39807 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  39812 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  39817 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39820 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39823 */     GIR_RootConstrainSelectedInstOperands,
     /*  39824 */     // GIR_Coverage, 1109,
     /*  39824 */     GIR_EraseRootFromParent_Done,
     /*  39825 */   // Label 326: @39825
     /*  39825 */   GIM_Try, /*On fail goto*//*Label 327*/ GIMT_Encode4(39884), // Rule ID 1110 //
     /*  39830 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts_isGFX10Plus),
     /*  39833 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  39837 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  39844 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  39851 */     // (sub:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_SUB_NC_U16_fake16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  39851 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_NC_U16_fake16_e64),
     /*  39854 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39856 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  39861 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  39866 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  39871 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  39876 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39879 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39882 */     GIR_RootConstrainSelectedInstOperands,
     /*  39883 */     // GIR_Coverage, 1110,
     /*  39883 */     GIR_EraseRootFromParent_Done,
     /*  39884 */   // Label 327: @39884
     /*  39884 */   GIM_Try, /*On fail goto*//*Label 328*/ GIMT_Encode4(39910), // Rule ID 945 //
     /*  39889 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX8GFX9),
     /*  39892 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  39896 */     // (sub:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_SUB_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
     /*  39896 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_U16_e64),
     /*  39899 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39901 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  39903 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  39905 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39908 */     GIR_RootConstrainSelectedInstOperands,
     /*  39909 */     // GIR_Coverage, 945,
     /*  39909 */     GIR_EraseRootFromParent_Done,
     /*  39910 */   // Label 328: @39910
     /*  39910 */   GIM_Reject,
     /*  39911 */ // Label 324: @39911
     /*  39911 */ GIM_Reject,
     /*  39912 */ // Label 315: @39912
     /*  39912 */ GIM_Try, /*On fail goto*//*Label 329*/ GIMT_Encode4(40026),
     /*  39917 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  39920 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  39923 */   GIM_Try, /*On fail goto*//*Label 330*/ GIMT_Encode4(39957), // Rule ID 44 //
     /*  39928 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  39932 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  39936 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  39940 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16637),
     /*  39944 */     // (sub:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_16637>>  =>  (S_SUB_I32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  39944 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_SUB_I32),
     /*  39949 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  39955 */     GIR_RootConstrainSelectedInstOperands,
     /*  39956 */     // GIR_Coverage, 44,
     /*  39956 */     GIR_Done,
     /*  39957 */   // Label 330: @39957
     /*  39957 */   GIM_Try, /*On fail goto*//*Label 331*/ GIMT_Encode4(39987), // Rule ID 2604 //
     /*  39962 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAddNoCarryInsts),
     /*  39965 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  39969 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23038),
     /*  39973 */     // (sub:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_23038>>  =>  (V_SUB_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, 0:{ *:[i1] })
     /*  39973 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_U32_e64),
     /*  39976 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39978 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  39980 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  39982 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39985 */     GIR_RootConstrainSelectedInstOperands,
     /*  39986 */     // GIR_Coverage, 2604,
     /*  39986 */     GIR_EraseRootFromParent_Done,
     /*  39987 */   // Label 331: @39987
     /*  39987 */   GIM_Try, /*On fail goto*//*Label 332*/ GIMT_Encode4(40025), // Rule ID 2606 //
     /*  39992 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX6GFX7GFX8GFX9),
     /*  39995 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  39999 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23038),
     /*  40003 */     // (sub:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_23038>>  =>  (V_SUB_CO_U32_e64:{ *:[i32] }:{ *:[i1] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, 0:{ *:[i1] })
     /*  40003 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
     /*  40006 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_CO_U32_e64),
     /*  40009 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  40011 */     GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  40016 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  40018 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  40020 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40023 */     GIR_RootConstrainSelectedInstOperands,
     /*  40024 */     // GIR_Coverage, 2606,
     /*  40024 */     GIR_EraseRootFromParent_Done,
     /*  40025 */   // Label 332: @40025
     /*  40025 */   GIM_Reject,
     /*  40026 */ // Label 329: @40026
     /*  40026 */ GIM_Reject,
     /*  40027 */ // Label 316: @40027
     /*  40027 */ GIM_Try, /*On fail goto*//*Label 333*/ GIMT_Encode4(40095),
     /*  40032 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  40035 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  40038 */   GIM_Try, /*On fail goto*//*Label 334*/ GIMT_Encode4(40068), // Rule ID 1436 //
     /*  40043 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  40047 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23038),
     /*  40051 */     // (sub:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_23038>>  =>  (V_SUB_U64_PSEUDO:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  40051 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_U64_PSEUDO),
     /*  40056 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::VCC), GIMT_Encode2(RegState::Dead),
     /*  40062 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  40066 */     GIR_RootConstrainSelectedInstOperands,
     /*  40067 */     // GIR_Coverage, 1436,
     /*  40067 */     GIR_Done,
     /*  40068 */   // Label 334: @40068
     /*  40068 */   GIM_Try, /*On fail goto*//*Label 335*/ GIMT_Encode4(40094), // Rule ID 1438 //
     /*  40073 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  40077 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16637),
     /*  40081 */     // (sub:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_16637>>  =>  (S_SUB_U64_PSEUDO:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  40081 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_SUB_U64_PSEUDO),
     /*  40086 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  40092 */     GIR_RootConstrainSelectedInstOperands,
     /*  40093 */     // GIR_Coverage, 1438,
     /*  40093 */     GIR_Done,
     /*  40094 */   // Label 335: @40094
     /*  40094 */   GIM_Reject,
     /*  40095 */ // Label 333: @40095
     /*  40095 */ GIM_Reject,
     /*  40096 */ // Label 317: @40096
     /*  40096 */ GIM_Try, /*On fail goto*//*Label 336*/ GIMT_Encode4(40167), // Rule ID 1185 //
     /*  40101 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  40104 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  40107 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40111 */   GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  40118 */   GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  40125 */   // (sub:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_PK_SUB_I16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1)
     /*  40125 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PK_SUB_I16),
     /*  40128 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  40130 */   GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  40135 */   GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  40140 */   GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  40145 */   GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  40150 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40153 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40156 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40159 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40162 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40165 */   GIR_RootConstrainSelectedInstOperands,
     /*  40166 */   // GIR_Coverage, 1185,
     /*  40166 */   GIR_EraseRootFromParent_Done,
     /*  40167 */ // Label 336: @40167
     /*  40167 */ GIM_Reject,
     /*  40168 */ // Label 318: @40168
     /*  40168 */ GIM_Reject,
     /*  40169 */ // Label 2: @40169
     /*  40169 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(8), GIMT_Encode2(12), /*)*//*default:*//*Label 341*/ GIMT_Encode4(40606),
     /*  40180 */ /*GILLT_s16*//*Label 337*/ GIMT_Encode4(40196),
     /*  40184 */ /*GILLT_s32*//*Label 338*/ GIMT_Encode4(40370),
     /*  40188 */ /*GILLT_s64*//*Label 339*/ GIMT_Encode4(40471),
     /*  40192 */ /*GILLT_v2s16*//*Label 340*/ GIMT_Encode4(40534),
     /*  40196 */ // Label 337: @40196
     /*  40196 */ GIM_Try, /*On fail goto*//*Label 342*/ GIMT_Encode4(40369),
     /*  40201 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
     /*  40204 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
     /*  40207 */   GIM_Try, /*On fail goto*//*Label 343*/ GIMT_Encode4(40266), // Rule ID 907 //
     /*  40212 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_NotHasTrue16BitInsts_isGFX10Only),
     /*  40215 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40219 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opsel),
     /*  40226 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opsel),
     /*  40233 */     // (mul:{ *:[i16] } (VOP3OpSel:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSel:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_MUL_LO_U16_opsel_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  40233 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_LO_U16_opsel_e64),
     /*  40236 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  40238 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  40243 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  40248 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  40253 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  40258 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40261 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40264 */     GIR_RootConstrainSelectedInstOperands,
     /*  40265 */     // GIR_Coverage, 907,
     /*  40265 */     GIR_EraseRootFromParent_Done,
     /*  40266 */   // Label 343: @40266
     /*  40266 */   GIM_Try, /*On fail goto*//*Label 344*/ GIMT_Encode4(40322), // Rule ID 908 //
     /*  40271 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseRealTrue16Insts),
     /*  40274 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
     /*  40278 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  40285 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  40292 */     // (mul:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_MUL_LO_U16_t16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  40292 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_LO_U16_t16_e64),
     /*  40295 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  40297 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  40302 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  40307 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  40312 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  40317 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40320 */     GIR_RootConstrainSelectedInstOperands,
     /*  40321 */     // GIR_Coverage, 908,
     /*  40321 */     GIR_EraseRootFromParent_Done,
     /*  40322 */   // Label 344: @40322
     /*  40322 */   GIM_Try, /*On fail goto*//*Label 345*/ GIMT_Encode4(40345), // Rule ID 906 //
     /*  40327 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_NotHasTrue16BitInsts),
     /*  40330 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40334 */     // (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_MUL_LO_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
     /*  40334 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_LO_U16_e64),
     /*  40339 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  40343 */     GIR_RootConstrainSelectedInstOperands,
     /*  40344 */     // GIR_Coverage, 906,
     /*  40344 */     GIR_Done,
     /*  40345 */   // Label 345: @40345
     /*  40345 */   GIM_Try, /*On fail goto*//*Label 346*/ GIMT_Encode4(40368), // Rule ID 909 //
     /*  40350 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts),
     /*  40353 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40357 */     // (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_MUL_LO_U16_fake16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
     /*  40357 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_LO_U16_fake16_e64),
     /*  40362 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  40366 */     GIR_RootConstrainSelectedInstOperands,
     /*  40367 */     // GIR_Coverage, 909,
     /*  40367 */     GIR_Done,
     /*  40368 */   // Label 346: @40368
     /*  40368 */   GIM_Reject,
     /*  40369 */ // Label 342: @40369
     /*  40369 */ GIM_Reject,
     /*  40370 */ // Label 338: @40370
     /*  40370 */ GIM_Try, /*On fail goto*//*Label 347*/ GIMT_Encode4(40470),
     /*  40375 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  40378 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  40381 */   GIM_Try, /*On fail goto*//*Label 348*/ GIMT_Encode4(40401), // Rule ID 81 //
     /*  40386 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  40390 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16644),
     /*  40394 */     // (mul:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_16644>>  =>  (S_MUL_I32:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  40394 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_MUL_I32),
     /*  40399 */     GIR_RootConstrainSelectedInstOperands,
     /*  40400 */     // GIR_Coverage, 81,
     /*  40400 */     GIR_Done,
     /*  40401 */   // Label 348: @40401
     /*  40401 */   GIM_Try, /*On fail goto*//*Label 349*/ GIMT_Encode4(40435), // Rule ID 973 //
     /*  40406 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40410 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_22968),
     /*  40414 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3mods0),
     /*  40421 */     // (mul:{ *:[i32] } (VOP3Mods0:{ *:[i32] } i32:{ *:[i32] }:$src0), i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_22968>>  =>  (V_MUL_LO_U32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  40421 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_LO_U32_e64),
     /*  40424 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  40426 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  40431 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  40433 */     GIR_RootConstrainSelectedInstOperands,
     /*  40434 */     // GIR_Coverage, 973,
     /*  40434 */     GIR_EraseRootFromParent_Done,
     /*  40435 */   // Label 349: @40435
     /*  40435 */   GIM_Try, /*On fail goto*//*Label 350*/ GIMT_Encode4(40469), // Rule ID 9303 //
     /*  40440 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40444 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_22968),
     /*  40448 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3mods0),
     /*  40455 */     // (mul:{ *:[i32] } i32:{ *:[i32] }:$src1, (VOP3Mods0:{ *:[i32] } i32:{ *:[i32] }:$src0))<<P:Predicate_anonymous_22968>>  =>  (V_MUL_LO_U32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  40455 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_LO_U32_e64),
     /*  40458 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  40460 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  40465 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  40467 */     GIR_RootConstrainSelectedInstOperands,
     /*  40468 */     // GIR_Coverage, 9303,
     /*  40468 */     GIR_EraseRootFromParent_Done,
     /*  40469 */   // Label 350: @40469
     /*  40469 */   GIM_Reject,
     /*  40470 */ // Label 347: @40470
     /*  40470 */ GIM_Reject,
     /*  40471 */ // Label 339: @40471
     /*  40471 */ GIM_Try, /*On fail goto*//*Label 351*/ GIMT_Encode4(40533),
     /*  40476 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  40479 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  40482 */   GIM_Try, /*On fail goto*//*Label 352*/ GIMT_Encode4(40505), // Rule ID 51 //
     /*  40487 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX12Plus),
     /*  40490 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  40494 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16644),
     /*  40498 */     // (mul:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_16644>>  =>  (S_MUL_U64:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  40498 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_MUL_U64),
     /*  40503 */     GIR_RootConstrainSelectedInstOperands,
     /*  40504 */     // GIR_Coverage, 51,
     /*  40504 */     GIR_Done,
     /*  40505 */   // Label 352: @40505
     /*  40505 */   GIM_Try, /*On fail goto*//*Label 353*/ GIMT_Encode4(40532), // Rule ID 840 //
     /*  40510 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX1250Plus),
     /*  40513 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  40517 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_22968),
     /*  40521 */     // (mul:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_22968>>  =>  (V_MUL_U64_e64:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  40521 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_U64_e64),
     /*  40526 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  40530 */     GIR_RootConstrainSelectedInstOperands,
     /*  40531 */     // GIR_Coverage, 840,
     /*  40531 */     GIR_Done,
     /*  40532 */   // Label 353: @40532
     /*  40532 */   GIM_Reject,
     /*  40533 */ // Label 351: @40533
     /*  40533 */ GIM_Reject,
     /*  40534 */ // Label 340: @40534
     /*  40534 */ GIM_Try, /*On fail goto*//*Label 354*/ GIMT_Encode4(40605), // Rule ID 1178 //
     /*  40539 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  40542 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  40545 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40549 */   GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  40556 */   GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  40563 */   // (mul:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_PK_MUL_LO_U16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1)
     /*  40563 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PK_MUL_LO_U16),
     /*  40566 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  40568 */   GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  40573 */   GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  40578 */   GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  40583 */   GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  40588 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40591 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40594 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40597 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40600 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40603 */   GIR_RootConstrainSelectedInstOperands,
     /*  40604 */   // GIR_Coverage, 1178,
     /*  40604 */   GIR_EraseRootFromParent_Done,
     /*  40605 */ // Label 354: @40605
     /*  40605 */ GIM_Reject,
     /*  40606 */ // Label 341: @40606
     /*  40606 */ GIM_Reject,
     /*  40607 */ // Label 3: @40607
     /*  40607 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(7), GIMT_Encode2(17), /*)*//*default:*//*Label 362*/ GIMT_Encode4(42603),
     /*  40618 */ /*GILLT_s1*//*Label 355*/ GIMT_Encode4(40658),
     /*  40622 */ /*GILLT_s16*//*Label 356*/ GIMT_Encode4(40721),
     /*  40626 */ /*GILLT_s32*//*Label 357*/ GIMT_Encode4(40961),
     /*  40630 */ /*GILLT_s64*//*Label 358*/ GIMT_Encode4(41591),
     /*  40634 */ /*GILLT_v2s16*//*Label 359*/ GIMT_Encode4(42188),
     /*  40638 */ /*GILLT_v2s32*//*Label 360*/ GIMT_Encode4(42339), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  40654 */ /*GILLT_v4s16*//*Label 361*/ GIMT_Encode4(42480),
     /*  40658 */ // Label 355: @40658
     /*  40658 */ GIM_Try, /*On fail goto*//*Label 363*/ GIMT_Encode4(40720),
     /*  40663 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
     /*  40666 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
     /*  40669 */   GIM_Try, /*On fail goto*//*Label 364*/ GIMT_Encode4(40694), // Rule ID 8218 //
     /*  40674 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
     /*  40677 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  40681 */     // (and:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_AND_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
     /*  40681 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_AND_B64),
     /*  40686 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  40692 */     GIR_RootConstrainSelectedInstOperands,
     /*  40693 */     // GIR_Coverage, 8218,
     /*  40693 */     GIR_Done,
     /*  40694 */   // Label 364: @40694
     /*  40694 */   GIM_Try, /*On fail goto*//*Label 365*/ GIMT_Encode4(40719), // Rule ID 8225 //
     /*  40699 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
     /*  40702 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  40706 */     // (and:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_AND_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
     /*  40706 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_AND_B32),
     /*  40711 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  40717 */     GIR_RootConstrainSelectedInstOperands,
     /*  40718 */     // GIR_Coverage, 8225,
     /*  40718 */     GIR_Done,
     /*  40719 */   // Label 365: @40719
     /*  40719 */   GIM_Reject,
     /*  40720 */ // Label 363: @40720
     /*  40720 */ GIM_Reject,
     /*  40721 */ // Label 356: @40721
     /*  40721 */ GIM_Try, /*On fail goto*//*Label 366*/ GIMT_Encode4(40960),
     /*  40726 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
     /*  40729 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
     /*  40732 */   GIM_Try, /*On fail goto*//*Label 367*/ GIMT_Encode4(40783), // Rule ID 9319 //
     /*  40737 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  40741 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  40745 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  40749 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  40753 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  40757 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  40761 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16645),
     /*  40765 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  40767 */     // (and:{ *:[i16] } (xor:{ *:[i16] } i16:{ *:[i16] }:$src1, -1:{ *:[i16] }), i16:{ *:[i16] }:$src0)<<P:Predicate_anonymous_16645>>  =>  (S_ANDN2_B32:{ *:[i16] }:{ *:[i1] } SSrc_b32:{ *:[i16] }:$src0, SSrc_b32:{ *:[i16] }:$src1)
     /*  40767 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
     /*  40770 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  40772 */     GIR_RootToRootCopy, /*OpIdx*/2, // src0
     /*  40774 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  40778 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  40781 */     GIR_RootConstrainSelectedInstOperands,
     /*  40782 */     // GIR_Coverage, 9319,
     /*  40782 */     GIR_EraseRootFromParent_Done,
     /*  40783 */   // Label 367: @40783
     /*  40783 */   GIM_Try, /*On fail goto*//*Label 368*/ GIMT_Encode4(40834), // Rule ID 1984 //
     /*  40788 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  40792 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  40796 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  40800 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  40804 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  40808 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  40812 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16645),
     /*  40816 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  40818 */     // (and:{ *:[i16] } i16:{ *:[i16] }:$src0, (xor:{ *:[i16] } i16:{ *:[i16] }:$src1, -1:{ *:[i16] }))<<P:Predicate_anonymous_16645>>  =>  (S_ANDN2_B32:{ *:[i16] }:{ *:[i1] } SSrc_b32:{ *:[i16] }:$src0, SSrc_b32:{ *:[i16] }:$src1)
     /*  40818 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
     /*  40821 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  40823 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  40825 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  40829 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  40832 */     GIR_RootConstrainSelectedInstOperands,
     /*  40833 */     // GIR_Coverage, 1984,
     /*  40833 */     GIR_EraseRootFromParent_Done,
     /*  40834 */   // Label 368: @40834
     /*  40834 */   GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(40857), // Rule ID 2636 //
     /*  40839 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotHasTrue16BitInsts),
     /*  40842 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40846 */     // (and:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_AND_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i16] }:$src0, VSrc_b32:{ *:[i16] }:$src1)
     /*  40846 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B32_e64),
     /*  40851 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  40855 */     GIR_RootConstrainSelectedInstOperands,
     /*  40856 */     // GIR_Coverage, 2636,
     /*  40856 */     GIR_Done,
     /*  40857 */   // Label 369: @40857
     /*  40857 */   GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(40880), // Rule ID 2639 //
     /*  40862 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts),
     /*  40865 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40869 */     // (and:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_AND_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i16] }:$src0, VSrc_b32:{ *:[i16] }:$src1)
     /*  40869 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B32_e64),
     /*  40874 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  40878 */     GIR_RootConstrainSelectedInstOperands,
     /*  40879 */     // GIR_Coverage, 2639,
     /*  40879 */     GIR_Done,
     /*  40880 */   // Label 370: @40880
     /*  40880 */   GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(40936), // Rule ID 938 //
     /*  40885 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX11Plus),
     /*  40888 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
     /*  40892 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  40899 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  40906 */     // (and:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_AND_B16_t16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  40906 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B16_t16_e64),
     /*  40909 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  40911 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  40916 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  40921 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  40926 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  40931 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40934 */     GIR_RootConstrainSelectedInstOperands,
     /*  40935 */     // GIR_Coverage, 938,
     /*  40935 */     GIR_EraseRootFromParent_Done,
     /*  40936 */   // Label 371: @40936
     /*  40936 */   GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(40959), // Rule ID 939 //
     /*  40941 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX11Plus),
     /*  40944 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40948 */     // (and:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_AND_B16_fake16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
     /*  40948 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B16_fake16_e64),
     /*  40953 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  40957 */     GIR_RootConstrainSelectedInstOperands,
     /*  40958 */     // GIR_Coverage, 939,
     /*  40958 */     GIR_Done,
     /*  40959 */   // Label 372: @40959
     /*  40959 */   GIM_Reject,
     /*  40960 */ // Label 366: @40960
     /*  40960 */ GIM_Reject,
     /*  40961 */ // Label 357: @40961
     /*  40961 */ GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(41590),
     /*  40966 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  40969 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  40972 */   GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(41047), // Rule ID 12060 //
     /*  40977 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40981 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  40985 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  40989 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  40993 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  40997 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  40999 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  41003 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  41007 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  41011 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  41015 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  41017 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
     /*  41021 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  41025 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23046),
     /*  41029 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  41031 */     // (and:{ *:[i32] } (add:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, i32:{ *:[i32] }:$width)<<P:Predicate_shl_oneuse>>, -1:{ *:[i32] })<<P:Predicate_add_oneuse>>, i32:{ *:[i32] }:$src)<<P:Predicate_anonymous_23046>>  =>  (V_BFE_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src, 0:{ *:[i32] }, ?:{ *:[i32] }:$width)
     /*  41031 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFE_U32_e64),
     /*  41034 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  41036 */     GIR_RootToRootCopy, /*OpIdx*/2, // src
     /*  41038 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41041 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // width
     /*  41045 */     GIR_RootConstrainSelectedInstOperands,
     /*  41046 */     // GIR_Coverage, 12060,
     /*  41046 */     GIR_EraseRootFromParent_Done,
     /*  41047 */   // Label 374: @41047
     /*  41047 */   GIM_Try, /*On fail goto*//*Label 375*/ GIMT_Encode4(41122), // Rule ID 12061 //
     /*  41052 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41056 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  41060 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  41064 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  41068 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  41072 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  41074 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  41078 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  41082 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  41086 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  41090 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  41092 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 255,
     /*  41096 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  41100 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23046),
     /*  41104 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  41106 */     // (and:{ *:[i32] } (xor:{ *:[i32] } (shl:{ *:[i32] } -1:{ *:[i32] }, i32:{ *:[i32] }:$width)<<P:Predicate_shl_oneuse>>, -1:{ *:[i32] })<<P:Predicate_xor_oneuse>>, i32:{ *:[i32] }:$src)<<P:Predicate_anonymous_23046>>  =>  (V_BFE_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src, 0:{ *:[i32] }, ?:{ *:[i32] }:$width)
     /*  41106 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFE_U32_e64),
     /*  41109 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  41111 */     GIR_RootToRootCopy, /*OpIdx*/2, // src
     /*  41113 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41116 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // width
     /*  41120 */     GIR_RootConstrainSelectedInstOperands,
     /*  41121 */     // GIR_Coverage, 12061,
     /*  41121 */     GIR_EraseRootFromParent_Done,
     /*  41122 */   // Label 375: @41122
     /*  41122 */   GIM_Try, /*On fail goto*//*Label 376*/ GIMT_Encode4(41197), // Rule ID 8409 //
     /*  41127 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41131 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  41135 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  41139 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  41143 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  41147 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  41149 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  41153 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  41157 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  41161 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  41165 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  41167 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
     /*  41171 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  41175 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23046),
     /*  41179 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  41181 */     // (and:{ *:[i32] } i32:{ *:[i32] }:$src, (add:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, i32:{ *:[i32] }:$width)<<P:Predicate_shl_oneuse>>, -1:{ *:[i32] })<<P:Predicate_add_oneuse>>)<<P:Predicate_anonymous_23046>>  =>  (V_BFE_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src, 0:{ *:[i32] }, ?:{ *:[i32] }:$width)
     /*  41181 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFE_U32_e64),
     /*  41184 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  41186 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  41188 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41191 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // width
     /*  41195 */     GIR_RootConstrainSelectedInstOperands,
     /*  41196 */     // GIR_Coverage, 8409,
     /*  41196 */     GIR_EraseRootFromParent_Done,
     /*  41197 */   // Label 376: @41197
     /*  41197 */   GIM_Try, /*On fail goto*//*Label 377*/ GIMT_Encode4(41272), // Rule ID 8410 //
     /*  41202 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41206 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  41210 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  41214 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  41218 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  41222 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  41224 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  41228 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  41232 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  41236 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  41240 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  41242 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 255,
     /*  41246 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  41250 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23046),
     /*  41254 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  41256 */     // (and:{ *:[i32] } i32:{ *:[i32] }:$src, (xor:{ *:[i32] } (shl:{ *:[i32] } -1:{ *:[i32] }, i32:{ *:[i32] }:$width)<<P:Predicate_shl_oneuse>>, -1:{ *:[i32] })<<P:Predicate_xor_oneuse>>)<<P:Predicate_anonymous_23046>>  =>  (V_BFE_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src, 0:{ *:[i32] }, ?:{ *:[i32] }:$width)
     /*  41256 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFE_U32_e64),
     /*  41259 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  41261 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  41263 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41266 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // width
     /*  41270 */     GIR_RootConstrainSelectedInstOperands,
     /*  41271 */     // GIR_Coverage, 8410,
     /*  41271 */     GIR_EraseRootFromParent_Done,
     /*  41272 */   // Label 377: @41272
     /*  41272 */   GIM_Try, /*On fail goto*//*Label 378*/ GIMT_Encode4(41325), // Rule ID 12027 //
     /*  41277 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41281 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  41285 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  41289 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  41293 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  41297 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  41299 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  41303 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23046),
     /*  41307 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  41309 */     // (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })<<P:Predicate_not_oneuse>>, i32:{ *:[i32] }:$z)<<P:Predicate_anonymous_23046>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$z)
     /*  41309 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  41312 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  41314 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // x
     /*  41318 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41321 */     GIR_RootToRootCopy, /*OpIdx*/2, // z
     /*  41323 */     GIR_RootConstrainSelectedInstOperands,
     /*  41324 */     // GIR_Coverage, 12027,
     /*  41324 */     GIR_EraseRootFromParent_Done,
     /*  41325 */   // Label 378: @41325
     /*  41325 */   GIM_Try, /*On fail goto*//*Label 379*/ GIMT_Encode4(41378), // Rule ID 8118 //
     /*  41330 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41334 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  41338 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  41342 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  41346 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  41350 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  41352 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  41356 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23046),
     /*  41360 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  41362 */     // (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })<<P:Predicate_not_oneuse>>)<<P:Predicate_anonymous_23046>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$z)
     /*  41362 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  41365 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  41367 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // x
     /*  41371 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41374 */     GIR_RootToRootCopy, /*OpIdx*/1, // z
     /*  41376 */     GIR_RootConstrainSelectedInstOperands,
     /*  41377 */     // GIR_Coverage, 8118,
     /*  41377 */     GIR_EraseRootFromParent_Done,
     /*  41378 */   // Label 379: @41378
     /*  41378 */   GIM_Try, /*On fail goto*//*Label 380*/ GIMT_Encode4(41429), // Rule ID 9244 //
     /*  41383 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  41387 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  41391 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  41395 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  41399 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  41403 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  41407 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16645),
     /*  41411 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  41413 */     // (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src1, -1:{ *:[i32] }), i32:{ *:[i32] }:$src0)<<P:Predicate_anonymous_16645>>  =>  (S_ANDN2_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  41413 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
     /*  41416 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  41418 */     GIR_RootToRootCopy, /*OpIdx*/2, // src0
     /*  41420 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  41424 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  41427 */     GIR_RootConstrainSelectedInstOperands,
     /*  41428 */     // GIR_Coverage, 9244,
     /*  41428 */     GIR_EraseRootFromParent_Done,
     /*  41429 */   // Label 380: @41429
     /*  41429 */   GIM_Try, /*On fail goto*//*Label 381*/ GIMT_Encode4(41480), // Rule ID 64 //
     /*  41434 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  41438 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  41442 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  41446 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  41450 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  41454 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  41458 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16645),
     /*  41462 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  41464 */     // (and:{ *:[i32] } i32:{ *:[i32] }:$src0, (xor:{ *:[i32] } i32:{ *:[i32] }:$src1, -1:{ *:[i32] }))<<P:Predicate_anonymous_16645>>  =>  (S_ANDN2_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  41464 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
     /*  41467 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  41469 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  41471 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  41475 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  41478 */     GIR_RootConstrainSelectedInstOperands,
     /*  41479 */     // GIR_Coverage, 64,
     /*  41479 */     GIR_EraseRootFromParent_Done,
     /*  41480 */   // Label 381: @41480
     /*  41480 */   GIM_Try, /*On fail goto*//*Label 382*/ GIMT_Encode4(41543), // Rule ID 8408 //
     /*  41485 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41489 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  41493 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  41497 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  41501 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  41505 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  41509 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  41513 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_IMMZeroBasedBitfieldMask),
     /*  41517 */     // MIs[2] Operand 1
     /*  41517 */     // No operand predicates
     /*  41517 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23046),
     /*  41521 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  41523 */     // (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src, i32:{ *:[i32] }:$rshift), (imm:{ *:[i32] })<<P:Predicate_IMMZeroBasedBitfieldMask>>:$mask)<<P:Predicate_anonymous_23046>>  =>  (V_BFE_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src, ?:{ *:[i32] }:$rshift, (IMMPopCount:{ *:[i32] } ?:{ *:[i32] }:$mask))
     /*  41523 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFE_U32_e64),
     /*  41526 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  41528 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  41532 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rshift
     /*  41536 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/2, /*Renderer*/GIMT_Encode2(GICR_renderPopcntImm), // mask
     /*  41541 */     GIR_RootConstrainSelectedInstOperands,
     /*  41542 */     // GIR_Coverage, 8408,
     /*  41542 */     GIR_EraseRootFromParent_Done,
     /*  41543 */   // Label 382: @41543
     /*  41543 */   GIM_Try, /*On fail goto*//*Label 383*/ GIMT_Encode4(41569), // Rule ID 52 //
     /*  41548 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  41552 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16645),
     /*  41556 */     // (and:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_16645>>  =>  (S_AND_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  41556 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_AND_B32),
     /*  41561 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  41567 */     GIR_RootConstrainSelectedInstOperands,
     /*  41568 */     // GIR_Coverage, 52,
     /*  41568 */     GIR_Done,
     /*  41569 */   // Label 383: @41569
     /*  41569 */   GIM_Try, /*On fail goto*//*Label 384*/ GIMT_Encode4(41589), // Rule ID 837 //
     /*  41574 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41578 */     // (and:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_AND_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  41578 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B32_e64),
     /*  41583 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  41587 */     GIR_RootConstrainSelectedInstOperands,
     /*  41588 */     // GIR_Coverage, 837,
     /*  41588 */     GIR_Done,
     /*  41589 */   // Label 384: @41589
     /*  41589 */   GIM_Reject,
     /*  41590 */ // Label 373: @41590
     /*  41590 */ GIM_Reject,
     /*  41591 */ // Label 358: @41591
     /*  41591 */ GIM_Try, /*On fail goto*//*Label 385*/ GIMT_Encode4(42187),
     /*  41596 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  41599 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  41602 */   GIM_Try, /*On fail goto*//*Label 386*/ GIMT_Encode4(41830), // Rule ID 12028 //
     /*  41607 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  41611 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  41615 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  41619 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  41623 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  41627 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  41629 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  41633 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23046),
     /*  41637 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  41639 */     // (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] })<<P:Predicate_not_oneuse>>, i64:{ *:[i64] }:$z)<<P:Predicate_anonymous_23046>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), 0:{ *:[i32] }, (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), 0:{ *:[i32] }, (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
     /*  41639 */     GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
     /*  41642 */     GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  41646 */     GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41651 */     GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/0, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // z
     /*  41657 */     GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41662 */     GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  41667 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
     /*  41670 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  41674 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41679 */     GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
     /*  41685 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41690 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  41695 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  41698 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  41702 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41707 */     GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
     /*  41710 */     GIR_AddImm8, /*InsnID*/4, /*Imm*/0,
     /*  41713 */     GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/5,
     /*  41716 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
     /*  41718 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
     /*  41721 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  41725 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41730 */     GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // z
     /*  41736 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41741 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  41746 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
     /*  41749 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  41753 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41758 */     GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
     /*  41764 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41769 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  41774 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  41777 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  41781 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41786 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  41789 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  41792 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  41795 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  41797 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  41800 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  41802 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  41805 */     GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
     /*  41808 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  41811 */     GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
     /*  41814 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  41819 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41824 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41829 */     // GIR_Coverage, 12028,
     /*  41829 */     GIR_EraseRootFromParent_Done,
     /*  41830 */   // Label 386: @41830
     /*  41830 */   GIM_Try, /*On fail goto*//*Label 387*/ GIMT_Encode4(42058), // Rule ID 8119 //
     /*  41835 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  41839 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  41843 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  41847 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  41851 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  41855 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  41857 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  41861 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23046),
     /*  41865 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  41867 */     // (and:{ *:[i64] } i64:{ *:[i64] }:$z, (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] })<<P:Predicate_not_oneuse>>)<<P:Predicate_anonymous_23046>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), 0:{ *:[i32] }, (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), 0:{ *:[i32] }, (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
     /*  41867 */     GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
     /*  41870 */     GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  41874 */     GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41879 */     GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // z
     /*  41885 */     GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41890 */     GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  41895 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
     /*  41898 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  41902 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41907 */     GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
     /*  41913 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41918 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  41923 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  41926 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  41930 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41935 */     GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
     /*  41938 */     GIR_AddImm8, /*InsnID*/4, /*Imm*/0,
     /*  41941 */     GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/5,
     /*  41944 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
     /*  41946 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
     /*  41949 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  41953 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41958 */     GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // z
     /*  41964 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41969 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  41974 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
     /*  41977 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  41981 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41986 */     GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
     /*  41992 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41997 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  42002 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  42005 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  42009 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42014 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  42017 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  42020 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  42023 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  42025 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  42028 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  42030 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  42033 */     GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
     /*  42036 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  42039 */     GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
     /*  42042 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  42047 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42052 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42057 */     // GIR_Coverage, 8119,
     /*  42057 */     GIR_EraseRootFromParent_Done,
     /*  42058 */   // Label 387: @42058
     /*  42058 */   GIM_Try, /*On fail goto*//*Label 388*/ GIMT_Encode4(42109), // Rule ID 9245 //
     /*  42063 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  42067 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  42071 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  42075 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  42079 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  42083 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  42087 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16645),
     /*  42091 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  42093 */     // (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$src1, -1:{ *:[i64] }), i64:{ *:[i64] }:$src0)<<P:Predicate_anonymous_16645>>  =>  (S_ANDN2_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  42093 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
     /*  42096 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  42098 */     GIR_RootToRootCopy, /*OpIdx*/2, // src0
     /*  42100 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  42104 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  42107 */     GIR_RootConstrainSelectedInstOperands,
     /*  42108 */     // GIR_Coverage, 9245,
     /*  42108 */     GIR_EraseRootFromParent_Done,
     /*  42109 */   // Label 388: @42109
     /*  42109 */   GIM_Try, /*On fail goto*//*Label 389*/ GIMT_Encode4(42160), // Rule ID 65 //
     /*  42114 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  42118 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  42122 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  42126 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  42130 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  42134 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  42138 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16645),
     /*  42142 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  42144 */     // (and:{ *:[i64] } i64:{ *:[i64] }:$src0, (xor:{ *:[i64] } i64:{ *:[i64] }:$src1, -1:{ *:[i64] }))<<P:Predicate_anonymous_16645>>  =>  (S_ANDN2_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  42144 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
     /*  42147 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  42149 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  42151 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  42155 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  42158 */     GIR_RootConstrainSelectedInstOperands,
     /*  42159 */     // GIR_Coverage, 65,
     /*  42159 */     GIR_EraseRootFromParent_Done,
     /*  42160 */   // Label 389: @42160
     /*  42160 */   GIM_Try, /*On fail goto*//*Label 390*/ GIMT_Encode4(42186), // Rule ID 53 //
     /*  42165 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  42169 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16645),
     /*  42173 */     // (and:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_16645>>  =>  (S_AND_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  42173 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_AND_B64),
     /*  42178 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  42184 */     GIR_RootConstrainSelectedInstOperands,
     /*  42185 */     // GIR_Coverage, 53,
     /*  42185 */     GIR_Done,
     /*  42186 */   // Label 390: @42186
     /*  42186 */   GIM_Reject,
     /*  42187 */ // Label 385: @42187
     /*  42187 */ GIM_Reject,
     /*  42188 */ // Label 359: @42188
     /*  42188 */ GIM_Try, /*On fail goto*//*Label 391*/ GIMT_Encode4(42338),
     /*  42193 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  42196 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  42199 */   GIM_Try, /*On fail goto*//*Label 392*/ GIMT_Encode4(42258), // Rule ID 9320 //
     /*  42204 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  42208 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  42212 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  42216 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  42220 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  42224 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  42228 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  42234 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  42236 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16645),
     /*  42240 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  42242 */     // (and:{ *:[v2i16] } (xor:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, immAllOnesV:{ *:[v2i16] }), v2i16:{ *:[v2i16] }:$src0)<<P:Predicate_anonymous_16645>>  =>  (S_ANDN2_B32:{ *:[v2i16] }:{ *:[i1] } SSrc_b32:{ *:[v2i16] }:$src0, SSrc_b32:{ *:[v2i16] }:$src1)
     /*  42242 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
     /*  42245 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  42247 */     GIR_RootToRootCopy, /*OpIdx*/2, // src0
     /*  42249 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  42253 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  42256 */     GIR_RootConstrainSelectedInstOperands,
     /*  42257 */     // GIR_Coverage, 9320,
     /*  42257 */     GIR_EraseRootFromParent_Done,
     /*  42258 */   // Label 392: @42258
     /*  42258 */   GIM_Try, /*On fail goto*//*Label 393*/ GIMT_Encode4(42317), // Rule ID 1985 //
     /*  42263 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  42267 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  42271 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  42275 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  42279 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  42283 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  42287 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  42293 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  42295 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16645),
     /*  42299 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  42301 */     // (and:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, (xor:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, immAllOnesV:{ *:[v2i16] }))<<P:Predicate_anonymous_16645>>  =>  (S_ANDN2_B32:{ *:[v2i16] }:{ *:[i1] } SSrc_b32:{ *:[v2i16] }:$src0, SSrc_b32:{ *:[v2i16] }:$src1)
     /*  42301 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
     /*  42304 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  42306 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  42308 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  42312 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  42315 */     GIR_RootConstrainSelectedInstOperands,
     /*  42316 */     // GIR_Coverage, 1985,
     /*  42316 */     GIR_EraseRootFromParent_Done,
     /*  42317 */   // Label 393: @42317
     /*  42317 */   GIM_Try, /*On fail goto*//*Label 394*/ GIMT_Encode4(42337), // Rule ID 2642 //
     /*  42322 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42326 */     // (and:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1)  =>  (V_AND_B32_e64:{ *:[v2i16] } VSrc_b32:{ *:[v2i16] }:$src0, VSrc_b32:{ *:[v2i16] }:$src1)
     /*  42326 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B32_e64),
     /*  42331 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  42335 */     GIR_RootConstrainSelectedInstOperands,
     /*  42336 */     // GIR_Coverage, 2642,
     /*  42336 */     GIR_Done,
     /*  42337 */   // Label 394: @42337
     /*  42337 */   GIM_Reject,
     /*  42338 */ // Label 391: @42338
     /*  42338 */ GIM_Reject,
     /*  42339 */ // Label 360: @42339
     /*  42339 */ GIM_Try, /*On fail goto*//*Label 395*/ GIMT_Encode4(42479),
     /*  42344 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  42347 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  42350 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16645),
     /*  42354 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  42358 */   GIM_Try, /*On fail goto*//*Label 396*/ GIMT_Encode4(42409), // Rule ID 9322 //
     /*  42363 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  42367 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  42371 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  42375 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  42379 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  42383 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  42389 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  42391 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  42393 */     // (and:{ *:[v2i32] } (xor:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$src1, immAllOnesV:{ *:[v2i32] }), v2i32:{ *:[v2i32] }:$src0)<<P:Predicate_anonymous_16645>>  =>  (S_ANDN2_B64:{ *:[v2i32] }:{ *:[i1] } SSrc_b64:{ *:[v2i32] }:$src0, SSrc_b64:{ *:[v2i32] }:$src1)
     /*  42393 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
     /*  42396 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  42398 */     GIR_RootToRootCopy, /*OpIdx*/2, // src0
     /*  42400 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  42404 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  42407 */     GIR_RootConstrainSelectedInstOperands,
     /*  42408 */     // GIR_Coverage, 9322,
     /*  42408 */     GIR_EraseRootFromParent_Done,
     /*  42409 */   // Label 396: @42409
     /*  42409 */   GIM_Try, /*On fail goto*//*Label 397*/ GIMT_Encode4(42460), // Rule ID 1987 //
     /*  42414 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  42418 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  42422 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  42426 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  42430 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  42434 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  42440 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  42442 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  42444 */     // (and:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$src0, (xor:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$src1, immAllOnesV:{ *:[v2i32] }))<<P:Predicate_anonymous_16645>>  =>  (S_ANDN2_B64:{ *:[v2i32] }:{ *:[i1] } SSrc_b64:{ *:[v2i32] }:$src0, SSrc_b64:{ *:[v2i32] }:$src1)
     /*  42444 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
     /*  42447 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  42449 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  42451 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  42455 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  42458 */     GIR_RootConstrainSelectedInstOperands,
     /*  42459 */     // GIR_Coverage, 1987,
     /*  42459 */     GIR_EraseRootFromParent_Done,
     /*  42460 */   // Label 397: @42460
     /*  42460 */   GIM_Try, /*On fail goto*//*Label 398*/ GIMT_Encode4(42478), // Rule ID 1969 //
     /*  42465 */     // (and:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$x, v2i32:{ *:[v2i32] }:$y)<<P:Predicate_anonymous_16645>>  =>  (S_AND_B64:{ *:[v2i32] }:{ *:[i1] } SReg_64:{ *:[v2i32] }:$x, SReg_64:{ *:[v2i32] }:$y)
     /*  42465 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_AND_B64),
     /*  42470 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  42476 */     GIR_RootConstrainSelectedInstOperands,
     /*  42477 */     // GIR_Coverage, 1969,
     /*  42477 */     GIR_Done,
     /*  42478 */   // Label 398: @42478
     /*  42478 */   GIM_Reject,
     /*  42479 */ // Label 395: @42479
     /*  42479 */ GIM_Reject,
     /*  42480 */ // Label 361: @42480
     /*  42480 */ GIM_Try, /*On fail goto*//*Label 399*/ GIMT_Encode4(42602),
     /*  42485 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  42488 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  42491 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16645),
     /*  42495 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  42499 */   GIM_Try, /*On fail goto*//*Label 400*/ GIMT_Encode4(42550), // Rule ID 9321 //
     /*  42504 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  42508 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  42512 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  42516 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  42520 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  42524 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  42530 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  42532 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  42534 */     // (and:{ *:[v4i16] } (xor:{ *:[v4i16] } v4i16:{ *:[v4i16] }:$src1, immAllOnesV:{ *:[v4i16] }), v4i16:{ *:[v4i16] }:$src0)<<P:Predicate_anonymous_16645>>  =>  (S_ANDN2_B64:{ *:[v4i16] }:{ *:[i1] } SSrc_b64:{ *:[v4i16] }:$src0, SSrc_b64:{ *:[v4i16] }:$src1)
     /*  42534 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
     /*  42537 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  42539 */     GIR_RootToRootCopy, /*OpIdx*/2, // src0
     /*  42541 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  42545 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  42548 */     GIR_RootConstrainSelectedInstOperands,
     /*  42549 */     // GIR_Coverage, 9321,
     /*  42549 */     GIR_EraseRootFromParent_Done,
     /*  42550 */   // Label 400: @42550
     /*  42550 */   GIM_Try, /*On fail goto*//*Label 401*/ GIMT_Encode4(42601), // Rule ID 1986 //
     /*  42555 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  42559 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  42563 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  42567 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  42571 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  42575 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  42581 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  42583 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  42585 */     // (and:{ *:[v4i16] } v4i16:{ *:[v4i16] }:$src0, (xor:{ *:[v4i16] } v4i16:{ *:[v4i16] }:$src1, immAllOnesV:{ *:[v4i16] }))<<P:Predicate_anonymous_16645>>  =>  (S_ANDN2_B64:{ *:[v4i16] }:{ *:[i1] } SSrc_b64:{ *:[v4i16] }:$src0, SSrc_b64:{ *:[v4i16] }:$src1)
     /*  42585 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
     /*  42588 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  42590 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  42592 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  42596 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  42599 */     GIR_RootConstrainSelectedInstOperands,
     /*  42600 */     // GIR_Coverage, 1986,
     /*  42600 */     GIR_EraseRootFromParent_Done,
     /*  42601 */   // Label 401: @42601
     /*  42601 */   GIM_Reject,
     /*  42602 */ // Label 399: @42602
     /*  42602 */ GIM_Reject,
     /*  42603 */ // Label 362: @42603
     /*  42603 */ GIM_Reject,
     /*  42604 */ // Label 4: @42604
     /*  42604 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(7), GIMT_Encode2(17), /*)*//*default:*//*Label 409*/ GIMT_Encode4(58695),
     /*  42615 */ /*GILLT_s1*//*Label 402*/ GIMT_Encode4(42655),
     /*  42619 */ /*GILLT_s16*//*Label 403*/ GIMT_Encode4(42718),
     /*  42623 */ /*GILLT_s32*//*Label 404*/ GIMT_Encode4(42958),
     /*  42627 */ /*GILLT_s64*//*Label 405*/ GIMT_Encode4(48635),
     /*  42631 */ /*GILLT_v2s16*//*Label 406*/ GIMT_Encode4(58280),
     /*  42635 */ /*GILLT_v2s32*//*Label 407*/ GIMT_Encode4(58431), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  42651 */ /*GILLT_v4s16*//*Label 408*/ GIMT_Encode4(58572),
     /*  42655 */ // Label 402: @42655
     /*  42655 */ GIM_Try, /*On fail goto*//*Label 410*/ GIMT_Encode4(42717),
     /*  42660 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
     /*  42663 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
     /*  42666 */   GIM_Try, /*On fail goto*//*Label 411*/ GIMT_Encode4(42691), // Rule ID 8219 //
     /*  42671 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
     /*  42674 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  42678 */     // (or:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_OR_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
     /*  42678 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_OR_B64),
     /*  42683 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  42689 */     GIR_RootConstrainSelectedInstOperands,
     /*  42690 */     // GIR_Coverage, 8219,
     /*  42690 */     GIR_Done,
     /*  42691 */   // Label 411: @42691
     /*  42691 */   GIM_Try, /*On fail goto*//*Label 412*/ GIMT_Encode4(42716), // Rule ID 8226 //
     /*  42696 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
     /*  42699 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  42703 */     // (or:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_OR_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
     /*  42703 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_OR_B32),
     /*  42708 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  42714 */     GIR_RootConstrainSelectedInstOperands,
     /*  42715 */     // GIR_Coverage, 8226,
     /*  42715 */     GIR_Done,
     /*  42716 */   // Label 412: @42716
     /*  42716 */   GIM_Reject,
     /*  42717 */ // Label 410: @42717
     /*  42717 */ GIM_Reject,
     /*  42718 */ // Label 403: @42718
     /*  42718 */ GIM_Try, /*On fail goto*//*Label 413*/ GIMT_Encode4(42957),
     /*  42723 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
     /*  42726 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
     /*  42729 */   GIM_Try, /*On fail goto*//*Label 414*/ GIMT_Encode4(42780), // Rule ID 9323 //
     /*  42734 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  42738 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  42742 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  42746 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  42750 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  42754 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  42758 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16646),
     /*  42762 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  42764 */     // (or:{ *:[i16] } (xor:{ *:[i16] } i16:{ *:[i16] }:$src1, -1:{ *:[i16] }), i16:{ *:[i16] }:$src0)<<P:Predicate_anonymous_16646>>  =>  (S_ORN2_B32:{ *:[i16] }:{ *:[i1] } SSrc_b32:{ *:[i16] }:$src0, SSrc_b32:{ *:[i16] }:$src1)
     /*  42764 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ORN2_B32),
     /*  42767 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  42769 */     GIR_RootToRootCopy, /*OpIdx*/2, // src0
     /*  42771 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  42775 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  42778 */     GIR_RootConstrainSelectedInstOperands,
     /*  42779 */     // GIR_Coverage, 9323,
     /*  42779 */     GIR_EraseRootFromParent_Done,
     /*  42780 */   // Label 414: @42780
     /*  42780 */   GIM_Try, /*On fail goto*//*Label 415*/ GIMT_Encode4(42831), // Rule ID 1988 //
     /*  42785 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  42789 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  42793 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  42797 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  42801 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  42805 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  42809 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_16646),
     /*  42813 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  42815 */     // (or:{ *:[i16] } i16:{ *:[i16] }:$src0, (xor:{ *:[i16] } i16:{ *:[i16] }:$src1, -1:{ *:[i16] }))<<P:Predicate_anonymous_16646>>  =>  (S_ORN2_B32:{ *:[i16] }:{ *:[i1] } SSrc_b32:{ *:[i16] }:$src0, SSrc_b32:{ *:[i16] }:$src1)
     /*  42815 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ORN2_B32),
     /*  42818 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  42820 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  42822 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  42826 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  42829 */     GIR_RootConstrainSelectedInstOperands,
     /*  42830 */     // GIR_Coverage, 1988,
     /*  42830 */     GIR_EraseRootFromParent_Done,
     /*  42831 */   // Label 415: @42831
     /*  42831 */   GIM_Try, /*On fail goto*//*Label 416*/ GIMT_Encode4(42854), // Rule ID 2637 //
     /*  42836 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotHasTrue16BitInsts),
     /*  42839 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42843 */     // (or:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_OR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i16] }:$src0, VSrc_b32:{ *:[i16] }:$src1)
     /*  42843 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_OR_B32_e64),
     /*  42848 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  42852 */     GIR_RootConstrainSelectedInstOperands,
     /*  42853 */     // GIR_Coverage, 2637,
     /*  42853 */     GIR_Done,
     /*  42854 */   // Label 416: @42854
     /*  42854 */   GIM_Try, /*On fail goto*//*Label 417*/ GIMT_Encode4(42877), // Rule ID 2640 //
     /*  42859 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts),
     /*  42862 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42866 */     // (or:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_OR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i16] }:$src0, VSrc_b32:{ *:[i16] }:$src1)
     /*  42866 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_OR_B32_e64),
     /*  42871 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  42875 */     GIR_RootConstrainSelectedInstOperands,
     /*  42876 */     // GIR_Coverage, 2640,
     /*  42876 */     GIR_Done,
     /*  42877 */   // Label 417: @42877
     /*  42877 */   GIM_Try, /*On fail goto*//*Label 418*/ GIMT_Encode4(42933), // Rule ID 940 //
     /*  42882 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX11Plus),
     /*  42885 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
     /*  42889 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  42896 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  42903 */     // (or:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_OR_B16_t16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  42903 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_OR_B16_t16_e64),
     /*  42906 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  42908 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  42913 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  42918 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  42923 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  42928 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  42931 */     GIR_RootConstrainSelectedInstOperands,
     /*  42932 */     // GIR_Coverage, 940,
     /*  42932 */     GIR_EraseRootFromParent_Done,
     /*  42933 */   // Label 418: @42933
     /*  42933 */   GIM_Try, /*On fail goto*//*Label 419*/ GIMT_Encode4(42956), // Rule ID 941 //
     /*  42938 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX11Plus),
     /*  42941 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42945 */     // (or:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_OR_B16_fake16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
     /*  42945 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_OR_B16_fake16_e64),
     /*  42950 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  42954 */     GIR_RootConstrainSelectedInstOperands,
     /*  42955 */     // GIR_Coverage, 941,
     /*  42955 */     GIR_Done,
     /*  42956 */   // Label 419: @42956
     /*  42956 */   GIM_Reject,
     /*  42957 */ // Label 413: @42957
     /*  42957 */ GIM_Reject,
     /*  42958 */ // Label 404: @42958
     /*  42958 */ GIM_Try, /*On fail goto*//*Label 420*/ GIMT_Encode4(48634),
     /*  42963 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  42966 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  42969 */   GIM_Try, /*On fail goto*//*Label 421*/ GIMT_Encode4(43150), // Rule ID 9358 //
     /*  42974 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAshrPkInsts),
     /*  42977 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42981 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  42985 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  42989 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  42993 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  42997 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  43001 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
     /*  43005 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  43009 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  43013 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  43017 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  43021 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  43025 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  43029 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  43033 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 128,
     /*  43037 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/3, 127,
     /*  43041 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(255),
     /*  43052 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  43056 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  43060 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  43064 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  43068 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  43072 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
     /*  43076 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  43080 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  43084 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  43088 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  43092 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  43096 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  43100 */     // MIs[6] src2
     /*  43100 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  43105 */     GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 128,
     /*  43109 */     GIM_CheckConstantInt8, /*MI*/5, /*Op*/3, 127,
     /*  43113 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 8,
     /*  43117 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  43119 */     // (or:{ *:[i32] } (and:{ *:[i32] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src2), -128:{ *:[i32] }, 127:{ *:[i32] }), 255:{ *:[i32] }), (shl:{ *:[i32] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2), -128:{ *:[i32] }, 127:{ *:[i32] }), 8:{ *:[i32] }))  =>  (V_ASHR_PK_I8_I32_e64:{ *:[i32] } 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src0, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src1, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src2, 0:{ *:[i32] })
     /*  43119 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ASHR_PK_I8_I32_e64),
     /*  43122 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  43124 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  43127 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src0
     /*  43131 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  43134 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  43138 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  43141 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // src2
     /*  43145 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  43148 */     GIR_RootConstrainSelectedInstOperands,
     /*  43149 */     // GIR_Coverage, 9358,
     /*  43149 */     GIR_EraseRootFromParent_Done,
     /*  43150 */   // Label 421: @43150
     /*  43150 */   GIM_Try, /*On fail goto*//*Label 422*/ GIMT_Encode4(43331), // Rule ID 2864 //
     /*  43155 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAshrPkInsts),
     /*  43158 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43162 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  43166 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  43170 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  43174 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  43178 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  43182 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
     /*  43186 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  43190 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  43194 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  43198 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  43202 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  43206 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  43210 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  43214 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 128,
     /*  43218 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/3, 127,
     /*  43222 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 8,
     /*  43226 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  43230 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43234 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  43238 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  43242 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  43246 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
     /*  43250 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  43254 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  43258 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  43262 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  43266 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  43270 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  43274 */     // MIs[6] src2
     /*  43274 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  43279 */     GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 128,
     /*  43283 */     GIM_CheckConstantInt8, /*MI*/5, /*Op*/3, 127,
     /*  43287 */     GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(255),
     /*  43298 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  43300 */     // (or:{ *:[i32] } (shl:{ *:[i32] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2), -128:{ *:[i32] }, 127:{ *:[i32] }), 8:{ *:[i32] }), (and:{ *:[i32] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src2), -128:{ *:[i32] }, 127:{ *:[i32] }), 255:{ *:[i32] }))  =>  (V_ASHR_PK_I8_I32_e64:{ *:[i32] } 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src0, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src1, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src2, 0:{ *:[i32] })
     /*  43300 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ASHR_PK_I8_I32_e64),
     /*  43303 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  43305 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  43308 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src0
     /*  43312 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  43315 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  43319 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  43322 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // src2
     /*  43326 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  43329 */     GIR_RootConstrainSelectedInstOperands,
     /*  43330 */     // GIR_Coverage, 2864,
     /*  43330 */     GIR_EraseRootFromParent_Done,
     /*  43331 */   // Label 422: @43331
     /*  43331 */   GIM_Try, /*On fail goto*//*Label 423*/ GIMT_Encode4(43499), // Rule ID 9359 //
     /*  43336 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAshrPkInsts),
     /*  43339 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43343 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  43347 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
     /*  43351 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  43355 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  43359 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  43363 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  43367 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  43371 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  43375 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  43379 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 0,
     /*  43383 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/3, GIMT_Encode8(255),
     /*  43394 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  43398 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  43402 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  43406 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  43410 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  43414 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
     /*  43418 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  43422 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  43426 */     GIM_CheckType, /*MI*/4, /*Op*/3, /*Type*/GILLT_s32,
     /*  43430 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  43434 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  43438 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  43442 */     // MIs[5] src2
     /*  43442 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  43447 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 0,
     /*  43451 */     GIM_CheckConstantInt, /*MI*/4, /*Op*/3, GIMT_Encode8(255),
     /*  43462 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 8,
     /*  43466 */     GIM_CheckIsSafeToFold, /*NumInsns*/5,
     /*  43468 */     // (or:{ *:[i32] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src2), 0:{ *:[i32] }, 255:{ *:[i32] }), (shl:{ *:[i32] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2), 0:{ *:[i32] }, 255:{ *:[i32] }), 8:{ *:[i32] }))  =>  (V_ASHR_PK_U8_I32_e64:{ *:[i32] } 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src0, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src1, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src2, 0:{ *:[i32] })
     /*  43468 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ASHR_PK_U8_I32_e64),
     /*  43471 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  43473 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  43476 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  43480 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  43483 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src1
     /*  43487 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  43490 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src2
     /*  43494 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  43497 */     GIR_RootConstrainSelectedInstOperands,
     /*  43498 */     // GIR_Coverage, 9359,
     /*  43498 */     GIR_EraseRootFromParent_Done,
     /*  43499 */   // Label 423: @43499
     /*  43499 */   GIM_Try, /*On fail goto*//*Label 424*/ GIMT_Encode4(43667), // Rule ID 2865 //
     /*  43504 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAshrPkInsts),
     /*  43507 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43511 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  43515 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  43519 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  43523 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  43527 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  43531 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
     /*  43535 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  43539 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  43543 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  43547 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  43551 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  43555 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  43559 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  43563 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 0,
     /*  43567 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/3, GIMT_Encode8(255),
     /*  43578 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 8,
     /*  43582 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  43586 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
     /*  43590 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  43594 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  43598 */     GIM_CheckType, /*MI*/4, /*Op*/3, /*Type*/GILLT_s32,
     /*  43602 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  43606 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  43610 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  43614 */     // MIs[5] src2
     /*  43614 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  43619 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 0,
     /*  43623 */     GIM_CheckConstantInt, /*MI*/4, /*Op*/3, GIMT_Encode8(255),
     /*  43634 */     GIM_CheckIsSafeToFold, /*NumInsns*/5,
     /*  43636 */     // (or:{ *:[i32] } (shl:{ *:[i32] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2), 0:{ *:[i32] }, 255:{ *:[i32] }), 8:{ *:[i32] }), (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src2), 0:{ *:[i32] }, 255:{ *:[i32] }))  =>  (V_ASHR_PK_U8_I32_e64:{ *:[i32] } 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src0, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src1, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src2, 0:{ *:[i32] })
     /*  43636 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ASHR_PK_U8_I32_e64),
     /*  43639 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  43641 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  43644 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  43648 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  43651 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  43655 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  43658 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // src2
     /*  43662 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  43665 */     GIR_RootConstrainSelectedInstOperands,
     /*  43666 */     // GIR_Coverage, 2865,
     /*  43666 */     GIR_EraseRootFromParent_Done,
     /*  43667 */   // Label 424: @43667
     /*  43667 */   GIM_Try, /*On fail goto*//*Label 425*/ GIMT_Encode4(43814), // Rule ID 12018 //
     /*  43672 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43676 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  43680 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43684 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  43688 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  43692 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  43696 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  43700 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  43704 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  43708 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 255,
     /*  43712 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  43716 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43720 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  43724 */     // MIs[3] x
     /*  43724 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  43729 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23048),
     /*  43733 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  43735 */     // (or:{ *:[i32] } (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] }), i32:{ *:[i32] }:$z), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_23048>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
     /*  43735 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  43738 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43742 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43747 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // z
     /*  43751 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43756 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  43759 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43763 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43768 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/3, /*OpIdx*/2, // y
     /*  43772 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43777 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  43780 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43784 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43789 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
     /*  43793 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43798 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  43801 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  43803 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  43806 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  43809 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
     /*  43812 */     GIR_RootConstrainSelectedInstOperands,
     /*  43813 */     // GIR_Coverage, 12018,
     /*  43813 */     GIR_EraseRootFromParent_Done,
     /*  43814 */   // Label 425: @43814
     /*  43814 */   GIM_Try, /*On fail goto*//*Label 426*/ GIMT_Encode4(43961), // Rule ID 12017 //
     /*  43819 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43823 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  43827 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43831 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  43835 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  43839 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  43843 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  43847 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  43851 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  43855 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 255,
     /*  43859 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  43863 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43867 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  43871 */     // MIs[3] x
     /*  43871 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  43876 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23048),
     /*  43880 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  43882 */     // (or:{ *:[i32] } (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] }), i32:{ *:[i32] }:$z), (and:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_23048>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
     /*  43882 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  43885 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43889 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43894 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // z
     /*  43898 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43903 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  43906 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43910 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43915 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/3, /*OpIdx*/1, // y
     /*  43919 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43924 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  43927 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43931 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43936 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
     /*  43940 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43945 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  43948 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  43950 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  43953 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  43956 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
     /*  43959 */     GIR_RootConstrainSelectedInstOperands,
     /*  43960 */     // GIR_Coverage, 12017,
     /*  43960 */     GIR_EraseRootFromParent_Done,
     /*  43961 */   // Label 426: @43961
     /*  43961 */   GIM_Try, /*On fail goto*//*Label 427*/ GIMT_Encode4(44108), // Rule ID 12016 //
     /*  43966 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43970 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  43974 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43978 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  43982 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  43986 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  43990 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  43994 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  43998 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  44002 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 255,
     /*  44006 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  44010 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44014 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  44018 */     // MIs[3] x
     /*  44018 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  44023 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23048),
     /*  44027 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  44029 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_23048>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
     /*  44029 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  44032 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44036 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44041 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // z
     /*  44045 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44050 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  44053 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44057 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44062 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/3, /*OpIdx*/2, // y
     /*  44066 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44071 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  44074 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44078 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44083 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
     /*  44087 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44092 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  44095 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  44097 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  44100 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  44103 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
     /*  44106 */     GIR_RootConstrainSelectedInstOperands,
     /*  44107 */     // GIR_Coverage, 12016,
     /*  44107 */     GIR_EraseRootFromParent_Done,
     /*  44108 */   // Label 427: @44108
     /*  44108 */   GIM_Try, /*On fail goto*//*Label 428*/ GIMT_Encode4(44255), // Rule ID 12015 //
     /*  44113 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44117 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  44121 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44125 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  44129 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  44133 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  44137 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  44141 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  44145 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  44149 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 255,
     /*  44153 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  44157 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44161 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  44165 */     // MIs[3] x
     /*  44165 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  44170 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23048),
     /*  44174 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  44176 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })), (and:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_23048>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
     /*  44176 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  44179 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44183 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44188 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // z
     /*  44192 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44197 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  44200 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44204 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44209 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/3, /*OpIdx*/1, // y
     /*  44213 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44218 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  44221 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44225 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44230 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
     /*  44234 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44239 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  44242 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  44244 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  44247 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  44250 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
     /*  44253 */     GIR_RootConstrainSelectedInstOperands,
     /*  44254 */     // GIR_Coverage, 12015,
     /*  44254 */     GIR_EraseRootFromParent_Done,
     /*  44255 */   // Label 428: @44255
     /*  44255 */   GIM_Try, /*On fail goto*//*Label 429*/ GIMT_Encode4(44402), // Rule ID 12012 //
     /*  44260 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44264 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  44268 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44272 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  44276 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  44280 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  44284 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44288 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  44292 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  44296 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  44300 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  44304 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  44308 */     // MIs[3] x
     /*  44308 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  44313 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 255,
     /*  44317 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23048),
     /*  44321 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  44323 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$x), (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] }), i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_23048>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
     /*  44323 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  44326 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44330 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44335 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // z
     /*  44339 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44344 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  44347 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44351 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44356 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  44360 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44365 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  44368 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44372 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44377 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // x
     /*  44381 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44386 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  44389 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  44391 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  44394 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  44397 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
     /*  44400 */     GIR_RootConstrainSelectedInstOperands,
     /*  44401 */     // GIR_Coverage, 12012,
     /*  44401 */     GIR_EraseRootFromParent_Done,
     /*  44402 */   // Label 429: @44402
     /*  44402 */   GIM_Try, /*On fail goto*//*Label 430*/ GIMT_Encode4(44549), // Rule ID 12014 //
     /*  44407 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44411 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  44415 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44419 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  44423 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  44427 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  44431 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44435 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  44439 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  44443 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  44447 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  44451 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  44455 */     // MIs[3] x
     /*  44455 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  44460 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 255,
     /*  44464 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23048),
     /*  44468 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  44470 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] }), i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_23048>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
     /*  44470 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  44473 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44477 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44482 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // z
     /*  44486 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44491 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  44494 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44498 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44503 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  44507 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44512 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  44515 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44519 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44524 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // x
     /*  44528 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44533 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  44536 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  44538 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  44541 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  44544 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
     /*  44547 */     GIR_RootConstrainSelectedInstOperands,
     /*  44548 */     // GIR_Coverage, 12014,
     /*  44548 */     GIR_EraseRootFromParent_Done,
     /*  44549 */   // Label 430: @44549
     /*  44549 */   GIM_Try, /*On fail goto*//*Label 431*/ GIMT_Encode4(44696), // Rule ID 8115 //
     /*  44554 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44558 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  44562 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44566 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  44570 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  44574 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  44578 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44582 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  44586 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  44590 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  44594 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  44598 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  44602 */     // MIs[3] x
     /*  44602 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  44607 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 255,
     /*  44611 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23048),
     /*  44615 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  44617 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$x), (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })))<<P:Predicate_anonymous_23048>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
     /*  44617 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  44620 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44624 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44629 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, // z
     /*  44633 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44638 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  44641 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44645 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44650 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  44654 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44659 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  44662 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44666 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44671 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // x
     /*  44675 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44680 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  44683 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  44685 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  44688 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  44691 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
     /*  44694 */     GIR_RootConstrainSelectedInstOperands,
     /*  44695 */     // GIR_Coverage, 8115,
     /*  44695 */     GIR_EraseRootFromParent_Done,
     /*  44696 */   // Label 431: @44696
     /*  44696 */   GIM_Try, /*On fail goto*//*Label 432*/ GIMT_Encode4(44843), // Rule ID 12013 //
     /*  44701 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44705 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  44709 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44713 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  44717 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  44721 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  44725 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44729 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  44733 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  44737 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  44741 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  44745 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  44749 */     // MIs[3] x
     /*  44749 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  44754 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 255,
     /*  44758 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23048),
     /*  44762 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  44764 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })))<<P:Predicate_anonymous_23048>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
     /*  44764 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  44767 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44771 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44776 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, // z
     /*  44780 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44785 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  44788 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44792 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44797 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  44801 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44806 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  44809 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44813 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44818 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // x
     /*  44822 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44827 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  44830 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  44832 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  44835 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  44838 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
     /*  44841 */     GIR_RootConstrainSelectedInstOperands,
     /*  44842 */     // GIR_Coverage, 12013,
     /*  44842 */     GIR_EraseRootFromParent_Done,
     /*  44843 */   // Label 432: @44843
     /*  44843 */   GIM_Try, /*On fail goto*//*Label 433*/ GIMT_Encode4(44936), // Rule ID 2733 //
     /*  44848 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  44851 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44855 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  44859 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  44863 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  44867 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  44871 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  44873 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:5:x
     /*  44877 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  44881 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44885 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  44889 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  44893 */     GIM_RecordNamedOperand, /*MI*/2, /*Op*/1, /*StoreIdx*/1, // Name : pred:5:y
     /*  44897 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  44901 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  44905 */     // MIs[3] Operand 1
     /*  44905 */     // No operand predicates
     /*  44905 */     GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_csh_mask_32),
     /*  44909 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:5:z
     /*  44913 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24390),
     /*  44917 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  44919 */     // (or:{ *:[i32] } (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:5:x, (and:{ *:[i32] } i32:{ *:[i32] }:$src1:$pred:5:y, (imm:{ *:[i32] }))<<P:Predicate_csh_mask_32>>)<<P:Predicate_anonymous_24380>>, i32:{ *:[i32] }:$src2:$pred:5:z)<<P:5:Predicate_anonymous_24390>>  =>  (V_LSHL_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  44919 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_OR_B32_e64),
     /*  44922 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  44924 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  44928 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  44932 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  44934 */     GIR_RootConstrainSelectedInstOperands,
     /*  44935 */     // GIR_Coverage, 2733,
     /*  44935 */     GIR_EraseRootFromParent_Done,
     /*  44936 */   // Label 433: @44936
     /*  44936 */   GIM_Try, /*On fail goto*//*Label 434*/ GIMT_Encode4(45029), // Rule ID 9338 //
     /*  44941 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  44944 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44948 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:5:z
     /*  44952 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  44956 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  44960 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  44964 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  44968 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  44970 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:5:x
     /*  44974 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  44978 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44982 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  44986 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  44990 */     GIM_RecordNamedOperand, /*MI*/2, /*Op*/1, /*StoreIdx*/1, // Name : pred:5:y
     /*  44994 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  44998 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  45002 */     // MIs[3] Operand 1
     /*  45002 */     // No operand predicates
     /*  45002 */     GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_csh_mask_32),
     /*  45006 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_24390),
     /*  45010 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  45012 */     // (or:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:5:z, (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:5:x, (and:{ *:[i32] } i32:{ *:[i32] }:$src1:$pred:5:y, (imm:{ *:[i32] }))<<P:Predicate_csh_mask_32>>)<<P:Predicate_anonymous_24380>>)<<P:5:Predicate_anonymous_24390>>  =>  (V_LSHL_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  45012 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_OR_B32_e64),
     /*  45015 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  45017 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  45021 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  45025 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  45027 */     GIR_RootConstrainSelectedInstOperands,
     /*  45028 */     // GIR_Coverage, 9338,
     /*  45028 */     GIR_EraseRootFromParent_Done,
     /*  45029 */   // Label 434: @45029
     /*  45029 */   GIM_Try, /*On fail goto*//*Label 435*/ GIMT_Encode4(45214), // Rule ID 12074 //
     /*  45034 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45038 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  45042 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45046 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  45050 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  45054 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  45058 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  45062 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  45066 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  45070 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  45074 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45078 */     // MIs[3] x
     /*  45078 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  45083 */     // MIs[3] z
     /*  45083 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  45088 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23048),
     /*  45092 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  45094 */     // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_23048>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  45094 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  45097 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45101 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45106 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  45110 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45115 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  45118 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45122 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45127 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, // z
     /*  45131 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45136 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  45139 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45143 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45148 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  45152 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45157 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  45160 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45164 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45169 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // x
     /*  45173 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45178 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  45181 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  45185 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45190 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  45193 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  45196 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  45198 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  45201 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  45203 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  45206 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  45209 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  45212 */     GIR_RootConstrainSelectedInstOperands,
     /*  45213 */     // GIR_Coverage, 12074,
     /*  45213 */     GIR_EraseRootFromParent_Done,
     /*  45214 */   // Label 435: @45214
     /*  45214 */   GIM_Try, /*On fail goto*//*Label 436*/ GIMT_Encode4(45399), // Rule ID 12075 //
     /*  45219 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45223 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  45227 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45231 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  45235 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  45239 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  45243 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  45247 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  45251 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  45255 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  45259 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45263 */     // MIs[3] z
     /*  45263 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  45268 */     // MIs[3] x
     /*  45268 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  45273 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23048),
     /*  45277 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  45279 */     // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_23048>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  45279 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  45282 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45286 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45291 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  45295 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45300 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  45303 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45307 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45312 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, // z
     /*  45316 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45321 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  45324 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45328 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45333 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  45337 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45342 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  45345 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45349 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45354 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // x
     /*  45358 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45363 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  45366 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  45370 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45375 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  45378 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  45381 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  45383 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  45386 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  45388 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  45391 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  45394 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  45397 */     GIR_RootConstrainSelectedInstOperands,
     /*  45398 */     // GIR_Coverage, 12075,
     /*  45398 */     GIR_EraseRootFromParent_Done,
     /*  45399 */   // Label 436: @45399
     /*  45399 */   GIM_Try, /*On fail goto*//*Label 437*/ GIMT_Encode4(45584), // Rule ID 12076 //
     /*  45404 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45408 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  45412 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45416 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  45420 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  45424 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  45428 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  45432 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  45436 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  45440 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  45444 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45448 */     // MIs[3] x
     /*  45448 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  45453 */     // MIs[3] z
     /*  45453 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  45458 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23048),
     /*  45462 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  45464 */     // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_23048>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  45464 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  45467 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45471 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45476 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  45480 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45485 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  45488 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45492 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45497 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, // z
     /*  45501 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45506 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  45509 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45513 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45518 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  45522 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45527 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  45530 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45534 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45539 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/2, // x
     /*  45543 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45548 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  45551 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  45555 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45560 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  45563 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  45566 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  45568 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  45571 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  45573 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  45576 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  45579 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  45582 */     GIR_RootConstrainSelectedInstOperands,
     /*  45583 */     // GIR_Coverage, 12076,
     /*  45583 */     GIR_EraseRootFromParent_Done,
     /*  45584 */   // Label 437: @45584
     /*  45584 */   GIM_Try, /*On fail goto*//*Label 438*/ GIMT_Encode4(45769), // Rule ID 12077 //
     /*  45589 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45593 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  45597 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45601 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  45605 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  45609 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  45613 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  45617 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  45621 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  45625 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  45629 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45633 */     // MIs[3] z
     /*  45633 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  45638 */     // MIs[3] x
     /*  45638 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  45643 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23048),
     /*  45647 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  45649 */     // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_23048>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  45649 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  45652 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45656 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45661 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  45665 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45670 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  45673 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45677 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45682 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, // z
     /*  45686 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45691 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  45694 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45698 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45703 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  45707 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45712 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  45715 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45719 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45724 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/2, // x
     /*  45728 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45733 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  45736 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  45740 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45745 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  45748 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  45751 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  45753 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  45756 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  45758 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  45761 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  45764 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  45767 */     GIR_RootConstrainSelectedInstOperands,
     /*  45768 */     // GIR_Coverage, 12077,
     /*  45768 */     GIR_EraseRootFromParent_Done,
     /*  45769 */   // Label 438: @45769
     /*  45769 */   GIM_Try, /*On fail goto*//*Label 439*/ GIMT_Encode4(45954), // Rule ID 12070 //
     /*  45774 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45778 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  45782 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45786 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  45790 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  45794 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  45798 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  45802 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  45806 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  45810 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  45814 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45818 */     // MIs[3] x
     /*  45818 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  45823 */     // MIs[3] z
     /*  45823 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  45828 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23048),
     /*  45832 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  45834 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_23048>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  45834 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  45837 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45841 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45846 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  45850 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45855 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  45858 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45862 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45867 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, // z
     /*  45871 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45876 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  45879 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45883 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45888 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  45892 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45897 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  45900 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45904 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45909 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // x
     /*  45913 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45918 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  45921 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  45925 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45930 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  45933 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  45936 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  45938 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  45941 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  45943 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  45946 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  45949 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  45952 */     GIR_RootConstrainSelectedInstOperands,
     /*  45953 */     // GIR_Coverage, 12070,
     /*  45953 */     GIR_EraseRootFromParent_Done,
     /*  45954 */   // Label 439: @45954
     /*  45954 */   GIM_Try, /*On fail goto*//*Label 440*/ GIMT_Encode4(46139), // Rule ID 12071 //
     /*  45959 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45963 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  45967 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45971 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  45975 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  45979 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  45983 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  45987 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  45991 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  45995 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  45999 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  46003 */     // MIs[3] z
     /*  46003 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  46008 */     // MIs[3] x
     /*  46008 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  46013 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23048),
     /*  46017 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  46019 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_23048>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  46019 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  46022 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46026 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46031 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  46035 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46040 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  46043 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46047 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46052 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, // z
     /*  46056 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46061 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  46064 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46068 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46073 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  46077 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46082 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  46085 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46089 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46094 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // x
     /*  46098 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46103 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  46106 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  46110 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46115 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  46118 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  46121 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  46123 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  46126 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  46128 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  46131 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  46134 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  46137 */     GIR_RootConstrainSelectedInstOperands,
     /*  46138 */     // GIR_Coverage, 12071,
     /*  46138 */     GIR_EraseRootFromParent_Done,
     /*  46139 */   // Label 440: @46139
     /*  46139 */   GIM_Try, /*On fail goto*//*Label 441*/ GIMT_Encode4(46324), // Rule ID 12072 //
     /*  46144 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46148 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  46152 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  46156 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  46160 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  46164 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  46168 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  46172 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  46176 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  46180 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  46184 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  46188 */     // MIs[3] x
     /*  46188 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  46193 */     // MIs[3] z
     /*  46193 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  46198 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23048),
     /*  46202 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  46204 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_23048>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  46204 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  46207 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46211 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46216 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  46220 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46225 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  46228 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46232 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46237 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, // z
     /*  46241 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46246 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  46249 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46253 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46258 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  46262 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46267 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  46270 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46274 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46279 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/2, // x
     /*  46283 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46288 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  46291 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  46295 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46300 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  46303 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  46306 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  46308 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  46311 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  46313 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  46316 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  46319 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  46322 */     GIR_RootConstrainSelectedInstOperands,
     /*  46323 */     // GIR_Coverage, 12072,
     /*  46323 */     GIR_EraseRootFromParent_Done,
     /*  46324 */   // Label 441: @46324
     /*  46324 */   GIM_Try, /*On fail goto*//*Label 442*/ GIMT_Encode4(46509), // Rule ID 12073 //
     /*  46329 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46333 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  46337 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  46341 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  46345 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  46349 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  46353 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  46357 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  46361 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  46365 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  46369 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  46373 */     // MIs[3] z
     /*  46373 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  46378 */     // MIs[3] x
     /*  46378 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  46383 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23048),
     /*  46387 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  46389 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_23048>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  46389 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  46392 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46396 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46401 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  46405 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46410 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  46413 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46417 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46422 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, // z
     /*  46426 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46431 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  46434 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46438 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46443 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  46447 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46452 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  46455 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46459 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46464 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/2, // x
     /*  46468 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46473 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  46476 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  46480 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46485 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  46488 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  46491 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  46493 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  46496 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  46498 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  46501 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  46504 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  46507 */     GIR_RootConstrainSelectedInstOperands,
     /*  46508 */     // GIR_Coverage, 12073,
     /*  46508 */     GIR_EraseRootFromParent_Done,
     /*  46509 */   // Label 442: @46509
     /*  46509 */   GIM_Try, /*On fail goto*//*Label 443*/ GIMT_Encode4(46694), // Rule ID 12064 //
     /*  46514 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46518 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  46522 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  46526 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  46530 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  46534 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  46538 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  46542 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  46546 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  46550 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  46554 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  46558 */     // MIs[3] x
     /*  46558 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  46563 */     // MIs[3] z
     /*  46563 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  46568 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23048),
     /*  46572 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  46574 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_23048>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  46574 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  46577 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46581 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46586 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, // y
     /*  46590 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46595 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  46598 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46602 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46607 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, // z
     /*  46611 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46616 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  46619 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46623 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46628 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // y
     /*  46632 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46637 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  46640 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46644 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46649 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // x
     /*  46653 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46658 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  46661 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  46665 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46670 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  46673 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  46676 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  46678 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  46681 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  46683 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  46686 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  46689 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  46692 */     GIR_RootConstrainSelectedInstOperands,
     /*  46693 */     // GIR_Coverage, 12064,
     /*  46693 */     GIR_EraseRootFromParent_Done,
     /*  46694 */   // Label 443: @46694
     /*  46694 */   GIM_Try, /*On fail goto*//*Label 444*/ GIMT_Encode4(46879), // Rule ID 12065 //
     /*  46699 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46703 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  46707 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  46711 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  46715 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  46719 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  46723 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  46727 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  46731 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  46735 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  46739 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  46743 */     // MIs[3] z
     /*  46743 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  46748 */     // MIs[3] x
     /*  46748 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  46753 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23048),
     /*  46757 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  46759 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_23048>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  46759 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  46762 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46766 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46771 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, // y
     /*  46775 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46780 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  46783 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46787 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46792 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, // z
     /*  46796 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46801 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  46804 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46808 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46813 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // y
     /*  46817 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46822 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  46825 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46829 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46834 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // x
     /*  46838 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46843 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  46846 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  46850 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46855 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  46858 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  46861 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  46863 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  46866 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  46868 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  46871 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  46874 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  46877 */     GIR_RootConstrainSelectedInstOperands,
     /*  46878 */     // GIR_Coverage, 12065,
     /*  46878 */     GIR_EraseRootFromParent_Done,
     /*  46879 */   // Label 444: @46879
     /*  46879 */   GIM_Try, /*On fail goto*//*Label 445*/ GIMT_Encode4(47064), // Rule ID 12068 //
     /*  46884 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46888 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  46892 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  46896 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  46900 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  46904 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  46908 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  46912 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  46916 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  46920 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  46924 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  46928 */     // MIs[3] x
     /*  46928 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  46933 */     // MIs[3] z
     /*  46933 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  46938 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23048),
     /*  46942 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  46944 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_23048>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  46944 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  46947 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46951 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46956 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, // y
     /*  46960 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46965 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  46968 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46972 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46977 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, // z
     /*  46981 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46986 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  46989 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46993 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46998 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // y
     /*  47002 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  47007 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  47010 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  47014 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  47019 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // x
     /*  47023 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  47028 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  47031 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  47035 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  47040 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  47043 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  47046 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  47048 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  47051 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  47053 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  47056 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  47059 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  47062 */     GIR_RootConstrainSelectedInstOperands,
     /*  47063 */     // GIR_Coverage, 12068,
     /*  47063 */     GIR_EraseRootFromParent_Done,
     /*  47064 */   // Label 445: @47064
     /*  47064 */   GIM_Try, /*On fail goto*//*Label 446*/ GIMT_Encode4(47249), // Rule ID 12069 //
     /*  47069 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  47073 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  47077 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  47081 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  47085 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  47089 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  47093 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  47097 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  47101 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  47105 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  47109 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  47113 */     // MIs[3] z
     /*  47113 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  47118 */     // MIs[3] x
     /*  47118 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  47123 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_23048),
     /*  47127 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  47129 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_23048>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  47129 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  47132 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  47136 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  47141 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, // y
     /*  47145 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  47150 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  47153 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  47157 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  47162 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, // z
     /*  47166 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  47171 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  47174 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  47178 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  47183 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // y
     /*  47187 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  47192 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  47195 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  47199 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  47204 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // x
     /*  47208 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  47213 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  47216 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  47220 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  47225 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  47228 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  47231 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
    