/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* AttrDef Declarations                                                       *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_ATTRDEF_CLASSES
#undef GET_ATTRDEF_CLASSES


namespace mlir {
class AsmParser;
class AsmPrinter;
} // namespace mlir
namespace mlir {
namespace rock {
/// What operation should be used to write data to memory
class StoreMethodAttr;
/// What operation should be used for the reduction
class ReduceMethodAttr;
/// A coordinate transformation, that is, a component of a transform_map.
/// 
///         A transform_map is a way to describe affine maps between coordinate spaces
///         that easily allows one to "take their derivative" when emitting hot unrolled
///          loops and that simplifies the process of describing these mappings.
/// 
///         Each transform produces some number of upper dimensions from some
///         number of lower dimensions. A collection of transformation that covers a set
///         of upper and lower dimensions can be packaged into a transform_map,
///         at which point they specify an affine map between coordinate spaces.
/// 
///         Each transform is specified as an attribute with the form
///         ```
///           #rock.transform<Type{param1, param2} ["upper1", "upper2"] at [dim1, dim2] -> ["lower1", "lower2"] at [dim3, dim4]>
///         ```
///         where the params block may be omitted for transforms that don't take parameters.
/// 
///         The available transform types are
///         - PassThrough, which maps N lower dimensions to N upper dimensions
///             without changing the coordinates in those dimensions
///         - Pad{l1, r1, l2, r2, ..., lN, rN} Adds padding to N dimensions in the
///           transformed upper output. The parameters are the amount of padding to
///           add to the left and right of each dimension, concatenated
///         - Slice{b1, e1, b2, e2, ... bN, eN} Takes a slice of N dimensions
///           creating, for each upper dimension i, a dimension of size e_i - b_i where 0
///           in the upper layer maps to b_i in the lower layer
///         - Embed{c1, c2, ... cN} - Creates N upper dimensions from 1 lower dimension
///           with the map (d1, d2, ..., dN) -> (d1 * C1 + d2 * C2 + ... dN * cN)
///         - Unmerge{c1, c2, ..., cN} - Creates N upper dimensions as in Embed,
///           but uses the map (d1, d2, ..., dN) -> (dN + cN * (d_{N - 1} * (... d1)))
///         - Merge{c1, c2, ..., cN} - Combines N lower dimensions into 1 upper dimension
///           with the parameters holding the sizes of the lower dimensions.
///           This has the effect of concatentating the dimensions if they are consecutive
///         - AddDim{size} - Adds one upper dimension of the given size that does not
///           correspond to any lower dimension.
///         - Broadcast{c1, c2, ..., cN} - Broadcast lower dimensions of size
///           c1, c2, ... cN to upper dimensions whose size isn't (currently) recorded
///           in the parameters. Note that the upper dimension's length doesn't have to
///           evenly divide into the lower one.
///         - ConstDim{c1, l1, c2, l2, .. cN, lN} an operator that sets the lower
///           dimensions of length l1, ... lN to the values c1, ..., cN. It takes no
///           input arguments.
class TransformAttr;
/// A package of a series of coordinate transformation descriptions
///         that completely defines how to map from some upper dimensions P
///         to some other lower dimensions Q.
/// 
///         Comes packaged with an affine map describing the transformation and upper and lowr bounds;
class TransformMapAttr;
/// The tuning parameters for a general (no special instructions) matrix
///     multiplication.
/// 
///     - blockSize: Optional parameter to specify the block size of the kernel
///     - kPerBlock: The number of values of k to process during each main loop
///       iteration within a workgroup
///     - mPerBlock: The number of values of m to process in each workgroup
///     - nPerBlock: The number of values of n to process in each workgroup
///     - kPerThread: The number of values of k to process as a unit on each thread
///     - mPerThread: The number of values of m to process as a unit on each thread
///     - nPerThread: The number of values of n to process as a unit on each thread
///     - kpack: The number of values of k to pack contiguously into the shared buffer
///     - splitKFactor:  Split-k factor for the Split-k GEMM algorithm
///     - scheduleVersion: Param to select GEMM schedule
///     - outputSwizzle: Whether to enable/disable output swizzle or use heuristics
class GeneralGemmParamsAttr;
/// The perf configs for rock.attention operator.
class AttnPerfConfigAttr;
/// The tuning parameters for an xdlops-based matrix multiplication.
class XdlopsGemmParamsAttr;
/// The tuning parameters for an xdlops-based matrix multiplication.
class XdlopsGemmDerivedParamsAttr;
/// The tuning parameters for an wmma-based matrix multiplication.
class WmmaGemmParamsAttr;
/// Features that can be enabled on GEMM-based operations
class GemmFeaturesAttr;
/// An attribute to express the properties of a loop to be pipelined
class PipelineAttr;
/// Attribute to express which GEMM Scheduling strategies a kernel lowering should use inside rocMLIR
class ScheduleVersionAttr;
class EnableSplitKForTuningAttr;
/// A user interface parameter for initializing specific memory buffers
/// 
///       The attribute is a way to describe which specific kernel parameter
///       (typically memref) must be initialized with specific value before
///       a kernel invocation.
class PrefillAttr;
namespace detail {
struct StoreMethodAttrStorage;
} // namespace detail
class StoreMethodAttr : public ::mlir::Attribute::AttrBase<StoreMethodAttr, ::mlir::Attribute, detail::StoreMethodAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "rock.StoreMethod";
  static constexpr ::llvm::StringLiteral dialectName = "rock";
  static StoreMethodAttr get(::mlir::MLIRContext *context, ::mlir::rock::StoreMethod value);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"StoreMethod"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  ::mlir::rock::StoreMethod getValue() const;
};
namespace detail {
struct ReduceMethodAttrStorage;
} // namespace detail
class ReduceMethodAttr : public ::mlir::Attribute::AttrBase<ReduceMethodAttr, ::mlir::Attribute, detail::ReduceMethodAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "rock.ReduceMethod";
  static constexpr ::llvm::StringLiteral dialectName = "rock";
  static ReduceMethodAttr get(::mlir::MLIRContext *context, ::mlir::rock::ReduceMethod value);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"ReduceMethod"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  ::mlir::rock::ReduceMethod getValue() const;
};
namespace detail {
struct TransformAttrStorage;
} // namespace detail
class TransformAttr : public ::mlir::Attribute::AttrBase<TransformAttr, ::mlir::Attribute, detail::TransformAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "rock.transform";
  static constexpr ::llvm::StringLiteral dialectName = "rock";
  using Base::getChecked;
  static TransformAttr get(::mlir::MLIRContext *context, ::mlir::rock::TransformType type, ::llvm::ArrayRef<int64_t> params, ::llvm::ArrayRef<::llvm::StringRef> upperNames, ::llvm::ArrayRef<uint32_t> upperDims, ::llvm::ArrayRef<::llvm::StringRef> lowerNames, ::llvm::ArrayRef<uint32_t> lowerDims);
  static TransformAttr getChecked(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::mlir::MLIRContext *context, ::mlir::rock::TransformType type, ::llvm::ArrayRef<int64_t> params, ::llvm::ArrayRef<::llvm::StringRef> upperNames, ::llvm::ArrayRef<uint32_t> upperDims, ::llvm::ArrayRef<::llvm::StringRef> lowerNames, ::llvm::ArrayRef<uint32_t> lowerDims);
  static ::llvm::LogicalResult verify(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::mlir::rock::TransformType type, ::llvm::ArrayRef<int64_t> params, ::llvm::ArrayRef<::llvm::StringRef> upperNames, ::llvm::ArrayRef<uint32_t> upperDims, ::llvm::ArrayRef<::llvm::StringRef> lowerNames, ::llvm::ArrayRef<uint32_t> lowerDims);
  static ::llvm::LogicalResult verifyInvariants(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::mlir::rock::TransformType type, ::llvm::ArrayRef<int64_t> params, ::llvm::ArrayRef<::llvm::StringRef> upperNames, ::llvm::ArrayRef<uint32_t> upperDims, ::llvm::ArrayRef<::llvm::StringRef> lowerNames, ::llvm::ArrayRef<uint32_t> lowerDims);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"transform"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  ::mlir::rock::TransformType getType() const;
  ::llvm::ArrayRef<int64_t> getParams() const;
  ::llvm::ArrayRef<::llvm::StringRef> getUpperNames() const;
  ::llvm::ArrayRef<uint32_t> getUpperDims() const;
  ::llvm::ArrayRef<::llvm::StringRef> getLowerNames() const;
  ::llvm::ArrayRef<uint32_t> getLowerDims() const;
};
namespace detail {
struct TransformMapAttrStorage;
} // namespace detail
class TransformMapAttr : public ::mlir::Attribute::AttrBase<TransformMapAttr, ::mlir::Attribute, detail::TransformMapAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "rock.transform_map";
  static constexpr ::llvm::StringLiteral dialectName = "rock";
  using Base::getChecked;
  static TransformMapAttr get(::mlir::MLIRContext *context, ::llvm::ArrayRef<::mlir::rock::TransformAttr> ops, AffineMapAttr map, DenseI64ArrayAttr upperBounds, DenseI64ArrayAttr lowerBounds);
  static TransformMapAttr getChecked(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::mlir::MLIRContext *context, ::llvm::ArrayRef<::mlir::rock::TransformAttr> ops, AffineMapAttr map, DenseI64ArrayAttr upperBounds, DenseI64ArrayAttr lowerBounds);
  static TransformMapAttr get(ArrayRef<::mlir::rock::TransformAttr> transforms, ArrayRef<int64_t> upperBounds, ArrayRef<int64_t> lowerBounds);
  static TransformMapAttr getChecked(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ArrayRef<::mlir::rock::TransformAttr> transforms, ArrayRef<int64_t> upperBounds, ArrayRef<int64_t> lowerBounds);
  static ::llvm::LogicalResult verify(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::llvm::ArrayRef<::mlir::rock::TransformAttr> ops, AffineMapAttr map, DenseI64ArrayAttr upperBounds, DenseI64ArrayAttr lowerBounds);
  static ::llvm::LogicalResult verifyInvariants(::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError, ::llvm::ArrayRef<::mlir::rock::TransformAttr> ops, AffineMapAttr map, DenseI64ArrayAttr upperBounds, DenseI64ArrayAttr lowerBounds);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"transform_map"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  ::llvm::ArrayRef<::mlir::rock::TransformAttr> getOps() const;
  AffineMapAttr getMap() const;
  DenseI64ArrayAttr getUpperBounds() const;
  DenseI64ArrayAttr getLowerBounds() const;
};
namespace detail {
struct GeneralGemmParamsAttrStorage;
} // namespace detail
class GeneralGemmParamsAttr : public ::mlir::Attribute::AttrBase<GeneralGemmParamsAttr, ::mlir::Attribute, detail::GeneralGemmParamsAttrStorage, ::mlir::rock::RockTuningParamAttrInterface::Trait> {
public:
  using Base::Base;
  void getPerfConfigStr(::llvm::SmallVectorImpl<char> &perfStr) {
    ("v3:" + Twine(getBlockSize()) + ","
    + Twine(getMPerBlock()) + ","
    + Twine(getNPerBlock()) + ","
    + Twine(getKPerBlock()) + ","
    + Twine(getMPerThread()) + ","
    + Twine(getNPerThread()) + ","
    + Twine(getSplitKFactor()) + ","
    + Twine(getScheduleVersion()) + ","
    + Twine(getOutputSwizzle())) 
    .toVector(perfStr);
  }
  bool getForceUnroll() { return true; }
  static constexpr ::llvm::StringLiteral name = "rock.general_gemm_params";
  static constexpr ::llvm::StringLiteral dialectName = "rock";
  static GeneralGemmParamsAttr get(::mlir::MLIRContext *context, uint32_t blockSize, int64_t kPerBlock, int64_t mPerBlock, int64_t nPerBlock, int64_t kPerThread, int64_t mPerThread, int64_t nPerThread, int64_t kpack, int64_t splitKFactor, int64_t scheduleVersion, int64_t outputSwizzle);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"general_gemm_params"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  uint32_t getBlockSize() const;
  int64_t getKPerBlock() const;
  int64_t getMPerBlock() const;
  int64_t getNPerBlock() const;
  int64_t getKPerThread() const;
  int64_t getMPerThread() const;
  int64_t getNPerThread() const;
  int64_t getKpack() const;
  int64_t getSplitKFactor() const;
  int64_t getScheduleVersion() const;
  int64_t getOutputSwizzle() const;
};
namespace detail {
struct AttnPerfConfigAttrStorage;
} // namespace detail
class AttnPerfConfigAttr : public ::mlir::Attribute::AttrBase<AttnPerfConfigAttr, ::mlir::Attribute, detail::AttnPerfConfigAttrStorage, ::mlir::rock::RockTuningParamAttrInterface::Trait> {
public:
  using Base::Base;
  void getPerfConfigStr(::llvm::SmallVectorImpl<char> &perfStr) {
    ("attn:v2:"
    + Twine(getMPerBlockG0()) + ","
    + Twine(getMPerBlockG1()) + ","
    + Twine(getNPerBlockG0()) + ","
    + Twine(getKpackPerBlock()) + ","
    + Twine(getMPerWave()) + ","
    + Twine(getMnPerXdl()) + ","
    + Twine(getKpack()) + ","
    + Twine(getSplitKFactor()) + ","
    + Twine(getScheduleVersion()) + ","
    + Twine(getOutputSwizzle()) + ","
    + Twine(getForceUnroll())).toVector(perfStr);
  }
  static constexpr ::llvm::StringLiteral name = "rock.attn_perf_config";
  static constexpr ::llvm::StringLiteral dialectName = "rock";
  static AttnPerfConfigAttr get(::mlir::MLIRContext *context, int64_t mPerBlockG0, int64_t mPerBlockG1, int64_t nPerBlockG0, int64_t kpackPerBlock, int64_t mPerWave, int64_t mnPerXdl, int64_t kpack, int64_t splitKFactor, int64_t scheduleVersion, int64_t outputSwizzle, bool forceUnroll);
  static AttnPerfConfigAttr get(StringAttr perfConfigStr);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"attn_perf_config"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  int64_t getMPerBlockG0() const;
  int64_t getMPerBlockG1() const;
  int64_t getNPerBlockG0() const;
  int64_t getKpackPerBlock() const;
  int64_t getMPerWave() const;
  int64_t getMnPerXdl() const;
  int64_t getKpack() const;
  int64_t getSplitKFactor() const;
  int64_t getScheduleVersion() const;
  int64_t getOutputSwizzle() const;
  bool getForceUnroll() const;
};
namespace detail {
struct XdlopsGemmParamsAttrStorage;
} // namespace detail
class XdlopsGemmParamsAttr : public ::mlir::Attribute::AttrBase<XdlopsGemmParamsAttr, ::mlir::Attribute, detail::XdlopsGemmParamsAttrStorage, ::mlir::rock::RockTuningParamAttrInterface::Trait> {
public:
  using Base::Base;
  void getPerfConfigStr(::llvm::SmallVectorImpl<char> &perfStr) {
      ("v3:" + Twine(getMPerBlock()) + ","
      + Twine(getNPerBlock()) + ","
      + Twine(getKpackPerBlock()) + ","
      + Twine(getMPerWave()) + ","
      + Twine(getMnPerXdl()) + ","
      + Twine(getKpack()) + ","
      + Twine(getSplitKFactor()) + ","
      + Twine(getScheduleVersion()) + ","
      + Twine(getOutputSwizzle()) + ","
      + Twine(getForceUnroll()) + ","
        + "1") /* *ThreadCopyMore* */
      .toVector(perfStr);
  }
  static constexpr ::llvm::StringLiteral name = "rock.xdlops_gemm_params";
  static constexpr ::llvm::StringLiteral dialectName = "rock";
  static XdlopsGemmParamsAttr get(::mlir::MLIRContext *context, int64_t kpackPerBlock, int64_t mPerBlock, int64_t nPerBlock, int64_t kpack, int64_t mPerWave, int64_t mnPerXdl, int64_t splitKFactor, int64_t scheduleVersion, int64_t outputSwizzle, bool forceUnroll);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"xdlops_gemm_params"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  int64_t getKpackPerBlock() const;
  int64_t getMPerBlock() const;
  int64_t getNPerBlock() const;
  int64_t getKpack() const;
  int64_t getMPerWave() const;
  int64_t getMnPerXdl() const;
  int64_t getSplitKFactor() const;
  int64_t getScheduleVersion() const;
  int64_t getOutputSwizzle() const;
  bool getForceUnroll() const;
};
namespace detail {
struct XdlopsGemmDerivedParamsAttrStorage;
} // namespace detail
class XdlopsGemmDerivedParamsAttr : public ::mlir::Attribute::AttrBase<XdlopsGemmDerivedParamsAttr, ::mlir::Attribute, detail::XdlopsGemmDerivedParamsAttrStorage, ::mlir::rock::RockTuningParamAttrInterface::Trait, ::mlir::rock::RockAccelTuningParamAttrInterface::Trait> {
public:
  using Base::Base;
  void getPerfConfigStr(::llvm::SmallVectorImpl<char> &perfStr) {
      ("v3:" + Twine(getMPerBlock()) + ","
      + Twine(getNPerBlock()) + ","
      + Twine(getKpackPerBlock()) + ","
      + Twine(getMPerWave()) + ","
      + Twine(getNPerWave()) + ","
      + Twine(getKpack()) + ","
      + Twine(getSplitKFactor()) + ","
      + Twine(getScheduleVersion()) + ","
      + Twine(getOutputSwizzle()) + ","
      + Twine(getForceUnroll()) + ","
        + "1") /* *ThreadCopyMore* */
      .toVector(perfStr);
  }
  static constexpr ::llvm::StringLiteral name = "rock.xdlops_gemm_derived_params";
  static constexpr ::llvm::StringLiteral dialectName = "rock";
  static XdlopsGemmDerivedParamsAttr get(::mlir::MLIRContext *context, int64_t kpackPerBlock, int64_t mPerBlock, int64_t nPerBlock, int64_t kpack, int64_t mPerWave, int64_t nPerWave, int64_t mnPerXdl, int64_t splitKFactor, int64_t scheduleVersion, int64_t outputSwizzle, bool forceUnroll);
  static XdlopsGemmDerivedParamsAttr get(XdlopsGemmParamsAttr params);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"xdlops_gemm_derived_params"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  int64_t getKpackPerBlock() const;
  int64_t getMPerBlock() const;
  int64_t getNPerBlock() const;
  int64_t getKpack() const;
  int64_t getMPerWave() const;
  int64_t getNPerWave() const;
  int64_t getMnPerXdl() const;
  int64_t getSplitKFactor() const;
  int64_t getScheduleVersion() const;
  int64_t getOutputSwizzle() const;
  bool getForceUnroll() const;
};
namespace detail {
struct WmmaGemmParamsAttrStorage;
} // namespace detail
class WmmaGemmParamsAttr : public ::mlir::Attribute::AttrBase<WmmaGemmParamsAttr, ::mlir::Attribute, detail::WmmaGemmParamsAttrStorage, ::mlir::rock::RockTuningParamAttrInterface::Trait, ::mlir::rock::RockAccelTuningParamAttrInterface::Trait> {
public:
  using Base::Base;
  void getPerfConfigStr(SmallVectorImpl<char> &perfStr) {
      ("v3:" +  Twine(getMPerBlock()) + ","
      + Twine(getNPerBlock()) + ","
      + Twine(getKpackPerBlock()) + ","
      + Twine(getMPerWave()) + ","
      + Twine(getNPerWave()) + ","
      + Twine(getKpack()) + ","
      + Twine(getSplitKFactor()) + ","
      + Twine(getScheduleVersion()) + ","
      + Twine(getOutputSwizzle()) + ","
      + Twine(getForceUnroll()) + ","
        + "1") /* *ThreadCopyMore* */
      .toVector(perfStr);
  }
  static constexpr ::llvm::StringLiteral name = "rock.wmma_gemm_params";
  static constexpr ::llvm::StringLiteral dialectName = "rock";
  static WmmaGemmParamsAttr get(::mlir::MLIRContext *context, int64_t kpackPerBlock, int64_t mPerBlock, int64_t nPerBlock, int64_t kpack, int64_t mPerWave, int64_t nPerWave, int64_t splitKFactor, int64_t scheduleVersion, int64_t outputSwizzle, bool forceUnroll);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"wmma_gemm_params"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  int64_t getKpackPerBlock() const;
  int64_t getMPerBlock() const;
  int64_t getNPerBlock() const;
  int64_t getKpack() const;
  int64_t getMPerWave() const;
  int64_t getNPerWave() const;
  int64_t getSplitKFactor() const;
  int64_t getScheduleVersion() const;
  int64_t getOutputSwizzle() const;
  bool getForceUnroll() const;
};
namespace detail {
struct GemmFeaturesAttrStorage;
} // namespace detail
class GemmFeaturesAttr : public ::mlir::Attribute::AttrBase<GemmFeaturesAttr, ::mlir::Attribute, detail::GemmFeaturesAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "rock.GemmFeatures";
  static constexpr ::llvm::StringLiteral dialectName = "rock";
  static GemmFeaturesAttr get(::mlir::MLIRContext *context, ::mlir::rock::GemmFeatures value);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"GemmFeatures"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  ::mlir::rock::GemmFeatures getValue() const;
};
namespace detail {
struct PipelineAttrStorage;
} // namespace detail
class PipelineAttr : public ::mlir::Attribute::AttrBase<PipelineAttr, ::mlir::Attribute, detail::PipelineAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "rock.pipeline";
  static constexpr ::llvm::StringLiteral dialectName = "rock";
  static PipelineAttr get(::mlir::MLIRContext *context, int64_t InitiationInterval);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"pipeline"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  int64_t getInitiationInterval() const;
};
namespace detail {
struct ScheduleVersionAttrStorage;
} // namespace detail
class ScheduleVersionAttr : public ::mlir::Attribute::AttrBase<ScheduleVersionAttr, ::mlir::Attribute, detail::ScheduleVersionAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "rock.schedule_version";
  static constexpr ::llvm::StringLiteral dialectName = "rock";
  static ScheduleVersionAttr get(::mlir::MLIRContext *context, int64_t ScheduleVersion);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"schedule_version"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  int64_t getScheduleVersion() const;
};
class EnableSplitKForTuningAttr : public ::mlir::Attribute::AttrBase<EnableSplitKForTuningAttr, ::mlir::Attribute, ::mlir::AttributeStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "rock.enable_splitk_for_tuning";
  static constexpr ::llvm::StringLiteral dialectName = "rock";
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"enable_splitk_for_tuning"};
  }

};
namespace detail {
struct PrefillAttrStorage;
} // namespace detail
class PrefillAttr : public ::mlir::Attribute::AttrBase<PrefillAttr, ::mlir::Attribute, detail::PrefillAttrStorage> {
public:
  using Base::Base;
  static constexpr ::llvm::StringLiteral name = "rock.rock.prefill";
  static constexpr ::llvm::StringLiteral dialectName = "rock";
  static PrefillAttr get(::mlir::MLIRContext *context, uint32_t argIndex, TypedAttr initValue);
  static constexpr ::llvm::StringLiteral getMnemonic() {
    return {"rock.prefill"};
  }

  static ::mlir::Attribute parse(::mlir::AsmParser &odsParser, ::mlir::Type odsType);
  void print(::mlir::AsmPrinter &odsPrinter) const;
  uint32_t getArgIndex() const;
  TypedAttr getInitValue() const;
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::StoreMethodAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::ReduceMethodAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::TransformAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::TransformMapAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::GeneralGemmParamsAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::AttnPerfConfigAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::XdlopsGemmParamsAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::XdlopsGemmDerivedParamsAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::WmmaGemmParamsAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::GemmFeaturesAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::PipelineAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::ScheduleVersionAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::EnableSplitKForTuningAttr)
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::PrefillAttr)

#endif  // GET_ATTRDEF_CLASSES

