/* Generated by nsgenbind
 *
 * nsgenbind is published under the MIT Licence.
 * nsgenbind is similar to a compiler is a purely transformative tool which
 * explicitly makes no copyright claim on this generated output
 */

/* DukTape JavaScript bindings for NetSurf browser
 *
 * Copyright 2015 Vincent Sanders <vince@netsurf-browser.org>
 * This file is part of NetSurf, http://www.netsurf-browser.org/
 * Released under the terms of the MIT License,
 *        http://www.opensource.org/licenses/mit-license
 */

#include <dom/dom.h>

#include "utils/log.h"
#include "utils/nsurl.h"

#include "javascript/duktape/duktape.h"

struct browser_window;
struct html_content;
struct dom_node;
struct dom_element;
struct dom_document;
struct dom_html_element;
struct dom_node_character_data;
struct dom_node_text;
struct dom_node_list;
struct dom_node_comment;
struct dom_html_collection;
struct dom_html_br_element;


#include "build/Linux-gtk3/duktape/binding.h"
#include "build/Linux-gtk3/duktape/private.h"
#include "build/Linux-gtk3/duktape/prototype.h"

#include "javascript/duktape/dukky.h"

void dukky_event___init(duk_context *ctx, event_private_t *priv, struct dom_event *evt)
{
#line 17 "Event.bnd"

	priv->evt = evt;
	dom_event_ref(evt);
#line 50 "event.c"
}

void dukky_event___fini(duk_context *ctx, event_private_t *priv)
{

	dom_event_unref(priv->evt);
}

static duk_ret_t dukky_event___constructor(duk_context *ctx)
{
	/* create private data and attach to instance */
	event_private_t *priv = calloc(1, sizeof(*priv));
	if (priv == NULL) return 0;
	duk_push_pointer(ctx, priv);
	duk_put_prop_string(ctx, 0, dukky_magic_string_private);

	dukky_event___init(ctx, priv, duk_get_pointer(ctx, 1));
	duk_set_top(ctx, 1);
	return 1;
}

static duk_ret_t dukky_event___destructor(duk_context *ctx)
{
	event_private_t *priv;
	duk_get_prop_string(ctx, 0, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop(ctx);
	if (priv == NULL) return 0;

	dukky_event___fini(ctx, priv);
	free(priv);
	return 0;
}

static duk_ret_t dukky_event_stopPropagation(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc > 0) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 0);
	}

	/* check types of passed arguments are correct */
	/* Get private data for method */
	event_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 90 "Event.bnd"

	dom_exception exc;

	exc = dom_event_stop_propagation(priv->evt);
	if (exc != DOM_NO_ERR) return 0;

	return 0;
#line 113 "event.c"
}

static duk_ret_t dukky_event_stopImmediatePropagation(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc > 0) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 0);
	}

	/* check types of passed arguments are correct */
	/* Get private data for method */
	event_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 100 "Event.bnd"

	dom_exception exc;

	exc = dom_event_stop_immediate_propagation(priv->evt);
	if (exc != DOM_NO_ERR) return 0;

	return 0;
#line 144 "event.c"
}

static duk_ret_t dukky_event_preventDefault(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc > 0) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 0);
	}

	/* check types of passed arguments are correct */
	/* Get private data for method */
	event_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 134 "Event.bnd"

	dom_exception exc;

	exc = dom_event_prevent_default(priv->evt);
	if (exc != DOM_NO_ERR) return 0;

	return 0;
#line 175 "event.c"
}

static duk_ret_t dukky_event_initEvent(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 3) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 3, dukky_argc);
	} else if (dukky_argc > 3) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 3);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	if (dukky_argc > 1) {
		if (!duk_is_boolean(ctx, 1)) {
			if (duk_is_number(ctx, 1)) {
				duk_to_boolean(ctx, 1);
			} else {
				return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_bool_type, 1, "bubbles");
			}
		}
	}
	if (dukky_argc > 2) {
		if (!duk_is_boolean(ctx, 2)) {
			if (duk_is_number(ctx, 2)) {
				duk_to_boolean(ctx, 2);
			} else {
				return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_bool_type, 2, "cancelable");
			}
		}
	}
	/* Get private data for method */
	event_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 169 "Event.bnd"

	dom_exception exc;
	bool bubbles;
	bool cancellable;

	duk_size_t text_len;
	const char *text = duk_safe_to_lstring(ctx, 0, &text_len);
	dom_string *text_str;

	exc = dom_string_create((const uint8_t*)text, text_len, &text_str);
	if (exc != DOM_NO_ERR) return 0; /* coerced to undefined */

	bubbles = duk_get_boolean(ctx, 1);
	cancellable = duk_get_boolean(ctx, 2);

	exc = dom_event_init(priv->evt, text_str, bubbles, cancellable);
	dom_string_unref(text_str);
	if (exc != DOM_NO_ERR) {
		return 0;
	}

	return 0;
#line 247 "event.c"
}

static duk_ret_t dukky_event_type_getter(duk_context *ctx)
{
	/* Get private data for method */
	event_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 30 "Event.bnd"

	dom_string *ret;
	dom_exception exc;

	exc = dom_event_get_type(priv->evt, &ret);
	if (exc != DOM_NO_ERR) return 0;
	if (ret == NULL) {
		duk_push_lstring(ctx, "", 0);
	} else {
		duk_push_lstring(ctx, dom_string_data(ret),
				dom_string_length(ret));
		dom_string_unref(ret);
	}

	return 1;
#line 278 "event.c"
}

static duk_ret_t dukky_event_target_getter(duk_context *ctx)
{
	/* Get private data for method */
	event_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 48 "Event.bnd"

	/** @todo Decide HTF this works wrt. Window as an event target */
	dom_node *et;
	dom_exception exc;

	exc = dom_event_get_target(priv->evt, &et);
	if (exc != DOM_NO_ERR) return 0;

	dukky_push_node(ctx, et);

	dom_node_unref(et);
	return 1;
#line 306 "event.c"
}

static duk_ret_t dukky_event_currentTarget_getter(duk_context *ctx)
{
	/* Get private data for method */
	event_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 63 "Event.bnd"

	/** @todo Decide HTF this works wrt. Window as an event target */
	dom_node *et;
	dom_exception exc;

	exc = dom_event_get_current_target(priv->evt, &et);
	if (exc != DOM_NO_ERR) return 0;

	dukky_push_node(ctx, et);

	dom_node_unref(et);
	return 1;
#line 334 "event.c"
}

static duk_ret_t dukky_event_eventPhase_getter(duk_context *ctx)
{
	/* Get private data for method */
	event_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 78 "Event.bnd"

	dom_exception exc;
	dom_event_flow_phase phase;

	exc = dom_event_get_event_phase(priv->evt, &phase);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_uint(ctx, phase);
	return 1;
#line 359 "event.c"
}

static duk_ret_t dukky_event_bubbles_getter(duk_context *ctx)
{
	/* Get private data for method */
	event_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 110 "Event.bnd"

	dom_exception exc;
	bool ret;

	exc = dom_event_get_bubbles(priv->evt, &ret);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_boolean(ctx, ret);
	return 1;
#line 384 "event.c"
}

static duk_ret_t dukky_event_cancelable_getter(duk_context *ctx)
{
	/* Get private data for method */
	event_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 122 "Event.bnd"

	dom_exception exc;
	bool ret;

	exc = dom_event_get_cancelable(priv->evt, &ret);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_boolean(ctx, ret);
	return 1;
#line 409 "event.c"
}

static duk_ret_t dukky_event_defaultPrevented_getter(duk_context *ctx)
{
	/* Get private data for method */
	event_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 144 "Event.bnd"

	dom_exception exc;
	bool ret;

	exc = dom_event_is_default_prevented(priv->evt, &ret);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_boolean(ctx, ret);
	return 1;
#line 434 "event.c"
}

static duk_ret_t dukky_event_isTrusted_getter(duk_context *ctx)
{
	/* Get private data for method */
	event_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 156 "Event.bnd"

	dom_exception exc;
	bool ret;

	exc = dom_event_get_is_trusted(priv->evt, &ret);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_boolean(ctx, ret);
	return 1;
#line 459 "event.c"
}

static duk_ret_t dukky_event_timeStamp_getter(duk_context *ctx)
{
	/* Get private data for method */
	event_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

duk_ret_t dukky_event___proto(duk_context *ctx, void *udata)
{
	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "stopPropagation");
	duk_push_c_function(ctx, dukky_event_stopPropagation, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "stopImmediatePropagation");
	duk_push_c_function(ctx, dukky_event_stopImmediatePropagation, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "preventDefault");
	duk_push_c_function(ctx, dukky_event_preventDefault, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "initEvent");
	duk_push_c_function(ctx, dukky_event_initEvent, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "type");
	duk_push_c_function(ctx, dukky_event_type_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "target");
	duk_push_c_function(ctx, dukky_event_target_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "currentTarget");
	duk_push_c_function(ctx, dukky_event_currentTarget_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "eventPhase");
	duk_push_c_function(ctx, dukky_event_eventPhase_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "bubbles");
	duk_push_c_function(ctx, dukky_event_bubbles_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "cancelable");
	duk_push_c_function(ctx, dukky_event_cancelable_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "defaultPrevented");
	duk_push_c_function(ctx, dukky_event_defaultPrevented_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "isTrusted");
	duk_push_c_function(ctx, dukky_event_isTrusted_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "timeStamp");
	duk_push_c_function(ctx, dukky_event_timeStamp_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	duk_dup(ctx, 0);
	duk_push_string(ctx, "NONE");
	duk_push_int(ctx, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	duk_dup(ctx, 0);
	duk_push_string(ctx, "CAPTURING_PHASE");
	duk_push_int(ctx, 1);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	duk_dup(ctx, 0);
	duk_push_string(ctx, "AT_TARGET");
	duk_push_int(ctx, 2);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	duk_dup(ctx, 0);
	duk_push_string(ctx, "BUBBLING_PHASE");
	duk_push_int(ctx, 3);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Set the destructor */
	duk_dup(ctx, 0);
	duk_push_c_function(ctx, dukky_event___destructor, 1);
	duk_set_finalizer(ctx, -2);
	duk_pop(ctx);

	/* Set the constructor */
	duk_dup(ctx, 0);
	duk_push_c_function(ctx, dukky_event___constructor, 2);
	duk_put_prop_string(ctx, -2, "\xFF\xFFNETSURF_DUKTAPE_INIT");
	duk_pop(ctx);

	return 1; /* The prototype object */
}


