// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from webkit-gir-files
// DO NOT EDIT
#![allow(deprecated)]

use crate::{ffi, HardwareAccelerationPolicy};
#[cfg(feature = "v2_42")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_42")))]
use crate::{Feature, FeatureList};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "WebKitSettings")]
    pub struct Settings(Object<ffi::WebKitSettings, ffi::WebKitSettingsClass>);

    match fn {
        type_ => || ffi::webkit_settings_get_type(),
    }
}

impl Settings {
    #[doc(alias = "webkit_settings_new")]
    pub fn new() -> Settings {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::webkit_settings_new()) }
    }

    //#[doc(alias = "webkit_settings_new_with_settings")]
    //#[doc(alias = "new_with_settings")]
    //pub fn with_settings(first_setting_name: &str, : /*Unknown conversion*//*Unimplemented*/Basic: VarArgs) -> Settings {
    //    unsafe { TODO: call ffi:webkit_settings_new_with_settings() }
    //}

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Settings`] objects.
    ///
    /// This method returns an instance of [`SettingsBuilder`](crate::builders::SettingsBuilder) which can be used to create [`Settings`] objects.
    pub fn builder() -> SettingsBuilder {
        SettingsBuilder::new()
    }

    #[cfg(feature = "v2_46")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_46")))]
    #[doc(alias = "webkit_settings_apply_from_key_file")]
    pub fn apply_from_key_file(
        &self,
        key_file: &glib::KeyFile,
        group_name: &str,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::webkit_settings_apply_from_key_file(
                self.to_glib_none().0,
                key_file.to_glib_none().0,
                group_name.to_glib_none().0,
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "webkit_settings_get_allow_file_access_from_file_urls")]
    #[doc(alias = "get_allow_file_access_from_file_urls")]
    #[doc(alias = "allow-file-access-from-file-urls")]
    pub fn allows_file_access_from_file_urls(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_allow_file_access_from_file_urls(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_allow_modal_dialogs")]
    #[doc(alias = "get_allow_modal_dialogs")]
    #[doc(alias = "allow-modal-dialogs")]
    pub fn allows_modal_dialogs(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_allow_modal_dialogs(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_allow_top_navigation_to_data_urls")]
    #[doc(alias = "get_allow_top_navigation_to_data_urls")]
    #[doc(alias = "allow-top-navigation-to-data-urls")]
    pub fn allows_top_navigation_to_data_urls(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_allow_top_navigation_to_data_urls(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_allow_universal_access_from_file_urls")]
    #[doc(alias = "get_allow_universal_access_from_file_urls")]
    #[doc(alias = "allow-universal-access-from-file-urls")]
    pub fn allows_universal_access_from_file_urls(&self) -> bool {
        unsafe {
            from_glib(
                ffi::webkit_settings_get_allow_universal_access_from_file_urls(
                    self.to_glib_none().0,
                ),
            )
        }
    }

    #[doc(alias = "webkit_settings_get_auto_load_images")]
    #[doc(alias = "get_auto_load_images")]
    #[doc(alias = "auto-load-images")]
    pub fn is_auto_load_images(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_auto_load_images(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_cursive_font_family")]
    #[doc(alias = "get_cursive_font_family")]
    #[doc(alias = "cursive-font-family")]
    pub fn cursive_font_family(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::webkit_settings_get_cursive_font_family(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_default_charset")]
    #[doc(alias = "get_default_charset")]
    #[doc(alias = "default-charset")]
    pub fn default_charset(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::webkit_settings_get_default_charset(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_default_font_family")]
    #[doc(alias = "get_default_font_family")]
    #[doc(alias = "default-font-family")]
    pub fn default_font_family(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::webkit_settings_get_default_font_family(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_default_font_size")]
    #[doc(alias = "get_default_font_size")]
    #[doc(alias = "default-font-size")]
    pub fn default_font_size(&self) -> u32 {
        unsafe { ffi::webkit_settings_get_default_font_size(self.to_glib_none().0) }
    }

    #[doc(alias = "webkit_settings_get_default_monospace_font_size")]
    #[doc(alias = "get_default_monospace_font_size")]
    #[doc(alias = "default-monospace-font-size")]
    pub fn default_monospace_font_size(&self) -> u32 {
        unsafe { ffi::webkit_settings_get_default_monospace_font_size(self.to_glib_none().0) }
    }

    #[doc(alias = "webkit_settings_get_disable_web_security")]
    #[doc(alias = "get_disable_web_security")]
    #[doc(alias = "disable-web-security")]
    pub fn is_disable_web_security(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_disable_web_security(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_draw_compositing_indicators")]
    #[doc(alias = "get_draw_compositing_indicators")]
    #[doc(alias = "draw-compositing-indicators")]
    pub fn draws_compositing_indicators(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_draw_compositing_indicators(
                self.to_glib_none().0,
            ))
        }
    }

    #[cfg(feature = "v2_46")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_46")))]
    #[doc(alias = "webkit_settings_get_enable_2d_canvas_acceleration")]
    #[doc(alias = "get_enable_2d_canvas_acceleration")]
    #[doc(alias = "enable-2d-canvas-acceleration")]
    pub fn enables_2d_canvas_acceleration(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_enable_2d_canvas_acceleration(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_enable_back_forward_navigation_gestures")]
    #[doc(alias = "get_enable_back_forward_navigation_gestures")]
    #[doc(alias = "enable-back-forward-navigation-gestures")]
    pub fn enables_back_forward_navigation_gestures(&self) -> bool {
        unsafe {
            from_glib(
                ffi::webkit_settings_get_enable_back_forward_navigation_gestures(
                    self.to_glib_none().0,
                ),
            )
        }
    }

    #[doc(alias = "webkit_settings_get_enable_caret_browsing")]
    #[doc(alias = "get_enable_caret_browsing")]
    #[doc(alias = "enable-caret-browsing")]
    pub fn enables_caret_browsing(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_enable_caret_browsing(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_enable_developer_extras")]
    #[doc(alias = "get_enable_developer_extras")]
    #[doc(alias = "enable-developer-extras")]
    pub fn enables_developer_extras(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_enable_developer_extras(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_enable_dns_prefetching")]
    #[doc(alias = "get_enable_dns_prefetching")]
    #[doc(alias = "enable-dns-prefetching")]
    pub fn enables_dns_prefetching(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_enable_dns_prefetching(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_enable_encrypted_media")]
    #[doc(alias = "get_enable_encrypted_media")]
    #[doc(alias = "enable-encrypted-media")]
    pub fn enables_encrypted_media(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_enable_encrypted_media(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_enable_fullscreen")]
    #[doc(alias = "get_enable_fullscreen")]
    #[doc(alias = "enable-fullscreen")]
    pub fn enables_fullscreen(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_enable_fullscreen(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_enable_html5_database")]
    #[doc(alias = "get_enable_html5_database")]
    #[doc(alias = "enable-html5-database")]
    pub fn enables_html5_database(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_enable_html5_database(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_enable_html5_local_storage")]
    #[doc(alias = "get_enable_html5_local_storage")]
    #[doc(alias = "enable-html5-local-storage")]
    pub fn enables_html5_local_storage(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_enable_html5_local_storage(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_enable_hyperlink_auditing")]
    #[doc(alias = "get_enable_hyperlink_auditing")]
    #[doc(alias = "enable-hyperlink-auditing")]
    pub fn enables_hyperlink_auditing(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_enable_hyperlink_auditing(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_enable_javascript")]
    #[doc(alias = "get_enable_javascript")]
    #[doc(alias = "enable-javascript")]
    pub fn enables_javascript(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_enable_javascript(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_enable_javascript_markup")]
    #[doc(alias = "get_enable_javascript_markup")]
    #[doc(alias = "enable-javascript-markup")]
    pub fn enables_javascript_markup(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_enable_javascript_markup(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_enable_media")]
    #[doc(alias = "get_enable_media")]
    #[doc(alias = "enable-media")]
    pub fn enables_media(&self) -> bool {
        unsafe { from_glib(ffi::webkit_settings_get_enable_media(self.to_glib_none().0)) }
    }

    #[doc(alias = "webkit_settings_get_enable_media_capabilities")]
    #[doc(alias = "get_enable_media_capabilities")]
    #[doc(alias = "enable-media-capabilities")]
    pub fn enables_media_capabilities(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_enable_media_capabilities(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_enable_media_stream")]
    #[doc(alias = "get_enable_media_stream")]
    #[doc(alias = "enable-media-stream")]
    pub fn enables_media_stream(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_enable_media_stream(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_enable_mediasource")]
    #[doc(alias = "get_enable_mediasource")]
    #[doc(alias = "enable-mediasource")]
    pub fn enables_mediasource(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_enable_mediasource(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_enable_mock_capture_devices")]
    #[doc(alias = "get_enable_mock_capture_devices")]
    #[doc(alias = "enable-mock-capture-devices")]
    pub fn enables_mock_capture_devices(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_enable_mock_capture_devices(
                self.to_glib_none().0,
            ))
        }
    }

    #[cfg_attr(feature = "v2_44", deprecated = "Since 2.44")]
    #[allow(deprecated)]
    #[doc(alias = "webkit_settings_get_enable_offline_web_application_cache")]
    #[doc(alias = "get_enable_offline_web_application_cache")]
    #[doc(alias = "enable-offline-web-application-cache")]
    pub fn enables_offline_web_application_cache(&self) -> bool {
        unsafe {
            from_glib(
                ffi::webkit_settings_get_enable_offline_web_application_cache(
                    self.to_glib_none().0,
                ),
            )
        }
    }

    #[doc(alias = "webkit_settings_get_enable_page_cache")]
    #[doc(alias = "get_enable_page_cache")]
    #[doc(alias = "enable-page-cache")]
    pub fn enables_page_cache(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_enable_page_cache(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_enable_resizable_text_areas")]
    #[doc(alias = "get_enable_resizable_text_areas")]
    #[doc(alias = "enable-resizable-text-areas")]
    pub fn enables_resizable_text_areas(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_enable_resizable_text_areas(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_enable_site_specific_quirks")]
    #[doc(alias = "get_enable_site_specific_quirks")]
    #[doc(alias = "enable-site-specific-quirks")]
    pub fn enables_site_specific_quirks(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_enable_site_specific_quirks(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_enable_smooth_scrolling")]
    #[doc(alias = "get_enable_smooth_scrolling")]
    #[doc(alias = "enable-smooth-scrolling")]
    pub fn enables_smooth_scrolling(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_enable_smooth_scrolling(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_enable_spatial_navigation")]
    #[doc(alias = "get_enable_spatial_navigation")]
    #[doc(alias = "enable-spatial-navigation")]
    pub fn enables_spatial_navigation(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_enable_spatial_navigation(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_enable_tabs_to_links")]
    #[doc(alias = "get_enable_tabs_to_links")]
    #[doc(alias = "enable-tabs-to-links")]
    pub fn enables_tabs_to_links(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_enable_tabs_to_links(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_enable_webaudio")]
    #[doc(alias = "get_enable_webaudio")]
    #[doc(alias = "enable-webaudio")]
    pub fn enables_webaudio(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_enable_webaudio(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_enable_webgl")]
    #[doc(alias = "get_enable_webgl")]
    #[doc(alias = "enable-webgl")]
    pub fn enables_webgl(&self) -> bool {
        unsafe { from_glib(ffi::webkit_settings_get_enable_webgl(self.to_glib_none().0)) }
    }

    #[doc(alias = "webkit_settings_get_enable_webrtc")]
    #[doc(alias = "get_enable_webrtc")]
    #[doc(alias = "enable-webrtc")]
    pub fn enables_webrtc(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_enable_webrtc(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_enable_write_console_messages_to_stdout")]
    #[doc(alias = "get_enable_write_console_messages_to_stdout")]
    #[doc(alias = "enable-write-console-messages-to-stdout")]
    pub fn enables_write_console_messages_to_stdout(&self) -> bool {
        unsafe {
            from_glib(
                ffi::webkit_settings_get_enable_write_console_messages_to_stdout(
                    self.to_glib_none().0,
                ),
            )
        }
    }

    #[doc(alias = "webkit_settings_get_fantasy_font_family")]
    #[doc(alias = "get_fantasy_font_family")]
    #[doc(alias = "fantasy-font-family")]
    pub fn fantasy_font_family(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::webkit_settings_get_fantasy_font_family(
                self.to_glib_none().0,
            ))
        }
    }

    #[cfg(feature = "v2_42")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_42")))]
    #[doc(alias = "webkit_settings_get_feature_enabled")]
    #[doc(alias = "get_feature_enabled")]
    pub fn is_feature_enabled(&self, feature: &Feature) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_feature_enabled(
                self.to_glib_none().0,
                feature.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_hardware_acceleration_policy")]
    #[doc(alias = "get_hardware_acceleration_policy")]
    #[doc(alias = "hardware-acceleration-policy")]
    pub fn hardware_acceleration_policy(&self) -> HardwareAccelerationPolicy {
        unsafe {
            from_glib(ffi::webkit_settings_get_hardware_acceleration_policy(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_javascript_can_access_clipboard")]
    #[doc(alias = "get_javascript_can_access_clipboard")]
    #[doc(alias = "javascript-can-access-clipboard")]
    pub fn is_javascript_can_access_clipboard(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_javascript_can_access_clipboard(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_javascript_can_open_windows_automatically")]
    #[doc(alias = "get_javascript_can_open_windows_automatically")]
    #[doc(alias = "javascript-can-open-windows-automatically")]
    pub fn is_javascript_can_open_windows_automatically(&self) -> bool {
        unsafe {
            from_glib(
                ffi::webkit_settings_get_javascript_can_open_windows_automatically(
                    self.to_glib_none().0,
                ),
            )
        }
    }

    #[cfg_attr(feature = "v2_42", deprecated = "Since 2.42")]
    #[allow(deprecated)]
    #[doc(alias = "webkit_settings_get_load_icons_ignoring_image_load_setting")]
    #[doc(alias = "get_load_icons_ignoring_image_load_setting")]
    #[doc(alias = "load-icons-ignoring-image-load-setting")]
    pub fn is_load_icons_ignoring_image_load_setting(&self) -> bool {
        unsafe {
            from_glib(
                ffi::webkit_settings_get_load_icons_ignoring_image_load_setting(
                    self.to_glib_none().0,
                ),
            )
        }
    }

    #[doc(alias = "webkit_settings_get_media_content_types_requiring_hardware_support")]
    #[doc(alias = "get_media_content_types_requiring_hardware_support")]
    #[doc(alias = "media-content-types-requiring-hardware-support")]
    pub fn media_content_types_requiring_hardware_support(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(
                ffi::webkit_settings_get_media_content_types_requiring_hardware_support(
                    self.to_glib_none().0,
                ),
            )
        }
    }

    #[doc(alias = "webkit_settings_get_media_playback_allows_inline")]
    #[doc(alias = "get_media_playback_allows_inline")]
    #[doc(alias = "media-playback-allows-inline")]
    pub fn is_media_playback_allows_inline(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_media_playback_allows_inline(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_media_playback_requires_user_gesture")]
    #[doc(alias = "get_media_playback_requires_user_gesture")]
    #[doc(alias = "media-playback-requires-user-gesture")]
    pub fn is_media_playback_requires_user_gesture(&self) -> bool {
        unsafe {
            from_glib(
                ffi::webkit_settings_get_media_playback_requires_user_gesture(
                    self.to_glib_none().0,
                ),
            )
        }
    }

    #[doc(alias = "webkit_settings_get_minimum_font_size")]
    #[doc(alias = "get_minimum_font_size")]
    #[doc(alias = "minimum-font-size")]
    pub fn minimum_font_size(&self) -> u32 {
        unsafe { ffi::webkit_settings_get_minimum_font_size(self.to_glib_none().0) }
    }

    #[doc(alias = "webkit_settings_get_monospace_font_family")]
    #[doc(alias = "get_monospace_font_family")]
    #[doc(alias = "monospace-font-family")]
    pub fn monospace_font_family(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::webkit_settings_get_monospace_font_family(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_pictograph_font_family")]
    #[doc(alias = "get_pictograph_font_family")]
    #[doc(alias = "pictograph-font-family")]
    pub fn pictograph_font_family(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::webkit_settings_get_pictograph_font_family(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_print_backgrounds")]
    #[doc(alias = "get_print_backgrounds")]
    #[doc(alias = "print-backgrounds")]
    pub fn is_print_backgrounds(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_print_backgrounds(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_sans_serif_font_family")]
    #[doc(alias = "get_sans_serif_font_family")]
    #[doc(alias = "sans-serif-font-family")]
    pub fn sans_serif_font_family(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::webkit_settings_get_sans_serif_font_family(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_serif_font_family")]
    #[doc(alias = "get_serif_font_family")]
    #[doc(alias = "serif-font-family")]
    pub fn serif_font_family(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::webkit_settings_get_serif_font_family(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_get_user_agent")]
    #[doc(alias = "get_user_agent")]
    #[doc(alias = "user-agent")]
    pub fn user_agent(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::webkit_settings_get_user_agent(self.to_glib_none().0)) }
    }

    #[doc(alias = "webkit_settings_get_zoom_text_only")]
    #[doc(alias = "get_zoom_text_only")]
    #[doc(alias = "zoom-text-only")]
    pub fn is_zoom_text_only(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_settings_get_zoom_text_only(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_settings_set_allow_file_access_from_file_urls")]
    #[doc(alias = "allow-file-access-from-file-urls")]
    pub fn set_allow_file_access_from_file_urls(&self, allowed: bool) {
        unsafe {
            ffi::webkit_settings_set_allow_file_access_from_file_urls(
                self.to_glib_none().0,
                allowed.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_settings_set_allow_modal_dialogs")]
    #[doc(alias = "allow-modal-dialogs")]
    pub fn set_allow_modal_dialogs(&self, allowed: bool) {
        unsafe {
            ffi::webkit_settings_set_allow_modal_dialogs(
                self.to_glib_none().0,
                allowed.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_settings_set_allow_top_navigation_to_data_urls")]
    #[doc(alias = "allow-top-navigation-to-data-urls")]
    pub fn set_allow_top_navigation_to_data_urls(&self, allowed: bool) {
        unsafe {
            ffi::webkit_settings_set_allow_top_navigation_to_data_urls(
                self.to_glib_none().0,
                allowed.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_settings_set_allow_universal_access_from_file_urls")]
    #[doc(alias = "allow-universal-access-from-file-urls")]
    pub fn set_allow_universal_access_from_file_urls(&self, allowed: bool) {
        unsafe {
            ffi::webkit_settings_set_allow_universal_access_from_file_urls(
                self.to_glib_none().0,
                allowed.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_settings_set_auto_load_images")]
    #[doc(alias = "auto-load-images")]
    pub fn set_auto_load_images(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_auto_load_images(self.to_glib_none().0, enabled.into_glib());
        }
    }

    #[doc(alias = "webkit_settings_set_cursive_font_family")]
    #[doc(alias = "cursive-font-family")]
    pub fn set_cursive_font_family(&self, cursive_font_family: &str) {
        unsafe {
            ffi::webkit_settings_set_cursive_font_family(
                self.to_glib_none().0,
                cursive_font_family.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "webkit_settings_set_default_charset")]
    #[doc(alias = "default-charset")]
    pub fn set_default_charset(&self, default_charset: &str) {
        unsafe {
            ffi::webkit_settings_set_default_charset(
                self.to_glib_none().0,
                default_charset.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "webkit_settings_set_default_font_family")]
    #[doc(alias = "default-font-family")]
    pub fn set_default_font_family(&self, default_font_family: &str) {
        unsafe {
            ffi::webkit_settings_set_default_font_family(
                self.to_glib_none().0,
                default_font_family.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "webkit_settings_set_default_font_size")]
    #[doc(alias = "default-font-size")]
    pub fn set_default_font_size(&self, font_size: u32) {
        unsafe {
            ffi::webkit_settings_set_default_font_size(self.to_glib_none().0, font_size);
        }
    }

    #[doc(alias = "webkit_settings_set_default_monospace_font_size")]
    #[doc(alias = "default-monospace-font-size")]
    pub fn set_default_monospace_font_size(&self, font_size: u32) {
        unsafe {
            ffi::webkit_settings_set_default_monospace_font_size(self.to_glib_none().0, font_size);
        }
    }

    #[doc(alias = "webkit_settings_set_disable_web_security")]
    #[doc(alias = "disable-web-security")]
    pub fn set_disable_web_security(&self, disabled: bool) {
        unsafe {
            ffi::webkit_settings_set_disable_web_security(
                self.to_glib_none().0,
                disabled.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_settings_set_draw_compositing_indicators")]
    #[doc(alias = "draw-compositing-indicators")]
    pub fn set_draw_compositing_indicators(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_draw_compositing_indicators(
                self.to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[cfg(feature = "v2_46")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_46")))]
    #[doc(alias = "webkit_settings_set_enable_2d_canvas_acceleration")]
    #[doc(alias = "enable-2d-canvas-acceleration")]
    pub fn set_enable_2d_canvas_acceleration(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_enable_2d_canvas_acceleration(
                self.to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_settings_set_enable_back_forward_navigation_gestures")]
    #[doc(alias = "enable-back-forward-navigation-gestures")]
    pub fn set_enable_back_forward_navigation_gestures(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_enable_back_forward_navigation_gestures(
                self.to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_settings_set_enable_caret_browsing")]
    #[doc(alias = "enable-caret-browsing")]
    pub fn set_enable_caret_browsing(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_enable_caret_browsing(
                self.to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_settings_set_enable_developer_extras")]
    #[doc(alias = "enable-developer-extras")]
    pub fn set_enable_developer_extras(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_enable_developer_extras(
                self.to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_settings_set_enable_dns_prefetching")]
    #[doc(alias = "enable-dns-prefetching")]
    pub fn set_enable_dns_prefetching(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_enable_dns_prefetching(
                self.to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_settings_set_enable_encrypted_media")]
    #[doc(alias = "enable-encrypted-media")]
    pub fn set_enable_encrypted_media(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_enable_encrypted_media(
                self.to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_settings_set_enable_fullscreen")]
    #[doc(alias = "enable-fullscreen")]
    pub fn set_enable_fullscreen(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_enable_fullscreen(self.to_glib_none().0, enabled.into_glib());
        }
    }

    #[doc(alias = "webkit_settings_set_enable_html5_database")]
    #[doc(alias = "enable-html5-database")]
    pub fn set_enable_html5_database(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_enable_html5_database(
                self.to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_settings_set_enable_html5_local_storage")]
    #[doc(alias = "enable-html5-local-storage")]
    pub fn set_enable_html5_local_storage(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_enable_html5_local_storage(
                self.to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_settings_set_enable_hyperlink_auditing")]
    #[doc(alias = "enable-hyperlink-auditing")]
    pub fn set_enable_hyperlink_auditing(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_enable_hyperlink_auditing(
                self.to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_settings_set_enable_javascript")]
    #[doc(alias = "enable-javascript")]
    pub fn set_enable_javascript(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_enable_javascript(self.to_glib_none().0, enabled.into_glib());
        }
    }

    #[doc(alias = "webkit_settings_set_enable_javascript_markup")]
    #[doc(alias = "enable-javascript-markup")]
    pub fn set_enable_javascript_markup(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_enable_javascript_markup(
                self.to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_settings_set_enable_media")]
    #[doc(alias = "enable-media")]
    pub fn set_enable_media(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_enable_media(self.to_glib_none().0, enabled.into_glib());
        }
    }

    #[doc(alias = "webkit_settings_set_enable_media_capabilities")]
    #[doc(alias = "enable-media-capabilities")]
    pub fn set_enable_media_capabilities(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_enable_media_capabilities(
                self.to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_settings_set_enable_media_stream")]
    #[doc(alias = "enable-media-stream")]
    pub fn set_enable_media_stream(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_enable_media_stream(
                self.to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_settings_set_enable_mediasource")]
    #[doc(alias = "enable-mediasource")]
    pub fn set_enable_mediasource(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_enable_mediasource(self.to_glib_none().0, enabled.into_glib());
        }
    }

    #[doc(alias = "webkit_settings_set_enable_mock_capture_devices")]
    #[doc(alias = "enable-mock-capture-devices")]
    pub fn set_enable_mock_capture_devices(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_enable_mock_capture_devices(
                self.to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[cfg_attr(feature = "v2_44", deprecated = "Since 2.44")]
    #[allow(deprecated)]
    #[doc(alias = "webkit_settings_set_enable_offline_web_application_cache")]
    #[doc(alias = "enable-offline-web-application-cache")]
    pub fn set_enable_offline_web_application_cache(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_enable_offline_web_application_cache(
                self.to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_settings_set_enable_page_cache")]
    #[doc(alias = "enable-page-cache")]
    pub fn set_enable_page_cache(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_enable_page_cache(self.to_glib_none().0, enabled.into_glib());
        }
    }

    #[doc(alias = "webkit_settings_set_enable_resizable_text_areas")]
    #[doc(alias = "enable-resizable-text-areas")]
    pub fn set_enable_resizable_text_areas(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_enable_resizable_text_areas(
                self.to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_settings_set_enable_site_specific_quirks")]
    #[doc(alias = "enable-site-specific-quirks")]
    pub fn set_enable_site_specific_quirks(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_enable_site_specific_quirks(
                self.to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_settings_set_enable_smooth_scrolling")]
    #[doc(alias = "enable-smooth-scrolling")]
    pub fn set_enable_smooth_scrolling(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_enable_smooth_scrolling(
                self.to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_settings_set_enable_spatial_navigation")]
    #[doc(alias = "enable-spatial-navigation")]
    pub fn set_enable_spatial_navigation(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_enable_spatial_navigation(
                self.to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_settings_set_enable_tabs_to_links")]
    #[doc(alias = "enable-tabs-to-links")]
    pub fn set_enable_tabs_to_links(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_enable_tabs_to_links(
                self.to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_settings_set_enable_webaudio")]
    #[doc(alias = "enable-webaudio")]
    pub fn set_enable_webaudio(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_enable_webaudio(self.to_glib_none().0, enabled.into_glib());
        }
    }

    #[doc(alias = "webkit_settings_set_enable_webgl")]
    #[doc(alias = "enable-webgl")]
    pub fn set_enable_webgl(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_enable_webgl(self.to_glib_none().0, enabled.into_glib());
        }
    }

    #[doc(alias = "webkit_settings_set_enable_webrtc")]
    #[doc(alias = "enable-webrtc")]
    pub fn set_enable_webrtc(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_enable_webrtc(self.to_glib_none().0, enabled.into_glib());
        }
    }

    #[doc(alias = "webkit_settings_set_enable_write_console_messages_to_stdout")]
    #[doc(alias = "enable-write-console-messages-to-stdout")]
    pub fn set_enable_write_console_messages_to_stdout(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_enable_write_console_messages_to_stdout(
                self.to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_settings_set_fantasy_font_family")]
    #[doc(alias = "fantasy-font-family")]
    pub fn set_fantasy_font_family(&self, fantasy_font_family: &str) {
        unsafe {
            ffi::webkit_settings_set_fantasy_font_family(
                self.to_glib_none().0,
                fantasy_font_family.to_glib_none().0,
            );
        }
    }

    #[cfg(feature = "v2_42")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_42")))]
    #[doc(alias = "webkit_settings_set_feature_enabled")]
    pub fn set_feature_enabled(&self, feature: &Feature, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_feature_enabled(
                self.to_glib_none().0,
                feature.to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_settings_set_hardware_acceleration_policy")]
    #[doc(alias = "hardware-acceleration-policy")]
    pub fn set_hardware_acceleration_policy(&self, policy: HardwareAccelerationPolicy) {
        unsafe {
            ffi::webkit_settings_set_hardware_acceleration_policy(
                self.to_glib_none().0,
                policy.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_settings_set_javascript_can_access_clipboard")]
    #[doc(alias = "javascript-can-access-clipboard")]
    pub fn set_javascript_can_access_clipboard(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_javascript_can_access_clipboard(
                self.to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_settings_set_javascript_can_open_windows_automatically")]
    #[doc(alias = "javascript-can-open-windows-automatically")]
    pub fn set_javascript_can_open_windows_automatically(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_javascript_can_open_windows_automatically(
                self.to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[cfg_attr(feature = "v2_42", deprecated = "Since 2.42")]
    #[allow(deprecated)]
    #[doc(alias = "webkit_settings_set_load_icons_ignoring_image_load_setting")]
    #[doc(alias = "load-icons-ignoring-image-load-setting")]
    pub fn set_load_icons_ignoring_image_load_setting(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_load_icons_ignoring_image_load_setting(
                self.to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_settings_set_media_content_types_requiring_hardware_support")]
    #[doc(alias = "media-content-types-requiring-hardware-support")]
    pub fn set_media_content_types_requiring_hardware_support(&self, content_types: Option<&str>) {
        unsafe {
            ffi::webkit_settings_set_media_content_types_requiring_hardware_support(
                self.to_glib_none().0,
                content_types.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "webkit_settings_set_media_playback_allows_inline")]
    #[doc(alias = "media-playback-allows-inline")]
    pub fn set_media_playback_allows_inline(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_media_playback_allows_inline(
                self.to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_settings_set_media_playback_requires_user_gesture")]
    #[doc(alias = "media-playback-requires-user-gesture")]
    pub fn set_media_playback_requires_user_gesture(&self, enabled: bool) {
        unsafe {
            ffi::webkit_settings_set_media_playback_requires_user_gesture(
                self.to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_settings_set_minimum_font_size")]
    #[doc(alias = "minimum-font-size")]
    pub fn set_minimum_font_size(&self, font_size: u32) {
        unsafe {
            ffi::webkit_settings_set_minimum_font_size(self.to_glib_none().0, font_size);
        }
    }

    #[doc(alias = "webkit_settings_set_monospace_font_family")]
    #[doc(alias = "monospace-font-family")]
    pub fn set_monospace_font_family(&self, monospace_font_family: &str) {
        unsafe {
            ffi::webkit_settings_set_monospace_font_family(
                self.to_glib_none().0,
                monospace_font_family.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "webkit_settings_set_pictograph_font_family")]
    #[doc(alias = "pictograph-font-family")]
    pub fn set_pictograph_font_family(&self, pictograph_font_family: &str) {
        unsafe {
            ffi::webkit_settings_set_pictograph_font_family(
                self.to_glib_none().0,
                pictograph_font_family.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "webkit_settings_set_print_backgrounds")]
    #[doc(alias = "print-backgrounds")]
    pub fn set_print_backgrounds(&self, print_backgrounds: bool) {
        unsafe {
            ffi::webkit_settings_set_print_backgrounds(
                self.to_glib_none().0,
                print_backgrounds.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_settings_set_sans_serif_font_family")]
    #[doc(alias = "sans-serif-font-family")]
    pub fn set_sans_serif_font_family(&self, sans_serif_font_family: &str) {
        unsafe {
            ffi::webkit_settings_set_sans_serif_font_family(
                self.to_glib_none().0,
                sans_serif_font_family.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "webkit_settings_set_serif_font_family")]
    #[doc(alias = "serif-font-family")]
    pub fn set_serif_font_family(&self, serif_font_family: &str) {
        unsafe {
            ffi::webkit_settings_set_serif_font_family(
                self.to_glib_none().0,
                serif_font_family.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "webkit_settings_set_user_agent")]
    #[doc(alias = "user-agent")]
    pub fn set_user_agent(&self, user_agent: Option<&str>) {
        unsafe {
            ffi::webkit_settings_set_user_agent(self.to_glib_none().0, user_agent.to_glib_none().0);
        }
    }

    #[doc(alias = "webkit_settings_set_user_agent_with_application_details")]
    pub fn set_user_agent_with_application_details(
        &self,
        application_name: Option<&str>,
        application_version: Option<&str>,
    ) {
        unsafe {
            ffi::webkit_settings_set_user_agent_with_application_details(
                self.to_glib_none().0,
                application_name.to_glib_none().0,
                application_version.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "webkit_settings_set_zoom_text_only")]
    #[doc(alias = "zoom-text-only")]
    pub fn set_zoom_text_only(&self, zoom_text_only: bool) {
        unsafe {
            ffi::webkit_settings_set_zoom_text_only(
                self.to_glib_none().0,
                zoom_text_only.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_settings_font_size_to_pixels")]
    pub fn font_size_to_pixels(points: u32) -> u32 {
        assert_initialized_main_thread!();
        unsafe { ffi::webkit_settings_font_size_to_pixels(points) }
    }

    #[doc(alias = "webkit_settings_font_size_to_points")]
    pub fn font_size_to_points(pixels: u32) -> u32 {
        assert_initialized_main_thread!();
        unsafe { ffi::webkit_settings_font_size_to_points(pixels) }
    }

    #[cfg(feature = "v2_42")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_42")))]
    #[doc(alias = "webkit_settings_get_all_features")]
    #[doc(alias = "get_all_features")]
    pub fn all_features() -> Option<FeatureList> {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::webkit_settings_get_all_features()) }
    }

    #[cfg(feature = "v2_42")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_42")))]
    #[doc(alias = "webkit_settings_get_development_features")]
    #[doc(alias = "get_development_features")]
    pub fn development_features() -> Option<FeatureList> {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::webkit_settings_get_development_features()) }
    }

    #[cfg(feature = "v2_42")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_42")))]
    #[doc(alias = "webkit_settings_get_experimental_features")]
    #[doc(alias = "get_experimental_features")]
    pub fn experimental_features() -> Option<FeatureList> {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::webkit_settings_get_experimental_features()) }
    }

    #[doc(alias = "allow-file-access-from-file-urls")]
    pub fn connect_allow_file_access_from_file_urls_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_allow_file_access_from_file_urls_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::allow-file-access-from-file-urls\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_allow_file_access_from_file_urls_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "allow-modal-dialogs")]
    pub fn connect_allow_modal_dialogs_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_allow_modal_dialogs_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::allow-modal-dialogs\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_allow_modal_dialogs_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "allow-top-navigation-to-data-urls")]
    pub fn connect_allow_top_navigation_to_data_urls_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_allow_top_navigation_to_data_urls_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::allow-top-navigation-to-data-urls\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_allow_top_navigation_to_data_urls_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "allow-universal-access-from-file-urls")]
    pub fn connect_allow_universal_access_from_file_urls_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_allow_universal_access_from_file_urls_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::allow-universal-access-from-file-urls\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_allow_universal_access_from_file_urls_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "auto-load-images")]
    pub fn connect_auto_load_images_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_auto_load_images_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::auto-load-images\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_auto_load_images_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "cursive-font-family")]
    pub fn connect_cursive_font_family_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_cursive_font_family_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::cursive-font-family\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_cursive_font_family_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "default-charset")]
    pub fn connect_default_charset_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_default_charset_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::default-charset\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_default_charset_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "default-font-family")]
    pub fn connect_default_font_family_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_default_font_family_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::default-font-family\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_default_font_family_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "default-font-size")]
    pub fn connect_default_font_size_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_default_font_size_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::default-font-size\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_default_font_size_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "default-monospace-font-size")]
    pub fn connect_default_monospace_font_size_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_default_monospace_font_size_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::default-monospace-font-size\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_default_monospace_font_size_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "disable-web-security")]
    pub fn connect_disable_web_security_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_disable_web_security_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::disable-web-security\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_disable_web_security_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "draw-compositing-indicators")]
    pub fn connect_draw_compositing_indicators_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_draw_compositing_indicators_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::draw-compositing-indicators\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_draw_compositing_indicators_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v2_46")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_46")))]
    #[doc(alias = "enable-2d-canvas-acceleration")]
    pub fn connect_enable_2d_canvas_acceleration_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_2d_canvas_acceleration_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-2d-canvas-acceleration\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_enable_2d_canvas_acceleration_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-back-forward-navigation-gestures")]
    pub fn connect_enable_back_forward_navigation_gestures_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_back_forward_navigation_gestures_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-back-forward-navigation-gestures\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_enable_back_forward_navigation_gestures_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-caret-browsing")]
    pub fn connect_enable_caret_browsing_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_caret_browsing_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-caret-browsing\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_enable_caret_browsing_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-developer-extras")]
    pub fn connect_enable_developer_extras_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_developer_extras_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-developer-extras\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_enable_developer_extras_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-dns-prefetching")]
    pub fn connect_enable_dns_prefetching_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_dns_prefetching_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-dns-prefetching\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_enable_dns_prefetching_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-encrypted-media")]
    pub fn connect_enable_encrypted_media_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_encrypted_media_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-encrypted-media\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_enable_encrypted_media_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-fullscreen")]
    pub fn connect_enable_fullscreen_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_fullscreen_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-fullscreen\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_enable_fullscreen_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-html5-database")]
    pub fn connect_enable_html5_database_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_html5_database_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-html5-database\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_enable_html5_database_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-html5-local-storage")]
    pub fn connect_enable_html5_local_storage_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_html5_local_storage_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-html5-local-storage\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_enable_html5_local_storage_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-hyperlink-auditing")]
    pub fn connect_enable_hyperlink_auditing_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_hyperlink_auditing_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-hyperlink-auditing\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_enable_hyperlink_auditing_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-javascript")]
    pub fn connect_enable_javascript_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_javascript_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-javascript\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_enable_javascript_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-javascript-markup")]
    pub fn connect_enable_javascript_markup_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_javascript_markup_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-javascript-markup\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_enable_javascript_markup_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-media")]
    pub fn connect_enable_media_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_media_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-media\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_enable_media_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-media-capabilities")]
    pub fn connect_enable_media_capabilities_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_media_capabilities_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-media-capabilities\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_enable_media_capabilities_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-media-stream")]
    pub fn connect_enable_media_stream_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_media_stream_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-media-stream\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_enable_media_stream_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-mediasource")]
    pub fn connect_enable_mediasource_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_mediasource_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-mediasource\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_enable_mediasource_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-mock-capture-devices")]
    pub fn connect_enable_mock_capture_devices_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_mock_capture_devices_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-mock-capture-devices\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_enable_mock_capture_devices_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg_attr(feature = "v2_44", deprecated = "Since 2.44")]
    #[doc(alias = "enable-offline-web-application-cache")]
    pub fn connect_enable_offline_web_application_cache_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_offline_web_application_cache_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-offline-web-application-cache\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_enable_offline_web_application_cache_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-page-cache")]
    pub fn connect_enable_page_cache_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_page_cache_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-page-cache\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_enable_page_cache_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-resizable-text-areas")]
    pub fn connect_enable_resizable_text_areas_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_resizable_text_areas_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-resizable-text-areas\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_enable_resizable_text_areas_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-site-specific-quirks")]
    pub fn connect_enable_site_specific_quirks_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_site_specific_quirks_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-site-specific-quirks\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_enable_site_specific_quirks_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-smooth-scrolling")]
    pub fn connect_enable_smooth_scrolling_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_smooth_scrolling_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-smooth-scrolling\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_enable_smooth_scrolling_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-spatial-navigation")]
    pub fn connect_enable_spatial_navigation_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_spatial_navigation_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-spatial-navigation\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_enable_spatial_navigation_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-tabs-to-links")]
    pub fn connect_enable_tabs_to_links_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_tabs_to_links_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-tabs-to-links\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_enable_tabs_to_links_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-webaudio")]
    pub fn connect_enable_webaudio_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_webaudio_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-webaudio\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_enable_webaudio_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-webgl")]
    pub fn connect_enable_webgl_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_webgl_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-webgl\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_enable_webgl_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-webrtc")]
    pub fn connect_enable_webrtc_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_webrtc_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-webrtc\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_enable_webrtc_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-write-console-messages-to-stdout")]
    pub fn connect_enable_write_console_messages_to_stdout_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_write_console_messages_to_stdout_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-write-console-messages-to-stdout\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_enable_write_console_messages_to_stdout_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "fantasy-font-family")]
    pub fn connect_fantasy_font_family_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_fantasy_font_family_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::fantasy-font-family\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_fantasy_font_family_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "hardware-acceleration-policy")]
    pub fn connect_hardware_acceleration_policy_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_hardware_acceleration_policy_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::hardware-acceleration-policy\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_hardware_acceleration_policy_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "javascript-can-access-clipboard")]
    pub fn connect_javascript_can_access_clipboard_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_javascript_can_access_clipboard_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::javascript-can-access-clipboard\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_javascript_can_access_clipboard_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "javascript-can-open-windows-automatically")]
    pub fn connect_javascript_can_open_windows_automatically_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_javascript_can_open_windows_automatically_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::javascript-can-open-windows-automatically\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_javascript_can_open_windows_automatically_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg_attr(feature = "v2_42", deprecated = "Since 2.42")]
    #[doc(alias = "load-icons-ignoring-image-load-setting")]
    pub fn connect_load_icons_ignoring_image_load_setting_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_load_icons_ignoring_image_load_setting_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::load-icons-ignoring-image-load-setting\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_load_icons_ignoring_image_load_setting_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "media-content-types-requiring-hardware-support")]
    pub fn connect_media_content_types_requiring_hardware_support_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_media_content_types_requiring_hardware_support_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::media-content-types-requiring-hardware-support\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_media_content_types_requiring_hardware_support_trampoline::<F>
                        as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "media-playback-allows-inline")]
    pub fn connect_media_playback_allows_inline_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_media_playback_allows_inline_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::media-playback-allows-inline\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_media_playback_allows_inline_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "media-playback-requires-user-gesture")]
    pub fn connect_media_playback_requires_user_gesture_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_media_playback_requires_user_gesture_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::media-playback-requires-user-gesture\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_media_playback_requires_user_gesture_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "minimum-font-size")]
    pub fn connect_minimum_font_size_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_minimum_font_size_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::minimum-font-size\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_minimum_font_size_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "monospace-font-family")]
    pub fn connect_monospace_font_family_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_monospace_font_family_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::monospace-font-family\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_monospace_font_family_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "pictograph-font-family")]
    pub fn connect_pictograph_font_family_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_pictograph_font_family_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pictograph-font-family\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_pictograph_font_family_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "print-backgrounds")]
    pub fn connect_print_backgrounds_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_print_backgrounds_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::print-backgrounds\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_print_backgrounds_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "sans-serif-font-family")]
    pub fn connect_sans_serif_font_family_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_sans_serif_font_family_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::sans-serif-font-family\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_sans_serif_font_family_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "serif-font-family")]
    pub fn connect_serif_font_family_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_serif_font_family_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::serif-font-family\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_serif_font_family_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "user-agent")]
    pub fn connect_user_agent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_user_agent_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::user-agent\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_user_agent_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "zoom-text-only")]
    pub fn connect_zoom_text_only_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_zoom_text_only_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::WebKitSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::zoom-text-only\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_zoom_text_only_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for Settings {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Settings`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct SettingsBuilder {
    builder: glib::object::ObjectBuilder<'static, Settings>,
}

impl SettingsBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn allow_file_access_from_file_urls(self, allow_file_access_from_file_urls: bool) -> Self {
        Self {
            builder: self.builder.property(
                "allow-file-access-from-file-urls",
                allow_file_access_from_file_urls,
            ),
        }
    }

    pub fn allow_modal_dialogs(self, allow_modal_dialogs: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("allow-modal-dialogs", allow_modal_dialogs),
        }
    }

    pub fn allow_top_navigation_to_data_urls(
        self,
        allow_top_navigation_to_data_urls: bool,
    ) -> Self {
        Self {
            builder: self.builder.property(
                "allow-top-navigation-to-data-urls",
                allow_top_navigation_to_data_urls,
            ),
        }
    }

    pub fn allow_universal_access_from_file_urls(
        self,
        allow_universal_access_from_file_urls: bool,
    ) -> Self {
        Self {
            builder: self.builder.property(
                "allow-universal-access-from-file-urls",
                allow_universal_access_from_file_urls,
            ),
        }
    }

    pub fn auto_load_images(self, auto_load_images: bool) -> Self {
        Self {
            builder: self.builder.property("auto-load-images", auto_load_images),
        }
    }

    pub fn cursive_font_family(self, cursive_font_family: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("cursive-font-family", cursive_font_family.into()),
        }
    }

    pub fn default_charset(self, default_charset: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("default-charset", default_charset.into()),
        }
    }

    pub fn default_font_family(self, default_font_family: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("default-font-family", default_font_family.into()),
        }
    }

    pub fn default_font_size(self, default_font_size: u32) -> Self {
        Self {
            builder: self
                .builder
                .property("default-font-size", default_font_size),
        }
    }

    pub fn default_monospace_font_size(self, default_monospace_font_size: u32) -> Self {
        Self {
            builder: self
                .builder
                .property("default-monospace-font-size", default_monospace_font_size),
        }
    }

    pub fn disable_web_security(self, disable_web_security: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("disable-web-security", disable_web_security),
        }
    }

    pub fn draw_compositing_indicators(self, draw_compositing_indicators: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("draw-compositing-indicators", draw_compositing_indicators),
        }
    }

    #[cfg(feature = "v2_46")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_46")))]
    pub fn enable_2d_canvas_acceleration(self, enable_2d_canvas_acceleration: bool) -> Self {
        Self {
            builder: self.builder.property(
                "enable-2d-canvas-acceleration",
                enable_2d_canvas_acceleration,
            ),
        }
    }

    pub fn enable_back_forward_navigation_gestures(
        self,
        enable_back_forward_navigation_gestures: bool,
    ) -> Self {
        Self {
            builder: self.builder.property(
                "enable-back-forward-navigation-gestures",
                enable_back_forward_navigation_gestures,
            ),
        }
    }

    pub fn enable_caret_browsing(self, enable_caret_browsing: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("enable-caret-browsing", enable_caret_browsing),
        }
    }

    pub fn enable_developer_extras(self, enable_developer_extras: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("enable-developer-extras", enable_developer_extras),
        }
    }

    pub fn enable_dns_prefetching(self, enable_dns_prefetching: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("enable-dns-prefetching", enable_dns_prefetching),
        }
    }

    pub fn enable_encrypted_media(self, enable_encrypted_media: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("enable-encrypted-media", enable_encrypted_media),
        }
    }

    pub fn enable_fullscreen(self, enable_fullscreen: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("enable-fullscreen", enable_fullscreen),
        }
    }

    pub fn enable_html5_database(self, enable_html5_database: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("enable-html5-database", enable_html5_database),
        }
    }

    pub fn enable_html5_local_storage(self, enable_html5_local_storage: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("enable-html5-local-storage", enable_html5_local_storage),
        }
    }

    pub fn enable_hyperlink_auditing(self, enable_hyperlink_auditing: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("enable-hyperlink-auditing", enable_hyperlink_auditing),
        }
    }

    pub fn enable_javascript(self, enable_javascript: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("enable-javascript", enable_javascript),
        }
    }

    pub fn enable_javascript_markup(self, enable_javascript_markup: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("enable-javascript-markup", enable_javascript_markup),
        }
    }

    pub fn enable_media(self, enable_media: bool) -> Self {
        Self {
            builder: self.builder.property("enable-media", enable_media),
        }
    }

    pub fn enable_media_capabilities(self, enable_media_capabilities: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("enable-media-capabilities", enable_media_capabilities),
        }
    }

    pub fn enable_media_stream(self, enable_media_stream: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("enable-media-stream", enable_media_stream),
        }
    }

    pub fn enable_mediasource(self, enable_mediasource: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("enable-mediasource", enable_mediasource),
        }
    }

    pub fn enable_mock_capture_devices(self, enable_mock_capture_devices: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("enable-mock-capture-devices", enable_mock_capture_devices),
        }
    }

    #[cfg_attr(feature = "v2_44", deprecated = "Since 2.44")]
    pub fn enable_offline_web_application_cache(
        self,
        enable_offline_web_application_cache: bool,
    ) -> Self {
        Self {
            builder: self.builder.property(
                "enable-offline-web-application-cache",
                enable_offline_web_application_cache,
            ),
        }
    }

    pub fn enable_page_cache(self, enable_page_cache: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("enable-page-cache", enable_page_cache),
        }
    }

    pub fn enable_resizable_text_areas(self, enable_resizable_text_areas: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("enable-resizable-text-areas", enable_resizable_text_areas),
        }
    }

    pub fn enable_site_specific_quirks(self, enable_site_specific_quirks: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("enable-site-specific-quirks", enable_site_specific_quirks),
        }
    }

    pub fn enable_smooth_scrolling(self, enable_smooth_scrolling: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("enable-smooth-scrolling", enable_smooth_scrolling),
        }
    }

    pub fn enable_spatial_navigation(self, enable_spatial_navigation: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("enable-spatial-navigation", enable_spatial_navigation),
        }
    }

    pub fn enable_tabs_to_links(self, enable_tabs_to_links: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("enable-tabs-to-links", enable_tabs_to_links),
        }
    }

    pub fn enable_webaudio(self, enable_webaudio: bool) -> Self {
        Self {
            builder: self.builder.property("enable-webaudio", enable_webaudio),
        }
    }

    pub fn enable_webgl(self, enable_webgl: bool) -> Self {
        Self {
            builder: self.builder.property("enable-webgl", enable_webgl),
        }
    }

    pub fn enable_webrtc(self, enable_webrtc: bool) -> Self {
        Self {
            builder: self.builder.property("enable-webrtc", enable_webrtc),
        }
    }

    pub fn enable_write_console_messages_to_stdout(
        self,
        enable_write_console_messages_to_stdout: bool,
    ) -> Self {
        Self {
            builder: self.builder.property(
                "enable-write-console-messages-to-stdout",
                enable_write_console_messages_to_stdout,
            ),
        }
    }

    pub fn fantasy_font_family(self, fantasy_font_family: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("fantasy-font-family", fantasy_font_family.into()),
        }
    }

    pub fn hardware_acceleration_policy(
        self,
        hardware_acceleration_policy: HardwareAccelerationPolicy,
    ) -> Self {
        Self {
            builder: self
                .builder
                .property("hardware-acceleration-policy", hardware_acceleration_policy),
        }
    }

    pub fn javascript_can_access_clipboard(self, javascript_can_access_clipboard: bool) -> Self {
        Self {
            builder: self.builder.property(
                "javascript-can-access-clipboard",
                javascript_can_access_clipboard,
            ),
        }
    }

    pub fn javascript_can_open_windows_automatically(
        self,
        javascript_can_open_windows_automatically: bool,
    ) -> Self {
        Self {
            builder: self.builder.property(
                "javascript-can-open-windows-automatically",
                javascript_can_open_windows_automatically,
            ),
        }
    }

    #[cfg_attr(feature = "v2_42", deprecated = "Since 2.42")]
    pub fn load_icons_ignoring_image_load_setting(
        self,
        load_icons_ignoring_image_load_setting: bool,
    ) -> Self {
        Self {
            builder: self.builder.property(
                "load-icons-ignoring-image-load-setting",
                load_icons_ignoring_image_load_setting,
            ),
        }
    }

    pub fn media_content_types_requiring_hardware_support(
        self,
        media_content_types_requiring_hardware_support: impl Into<glib::GString>,
    ) -> Self {
        Self {
            builder: self.builder.property(
                "media-content-types-requiring-hardware-support",
                media_content_types_requiring_hardware_support.into(),
            ),
        }
    }

    pub fn media_playback_allows_inline(self, media_playback_allows_inline: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("media-playback-allows-inline", media_playback_allows_inline),
        }
    }

    pub fn media_playback_requires_user_gesture(
        self,
        media_playback_requires_user_gesture: bool,
    ) -> Self {
        Self {
            builder: self.builder.property(
                "media-playback-requires-user-gesture",
                media_playback_requires_user_gesture,
            ),
        }
    }

    pub fn minimum_font_size(self, minimum_font_size: u32) -> Self {
        Self {
            builder: self
                .builder
                .property("minimum-font-size", minimum_font_size),
        }
    }

    pub fn monospace_font_family(self, monospace_font_family: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("monospace-font-family", monospace_font_family.into()),
        }
    }

    pub fn pictograph_font_family(self, pictograph_font_family: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("pictograph-font-family", pictograph_font_family.into()),
        }
    }

    pub fn print_backgrounds(self, print_backgrounds: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("print-backgrounds", print_backgrounds),
        }
    }

    pub fn sans_serif_font_family(self, sans_serif_font_family: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("sans-serif-font-family", sans_serif_font_family.into()),
        }
    }

    pub fn serif_font_family(self, serif_font_family: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("serif-font-family", serif_font_family.into()),
        }
    }

    pub fn user_agent(self, user_agent: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("user-agent", user_agent.into()),
        }
    }

    pub fn zoom_text_only(self, zoom_text_only: bool) -> Self {
        Self {
            builder: self.builder.property("zoom-text-only", zoom_text_only),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Settings`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Settings {
        self.builder.build()
    }
}
