use chrono::{DateTime, Utc};
use glib::Boxed;

#[derive(Copy, Clone, Debug, PartialEq, Eq, Boxed)]
#[boxed_type(name = "NewsFlashGDateTime")]
pub struct GDateTime(DateTime<Utc>);

impl From<GDateTime> for DateTime<Utc> {
    fn from(dt: GDateTime) -> Self {
        dt.0
    }
}

impl From<DateTime<Utc>> for GDateTime {
    fn from(dt: DateTime<Utc>) -> Self {
        Self(dt)
    }
}

impl AsRef<DateTime<Utc>> for GDateTime {
    fn as_ref(&self) -> &DateTime<Utc> {
        &self.0
    }
}

impl Default for GDateTime {
    fn default() -> Self {
        Self(Utc::now())
    }
}

#[derive(Copy, Clone, Debug, Default, PartialEq, Eq, Boxed)]
#[boxed_type(name = "NewsFlashGOptionalDateTime")]
pub struct GOptionalDateTime(Option<DateTime<Utc>>);

impl From<GOptionalDateTime> for Option<DateTime<Utc>> {
    fn from(dt: GOptionalDateTime) -> Self {
        dt.0
    }
}

impl From<DateTime<Utc>> for GOptionalDateTime {
    fn from(dt: DateTime<Utc>) -> Self {
        Self(Some(dt))
    }
}

impl From<Option<DateTime<Utc>>> for GOptionalDateTime {
    fn from(dt: Option<DateTime<Utc>>) -> Self {
        Self(dt)
    }
}

impl AsRef<Option<DateTime<Utc>>> for GOptionalDateTime {
    fn as_ref(&self) -> &Option<DateTime<Utc>> {
        &self.0
    }
}
