/* Upgrades.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Upgrades.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/
/* Class for aggregating one-off "upgrade" tasks that occur at startup, such as*/
/* moving or deleting files. This occurs after the UI is shown, so it's not appropriate*/
/* for database updates and such.*/

#include "io.elementary.photos.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_UPGRADE_TASK (upgrade_task_get_type ())
#define UPGRADE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UPGRADE_TASK, UpgradeTask))
#define IS_UPGRADE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UPGRADE_TASK))
#define UPGRADE_TASK_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_UPGRADE_TASK, UpgradeTaskIface))

typedef struct _UpgradeTask UpgradeTask;
typedef struct _UpgradeTaskIface UpgradeTaskIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MIMICS_REMOVAL_TASK (mimics_removal_task_get_type ())
#define MIMICS_REMOVAL_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MIMICS_REMOVAL_TASK, MimicsRemovalTask))
#define MIMICS_REMOVAL_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MIMICS_REMOVAL_TASK, MimicsRemovalTaskClass))
#define IS_MIMICS_REMOVAL_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MIMICS_REMOVAL_TASK))
#define IS_MIMICS_REMOVAL_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MIMICS_REMOVAL_TASK))
#define MIMICS_REMOVAL_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MIMICS_REMOVAL_TASK, MimicsRemovalTaskClass))

typedef struct _MimicsRemovalTask MimicsRemovalTask;
typedef struct _MimicsRemovalTaskClass MimicsRemovalTaskClass;

#define TYPE_FIXUP_RAW_THUMBNAILS_TASK (fixup_raw_thumbnails_task_get_type ())
#define FIXUP_RAW_THUMBNAILS_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FIXUP_RAW_THUMBNAILS_TASK, FixupRawThumbnailsTask))
#define FIXUP_RAW_THUMBNAILS_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FIXUP_RAW_THUMBNAILS_TASK, FixupRawThumbnailsTaskClass))
#define IS_FIXUP_RAW_THUMBNAILS_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FIXUP_RAW_THUMBNAILS_TASK))
#define IS_FIXUP_RAW_THUMBNAILS_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FIXUP_RAW_THUMBNAILS_TASK))
#define FIXUP_RAW_THUMBNAILS_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FIXUP_RAW_THUMBNAILS_TASK, FixupRawThumbnailsTaskClass))

typedef struct _FixupRawThumbnailsTask FixupRawThumbnailsTask;
typedef struct _FixupRawThumbnailsTaskClass FixupRawThumbnailsTaskClass;
#define _upgrades_unref0(var) ((var == NULL) ? NULL : (var = (upgrades_unref (var), NULL)))
typedef struct _ParamSpecUpgrades ParamSpecUpgrades;
typedef struct _MimicsRemovalTaskPrivate MimicsRemovalTaskPrivate;
enum  {
	MIMICS_REMOVAL_TASK_0_PROPERTY,
	MIMICS_REMOVAL_TASK_NUM_PROPERTIES
};
static GParamSpec* mimics_removal_task_properties[MIMICS_REMOVAL_TASK_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FixupRawThumbnailsTaskPrivate FixupRawThumbnailsTaskPrivate;
enum  {
	FIXUP_RAW_THUMBNAILS_TASK_0_PROPERTY,
	FIXUP_RAW_THUMBNAILS_TASK_NUM_PROPERTIES
};
static GParamSpec* fixup_raw_thumbnails_task_properties[FIXUP_RAW_THUMBNAILS_TASK_NUM_PROPERTIES];
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _photo_row_unref0(var) ((var == NULL) ? NULL : (var = (photo_row_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _UpgradeTaskIface {
	GTypeInterface parent_iface;
	guint64 (*get_step_count) (UpgradeTask* self);
	void (*execute) (UpgradeTask* self, ProgressMonitor monitor, gpointer monitor_target);
};

struct _UpgradesPrivate {
	guint64 total_steps;
	GeeLinkedList* task_list;
};

struct _ParamSpecUpgrades {
	GParamSpec parent_instance;
};

struct _MimicsRemovalTask {
	GObject parent_instance;
	MimicsRemovalTaskPrivate * priv;
};

struct _MimicsRemovalTaskClass {
	GObjectClass parent_class;
};

struct _MimicsRemovalTaskPrivate {
	GFile* mimic_dir;
	guint64 num_mimics;
};

struct _FixupRawThumbnailsTask {
	GObject parent_instance;
	FixupRawThumbnailsTaskPrivate * priv;
};

struct _FixupRawThumbnailsTaskClass {
	GObjectClass parent_class;
};

static gint Upgrades_private_offset;
static gpointer upgrades_parent_class = NULL;
static Upgrades* upgrades_instance;
static Upgrades* upgrades_instance = NULL;
static gint MimicsRemovalTask_private_offset;
static gpointer mimics_removal_task_parent_class = NULL;
static UpgradeTaskIface * mimics_removal_task_upgrade_task_parent_iface = NULL;
static gpointer fixup_raw_thumbnails_task_parent_class = NULL;
static UpgradeTaskIface * fixup_raw_thumbnails_task_upgrade_task_parent_iface = NULL;

VALA_EXTERN GType upgrade_task_get_type (void) G_GNUC_CONST ;
static Upgrades* upgrades_new (void);
static Upgrades* upgrades_construct (GType object_type);
static void upgrades_add (Upgrades* self,
                   UpgradeTask* task);
VALA_EXTERN MimicsRemovalTask* mimics_removal_task_new (void);
VALA_EXTERN MimicsRemovalTask* mimics_removal_task_construct (GType object_type);
VALA_EXTERN GType mimics_removal_task_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FixupRawThumbnailsTask* fixup_raw_thumbnails_task_new (void);
VALA_EXTERN FixupRawThumbnailsTask* fixup_raw_thumbnails_task_construct (GType object_type);
VALA_EXTERN GType fixup_raw_thumbnails_task_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void upgrade_task_execute (UpgradeTask* self,
                           ProgressMonitor monitor,
                           gpointer monitor_target);
VALA_EXTERN guint64 upgrade_task_get_step_count (UpgradeTask* self);
static void upgrades_finalize (Upgrades * obj);
static GType upgrades_get_type_once (void);
static GType upgrade_task_get_type_once (void);
VALA_EXTERN GFile* app_dirs_get_data_dir (void);
static guint64 mimics_removal_task_real_get_step_count (UpgradeTask* base);
static void mimics_removal_task_real_execute (UpgradeTask* base,
                                       ProgressMonitor monitor,
                                       gpointer monitor_target);
static void mimics_removal_task_finalize (GObject * obj);
static GType mimics_removal_task_get_type_once (void);
static guint64 fixup_raw_thumbnails_task_real_get_step_count (UpgradeTask* base);
static void fixup_raw_thumbnails_task_real_execute (UpgradeTask* base,
                                             ProgressMonitor monitor,
                                             gpointer monitor_target);
static GType fixup_raw_thumbnails_task_get_type_once (void);

static inline gpointer
upgrades_get_instance_private (Upgrades* self)
{
	return G_STRUCT_MEMBER_P (self, Upgrades_private_offset);
}

static Upgrades*
upgrades_construct (GType object_type)
{
	Upgrades* self = NULL;
	MimicsRemovalTask* _tmp0_;
	MimicsRemovalTask* _tmp1_;
	GApplication* _tmp2_;
	self = (Upgrades*) g_type_create_instance (object_type);
	_tmp0_ = mimics_removal_task_new ();
	_tmp1_ = _tmp0_;
	upgrades_add (self, (UpgradeTask*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = g_application_get_default ();
	if (photos_application_get_raw_thumbs_fix_required (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, PHOTOS_TYPE_APPLICATION, PhotosApplication))) {
		FixupRawThumbnailsTask* _tmp3_;
		FixupRawThumbnailsTask* _tmp4_;
		_tmp3_ = fixup_raw_thumbnails_task_new ();
		_tmp4_ = _tmp3_;
		upgrades_add (self, (UpgradeTask*) _tmp4_);
		_g_object_unref0 (_tmp4_);
	}
	return self;
}

static Upgrades*
upgrades_new (void)
{
	return upgrades_construct (TYPE_UPGRADES);
}

void
upgrades_init (void)
{
	Upgrades* _tmp0_;
	Upgrades* _tmp1_;
	_tmp0_ = upgrades_instance;
	_vala_assert (_tmp0_ == NULL, "instance == null");
	_tmp1_ = upgrades_new ();
	_upgrades_unref0 (upgrades_instance);
	upgrades_instance = _tmp1_;
}

static gpointer
_upgrades_ref0 (gpointer self)
{
	return self ? upgrades_ref (self) : NULL;
}

Upgrades*
upgrades_get_instance (void)
{
	Upgrades* _tmp0_;
	Upgrades* _tmp1_;
	Upgrades* result;
	_tmp0_ = upgrades_instance;
	_tmp1_ = _upgrades_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

guint64
upgrades_get_step_count (Upgrades* self)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	result = self->priv->total_steps;
	return result;
}

void
upgrades_execute (Upgrades* self,
                  ProgressMonitor monitor,
                  gpointer monitor_target)
{
	g_return_if_fail (self != NULL);
	{
		GeeLinkedList* _task_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _task_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _task_index = 0;
		_tmp0_ = self->priv->task_list;
		_task_list = _tmp0_;
		_tmp1_ = _task_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_task_size = _tmp3_;
		_task_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			UpgradeTask* task = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			UpgradeTask* _tmp8_;
			_task_index = _task_index + 1;
			_tmp4_ = _task_index;
			_tmp5_ = _task_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _task_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _task_index);
			task = (UpgradeTask*) _tmp7_;
			_tmp8_ = task;
			upgrade_task_execute (_tmp8_, monitor, monitor_target);
			_g_object_unref0 (task);
		}
	}
}

static void
upgrades_add (Upgrades* self,
              UpgradeTask* task)
{
	GeeLinkedList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (task != NULL);
	self->priv->total_steps = self->priv->total_steps + upgrade_task_get_step_count (task);
	_tmp0_ = self->priv->task_list;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, task);
}

static void
value_upgrades_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_upgrades_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		upgrades_unref (value->data[0].v_pointer);
	}
}

static void
value_upgrades_copy_value (const GValue* src_value,
                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = upgrades_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_upgrades_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_upgrades_collect_value (GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		Upgrades * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = upgrades_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_upgrades_lcopy_value (const GValue* value,
                            guint n_collect_values,
                            GTypeCValue* collect_values,
                            guint collect_flags)
{
	Upgrades ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = upgrades_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_upgrades (const gchar* name,
                     const gchar* nick,
                     const gchar* blurb,
                     GType object_type,
                     GParamFlags flags)
{
	ParamSpecUpgrades* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_UPGRADES), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_upgrades (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UPGRADES), NULL);
	return value->data[0].v_pointer;
}

void
value_set_upgrades (GValue* value,
                    gpointer v_object)
{
	Upgrades * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UPGRADES));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_UPGRADES));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		upgrades_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		upgrades_unref (old);
	}
}

void
value_take_upgrades (GValue* value,
                     gpointer v_object)
{
	Upgrades * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UPGRADES));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_UPGRADES));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		upgrades_unref (old);
	}
}

static void
upgrades_class_init (UpgradesClass * klass,
                     gpointer klass_data)
{
	upgrades_parent_class = g_type_class_peek_parent (klass);
	((UpgradesClass *) klass)->finalize = upgrades_finalize;
	g_type_class_adjust_private_offset (klass, &Upgrades_private_offset);
}

static void
upgrades_instance_init (Upgrades * self,
                        gpointer klass)
{
	GeeLinkedList* _tmp0_;
	self->priv = upgrades_get_instance_private (self);
	self->priv->total_steps = (guint64) 0;
	_tmp0_ = gee_linked_list_new (TYPE_UPGRADE_TASK, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->task_list = _tmp0_;
	self->ref_count = 1;
}

static void
upgrades_finalize (Upgrades * obj)
{
	Upgrades * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UPGRADES, Upgrades);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->task_list);
}

static GType
upgrades_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_upgrades_init, value_upgrades_free_value, value_upgrades_copy_value, value_upgrades_peek_pointer, "p", value_upgrades_collect_value, "p", value_upgrades_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (UpgradesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) upgrades_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Upgrades), 0, (GInstanceInitFunc) upgrades_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType upgrades_type_id;
	upgrades_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Upgrades", &g_define_type_info, &g_define_type_fundamental_info, 0);
	Upgrades_private_offset = g_type_add_instance_private (upgrades_type_id, sizeof (UpgradesPrivate));
	return upgrades_type_id;
}

GType
upgrades_get_type (void)
{
	static volatile gsize upgrades_type_id__once = 0;
	if (g_once_init_enter (&upgrades_type_id__once)) {
		GType upgrades_type_id;
		upgrades_type_id = upgrades_get_type_once ();
		g_once_init_leave (&upgrades_type_id__once, upgrades_type_id);
	}
	return upgrades_type_id__once;
}

gpointer
upgrades_ref (gpointer instance)
{
	Upgrades * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
upgrades_unref (gpointer instance)
{
	Upgrades * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UPGRADES_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

guint64
upgrade_task_get_step_count (UpgradeTask* self)
{
	UpgradeTaskIface* _iface_;
	g_return_val_if_fail (self != NULL, 0ULL);
	_iface_ = UPGRADE_TASK_GET_INTERFACE (self);
	if (_iface_->get_step_count) {
		return _iface_->get_step_count (self);
	}
	return 0ULL;
}

void
upgrade_task_execute (UpgradeTask* self,
                      ProgressMonitor monitor,
                      gpointer monitor_target)
{
	UpgradeTaskIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = UPGRADE_TASK_GET_INTERFACE (self);
	if (_iface_->execute) {
		_iface_->execute (self, monitor, monitor_target);
	}
}

static void
upgrade_task_default_init (UpgradeTaskIface * iface,
                           gpointer iface_data)
{
}

static GType
upgrade_task_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UpgradeTaskIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) upgrade_task_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType upgrade_task_type_id;
	upgrade_task_type_id = g_type_register_static (G_TYPE_INTERFACE, "UpgradeTask", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (upgrade_task_type_id, G_TYPE_OBJECT);
	return upgrade_task_type_id;
}

GType
upgrade_task_get_type (void)
{
	static volatile gsize upgrade_task_type_id__once = 0;
	if (g_once_init_enter (&upgrade_task_type_id__once)) {
		GType upgrade_task_type_id;
		upgrade_task_type_id = upgrade_task_get_type_once ();
		g_once_init_leave (&upgrade_task_type_id__once, upgrade_task_type_id);
	}
	return upgrade_task_type_id__once;
}

static inline gpointer
mimics_removal_task_get_instance_private (MimicsRemovalTask* self)
{
	return G_STRUCT_MEMBER_P (self, MimicsRemovalTask_private_offset);
}

static guint64
mimics_removal_task_real_get_step_count (UpgradeTask* base)
{
	MimicsRemovalTask * self;
	GError* _inner_error0_ = NULL;
	guint64 result;
	self = (MimicsRemovalTask*) base;
	{
		guint64 _tmp0_ = 0ULL;
		GFile* _tmp1_;
		_tmp1_ = self->priv->mimic_dir;
		_tmp0_ = count_files_in_directory (_tmp1_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		self->priv->num_mimics = _tmp0_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_debug ("Upgrades.vala:88: Error on deleting mimics: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		guint64 _tmp4_ = 0ULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
	result = self->priv->num_mimics;
	return result;
}

static void
mimics_removal_task_real_execute (UpgradeTask* base,
                                  ProgressMonitor monitor,
                                  gpointer monitor_target)
{
	MimicsRemovalTask * self;
	GError* _inner_error0_ = NULL;
	self = (MimicsRemovalTask*) base;
	{
		GFile* _tmp0_;
		GFile* _tmp1_;
		_tmp0_ = self->priv->mimic_dir;
		delete_all_files (_tmp0_, NULL, monitor, monitor_target, self->priv->num_mimics, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = self->priv->mimic_dir;
		g_file_delete (_tmp1_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_debug ("Upgrades.vala:98: Could not delete mimics: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

MimicsRemovalTask*
mimics_removal_task_construct (GType object_type)
{
	MimicsRemovalTask * self = NULL;
	self = (MimicsRemovalTask*) g_object_new (object_type, NULL);
	return self;
}

MimicsRemovalTask*
mimics_removal_task_new (void)
{
	return mimics_removal_task_construct (TYPE_MIMICS_REMOVAL_TASK);
}

static void
mimics_removal_task_class_init (MimicsRemovalTaskClass * klass,
                                gpointer klass_data)
{
	mimics_removal_task_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MimicsRemovalTask_private_offset);
	G_OBJECT_CLASS (klass)->finalize = mimics_removal_task_finalize;
}

static void
mimics_removal_task_upgrade_task_interface_init (UpgradeTaskIface * iface,
                                                 gpointer iface_data)
{
	mimics_removal_task_upgrade_task_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_step_count = (guint64 (*) (UpgradeTask*)) mimics_removal_task_real_get_step_count;
	iface->execute = (void (*) (UpgradeTask*, ProgressMonitor, gpointer)) mimics_removal_task_real_execute;
}

static void
mimics_removal_task_instance_init (MimicsRemovalTask * self,
                                   gpointer klass)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	self->priv = mimics_removal_task_get_instance_private (self);
	_tmp0_ = app_dirs_get_data_dir ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_child (_tmp1_, "mimics");
	self->priv->mimic_dir = _tmp2_;
	_g_object_unref0 (_tmp1_);
	self->priv->num_mimics = (guint64) 0;
}

static void
mimics_removal_task_finalize (GObject * obj)
{
	MimicsRemovalTask * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MIMICS_REMOVAL_TASK, MimicsRemovalTask);
	_g_object_unref0 (self->priv->mimic_dir);
	G_OBJECT_CLASS (mimics_removal_task_parent_class)->finalize (obj);
}

static GType
mimics_removal_task_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MimicsRemovalTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mimics_removal_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MimicsRemovalTask), 0, (GInstanceInitFunc) mimics_removal_task_instance_init, NULL };
	static const GInterfaceInfo upgrade_task_info = { (GInterfaceInitFunc) mimics_removal_task_upgrade_task_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType mimics_removal_task_type_id;
	mimics_removal_task_type_id = g_type_register_static (G_TYPE_OBJECT, "MimicsRemovalTask", &g_define_type_info, 0);
	g_type_add_interface_static (mimics_removal_task_type_id, TYPE_UPGRADE_TASK, &upgrade_task_info);
	MimicsRemovalTask_private_offset = g_type_add_instance_private (mimics_removal_task_type_id, sizeof (MimicsRemovalTaskPrivate));
	return mimics_removal_task_type_id;
}

GType
mimics_removal_task_get_type (void)
{
	static volatile gsize mimics_removal_task_type_id__once = 0;
	if (g_once_init_enter (&mimics_removal_task_type_id__once)) {
		GType mimics_removal_task_type_id;
		mimics_removal_task_type_id = mimics_removal_task_get_type_once ();
		g_once_init_leave (&mimics_removal_task_type_id__once, mimics_removal_task_type_id);
	}
	return mimics_removal_task_type_id__once;
}

static guint64
fixup_raw_thumbnails_task_real_get_step_count (UpgradeTask* base)
{
	FixupRawThumbnailsTask * self;
	gint num_raw_files = 0;
	guint64 result;
	self = (FixupRawThumbnailsTask*) base;
	num_raw_files = 0;
	{
		GeeArrayList* _phr_list = NULL;
		PhotoTable* _tmp0_;
		PhotoTable* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _tmp3_;
		gint _phr_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _phr_index = 0;
		_tmp0_ = photo_table_get_instance ();
		_tmp1_ = _tmp0_;
		_tmp2_ = photo_table_get_all (_tmp1_);
		_tmp3_ = _tmp2_;
		_database_table_unref0 (_tmp1_);
		_phr_list = _tmp3_;
		_tmp4_ = _phr_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_phr_size = _tmp6_;
		_phr_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			PhotoRow* phr = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			PhotoRow* _tmp11_;
			BackingPhotoRow* _tmp12_;
			_phr_index = _phr_index + 1;
			_tmp7_ = _phr_index;
			_tmp8_ = _phr_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _phr_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _phr_index);
			phr = (PhotoRow*) _tmp10_;
			_tmp11_ = phr;
			_tmp12_ = _tmp11_->master;
			if (_tmp12_->file_format == PHOTO_FILE_FORMAT_RAW) {
				gint _tmp13_;
				_tmp13_ = num_raw_files;
				num_raw_files = _tmp13_ + 1;
			}
			_photo_row_unref0 (phr);
		}
		_g_object_unref0 (_phr_list);
	}
	result = (guint64) num_raw_files;
	return result;
}

static void
fixup_raw_thumbnails_task_real_execute (UpgradeTask* base,
                                        ProgressMonitor monitor,
                                        gpointer monitor_target)
{
	FixupRawThumbnailsTask * self;
	self = (FixupRawThumbnailsTask*) base;
	g_debug ("Upgrades.vala:118: Executing thumbnail deletion and fixup");
	{
		GeeArrayList* _phr_list = NULL;
		PhotoTable* _tmp0_;
		PhotoTable* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _tmp3_;
		gint _phr_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _phr_index = 0;
		_tmp0_ = photo_table_get_instance ();
		_tmp1_ = _tmp0_;
		_tmp2_ = photo_table_get_all (_tmp1_);
		_tmp3_ = _tmp2_;
		_database_table_unref0 (_tmp1_);
		_phr_list = _tmp3_;
		_tmp4_ = _phr_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_phr_size = _tmp6_;
		_phr_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			PhotoRow* phr = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			gboolean _tmp11_ = FALSE;
			PhotoRow* _tmp12_;
			BackingPhotoRow* _tmp13_;
			_phr_index = _phr_index + 1;
			_tmp7_ = _phr_index;
			_tmp8_ = _phr_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _phr_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _phr_index);
			phr = (PhotoRow*) _tmp10_;
			_tmp12_ = phr;
			_tmp13_ = _tmp12_->master;
			if (_tmp13_->file_format == PHOTO_FILE_FORMAT_RAW) {
				PhotoRow* _tmp14_;
				_tmp14_ = phr;
				_tmp11_ = _tmp14_->developer == RAW_DEVELOPER_CAMERA;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				LibraryPhotoSourceCollection* _tmp15_;
				PhotoRow* _tmp16_;
				PhotoID _tmp17_;
				LibraryPhoto* _tmp18_;
				LibraryPhoto* _tmp19_;
				_tmp15_ = library_photo_global;
				_tmp16_ = phr;
				_tmp17_ = _tmp16_->photo_id;
				_tmp18_ = library_photo_source_collection_fetch (_tmp15_, &_tmp17_);
				_tmp19_ = _tmp18_;
				thumbnail_cache_remove ((ThumbnailSource*) _tmp19_);
				_g_object_unref0 (_tmp19_);
			}
			_photo_row_unref0 (phr);
		}
		_g_object_unref0 (_phr_list);
	}
}

FixupRawThumbnailsTask*
fixup_raw_thumbnails_task_construct (GType object_type)
{
	FixupRawThumbnailsTask * self = NULL;
	self = (FixupRawThumbnailsTask*) g_object_new (object_type, NULL);
	return self;
}

FixupRawThumbnailsTask*
fixup_raw_thumbnails_task_new (void)
{
	return fixup_raw_thumbnails_task_construct (TYPE_FIXUP_RAW_THUMBNAILS_TASK);
}

static void
fixup_raw_thumbnails_task_class_init (FixupRawThumbnailsTaskClass * klass,
                                      gpointer klass_data)
{
	fixup_raw_thumbnails_task_parent_class = g_type_class_peek_parent (klass);
}

static void
fixup_raw_thumbnails_task_upgrade_task_interface_init (UpgradeTaskIface * iface,
                                                       gpointer iface_data)
{
	fixup_raw_thumbnails_task_upgrade_task_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_step_count = (guint64 (*) (UpgradeTask*)) fixup_raw_thumbnails_task_real_get_step_count;
	iface->execute = (void (*) (UpgradeTask*, ProgressMonitor, gpointer)) fixup_raw_thumbnails_task_real_execute;
}

static void
fixup_raw_thumbnails_task_instance_init (FixupRawThumbnailsTask * self,
                                         gpointer klass)
{
}

static GType
fixup_raw_thumbnails_task_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FixupRawThumbnailsTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fixup_raw_thumbnails_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FixupRawThumbnailsTask), 0, (GInstanceInitFunc) fixup_raw_thumbnails_task_instance_init, NULL };
	static const GInterfaceInfo upgrade_task_info = { (GInterfaceInitFunc) fixup_raw_thumbnails_task_upgrade_task_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType fixup_raw_thumbnails_task_type_id;
	fixup_raw_thumbnails_task_type_id = g_type_register_static (G_TYPE_OBJECT, "FixupRawThumbnailsTask", &g_define_type_info, 0);
	g_type_add_interface_static (fixup_raw_thumbnails_task_type_id, TYPE_UPGRADE_TASK, &upgrade_task_info);
	return fixup_raw_thumbnails_task_type_id;
}

GType
fixup_raw_thumbnails_task_get_type (void)
{
	static volatile gsize fixup_raw_thumbnails_task_type_id__once = 0;
	if (g_once_init_enter (&fixup_raw_thumbnails_task_type_id__once)) {
		GType fixup_raw_thumbnails_task_type_id;
		fixup_raw_thumbnails_task_type_id = fixup_raw_thumbnails_task_get_type_once ();
		g_once_init_leave (&fixup_raw_thumbnails_task_type_id__once, fixup_raw_thumbnails_task_type_id);
	}
	return fixup_raw_thumbnails_task_type_id__once;
}

