/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 * Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtGui.h"

#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtGui/qdesktopservices.sip"
#include <qdesktopservices.h>
#line 29 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQDesktopServices.cpp"

#line 27 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 33 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQDesktopServices.cpp"
#line 28 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qobject.sip"
#include <qobject.h>
#line 36 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQDesktopServices.cpp"
#line 109 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qurl.sip"
#include <qurl.h>
#line 39 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQDesktopServices.cpp"


PyDoc_STRVAR(doc_QDesktopServices_openUrl, "openUrl(url: QUrl) -> bool");

extern "C" {static PyObject *meth_QDesktopServices_openUrl(PyObject *, PyObject *);}
static PyObject *meth_QDesktopServices_openUrl(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QUrl* a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "J9", sipType_QUrl, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = ::QDesktopServices::openUrl(*a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDesktopServices, sipName_openUrl, doc_QDesktopServices_openUrl);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDesktopServices_setUrlHandler, "setUrlHandler(scheme: str|None, receiver: QObject|None, method: str)\n"
"setUrlHandler(scheme: str|None, method: Callable[[QUrl], None])");

extern "C" {static PyObject *meth_QDesktopServices_setUrlHandler(PyObject *, PyObject *);}
static PyObject *meth_QDesktopServices_setUrlHandler(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QObject* a1;
        const char* a2;
        PyObject *a2Keep;

        if (sipParseArgs(&sipParseErr, sipArgs, "J1J8AA", sipType_QString, &a0, &a0State, sipType_QObject, &a1, &a2Keep, &a2))
        {
            ::QDesktopServices::setUrlHandler(*a0, a1, a2);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            Py_DECREF(a2Keep);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::QString* a0;
        int a0State = 0;
        PyObject * a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "J1F", sipType_QString, &a0, &a0State, &a1))
        {
#line 34 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtGui/qdesktopservices.sip"
        // Allow a callable that must be a slot of a QObject, although we never tell
        // the user if it isn't.
        sipMethodDef pm;
        
        if (sipGetMethod(a1, &pm))
        {
            int iserr = 0;
            QObject *receiver = reinterpret_cast<QObject *>(sipForceConvertToType(
                    pm.pm_self, sipType_QObject, NULL, SIP_NOT_NONE, NULL, &iserr));
        
            if (!iserr)
            {
                PyObject *f_name_obj = PyObject_GetAttrString(pm.pm_function, "__name__");
        
                if (f_name_obj)
                {
                    // We only want a borrowed reference.
                    Py_DECREF(f_name_obj);
        
                    const char *f_name = sipString_AsASCIIString(&f_name_obj);
        
                    if (f_name)
                    {
                        QDesktopServices::setUrlHandler(*a0, receiver, f_name);
        
                        Py_DECREF(f_name_obj);
                    }
                }
            }
        }
#line 134 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQDesktopServices.cpp"
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QDesktopServices, sipName_setUrlHandler, doc_QDesktopServices_setUrlHandler);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDesktopServices_unsetUrlHandler, "unsetUrlHandler(scheme: str|None)");

extern "C" {static PyObject *meth_QDesktopServices_unsetUrlHandler(PyObject *, PyObject *);}
static PyObject *meth_QDesktopServices_unsetUrlHandler(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "J1", sipType_QString, &a0, &a0State))
        {
            ::QDesktopServices::unsetUrlHandler(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QDesktopServices, sipName_unsetUrlHandler, doc_QDesktopServices_unsetUrlHandler);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QDesktopServices(void *, int);}
static void release_QDesktopServices(void *sipCppV, int)
{
    delete reinterpret_cast< ::QDesktopServices *>(sipCppV);
}


extern "C" {static void *array_QDesktopServices(Py_ssize_t);}
static void *array_QDesktopServices(Py_ssize_t sipNrElem)
{
    return new ::QDesktopServices[sipNrElem];
}


extern "C" {static void array_delete_QDesktopServices(void *);}
static void array_delete_QDesktopServices(void *sipCpp)
{
    delete[] reinterpret_cast< ::QDesktopServices *>(sipCpp);
}


extern "C" {static void assign_QDesktopServices(void *, Py_ssize_t, void *);}
static void assign_QDesktopServices(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QDesktopServices *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QDesktopServices *>(sipSrc);
}


extern "C" {static void *copy_QDesktopServices(const void *, Py_ssize_t);}
static void *copy_QDesktopServices(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QDesktopServices(reinterpret_cast<const ::QDesktopServices *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QDesktopServices(sipSimpleWrapper *);}
static void dealloc_QDesktopServices(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QDesktopServices(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QDesktopServices(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QDesktopServices(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QDesktopServices *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QDesktopServices();

            return sipCpp;
        }
    }

    {
        const ::QDesktopServices* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QDesktopServices, &a0))
        {
            sipCpp = new ::QDesktopServices(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QDesktopServices[] = {
    {sipName_openUrl, meth_QDesktopServices_openUrl, METH_VARARGS, doc_QDesktopServices_openUrl},
    {sipName_setUrlHandler, meth_QDesktopServices_setUrlHandler, METH_VARARGS, doc_QDesktopServices_setUrlHandler},
    {sipName_unsetUrlHandler, meth_QDesktopServices_unsetUrlHandler, METH_VARARGS, doc_QDesktopServices_unsetUrlHandler}
};

PyDoc_STRVAR(doc_QDesktopServices, "\1QDesktopServices()\n"
"QDesktopServices(a0: QDesktopServices)");


static pyqt5ClassPluginDef plugin_QDesktopServices = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtGui_QDesktopServices = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QDesktopServices,
        SIP_NULLPTR,
        &plugin_QDesktopServices,
    },
    {
        sipNameNr_QDesktopServices,
        {0, 0, 1},
        3, methods_QDesktopServices,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QDesktopServices,
    -1,
    sipNameNr_sip_simplewrapper,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QDesktopServices,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QDesktopServices,
    assign_QDesktopServices,
    array_QDesktopServices,
    copy_QDesktopServices,
    release_QDesktopServices,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QDesktopServices,
    sizeof (::QDesktopServices),
};
