/* agent-matcher.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from agent-matcher.vala, do not modify */

/* SPDX-License-Identifier: LGPL-2.1-or-later*/
/* SPDX-FileCopyrightText: 2023 Jens Georg <mail@jensge.org>*/

#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "rygel-core.h"

#define RYGEL_AGENT_MATCHER_MATCHING_PATTERN ".*%s.*"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define RYGEL_TYPE_AGENT_MATCHER (rygel_agent_matcher_get_type ())
#define RYGEL_AGENT_MATCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AGENT_MATCHER, RygelAgentMatcher))
#define RYGEL_AGENT_MATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AGENT_MATCHER, RygelAgentMatcherClass))
#define RYGEL_IS_AGENT_MATCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AGENT_MATCHER))
#define RYGEL_IS_AGENT_MATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AGENT_MATCHER))
#define RYGEL_AGENT_MATCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AGENT_MATCHER, RygelAgentMatcherClass))

typedef struct _RygelAgentMatcher RygelAgentMatcher;
typedef struct _RygelAgentMatcherClass RygelAgentMatcherClass;
typedef struct _RygelAgentMatcherPrivate RygelAgentMatcherPrivate;
enum  {
	RYGEL_AGENT_MATCHER_0_PROPERTY,
	RYGEL_AGENT_MATCHER_AGENTS_PROPERTY,
	RYGEL_AGENT_MATCHER_NAME_PROPERTY,
	RYGEL_AGENT_MATCHER_AGENT_REGEX_PROPERTY,
	RYGEL_AGENT_MATCHER_NUM_PROPERTIES
};
static GParamSpec* rygel_agent_matcher_properties[RYGEL_AGENT_MATCHER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelAgentMatcher {
	GObject parent_instance;
	RygelAgentMatcherPrivate * priv;
};

struct _RygelAgentMatcherClass {
	GObjectClass parent_class;
};

struct _RygelAgentMatcherPrivate {
	GeeArrayList* _agents;
	gchar* _name;
	GRegex* _agent_regex;
	gchar* agent_pattern;
};

static gint RygelAgentMatcher_private_offset;
static gpointer rygel_agent_matcher_parent_class = NULL;

VALA_EXTERN GType rygel_agent_matcher_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelAgentMatcher* rygel_agent_matcher_new (const gchar* name,
                                            GeeArrayList* agents);
VALA_EXTERN RygelAgentMatcher* rygel_agent_matcher_construct (GType object_type,
                                                  const gchar* name,
                                                  GeeArrayList* agents);
static void rygel_agent_matcher_real_constructed (GObject* base);
VALA_EXTERN GeeArrayList* rygel_agent_matcher_get_agents (RygelAgentMatcher* self);
static void _vala_array_add14 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void rygel_agent_matcher_set_agent_regex (RygelAgentMatcher* self,
                                          GRegex* value);
VALA_EXTERN gboolean rygel_agent_matcher_empty (RygelAgentMatcher* self);
VALA_EXTERN gboolean rygel_agent_matcher_matches (RygelAgentMatcher* self,
                                      const gchar* header);
VALA_EXTERN GRegex* rygel_agent_matcher_get_agent_regex (RygelAgentMatcher* self);
static void rygel_agent_matcher_set_agents (RygelAgentMatcher* self,
                                     GeeArrayList* value);
VALA_EXTERN const gchar* rygel_agent_matcher_get_name (RygelAgentMatcher* self);
static void rygel_agent_matcher_set_name (RygelAgentMatcher* self,
                                   const gchar* value);
static void rygel_agent_matcher_finalize (GObject * obj);
static GType rygel_agent_matcher_get_type_once (void);
static void _vala_rygel_agent_matcher_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_rygel_agent_matcher_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
rygel_agent_matcher_get_instance_private (RygelAgentMatcher* self)
{
	return G_STRUCT_MEMBER_P (self, RygelAgentMatcher_private_offset);
}

RygelAgentMatcher*
rygel_agent_matcher_construct (GType object_type,
                               const gchar* name,
                               GeeArrayList* agents)
{
	RygelAgentMatcher * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (agents != NULL, NULL);
	self = (RygelAgentMatcher*) g_object_new (object_type, "agents", agents, "name", name, NULL);
	return self;
}

RygelAgentMatcher*
rygel_agent_matcher_new (const gchar* name,
                         GeeArrayList* agents)
{
	return rygel_agent_matcher_construct (RYGEL_TYPE_AGENT_MATCHER, name, agents);
}

static void
_vala_array_add14 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static void
rygel_agent_matcher_real_constructed (GObject* base)
{
	RygelAgentMatcher * self;
	gchar** agents_with_pattern = NULL;
	gchar** _tmp0_;
	gint agents_with_pattern_length1;
	gint _agents_with_pattern_size_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	const gchar* _tmp17_;
	GError* _inner_error0_ = NULL;
	self = (RygelAgentMatcher*) base;
	if (G_OBJECT_CLASS (rygel_agent_matcher_parent_class)->constructed != NULL) {
		G_OBJECT_CLASS (rygel_agent_matcher_parent_class)->constructed (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
	}
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	agents_with_pattern = _tmp0_;
	agents_with_pattern_length1 = 0;
	_agents_with_pattern_size_ = agents_with_pattern_length1;
	{
		GeeArrayList* _agent_list = NULL;
		GeeArrayList* _tmp1_;
		gint _agent_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _agent_index = 0;
		_tmp1_ = self->priv->_agents;
		_agent_list = _tmp1_;
		_tmp2_ = _agent_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_agent_size = _tmp4_;
		_agent_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gchar* agent = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_agent_index = _agent_index + 1;
			_tmp5_ = _agent_index;
			_tmp6_ = _agent_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _agent_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _agent_index);
			agent = (gchar*) _tmp8_;
			_tmp9_ = agent;
			_tmp10_ = g_regex_escape_string (_tmp9_, -1);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strdup_printf (RYGEL_AGENT_MATCHER_MATCHING_PATTERN, _tmp11_);
			_vala_array_add14 (&agents_with_pattern, &agents_with_pattern_length1, &_agents_with_pattern_size_, _tmp12_);
			_g_free0 (_tmp11_);
			_g_free0 (agent);
		}
	}
	_tmp13_ = agents_with_pattern;
	_tmp13__length1 = agents_with_pattern_length1;
	if (_tmp13__length1 > 0) {
		gchar** _tmp14_;
		gint _tmp14__length1;
		gchar* _tmp15_;
		_tmp14_ = agents_with_pattern;
		_tmp14__length1 = agents_with_pattern_length1;
		_tmp15_ = _vala_g_strjoinv ("|", _tmp14_, (gint) _tmp14__length1);
		_g_free0 (self->priv->agent_pattern);
		self->priv->agent_pattern = _tmp15_;
	} else {
		gchar* _tmp16_;
		_tmp16_ = g_strdup ("");
		_g_free0 (self->priv->agent_pattern);
		self->priv->agent_pattern = _tmp16_;
	}
	_tmp17_ = self->priv->agent_pattern;
	g_debug ("agent-matcher.vala:34: Agent matcher configured for matching %s", _tmp17_);
	{
		GRegex* _tmp18_ = NULL;
		const gchar* _tmp19_;
		GRegex* _tmp20_;
		_tmp19_ = self->priv->agent_pattern;
		_tmp20_ = g_regex_new (_tmp19_, 0, 0, &_inner_error0_);
		_tmp18_ = _tmp20_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		rygel_agent_matcher_set_agent_regex (self, _tmp18_);
		_g_regex_unref0 (_tmp18_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp21_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp21_ = e->message;
		g_critical ("agent-matcher.vala:40: Error generating UserAgent regex: %s, Must not " \
"be reached", _tmp21_);
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		agents_with_pattern = (_vala_array_free (agents_with_pattern, agents_with_pattern_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	agents_with_pattern = (_vala_array_free (agents_with_pattern, agents_with_pattern_length1, (GDestroyNotify) g_free), NULL);
}

gboolean
rygel_agent_matcher_empty (RygelAgentMatcher* self)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->agent_pattern;
	result = g_strcmp0 (_tmp0_, "") == 0;
	return result;
}

gboolean
rygel_agent_matcher_matches (RygelAgentMatcher* self,
                             const gchar* header)
{
	GRegex* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (header != NULL, FALSE);
	_tmp0_ = self->priv->_agent_regex;
	result = g_regex_match (_tmp0_, header, 0, NULL);
	return result;
}

GeeArrayList*
rygel_agent_matcher_get_agents (RygelAgentMatcher* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_agents;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
rygel_agent_matcher_set_agents (RygelAgentMatcher* self,
                                GeeArrayList* value)
{
	GeeArrayList* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_agent_matcher_get_agents (self);
	if (old_value != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_agents);
		self->priv->_agents = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_agent_matcher_properties[RYGEL_AGENT_MATCHER_AGENTS_PROPERTY]);
	}
}

const gchar*
rygel_agent_matcher_get_name (RygelAgentMatcher* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
rygel_agent_matcher_set_name (RygelAgentMatcher* self,
                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_agent_matcher_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_agent_matcher_properties[RYGEL_AGENT_MATCHER_NAME_PROPERTY]);
	}
}

GRegex*
rygel_agent_matcher_get_agent_regex (RygelAgentMatcher* self)
{
	GRegex* result;
	GRegex* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_agent_regex;
	result = _tmp0_;
	return result;
}

static gpointer
_g_regex_ref0 (gpointer self)
{
	return self ? g_regex_ref (self) : NULL;
}

static void
rygel_agent_matcher_set_agent_regex (RygelAgentMatcher* self,
                                     GRegex* value)
{
	GRegex* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_agent_matcher_get_agent_regex (self);
	if (old_value != value) {
		GRegex* _tmp0_;
		_tmp0_ = _g_regex_ref0 (value);
		_g_regex_unref0 (self->priv->_agent_regex);
		self->priv->_agent_regex = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_agent_matcher_properties[RYGEL_AGENT_MATCHER_AGENT_REGEX_PROPERTY]);
	}
}

static void
rygel_agent_matcher_class_init (RygelAgentMatcherClass * klass,
                                gpointer klass_data)
{
	rygel_agent_matcher_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelAgentMatcher_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) rygel_agent_matcher_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_agent_matcher_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_agent_matcher_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_agent_matcher_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AGENT_MATCHER_AGENTS_PROPERTY, rygel_agent_matcher_properties[RYGEL_AGENT_MATCHER_AGENTS_PROPERTY] = g_param_spec_object ("agents", "agents", "agents", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AGENT_MATCHER_NAME_PROPERTY, rygel_agent_matcher_properties[RYGEL_AGENT_MATCHER_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AGENT_MATCHER_AGENT_REGEX_PROPERTY, rygel_agent_matcher_properties[RYGEL_AGENT_MATCHER_AGENT_REGEX_PROPERTY] = g_param_spec_boxed ("agent-regex", "agent-regex", "agent-regex", G_TYPE_REGEX, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
rygel_agent_matcher_instance_init (RygelAgentMatcher * self,
                                   gpointer klass)
{
	self->priv = rygel_agent_matcher_get_instance_private (self);
}

static void
rygel_agent_matcher_finalize (GObject * obj)
{
	RygelAgentMatcher * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_AGENT_MATCHER, RygelAgentMatcher);
	_g_object_unref0 (self->priv->_agents);
	_g_free0 (self->priv->_name);
	_g_regex_unref0 (self->priv->_agent_regex);
	_g_free0 (self->priv->agent_pattern);
	G_OBJECT_CLASS (rygel_agent_matcher_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
rygel_agent_matcher_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelAgentMatcherClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_agent_matcher_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelAgentMatcher), 0, (GInstanceInitFunc) rygel_agent_matcher_instance_init, NULL };
	GType rygel_agent_matcher_type_id;
	rygel_agent_matcher_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelAgentMatcher", &g_define_type_info, 0);
	RygelAgentMatcher_private_offset = g_type_add_instance_private (rygel_agent_matcher_type_id, sizeof (RygelAgentMatcherPrivate));
	return rygel_agent_matcher_type_id;
}

GType
rygel_agent_matcher_get_type (void)
{
	static volatile gsize rygel_agent_matcher_type_id__once = 0;
	if (g_once_init_enter (&rygel_agent_matcher_type_id__once)) {
		GType rygel_agent_matcher_type_id;
		rygel_agent_matcher_type_id = rygel_agent_matcher_get_type_once ();
		g_once_init_leave (&rygel_agent_matcher_type_id__once, rygel_agent_matcher_type_id);
	}
	return rygel_agent_matcher_type_id__once;
}

static void
_vala_rygel_agent_matcher_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	RygelAgentMatcher * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_AGENT_MATCHER, RygelAgentMatcher);
	switch (property_id) {
		case RYGEL_AGENT_MATCHER_AGENTS_PROPERTY:
		g_value_set_object (value, rygel_agent_matcher_get_agents (self));
		break;
		case RYGEL_AGENT_MATCHER_NAME_PROPERTY:
		g_value_set_string (value, rygel_agent_matcher_get_name (self));
		break;
		case RYGEL_AGENT_MATCHER_AGENT_REGEX_PROPERTY:
		g_value_set_boxed (value, rygel_agent_matcher_get_agent_regex (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_agent_matcher_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	RygelAgentMatcher * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_AGENT_MATCHER, RygelAgentMatcher);
	switch (property_id) {
		case RYGEL_AGENT_MATCHER_AGENTS_PROPERTY:
		rygel_agent_matcher_set_agents (self, g_value_get_object (value));
		break;
		case RYGEL_AGENT_MATCHER_NAME_PROPERTY:
		rygel_agent_matcher_set_name (self, g_value_get_string (value));
		break;
		case RYGEL_AGENT_MATCHER_AGENT_REGEX_PROPERTY:
		rygel_agent_matcher_set_agent_regex (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

