/* rygel-http-thumbnail-handler.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-http-thumbnail-handler.vala, do not modify */

/*
 * Copyright (C) 2008, 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <libsoup/soup.h>
#include "rygel-core.h"
#include <libgupnp-av/gupnp-av.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER (rygel_http_thumbnail_handler_get_type ())
#define RYGEL_HTTP_THUMBNAIL_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER, RygelHTTPThumbnailHandler))
#define RYGEL_HTTP_THUMBNAIL_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER, RygelHTTPThumbnailHandlerClass))
#define RYGEL_IS_HTTP_THUMBNAIL_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER))
#define RYGEL_IS_HTTP_THUMBNAIL_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER))
#define RYGEL_HTTP_THUMBNAIL_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER, RygelHTTPThumbnailHandlerClass))

typedef struct _RygelHTTPThumbnailHandler RygelHTTPThumbnailHandler;
typedef struct _RygelHTTPThumbnailHandlerClass RygelHTTPThumbnailHandlerClass;
typedef struct _RygelHTTPThumbnailHandlerPrivate RygelHTTPThumbnailHandlerPrivate;
enum  {
	RYGEL_HTTP_THUMBNAIL_HANDLER_0_PROPERTY,
	RYGEL_HTTP_THUMBNAIL_HANDLER_NUM_PROPERTIES
};
static GParamSpec* rygel_http_thumbnail_handler_properties[RYGEL_HTTP_THUMBNAIL_HANDLER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelHTTPThumbnailHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPThumbnailHandlerPrivate * priv;
};

struct _RygelHTTPThumbnailHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};

struct _RygelHTTPThumbnailHandlerPrivate {
	RygelMediaFileItem* media_item;
	gint thumbnail_index;
	RygelThumbnail* thumbnail;
};

static gint RygelHTTPThumbnailHandler_private_offset;
static gpointer rygel_http_thumbnail_handler_parent_class = NULL;

VALA_EXTERN GType rygel_http_thumbnail_handler_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelHTTPThumbnailHandler* rygel_http_thumbnail_handler_new (RygelMediaFileItem* media_item,
                                                             gint thumbnail_index,
                                                             GCancellable* cancellable,
                                                             GError** error);
VALA_EXTERN RygelHTTPThumbnailHandler* rygel_http_thumbnail_handler_construct (GType object_type,
                                                                   RygelMediaFileItem* media_item,
                                                                   gint thumbnail_index,
                                                                   GCancellable* cancellable,
                                                                   GError** error);
static gboolean rygel_http_thumbnail_handler_real_supports_transfer_mode (RygelHTTPGetHandler* base,
                                                                   const gchar* mode);
static void rygel_http_thumbnail_handler_real_add_response_headers (RygelHTTPGetHandler* base,
                                                             RygelHTTPGet* request,
                                                             GError** error);
VALA_EXTERN RygelMediaResource* rygel_thumbnail_get_resource (RygelThumbnail* self,
                                                  const gchar* protocol,
                                                  gint index);
VALA_EXTERN gchar* rygel_http_server_get_protocol (RygelHTTPServer* self);
static RygelHTTPResponse* rygel_http_thumbnail_handler_real_render_body (RygelHTTPGetHandler* base,
                                                                  RygelHTTPGet* request,
                                                                  GError** error);
static gint64 rygel_http_thumbnail_handler_real_get_resource_size (RygelHTTPGetHandler* base);
static gboolean rygel_http_thumbnail_handler_real_supports_byte_seek (RygelHTTPGetHandler* base);
static void rygel_http_thumbnail_handler_finalize (GObject * obj);
static GType rygel_http_thumbnail_handler_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
rygel_http_thumbnail_handler_get_instance_private (RygelHTTPThumbnailHandler* self)
{
	return G_STRUCT_MEMBER_P (self, RygelHTTPThumbnailHandler_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_rygel_icon_info_ref0 (gpointer self)
{
	return self ? rygel_icon_info_ref (self) : NULL;
}

RygelHTTPThumbnailHandler*
rygel_http_thumbnail_handler_construct (GType object_type,
                                        RygelMediaFileItem* media_item,
                                        gint thumbnail_index,
                                        GCancellable* cancellable,
                                        GError** error)
{
	RygelHTTPThumbnailHandler * self = NULL;
	RygelMediaFileItem* _tmp0_;
	RygelThumbnail* _tmp16_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (media_item != NULL, NULL);
	self = (RygelHTTPThumbnailHandler*) rygel_http_get_handler_construct (object_type);
	_tmp0_ = _g_object_ref0 (media_item);
	_g_object_unref0 (self->priv->media_item);
	self->priv->media_item = _tmp0_;
	self->priv->thumbnail_index = thumbnail_index;
	rygel_http_get_handler_set_cancellable ((RygelHTTPGetHandler*) self, cancellable);
	if (RYGEL_IS_MUSIC_ITEM (media_item)) {
		RygelMusicItem* music_item = NULL;
		RygelMusicItem* _tmp1_;
		RygelMusicItem* _tmp2_;
		RygelThumbnail* _tmp3_;
		RygelThumbnail* _tmp4_;
		RygelThumbnail* _tmp5_;
		_tmp1_ = _g_object_ref0 (RYGEL_IS_MUSIC_ITEM (media_item) ? ((RygelMusicItem*) media_item) : NULL);
		music_item = _tmp1_;
		_tmp2_ = music_item;
		_tmp3_ = rygel_music_item_get_album_art (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _rygel_icon_info_ref0 (_tmp4_);
		_rygel_icon_info_unref0 (self->priv->thumbnail);
		self->priv->thumbnail = _tmp5_;
		_g_object_unref0 (music_item);
	} else {
		if (RYGEL_IS_VISUAL_ITEM (media_item)) {
			RygelVisualItem* visual_item = NULL;
			RygelVisualItem* _tmp6_;
			RygelVisualItem* _tmp7_;
			GeeArrayList* _tmp8_;
			GeeArrayList* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			_tmp6_ = _g_object_ref0 (RYGEL_IS_VISUAL_ITEM (media_item) ? ((RygelVisualItem*) media_item) : NULL);
			visual_item = _tmp6_;
			_tmp7_ = visual_item;
			_tmp8_ = rygel_visual_item_get_thumbnails (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
			_tmp11_ = _tmp10_;
			if (thumbnail_index < _tmp11_) {
				RygelVisualItem* _tmp12_;
				GeeArrayList* _tmp13_;
				GeeArrayList* _tmp14_;
				gpointer _tmp15_;
				_tmp12_ = visual_item;
				_tmp13_ = rygel_visual_item_get_thumbnails (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, thumbnail_index);
				_rygel_icon_info_unref0 (self->priv->thumbnail);
				self->priv->thumbnail = (RygelThumbnail*) _tmp15_;
			}
			_g_object_unref0 (visual_item);
		}
	}
	_tmp16_ = self->priv->thumbnail;
	if (_tmp16_ == NULL) {
		gchar* msg = NULL;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		GError* _tmp21_;
		_tmp17_ = g_strdup ("Thumbnail index %d not found for item '%s");
		msg = _tmp17_;
		_tmp18_ = msg;
		_tmp19_ = rygel_media_object_get_id ((RygelMediaObject*) media_item);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _tmp18_, thumbnail_index, _tmp20_);
		_inner_error0_ = _tmp21_;
		if (_inner_error0_->domain == RYGEL_HTTP_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (msg);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_free0 (msg);
	}
	return self;
}

RygelHTTPThumbnailHandler*
rygel_http_thumbnail_handler_new (RygelMediaFileItem* media_item,
                                  gint thumbnail_index,
                                  GCancellable* cancellable,
                                  GError** error)
{
	return rygel_http_thumbnail_handler_construct (RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER, media_item, thumbnail_index, cancellable, error);
}

static gboolean
rygel_http_thumbnail_handler_real_supports_transfer_mode (RygelHTTPGetHandler* base,
                                                          const gchar* mode)
{
	RygelHTTPThumbnailHandler * self;
	gboolean result;
	self = (RygelHTTPThumbnailHandler*) base;
	g_return_val_if_fail (mode != NULL, FALSE);
	result = g_strcmp0 (mode, RYGEL_HTTP_GET_HANDLER_TRANSFER_MODE_STREAMING) != 0;
	return result;
}

static void
rygel_http_thumbnail_handler_real_add_response_headers (RygelHTTPGetHandler* base,
                                                        RygelHTTPGet* request,
                                                        GError** error)
{
	RygelHTTPThumbnailHandler * self;
	SoupServerMessage* _tmp0_;
	SoupMessageHeaders* _tmp1_;
	RygelThumbnail* _tmp2_;
	const gchar* _tmp3_;
	RygelMediaResource* res = NULL;
	RygelThumbnail* _tmp4_;
	RygelHTTPServer* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	RygelMediaResource* _tmp8_;
	RygelMediaResource* _tmp9_;
	gchar* protocol_info = NULL;
	GUPnPProtocolInfo* _tmp10_;
	GUPnPProtocolInfo* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar** pi_fields = NULL;
	gchar** _tmp14_;
	gchar** _tmp15_;
	gint pi_fields_length1;
	gint _pi_fields_size_;
	SoupServerMessage* _tmp16_;
	SoupMessageHeaders* _tmp17_;
	const gchar* _tmp18_;
	GError* _inner_error0_ = NULL;
	self = (RygelHTTPThumbnailHandler*) base;
	g_return_if_fail (request != NULL);
	_tmp0_ = ((RygelHTTPRequest*) request)->msg;
	_tmp1_ = soup_server_message_get_response_headers (_tmp0_);
	_tmp2_ = self->priv->thumbnail;
	_tmp3_ = ((RygelIconInfo*) _tmp2_)->mime_type;
	soup_message_headers_append (_tmp1_, "Content-Type", _tmp3_);
	_tmp4_ = self->priv->thumbnail;
	_tmp5_ = ((RygelHTTPRequest*) request)->http_server;
	_tmp6_ = rygel_http_server_get_protocol (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = rygel_thumbnail_get_resource (_tmp4_, _tmp7_, self->priv->thumbnail_index);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	res = _tmp9_;
	_tmp10_ = rygel_media_resource_get_protocol_info (res, NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = gupnp_protocol_info_to_string (_tmp11_);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (_tmp11_);
	protocol_info = _tmp13_;
	_tmp15_ = _tmp14_ = g_strsplit (protocol_info, ":", 4);
	pi_fields = _tmp15_;
	pi_fields_length1 = _vala_array_length (_tmp14_);
	_pi_fields_size_ = pi_fields_length1;
	_tmp16_ = ((RygelHTTPRequest*) request)->msg;
	_tmp17_ = soup_server_message_get_response_headers (_tmp16_);
	_tmp18_ = pi_fields[3];
	soup_message_headers_append (_tmp17_, "contentFeatures.dlna.org", _tmp18_);
	RYGEL_HTTP_GET_HANDLER_CLASS (rygel_http_thumbnail_handler_parent_class)->add_response_headers (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler), request, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == RYGEL_HTTP_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error0_);
			pi_fields = (_vala_array_free (pi_fields, pi_fields_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (protocol_info);
			_g_object_unref0 (res);
			return;
		} else {
			pi_fields = (_vala_array_free (pi_fields, pi_fields_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (protocol_info);
			_g_object_unref0 (res);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	pi_fields = (_vala_array_free (pi_fields, pi_fields_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (protocol_info);
	_g_object_unref0 (res);
}

static RygelHTTPResponse*
rygel_http_thumbnail_handler_real_render_body (RygelHTTPGetHandler* base,
                                               RygelHTTPGet* request,
                                               GError** error)
{
	RygelHTTPThumbnailHandler * self;
	RygelDataSource* src = NULL;
	GError* _inner_error0_ = NULL;
	RygelHTTPResponse* result;
	self = (RygelHTTPThumbnailHandler*) base;
	g_return_val_if_fail (request != NULL, NULL);
	{
		RygelMediaEngine* engine = NULL;
		RygelMediaEngine* _tmp0_;
		RygelDataSource* _tmp1_ = NULL;
		RygelMediaEngine* _tmp2_;
		RygelThumbnail* _tmp3_;
		const gchar* _tmp4_;
		RygelDataSource* _tmp5_;
		RygelDataSource* _tmp6_;
		RygelHTTPResponse* _tmp7_ = NULL;
		RygelDataSource* _tmp8_;
		RygelHTTPResponse* _tmp9_;
		RygelHTTPResponse* _tmp10_;
		_tmp0_ = rygel_media_engine_get_default ();
		engine = _tmp0_;
		_tmp2_ = engine;
		_tmp3_ = self->priv->thumbnail;
		_tmp4_ = ((RygelIconInfo*) _tmp3_)->uri;
		_tmp5_ = rygel_media_engine_create_data_source_for_uri (_tmp2_, _tmp4_, &_inner_error0_);
		_tmp1_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (engine);
			goto __catch0_g_error;
		}
		_tmp6_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (src);
		src = _tmp6_;
		_tmp8_ = src;
		_tmp9_ = rygel_http_response_new (request, (RygelHTTPGetHandler*) self, _tmp8_, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp1_);
			_g_object_unref0 (engine);
			goto __catch0_g_error;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_object_unref0 (_tmp7_);
		_g_object_unref0 (_tmp1_);
		_g_object_unref0 (engine);
		_g_object_unref0 (src);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		GError* _tmp13_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = err;
		_tmp12_ = _tmp11_->message;
		_tmp13_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _tmp12_);
		_inner_error0_ = _tmp13_;
		_g_error_free0 (err);
		goto __finally0;
	}
	__finally0:
	if (_inner_error0_->domain == RYGEL_HTTP_REQUEST_ERROR) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (src);
		return NULL;
	} else {
		_g_object_unref0 (src);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static gint64
rygel_http_thumbnail_handler_real_get_resource_size (RygelHTTPGetHandler* base)
{
	RygelHTTPThumbnailHandler * self;
	RygelThumbnail* _tmp0_;
	gint64 result;
	self = (RygelHTTPThumbnailHandler*) base;
	_tmp0_ = self->priv->thumbnail;
	result = ((RygelIconInfo*) _tmp0_)->size;
	return result;
}

static gboolean
rygel_http_thumbnail_handler_real_supports_byte_seek (RygelHTTPGetHandler* base)
{
	RygelHTTPThumbnailHandler * self;
	gboolean result;
	self = (RygelHTTPThumbnailHandler*) base;
	result = TRUE;
	return result;
}

static void
rygel_http_thumbnail_handler_class_init (RygelHTTPThumbnailHandlerClass * klass,
                                         gpointer klass_data)
{
	rygel_http_thumbnail_handler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelHTTPThumbnailHandler_private_offset);
	((RygelHTTPGetHandlerClass *) klass)->supports_transfer_mode = (gboolean (*) (RygelHTTPGetHandler*, const gchar*)) rygel_http_thumbnail_handler_real_supports_transfer_mode;
	((RygelHTTPGetHandlerClass *) klass)->add_response_headers = (void (*) (RygelHTTPGetHandler*, RygelHTTPGet*, GError**)) rygel_http_thumbnail_handler_real_add_response_headers;
	((RygelHTTPGetHandlerClass *) klass)->render_body = (RygelHTTPResponse* (*) (RygelHTTPGetHandler*, RygelHTTPGet*, GError**)) rygel_http_thumbnail_handler_real_render_body;
	((RygelHTTPGetHandlerClass *) klass)->get_resource_size = (gint64 (*) (RygelHTTPGetHandler*)) rygel_http_thumbnail_handler_real_get_resource_size;
	((RygelHTTPGetHandlerClass *) klass)->supports_byte_seek = (gboolean (*) (RygelHTTPGetHandler*)) rygel_http_thumbnail_handler_real_supports_byte_seek;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_thumbnail_handler_finalize;
}

static void
rygel_http_thumbnail_handler_instance_init (RygelHTTPThumbnailHandler * self,
                                            gpointer klass)
{
	self->priv = rygel_http_thumbnail_handler_get_instance_private (self);
}

static void
rygel_http_thumbnail_handler_finalize (GObject * obj)
{
	RygelHTTPThumbnailHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER, RygelHTTPThumbnailHandler);
	_g_object_unref0 (self->priv->media_item);
	_rygel_icon_info_unref0 (self->priv->thumbnail);
	G_OBJECT_CLASS (rygel_http_thumbnail_handler_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
rygel_http_thumbnail_handler_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPThumbnailHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_thumbnail_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPThumbnailHandler), 0, (GInstanceInitFunc) rygel_http_thumbnail_handler_instance_init, NULL };
	GType rygel_http_thumbnail_handler_type_id;
	rygel_http_thumbnail_handler_type_id = g_type_register_static (RYGEL_TYPE_HTTP_GET_HANDLER, "RygelHTTPThumbnailHandler", &g_define_type_info, 0);
	RygelHTTPThumbnailHandler_private_offset = g_type_add_instance_private (rygel_http_thumbnail_handler_type_id, sizeof (RygelHTTPThumbnailHandlerPrivate));
	return rygel_http_thumbnail_handler_type_id;
}

GType
rygel_http_thumbnail_handler_get_type (void)
{
	static volatile gsize rygel_http_thumbnail_handler_type_id__once = 0;
	if (g_once_init_enter (&rygel_http_thumbnail_handler_type_id__once)) {
		GType rygel_http_thumbnail_handler_type_id;
		rygel_http_thumbnail_handler_type_id = rygel_http_thumbnail_handler_get_type_once ();
		g_once_init_leave (&rygel_http_thumbnail_handler_type_id__once, rygel_http_thumbnail_handler_type_id);
	}
	return rygel_http_thumbnail_handler_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

