/* localsearch-cleanup-query.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from localsearch-cleanup-query.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Nokia Corporation.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-localsearch.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <tinysparql.h>
#include <glib-object.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _rygel_local_search_query_triplet_unref0(var) ((var == NULL) ? NULL : (var = (rygel_local_search_query_triplet_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _rygel_local_search_query_unref0(var) ((var == NULL) ? NULL : (var = (rygel_local_search_query_unref (var), NULL)))
typedef struct _RygelLocalSearchCleanupQueryExecuteData RygelLocalSearchCleanupQueryExecuteData;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _RygelLocalSearchCleanupQueryPrivate {
	gchar* category;
	gchar* graph;
};

struct _RygelLocalSearchCleanupQueryExecuteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelLocalSearchCleanupQuery* self;
	TrackerSparqlConnection* resources;
	gchar* str;
	gchar* _tmp0_;
	GError* _inner_error0_;
};

static gint RygelLocalSearchCleanupQuery_private_offset;
static gpointer rygel_local_search_cleanup_query_parent_class = NULL;

static void rygel_local_search_cleanup_query_real_execute_data_free (gpointer _data);
static void rygel_local_search_cleanup_query_real_execute (RygelLocalSearchQuery* base,
                                                    TrackerSparqlConnection* resources,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
static gboolean rygel_local_search_cleanup_query_real_execute_co (RygelLocalSearchCleanupQueryExecuteData* _data_);
static void rygel_local_search_cleanup_query_execute_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static gchar* rygel_local_search_cleanup_query_real_to_string (RygelLocalSearchQuery* base);
static void rygel_local_search_cleanup_query_finalize (RygelLocalSearchQuery * obj);
static GType rygel_local_search_cleanup_query_get_type_once (void);

static inline gpointer
rygel_local_search_cleanup_query_get_instance_private (RygelLocalSearchCleanupQuery* self)
{
	return G_STRUCT_MEMBER_P (self, RygelLocalSearchCleanupQuery_private_offset);
}

RygelLocalSearchCleanupQuery*
rygel_local_search_cleanup_query_construct (GType object_type,
                                            const gchar* category,
                                            const gchar* graph)
{
	RygelLocalSearchCleanupQuery* self = NULL;
	RygelLocalSearchQueryTriplets* triplets = NULL;
	RygelLocalSearchQueryTriplets* _tmp0_;
	RygelLocalSearchQueryTriplet* _tmp1_;
	RygelLocalSearchQueryTriplet* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (category != NULL, NULL);
	g_return_val_if_fail (graph != NULL, NULL);
	_tmp0_ = rygel_local_search_query_triplets_new ();
	triplets = _tmp0_;
	_tmp1_ = rygel_local_search_query_triplet_new ("?r", "a", "rdfs:Resource");
	_tmp2_ = _tmp1_;
	gee_abstract_collection_add ((GeeAbstractCollection*) triplets, _tmp2_);
	_rygel_local_search_query_triplet_unref0 (_tmp2_);
	self = (RygelLocalSearchCleanupQuery*) rygel_local_search_query_construct (object_type, triplets);
	_tmp3_ = g_strdup (category);
	_g_free0 (self->priv->category);
	self->priv->category = _tmp3_;
	_tmp4_ = g_strdup (graph);
	_g_free0 (self->priv->graph);
	self->priv->graph = _tmp4_;
	_g_object_unref0 (triplets);
	return self;
}

RygelLocalSearchCleanupQuery*
rygel_local_search_cleanup_query_new (const gchar* category,
                                      const gchar* graph)
{
	return rygel_local_search_cleanup_query_construct (RYGEL_LOCAL_SEARCH_TYPE_CLEANUP_QUERY, category, graph);
}

static void
rygel_local_search_cleanup_query_real_execute_data_free (gpointer _data)
{
	RygelLocalSearchCleanupQueryExecuteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->resources);
	_rygel_local_search_query_unref0 (_data_->self);
	g_slice_free (RygelLocalSearchCleanupQueryExecuteData, _data_);
}

static gpointer
_rygel_local_search_query_ref0 (gpointer self)
{
	return self ? rygel_local_search_query_ref (self) : NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
rygel_local_search_cleanup_query_real_execute (RygelLocalSearchQuery* base,
                                               TrackerSparqlConnection* resources,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	RygelLocalSearchCleanupQuery * self;
	RygelLocalSearchCleanupQueryExecuteData* _data_;
	RygelLocalSearchCleanupQuery* _tmp0_;
	TrackerSparqlConnection* _tmp1_;
	g_return_if_fail (resources != NULL);
	self = (RygelLocalSearchCleanupQuery*) base;
	_data_ = g_slice_new0 (RygelLocalSearchCleanupQueryExecuteData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_local_search_cleanup_query_real_execute_data_free);
	_tmp0_ = _rygel_local_search_query_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (resources);
	_g_object_unref0 (_data_->resources);
	_data_->resources = _tmp1_;
	rygel_local_search_cleanup_query_real_execute_co (_data_);
}

static void
rygel_local_search_cleanup_query_execute_finish (RygelLocalSearchQuery* base,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	RygelLocalSearchCleanupQueryExecuteData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
rygel_local_search_cleanup_query_execute_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	RygelLocalSearchCleanupQueryExecuteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_local_search_cleanup_query_real_execute_co (_data_);
}

static gboolean
rygel_local_search_cleanup_query_real_execute_co (RygelLocalSearchCleanupQueryExecuteData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = rygel_local_search_query_to_string ((RygelLocalSearchQuery*) _data_->self);
	_data_->str = _data_->_tmp0_;
	g_debug ("localsearch-cleanup-query.vala:50: Executing SPARQL query: %s", _data_->str);
	_data_->_state_ = 1;
	tracker_sparql_connection_update_async (_data_->resources, _data_->str, NULL, rygel_local_search_cleanup_query_execute_ready, _data_);
	return FALSE;
	_state_1:
	tracker_sparql_connection_update_finish (_data_->resources, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->str);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_free0 (_data_->str);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
rygel_local_search_cleanup_query_real_to_string (RygelLocalSearchQuery* base)
{
	RygelLocalSearchCleanupQuery * self;
	GString* _result_ = NULL;
	GString* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	self = (RygelLocalSearchCleanupQuery*) base;
	_tmp0_ = g_string_new ("");
	_result_ = _tmp0_;
	g_string_append (_result_, "DELETE {");
	_tmp1_ = self->priv->graph;
	g_string_append_printf (_result_, "GRAPH %s {", _tmp1_);
	_tmp2_ = RYGEL_LOCAL_SEARCH_QUERY_CLASS (rygel_local_search_cleanup_query_parent_class)->to_string (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_LOCAL_SEARCH_TYPE_QUERY, RygelLocalSearchQuery));
	_tmp3_ = _tmp2_;
	g_string_append (_result_, _tmp3_);
	_g_free0 (_tmp3_);
	g_string_append (_result_, "}} WHERE {");
	_tmp4_ = self->priv->graph;
	g_string_append_printf (_result_, "GRAPH %s {", _tmp4_);
	_tmp5_ = self->priv->category;
	g_string_append_printf (_result_, "?r a %s . ", _tmp5_);
	g_string_append (_result_, " ?r nie:generator \"rygel\". } ");
	g_string_append (_result_, "FILTER(NOT EXISTS { ");
	g_string_append (_result_, "GRAPH tracker:FileSystem {");
	g_string_append (_result_, "?r a nfo:FileDataObject. }})}");
	_tmp6_ = _result_->str;
	_tmp7_ = g_strdup (_tmp6_);
	result = _tmp7_;
	_g_string_free0 (_result_);
	return result;
}

static void
rygel_local_search_cleanup_query_class_init (RygelLocalSearchCleanupQueryClass * klass,
                                             gpointer klass_data)
{
	rygel_local_search_cleanup_query_parent_class = g_type_class_peek_parent (klass);
	((RygelLocalSearchQueryClass *) klass)->finalize = rygel_local_search_cleanup_query_finalize;
	g_type_class_adjust_private_offset (klass, &RygelLocalSearchCleanupQuery_private_offset);
	((RygelLocalSearchQueryClass *) klass)->execute = (void (*) (RygelLocalSearchQuery*, TrackerSparqlConnection*, GAsyncReadyCallback, gpointer)) rygel_local_search_cleanup_query_real_execute;
	((RygelLocalSearchQueryClass *) klass)->execute_finish = (void (*) (RygelLocalSearchQuery*, GAsyncResult*, GError**)) rygel_local_search_cleanup_query_execute_finish;
	((RygelLocalSearchQueryClass *) klass)->to_string = (gchar* (*) (RygelLocalSearchQuery*)) rygel_local_search_cleanup_query_real_to_string;
}

static void
rygel_local_search_cleanup_query_instance_init (RygelLocalSearchCleanupQuery * self,
                                                gpointer klass)
{
	self->priv = rygel_local_search_cleanup_query_get_instance_private (self);
}

static void
rygel_local_search_cleanup_query_finalize (RygelLocalSearchQuery * obj)
{
	RygelLocalSearchCleanupQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_LOCAL_SEARCH_TYPE_CLEANUP_QUERY, RygelLocalSearchCleanupQuery);
	_g_free0 (self->priv->category);
	_g_free0 (self->priv->graph);
	RYGEL_LOCAL_SEARCH_QUERY_CLASS (rygel_local_search_cleanup_query_parent_class)->finalize (obj);
}

/**
 * Represents LocalSearch SPARQL Deletion query
 */
 G_GNUC_NO_INLINE static GType
rygel_local_search_cleanup_query_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelLocalSearchCleanupQueryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_local_search_cleanup_query_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelLocalSearchCleanupQuery), 0, (GInstanceInitFunc) rygel_local_search_cleanup_query_instance_init, NULL };
	GType rygel_local_search_cleanup_query_type_id;
	rygel_local_search_cleanup_query_type_id = g_type_register_static (RYGEL_LOCAL_SEARCH_TYPE_QUERY, "RygelLocalSearchCleanupQuery", &g_define_type_info, 0);
	RygelLocalSearchCleanupQuery_private_offset = g_type_add_instance_private (rygel_local_search_cleanup_query_type_id, sizeof (RygelLocalSearchCleanupQueryPrivate));
	return rygel_local_search_cleanup_query_type_id;
}

GType
rygel_local_search_cleanup_query_get_type (void)
{
	static volatile gsize rygel_local_search_cleanup_query_type_id__once = 0;
	if (g_once_init_enter (&rygel_local_search_cleanup_query_type_id__once)) {
		GType rygel_local_search_cleanup_query_type_id;
		rygel_local_search_cleanup_query_type_id = rygel_local_search_cleanup_query_get_type_once ();
		g_once_init_leave (&rygel_local_search_cleanup_query_type_id__once, rygel_local_search_cleanup_query_type_id);
	}
	return rygel_local_search_cleanup_query_type_id__once;
}

