/* Tracker.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Tracker.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <glib.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CORE_TYPE_TRACKER_ACCUMULATOR (core_tracker_accumulator_get_type ())
#define CORE_TRACKER_ACCUMULATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CORE_TYPE_TRACKER_ACCUMULATOR, CoreTrackerAccumulator))
#define CORE_IS_TRACKER_ACCUMULATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CORE_TYPE_TRACKER_ACCUMULATOR))
#define CORE_TRACKER_ACCUMULATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CORE_TYPE_TRACKER_ACCUMULATOR, CoreTrackerAccumulatorIface))

typedef struct _CoreTrackerAccumulator CoreTrackerAccumulator;
typedef struct _CoreTrackerAccumulatorIface CoreTrackerAccumulatorIface;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define CORE_TYPE_TRACKER (core_tracker_get_type ())
#define CORE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CORE_TYPE_TRACKER, CoreTracker))
#define CORE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CORE_TYPE_TRACKER, CoreTrackerClass))
#define CORE_IS_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CORE_TYPE_TRACKER))
#define CORE_IS_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CORE_TYPE_TRACKER))
#define CORE_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CORE_TYPE_TRACKER, CoreTrackerClass))

typedef struct _CoreTracker CoreTracker;
typedef struct _CoreTrackerClass CoreTrackerClass;
typedef struct _CoreTrackerPrivate CoreTrackerPrivate;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef gboolean (*CoreTrackerIncludeUnincludeObject) (DataObject* object, gpointer user_data);
#define _alteration_unref0(var) ((var == NULL) ? NULL : (var = (alteration_unref (var), NULL)))
typedef struct _CoreParamSpecTracker CoreParamSpecTracker;
enum  {
	CORE_TRACKER_UPDATED_SIGNAL,
	CORE_TRACKER_NUM_SIGNALS
};
static guint core_tracker_signals[CORE_TRACKER_NUM_SIGNALS] = {0};

#define CORE_TYPE_VIEW_TRACKER (core_view_tracker_get_type ())
#define CORE_VIEW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CORE_TYPE_VIEW_TRACKER, CoreViewTracker))
#define CORE_VIEW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CORE_TYPE_VIEW_TRACKER, CoreViewTrackerClass))
#define CORE_IS_VIEW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CORE_TYPE_VIEW_TRACKER))
#define CORE_IS_VIEW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CORE_TYPE_VIEW_TRACKER))
#define CORE_VIEW_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CORE_TYPE_VIEW_TRACKER, CoreViewTrackerClass))

typedef struct _CoreViewTracker CoreViewTracker;
typedef struct _CoreViewTrackerClass CoreViewTrackerClass;
typedef struct _CoreViewTrackerPrivate CoreViewTrackerPrivate;

#define CORE_VIEW_TRACKER_TYPE_MUX (core_view_tracker_mux_get_type ())
#define CORE_VIEW_TRACKER_MUX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CORE_VIEW_TRACKER_TYPE_MUX, CoreViewTrackerMux))
#define CORE_VIEW_TRACKER_MUX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CORE_VIEW_TRACKER_TYPE_MUX, CoreViewTrackerMuxClass))
#define CORE_VIEW_TRACKER_IS_MUX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CORE_VIEW_TRACKER_TYPE_MUX))
#define CORE_VIEW_TRACKER_IS_MUX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CORE_VIEW_TRACKER_TYPE_MUX))
#define CORE_VIEW_TRACKER_MUX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CORE_VIEW_TRACKER_TYPE_MUX, CoreViewTrackerMuxClass))

typedef struct _CoreViewTrackerMux CoreViewTrackerMux;
typedef struct _CoreViewTrackerMuxClass CoreViewTrackerMuxClass;

#define TYPE_VIEW_COLLECTION (view_collection_get_type ())
#define VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIEW_COLLECTION, ViewCollection))
#define VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIEW_COLLECTION, ViewCollectionClass))
#define IS_VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIEW_COLLECTION))
#define IS_VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIEW_COLLECTION))
#define VIEW_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIEW_COLLECTION, ViewCollectionClass))

typedef struct _ViewCollection ViewCollection;
typedef struct _ViewCollectionClass ViewCollectionClass;

#define TYPE_DATA_VIEW (data_view_get_type ())
#define DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_VIEW, DataView))
#define DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_VIEW, DataViewClass))
#define IS_DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_VIEW))
#define IS_DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_VIEW))
#define DATA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_VIEW, DataViewClass))

typedef struct _DataView DataView;
typedef struct _DataViewClass DataViewClass;
typedef struct _CoreViewTrackerMuxPrivate CoreViewTrackerMuxPrivate;
enum  {
	CORE_VIEW_TRACKER_MUX_0_PROPERTY,
	CORE_VIEW_TRACKER_MUX_NUM_PROPERTIES
};
static GParamSpec* core_view_tracker_mux_properties[CORE_VIEW_TRACKER_MUX_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CoreTrackerAccumulatorIface {
	GTypeInterface parent_iface;
	gboolean (*include) (CoreTrackerAccumulator* self, DataObject* object);
	gboolean (*uninclude) (CoreTrackerAccumulator* self, DataObject* object);
	gboolean (*altered) (CoreTrackerAccumulator* self, DataObject* object, Alteration* alteration);
};

struct _CoreTracker {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CoreTrackerPrivate * priv;
};

struct _CoreTrackerClass {
	GTypeClass parent_class;
	void (*finalize) (CoreTracker *self);
	void (*updated) (CoreTracker* self);
};

struct _CoreTrackerPrivate {
	DataCollection* collection;
	GeeCollection* initial;
	CoreTrackerAccumulator* acc;
};

struct _CoreParamSpecTracker {
	GParamSpec parent_instance;
};

struct _CoreViewTracker {
	CoreTracker parent_instance;
	CoreViewTrackerPrivate * priv;
};

struct _CoreViewTrackerClass {
	CoreTrackerClass parent_class;
};

struct _CoreViewTrackerPrivate {
	CoreViewTrackerMux* mux;
};

struct _CoreViewTrackerMux {
	GObject parent_instance;
	CoreViewTrackerMuxPrivate * priv;
	CoreTrackerAccumulator* all;
	CoreTrackerAccumulator* visible;
	CoreTrackerAccumulator* selected;
};

struct _CoreViewTrackerMuxClass {
	GObjectClass parent_class;
};

static gint CoreTracker_private_offset;
static gpointer core_tracker_parent_class = NULL;
static gint CoreViewTracker_private_offset;
static gpointer core_view_tracker_parent_class = NULL;
static gpointer core_view_tracker_mux_parent_class = NULL;
static CoreTrackerAccumulatorIface * core_view_tracker_mux_core_tracker_accumulator_parent_iface = NULL;

VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN gpointer alteration_ref (gpointer instance);
VALA_EXTERN void alteration_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_alteration (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_alteration (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_alteration (const GValue* value);
VALA_EXTERN GType alteration_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Alteration, alteration_unref)
VALA_EXTERN GType core_tracker_accumulator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CoreTrackerAccumulator, g_object_unref)
VALA_EXTERN gboolean core_tracker_accumulator_include (CoreTrackerAccumulator* self,
                                           DataObject* object);
VALA_EXTERN gboolean core_tracker_accumulator_uninclude (CoreTrackerAccumulator* self,
                                             DataObject* object);
VALA_EXTERN gboolean core_tracker_accumulator_altered (CoreTrackerAccumulator* self,
                                           DataObject* object,
                                           Alteration* alteration);
static GType core_tracker_accumulator_get_type_once (void);
VALA_EXTERN gpointer core_tracker_ref (gpointer instance);
VALA_EXTERN void core_tracker_unref (gpointer instance);
VALA_EXTERN GParamSpec* core_param_spec_tracker (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void core_value_set_tracker (GValue* value,
                             gpointer v_object);
VALA_EXTERN void core_value_take_tracker (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer core_value_get_tracker (const GValue* value);
VALA_EXTERN GType core_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CoreTracker, core_tracker_unref)
VALA_EXTERN gpointer data_collection_ref (gpointer instance);
VALA_EXTERN void data_collection_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_data_collection (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_data_collection (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_data_collection (const GValue* value);
VALA_EXTERN GType data_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataCollection, data_collection_unref)
static void core_tracker_on_items_added (CoreTracker* self,
                                  GeeIterable* added);
static void _core_tracker_on_items_added_data_collection_items_added (DataCollection* _sender,
                                                               GeeIterable* added,
                                                               gpointer self);
static void core_tracker_on_items_removed (CoreTracker* self,
                                    GeeIterable* removed);
static void _core_tracker_on_items_removed_data_collection_items_removed (DataCollection* _sender,
                                                                   GeeIterable* removed,
                                                                   gpointer self);
static void core_tracker_on_items_altered (CoreTracker* self,
                                    GeeMap* map);
static void _core_tracker_on_items_altered_data_collection_items_altered (DataCollection* _sender,
                                                                   GeeMap* items,
                                                                   gpointer self);
VALA_EXTERN CoreTracker* core_tracker_new (DataCollection* collection,
                               GeeCollection* initial);
VALA_EXTERN CoreTracker* core_tracker_construct (GType object_type,
                                     DataCollection* collection,
                                     GeeCollection* initial);
VALA_EXTERN void core_tracker_start (CoreTracker* self,
                         CoreTrackerAccumulator* acc);
VALA_EXTERN GeeCollection* data_collection_get_all (DataCollection* self);
VALA_EXTERN DataCollection* core_tracker_get_collection (CoreTracker* self);
VALA_EXTERN void core_tracker_include_uninclude (CoreTracker* self,
                                     GeeIterable* objects,
                                     CoreTrackerIncludeUnincludeObject cb,
                                     gpointer cb_target);
static gboolean _core_tracker_accumulator_include_core_tracker_include_uninclude_object (DataObject* object,
                                                                                  gpointer self);
static gboolean _core_tracker_accumulator_uninclude_core_tracker_include_uninclude_object (DataObject* object,
                                                                                    gpointer self);
static void core_tracker_real_updated (CoreTracker* self);
static void core_tracker_finalize (CoreTracker * obj);
static GType core_tracker_get_type_once (void);
VALA_EXTERN GType core_view_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CoreViewTracker, core_tracker_unref)
static GType core_view_tracker_mux_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CoreViewTrackerMux, g_object_unref)
VALA_EXTERN GType view_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ViewCollection, data_collection_unref)
VALA_EXTERN GType data_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataView, g_object_unref)
static void core_view_tracker_on_items_shown (CoreViewTracker* self,
                                       GeeCollection* shown);
static void _core_view_tracker_on_items_shown_view_collection_items_shown (ViewCollection* _sender,
                                                                    GeeCollection* visible,
                                                                    gpointer self);
static void core_view_tracker_on_items_hidden (CoreViewTracker* self,
                                        GeeCollection* hidden);
static void _core_view_tracker_on_items_hidden_view_collection_items_hidden (ViewCollection* _sender,
                                                                      GeeCollection* hidden,
                                                                      gpointer self);
static void core_view_tracker_on_items_selected (CoreViewTracker* self,
                                          GeeIterable* selected);
static void _core_view_tracker_on_items_selected_view_collection_items_selected (ViewCollection* _sender,
                                                                          GeeIterable* selected,
                                                                          gpointer self);
static void core_view_tracker_on_items_unselected (CoreViewTracker* self,
                                            GeeIterable* unselected);
static void _core_view_tracker_on_items_unselected_view_collection_items_unselected (ViewCollection* _sender,
                                                                              GeeIterable* unselected,
                                                                              gpointer self);
VALA_EXTERN CoreViewTracker* core_view_tracker_new (ViewCollection* collection);
VALA_EXTERN CoreViewTracker* core_view_tracker_construct (GType object_type,
                                              ViewCollection* collection);
VALA_EXTERN GeeCollection* view_collection_get_all_unfiltered (ViewCollection* self);
VALA_EXTERN void core_view_tracker_start (CoreViewTracker* self,
                              CoreTrackerAccumulator* all,
                              CoreTrackerAccumulator* visible,
                              CoreTrackerAccumulator* selected);
static CoreViewTrackerMux* core_view_tracker_mux_new (CoreTrackerAccumulator* all,
                                               CoreTrackerAccumulator* visible,
                                               CoreTrackerAccumulator* selected);
static CoreViewTrackerMux* core_view_tracker_mux_construct (GType object_type,
                                                     CoreTrackerAccumulator* all,
                                                     CoreTrackerAccumulator* visible,
                                                     CoreTrackerAccumulator* selected);
static gboolean core_view_tracker_mux_real_include (CoreTrackerAccumulator* base,
                                             DataObject* object);
VALA_EXTERN gboolean data_view_is_visible (DataView* self);
VALA_EXTERN gboolean data_view_is_selected (DataView* self);
static gboolean core_view_tracker_mux_real_uninclude (CoreTrackerAccumulator* base,
                                               DataObject* object);
static gboolean core_view_tracker_mux_real_altered (CoreTrackerAccumulator* base,
                                             DataObject* object,
                                             Alteration* alteration);
static void core_view_tracker_mux_finalize (GObject * obj);
static GType core_view_tracker_mux_get_type_once (void);
static void core_view_tracker_finalize (CoreTracker * obj);
static GType core_view_tracker_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

gboolean
core_tracker_accumulator_include (CoreTrackerAccumulator* self,
                                  DataObject* object)
{
	CoreTrackerAccumulatorIface* _iface_;
	g_return_val_if_fail (CORE_IS_TRACKER_ACCUMULATOR (self), FALSE);
	_iface_ = CORE_TRACKER_ACCUMULATOR_GET_INTERFACE (self);
	if (_iface_->include) {
		return _iface_->include (self, object);
	}
	return FALSE;
}

gboolean
core_tracker_accumulator_uninclude (CoreTrackerAccumulator* self,
                                    DataObject* object)
{
	CoreTrackerAccumulatorIface* _iface_;
	g_return_val_if_fail (CORE_IS_TRACKER_ACCUMULATOR (self), FALSE);
	_iface_ = CORE_TRACKER_ACCUMULATOR_GET_INTERFACE (self);
	if (_iface_->uninclude) {
		return _iface_->uninclude (self, object);
	}
	return FALSE;
}

gboolean
core_tracker_accumulator_altered (CoreTrackerAccumulator* self,
                                  DataObject* object,
                                  Alteration* alteration)
{
	CoreTrackerAccumulatorIface* _iface_;
	g_return_val_if_fail (CORE_IS_TRACKER_ACCUMULATOR (self), FALSE);
	_iface_ = CORE_TRACKER_ACCUMULATOR_GET_INTERFACE (self);
	if (_iface_->altered) {
		return _iface_->altered (self, object, alteration);
	}
	return FALSE;
}

static void
core_tracker_accumulator_default_init (CoreTrackerAccumulatorIface * iface,
                                       gpointer iface_data)
{
}

static GType
core_tracker_accumulator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CoreTrackerAccumulatorIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) core_tracker_accumulator_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType core_tracker_accumulator_type_id;
	core_tracker_accumulator_type_id = g_type_register_static (G_TYPE_INTERFACE, "CoreTrackerAccumulator", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (core_tracker_accumulator_type_id, G_TYPE_OBJECT);
	return core_tracker_accumulator_type_id;
}

GType
core_tracker_accumulator_get_type (void)
{
	static volatile gsize core_tracker_accumulator_type_id__once = 0;
	if (g_once_init_enter (&core_tracker_accumulator_type_id__once)) {
		GType core_tracker_accumulator_type_id;
		core_tracker_accumulator_type_id = core_tracker_accumulator_get_type_once ();
		g_once_init_leave (&core_tracker_accumulator_type_id__once, core_tracker_accumulator_type_id);
	}
	return core_tracker_accumulator_type_id__once;
}

static inline gpointer
core_tracker_get_instance_private (CoreTracker* self)
{
	return G_STRUCT_MEMBER_P (self, CoreTracker_private_offset);
}

static void
_core_tracker_on_items_added_data_collection_items_added (DataCollection* _sender,
                                                          GeeIterable* added,
                                                          gpointer self)
{
	core_tracker_on_items_added ((CoreTracker*) self, added);
}

static void
_core_tracker_on_items_removed_data_collection_items_removed (DataCollection* _sender,
                                                              GeeIterable* removed,
                                                              gpointer self)
{
	core_tracker_on_items_removed ((CoreTracker*) self, removed);
}

static void
_core_tracker_on_items_altered_data_collection_items_altered (DataCollection* _sender,
                                                              GeeMap* items,
                                                              gpointer self)
{
	core_tracker_on_items_altered ((CoreTracker*) self, items);
}

static gpointer
_data_collection_ref0 (gpointer self)
{
	return self ? data_collection_ref (self) : NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

CoreTracker*
core_tracker_construct (GType object_type,
                        DataCollection* collection,
                        GeeCollection* initial)
{
	CoreTracker* self = NULL;
	DataCollection* _tmp0_;
	GeeCollection* _tmp1_;
	g_return_val_if_fail (IS_DATA_COLLECTION (collection), NULL);
	g_return_val_if_fail ((initial == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (initial, GEE_TYPE_COLLECTION), NULL);
	self = (CoreTracker*) g_type_create_instance (object_type);
	_tmp0_ = _data_collection_ref0 (collection);
	_data_collection_unref0 (self->priv->collection);
	self->priv->collection = _tmp0_;
	_tmp1_ = _g_object_ref0 (initial);
	_g_object_unref0 (self->priv->initial);
	self->priv->initial = _tmp1_;
	return self;
}

CoreTracker*
core_tracker_new (DataCollection* collection,
                  GeeCollection* initial)
{
	return core_tracker_construct (CORE_TYPE_TRACKER, collection, initial);
}

void
core_tracker_start (CoreTracker* self,
                    CoreTrackerAccumulator* acc)
{
	CoreTrackerAccumulator* _tmp0_;
	CoreTrackerAccumulator* _tmp1_;
	DataCollection* _tmp2_;
	DataCollection* _tmp3_;
	DataCollection* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GeeCollection* _tmp6_;
	g_return_if_fail (CORE_IS_TRACKER (self));
	g_return_if_fail (CORE_IS_TRACKER_ACCUMULATOR (acc));
	_tmp0_ = self->priv->acc;
	_vala_assert (_tmp0_ == NULL, "this.acc == null");
	_tmp1_ = _g_object_ref0 (acc);
	_g_object_unref0 (self->priv->acc);
	self->priv->acc = _tmp1_;
	_tmp2_ = self->priv->collection;
	g_signal_connect (_tmp2_, "items-added", (GCallback) _core_tracker_on_items_added_data_collection_items_added, self);
	_tmp3_ = self->priv->collection;
	g_signal_connect (_tmp3_, "items-removed", (GCallback) _core_tracker_on_items_removed_data_collection_items_removed, self);
	_tmp4_ = self->priv->collection;
	g_signal_connect (_tmp4_, "items-altered", (GCallback) _core_tracker_on_items_altered_data_collection_items_altered, self);
	_tmp6_ = self->priv->initial;
	if (_tmp6_ != NULL) {
		GeeCollection* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		_tmp7_ = self->priv->initial;
		_tmp8_ = gee_collection_get_size (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp5_ = _tmp9_ > 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		GeeCollection* _tmp10_;
		_tmp10_ = self->priv->initial;
		core_tracker_on_items_added (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ITERABLE, GeeIterable));
	} else {
		GeeCollection* _tmp11_;
		_tmp11_ = self->priv->initial;
		if (_tmp11_ == NULL) {
			DataCollection* _tmp12_;
			GeeCollection* _tmp13_;
			GeeCollection* _tmp14_;
			_tmp12_ = self->priv->collection;
			_tmp13_ = data_collection_get_all (_tmp12_);
			_tmp14_ = _tmp13_;
			core_tracker_on_items_added (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ITERABLE, GeeIterable));
			_g_object_unref0 (_tmp14_);
		}
	}
	_g_object_unref0 (self->priv->initial);
	self->priv->initial = NULL;
}

DataCollection*
core_tracker_get_collection (CoreTracker* self)
{
	DataCollection* _tmp0_;
	DataCollection* _tmp1_;
	DataCollection* result;
	g_return_val_if_fail (CORE_IS_TRACKER (self), NULL);
	_tmp0_ = self->priv->collection;
	_tmp1_ = _data_collection_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static gboolean
_core_tracker_accumulator_include_core_tracker_include_uninclude_object (DataObject* object,
                                                                         gpointer self)
{
	gboolean result;
	result = core_tracker_accumulator_include ((CoreTrackerAccumulator*) self, object);
	return result;
}

static void
core_tracker_on_items_added (CoreTracker* self,
                             GeeIterable* added)
{
	CoreTrackerAccumulator* _tmp0_;
	g_return_if_fail (CORE_IS_TRACKER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_ITERABLE));
	_tmp0_ = self->priv->acc;
	core_tracker_include_uninclude (self, added, _core_tracker_accumulator_include_core_tracker_include_uninclude_object, _tmp0_);
}

static gboolean
_core_tracker_accumulator_uninclude_core_tracker_include_uninclude_object (DataObject* object,
                                                                           gpointer self)
{
	gboolean result;
	result = core_tracker_accumulator_uninclude ((CoreTrackerAccumulator*) self, object);
	return result;
}

static void
core_tracker_on_items_removed (CoreTracker* self,
                               GeeIterable* removed)
{
	CoreTrackerAccumulator* _tmp0_;
	g_return_if_fail (CORE_IS_TRACKER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (removed, GEE_TYPE_ITERABLE));
	_tmp0_ = self->priv->acc;
	core_tracker_include_uninclude (self, removed, _core_tracker_accumulator_uninclude_core_tracker_include_uninclude_object, _tmp0_);
}

void
core_tracker_include_uninclude (CoreTracker* self,
                                GeeIterable* objects,
                                CoreTrackerIncludeUnincludeObject cb,
                                gpointer cb_target)
{
	gboolean fire_updated = FALSE;
	g_return_if_fail (CORE_IS_TRACKER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (objects, GEE_TYPE_ITERABLE));
	fire_updated = FALSE;
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (objects);
		_object_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataObject* object = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			gboolean _tmp4_ = FALSE;
			DataObject* _tmp5_;
			_tmp1_ = _object_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _object_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			object = (DataObject*) _tmp3_;
			_tmp5_ = object;
			if (cb (_tmp5_, cb_target)) {
				_tmp4_ = TRUE;
			} else {
				_tmp4_ = fire_updated;
			}
			fire_updated = _tmp4_;
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	if (fire_updated) {
		g_signal_emit (self, core_tracker_signals[CORE_TRACKER_UPDATED_SIGNAL], 0);
	}
}

static void
core_tracker_on_items_altered (CoreTracker* self,
                               GeeMap* map)
{
	gboolean fire_updated = FALSE;
	g_return_if_fail (CORE_IS_TRACKER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (map, GEE_TYPE_MAP));
	fire_updated = FALSE;
	{
		GeeIterator* _object_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = gee_map_get_keys (map);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_object_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			DataObject* object = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			CoreTrackerAccumulator* _tmp9_;
			DataObject* _tmp10_;
			DataObject* _tmp11_;
			gpointer _tmp12_;
			Alteration* _tmp13_;
			gboolean _tmp14_;
			_tmp5_ = _object_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _object_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			object = (DataObject*) _tmp7_;
			_tmp9_ = self->priv->acc;
			_tmp10_ = object;
			_tmp11_ = object;
			_tmp12_ = gee_map_get (map, _tmp11_);
			_tmp13_ = (Alteration*) _tmp12_;
			_tmp14_ = core_tracker_accumulator_altered (_tmp9_, _tmp10_, _tmp13_);
			_alteration_unref0 (_tmp13_);
			if (_tmp14_) {
				_tmp8_ = TRUE;
			} else {
				_tmp8_ = fire_updated;
			}
			fire_updated = _tmp8_;
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	if (fire_updated) {
		g_signal_emit (self, core_tracker_signals[CORE_TRACKER_UPDATED_SIGNAL], 0);
	}
}

static void
core_tracker_real_updated (CoreTracker* self)
{
}

static void
core_value_tracker_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
core_value_tracker_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		core_tracker_unref (value->data[0].v_pointer);
	}
}

static void
core_value_tracker_copy_value (const GValue* src_value,
                               GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = core_tracker_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
core_value_tracker_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
core_value_tracker_collect_value (GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		CoreTracker * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = core_tracker_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
core_value_tracker_lcopy_value (const GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	CoreTracker ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = core_tracker_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
core_param_spec_tracker (const gchar* name,
                         const gchar* nick,
                         const gchar* blurb,
                         GType object_type,
                         GParamFlags flags)
{
	CoreParamSpecTracker* spec;
	g_return_val_if_fail (g_type_is_a (object_type, CORE_TYPE_TRACKER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
core_value_get_tracker (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CORE_TYPE_TRACKER), NULL);
	return value->data[0].v_pointer;
}

void
core_value_set_tracker (GValue* value,
                        gpointer v_object)
{
	CoreTracker * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CORE_TYPE_TRACKER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CORE_TYPE_TRACKER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		core_tracker_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		core_tracker_unref (old);
	}
}

void
core_value_take_tracker (GValue* value,
                         gpointer v_object)
{
	CoreTracker * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CORE_TYPE_TRACKER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CORE_TYPE_TRACKER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		core_tracker_unref (old);
	}
}

static void
core_tracker_class_init (CoreTrackerClass * klass,
                         gpointer klass_data)
{
	core_tracker_parent_class = g_type_class_peek_parent (klass);
	((CoreTrackerClass *) klass)->finalize = core_tracker_finalize;
	g_type_class_adjust_private_offset (klass, &CoreTracker_private_offset);
	((CoreTrackerClass *) klass)->updated = core_tracker_real_updated;
	core_tracker_signals[CORE_TRACKER_UPDATED_SIGNAL] = g_signal_new ("updated", CORE_TYPE_TRACKER, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (CoreTrackerClass, updated), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
core_tracker_instance_init (CoreTracker * self,
                            gpointer klass)
{
	self->priv = core_tracker_get_instance_private (self);
	self->priv->acc = NULL;
	self->ref_count = 1;
}

static void
core_tracker_finalize (CoreTracker * obj)
{
	CoreTracker * self;
	CoreTrackerAccumulator* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CORE_TYPE_TRACKER, CoreTracker);
	g_signal_handlers_destroy (self);
	_tmp0_ = self->priv->acc;
	if (_tmp0_ != NULL) {
		DataCollection* _tmp1_;
		guint _tmp2_;
		DataCollection* _tmp3_;
		guint _tmp4_;
		DataCollection* _tmp5_;
		guint _tmp6_;
		_tmp1_ = self->priv->collection;
		g_signal_parse_name ("items-added", TYPE_DATA_COLLECTION, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _core_tracker_on_items_added_data_collection_items_added, self);
		_tmp3_ = self->priv->collection;
		g_signal_parse_name ("items-removed", TYPE_DATA_COLLECTION, &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _core_tracker_on_items_removed_data_collection_items_removed, self);
		_tmp5_ = self->priv->collection;
		g_signal_parse_name ("items-altered", TYPE_DATA_COLLECTION, &_tmp6_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _core_tracker_on_items_altered_data_collection_items_altered, self);
	}
	_data_collection_unref0 (self->priv->collection);
	_g_object_unref0 (self->priv->initial);
	_g_object_unref0 (self->priv->acc);
}

static GType
core_tracker_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { core_value_tracker_init, core_value_tracker_free_value, core_value_tracker_copy_value, core_value_tracker_peek_pointer, "p", core_value_tracker_collect_value, "p", core_value_tracker_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (CoreTrackerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) core_tracker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CoreTracker), 0, (GInstanceInitFunc) core_tracker_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType core_tracker_type_id;
	core_tracker_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CoreTracker", &g_define_type_info, &g_define_type_fundamental_info, 0);
	CoreTracker_private_offset = g_type_add_instance_private (core_tracker_type_id, sizeof (CoreTrackerPrivate));
	return core_tracker_type_id;
}

GType
core_tracker_get_type (void)
{
	static volatile gsize core_tracker_type_id__once = 0;
	if (g_once_init_enter (&core_tracker_type_id__once)) {
		GType core_tracker_type_id;
		core_tracker_type_id = core_tracker_get_type_once ();
		g_once_init_leave (&core_tracker_type_id__once, core_tracker_type_id);
	}
	return core_tracker_type_id__once;
}

gpointer
core_tracker_ref (gpointer instance)
{
	CoreTracker * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
core_tracker_unref (gpointer instance)
{
	CoreTracker * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CORE_TRACKER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
core_view_tracker_get_instance_private (CoreViewTracker* self)
{
	return G_STRUCT_MEMBER_P (self, CoreViewTracker_private_offset);
}

static void
_core_view_tracker_on_items_shown_view_collection_items_shown (ViewCollection* _sender,
                                                               GeeCollection* visible,
                                                               gpointer self)
{
	core_view_tracker_on_items_shown ((CoreViewTracker*) self, visible);
}

static void
_core_view_tracker_on_items_hidden_view_collection_items_hidden (ViewCollection* _sender,
                                                                 GeeCollection* hidden,
                                                                 gpointer self)
{
	core_view_tracker_on_items_hidden ((CoreViewTracker*) self, hidden);
}

static void
_core_view_tracker_on_items_selected_view_collection_items_selected (ViewCollection* _sender,
                                                                     GeeIterable* selected,
                                                                     gpointer self)
{
	core_view_tracker_on_items_selected ((CoreViewTracker*) self, selected);
}

static void
_core_view_tracker_on_items_unselected_view_collection_items_unselected (ViewCollection* _sender,
                                                                         GeeIterable* unselected,
                                                                         gpointer self)
{
	core_view_tracker_on_items_unselected ((CoreViewTracker*) self, unselected);
}

CoreViewTracker*
core_view_tracker_construct (GType object_type,
                             ViewCollection* collection)
{
	CoreViewTracker* self = NULL;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	g_return_val_if_fail (IS_VIEW_COLLECTION (collection), NULL);
	_tmp0_ = view_collection_get_all_unfiltered (collection);
	_tmp1_ = _tmp0_;
	self = (CoreViewTracker*) core_tracker_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (collection, TYPE_DATA_COLLECTION, DataCollection), _tmp1_);
	_g_object_unref0 (_tmp1_);
	return self;
}

CoreViewTracker*
core_view_tracker_new (ViewCollection* collection)
{
	return core_view_tracker_construct (CORE_TYPE_VIEW_TRACKER, collection);
}

void
core_view_tracker_start (CoreViewTracker* self,
                         CoreTrackerAccumulator* all,
                         CoreTrackerAccumulator* visible,
                         CoreTrackerAccumulator* selected)
{
	CoreViewTrackerMux* _tmp0_;
	CoreViewTrackerMux* _tmp1_;
	ViewCollection* collection = NULL;
	DataCollection* _tmp2_;
	ViewCollection* _tmp3_;
	CoreViewTrackerMux* _tmp4_;
	g_return_if_fail (CORE_IS_VIEW_TRACKER (self));
	g_return_if_fail ((all == NULL) || CORE_IS_TRACKER_ACCUMULATOR (all));
	g_return_if_fail ((visible == NULL) || CORE_IS_TRACKER_ACCUMULATOR (visible));
	g_return_if_fail ((selected == NULL) || CORE_IS_TRACKER_ACCUMULATOR (selected));
	_tmp0_ = self->priv->mux;
	_vala_assert (_tmp0_ == NULL, "mux == null");
	_tmp1_ = core_view_tracker_mux_new (all, visible, selected);
	_g_object_unref0 (self->priv->mux);
	self->priv->mux = _tmp1_;
	_tmp2_ = core_tracker_get_collection (G_TYPE_CHECK_INSTANCE_CAST (self, CORE_TYPE_TRACKER, CoreTracker));
	_tmp3_ = IS_VIEW_COLLECTION (_tmp2_) ? ((ViewCollection*) _tmp2_) : NULL;
	if (_tmp3_ == NULL) {
		_data_collection_unref0 (_tmp2_);
	}
	collection = _tmp3_;
	_vala_assert (collection != NULL, "collection != null");
	g_signal_connect (collection, "items-shown", (GCallback) _core_view_tracker_on_items_shown_view_collection_items_shown, self);
	g_signal_connect (collection, "items-hidden", (GCallback) _core_view_tracker_on_items_hidden_view_collection_items_hidden, self);
	g_signal_connect (collection, "items-selected", (GCallback) _core_view_tracker_on_items_selected_view_collection_items_selected, self);
	g_signal_connect (collection, "items-unselected", (GCallback) _core_view_tracker_on_items_unselected_view_collection_items_unselected, self);
	_tmp4_ = self->priv->mux;
	core_tracker_start (G_TYPE_CHECK_INSTANCE_CAST (self, CORE_TYPE_TRACKER, CoreTracker), G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, CORE_TYPE_TRACKER_ACCUMULATOR, CoreTrackerAccumulator));
	_data_collection_unref0 (collection);
}

static void
core_view_tracker_on_items_shown (CoreViewTracker* self,
                                  GeeCollection* shown)
{
	CoreViewTrackerMux* _tmp0_;
	CoreTrackerAccumulator* _tmp1_;
	g_return_if_fail (CORE_IS_VIEW_TRACKER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (shown, GEE_TYPE_COLLECTION));
	_tmp0_ = self->priv->mux;
	_tmp1_ = _tmp0_->visible;
	if (_tmp1_ != NULL) {
		CoreViewTrackerMux* _tmp2_;
		CoreTrackerAccumulator* _tmp3_;
		_tmp2_ = self->priv->mux;
		_tmp3_ = _tmp2_->visible;
		core_tracker_include_uninclude (G_TYPE_CHECK_INSTANCE_CAST (self, CORE_TYPE_TRACKER, CoreTracker), G_TYPE_CHECK_INSTANCE_CAST (shown, GEE_TYPE_ITERABLE, GeeIterable), _core_tracker_accumulator_include_core_tracker_include_uninclude_object, _tmp3_);
	}
}

static void
core_view_tracker_on_items_hidden (CoreViewTracker* self,
                                   GeeCollection* hidden)
{
	CoreViewTrackerMux* _tmp0_;
	CoreTrackerAccumulator* _tmp1_;
	g_return_if_fail (CORE_IS_VIEW_TRACKER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (hidden, GEE_TYPE_COLLECTION));
	_tmp0_ = self->priv->mux;
	_tmp1_ = _tmp0_->visible;
	if (_tmp1_ != NULL) {
		CoreViewTrackerMux* _tmp2_;
		CoreTrackerAccumulator* _tmp3_;
		_tmp2_ = self->priv->mux;
		_tmp3_ = _tmp2_->visible;
		core_tracker_include_uninclude (G_TYPE_CHECK_INSTANCE_CAST (self, CORE_TYPE_TRACKER, CoreTracker), G_TYPE_CHECK_INSTANCE_CAST (hidden, GEE_TYPE_ITERABLE, GeeIterable), _core_tracker_accumulator_uninclude_core_tracker_include_uninclude_object, _tmp3_);
	}
}

static void
core_view_tracker_on_items_selected (CoreViewTracker* self,
                                     GeeIterable* selected)
{
	CoreViewTrackerMux* _tmp0_;
	CoreTrackerAccumulator* _tmp1_;
	g_return_if_fail (CORE_IS_VIEW_TRACKER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (selected, GEE_TYPE_ITERABLE));
	_tmp0_ = self->priv->mux;
	_tmp1_ = _tmp0_->selected;
	if (_tmp1_ != NULL) {
		CoreViewTrackerMux* _tmp2_;
		CoreTrackerAccumulator* _tmp3_;
		_tmp2_ = self->priv->mux;
		_tmp3_ = _tmp2_->selected;
		core_tracker_include_uninclude (G_TYPE_CHECK_INSTANCE_CAST (self, CORE_TYPE_TRACKER, CoreTracker), selected, _core_tracker_accumulator_include_core_tracker_include_uninclude_object, _tmp3_);
	}
}

static void
core_view_tracker_on_items_unselected (CoreViewTracker* self,
                                       GeeIterable* unselected)
{
	CoreViewTrackerMux* _tmp0_;
	CoreTrackerAccumulator* _tmp1_;
	g_return_if_fail (CORE_IS_VIEW_TRACKER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (unselected, GEE_TYPE_ITERABLE));
	_tmp0_ = self->priv->mux;
	_tmp1_ = _tmp0_->selected;
	if (_tmp1_ != NULL) {
		CoreViewTrackerMux* _tmp2_;
		CoreTrackerAccumulator* _tmp3_;
		_tmp2_ = self->priv->mux;
		_tmp3_ = _tmp2_->selected;
		core_tracker_include_uninclude (G_TYPE_CHECK_INSTANCE_CAST (self, CORE_TYPE_TRACKER, CoreTracker), unselected, _core_tracker_accumulator_uninclude_core_tracker_include_uninclude_object, _tmp3_);
	}
}

static CoreViewTrackerMux*
core_view_tracker_mux_construct (GType object_type,
                                 CoreTrackerAccumulator* all,
                                 CoreTrackerAccumulator* visible,
                                 CoreTrackerAccumulator* selected)
{
	CoreViewTrackerMux * self = NULL;
	CoreTrackerAccumulator* _tmp0_;
	CoreTrackerAccumulator* _tmp1_;
	CoreTrackerAccumulator* _tmp2_;
	g_return_val_if_fail ((all == NULL) || CORE_IS_TRACKER_ACCUMULATOR (all), NULL);
	g_return_val_if_fail ((visible == NULL) || CORE_IS_TRACKER_ACCUMULATOR (visible), NULL);
	g_return_val_if_fail ((selected == NULL) || CORE_IS_TRACKER_ACCUMULATOR (selected), NULL);
	self = (CoreViewTrackerMux*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (all);
	_g_object_unref0 (self->all);
	self->all = _tmp0_;
	_tmp1_ = _g_object_ref0 (visible);
	_g_object_unref0 (self->visible);
	self->visible = _tmp1_;
	_tmp2_ = _g_object_ref0 (selected);
	_g_object_unref0 (self->selected);
	self->selected = _tmp2_;
	return self;
}

static CoreViewTrackerMux*
core_view_tracker_mux_new (CoreTrackerAccumulator* all,
                           CoreTrackerAccumulator* visible,
                           CoreTrackerAccumulator* selected)
{
	return core_view_tracker_mux_construct (CORE_VIEW_TRACKER_TYPE_MUX, all, visible, selected);
}

static gboolean
core_view_tracker_mux_real_include (CoreTrackerAccumulator* base,
                                    DataObject* object)
{
	CoreViewTrackerMux * self;
	DataView* view = NULL;
	DataView* _tmp0_;
	gboolean fire_updated = FALSE;
	CoreTrackerAccumulator* _tmp1_;
	gboolean _tmp5_ = FALSE;
	CoreTrackerAccumulator* _tmp6_;
	gboolean _tmp11_ = FALSE;
	CoreTrackerAccumulator* _tmp12_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CORE_VIEW_TRACKER_TYPE_MUX, CoreViewTrackerMux);
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DATA_VIEW, DataView));
	view = _tmp0_;
	fire_updated = FALSE;
	_tmp1_ = self->all;
	if (_tmp1_ != NULL) {
		gboolean _tmp2_ = FALSE;
		CoreTrackerAccumulator* _tmp3_;
		DataView* _tmp4_;
		_tmp3_ = self->all;
		_tmp4_ = view;
		if (core_tracker_accumulator_include (_tmp3_, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_OBJECT, DataObject))) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = fire_updated;
		}
		fire_updated = _tmp2_;
	}
	_tmp6_ = self->visible;
	if (_tmp6_ != NULL) {
		DataView* _tmp7_;
		_tmp7_ = view;
		_tmp5_ = data_view_is_visible (_tmp7_);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		gboolean _tmp8_ = FALSE;
		CoreTrackerAccumulator* _tmp9_;
		DataView* _tmp10_;
		_tmp9_ = self->visible;
		_tmp10_ = view;
		if (core_tracker_accumulator_include (_tmp9_, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_OBJECT, DataObject))) {
			_tmp8_ = TRUE;
		} else {
			_tmp8_ = fire_updated;
		}
		fire_updated = _tmp8_;
	}
	_tmp12_ = self->selected;
	if (_tmp12_ != NULL) {
		DataView* _tmp13_;
		_tmp13_ = view;
		_tmp11_ = data_view_is_selected (_tmp13_);
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		gboolean _tmp14_ = FALSE;
		CoreTrackerAccumulator* _tmp15_;
		DataView* _tmp16_;
		_tmp15_ = self->selected;
		_tmp16_ = view;
		if (core_tracker_accumulator_include (_tmp15_, G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_DATA_OBJECT, DataObject))) {
			_tmp14_ = TRUE;
		} else {
			_tmp14_ = fire_updated;
		}
		fire_updated = _tmp14_;
	}
	result = fire_updated;
	_g_object_unref0 (view);
	return result;
}

static gboolean
core_view_tracker_mux_real_uninclude (CoreTrackerAccumulator* base,
                                      DataObject* object)
{
	CoreViewTrackerMux * self;
	DataView* view = NULL;
	DataView* _tmp0_;
	gboolean fire_updated = FALSE;
	CoreTrackerAccumulator* _tmp1_;
	gboolean _tmp5_ = FALSE;
	CoreTrackerAccumulator* _tmp6_;
	gboolean _tmp11_ = FALSE;
	CoreTrackerAccumulator* _tmp12_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CORE_VIEW_TRACKER_TYPE_MUX, CoreViewTrackerMux);
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DATA_VIEW, DataView));
	view = _tmp0_;
	fire_updated = FALSE;
	_tmp1_ = self->all;
	if (_tmp1_ != NULL) {
		gboolean _tmp2_ = FALSE;
		CoreTrackerAccumulator* _tmp3_;
		DataView* _tmp4_;
		_tmp3_ = self->all;
		_tmp4_ = view;
		if (core_tracker_accumulator_uninclude (_tmp3_, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_OBJECT, DataObject))) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = fire_updated;
		}
		fire_updated = _tmp2_;
	}
	_tmp6_ = self->visible;
	if (_tmp6_ != NULL) {
		DataView* _tmp7_;
		_tmp7_ = view;
		_tmp5_ = data_view_is_visible (_tmp7_);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		gboolean _tmp8_ = FALSE;
		CoreTrackerAccumulator* _tmp9_;
		DataView* _tmp10_;
		_tmp9_ = self->visible;
		_tmp10_ = view;
		if (core_tracker_accumulator_uninclude (_tmp9_, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_OBJECT, DataObject))) {
			_tmp8_ = TRUE;
		} else {
			_tmp8_ = fire_updated;
		}
		fire_updated = _tmp8_;
	}
	_tmp12_ = self->selected;
	if (_tmp12_ != NULL) {
		DataView* _tmp13_;
		_tmp13_ = view;
		_tmp11_ = data_view_is_selected (_tmp13_);
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		gboolean _tmp14_ = FALSE;
		CoreTrackerAccumulator* _tmp15_;
		DataView* _tmp16_;
		_tmp15_ = self->selected;
		_tmp16_ = view;
		if (core_tracker_accumulator_uninclude (_tmp15_, G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_DATA_OBJECT, DataObject))) {
			_tmp14_ = TRUE;
		} else {
			_tmp14_ = fire_updated;
		}
		fire_updated = _tmp14_;
	}
	result = fire_updated;
	_g_object_unref0 (view);
	return result;
}

static gboolean
core_view_tracker_mux_real_altered (CoreTrackerAccumulator* base,
                                    DataObject* object,
                                    Alteration* alteration)
{
	CoreViewTrackerMux * self;
	DataView* view = NULL;
	DataView* _tmp0_;
	gboolean fire_updated = FALSE;
	CoreTrackerAccumulator* _tmp1_;
	gboolean _tmp5_ = FALSE;
	CoreTrackerAccumulator* _tmp6_;
	gboolean _tmp11_ = FALSE;
	CoreTrackerAccumulator* _tmp12_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CORE_VIEW_TRACKER_TYPE_MUX, CoreViewTrackerMux);
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
	g_return_val_if_fail (IS_ALTERATION (alteration), FALSE);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DATA_VIEW, DataView));
	view = _tmp0_;
	fire_updated = FALSE;
	_tmp1_ = self->all;
	if (_tmp1_ != NULL) {
		gboolean _tmp2_ = FALSE;
		CoreTrackerAccumulator* _tmp3_;
		DataView* _tmp4_;
		_tmp3_ = self->all;
		_tmp4_ = view;
		if (core_tracker_accumulator_altered (_tmp3_, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_OBJECT, DataObject), alteration)) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = fire_updated;
		}
		fire_updated = _tmp2_;
	}
	_tmp6_ = self->visible;
	if (_tmp6_ != NULL) {
		DataView* _tmp7_;
		_tmp7_ = view;
		_tmp5_ = data_view_is_visible (_tmp7_);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		gboolean _tmp8_ = FALSE;
		CoreTrackerAccumulator* _tmp9_;
		DataView* _tmp10_;
		_tmp9_ = self->visible;
		_tmp10_ = view;
		if (core_tracker_accumulator_altered (_tmp9_, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_OBJECT, DataObject), alteration)) {
			_tmp8_ = TRUE;
		} else {
			_tmp8_ = fire_updated;
		}
		fire_updated = _tmp8_;
	}
	_tmp12_ = self->selected;
	if (_tmp12_ != NULL) {
		DataView* _tmp13_;
		_tmp13_ = view;
		_tmp11_ = data_view_is_selected (_tmp13_);
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		gboolean _tmp14_ = FALSE;
		CoreTrackerAccumulator* _tmp15_;
		DataView* _tmp16_;
		_tmp15_ = self->selected;
		_tmp16_ = view;
		if (core_tracker_accumulator_altered (_tmp15_, G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_DATA_OBJECT, DataObject), alteration)) {
			_tmp14_ = TRUE;
		} else {
			_tmp14_ = fire_updated;
		}
		fire_updated = _tmp14_;
	}
	result = fire_updated;
	_g_object_unref0 (view);
	return result;
}

static void
core_view_tracker_mux_class_init (CoreViewTrackerMuxClass * klass,
                                  gpointer klass_data)
{
	core_view_tracker_mux_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = core_view_tracker_mux_finalize;
}

static void
core_view_tracker_mux_core_tracker_accumulator_interface_init (CoreTrackerAccumulatorIface * iface,
                                                               gpointer iface_data)
{
	core_view_tracker_mux_core_tracker_accumulator_parent_iface = g_type_interface_peek_parent (iface);
	iface->include = (gboolean (*) (CoreTrackerAccumulator*, DataObject*)) core_view_tracker_mux_real_include;
	iface->uninclude = (gboolean (*) (CoreTrackerAccumulator*, DataObject*)) core_view_tracker_mux_real_uninclude;
	iface->altered = (gboolean (*) (CoreTrackerAccumulator*, DataObject*, Alteration*)) core_view_tracker_mux_real_altered;
}

static void
core_view_tracker_mux_instance_init (CoreViewTrackerMux * self,
                                     gpointer klass)
{
}

static void
core_view_tracker_mux_finalize (GObject * obj)
{
	CoreViewTrackerMux * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CORE_VIEW_TRACKER_TYPE_MUX, CoreViewTrackerMux);
	_g_object_unref0 (self->all);
	_g_object_unref0 (self->visible);
	_g_object_unref0 (self->selected);
	G_OBJECT_CLASS (core_view_tracker_mux_parent_class)->finalize (obj);
}

static GType
core_view_tracker_mux_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CoreViewTrackerMuxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) core_view_tracker_mux_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CoreViewTrackerMux), 0, (GInstanceInitFunc) core_view_tracker_mux_instance_init, NULL };
	static const GInterfaceInfo core_tracker_accumulator_info = { (GInterfaceInitFunc) core_view_tracker_mux_core_tracker_accumulator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType core_view_tracker_mux_type_id;
	core_view_tracker_mux_type_id = g_type_register_static (G_TYPE_OBJECT, "CoreViewTrackerMux", &g_define_type_info, 0);
	g_type_add_interface_static (core_view_tracker_mux_type_id, CORE_TYPE_TRACKER_ACCUMULATOR, &core_tracker_accumulator_info);
	return core_view_tracker_mux_type_id;
}

static GType
core_view_tracker_mux_get_type (void)
{
	static volatile gsize core_view_tracker_mux_type_id__once = 0;
	if (g_once_init_enter (&core_view_tracker_mux_type_id__once)) {
		GType core_view_tracker_mux_type_id;
		core_view_tracker_mux_type_id = core_view_tracker_mux_get_type_once ();
		g_once_init_leave (&core_view_tracker_mux_type_id__once, core_view_tracker_mux_type_id);
	}
	return core_view_tracker_mux_type_id__once;
}

static void
core_view_tracker_class_init (CoreViewTrackerClass * klass,
                              gpointer klass_data)
{
	core_view_tracker_parent_class = g_type_class_peek_parent (klass);
	((CoreTrackerClass *) klass)->finalize = core_view_tracker_finalize;
	g_type_class_adjust_private_offset (klass, &CoreViewTracker_private_offset);
}

static void
core_view_tracker_instance_init (CoreViewTracker * self,
                                 gpointer klass)
{
	self->priv = core_view_tracker_get_instance_private (self);
	self->priv->mux = NULL;
}

static void
core_view_tracker_finalize (CoreTracker * obj)
{
	CoreViewTracker * self;
	CoreViewTrackerMux* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CORE_TYPE_VIEW_TRACKER, CoreViewTracker);
	_tmp0_ = self->priv->mux;
	if (_tmp0_ != NULL) {
		ViewCollection* collection = NULL;
		DataCollection* _tmp1_;
		ViewCollection* _tmp2_;
		ViewCollection* _tmp3_;
		ViewCollection* _tmp4_;
		guint _tmp5_;
		ViewCollection* _tmp6_;
		guint _tmp7_;
		ViewCollection* _tmp8_;
		guint _tmp9_;
		ViewCollection* _tmp10_;
		guint _tmp11_;
		_tmp1_ = core_tracker_get_collection (G_TYPE_CHECK_INSTANCE_CAST (self, CORE_TYPE_TRACKER, CoreTracker));
		_tmp2_ = IS_VIEW_COLLECTION (_tmp1_) ? ((ViewCollection*) _tmp1_) : NULL;
		if (_tmp2_ == NULL) {
			_data_collection_unref0 (_tmp1_);
		}
		collection = _tmp2_;
		_tmp3_ = collection;
		_vala_assert (_tmp3_ != NULL, "collection != null");
		_tmp4_ = collection;
		g_signal_parse_name ("items-shown", TYPE_VIEW_COLLECTION, &_tmp5_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _core_view_tracker_on_items_shown_view_collection_items_shown, self);
		_tmp6_ = collection;
		g_signal_parse_name ("items-hidden", TYPE_VIEW_COLLECTION, &_tmp7_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _core_view_tracker_on_items_hidden_view_collection_items_hidden, self);
		_tmp8_ = collection;
		g_signal_parse_name ("items-selected", TYPE_VIEW_COLLECTION, &_tmp9_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _core_view_tracker_on_items_selected_view_collection_items_selected, self);
		_tmp10_ = collection;
		g_signal_parse_name ("items-unselected", TYPE_VIEW_COLLECTION, &_tmp11_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _core_view_tracker_on_items_unselected_view_collection_items_unselected, self);
		_data_collection_unref0 (collection);
	}
	_g_object_unref0 (self->priv->mux);
	CORE_TRACKER_CLASS (core_view_tracker_parent_class)->finalize (obj);
}

static GType
core_view_tracker_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CoreViewTrackerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) core_view_tracker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CoreViewTracker), 0, (GInstanceInitFunc) core_view_tracker_instance_init, NULL };
	GType core_view_tracker_type_id;
	core_view_tracker_type_id = g_type_register_static (CORE_TYPE_TRACKER, "CoreViewTracker", &g_define_type_info, 0);
	CoreViewTracker_private_offset = g_type_add_instance_private (core_view_tracker_type_id, sizeof (CoreViewTrackerPrivate));
	return core_view_tracker_type_id;
}

GType
core_view_tracker_get_type (void)
{
	static volatile gsize core_view_tracker_type_id__once = 0;
	if (g_once_init_enter (&core_view_tracker_type_id__once)) {
		GType core_view_tracker_type_id;
		core_view_tracker_type_id = core_view_tracker_get_type_once ();
		g_once_init_leave (&core_view_tracker_type_id__once, core_view_tracker_type_id);
	}
	return core_view_tracker_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

