const char luadebug_lua[] =
"--[[\n"
"\tCopyright (c) 2020 Scott Lembcke and Howling Moon Software\n"
"\n"
"\tPermission is hereby granted, free of charge, to any person obtaining a copy\n"
"\tof this software and associated documentation files (the \"Software\"), to deal\n"
"\tin the Software without restriction, including without limitation the rights\n"
"\tto use, copy, modify, merge, publish, distribute, sublicense, and/or sell\n"
"\tcopies of the Software, and to permit persons to whom the Software is\n"
"\tfurnished to do so, subject to the following conditions:\n"
"\n"
"\tThe above copyright notice and this permission notice shall be included in\n"
"\tall copies or substantial portions of the Software.\n"
"\n"
"\tTHE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n"
"\tIMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n"
"\tFITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n"
"\tAUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n"
"\tLIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\n"
"\tOUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE\n"
"\tSOFTWARE.\n"
"\n"
"\tTODO:\n"
"\t* Print short function arguments as part of stack location.\n"
"\t* Properly handle being reentrant due to coroutines.\n"
"]]\n"
"\n"
"local dbg\n"
"\n"
"local HOME_DIR = os.getenv('HOME')\n"
"local DEBUGGER = 'luadebug'\n"
"local HISTORYFILE = HOME_DIR ~= nil and HOME_DIR .. '/' .. '.tdbg_history' or nil\n"
"-- Use ANSI color codes in the prompt by default.\n"
"local COLOR_GRAY = \"\"\n"
"local COLOR_RED = \"\"\n"
"local COLOR_GREEN\n"
"local COLOR_BLUE = \"\"\n"
"local COLOR_YELLOW = \"\"\n"
"local COLOR_RESET = \"\"\n"
"local CARET_SYM = \"=>\"\n"
"local CARET = \" \" .. CARET_SYM .. \" \"\n"
"local BREAK_SYM = \"●\"\n"
"\n"
"local LJ_MAX_LINE = 0x7fffff00 -- Max. source code line number.\n"
"\n"
"local function pretty(obj, max_depth)\n"
"    if max_depth == nil then\n"
"        max_depth = dbg.cfg.pretty_depth\n"
"    end\n"
"\n"
"    -- Returns true if a table has a __tostring metamethod.\n"
"    local function coerceable(tbl)\n"
"        local meta = getmetatable(tbl)\n"
"        return (meta and meta.__tostring)\n"
"    end\n"
"\n"
"    local function recurse(obj, depth)\n"
"        if type(obj) == \"string\" then\n"
"            -- Dump the string so that escape sequences are printed.\n"
"            return string.format(\"%q\", obj)\n"
"        elseif type(obj) == \"table\" and depth < max_depth and not coerceable(obj) then\n"
"            local str = \"{\"\n"
"\n"
"            for k, v in pairs(obj) do\n"
"                local pair = pretty(k, 0) .. \" = \" .. recurse(v, depth + 1)\n"
"                str = str .. (str == \"{\" and pair or \", \" .. pair)\n"
"            end\n"
"\n"
"            return str .. \"}\"\n"
"        else\n"
"            -- tostring() can fail if there is an error in a __tostring metamethod.\n"
"            local success, value = pcall(function() return tostring(obj) end)\n"
"            return (success and value or \"<!!error in __tostring metamethod!!>\")\n"
"        end\n"
"    end\n"
"\n"
"    return recurse(obj, 0)\n"
"end\n"
"\n"
"local function get_stack_length(offset)\n"
"    local index = offset + 1\n"
"    while true do\n"
"        if not debug.getinfo(index) then\n"
"            break\n"
"        end\n"
"        index = index + 1\n"
"    end\n"
"    return index - offset - 1\n"
"end\n"
"\n"
"-- The stack level that cmd_* functions use to access locals or info\n"
"-- The structure of the code very carefully ensures this.\n"
"local CMD_STACK_LEVEL = 6\n"
"\n"
"-- Location of the top of the stack outside of the debugger.\n"
"-- Adjusted by some debugger entrypoints.\n"
"local stack_top = 0\n"
"\n"
"-- The current stack frame index.\n"
"-- Changed using the up/down commands\n"
"local stack_inspect_offset = 0\n"
"\n"
"-- Tarantool console compatible readline support.\n"
"local function dbg_readline(prompt)\n"
"    local console = require('console.lib')\n"
"    local line = console.readline({\n"
"        prompt = prompt,\n"
"        completion = nil,\n"
"    })\n"
"    if not line then\n"
"        return nil\n"
"    end\n"
"    console.add_history(line)\n"
"    if HISTORYFILE then\n"
"        console.save_history(HISTORYFILE)\n"
"    end\n"
"    return line\n"
"end\n"
"\n"
"-- Default dbg.write function\n"
"local function dbg_write(str)\n"
"    io.write(str)\n"
"end\n"
"\n"
"local function dbg_writeln(str, ...)\n"
"    if select(\"#\", ...) == 0 then\n"
"        dbg.write((str or \"<NULL>\") .. \"\\n\")\n"
"    else\n"
"        dbg.write(string.format(str .. \"\\n\", ...))\n"
"    end\n"
"end\n"
"\n"
"-- colored text output wrappers\n"
"local function color_blue(text)\n"
"    return COLOR_BLUE .. text .. COLOR_RESET\n"
"end\n"
"\n"
"local function color_yellow(text)\n"
"    return COLOR_YELLOW .. text .. COLOR_RESET\n"
"end\n"
"\n"
"local function color_red(text)\n"
"    return COLOR_RED .. text .. COLOR_RESET\n"
"end\n"
"\n"
"local function color_grey(text)\n"
"    return COLOR_GRAY .. text .. COLOR_RESET\n"
"end\n"
"\n"
"-- report error highlighted in color\n"
"local function dbg_write_error(str, ...)\n"
"    dbg_writeln(color_red('Error: ') .. str, ...)\n"
"end\n"
"\n"
"-- report non-fatal warnings highlighted in color\n"
"local function dbg_write_warn(str, ...)\n"
"    dbg_writeln(color_yellow('Warning: ') .. str, ...)\n"
"end\n"
"\n"
"local function q(text)\n"
"    return \"'\" .. text .. \"'\"\n"
"end\n"
"\n"
"local function format_loc(file, line)\n"
"    return color_blue(file) .. \":\" .. color_yellow(line)\n"
"end\n"
"\n"
"local function format_stack_frame_info(info)\n"
"    local filename = info.source:match(\"@(.*)\")\n"
"    local source = filename and dbg.shorten_path(filename) or info.short_src\n"
"    local namewhat = (info.namewhat == \"\" and \"chunk at\" or info.namewhat)\n"
"    local name = info.name and q(color_blue(info.name)) or\n"
"                 format_loc(source, info.linedefined)\n"
"    return format_loc(source, info.currentline) .. \" in \" .. namewhat .. \" \" .. name\n"
"end\n"
"\n"
"local fio = require 'fio'\n"
"local cwd = fio.cwd()\n"
"\n"
"local suffix_arrays = {} -- memoize file x tree resuls\n"
"local normalized_files = {} -- memoize normalization results\n"
"\n"
"--[[\n"
"    Normalize `debug.getinfo().source` names:\n"
"    - remove leading '@';\n"
"    - remove trailing new lines (if any);\n"
"    - if there is leading '.' or '..' then calculate full path\n"
"      using current directory.\n"
"]]\n"
"local function normalize_file(file, resolve_dots)\n"
"    local srcfile = file\n"
"    if not file then\n"
"        return ''\n"
"    end\n"
"    if normalized_files[file] then\n"
"        return normalized_files[file]\n"
"    end\n"
"    file = file:gsub('^@', ''):gsub('\\n', '')\n"
"    if resolve_dots and file:sub(1,1) == '.' then\n"
"        file = fio.abspath(fio.pathjoin(cwd, file))\n"
"    end\n"
"    normalized_files[srcfile] = file\n"
"    return file\n"
"end\n"
"\n"
"-- This function is on a hot path of a debugger hook.\n"
"-- Try very hard to avoid wasting of CPU cycles, so reuse\n"
"-- previously calculated results via memoization\n"
"local function build_suffix_array(file, resolve_dots)\n"
"    local decorated_name = file\n"
"    if suffix_arrays[decorated_name] ~= nil then\n"
"        return suffix_arrays[decorated_name]\n"
"    end\n"
"\n"
"    local suffixes = {}\n"
"    file = normalize_file(file, resolve_dots)\n"
"    --[[\n"
"        we would very much prefer to use simple:\n"
"           for v in file:gmatch('[^/]+') do\n"
"        loop here, but string.gmatch is very slow\n"
"        and that we actually need here are simple strchr's.\n"
"    ]]\n"
"    local i = 0\n"
"    local j\n"
"    local v\n"
"    repeat\n"
"        j = file:find('/', i, true)\n"
"        if j ~= nil then\n"
"            v = file:sub(i, j - 1)\n"
"            if v ~= '.' then -- just skip '.' for current dir\n"
"                if v == '..' then\n"
"                    table.remove(suffixes)\n"
"                else\n"
"                    table.insert(suffixes, 1, v)\n"
"                end\n"
"            end\n"
"            i = j + 1\n"
"        end\n"
"    until j == nil\n"
"    -- don't forget to process the trailing segment\n"
"    v = file:sub(i, #file)\n"
"    if v ~= '.' then -- just skip '.' for current dir\n"
"        if v == '..' then\n"
"            table.remove(suffixes)\n"
"        else\n"
"            table.insert(suffixes, 1, v)\n"
"        end\n"
"    end\n"
"\n"
"    suffix_arrays[decorated_name] = suffixes\n"
"    return suffixes\n"
"end\n"
"\n"
"-- Merge suffix array A to the tree T:\n"
"--   Given input array ['E.lua','C','B'] which is suffix array\n"
"--   corresponding to the input path '@B/./C/E.lua',\n"
"--   we build tree of a form:\n"
"--     T['E.lua']['C']['B'] = {}\n"
"local function append_suffix_array(T, A)\n"
"    assert(type(T) == 'table')\n"
"    assert(type(A) == 'table')\n"
"    if #A < 1 then\n"
"        return\n"
"    end\n"
"    local C = T -- advance current node, starting from root\n"
"    local P -- prior node\n"
"    for i = 1, #A do\n"
"        local v = A[i]\n"
"        if not C[v] then\n"
"            C[v] = {}\n"
"            C[v]['$ref'] = 1 --reference counter\n"
"        else\n"
"            C[v]['$ref'] = C[v]['$ref'] + 1\n"
"        end\n"
"        P = C\n"
"        C = C[v]\n"
"    end\n"
"    local last = A[#A]\n"
"    P[last]['$f'] = true\n"
"end\n"
"\n"
"-- lookup into suffix tree T given constructed suffix array S\n"
"local function lookup_suffix_array(T, S)\n"
"    if #S < 1 then\n"
"        return false\n"
"    end\n"
"    -- we need to make sure that at least once\n"
"    -- we have matched node inside of loop\n"
"    -- so bail out immediately if there is no any single\n"
"    -- match\n"
"    if T[S[1]] == nil then\n"
"        return false\n"
"    end\n"
"\n"
"    local C = T\n"
"    local P -- last accessed node\n"
"    local v\n"
"    for i = 1, #S do\n"
"        v = S[i]\n"
"        if C[v] == nil then\n"
"            return not not P[S[i - 1]]['$f']\n"
"        end\n"
"        P = C\n"
"        C = C[v]\n"
"    end\n"
"    return not not P[v]['$f']\n"
"end\n"
"\n"
"--[[\n"
"    Given suffix tree T try to remove suffix array A\n"
"    from the tree. Leafs and intermediate nodes will be\n"
"    cleaned up only once their reference counter '$ref'\n"
"    will reach 1.\n"
"]]\n"
"local function remove_suffix_array(T, A)\n"
"    local C = T\n"
"    local mem_walk = {}\n"
"    -- walks down tree, remembering pointers for inner directories\n"
"    for i = 1, #A do\n"
"        mem_walk[i] = C\n"
"        local v = A[i]\n"
"        if C[v] == nil then\n"
"            return false\n"
"        end\n"
"        C = C[v]\n"
"    end\n"
"\n"
"    -- now walk in revert order cleaning subnodes,\n"
"    -- starting from deepest reachable leaf\n"
"    for i = #A, 1, -1 do\n"
"        C = mem_walk[i]\n"
"        local v = A[i]\n"
"        assert(C[v] ~= nil)\n"
"        assert(C[v]['$ref'] >= 1)\n"
"        C[v]['$ref'] = C[v]['$ref'] - 1\n"
"        if C[v]['$ref'] <= 1 then\n"
"            mem_walk[i] = nil\n"
"            C[v] = nil\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"local myself = normalize_file(debug.getinfo(1,'S').source)\n"
"local breakpoints = {}\n"
"\n"
"local function has_breakpoint(file, line)\n"
"    local T = breakpoints[line]\n"
"    if T == nil then\n"
"        return false\n"
"    end\n"
"    local suffixes = build_suffix_array(file)\n"
"    return lookup_suffix_array(T, suffixes)\n"
"end\n"
"\n"
"local function has_active_breakpoints()\n"
"    local key = next(breakpoints)\n"
"    return key ~= nil\n"
"end\n"
"\n"
"local function add_breakpoint(file, line)\n"
"    local suffixes = build_suffix_array(file, true)\n"
"    local normfile = normalize_file(file, true)\n"
"    -- save direct hash (for faster lookup): line -> file\n"
"    if not breakpoints[line] then\n"
"        breakpoints[line] = {}\n"
"    end\n"
"    append_suffix_array(breakpoints[line], suffixes)\n"
"    -- save reversed hash information: file -> [lines]\n"
"    if not breakpoints[normfile] then\n"
"        breakpoints[normfile] = {}\n"
"    end\n"
"    breakpoints[normfile][line] = true\n"
"end\n"
"\n"
"local function remove_breakpoint(file, line)\n"
"    local normfile = normalize_file(file, true)\n"
"    if breakpoints[line] == nil then\n"
"        return false\n"
"    end\n"
"    local suffixes = build_suffix_array(file, true)\n"
"    remove_suffix_array(breakpoints[line], suffixes)\n"
"    breakpoints[normfile][line] = nil\n"
"end\n"
"\n"
"local repl\n"
"\n"
"-- Return false for stack frames without source,\n"
"-- which includes C frames, Lua bytecode, and `loadstring` functions\n"
"local function frame_has_line(info) return info.currentline >= 0 end\n"
"\n"
"local dbg_hook_ofs = 2\n"
"\n"
"local function hook_factory(level)\n"
"    local stop_level = level or -1\n"
"    return function(reason)\n"
"        return function(event, _)\n"
"            -- Skip events that don't have line information.\n"
"            local info = debug.getinfo(2, \"Sl\")\n"
"            local normfile = normalize_file(info.source)\n"
"\n"
"            if not frame_has_line(info) or normfile == myself then\n"
"                return\n"
"            end\n"
"\n"
"            -- [Correction logics borrowed from mobdebug.lua]\n"
"            -- This is needed to check if the stack got shorter or longer.\n"
"            -- Unfortunately counting call/return calls is not reliable.\n"
"            -- The discrepancy may happen when \"pcall(load, '')\" call is made\n"
"            -- or when \"error()\" is called in a function.\n"
"            -- Start from one level higher just in case we need to grow the\n"
"            -- stack. This may happen after coroutine.resume call to a function\n"
"            -- that doesn't have any other instructions to execute. It triggers\n"
"            -- three returns: \"return, tail return, return\", which needs to be\n"
"            -- accounted for.\n"
"            local offset = get_stack_length(dbg_hook_ofs)\n"
"\n"
"            if event == \"line\" then\n"
"                local matched = offset <= stop_level or\n"
"                                has_breakpoint(normfile, info.currentline)\n"
"                if matched then\n"
"                    repl(reason)\n"
"                end\n"
"            end\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"-- For the breakpoint hook, we will bail out of a function\n"
"-- for a majority of a calls (say in 99.999% of a cases).\n"
"-- So it's very important to spend as little time as possible\n"
"-- here: quick return if irrelevant, allocate the least possible\n"
"-- memory, memoize calculated values - as for neighborhood lines it will\n"
"-- be mostly the same\n"
"local function hook_check_bps()\n"
"    return function(event, _)\n"
"        -- Skip events that don't have line information.\n"
"        local info = debug.getinfo(2, \"Sl\")\n"
"        if not frame_has_line(info) then\n"
"            return\n"
"        end\n"
"        if event == 'line' and has_breakpoint(info.source, info.currentline) then\n"
"            repl('hit')\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"-- Create a table of all the locally accessible variables.\n"
"-- Globals are not included when running the locals command, but are when running the print command.\n"
"local function local_bindings(offset, include_globals)\n"
"    local level = offset + stack_inspect_offset + CMD_STACK_LEVEL\n"
"    local func = debug.getinfo(level, \"f\").func\n"
"    local bindings = {}\n"
"\n"
"    -- Retrieve the upvalues\n"
"    do  local i = 1;\n"
"        while true do\n"
"            local name, value = debug.getupvalue(func, i)\n"
"            if not name then break end\n"
"            bindings[name] = value\n"
"            i = i + 1\n"
"        end\n"
"    end\n"
"\n"
"    -- Retrieve the locals (overwriting any upvalues)\n"
"    do  local i = 1;\n"
"        while true do\n"
"            local name, value = debug.getlocal(level, i)\n"
"            if not name then break end\n"
"            bindings[name] = value\n"
"            i = i + 1\n"
"        end\n"
"    end\n"
"\n"
"    -- Retrieve the varargs (works in Lua 5.2 and LuaJIT)\n"
"    local varargs = {}\n"
"    do  local i = 1;\n"
"        while true do\n"
"            local name, value = debug.getlocal(level, -i)\n"
"            if not name then break end\n"
"            varargs[i] = value\n"
"            i = i + 1\n"
"        end\n"
"    end\n"
"    if #varargs > 0 then bindings[\"...\"] = varargs end\n"
"\n"
"    if include_globals then\n"
"        return setmetatable(bindings, { __index = getfenv(func) or _G })\n"
"    else\n"
"        return bindings\n"
"    end\n"
"end\n"
"\n"
"-- Used as a __newindex metamethod to modify variables in cmd_eval().\n"
"local function mutate_bindings(_, name, value)\n"
"    local FUNC_STACK_OFFSET = 3 -- Stack depth of this function.\n"
"    local level = stack_inspect_offset + FUNC_STACK_OFFSET + CMD_STACK_LEVEL\n"
"\n"
"    -- Set a local.\n"
"    do  local i = 1;\n"
"        repeat\n"
"            local var = debug.getlocal(level, i)\n"
"            if name == var then\n"
"                dbg_writeln(color_yellow(DEBUGGER) .. CARET ..\n"
"                            \"Set local variable \" .. color_blue(name))\n"
"                return debug.setlocal(level, i, value)\n"
"            end\n"
"            i = i + 1\n"
"        until var == nil\n"
"    end\n"
"\n"
"    -- Set an upvalue.\n"
"    local func = debug.getinfo(level).func\n"
"    do  local i = 1;\n"
"        repeat\n"
"            local var = debug.getupvalue(func, i)\n"
"            if name == var then\n"
"                dbg_writeln(color_yellow(DEBUGGER) ..\n"
"                            \"Set upvalue \" .. color_blue(name))\n"
"                return debug.setupvalue(func, i, value)\n"
"            end\n"
"            i = i + 1\n"
"        until var == nil\n"
"    end\n"
"\n"
"    -- Set a global.\n"
"    dbg_writeln(color_yellow(DEBUGGER) ..\n"
"                \"Set global variable \" .. color_blue(name))\n"
"    _G[name] = value\n"
"end\n"
"\n"
"-- Compile an expression with the given variable bindings.\n"
"local function compile_chunk(block, env)\n"
"    local source = DEBUGGER .. \" REPL\"\n"
"    local chunk = loadstring(block, source)\n"
"    if chunk then\n"
"        setfenv(chunk, env)\n"
"    else\n"
"        dbg_write_error(\"Could not compile block: %s\", q(block))\n"
"    end\n"
"    return chunk\n"
"end\n"
"\n"
"local SOURCE_CACHE = {}\n"
"local tnt = nil\n"
"\n"
"local function code_listing(source, currentline, file, context_lines)\n"
"    local normfile = normalize_file(file)\n"
"    if source and source[currentline] then\n"
"        for i = currentline - context_lines,\n"
"                currentline + context_lines do\n"
"            local break_at = has_breakpoint(normfile, i)\n"
"            local tab_or_caret = (i == currentline and CARET_SYM or \"  \")\n"
"                                 .. (break_at and BREAK_SYM or \" \")\n"
"            local line = source[i]\n"
"            if line then\n"
"                dbg_writeln(color_grey(\"% 4d\") .. tab_or_caret .. \"%s\", i, line)\n"
"            end\n"
"        end\n"
"        return true\n"
"    else\n"
"        dbg_write_warn(\"No source code is available for %s:%d\",\n"
"                       color_blue(normfile), currentline or 0)\n"
"        return true\n"
"    end\n"
"end\n"
"\n"
"local function where(info, context_lines)\n"
"    local filesource = info.source\n"
"    local source = SOURCE_CACHE[info.source]\n"
"    if not source then\n"
"        source = {}\n"
"        -- Tarantool builtin module\n"
"        if filesource:match(\"@builtin/.*.lua\") then\n"
"            pcall(function()\n"
"                local lua_code = tnt.debug.getsources(filesource)\n"
"\n"
"                for line in string.gmatch(lua_code, \"([^\\n]*)\\n\?\") do\n"
"                    table.insert(source, line)\n"
"                end\n"
"            end)\n"
"        else\n"
"            -- external module - load file\n"
"            local filename = filesource:match(\"@(.*)\") or filesource\n"
"            if filename then\n"
"                pcall(function()\n"
"                    for line in io.lines(filename) do\n"
"                        table.insert(source, line)\n"
"                    end\n"
"                end)\n"
"            elseif filesource then\n"
"                for line in info.source:gmatch(\"(.-)\\n\") do\n"
"                    table.insert(filesource, line)\n"
"                end\n"
"            end\n"
"        end\n"
"        SOURCE_CACHE[info.source] = source\n"
"    end\n"
"\n"
"    return code_listing(source, info.currentline, info.source, context_lines)\n"
"end\n"
"\n"
"-- Status flag to avoid redundant code listing to be shown.\n"
"-- `up`, `down`, `where` commands show their own code context\n"
"-- so do not show anything after them.\n"
"local listing_shown = false\n"
"\n"
"-- Display automatically `where` context if configured so.\n"
"local function auto_listing(info)\n"
"    if tonumber(dbg.cfg.auto_where) then\n"
"        return where(info, dbg.cfg.auto_where)\n"
"    end\n"
"end\n"
"\n"
"-- Wee version differences\n"
"local unpack = unpack or table.unpack\n"
"local pack = function(...) return { n = select(\"#\", ...), ... } end\n"
"\n"
"local current_stack_level = function() return get_stack_length(stack_top) end\n"
"\n"
"local function cmd_step()\n"
"    return true, hook_factory(math.huge)\n"
"end\n"
"\n"
"local function cmd_next()\n"
"    return true, hook_factory(current_stack_level() - CMD_STACK_LEVEL)\n"
"end\n"
"\n"
"local function cmd_finish()\n"
"    return true, hook_factory(current_stack_level() - CMD_STACK_LEVEL - 1)\n"
"end\n"
"\n"
"-- If there is no any single defined breakpoint yet, then\n"
"-- do not stop in debugger hooks\n"
"local function cmd_continue()\n"
"    if not has_active_breakpoints() then\n"
"        return true\n"
"    end\n"
"    return true, hook_check_bps\n"
"end\n"
"\n"
"local function cmd_print(expr)\n"
"    local env = local_bindings(1, true)\n"
"    local chunk = compile_chunk(\"return \" .. expr, env)\n"
"    if chunk == nil then return false end\n"
"\n"
"    -- Call the chunk and collect the results.\n"
"    local results = pack(pcall(chunk, unpack(rawget(env, \"...\") or {})))\n"
"\n"
"    -- The first result is the pcall error.\n"
"    if not results[1] then\n"
"        dbg_write_error(results[2])\n"
"    else\n"
"        local output = \"\"\n"
"        for i = 2, results.n do\n"
"            output = output .. (i ~= 2 and \", \" or \"\") .. pretty(results[i])\n"
"        end\n"
"\n"
"        if output == \"\" then output = \"<no result>\" end\n"
"        dbg_writeln(color_blue(expr) .. CARET .. output)\n"
"    end\n"
"\n"
"    return false\n"
"end\n"
"\n"
"local function cmd_eval(code)\n"
"    local env = local_bindings(1, true)\n"
"    local mutable_env = setmetatable({}, {\n"
"        __index = env,\n"
"        __newindex = mutate_bindings,\n"
"    })\n"
"\n"
"    local chunk = compile_chunk(code, mutable_env)\n"
"    if chunk == nil then return false end\n"
"\n"
"    -- Call the chunk and collect the results.\n"
"    local success, err = pcall(chunk, unpack(rawget(env, \"...\") or {}))\n"
"    if not success then\n"
"        dbg_write_error(tostring(err))\n"
"    end\n"
"\n"
"    return false\n"
"end\n"
"\n"
"--[[\n"
"    Parse source location syntax. One of a kind:\n"
"        luadebug.lua:100\n"
"        luadebug.lua+100\n"
"        :100\n"
"        +100\n"
"--]]\n"
"local function parse_bp(expr)\n"
"    assert(expr)\n"
"    local from, to, file, line = expr:find('^(.-)%s*[+:](%d+)%s*$')\n"
"    if not from then return nil end\n"
"    assert(to == #expr)\n"
"    return file, tonumber(line)\n"
"end\n"
"\n"
"local function _bp_format_expected()\n"
"    dbg_write_error(\"command expects argument in format filename:NN or \" ..\n"
"                    \"filename+NN, where NN should be a positive number.\")\n"
"end\n"
"\n"
"-- check range to fit in boundaries {from, to}\n"
"local function check_line_max(v, from, to)\n"
"    if type(v) ~= 'number' then\n"
"        dbg_write_error(\"numeric value expected as line number, \" ..\n"
"                        \"but received %s\", type(v))\n"
"        return false\n"
"    end\n"
"    if v >= from and v <= to then\n"
"        return true\n"
"    end\n"
"    dbg_write_error(\"line number %d is out of allowed range [%d, %d]\",\n"
"                    v, from, to)\n"
"    return false\n"
"end\n"
"\n"
"\n"
"local function cmd_add_breakpoint(bps)\n"
"    assert(bps)\n"
"    local fullfile, line = parse_bp(bps)\n"
"    if not fullfile then\n"
"        _bp_format_expected()\n"
"        return false\n"
"    end\n"
"    if not check_line_max(line, 1, LJ_MAX_LINE) then\n"
"        return false\n"
"    end\n"
"    local info = debug.getinfo(stack_inspect_offset + CMD_STACK_LEVEL, \"S\")\n"
"    local debuggee = info.source\n"
"    local file = #fullfile > 0 and fullfile or debuggee\n"
"    local normfile = normalize_file(file)\n"
"\n"
"    add_breakpoint(normfile, line)\n"
"    dbg_writeln(\"Added breakpoint %s:%d.\", color_blue(normfile), line)\n"
"    listing_shown = auto_listing({source = file, currentline = line})\n"
"    return false\n"
"end\n"
"\n"
"local function _bpd_format_expected()\n"
"    dbg_write_error(\" command expects argument specifying breakpoint or\" ..\n"
"                    \" * for all breakpoints.\")\n"
"end\n"
"\n"
"local function cmd_remove_breakpoint(bps)\n"
"    assert(bps)\n"
"    if bps == '*' then\n"
"        breakpoints = {}\n"
"        dbg_writeln(\"Removed all breakpoints.\")\n"
"        return false\n"
"    end\n"
"\n"
"    local fullfile, line = parse_bp(bps)\n"
"    if not fullfile then\n"
"        _bpd_format_expected()\n"
"        return false\n"
"    end\n"
"    if not check_line_max(line, 1, LJ_MAX_LINE) then\n"
"        return false\n"
"    end\n"
"    local info = debug.getinfo(stack_inspect_offset + CMD_STACK_LEVEL, \"S\")\n"
"    local debuggee = info.source\n"
"    local file = #fullfile > 0 and fullfile or debuggee\n"
"    local normfile = normalize_file(file)\n"
"    local removed = remove_breakpoint(normfile, line)\n"
"    if removed then\n"
"        dbg_writeln(\"Removed breakpoint %s:%d.\", color_blue(normfile), line)\n"
"    else\n"
"        dbg_write_warn(\"No breakpoint defined in %s:%d.\",\n"
"                       color_blue(normfile), line)\n"
"    end\n"
"    return false\n"
"end\n"
"\n"
"local function cmd_list_breakpoints()\n"
"    if has_active_breakpoints() then\n"
"        dbg_writeln(\"List of active breakpoints:\")\n"
"        -- we keep both lines->file and file->line in the same\n"
"        -- breakpoints[] array, thus we should filter out strings\n"
"        for file, breaks in pairs(breakpoints) do\n"
"            if type(file) == 'string' then\n"
"                local sorted = {}\n"
"                for line, _ in pairs(breaks) do\n"
"                    table.insert(sorted, line)\n"
"                end\n"
"                table.sort(sorted)\n"
"                for _, line in pairs(sorted) do\n"
"                    dbg_writeln(\"\\t%s:%d\", file, line)\n"
"                end\n"
"            end\n"
"        end\n"
"    else\n"
"        dbg_write_warn(\"No active breakpoints defined.\")\n"
"    end\n"
"    return false\n"
"end\n"
"\n"
"--[[\n"
"    Go up the stack. It advances from the callee frame to the caller.\n"
"]]\n"
"local function cmd_up()\n"
"    local offset = stack_inspect_offset\n"
"    local info\n"
"\n"
"    repeat -- Find the next frame with a file.\n"
"        offset = offset + 1\n"
"        info = debug.getinfo(offset + CMD_STACK_LEVEL, \"Snl\")\n"
"    until not info or frame_has_line(info)\n"
"\n"
"    if info then\n"
"        stack_inspect_offset = offset\n"
"        dbg_writeln(\"Inspecting frame: \" .. format_stack_frame_info(info))\n"
"        auto_listing(info)\n"
"    else\n"
"        dbg_write_warn(\"Already at the bottom of the stack.\")\n"
"    end\n"
"    listing_shown = true\n"
"\n"
"    return false\n"
"end\n"
"\n"
"--[[\n"
"    Go down the stack. It advances from the caller frame to the callee.\n"
"]]\n"
"local function cmd_down()\n"
"    local offset = stack_inspect_offset\n"
"    local info\n"
"\n"
"    repeat -- Find the next frame with a file.\n"
"        offset = offset - 1\n"
"        if offset < stack_top then info = nil; break end\n"
"        info = debug.getinfo(offset + CMD_STACK_LEVEL)\n"
"    until frame_has_line(info)\n"
"\n"
"    if info then\n"
"        stack_inspect_offset = offset\n"
"        dbg_writeln(\"Inspecting frame: \" .. format_stack_frame_info(info))\n"
"        auto_listing(info)\n"
"    else\n"
"        dbg_write_warn(\"Already at the top of the stack.\")\n"
"    end\n"
"    listing_shown = true\n"
"\n"
"    return false\n"
"end\n"
"\n"
"local function cmd_where(context_lines)\n"
"    local info = debug.getinfo(stack_inspect_offset + CMD_STACK_LEVEL, \"Sl\")\n"
"    if info then\n"
"        where(info, tonumber(context_lines) or 5)\n"
"    end\n"
"    listing_shown = true\n"
"    return false\n"
"end\n"
"\n"
"local function cmd_trace()\n"
"    dbg_writeln(\"Inspecting frame %d\", stack_inspect_offset - stack_top)\n"
"    local i = 0;\n"
"    while true do\n"
"        local info = debug.getinfo(stack_top + CMD_STACK_LEVEL + i, \"Snl\")\n"
"        if not info then break end\n"
"\n"
"        local is_current_frame = (i + stack_top == stack_inspect_offset)\n"
"        local tab_or_caret = (is_current_frame and CARET or \"    \")\n"
"        dbg_writeln(color_grey(\"% 4d\") .. tab_or_caret .. \"%s\",\n"
"                    i, format_stack_frame_info(info))\n"
"        i = i + 1\n"
"    end\n"
"\n"
"    return false\n"
"end\n"
"\n"
"local function cmd_locals()\n"
"    local bindings = local_bindings(1, false)\n"
"\n"
"    -- Get all the variable binding names and sort them\n"
"    local keys = {}\n"
"    for k, _ in pairs(bindings) do table.insert(keys, k) end\n"
"    table.sort(keys)\n"
"\n"
"    for _, k in ipairs(keys) do\n"
"        local v = bindings[k]\n"
"\n"
"        -- Skip the debugger object itself, \"(*internal)\" values, and Lua 5.2's _ENV object.\n"
"        if not rawequal(v, dbg) and k ~= \"_ENV\" and not k:match(\"%(.*%)\") then\n"
"            dbg_writeln(\"  \" .. color_blue(k) .. CARET .. pretty(v))\n"
"        end\n"
"    end\n"
"\n"
"    return false\n"
"end\n"
"\n"
"local gen_commands\n"
"\n"
"local function cmd_help()\n"
"    for _, v in ipairs(gen_commands) do\n"
"        local map = gen_commands[v]\n"
"        if #map.aliases > 0 then\n"
"            local fun = require 'fun'\n"
"            local txt = ''\n"
"            fun.each(function(x) txt = txt .. ', ' .. color_yellow(x) end,\n"
"                     map.aliases)\n"
"            dbg.writeln(color_blue(v) .. ', ' .. string.sub(txt, 3, #txt) ..\n"
"                        ' ' .. (map.arg or ''))\n"
"        else\n"
"            dbg.writeln(color_blue(v) .. ' ' .. (map.arg or ''));\n"
"        end\n"
"        dbg.writeln(color_grey('    -- ' .. map.help))\n"
"    end\n"
"    dbg.writeln('')\n"
"\n"
"    return false\n"
"end\n"
"\n"
"local function cmd_quit()\n"
"    dbg.exit(0)\n"
"    return true\n"
"end\n"
"\n"
"local commands_help = {\n"
"    {'b.reak.point $location|add_break.point', 'set new breakpoints at module.lua+num', cmd_add_breakpoint},\n"
"    {'bd.elete $location|delete_break.point', 'delete breakpoints',  cmd_remove_breakpoint},\n"
"    {'bl.ist|list_break.points', 'list breakpoints', cmd_list_breakpoints},\n"
"    {'c.ont.inue', 'continue execution', cmd_continue},\n"
"    {'d.own', 'move down the stack by one frame',  cmd_down},\n"
"    {'e.val $expression', 'execute the statement',  cmd_eval},\n"
"    {'f.inish|step_out', 'step forward until exiting the current function',  cmd_finish},\n"
"    {'h.elp|\?', 'print this help message',  cmd_help},\n"
"    {'l.ocals', 'print the function arguments, locals and upvalues',  cmd_locals},\n"
"    {'n.ext|step_over', 'step forward by one line (skipping over functions)',  cmd_next},\n"
"    {'p.rint $expression', 'execute the expression and print the result',  cmd_print},\n"
"    {'q.uit', 'exit debugger', cmd_quit},\n"
"    {'s.t.ep|step_into', 'step forward by one line (into functions)', cmd_step},\n"
"    {'t.race|bt', 'print the stack trace',  cmd_trace},\n"
"    {'u.p', 'move up the stack by one frame',  cmd_up},\n"
"    {'w.here $linecount', 'print source code around the current line', cmd_where},\n"
"}\n"
"\n"
"local function build_commands_map(commands)\n"
"    local gen_commands = {}\n"
"\n"
"    for _, cmds in ipairs(commands) do\n"
"        local c, h, f = unpack(cmds)\n"
"        local first = true\n"
"        local main_cmd\n"
"        local pattern = '^[^%s]+%s+([^%s]+)'\n"
"        --[[\n"
"            \"expected argument\" is treated as a global attribute,\n"
"            active for all command's aliases.\n"
"        ]]\n"
"        local arg_exp = false\n"
"\n"
"        for subcmds in c:gmatch('[^|]+') do\n"
"            local arg = subcmds:match(pattern)\n"
"            subcmds = subcmds:match('^([^%s]+)')\n"
"            local cmd = ''\n"
"            local gen = subcmds:gmatch('[^.]+')\n"
"            local prefix = gen()\n"
"            local suffix = ''\n"
"            local segment = prefix\n"
"\n"
"            -- remember the first segment (main shortcut for command)\n"
"            if first then\n"
"                main_cmd = prefix\n"
"                arg_exp = arg\n"
"            end\n"
"\n"
"            repeat\n"
"                cmd = cmd .. segment\n"
"                gen_commands[cmd] = {\n"
"                    help = h,\n"
"                    handler = f,\n"
"                    first = first,\n"
"                    suffix = suffix,\n"
"                    aliases = {},\n"
"                    arg = arg_exp\n"
"                }\n"
"                if first then\n"
"                    table.insert(gen_commands, main_cmd)\n"
"                else\n"
"                    assert(#main_cmd > 0)\n"
"                    table.insert(gen_commands[main_cmd].aliases, cmd)\n"
"                end\n"
"                first = false\n"
"                segment = gen()\n"
"                suffix = suffix .. (segment or '')\n"
"            until not segment\n"
"        end\n"
"    end\n"
"    return gen_commands\n"
"end\n"
"\n"
"gen_commands = build_commands_map(commands_help)\n"
"\n"
"local last_cmd = false\n"
"\n"
"-- Recognize a command, then return command handler,\n"
"-- 1st argument passed, and flag what argument is expected.\n"
"local function match_command(line)\n"
"    local gen = line:gmatch('[^%s]+')\n"
"    local cmd = gen()\n"
"    local arg1st = gen()\n"
"    if not gen_commands[cmd] then\n"
"        return nil\n"
"    else\n"
"        return gen_commands[cmd].handler, arg1st, gen_commands[cmd].arg\n"
"    end\n"
"end\n"
"\n"
"-- Run a command line\n"
"-- Returns true if the REPL should exit and the hook function factory\n"
"local function run_command(line)\n"
"    -- GDB/LLDB exit on ctrl-d\n"
"    if line == nil then dbg.exit(1); return true end\n"
"\n"
"    -- Re-execute the last command if you press return.\n"
"    if line == \"\" then line = last_cmd or \"h\" end\n"
"\n"
"    local handler, command_arg, arg_expected = match_command(line)\n"
"    if handler then\n"
"        if arg_expected and command_arg == nil then\n"
"            dbg_write_error(\"command '%s' expects argument, but none received.\\n\" ..\n"
"                            \"Type 'h' and press return for a command list.\",\n"
"                            line)\n"
"            return false\n"
"        else\n"
"            last_cmd = line\n"
"            -- unpack({...}) prevents tail call elimination so the stack frame indices are predictable.\n"
"            return unpack({ handler(command_arg) })\n"
"        end\n"
"    elseif dbg.cfg.auto_eval then\n"
"        return unpack({ cmd_eval(line) })\n"
"    else\n"
"        dbg_write_error(\"command '%s' is not recognized.\\n\" ..\n"
"                        \"Type 'h' and press return for a command list.\",\n"
"                        line)\n"
"        return false\n"
"    end\n"
"end\n"
"\n"
"local started = false\n"
"\n"
"local function motto()\n"
"    -- Detect Tarantool version.\n"
"    if not tnt then\n"
"        tnt = require('tarantool')\n"
"        assert(tnt ~= nil)\n"
"    end\n"
"    dbg_writeln(color_yellow(DEBUGGER .. \": \") .. \"Loaded for \" .. tnt.version)\n"
"    jit.off()\n"
"    jit.flush()\n"
"end\n"
"\n"
"-- lazily perform repl initialization\n"
"local function start_repl()\n"
"    if started then\n"
"        return\n"
"    end\n"
"    motto()\n"
"    if HISTORYFILE then\n"
"        require('console.lib').load_history(HISTORYFILE)\n"
"    end\n"
"    started = true\n"
"end\n"
"\n"
"repl = function(reason)\n"
"    start_repl()\n"
"    -- Skip frames without source info.\n"
"    while not frame_has_line(debug.getinfo(stack_inspect_offset +\n"
"                                           CMD_STACK_LEVEL - 3, \"l\")) do\n"
"        stack_inspect_offset = stack_inspect_offset + 1\n"
"    end\n"
"\n"
"    local info = debug.getinfo(stack_inspect_offset + CMD_STACK_LEVEL - 3,\n"
"                               \"Snl\")\n"
"    reason = reason and (color_yellow(\"break via \") .. color_red(reason) ..\n"
"             CARET) or \"\"\n"
"    dbg_writeln(reason .. format_stack_frame_info(info))\n"
"\n"
"    repeat\n"
"        -- Do not current context if prior command showed their own.\n"
"        if not listing_shown then\n"
"            auto_listing(info)\n"
"        end\n"
"        -- Command could show their own context with listing\n"
"        -- so reset status before command executed.\n"
"        listing_shown = false\n"
"        local success, done, hook = pcall(run_command,\n"
"                                         dbg.read(color_red(DEBUGGER .. \"> \")))\n"
"        if success then\n"
"            debug.sethook(hook and hook(0), \"l\")\n"
"        else\n"
"            local message = color_red(\"INTERNAL \" .. DEBUGGER .. \" ERROR. \" ..\n"
"                            \"ABORTING\\n:\") .. \" \" .. done\n"
"            dbg_writeln(message)\n"
"            error(message)\n"
"        end\n"
"    until done\n"
"end\n"
"\n"
"-- Make the debugger object callable like a function.\n"
"dbg = setmetatable({\n"
"        read    = dbg_readline,\n"
"        write   = dbg_write,\n"
"        writeln = dbg_writeln,\n"
"\n"
"        shorten_path = function(path) return path end,\n"
"        exit    = function(err) os.exit(err) end,\n"
"\n"
"        cfg = {\n"
"            auto_where  = 3,\n"
"            auto_eval   = false,\n"
"            pretty_depth = 3,\n"
"        },\n"
"        pretty  = pretty,\n"
"        pp = function(value, depth)\n"
"            dbg_writeln(pretty(value, depth))\n"
"        end,\n"
"    }, {\n"
"    __call = function(_, condition, top_offset, source)\n"
"        if condition then\n"
"            return\n"
"        end\n"
"\n"
"        top_offset = top_offset or 0\n"
"        stack_inspect_offset = top_offset\n"
"        stack_top = top_offset\n"
"\n"
"        local hook_next = hook_factory(current_stack_level())\n"
"        debug.sethook(hook_next(source or \"dbg()\"), \"l\")\n"
"        return\n"
"    end,\n"
"})\n"
"\n"
"local lua_error, lua_assert = error, assert\n"
"\n"
"-- Works like error(), but invokes the debugger.\n"
"function dbg.error(err, level)\n"
"    level = level or 1\n"
"    dbg_write_error(pretty(err))\n"
"    dbg(false, level, \"dbg.error()\")\n"
"\n"
"    lua_error(err, level)\n"
"end\n"
"\n"
"-- Works like assert(), but invokes the debugger on a failure.\n"
"function dbg.assert(condition, message)\n"
"    if not condition then\n"
"        dbg_write_error(message)\n"
"        dbg(false, 1, \"dbg.assert()\")\n"
"    end\n"
"\n"
"    return lua_assert(condition, message)\n"
"end\n"
"\n"
"-- Works like pcall(), but invokes the debugger on an error.\n"
"function dbg.call(f, ...)\n"
"    return xpcall(f, function(err)\n"
"        dbg_write_error(pretty(err))\n"
"        dbg(false, 1, \"dbg.call()\")\n"
"\n"
"        return err\n"
"    end, ...)\n"
"end\n"
"\n"
"-- Start an interactive debugging console.\n"
"function dbg.start(path, ...)\n"
"    assert(path ~= nil and type(path) == 'string')\n"
"    assert(fio.stat(path) ~= nil)\n"
"\n"
"    stack_inspect_offset = 0\n"
"    stack_top = 0\n"
"    local hook_step = hook_factory(math.huge)\n"
"    debug.sethook(hook_step(path), \"l\")\n"
"    dofile(path, ...);\n"
"end\n"
"\n"
"-- Error message handler that can be used with lua_pcall().\n"
"function dbg.msgh(...)\n"
"    if debug.getinfo(2) then\n"
"        dbg_write_error(pretty(...))\n"
"        dbg(false, 1, \"dbg.msgh()\")\n"
"    else\n"
"        dbg_write_error(DEBUGGER .. \": \" ..\n"
"                    \"Error did not occur in Lua code. \" ..\n"
"                    \"Execution will continue after dbg_pcall().\")\n"
"    end\n"
"\n"
"    return ...\n"
"end\n"
"\n"
"local ffi = require(\"ffi\")\n"
"ffi.cdef [[ int isatty(int); ]]\n"
"\n"
"local stdout_isatty = ffi.C.isatty(1)\n"
"\n"
"-- Conditionally enable color support.\n"
"local color_maybe_supported = (stdout_isatty and os.getenv(\"TERM\") and os.getenv(\"TERM\") ~= \"dumb\")\n"
"if color_maybe_supported and not os.getenv(\"NO_COLOR\") then\n"
"    COLOR_GRAY = string.char(27) .. \"[90m\"\n"
"    COLOR_RED = string.char(27) .. \"[91m\"\n"
"    COLOR_GREEN = string.char(27) .. \"[92m\"\n"
"    COLOR_BLUE = string.char(27) .. \"[94m\"\n"
"    COLOR_YELLOW = string.char(27) .. \"[33m\"\n"
"    COLOR_RESET = string.char(27) .. \"[0m\"\n"
"\n"
"    CARET_SYM = COLOR_GREEN .. \"=>\" .. COLOR_RESET\n"
"    CARET = \" \" .. CARET_SYM .. \" \"\n"
"    BREAK_SYM = COLOR_RED .. \"●\" .. COLOR_RESET\n"
"end\n"
"\n"
"return dbg\n"
""
;
