/* SnapshotListBox.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SnapshotListBox.vala, do not modify */

/*
 * SnapshotListBox.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <cairo-gobject.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <gdk/gdk.h>

#define ICON_MANAGER_GENERIC_ICON_DIRECTORY "folder"
#define ICON_MANAGER_GENERIC_ICON_FILE "text-x-preview"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SNAPSHOT_LIST_BOX (snapshot_list_box_get_type ())
#define SNAPSHOT_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT_LIST_BOX, SnapshotListBox))
#define SNAPSHOT_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT_LIST_BOX, SnapshotListBoxClass))
#define IS_SNAPSHOT_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT_LIST_BOX))
#define IS_SNAPSHOT_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT_LIST_BOX))
#define SNAPSHOT_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT_LIST_BOX, SnapshotListBoxClass))

typedef struct _SnapshotListBox SnapshotListBox;
typedef struct _SnapshotListBoxClass SnapshotListBoxClass;
typedef struct _SnapshotListBoxPrivate SnapshotListBoxPrivate;
enum  {
	SNAPSHOT_LIST_BOX_0_PROPERTY,
	SNAPSHOT_LIST_BOX_NUM_PROPERTIES
};
static GParamSpec* snapshot_list_box_properties[SNAPSHOT_LIST_BOX_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

#define TYPE_SNAPSHOT (snapshot_get_type ())
#define SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT, Snapshot))
#define SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT, SnapshotClass))
#define IS_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT))
#define IS_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT))
#define SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT, SnapshotClass))

typedef struct _Snapshot Snapshot;
typedef struct _SnapshotClass SnapshotClass;
typedef struct _SnapshotPrivate SnapshotPrivate;

#define TYPE_SUBVOLUME (subvolume_get_type ())
#define SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUBVOLUME, Subvolume))
#define SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUBVOLUME, SubvolumeClass))
#define IS_SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUBVOLUME))
#define IS_SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUBVOLUME))
#define SUBVOLUME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUBVOLUME, SubvolumeClass))

typedef struct _Subvolume Subvolume;
typedef struct _SubvolumeClass SubvolumeClass;

#define TYPE_FS_TAB_ENTRY (fs_tab_entry_get_type ())
#define FS_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FS_TAB_ENTRY, FsTabEntry))
#define FS_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FS_TAB_ENTRY, FsTabEntryClass))
#define IS_FS_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FS_TAB_ENTRY))
#define IS_FS_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FS_TAB_ENTRY))
#define FS_TAB_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FS_TAB_ENTRY, FsTabEntryClass))

typedef struct _FsTabEntry FsTabEntry;
typedef struct _FsTabEntryClass FsTabEntryClass;

#define TYPE_CRYPT_TAB_ENTRY (crypt_tab_entry_get_type ())
#define CRYPT_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CRYPT_TAB_ENTRY, CryptTabEntry))
#define CRYPT_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CRYPT_TAB_ENTRY, CryptTabEntryClass))
#define IS_CRYPT_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CRYPT_TAB_ENTRY))
#define IS_CRYPT_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CRYPT_TAB_ENTRY))
#define CRYPT_TAB_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CRYPT_TAB_ENTRY, CryptTabEntryClass))

typedef struct _CryptTabEntry CryptTabEntry;
typedef struct _CryptTabEntryClass CryptTabEntryClass;

#define TYPE_LINUX_DISTRO (linux_distro_get_type ())
#define LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LINUX_DISTRO, LinuxDistro))
#define LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LINUX_DISTRO, LinuxDistroClass))
#define IS_LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LINUX_DISTRO))
#define IS_LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LINUX_DISTRO))
#define LINUX_DISTRO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LINUX_DISTRO, LinuxDistroClass))

typedef struct _LinuxDistro LinuxDistro;
typedef struct _LinuxDistroClass LinuxDistroClass;

#define TYPE_SNAPSHOT_REPO (snapshot_repo_get_type ())
#define SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepo))
#define SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))
#define IS_SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT_REPO))
#define IS_SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT_REPO))
#define SNAPSHOT_REPO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))

typedef struct _SnapshotRepo SnapshotRepo;
typedef struct _SnapshotRepoClass SnapshotRepoClass;

#define TYPE_ASYNC_TASK (async_task_get_type ())
#define ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASYNC_TASK, AsyncTask))
#define ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASYNC_TASK, AsyncTaskClass))
#define IS_ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASYNC_TASK))
#define IS_ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASYNC_TASK))
#define ASYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASYNC_TASK, AsyncTaskClass))

typedef struct _AsyncTask AsyncTask;
typedef struct _AsyncTaskClass AsyncTaskClass;

#define TYPE_DELETE_FILE_TASK (delete_file_task_get_type ())
#define DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTask))
#define DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))
#define IS_DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELETE_FILE_TASK))
#define IS_DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELETE_FILE_TASK))
#define DELETE_FILE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))

typedef struct _DeleteFileTask DeleteFileTask;
typedef struct _DeleteFileTaskClass DeleteFileTaskClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))

#define TYPE_MAIN (main_get_type ())
#define MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN, Main))
#define MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN, MainClass))
#define IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN))
#define IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN))
#define MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN, MainClass))

typedef struct _Main Main;
typedef struct _MainClass MainClass;
typedef struct _MainPrivate MainPrivate;

#define TYPE_DEVICE (device_get_type ())
#define DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEVICE, Device))
#define DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEVICE, DeviceClass))
#define IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEVICE))
#define IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEVICE))
#define DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEVICE, DeviceClass))

typedef struct _Device Device;
typedef struct _DeviceClass DeviceClass;

#define TYPE_APP_EXCLUDE_ENTRY (app_exclude_entry_get_type ())
#define APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntry))
#define APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))
#define IS_APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_EXCLUDE_ENTRY))
#define IS_APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_EXCLUDE_ENTRY))
#define APP_EXCLUDE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))

typedef struct _AppExcludeEntry AppExcludeEntry;
typedef struct _AppExcludeEntryClass AppExcludeEntryClass;

#define TYPE_MOUNT_ENTRY (mount_entry_get_type ())
#define MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_ENTRY, MountEntry))
#define MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_ENTRY, MountEntryClass))
#define IS_MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_ENTRY))
#define IS_MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_ENTRY))
#define MOUNT_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_ENTRY, MountEntryClass))

typedef struct _MountEntry MountEntry;
typedef struct _MountEntryClass MountEntryClass;

#define TYPE_APP_LOCK (app_lock_get_type ())
#define APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_LOCK, AppLock))
#define APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_LOCK, AppLockClass))
#define IS_APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_LOCK))
#define IS_APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_LOCK))
#define APP_LOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_LOCK, AppLockClass))

typedef struct _AppLock AppLock;
typedef struct _AppLockClass AppLockClass;

#define TYPE_RSYNC_TASK (rsync_task_get_type ())
#define RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_TASK, RsyncTask))
#define RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_TASK, RsyncTaskClass))
#define IS_RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_TASK))
#define IS_RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_TASK))
#define RSYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_TASK, RsyncTaskClass))

typedef struct _RsyncTask RsyncTask;
typedef struct _RsyncTaskClass RsyncTaskClass;

#define TYPE_RSYNC_SPACE_CHECK_TASK (rsync_space_check_task_get_type ())
#define RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTask))
#define RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))
#define IS_RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_SPACE_CHECK_TASK))
#define IS_RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_SPACE_CHECK_TASK))
#define RSYNC_SPACE_CHECK_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))

typedef struct _RsyncSpaceCheckTask RsyncSpaceCheckTask;
typedef struct _RsyncSpaceCheckTaskClass RsyncSpaceCheckTaskClass;

#define TYPE_SYSTEM_USER (system_user_get_type ())
#define SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYSTEM_USER, SystemUser))
#define SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYSTEM_USER, SystemUserClass))
#define IS_SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYSTEM_USER))
#define IS_SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYSTEM_USER))
#define SYSTEM_USER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYSTEM_USER, SystemUserClass))

typedef struct _SystemUser SystemUser;
typedef struct _SystemUserClass SystemUserClass;
typedef struct _SubvolumePrivate SubvolumePrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _SnapshotRepoPrivate SnapshotRepoPrivate;
typedef enum  {
	SNAPSHOT_LOCATION_STATUS_NOT_SELECTED = -2,
	SNAPSHOT_LOCATION_STATUS_NOT_AVAILABLE = -1,
	SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_HAS_SPACE = 0,
	SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_NO_SPACE = 1,
	SNAPSHOT_LOCATION_STATUS_NO_SNAPSHOTS_NO_SPACE = 2,
	SNAPSHOT_LOCATION_STATUS_NO_SNAPSHOTS_HAS_SPACE = 3,
	SNAPSHOT_LOCATION_STATUS_READ_ONLY_FS = 4,
	SNAPSHOT_LOCATION_STATUS_HARDLINKS_NOT_SUPPORTED = 5,
	SNAPSHOT_LOCATION_STATUS_NO_BTRFS_SYSTEM = 6
} SnapshotLocationStatus;

#define TYPE_SNAPSHOT_LOCATION_STATUS (snapshot_location_status_get_type ())
enum  {
	SNAPSHOT_LIST_BOX_DELETE_SELECTED_SIGNAL,
	SNAPSHOT_LIST_BOX_MARK_SELECTED_SIGNAL,
	SNAPSHOT_LIST_BOX_BROWSE_SELECTED_SIGNAL,
	SNAPSHOT_LIST_BOX_VIEW_SNAPSHOT_LOG_SIGNAL,
	SNAPSHOT_LIST_BOX_NUM_SIGNALS
};
static guint snapshot_list_box_signals[SNAPSHOT_LIST_BOX_NUM_SIGNALS] = {0};

struct _SnapshotListBox {
	GtkBox parent_instance;
	SnapshotListBoxPrivate * priv;
	GtkTreeView* treeview;
};

struct _SnapshotListBoxClass {
	GtkBoxClass parent_class;
};

struct _SnapshotListBoxPrivate {
	GtkTreeViewColumn* col_date;
	GtkTreeViewColumn* col_tags;
	GtkTreeViewColumn* col_size;
	GtkTreeViewColumn* col_unshared;
	GtkTreeViewColumn* col_system;
	GtkTreeViewColumn* col_desc;
	gint treeview_sort_column_index;
	gboolean treeview_sort_column_desc;
	GtkMenu* menu_snapshots;
	GtkImageMenuItem* mi_browse;
	GtkImageMenuItem* mi_remove;
	GtkImageMenuItem* mi_mark;
	GtkImageMenuItem* mi_view_log_create;
	GtkImageMenuItem* mi_view_log_restore;
	GtkWindow* parent_window;
};

struct _Snapshot {
	GObject parent_instance;
	SnapshotPrivate * priv;
	gchar* path;
	gchar* name;
	GDateTime* date;
	gchar* sys_uuid;
	gchar* sys_distro;
	gchar* app_version;
	gchar* description;
	gint64 file_count;
	GeeArrayList* tags;
	GeeArrayList* exclude_list;
	GeeHashMap* subvolumes;
	GeeArrayList* fstab_list;
	GeeArrayList* cryttab_list;
	gboolean valid;
	gboolean live;
	gboolean marked_for_deletion;
	LinuxDistro* distro;
	SnapshotRepo* repo;
	gboolean btrfs_mode;
	GeeHashMap* paths;
	gchar* mount_path_root;
	gchar* mount_path_home;
	DeleteFileTask* delete_file_task;
};

struct _SnapshotClass {
	GObjectClass parent_class;
};

struct _Main {
	GObject parent_instance;
	MainPrivate * priv;
	gchar* app_path;
	gchar* share_folder;
	gchar* rsnapshot_conf_path;
	gchar* app_conf_path;
	gchar* app_conf_path_old;
	gchar* app_conf_path_default;
	gboolean first_run;
	gchar* backup_uuid;
	gchar* backup_parent_uuid;
	gboolean btrfs_mode;
	gboolean include_btrfs_home_for_backup;
	gboolean include_btrfs_home_for_restore;
	gboolean stop_cron_emails;
	GeeArrayList* partitions;
	GeeArrayList* exclude_list_user;
	GeeArrayList* exclude_list_default;
	GeeArrayList* exclude_list_default_extra;
	GeeArrayList* exclude_list_home;
	GeeArrayList* exclude_list_restore;
	GeeArrayList* exclude_list_apps;
	GeeArrayList* mount_list;
	GeeArrayList* exclude_app_names;
	SnapshotRepo* repo;
	Device* sys_root;
	Device* sys_boot;
	Device* sys_efi;
	Device* sys_home;
	GeeHashMap* sys_subvolumes;
	gchar* mount_point_restore;
	gchar* mount_point_app;
	LinuxDistro* current_distro;
	gboolean mirror_system;
	gboolean schedule_monthly;
	gboolean schedule_weekly;
	gboolean schedule_daily;
	gboolean schedule_hourly;
	gboolean schedule_boot;
	gint count_monthly;
	gint count_weekly;
	gint count_daily;
	gint count_hourly;
	gint count_boot;
	gchar* app_mode;
	gboolean dry_run;
	gboolean thr_success;
	gboolean thread_estimate_running;
	gboolean thread_estimate_success;
	gboolean thread_restore_running;
	gboolean thread_restore_success;
	gboolean thread_delete_running;
	gboolean thread_delete_success;
	gboolean thread_subvol_info_running;
	gboolean thread_subvol_info_success;
	gint thr_retval;
	gchar* thr_arg1;
	gboolean thr_timeout_active;
	gchar* thr_timeout_cmd;
	gint startup_delay_interval_mins;
	gint retain_snapshots_max_days;
	gchar* log_dir;
	gchar* log_file;
	AppLock* app_lock;
	gchar* date_format;
	GeeArrayList* delete_list;
	Snapshot* snapshot_to_delete;
	Snapshot* snapshot_to_restore;
	gboolean reinstall_grub2;
	gboolean update_initramfs;
	gboolean update_grub;
	gchar* grub_device;
	gboolean use_option_raw;
	gboolean cmd_skip_grub;
	gchar* cmd_grub_device;
	gchar* cmd_target_device;
	gchar* cmd_backup_device;
	gchar* cmd_snapshot;
	gboolean cmd_confirm;
	gboolean cmd_verbose;
	gboolean cmd_scripted;
	gchar* cmd_comments;
	gchar* cmd_tags;
	gboolean* cmd_btrfs_mode;
	gchar* progress_text;
	GtkWindow* parent_window;
	RsyncTask* task;
	DeleteFileTask* delete_file_task;
	RsyncSpaceCheckTask* space_check_task;
	GeeHashMap* current_system_users;
	gchar* users_with_encrypted_home;
	gchar* encrypted_home_dirs;
	gboolean encrypted_home_warning_shown;
	gchar* encrypted_private_dirs;
	gboolean encrypted_private_warning_shown;
};

struct _MainClass {
	GObjectClass parent_class;
};

struct _Subvolume {
	GObject parent_instance;
	SubvolumePrivate * priv;
	gchar* device_uuid;
	gchar* name;
	gchar* path;
	glong id;
	gint64 total_bytes;
	gint64 unshared_bytes;
	gchar* mount_path;
	SnapshotRepo* repo;
};

struct _SubvolumeClass {
	GObjectClass parent_class;
};

struct _SnapshotRepo {
	GObject parent_instance;
	SnapshotRepoPrivate * priv;
	Device* device;
	Device* device_home;
	gchar* mount_path;
	GeeHashMap* mount_paths;
	gboolean btrfs_mode;
	GeeArrayList* snapshots;
	GeeArrayList* invalid_snapshots;
	gchar* status_message;
	gchar* status_details;
	SnapshotLocationStatus status_code;
	gboolean last_snapshot_failed_space;
};

struct _SnapshotRepoClass {
	GObjectClass parent_class;
};

static gint SnapshotListBox_private_offset;
static gpointer snapshot_list_box_parent_class = NULL;
VALA_EXTERN Main* App;

VALA_EXTERN GType snapshot_list_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SnapshotListBox, g_object_unref)
VALA_EXTERN SnapshotListBox* snapshot_list_box_new (GtkWindow* _parent_window);
VALA_EXTERN SnapshotListBox* snapshot_list_box_construct (GType object_type,
                                              GtkWindow* _parent_window);
VALA_EXTERN void tee_jee_logging_log_debug (const gchar* message);
static void snapshot_list_box_init_treeview (SnapshotListBox* self);
static void snapshot_list_box_init_list_view_context_menu (SnapshotListBox* self);
VALA_EXTERN cairo_surface_t* icon_manager_lookup_surface (const gchar* icon_name,
                                              gint icon_size,
                                              gint scale,
                                              gboolean symbolic,
                                              gboolean use_hardcoded);
static void snapshot_list_box_cell_date_render (SnapshotListBox* self,
                                         GtkCellLayout* cell_layout,
                                         GtkCellRenderer* cell,
                                         GtkTreeModel* model,
                                         GtkTreeIter* iter);
static void _snapshot_list_box_cell_date_render_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                    GtkCellRenderer* cell,
                                                                    GtkTreeModel* tree_model,
                                                                    GtkTreeIter* iter,
                                                                    gpointer self);
static void __lambda26_ (SnapshotListBox* self);
VALA_EXTERN void snapshot_list_box_refresh (SnapshotListBox* self);
static void ___lambda26__gtk_tree_view_column_clicked (GtkTreeViewColumn* _sender,
                                                gpointer self);
static void snapshot_list_box_cell_system_render (SnapshotListBox* self,
                                           GtkCellLayout* cell_layout,
                                           GtkCellRenderer* cell,
                                           GtkTreeModel* model,
                                           GtkTreeIter* iter);
static void _snapshot_list_box_cell_system_render_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                      GtkCellRenderer* cell,
                                                                      GtkTreeModel* tree_model,
                                                                      GtkTreeIter* iter,
                                                                      gpointer self);
static void __lambda31_ (SnapshotListBox* self);
static void ___lambda31__gtk_tree_view_column_clicked (GtkTreeViewColumn* _sender,
                                                gpointer self);
static void snapshot_list_box_cell_tags_render (SnapshotListBox* self,
                                         GtkCellLayout* cell_layout,
                                         GtkCellRenderer* cell,
                                         GtkTreeModel* model,
                                         GtkTreeIter* iter);
static void _snapshot_list_box_cell_tags_render_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                    GtkCellRenderer* cell,
                                                                    GtkTreeModel* tree_model,
                                                                    GtkTreeIter* iter,
                                                                    gpointer self);
static void __lambda32_ (SnapshotListBox* self);
static void ___lambda32__gtk_tree_view_column_clicked (GtkTreeViewColumn* _sender,
                                                gpointer self);
static void snapshot_list_box_cell_size_render (SnapshotListBox* self,
                                         GtkCellLayout* cell_layout,
                                         GtkCellRenderer* cell,
                                         GtkTreeModel* model,
                                         GtkTreeIter* iter);
static void _snapshot_list_box_cell_size_render_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                    GtkCellRenderer* cell,
                                                                    GtkTreeModel* tree_model,
                                                                    GtkTreeIter* iter,
                                                                    gpointer self);
static void __lambda33_ (SnapshotListBox* self);
static void ___lambda33__gtk_tree_view_column_clicked (GtkTreeViewColumn* _sender,
                                                gpointer self);
static void snapshot_list_box_cell_unshared_render (SnapshotListBox* self,
                                             GtkCellLayout* cell_layout,
                                             GtkCellRenderer* cell,
                                             GtkTreeModel* model,
                                             GtkTreeIter* iter);
static void _snapshot_list_box_cell_unshared_render_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                        GtkCellRenderer* cell,
                                                                        GtkTreeModel* tree_model,
                                                                        GtkTreeIter* iter,
                                                                        gpointer self);
static void __lambda34_ (SnapshotListBox* self);
static void ___lambda34__gtk_tree_view_column_clicked (GtkTreeViewColumn* _sender,
                                                gpointer self);
static void snapshot_list_box_cell_desc_render (SnapshotListBox* self,
                                         GtkCellLayout* cell_layout,
                                         GtkCellRenderer* cell,
                                         GtkTreeModel* model,
                                         GtkTreeIter* iter);
static void _snapshot_list_box_cell_desc_render_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                    GtkCellRenderer* cell,
                                                                    GtkTreeModel* tree_model,
                                                                    GtkTreeIter* iter,
                                                                    gpointer self);
static void __lambda35_ (SnapshotListBox* self,
                  const gchar* path,
                  const gchar* new_text);
VALA_EXTERN GType snapshot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Snapshot, g_object_unref)
VALA_EXTERN GType subvolume_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Subvolume, g_object_unref)
VALA_EXTERN GType fs_tab_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FsTabEntry, g_object_unref)
VALA_EXTERN GType crypt_tab_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CryptTabEntry, g_object_unref)
VALA_EXTERN GType linux_distro_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LinuxDistro, g_object_unref)
VALA_EXTERN GType snapshot_repo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SnapshotRepo, g_object_unref)
VALA_EXTERN GType async_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AsyncTask, g_object_unref)
VALA_EXTERN GType delete_file_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DeleteFileTask, g_object_unref)
VALA_EXTERN void snapshot_update_control_file (Snapshot* self);
static void ___lambda35__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender,
                                                 const gchar* path,
                                                 const gchar* new_text,
                                                 gpointer self);
static gboolean __lambda36_ (SnapshotListBox* self,
                      gint x,
                      gint y,
                      gboolean keyboard_tooltip,
                      GtkTooltip* tooltip);
static void _vala_GtkTreePath_free (GtkTreePath* self);
VALA_EXTERN GType main_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Main, g_object_unref)
VALA_EXTERN GType device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Device, g_object_unref)
VALA_EXTERN GType app_exclude_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppExcludeEntry, g_object_unref)
VALA_EXTERN GType mount_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MountEntry, g_object_unref)
VALA_EXTERN GType app_lock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppLock, g_object_unref)
VALA_EXTERN GType rsync_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncTask, g_object_unref)
VALA_EXTERN GType rsync_space_check_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncSpaceCheckTask, g_object_unref)
VALA_EXTERN GType system_user_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SystemUser, g_object_unref)
VALA_EXTERN GeeArrayList* snapshot_get_subvolumes_sorted (Snapshot* self);
static gboolean ___lambda36__gtk_widget_query_tooltip (GtkWidget* _sender,
                                                gint x,
                                                gint y,
                                                gboolean keyboard_tooltip,
                                                GtkTooltip* tooltip,
                                                gpointer self);
VALA_EXTERN GtkImage* icon_manager_lookup_image (const gchar* icon_name,
                                     gint icon_size,
                                     gboolean symbolic,
                                     gboolean use_hardcoded);
static void __lambda37_ (SnapshotListBox* self);
static void ___lambda37__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void __lambda38_ (SnapshotListBox* self);
static void ___lambda38__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void __lambda39_ (SnapshotListBox* self);
static void ___lambda39__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void __lambda40_ (SnapshotListBox* self);
static void ___lambda40__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void __lambda41_ (SnapshotListBox* self);
static void ___lambda41__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static gboolean snapshot_list_box_treeview_popup_menu (SnapshotListBox* self);
static gboolean _snapshot_list_box_treeview_popup_menu_gtk_widget_popup_menu (GtkWidget* _sender,
                                                                       gpointer self);
static gboolean snapshot_list_box_treeview_button_press_event (SnapshotListBox* self,
                                                        GdkEventButton* event);
static gboolean _snapshot_list_box_treeview_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                                       GdkEventButton* event,
                                                                                       gpointer self);
static gboolean snapshot_list_box_menu_snapshots_popup (SnapshotListBox* self,
                                                 GtkMenu* popup,
                                                 GdkEventButton* event);
VALA_EXTERN gchar* snapshot_get_date_formatted (Snapshot* self);
VALA_EXTERN gchar* snapshot_get_taglist_short (Snapshot* self);
VALA_EXTERN gchar* tee_jee_file_system_format_file_size (guint64 size,
                                             gboolean binary_units,
                                             const gchar* unit,
                                             gboolean show_units,
                                             gint decimals);
VALA_EXTERN GeeArrayList* snapshot_list_box_selected_snapshots (SnapshotListBox* self);
VALA_EXTERN gboolean tee_jee_file_system_file_exists (const gchar* file_path);
VALA_EXTERN gchar* snapshot_get_rsync_restore_log_file (Snapshot* self);
VALA_EXTERN gchar* snapshot_get_rsync_restore_changes_log_file (Snapshot* self);
VALA_EXTERN gboolean snapshot_repo_available (SnapshotRepo* self);
VALA_EXTERN gboolean snapshot_repo_load_snapshots (SnapshotRepo* self);
VALA_EXTERN GType snapshot_location_status_get_type (void) G_GNUC_CONST ;
static gint ____lambda27_ (SnapshotListBox* self,
                    Snapshot* a,
                    Snapshot* b);
static gint _____lambda27__gcompare_data_func (gconstpointer a,
                                        gconstpointer b,
                                        gpointer self);
static gint ____lambda28_ (SnapshotListBox* self,
                    Snapshot* a,
                    Snapshot* b);
static gint _____lambda28__gcompare_data_func (gconstpointer a,
                                        gconstpointer b,
                                        gpointer self);
static gint ____lambda29_ (SnapshotListBox* self,
                    Snapshot* a,
                    Snapshot* b);
VALA_EXTERN gchar* snapshot_get_taglist (Snapshot* self);
static gint _____lambda29__gcompare_data_func (gconstpointer a,
                                        gconstpointer b,
                                        gpointer self);
static gint ____lambda30_ (SnapshotListBox* self,
                    Snapshot* a,
                    Snapshot* b);
static gint _____lambda30__gcompare_data_func (gconstpointer a,
                                        gconstpointer b,
                                        gpointer self);
VALA_EXTERN gboolean main_get_btrfs_qgroups_enabled (Main* self);
VALA_EXTERN void snapshot_list_box_hide_context_menu (SnapshotListBox* self);
static void snapshot_list_box_finalize (GObject * obj);
static GType snapshot_list_box_get_type_once (void);

static inline gpointer
snapshot_list_box_get_instance_private (SnapshotListBox* self)
{
	return G_STRUCT_MEMBER_P (self, SnapshotListBox_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

SnapshotListBox*
snapshot_list_box_construct (GType object_type,
                             GtkWindow* _parent_window)
{
	SnapshotListBox * self = NULL;
	GtkWindow* _tmp0_;
	g_return_val_if_fail (_parent_window != NULL, NULL);
	tee_jee_logging_log_debug ("SnapshotListBox: SnapshotListBox()");
	self = (SnapshotListBox*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, "spacing", 6, NULL);
	_tmp0_ = _g_object_ref0 (_parent_window);
	_g_object_unref0 (self->priv->parent_window);
	self->priv->parent_window = _tmp0_;
	g_object_set ((GtkWidget*) self, "margin", 6, NULL);
	snapshot_list_box_init_treeview (self);
	snapshot_list_box_init_list_view_context_menu (self);
	tee_jee_logging_log_debug ("SnapshotListBox: SnapshotListBox(): exit");
	return self;
}

SnapshotListBox*
snapshot_list_box_new (GtkWindow* _parent_window)
{
	return snapshot_list_box_construct (TYPE_SNAPSHOT_LIST_BOX, _parent_window);
}

static void
_snapshot_list_box_cell_date_render_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                               GtkCellRenderer* cell,
                                                               GtkTreeModel* tree_model,
                                                               GtkTreeIter* iter,
                                                               gpointer self)
{
	snapshot_list_box_cell_date_render ((SnapshotListBox*) self, cell_layout, cell, tree_model, iter);
}

static void
__lambda26_ (SnapshotListBox* self)
{
	if (self->priv->treeview_sort_column_index == 0) {
		self->priv->treeview_sort_column_desc = !self->priv->treeview_sort_column_desc;
	} else {
		self->priv->treeview_sort_column_index = 0;
		self->priv->treeview_sort_column_desc = TRUE;
	}
	snapshot_list_box_refresh (self);
}

static void
___lambda26__gtk_tree_view_column_clicked (GtkTreeViewColumn* _sender,
                                           gpointer self)
{
	__lambda26_ ((SnapshotListBox*) self);
}

static void
_snapshot_list_box_cell_system_render_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                 GtkCellRenderer* cell,
                                                                 GtkTreeModel* tree_model,
                                                                 GtkTreeIter* iter,
                                                                 gpointer self)
{
	snapshot_list_box_cell_system_render ((SnapshotListBox*) self, cell_layout, cell, tree_model, iter);
}

static void
__lambda31_ (SnapshotListBox* self)
{
	if (self->priv->treeview_sort_column_index == 1) {
		self->priv->treeview_sort_column_desc = !self->priv->treeview_sort_column_desc;
	} else {
		self->priv->treeview_sort_column_index = 1;
		self->priv->treeview_sort_column_desc = FALSE;
	}
	snapshot_list_box_refresh (self);
}

static void
___lambda31__gtk_tree_view_column_clicked (GtkTreeViewColumn* _sender,
                                           gpointer self)
{
	__lambda31_ ((SnapshotListBox*) self);
}

static void
_snapshot_list_box_cell_tags_render_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                               GtkCellRenderer* cell,
                                                               GtkTreeModel* tree_model,
                                                               GtkTreeIter* iter,
                                                               gpointer self)
{
	snapshot_list_box_cell_tags_render ((SnapshotListBox*) self, cell_layout, cell, tree_model, iter);
}

static void
__lambda32_ (SnapshotListBox* self)
{
	if (self->priv->treeview_sort_column_index == 2) {
		self->priv->treeview_sort_column_desc = !self->priv->treeview_sort_column_desc;
	} else {
		self->priv->treeview_sort_column_index = 2;
		self->priv->treeview_sort_column_desc = FALSE;
	}
	snapshot_list_box_refresh (self);
}

static void
___lambda32__gtk_tree_view_column_clicked (GtkTreeViewColumn* _sender,
                                           gpointer self)
{
	__lambda32_ ((SnapshotListBox*) self);
}

static void
_snapshot_list_box_cell_size_render_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                               GtkCellRenderer* cell,
                                                               GtkTreeModel* tree_model,
                                                               GtkTreeIter* iter,
                                                               gpointer self)
{
	snapshot_list_box_cell_size_render ((SnapshotListBox*) self, cell_layout, cell, tree_model, iter);
}

static void
__lambda33_ (SnapshotListBox* self)
{
	if (self->priv->treeview_sort_column_index == 2) {
		self->priv->treeview_sort_column_desc = !self->priv->treeview_sort_column_desc;
	} else {
		self->priv->treeview_sort_column_index = 2;
		self->priv->treeview_sort_column_desc = FALSE;
	}
	snapshot_list_box_refresh (self);
}

static void
___lambda33__gtk_tree_view_column_clicked (GtkTreeViewColumn* _sender,
                                           gpointer self)
{
	__lambda33_ ((SnapshotListBox*) self);
}

static void
_snapshot_list_box_cell_unshared_render_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                   GtkCellRenderer* cell,
                                                                   GtkTreeModel* tree_model,
                                                                   GtkTreeIter* iter,
                                                                   gpointer self)
{
	snapshot_list_box_cell_unshared_render ((SnapshotListBox*) self, cell_layout, cell, tree_model, iter);
}

static void
__lambda34_ (SnapshotListBox* self)
{
	if (self->priv->treeview_sort_column_index == 2) {
		self->priv->treeview_sort_column_desc = !self->priv->treeview_sort_column_desc;
	} else {
		self->priv->treeview_sort_column_index = 2;
		self->priv->treeview_sort_column_desc = FALSE;
	}
	snapshot_list_box_refresh (self);
}

static void
___lambda34__gtk_tree_view_column_clicked (GtkTreeViewColumn* _sender,
                                           gpointer self)
{
	__lambda34_ ((SnapshotListBox*) self);
}

static void
_snapshot_list_box_cell_desc_render_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                               GtkCellRenderer* cell,
                                                               GtkTreeModel* tree_model,
                                                               GtkTreeIter* iter,
                                                               gpointer self)
{
	snapshot_list_box_cell_desc_render ((SnapshotListBox*) self, cell_layout, cell, tree_model, iter);
}

static void
__lambda35_ (SnapshotListBox* self,
             const gchar* path,
             const gchar* new_text)
{
	Snapshot* bak = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* model = NULL;
	GtkTreeView* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkListStore* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	GtkTreeIter _tmp5_;
	Snapshot* _tmp6_ = NULL;
	gchar* _tmp7_;
	g_return_if_fail (path != NULL);
	g_return_if_fail (new_text != NULL);
	_tmp0_ = self->treeview;
	_tmp1_ = gtk_tree_view_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_list_store_get_type (), GtkListStore));
	model = _tmp3_;
	gtk_tree_model_get_iter_from_string ((GtkTreeModel*) model, &_tmp4_, path);
	iter = _tmp4_;
	_tmp5_ = iter;
	gtk_tree_model_get ((GtkTreeModel*) model, &_tmp5_, 0, &_tmp6_, -1, -1);
	_g_object_unref0 (bak);
	bak = _tmp6_;
	_tmp7_ = g_strdup (new_text);
	_g_free0 (bak->description);
	bak->description = _tmp7_;
	snapshot_update_control_file (bak);
	_g_object_unref0 (model);
	_g_object_unref0 (bak);
}

static void
___lambda35__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender,
                                            const gchar* path,
                                            const gchar* new_text,
                                            gpointer self)
{
	__lambda35_ ((SnapshotListBox*) self, path, new_text);
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

static gboolean
__lambda36_ (SnapshotListBox* self,
             gint x,
             gint y,
             gboolean keyboard_tooltip,
             GtkTooltip* tooltip)
{
	GtkTreeModel* model = NULL;
	GtkTreePath* path = NULL;
	GtkTreeIter iter = {0};
	GtkTreeViewColumn* column = NULL;
	GtkTreeView* _tmp0_;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreePath* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_;
	GtkTreeModel* _tmp5_;
	gboolean result;
	g_return_val_if_fail (tooltip != NULL, FALSE);
	_tmp0_ = self->treeview;
	_tmp4_ = gtk_tree_view_get_tooltip_context (_tmp0_, &x, &y, keyboard_tooltip, &_tmp1_, &_tmp2_, &_tmp3_);
	_g_object_unref0 (model);
	_tmp5_ = _g_object_ref0 (_tmp1_);
	model = _tmp5_;
	__vala_GtkTreePath_free0 (path);
	path = _tmp2_;
	iter = _tmp3_;
	if (_tmp4_) {
		gint bx = 0;
		gint by = 0;
		GtkTreeView* _tmp6_;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		GtkTreeView* _tmp9_;
		GtkTreeViewColumn* _tmp10_ = NULL;
		gboolean _tmp11_;
		GtkTreeViewColumn* _tmp12_;
		_tmp6_ = self->treeview;
		gtk_tree_view_convert_widget_to_bin_window_coords (_tmp6_, x, y, &_tmp7_, &_tmp8_);
		bx = _tmp7_;
		by = _tmp8_;
		_tmp9_ = self->treeview;
		_tmp11_ = gtk_tree_view_get_path_at_pos (_tmp9_, bx, by, NULL, &_tmp10_, NULL, NULL);
		_g_object_unref0 (column);
		_tmp12_ = _g_object_ref0 (_tmp10_);
		column = _tmp12_;
		if (_tmp11_) {
			gboolean _tmp13_ = FALSE;
			GtkTreeViewColumn* _tmp14_;
			GtkTreeViewColumn* _tmp15_;
			_tmp14_ = column;
			_tmp15_ = self->priv->col_date;
			if (_tmp14_ == _tmp15_) {
				_tmp13_ = TRUE;
			} else {
				GtkTreeViewColumn* _tmp16_;
				GtkTreeViewColumn* _tmp17_;
				_tmp16_ = column;
				_tmp17_ = self->priv->col_system;
				_tmp13_ = _tmp16_ == _tmp17_;
			}
			if (_tmp13_) {
				Snapshot* bak = NULL;
				GtkTreeModel* _tmp18_;
				GtkTreeIter _tmp19_;
				Snapshot* _tmp20_ = NULL;
				gchar* txt = NULL;
				gchar* _tmp21_;
				Main* _tmp22_;
				const gchar* _tmp58_;
				_tmp18_ = model;
				_tmp19_ = iter;
				gtk_tree_model_get (_tmp18_, &_tmp19_, 0, &_tmp20_, -1, -1);
				_g_object_unref0 (bak);
				bak = _tmp20_;
				_tmp21_ = g_strdup ("");
				txt = _tmp21_;
				_tmp22_ = App;
				if (_tmp22_->btrfs_mode) {
					const gchar* _tmp23_;
					Snapshot* _tmp24_;
					GeeHashMap* _tmp25_;
					GeeCollection* _tmp26_;
					GeeCollection* _tmp27_;
					GeeCollection* _tmp28_;
					gint _tmp29_;
					gint _tmp30_;
					gchar* _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					_tmp23_ = txt;
					_tmp24_ = bak;
					_tmp25_ = _tmp24_->subvolumes;
					_tmp26_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp25_);
					_tmp27_ = _tmp26_;
					_tmp28_ = _tmp27_;
					_tmp29_ = gee_collection_get_size (_tmp28_);
					_tmp30_ = _tmp29_;
					_tmp31_ = g_strdup_printf ("<b>%s: %d</b>\n", _ ("Subvolumes"), _tmp30_);
					_tmp32_ = _tmp31_;
					_tmp33_ = g_strconcat (_tmp23_, _tmp32_, NULL);
					_g_free0 (txt);
					txt = _tmp33_;
					_g_free0 (_tmp32_);
					_g_object_unref0 (_tmp28_);
					{
						GeeArrayList* _subvol_list = NULL;
						Snapshot* _tmp34_;
						GeeArrayList* _tmp35_;
						GeeArrayList* _tmp36_;
						gint _subvol_size = 0;
						GeeArrayList* _tmp37_;
						gint _tmp38_;
						gint _tmp39_;
						gint _subvol_index = 0;
						_tmp34_ = bak;
						_tmp35_ = snapshot_get_subvolumes_sorted (_tmp34_);
						_tmp36_ = _tmp35_;
						_subvol_list = _tmp36_;
						_tmp37_ = _subvol_list;
						_tmp38_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp37_);
						_tmp39_ = _tmp38_;
						_subvol_size = _tmp39_;
						_subvol_index = -1;
						while (TRUE) {
							gint _tmp40_;
							gint _tmp41_;
							Subvolume* subvol = NULL;
							GeeArrayList* _tmp42_;
							gpointer _tmp43_;
							const gchar* _tmp44_;
							gint _tmp45_;
							gint _tmp46_;
							const gchar* _tmp49_;
							Subvolume* _tmp50_;
							const gchar* _tmp51_;
							gchar* _tmp52_;
							gchar* _tmp53_;
							gchar* _tmp54_;
							_subvol_index = _subvol_index + 1;
							_tmp40_ = _subvol_index;
							_tmp41_ = _subvol_size;
							if (!(_tmp40_ < _tmp41_)) {
								break;
							}
							_tmp42_ = _subvol_list;
							_tmp43_ = gee_abstract_list_get ((GeeAbstractList*) _tmp42_, _subvol_index);
							subvol = (Subvolume*) _tmp43_;
							_tmp44_ = txt;
							_tmp45_ = strlen (_tmp44_);
							_tmp46_ = _tmp45_;
							if (_tmp46_ > 0) {
								const gchar* _tmp47_;
								gchar* _tmp48_;
								_tmp47_ = txt;
								_tmp48_ = g_strconcat (_tmp47_, "\n", NULL);
								_g_free0 (txt);
								txt = _tmp48_;
							}
							_tmp49_ = txt;
							_tmp50_ = subvol;
							_tmp51_ = _tmp50_->path;
							_tmp52_ = g_strdup_printf ("%s", _tmp51_);
							_tmp53_ = _tmp52_;
							_tmp54_ = g_strconcat (_tmp49_, _tmp53_, NULL);
							_g_free0 (txt);
							txt = _tmp54_;
							_g_free0 (_tmp53_);
							_g_object_unref0 (subvol);
						}
						_g_object_unref0 (_subvol_list);
					}
				} else {
					Snapshot* _tmp55_;
					const gchar* _tmp56_;
					gchar* _tmp57_;
					_tmp55_ = bak;
					_tmp56_ = _tmp55_->path;
					_tmp57_ = g_strdup (_tmp56_);
					_g_free0 (txt);
					txt = _tmp57_;
				}
				_tmp58_ = txt;
				gtk_tooltip_set_markup (tooltip, _tmp58_);
				result = TRUE;
				_g_free0 (txt);
				_g_object_unref0 (bak);
				_g_object_unref0 (column);
				__vala_GtkTreePath_free0 (path);
				_g_object_unref0 (model);
				return result;
			} else {
				GtkTreeViewColumn* _tmp59_;
				GtkTreeViewColumn* _tmp60_;
				_tmp59_ = column;
				_tmp60_ = self->priv->col_desc;
				if (_tmp59_ == _tmp60_) {
					gtk_tooltip_set_markup (tooltip, _ ("<b>Comments</b> (double-click to edit)"));
					result = TRUE;
					_g_object_unref0 (column);
					__vala_GtkTreePath_free0 (path);
					_g_object_unref0 (model);
					return result;
				} else {
					GtkTreeViewColumn* _tmp61_;
					GtkTreeViewColumn* _tmp62_;
					_tmp61_ = column;
					_tmp62_ = self->priv->col_tags;
					if (_tmp61_ == _tmp62_) {
						gchar* _tmp63_;
						gchar* _tmp64_;
						_tmp63_ = g_strdup_printf ("<b>%s</b>\n\nO \t%s\nB \t%s\nH \t%s\nD \t%s\nW \t%s\nM \t%s", _ ("Snapshot Levels"), _ ("On demand (manual)"), _ ("Boot"), _ ("Hourly"), _ ("Daily"), _ ("Weekly"), _ ("Monthly"));
						_tmp64_ = _tmp63_;
						gtk_tooltip_set_markup (tooltip, _tmp64_);
						_g_free0 (_tmp64_);
						result = TRUE;
						_g_object_unref0 (column);
						__vala_GtkTreePath_free0 (path);
						_g_object_unref0 (model);
						return result;
					}
				}
			}
		}
	}
	result = FALSE;
	_g_object_unref0 (column);
	__vala_GtkTreePath_free0 (path);
	_g_object_unref0 (model);
	return result;
}

static gboolean
___lambda36__gtk_widget_query_tooltip (GtkWidget* _sender,
                                       gint x,
                                       gint y,
                                       gboolean keyboard_tooltip,
                                       GtkTooltip* tooltip,
                                       gpointer self)
{
	gboolean result;
	result = __lambda36_ ((SnapshotListBox*) self, x, y, keyboard_tooltip, tooltip);
	return result;
}

static void
snapshot_list_box_init_treeview (SnapshotListBox* self)
{
	GtkTreeView* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GtkTreeView* _tmp3_;
	GtkTreeView* _tmp4_;
	GtkScrolledWindow* sw_backups = NULL;
	GtkScrolledWindow* _tmp5_;
	GtkTreeView* _tmp6_;
	GtkTreeViewColumn* _tmp7_;
	GtkTreeViewColumn* _tmp8_;
	GtkTreeViewColumn* _tmp9_;
	GtkTreeViewColumn* _tmp10_;
	GtkTreeViewColumn* _tmp11_;
	GtkTreeViewColumn* _tmp12_;
	GtkCellRendererPixbuf* cell_backup_icon = NULL;
	GtkCellRendererPixbuf* _tmp13_;
	GtkTreeView* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	cairo_surface_t* _tmp17_;
	cairo_surface_t* _tmp18_;
	GtkTreeViewColumn* _tmp19_;
	GtkCellRendererText* cell_date = NULL;
	GtkCellRendererText* _tmp20_;
	GtkTreeViewColumn* _tmp21_;
	GtkTreeViewColumn* _tmp22_;
	GtkTreeView* _tmp23_;
	GtkTreeViewColumn* _tmp24_;
	GtkTreeViewColumn* _tmp25_;
	GtkTreeViewColumn* _tmp26_;
	GtkTreeViewColumn* _tmp27_;
	GtkTreeViewColumn* _tmp28_;
	GtkTreeViewColumn* _tmp29_;
	GtkTreeViewColumn* _tmp30_;
	GtkCellRendererText* cell_system = NULL;
	GtkCellRendererText* _tmp31_;
	GtkTreeViewColumn* _tmp32_;
	GtkTreeViewColumn* _tmp33_;
	GtkTreeView* _tmp34_;
	GtkTreeViewColumn* _tmp35_;
	GtkTreeViewColumn* _tmp36_;
	GtkTreeViewColumn* _tmp37_;
	GtkTreeViewColumn* _tmp38_;
	GtkTreeViewColumn* _tmp39_;
	GtkTreeViewColumn* _tmp40_;
	GtkCellRendererText* cell_tags = NULL;
	GtkCellRendererText* _tmp41_;
	GtkTreeViewColumn* _tmp42_;
	GtkTreeViewColumn* _tmp43_;
	GtkTreeView* _tmp44_;
	GtkTreeViewColumn* _tmp45_;
	GtkTreeViewColumn* _tmp46_;
	GtkTreeViewColumn* col = NULL;
	GtkTreeViewColumn* _tmp47_;
	GtkTreeViewColumn* _tmp48_;
	GtkTreeViewColumn* _tmp49_;
	GtkTreeViewColumn* _tmp50_;
	GtkTreeViewColumn* _tmp51_;
	GtkCellRendererText* cell_size = NULL;
	GtkCellRendererText* _tmp52_;
	GtkTreeViewColumn* _tmp53_;
	GtkTreeViewColumn* _tmp54_;
	GtkTreeViewColumn* _tmp55_;
	GtkTreeViewColumn* _tmp56_;
	GtkTreeView* _tmp57_;
	GtkTreeViewColumn* _tmp58_;
	GtkTreeViewColumn* _tmp59_;
	GtkTreeViewColumn* _tmp60_;
	GtkTreeViewColumn* _tmp61_;
	GtkTreeViewColumn* _tmp62_;
	GtkTreeViewColumn* _tmp63_;
	GtkTreeViewColumn* _tmp64_;
	GtkCellRendererText* cell_unshared = NULL;
	GtkCellRendererText* _tmp65_;
	GtkTreeViewColumn* _tmp66_;
	GtkTreeViewColumn* _tmp67_;
	GtkTreeViewColumn* _tmp68_;
	GtkTreeViewColumn* _tmp69_;
	GtkTreeView* _tmp70_;
	GtkTreeViewColumn* _tmp71_;
	GtkTreeViewColumn* _tmp72_;
	GtkTreeViewColumn* _tmp73_;
	GtkTreeViewColumn* _tmp74_;
	GtkTreeViewColumn* _tmp75_;
	GtkTreeViewColumn* _tmp76_;
	GtkTreeViewColumn* _tmp77_;
	GtkCellRendererText* cell_desc = NULL;
	GtkCellRendererText* _tmp78_;
	GtkTreeViewColumn* _tmp79_;
	GtkTreeViewColumn* _tmp80_;
	GtkTreeView* _tmp81_;
	GtkTreeViewColumn* _tmp82_;
	GtkTreeViewColumn* col_buffer = NULL;
	GtkTreeViewColumn* _tmp83_;
	GtkCellRendererText* cell_text = NULL;
	GtkCellRendererText* _tmp84_;
	GtkTreeView* _tmp85_;
	GtkTreeView* _tmp86_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkTreeView*) gtk_tree_view_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->treeview);
	self->treeview = _tmp0_;
	_tmp1_ = self->treeview;
	_tmp2_ = gtk_tree_view_get_selection (_tmp1_);
	gtk_tree_selection_set_mode (_tmp2_, GTK_SELECTION_MULTIPLE);
	_tmp3_ = self->treeview;
	gtk_tree_view_set_headers_clickable (_tmp3_, TRUE);
	_tmp4_ = self->treeview;
	gtk_widget_set_has_tooltip ((GtkWidget*) _tmp4_, TRUE);
	_tmp5_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp5_);
	sw_backups = _tmp5_;
	gtk_scrolled_window_set_shadow_type (sw_backups, GTK_SHADOW_ETCHED_IN);
	_tmp6_ = self->treeview;
	gtk_container_add ((GtkContainer*) sw_backups, (GtkWidget*) _tmp6_);
	g_object_set ((GtkWidget*) sw_backups, "expand", TRUE, NULL);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) sw_backups);
	_tmp7_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->col_date);
	self->priv->col_date = _tmp7_;
	_tmp8_ = self->priv->col_date;
	gtk_tree_view_column_set_title (_tmp8_, _ ("Snapshot"));
	_tmp9_ = self->priv->col_date;
	gtk_tree_view_column_set_clickable (_tmp9_, TRUE);
	_tmp10_ = self->priv->col_date;
	gtk_tree_view_column_set_resizable (_tmp10_, TRUE);
	_tmp11_ = self->priv->col_date;
	gtk_tree_view_column_set_spacing (_tmp11_, 1);
	_tmp12_ = self->priv->col_date;
	gtk_tree_view_column_set_min_width (_tmp12_, 200);
	_tmp13_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp13_);
	cell_backup_icon = _tmp13_;
	_tmp14_ = self->treeview;
	_tmp15_ = gtk_widget_get_scale_factor ((GtkWidget*) _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = icon_manager_lookup_surface ("clock", 16, _tmp16_, FALSE, FALSE);
	_tmp18_ = _tmp17_;
	g_object_set (cell_backup_icon, "surface", _tmp18_, NULL);
	_cairo_surface_destroy0 (_tmp18_);
	g_object_set ((GtkCellRenderer*) cell_backup_icon, "xpad", (guint) 4, NULL);
	g_object_set ((GtkCellRenderer*) cell_backup_icon, "ypad", (guint) 6, NULL);
	_tmp19_ = self->priv->col_date;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp19_, (GtkCellRenderer*) cell_backup_icon, FALSE);
	_tmp20_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp20_);
	cell_date = _tmp20_;
	_tmp21_ = self->priv->col_date;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp21_, (GtkCellRenderer*) cell_date, FALSE);
	_tmp22_ = self->priv->col_date;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp22_, (GtkCellRenderer*) cell_date, _snapshot_list_box_cell_date_render_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp23_ = self->treeview;
	_tmp24_ = self->priv->col_date;
	gtk_tree_view_append_column (_tmp23_, _tmp24_);
	_tmp25_ = self->priv->col_date;
	g_signal_connect_object (_tmp25_, "clicked", (GCallback) ___lambda26__gtk_tree_view_column_clicked, self, 0);
	_tmp26_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp26_);
	_g_object_unref0 (self->priv->col_system);
	self->priv->col_system = _tmp26_;
	_tmp27_ = self->priv->col_system;
	gtk_tree_view_column_set_title (_tmp27_, _ ("System"));
	_tmp28_ = self->priv->col_system;
	gtk_tree_view_column_set_resizable (_tmp28_, TRUE);
	_tmp29_ = self->priv->col_system;
	gtk_tree_view_column_set_clickable (_tmp29_, TRUE);
	_tmp30_ = self->priv->col_system;
	gtk_tree_view_column_set_min_width (_tmp30_, 200);
	_tmp31_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp31_);
	cell_system = _tmp31_;
	g_object_set (cell_system, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
	_tmp32_ = self->priv->col_system;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp32_, (GtkCellRenderer*) cell_system, FALSE);
	_tmp33_ = self->priv->col_system;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp33_, (GtkCellRenderer*) cell_system, _snapshot_list_box_cell_system_render_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp34_ = self->treeview;
	_tmp35_ = self->priv->col_system;
	gtk_tree_view_append_column (_tmp34_, _tmp35_);
	_tmp36_ = self->priv->col_system;
	g_signal_connect_object (_tmp36_, "clicked", (GCallback) ___lambda31__gtk_tree_view_column_clicked, self, 0);
	_tmp37_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp37_);
	_g_object_unref0 (self->priv->col_tags);
	self->priv->col_tags = _tmp37_;
	_tmp38_ = self->priv->col_tags;
	gtk_tree_view_column_set_title (_tmp38_, _ ("Tags"));
	_tmp39_ = self->priv->col_tags;
	gtk_tree_view_column_set_resizable (_tmp39_, TRUE);
	_tmp40_ = self->priv->col_tags;
	gtk_tree_view_column_set_clickable (_tmp40_, TRUE);
	_tmp41_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp41_);
	cell_tags = _tmp41_;
	g_object_set (cell_tags, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
	_tmp42_ = self->priv->col_tags;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp42_, (GtkCellRenderer*) cell_tags, FALSE);
	_tmp43_ = self->priv->col_tags;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp43_, (GtkCellRenderer*) cell_tags, _snapshot_list_box_cell_tags_render_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp44_ = self->treeview;
	_tmp45_ = self->priv->col_tags;
	gtk_tree_view_append_column (_tmp44_, _tmp45_);
	_tmp46_ = self->priv->col_tags;
	g_signal_connect_object (_tmp46_, "clicked", (GCallback) ___lambda32__gtk_tree_view_column_clicked, self, 0);
	_tmp47_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp47_);
	col = _tmp47_;
	_tmp48_ = col;
	gtk_tree_view_column_set_title (_tmp48_, _ ("Size"));
	_tmp49_ = col;
	gtk_tree_view_column_set_resizable (_tmp49_, TRUE);
	_tmp50_ = col;
	gtk_tree_view_column_set_min_width (_tmp50_, 80);
	_tmp51_ = col;
	gtk_tree_view_column_set_clickable (_tmp51_, TRUE);
	_tmp52_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp52_);
	cell_size = _tmp52_;
	g_object_set (cell_size, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
	g_object_set ((GtkCellRenderer*) cell_size, "xalign", (gfloat) 1.0, NULL);
	_tmp53_ = col;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp53_, (GtkCellRenderer*) cell_size, FALSE);
	_tmp54_ = col;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp54_, (GtkCellRenderer*) cell_size, _snapshot_list_box_cell_size_render_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp55_ = col;
	_tmp56_ = _g_object_ref0 (_tmp55_);
	_g_object_unref0 (self->priv->col_size);
	self->priv->col_size = _tmp56_;
	_tmp57_ = self->treeview;
	_tmp58_ = self->priv->col_size;
	gtk_tree_view_append_column (_tmp57_, _tmp58_);
	_tmp59_ = self->priv->col_size;
	g_signal_connect_object (_tmp59_, "clicked", (GCallback) ___lambda33__gtk_tree_view_column_clicked, self, 0);
	_tmp60_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp60_);
	_g_object_unref0 (col);
	col = _tmp60_;
	_tmp61_ = col;
	gtk_tree_view_column_set_title (_tmp61_, _ ("Unshared"));
	_tmp62_ = col;
	gtk_tree_view_column_set_resizable (_tmp62_, TRUE);
	_tmp63_ = col;
	gtk_tree_view_column_set_min_width (_tmp63_, 80);
	_tmp64_ = col;
	gtk_tree_view_column_set_clickable (_tmp64_, TRUE);
	_tmp65_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp65_);
	cell_unshared = _tmp65_;
	g_object_set (cell_unshared, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
	g_object_set ((GtkCellRenderer*) cell_unshared, "xalign", (gfloat) 1.0, NULL);
	_tmp66_ = col;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp66_, (GtkCellRenderer*) cell_unshared, FALSE);
	_tmp67_ = col;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp67_, (GtkCellRenderer*) cell_unshared, _snapshot_list_box_cell_unshared_render_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp68_ = col;
	_tmp69_ = _g_object_ref0 (_tmp68_);
	_g_object_unref0 (self->priv->col_unshared);
	self->priv->col_unshared = _tmp69_;
	_tmp70_ = self->treeview;
	_tmp71_ = self->priv->col_unshared;
	gtk_tree_view_append_column (_tmp70_, _tmp71_);
	_tmp72_ = self->priv->col_unshared;
	g_signal_connect_object (_tmp72_, "clicked", (GCallback) ___lambda34__gtk_tree_view_column_clicked, self, 0);
	_tmp73_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp73_);
	_g_object_unref0 (self->priv->col_desc);
	self->priv->col_desc = _tmp73_;
	_tmp74_ = self->priv->col_desc;
	gtk_tree_view_column_set_title (_tmp74_, _ ("Comments (click to edit)"));
	_tmp75_ = self->priv->col_desc;
	gtk_tree_view_column_set_resizable (_tmp75_, TRUE);
	_tmp76_ = self->priv->col_desc;
	gtk_tree_view_column_set_clickable (_tmp76_, TRUE);
	_tmp77_ = self->priv->col_desc;
	gtk_tree_view_column_set_expand (_tmp77_, TRUE);
	_tmp78_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp78_);
	cell_desc = _tmp78_;
	g_object_set (cell_desc, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
	_tmp79_ = self->priv->col_desc;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp79_, (GtkCellRenderer*) cell_desc, FALSE);
	_tmp80_ = self->priv->col_desc;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp80_, (GtkCellRenderer*) cell_desc, _snapshot_list_box_cell_desc_render_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp81_ = self->treeview;
	_tmp82_ = self->priv->col_desc;
	gtk_tree_view_append_column (_tmp81_, _tmp82_);
	g_object_set (cell_desc, "editable", TRUE, NULL);
	g_signal_connect_object (cell_desc, "edited", (GCallback) ___lambda35__gtk_cell_renderer_text_edited, self, 0);
	_tmp83_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp83_);
	col_buffer = _tmp83_;
	_tmp84_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp84_);
	cell_text = _tmp84_;
	g_object_set ((GtkCellRenderer*) cell_text, "width", 20, NULL);
	gtk_cell_layout_pack_start ((GtkCellLayout*) col_buffer, (GtkCellRenderer*) cell_text, FALSE);
	_tmp85_ = self->treeview;
	gtk_tree_view_append_column (_tmp85_, col_buffer);
	_tmp86_ = self->treeview;
	g_signal_connect_object ((GtkWidget*) _tmp86_, "query-tooltip", (GCallback) ___lambda36__gtk_widget_query_tooltip, self, 0);
	_g_object_unref0 (cell_text);
	_g_object_unref0 (col_buffer);
	_g_object_unref0 (cell_desc);
	_g_object_unref0 (cell_unshared);
	_g_object_unref0 (cell_size);
	_g_object_unref0 (col);
	_g_object_unref0 (cell_tags);
	_g_object_unref0 (cell_system);
	_g_object_unref0 (cell_date);
	_g_object_unref0 (cell_backup_icon);
	_g_object_unref0 (sw_backups);
}

static void
__lambda37_ (SnapshotListBox* self)
{
	g_signal_emit (self, snapshot_list_box_signals[SNAPSHOT_LIST_BOX_BROWSE_SELECTED_SIGNAL], 0);
}

static void
___lambda37__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda37_ ((SnapshotListBox*) self);
}

static void
__lambda38_ (SnapshotListBox* self)
{
	g_signal_emit (self, snapshot_list_box_signals[SNAPSHOT_LIST_BOX_VIEW_SNAPSHOT_LOG_SIGNAL], 0, FALSE);
}

static void
___lambda38__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda38_ ((SnapshotListBox*) self);
}

static void
__lambda39_ (SnapshotListBox* self)
{
	g_signal_emit (self, snapshot_list_box_signals[SNAPSHOT_LIST_BOX_VIEW_SNAPSHOT_LOG_SIGNAL], 0, TRUE);
}

static void
___lambda39__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda39_ ((SnapshotListBox*) self);
}

static void
__lambda40_ (SnapshotListBox* self)
{
	g_signal_emit (self, snapshot_list_box_signals[SNAPSHOT_LIST_BOX_DELETE_SELECTED_SIGNAL], 0);
}

static void
___lambda40__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda40_ ((SnapshotListBox*) self);
}

static void
__lambda41_ (SnapshotListBox* self)
{
	g_signal_emit (self, snapshot_list_box_signals[SNAPSHOT_LIST_BOX_MARK_SELECTED_SIGNAL], 0);
}

static void
___lambda41__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda41_ ((SnapshotListBox*) self);
}

static gboolean
_snapshot_list_box_treeview_popup_menu_gtk_widget_popup_menu (GtkWidget* _sender,
                                                              gpointer self)
{
	gboolean result;
	result = snapshot_list_box_treeview_popup_menu ((SnapshotListBox*) self);
	return result;
}

static gboolean
_snapshot_list_box_treeview_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                              GdkEventButton* event,
                                                                              gpointer self)
{
	gboolean result;
	result = snapshot_list_box_treeview_button_press_event ((SnapshotListBox*) self, event);
	return result;
}

static void
snapshot_list_box_init_list_view_context_menu (SnapshotListBox* self)
{
	GdkRGBA gray = {0};
	GtkMenu* _tmp0_;
	GtkImageMenuItem* item = NULL;
	GtkImageMenuItem* _tmp1_;
	GtkImageMenuItem* _tmp2_;
	GtkImage* _tmp3_;
	GtkImage* _tmp4_;
	GtkImageMenuItem* _tmp5_;
	GtkMenu* _tmp6_;
	GtkImageMenuItem* _tmp7_;
	GtkImageMenuItem* _tmp8_;
	GtkImageMenuItem* _tmp9_;
	GtkImageMenuItem* _tmp10_;
	GtkImageMenuItem* _tmp11_;
	GtkImage* _tmp12_;
	GtkImage* _tmp13_;
	GtkImageMenuItem* _tmp14_;
	GtkMenu* _tmp15_;
	GtkImageMenuItem* _tmp16_;
	GtkImageMenuItem* _tmp17_;
	GtkImageMenuItem* _tmp18_;
	GtkImageMenuItem* _tmp19_;
	GtkImageMenuItem* _tmp20_;
	GtkImage* _tmp21_;
	GtkImage* _tmp22_;
	GtkImageMenuItem* _tmp23_;
	GtkMenu* _tmp24_;
	GtkImageMenuItem* _tmp25_;
	GtkImageMenuItem* _tmp26_;
	GtkImageMenuItem* _tmp27_;
	GtkImageMenuItem* _tmp28_;
	GtkImageMenuItem* _tmp29_;
	GtkImage* _tmp30_;
	GtkImage* _tmp31_;
	GtkImageMenuItem* _tmp32_;
	GtkMenu* _tmp33_;
	GtkImageMenuItem* _tmp34_;
	GtkImageMenuItem* _tmp35_;
	GtkImageMenuItem* _tmp36_;
	GtkImageMenuItem* _tmp37_;
	GtkImageMenuItem* _tmp38_;
	GtkImage* _tmp39_;
	GtkImage* _tmp40_;
	GtkImageMenuItem* _tmp41_;
	GtkMenu* _tmp42_;
	GtkImageMenuItem* _tmp43_;
	GtkImageMenuItem* _tmp44_;
	GtkImageMenuItem* _tmp45_;
	GtkMenu* _tmp46_;
	GtkTreeView* _tmp47_;
	GtkTreeView* _tmp48_;
	g_return_if_fail (self != NULL);
	memset (&gray, 0, sizeof (GdkRGBA));
	gdk_rgba_parse (&gray, "rgba(200,200,200,1)");
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->menu_snapshots);
	self->priv->menu_snapshots = _tmp0_;
	_tmp1_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_label (_ ("Browse Files"));
	g_object_ref_sink (_tmp1_);
	item = _tmp1_;
	_tmp2_ = item;
	_tmp3_ = icon_manager_lookup_image (ICON_MANAGER_GENERIC_ICON_DIRECTORY, 16, FALSE, FALSE);
	_tmp4_ = _tmp3_;
	gtk_image_menu_item_set_image (_tmp2_, (GtkWidget*) _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = item;
	g_signal_connect_object ((GtkMenuItem*) _tmp5_, "activate", (GCallback) ___lambda37__gtk_menu_item_activate, self, 0);
	_tmp6_ = self->priv->menu_snapshots;
	_tmp7_ = item;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp6_, (GtkMenuItem*) _tmp7_);
	_tmp8_ = item;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (self->priv->mi_browse);
	self->priv->mi_browse = _tmp9_;
	_tmp10_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_label (_ ("View Rsync Log for Create"));
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (item);
	item = _tmp10_;
	_tmp11_ = item;
	_tmp12_ = icon_manager_lookup_image (ICON_MANAGER_GENERIC_ICON_FILE, 16, FALSE, FALSE);
	_tmp13_ = _tmp12_;
	gtk_image_menu_item_set_image (_tmp11_, (GtkWidget*) _tmp13_);
	_g_object_unref0 (_tmp13_);
	_tmp14_ = item;
	g_signal_connect_object ((GtkMenuItem*) _tmp14_, "activate", (GCallback) ___lambda38__gtk_menu_item_activate, self, 0);
	_tmp15_ = self->priv->menu_snapshots;
	_tmp16_ = item;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp15_, (GtkMenuItem*) _tmp16_);
	_tmp17_ = item;
	_tmp18_ = _g_object_ref0 (_tmp17_);
	_g_object_unref0 (self->priv->mi_view_log_create);
	self->priv->mi_view_log_create = _tmp18_;
	_tmp19_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_label (_ ("View Rsync Log for Restore"));
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (item);
	item = _tmp19_;
	_tmp20_ = item;
	_tmp21_ = icon_manager_lookup_image (ICON_MANAGER_GENERIC_ICON_FILE, 16, FALSE, FALSE);
	_tmp22_ = _tmp21_;
	gtk_image_menu_item_set_image (_tmp20_, (GtkWidget*) _tmp22_);
	_g_object_unref0 (_tmp22_);
	_tmp23_ = item;
	g_signal_connect_object ((GtkMenuItem*) _tmp23_, "activate", (GCallback) ___lambda39__gtk_menu_item_activate, self, 0);
	_tmp24_ = self->priv->menu_snapshots;
	_tmp25_ = item;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp24_, (GtkMenuItem*) _tmp25_);
	_tmp26_ = item;
	_tmp27_ = _g_object_ref0 (_tmp26_);
	_g_object_unref0 (self->priv->mi_view_log_restore);
	self->priv->mi_view_log_restore = _tmp27_;
	_tmp28_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_label (_ ("Delete"));
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (item);
	item = _tmp28_;
	_tmp29_ = item;
	_tmp30_ = icon_manager_lookup_image ("edit-delete", 16, FALSE, FALSE);
	_tmp31_ = _tmp30_;
	gtk_image_menu_item_set_image (_tmp29_, (GtkWidget*) _tmp31_);
	_g_object_unref0 (_tmp31_);
	_tmp32_ = item;
	g_signal_connect_object ((GtkMenuItem*) _tmp32_, "activate", (GCallback) ___lambda40__gtk_menu_item_activate, self, 0);
	_tmp33_ = self->priv->menu_snapshots;
	_tmp34_ = item;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp33_, (GtkMenuItem*) _tmp34_);
	_tmp35_ = item;
	_tmp36_ = _g_object_ref0 (_tmp35_);
	_g_object_unref0 (self->priv->mi_remove);
	self->priv->mi_remove = _tmp36_;
	_tmp37_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_label (_ ("Mark/Unmark for Deletion"));
	g_object_ref_sink (_tmp37_);
	_g_object_unref0 (item);
	item = _tmp37_;
	_tmp38_ = item;
	_tmp39_ = icon_manager_lookup_image ("edit-delete", 16, FALSE, FALSE);
	_tmp40_ = _tmp39_;
	gtk_image_menu_item_set_image (_tmp38_, (GtkWidget*) _tmp40_);
	_g_object_unref0 (_tmp40_);
	_tmp41_ = item;
	g_signal_connect_object ((GtkMenuItem*) _tmp41_, "activate", (GCallback) ___lambda41__gtk_menu_item_activate, self, 0);
	_tmp42_ = self->priv->menu_snapshots;
	_tmp43_ = item;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp42_, (GtkMenuItem*) _tmp43_);
	_tmp44_ = item;
	_tmp45_ = _g_object_ref0 (_tmp44_);
	_g_object_unref0 (self->priv->mi_mark);
	self->priv->mi_mark = _tmp45_;
	_tmp46_ = self->priv->menu_snapshots;
	gtk_widget_show_all ((GtkWidget*) _tmp46_);
	_tmp47_ = self->treeview;
	g_signal_connect_object ((GtkWidget*) _tmp47_, "popup-menu", (GCallback) _snapshot_list_box_treeview_popup_menu_gtk_widget_popup_menu, self, 0);
	_tmp48_ = self->treeview;
	g_signal_connect_object ((GtkWidget*) _tmp48_, "button-press-event", (GCallback) _snapshot_list_box_treeview_button_press_event_gtk_widget_button_press_event, self, 0);
	_g_object_unref0 (item);
}

static gboolean
snapshot_list_box_treeview_popup_menu (SnapshotListBox* self)
{
	GtkMenu* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->menu_snapshots;
	result = snapshot_list_box_menu_snapshots_popup (self, _tmp0_, NULL);
	return result;
}

static gboolean
snapshot_list_box_treeview_button_press_event (SnapshotListBox* self,
                                               GdkEventButton* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button == ((guint) 3)) {
		GtkMenu* _tmp0_;
		_tmp0_ = self->priv->menu_snapshots;
		result = snapshot_list_box_menu_snapshots_popup (self, _tmp0_, event);
		return result;
	}
	result = FALSE;
	return result;
}

static void
snapshot_list_box_cell_date_render (SnapshotListBox* self,
                                    GtkCellLayout* cell_layout,
                                    GtkCellRenderer* cell,
                                    GtkTreeModel* model,
                                    GtkTreeIter* iter)
{
	Snapshot* bak = NULL;
	GtkTreeIter _tmp0_;
	Snapshot* _tmp1_ = NULL;
	GtkCellRendererText* ctxt = NULL;
	GtkCellRendererText* _tmp2_;
	GtkCellRendererText* _tmp3_;
	Snapshot* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GtkCellRendererText* _tmp8_;
	Snapshot* _tmp9_;
	Snapshot* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	gtk_tree_model_get (model, &_tmp0_, 0, &_tmp1_, -1, -1);
	_g_object_unref0 (bak);
	bak = _tmp1_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (cell, gtk_cell_renderer_text_get_type ()) ? ((GtkCellRendererText*) cell) : NULL);
	ctxt = _tmp2_;
	_tmp3_ = ctxt;
	_tmp4_ = bak;
	_tmp5_ = snapshot_get_date_formatted (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	g_object_set (_tmp3_, "text", _tmp7_, NULL);
	_g_free0 (_tmp7_);
	_tmp8_ = ctxt;
	_tmp9_ = bak;
	gtk_cell_renderer_set_sensitive ((GtkCellRenderer*) _tmp8_, !_tmp9_->marked_for_deletion);
	_tmp10_ = bak;
	if (_tmp10_->live) {
		GtkCellRendererText* _tmp11_;
		GtkCellRendererText* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp11_ = ctxt;
		_tmp12_ = ctxt;
		g_object_get (_tmp12_, "text", &_tmp13_, NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strdup_printf ("<b>%s</b>", _tmp15_);
		_tmp17_ = _tmp16_;
		g_object_set (_tmp11_, "markup", _tmp17_, NULL);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp15_);
	} else {
		GtkCellRendererText* _tmp18_;
		GtkCellRendererText* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp18_ = ctxt;
		_tmp19_ = ctxt;
		g_object_get (_tmp19_, "text", &_tmp20_, NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = _tmp21_;
		g_object_set (_tmp18_, "markup", _tmp22_, NULL);
		_g_free0 (_tmp22_);
	}
	_g_object_unref0 (ctxt);
	_g_object_unref0 (bak);
}

static void
snapshot_list_box_cell_tags_render (SnapshotListBox* self,
                                    GtkCellLayout* cell_layout,
                                    GtkCellRenderer* cell,
                                    GtkTreeModel* model,
                                    GtkTreeIter* iter)
{
	Snapshot* bak = NULL;
	GtkTreeIter _tmp0_;
	Snapshot* _tmp1_ = NULL;
	GtkCellRendererText* ctxt = NULL;
	GtkCellRendererText* _tmp2_;
	GtkCellRendererText* _tmp3_;
	Snapshot* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GtkCellRendererText* _tmp8_;
	Snapshot* _tmp9_;
	Snapshot* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	gtk_tree_model_get (model, &_tmp0_, 0, &_tmp1_, -1, -1);
	_g_object_unref0 (bak);
	bak = _tmp1_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (cell, gtk_cell_renderer_text_get_type ()) ? ((GtkCellRendererText*) cell) : NULL);
	ctxt = _tmp2_;
	_tmp3_ = ctxt;
	_tmp4_ = bak;
	_tmp5_ = snapshot_get_taglist_short (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	g_object_set (_tmp3_, "text", _tmp7_, NULL);
	_g_free0 (_tmp7_);
	_tmp8_ = ctxt;
	_tmp9_ = bak;
	gtk_cell_renderer_set_sensitive ((GtkCellRenderer*) _tmp8_, !_tmp9_->marked_for_deletion);
	_tmp10_ = bak;
	if (_tmp10_->live) {
		GtkCellRendererText* _tmp11_;
		GtkCellRendererText* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp11_ = ctxt;
		_tmp12_ = ctxt;
		g_object_get (_tmp12_, "text", &_tmp13_, NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strdup_printf ("<b>%s</b>", _tmp15_);
		_tmp17_ = _tmp16_;
		g_object_set (_tmp11_, "markup", _tmp17_, NULL);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp15_);
	} else {
		GtkCellRendererText* _tmp18_;
		GtkCellRendererText* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp18_ = ctxt;
		_tmp19_ = ctxt;
		g_object_get (_tmp19_, "text", &_tmp20_, NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = _tmp21_;
		g_object_set (_tmp18_, "markup", _tmp22_, NULL);
		_g_free0 (_tmp22_);
	}
	_g_object_unref0 (ctxt);
	_g_object_unref0 (bak);
}

static void
snapshot_list_box_cell_size_render (SnapshotListBox* self,
                                    GtkCellLayout* cell_layout,
                                    GtkCellRenderer* cell,
                                    GtkTreeModel* model,
                                    GtkTreeIter* iter)
{
	Snapshot* bak = NULL;
	GtkTreeIter _tmp0_;
	Snapshot* _tmp1_ = NULL;
	GtkCellRendererText* ctxt = NULL;
	GtkCellRendererText* _tmp2_;
	Snapshot* _tmp3_;
	GtkCellRendererText* _tmp20_;
	Snapshot* _tmp21_;
	Snapshot* _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	gtk_tree_model_get (model, &_tmp0_, 0, &_tmp1_, -1, -1);
	_g_object_unref0 (bak);
	bak = _tmp1_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (cell, gtk_cell_renderer_text_get_type ()) ? ((GtkCellRendererText*) cell) : NULL);
	ctxt = _tmp2_;
	_tmp3_ = bak;
	if (_tmp3_->btrfs_mode) {
		gint64 size = 0LL;
		Snapshot* _tmp4_;
		GeeHashMap* _tmp5_;
		Snapshot* _tmp10_;
		GeeHashMap* _tmp11_;
		GtkCellRendererText* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		size = (gint64) 0;
		_tmp4_ = bak;
		_tmp5_ = _tmp4_->subvolumes;
		if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp5_, "@")) {
			Snapshot* _tmp6_;
			GeeHashMap* _tmp7_;
			gpointer _tmp8_;
			Subvolume* _tmp9_;
			_tmp6_ = bak;
			_tmp7_ = _tmp6_->subvolumes;
			_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp7_, "@");
			_tmp9_ = (Subvolume*) _tmp8_;
			size += _tmp9_->total_bytes;
			_g_object_unref0 (_tmp9_);
		}
		_tmp10_ = bak;
		_tmp11_ = _tmp10_->subvolumes;
		if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp11_, "@home")) {
			Snapshot* _tmp12_;
			GeeHashMap* _tmp13_;
			gpointer _tmp14_;
			Subvolume* _tmp15_;
			_tmp12_ = bak;
			_tmp13_ = _tmp12_->subvolumes;
			_tmp14_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp13_, "@home");
			_tmp15_ = (Subvolume*) _tmp14_;
			size += _tmp15_->total_bytes;
			_g_object_unref0 (_tmp15_);
		}
		_tmp16_ = ctxt;
		_tmp17_ = tee_jee_file_system_format_file_size ((guint64) size, FALSE, "", TRUE, 1);
		_tmp18_ = _tmp17_;
		g_object_set (_tmp16_, "text", _tmp18_, NULL);
		_g_free0 (_tmp18_);
	} else {
		GtkCellRendererText* _tmp19_;
		_tmp19_ = ctxt;
		g_object_set (_tmp19_, "text", "", NULL);
	}
	_tmp20_ = ctxt;
	_tmp21_ = bak;
	gtk_cell_renderer_set_sensitive ((GtkCellRenderer*) _tmp20_, !_tmp21_->marked_for_deletion);
	_tmp22_ = bak;
	if (_tmp22_->live) {
		GtkCellRendererText* _tmp23_;
		GtkCellRendererText* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		_tmp23_ = ctxt;
		_tmp24_ = ctxt;
		g_object_get (_tmp24_, "text", &_tmp25_, NULL);
		_tmp26_ = _tmp25_;
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strdup_printf ("<b>%s</b>", _tmp27_);
		_tmp29_ = _tmp28_;
		g_object_set (_tmp23_, "markup", _tmp29_, NULL);
		_g_free0 (_tmp29_);
		_g_free0 (_tmp27_);
	} else {
		GtkCellRendererText* _tmp30_;
		GtkCellRendererText* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		_tmp30_ = ctxt;
		_tmp31_ = ctxt;
		g_object_get (_tmp31_, "text", &_tmp32_, NULL);
		_tmp33_ = _tmp32_;
		_tmp34_ = _tmp33_;
		g_object_set (_tmp30_, "markup", _tmp34_, NULL);
		_g_free0 (_tmp34_);
	}
	_g_object_unref0 (ctxt);
	_g_object_unref0 (bak);
}

static void
snapshot_list_box_cell_unshared_render (SnapshotListBox* self,
                                        GtkCellLayout* cell_layout,
                                        GtkCellRenderer* cell,
                                        GtkTreeModel* model,
                                        GtkTreeIter* iter)
{
	Snapshot* bak = NULL;
	GtkTreeIter _tmp0_;
	Snapshot* _tmp1_ = NULL;
	GtkCellRendererText* ctxt = NULL;
	GtkCellRendererText* _tmp2_;
	Snapshot* _tmp3_;
	GtkCellRendererText* _tmp20_;
	Snapshot* _tmp21_;
	Snapshot* _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	gtk_tree_model_get (model, &_tmp0_, 0, &_tmp1_, -1, -1);
	_g_object_unref0 (bak);
	bak = _tmp1_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (cell, gtk_cell_renderer_text_get_type ()) ? ((GtkCellRendererText*) cell) : NULL);
	ctxt = _tmp2_;
	_tmp3_ = bak;
	if (_tmp3_->btrfs_mode) {
		gint64 size = 0LL;
		Snapshot* _tmp4_;
		GeeHashMap* _tmp5_;
		Snapshot* _tmp10_;
		GeeHashMap* _tmp11_;
		GtkCellRendererText* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		size = (gint64) 0;
		_tmp4_ = bak;
		_tmp5_ = _tmp4_->subvolumes;
		if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp5_, "@")) {
			Snapshot* _tmp6_;
			GeeHashMap* _tmp7_;
			gpointer _tmp8_;
			Subvolume* _tmp9_;
			_tmp6_ = bak;
			_tmp7_ = _tmp6_->subvolumes;
			_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp7_, "@");
			_tmp9_ = (Subvolume*) _tmp8_;
			size += _tmp9_->unshared_bytes;
			_g_object_unref0 (_tmp9_);
		}
		_tmp10_ = bak;
		_tmp11_ = _tmp10_->subvolumes;
		if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp11_, "@home")) {
			Snapshot* _tmp12_;
			GeeHashMap* _tmp13_;
			gpointer _tmp14_;
			Subvolume* _tmp15_;
			_tmp12_ = bak;
			_tmp13_ = _tmp12_->subvolumes;
			_tmp14_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp13_, "@home");
			_tmp15_ = (Subvolume*) _tmp14_;
			size += _tmp15_->unshared_bytes;
			_g_object_unref0 (_tmp15_);
		}
		_tmp16_ = ctxt;
		_tmp17_ = tee_jee_file_system_format_file_size ((guint64) size, FALSE, "", TRUE, 1);
		_tmp18_ = _tmp17_;
		g_object_set (_tmp16_, "text", _tmp18_, NULL);
		_g_free0 (_tmp18_);
	} else {
		GtkCellRendererText* _tmp19_;
		_tmp19_ = ctxt;
		g_object_set (_tmp19_, "text", "", NULL);
	}
	_tmp20_ = ctxt;
	_tmp21_ = bak;
	gtk_cell_renderer_set_sensitive ((GtkCellRenderer*) _tmp20_, !_tmp21_->marked_for_deletion);
	_tmp22_ = bak;
	if (_tmp22_->live) {
		GtkCellRendererText* _tmp23_;
		GtkCellRendererText* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		_tmp23_ = ctxt;
		_tmp24_ = ctxt;
		g_object_get (_tmp24_, "text", &_tmp25_, NULL);
		_tmp26_ = _tmp25_;
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strdup_printf ("<b>%s</b>", _tmp27_);
		_tmp29_ = _tmp28_;
		g_object_set (_tmp23_, "markup", _tmp29_, NULL);
		_g_free0 (_tmp29_);
		_g_free0 (_tmp27_);
	} else {
		GtkCellRendererText* _tmp30_;
		GtkCellRendererText* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		_tmp30_ = ctxt;
		_tmp31_ = ctxt;
		g_object_get (_tmp31_, "text", &_tmp32_, NULL);
		_tmp33_ = _tmp32_;
		_tmp34_ = _tmp33_;
		g_object_set (_tmp30_, "markup", _tmp34_, NULL);
		_g_free0 (_tmp34_);
	}
	_g_object_unref0 (ctxt);
	_g_object_unref0 (bak);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
snapshot_list_box_cell_system_render (SnapshotListBox* self,
                                      GtkCellLayout* cell_layout,
                                      GtkCellRenderer* cell,
                                      GtkTreeModel* model,
                                      GtkTreeIter* iter)
{
	Snapshot* bak = NULL;
	GtkTreeIter _tmp0_;
	Snapshot* _tmp1_ = NULL;
	GtkCellRendererText* ctxt = NULL;
	GtkCellRendererText* _tmp2_;
	GtkCellRendererText* _tmp3_;
	Snapshot* _tmp4_;
	const gchar* _tmp5_;
	GtkCellRendererText* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_;
	GtkCellRendererText* _tmp18_;
	Snapshot* _tmp19_;
	Snapshot* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	gtk_tree_model_get (model, &_tmp0_, 0, &_tmp1_, -1, -1);
	_g_object_unref0 (bak);
	bak = _tmp1_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (cell, gtk_cell_renderer_text_get_type ()) ? ((GtkCellRendererText*) cell) : NULL);
	ctxt = _tmp2_;
	_tmp3_ = ctxt;
	_tmp4_ = bak;
	_tmp5_ = _tmp4_->sys_distro;
	g_object_set (_tmp3_, "text", _tmp5_, NULL);
	_tmp6_ = ctxt;
	g_object_get (_tmp6_, "text", &_tmp7_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp10_ = string_contains (_tmp9_, "LinuxMint");
	_g_free0 (_tmp9_);
	if (_tmp10_) {
		GtkCellRendererText* _tmp11_;
		GtkCellRendererText* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp11_ = ctxt;
		_tmp12_ = ctxt;
		g_object_get (_tmp12_, "text", &_tmp13_, NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_;
		_tmp16_ = string_replace (_tmp15_, "LinuxMint", "Linux Mint");
		_tmp17_ = _tmp16_;
		g_object_set (_tmp11_, "text", _tmp17_, NULL);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp15_);
	}
	_tmp18_ = ctxt;
	_tmp19_ = bak;
	gtk_cell_renderer_set_sensitive ((GtkCellRenderer*) _tmp18_, !_tmp19_->marked_for_deletion);
	_tmp20_ = bak;
	if (_tmp20_->live) {
		GtkCellRendererText* _tmp21_;
		GtkCellRendererText* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		_tmp21_ = ctxt;
		_tmp22_ = ctxt;
		g_object_get (_tmp22_, "text", &_tmp23_, NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strdup_printf ("<b>%s</b>", _tmp25_);
		_tmp27_ = _tmp26_;
		g_object_set (_tmp21_, "markup", _tmp27_, NULL);
		_g_free0 (_tmp27_);
		_g_free0 (_tmp25_);
	} else {
		GtkCellRendererText* _tmp28_;
		GtkCellRendererText* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		_tmp28_ = ctxt;
		_tmp29_ = ctxt;
		g_object_get (_tmp29_, "text", &_tmp30_, NULL);
		_tmp31_ = _tmp30_;
		_tmp32_ = _tmp31_;
		g_object_set (_tmp28_, "markup", _tmp32_, NULL);
		_g_free0 (_tmp32_);
	}
	_g_object_unref0 (ctxt);
	_g_object_unref0 (bak);
}

static void
snapshot_list_box_cell_desc_render (SnapshotListBox* self,
                                    GtkCellLayout* cell_layout,
                                    GtkCellRenderer* cell,
                                    GtkTreeModel* model,
                                    GtkTreeIter* iter)
{
	Snapshot* bak = NULL;
	GtkTreeIter _tmp0_;
	Snapshot* _tmp1_ = NULL;
	GtkCellRendererText* ctxt = NULL;
	GtkCellRendererText* _tmp2_;
	GtkCellRendererText* _tmp3_;
	Snapshot* _tmp4_;
	const gchar* _tmp5_;
	GtkCellRendererText* _tmp6_;
	Snapshot* _tmp7_;
	Snapshot* _tmp8_;
	Snapshot* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	gtk_tree_model_get (model, &_tmp0_, 0, &_tmp1_, -1, -1);
	_g_object_unref0 (bak);
	bak = _tmp1_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (cell, gtk_cell_renderer_text_get_type ()) ? ((GtkCellRendererText*) cell) : NULL);
	ctxt = _tmp2_;
	_tmp3_ = ctxt;
	_tmp4_ = bak;
	_tmp5_ = _tmp4_->description;
	g_object_set (_tmp3_, "text", _tmp5_, NULL);
	_tmp6_ = ctxt;
	_tmp7_ = bak;
	gtk_cell_renderer_set_sensitive ((GtkCellRenderer*) _tmp6_, !_tmp7_->marked_for_deletion);
	_tmp8_ = bak;
	if (_tmp8_->live) {
		GtkCellRendererText* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		GtkCellRendererText* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp9_ = ctxt;
		_tmp10_ = g_strconcat ("[", _ ("LIVE"), NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat (_tmp11_, "] ", NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = ctxt;
		g_object_get (_tmp14_, "text", &_tmp15_, NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strconcat (_tmp13_, _tmp17_, NULL);
		_tmp19_ = _tmp18_;
		g_object_set (_tmp9_, "text", _tmp19_, NULL);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
	}
	_tmp20_ = bak;
	if (_tmp20_->live) {
		GtkCellRendererText* _tmp21_;
		GtkCellRendererText* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		_tmp21_ = ctxt;
		_tmp22_ = ctxt;
		g_object_get (_tmp22_, "text", &_tmp23_, NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strdup_printf ("<b>%s</b>", _tmp25_);
		_tmp27_ = _tmp26_;
		g_object_set (_tmp21_, "markup", _tmp27_, NULL);
		_g_free0 (_tmp27_);
		_g_free0 (_tmp25_);
	} else {
		GtkCellRendererText* _tmp28_;
		GtkCellRendererText* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		_tmp28_ = ctxt;
		_tmp29_ = ctxt;
		g_object_get (_tmp29_, "text", &_tmp30_, NULL);
		_tmp31_ = _tmp30_;
		_tmp32_ = _tmp31_;
		g_object_set (_tmp28_, "markup", _tmp32_, NULL);
		_g_free0 (_tmp32_);
	}
	_g_object_unref0 (ctxt);
	_g_object_unref0 (bak);
}

static gboolean
snapshot_list_box_menu_snapshots_popup (SnapshotListBox* self,
                                        GtkMenu* popup,
                                        GdkEventButton* event)
{
	GeeArrayList* selected = NULL;
	GeeArrayList* _tmp0_;
	GtkImageMenuItem* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GtkImageMenuItem* _tmp5_;
	GeeArrayList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GtkImageMenuItem* _tmp9_;
	Main* _tmp10_;
	GtkImageMenuItem* _tmp11_;
	Main* _tmp12_;
	Main* _tmp13_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (popup != NULL, FALSE);
	_tmp0_ = snapshot_list_box_selected_snapshots (self);
	selected = _tmp0_;
	_tmp1_ = self->priv->mi_remove;
	_tmp2_ = selected;
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, _tmp4_ > 0);
	_tmp5_ = self->priv->mi_mark;
	_tmp6_ = selected;
	_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, _tmp8_ > 0);
	_tmp9_ = self->priv->mi_view_log_create;
	_tmp10_ = App;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, !_tmp10_->btrfs_mode);
	_tmp11_ = self->priv->mi_view_log_restore;
	_tmp12_ = App;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, !_tmp12_->btrfs_mode);
	_tmp13_ = App;
	if (!_tmp13_->btrfs_mode) {
		GeeArrayList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		_tmp14_ = selected;
		_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		if (_tmp16_ > 0) {
			gboolean _tmp17_ = FALSE;
			GeeArrayList* _tmp18_;
			gpointer _tmp19_;
			Snapshot* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gboolean _tmp24_;
			GtkImageMenuItem* _tmp31_;
			_tmp18_ = selected;
			_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, 0);
			_tmp20_ = (Snapshot*) _tmp19_;
			_tmp21_ = snapshot_get_rsync_restore_log_file (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = _tmp22_;
			_tmp24_ = tee_jee_file_system_file_exists (_tmp23_);
			_g_free0 (_tmp23_);
			_g_object_unref0 (_tmp20_);
			if (_tmp24_) {
				_tmp17_ = TRUE;
			} else {
				GeeArrayList* _tmp25_;
				gpointer _tmp26_;
				Snapshot* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				_tmp25_ = selected;
				_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, 0);
				_tmp27_ = (Snapshot*) _tmp26_;
				_tmp28_ = snapshot_get_rsync_restore_changes_log_file (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = _tmp29_;
				_tmp17_ = tee_jee_file_system_file_exists (_tmp30_);
				_g_free0 (_tmp30_);
				_g_object_unref0 (_tmp27_);
			}
			_tmp31_ = self->priv->mi_view_log_restore;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp31_, _tmp17_);
		}
	}
	if (event != NULL) {
		GtkMenu* _tmp32_;
		_tmp32_ = self->priv->menu_snapshots;
		gtk_menu_popup (_tmp32_, NULL, NULL, NULL, NULL, event->button, event->time);
	} else {
		GtkMenu* _tmp33_;
		_tmp33_ = self->priv->menu_snapshots;
		gtk_menu_popup (_tmp33_, NULL, NULL, NULL, NULL, (guint) 0, gtk_get_current_event_time ());
	}
	result = TRUE;
	_g_object_unref0 (selected);
	return result;
}

static gint
____lambda27_ (SnapshotListBox* self,
               Snapshot* a,
               Snapshot* b)
{
	Snapshot* t1 = NULL;
	Snapshot* _tmp0_;
	Snapshot* t2 = NULL;
	Snapshot* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	gint result;
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (a, TYPE_SNAPSHOT, Snapshot));
	t1 = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b, TYPE_SNAPSHOT, Snapshot));
	t2 = _tmp1_;
	_tmp2_ = t1->date;
	_tmp3_ = t2->date;
	result = g_date_time_compare (_tmp2_, _tmp3_);
	_g_object_unref0 (t2);
	_g_object_unref0 (t1);
	return result;
}

static gint
_____lambda27__gcompare_data_func (gconstpointer a,
                                   gconstpointer b,
                                   gpointer self)
{
	gint result;
	result = ____lambda27_ ((SnapshotListBox*) self, (Snapshot*) a, (Snapshot*) b);
	return result;
}

static gint
____lambda28_ (SnapshotListBox* self,
               Snapshot* a,
               Snapshot* b)
{
	Snapshot* t1 = NULL;
	Snapshot* _tmp0_;
	Snapshot* t2 = NULL;
	Snapshot* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	gint result;
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (a, TYPE_SNAPSHOT, Snapshot));
	t1 = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b, TYPE_SNAPSHOT, Snapshot));
	t2 = _tmp1_;
	_tmp2_ = t1->date;
	_tmp3_ = t2->date;
	result = -1 * g_date_time_compare (_tmp2_, _tmp3_);
	_g_object_unref0 (t2);
	_g_object_unref0 (t1);
	return result;
}

static gint
_____lambda28__gcompare_data_func (gconstpointer a,
                                   gconstpointer b,
                                   gpointer self)
{
	gint result;
	result = ____lambda28_ ((SnapshotListBox*) self, (Snapshot*) a, (Snapshot*) b);
	return result;
}

static gint
____lambda29_ (SnapshotListBox* self,
               Snapshot* a,
               Snapshot* b)
{
	Snapshot* t1 = NULL;
	Snapshot* _tmp0_;
	Snapshot* t2 = NULL;
	Snapshot* _tmp1_;
	GCompareFunc _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gint _tmp9_;
	gint result;
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (a, TYPE_SNAPSHOT, Snapshot));
	t1 = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b, TYPE_SNAPSHOT, Snapshot));
	t2 = _tmp1_;
	_tmp2_ = ((GCompareFunc) g_strcmp0);
	_tmp3_ = snapshot_get_taglist (t1);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = snapshot_get_taglist (t2);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp2_ (_tmp5_, _tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp5_);
	result = _tmp9_;
	_g_object_unref0 (t2);
	_g_object_unref0 (t1);
	return result;
}

static gint
_____lambda29__gcompare_data_func (gconstpointer a,
                                   gconstpointer b,
                                   gpointer self)
{
	gint result;
	result = ____lambda29_ ((SnapshotListBox*) self, (Snapshot*) a, (Snapshot*) b);
	return result;
}

static gint
____lambda30_ (SnapshotListBox* self,
               Snapshot* a,
               Snapshot* b)
{
	Snapshot* t1 = NULL;
	Snapshot* _tmp0_;
	Snapshot* t2 = NULL;
	Snapshot* _tmp1_;
	GCompareFunc _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gint _tmp9_;
	gint result;
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (a, TYPE_SNAPSHOT, Snapshot));
	t1 = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b, TYPE_SNAPSHOT, Snapshot));
	t2 = _tmp1_;
	_tmp2_ = ((GCompareFunc) g_strcmp0);
	_tmp3_ = snapshot_get_taglist (t1);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = snapshot_get_taglist (t2);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp9_ = -1 * _tmp2_ (_tmp5_, _tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp5_);
	result = _tmp9_;
	_g_object_unref0 (t2);
	_g_object_unref0 (t1);
	return result;
}

static gint
_____lambda30__gcompare_data_func (gconstpointer a,
                                   gconstpointer b,
                                   gpointer self)
{
	gint result;
	result = ____lambda30_ ((SnapshotListBox*) self, (Snapshot*) a, (Snapshot*) b);
	return result;
}

void
snapshot_list_box_refresh (SnapshotListBox* self)
{
	GtkListStore* model = NULL;
	GtkListStore* _tmp0_;
	gboolean _tmp1_ = FALSE;
	Main* _tmp2_;
	SnapshotRepo* _tmp3_;
	Main* _tmp8_;
	SnapshotRepo* _tmp9_;
	GeeArrayList* list = NULL;
	Main* _tmp10_;
	SnapshotRepo* _tmp11_;
	GeeArrayList* _tmp12_;
	GeeArrayList* _tmp13_;
	GtkTreeIter iter = {0};
	GtkTreeViewColumn* _tmp31_;
	Main* _tmp32_;
	gboolean _tmp33_;
	gboolean _tmp34_;
	GtkTreeViewColumn* _tmp35_;
	Main* _tmp36_;
	gboolean _tmp37_;
	gboolean _tmp38_;
	GtkTreeView* _tmp39_;
	GtkListStore* _tmp40_;
	GtkTreeView* _tmp41_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_list_store_new (1, TYPE_SNAPSHOT, -1);
	model = _tmp0_;
	_tmp2_ = App;
	_tmp3_ = _tmp2_->repo;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		Main* _tmp4_;
		SnapshotRepo* _tmp5_;
		_tmp4_ = App;
		_tmp5_ = _tmp4_->repo;
		_tmp1_ = !snapshot_repo_available (_tmp5_);
	}
	if (_tmp1_) {
		GtkTreeView* _tmp6_;
		GtkListStore* _tmp7_;
		_tmp6_ = self->treeview;
		_tmp7_ = model;
		gtk_tree_view_set_model (_tmp6_, (GtkTreeModel*) _tmp7_);
		_g_object_unref0 (model);
		return;
	}
	_tmp8_ = App;
	_tmp9_ = _tmp8_->repo;
	snapshot_repo_load_snapshots (_tmp9_);
	_tmp10_ = App;
	_tmp11_ = _tmp10_->repo;
	_tmp12_ = _tmp11_->snapshots;
	_tmp13_ = _g_object_ref0 (_tmp12_);
	list = _tmp13_;
	if (self->priv->treeview_sort_column_index == 0) {
		if (self->priv->treeview_sort_column_desc) {
			GeeArrayList* _tmp14_;
			_tmp14_ = list;
			gee_list_sort ((GeeList*) _tmp14_, _____lambda27__gcompare_data_func, g_object_ref (self), g_object_unref);
		} else {
			GeeArrayList* _tmp15_;
			_tmp15_ = list;
			gee_list_sort ((GeeList*) _tmp15_, _____lambda28__gcompare_data_func, g_object_ref (self), g_object_unref);
		}
	} else {
		if (self->priv->treeview_sort_column_desc) {
			GeeArrayList* _tmp16_;
			_tmp16_ = list;
			gee_list_sort ((GeeList*) _tmp16_, _____lambda29__gcompare_data_func, g_object_ref (self), g_object_unref);
		} else {
			GeeArrayList* _tmp17_;
			_tmp17_ = list;
			gee_list_sort ((GeeList*) _tmp17_, _____lambda30__gcompare_data_func, g_object_ref (self), g_object_unref);
		}
	}
	{
		GeeArrayList* _bak_list = NULL;
		GeeArrayList* _tmp18_;
		gint _bak_size = 0;
		GeeArrayList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _bak_index = 0;
		_tmp18_ = list;
		_bak_list = _tmp18_;
		_tmp19_ = _bak_list;
		_tmp20_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_bak_size = _tmp21_;
		_bak_index = -1;
		while (TRUE) {
			gint _tmp22_;
			gint _tmp23_;
			Snapshot* bak = NULL;
			GeeArrayList* _tmp24_;
			gpointer _tmp25_;
			GtkListStore* _tmp26_;
			GtkTreeIter _tmp27_ = {0};
			GtkListStore* _tmp28_;
			GtkTreeIter _tmp29_;
			Snapshot* _tmp30_;
			_bak_index = _bak_index + 1;
			_tmp22_ = _bak_index;
			_tmp23_ = _bak_size;
			if (!(_tmp22_ < _tmp23_)) {
				break;
			}
			_tmp24_ = _bak_list;
			_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp24_, _bak_index);
			bak = (Snapshot*) _tmp25_;
			_tmp26_ = model;
			gtk_list_store_append (_tmp26_, &_tmp27_);
			iter = _tmp27_;
			_tmp28_ = model;
			_tmp29_ = iter;
			_tmp30_ = bak;
			gtk_list_store_set (_tmp28_, &_tmp29_, 0, _tmp30_, -1);
			_g_object_unref0 (bak);
		}
	}
	_tmp31_ = self->priv->col_size;
	_tmp32_ = App;
	_tmp33_ = main_get_btrfs_qgroups_enabled (_tmp32_);
	_tmp34_ = _tmp33_;
	gtk_tree_view_column_set_visible (_tmp31_, _tmp34_);
	_tmp35_ = self->priv->col_unshared;
	_tmp36_ = App;
	_tmp37_ = main_get_btrfs_qgroups_enabled (_tmp36_);
	_tmp38_ = _tmp37_;
	gtk_tree_view_column_set_visible (_tmp35_, _tmp38_);
	_tmp39_ = self->treeview;
	_tmp40_ = model;
	gtk_tree_view_set_model (_tmp39_, (GtkTreeModel*) _tmp40_);
	_tmp41_ = self->treeview;
	gtk_tree_view_columns_autosize (_tmp41_);
	_g_object_unref0 (list);
	_g_object_unref0 (model);
}

void
snapshot_list_box_hide_context_menu (SnapshotListBox* self)
{
	GtkTreeView* _tmp0_;
	guint _tmp1_;
	GtkTreeView* _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->treeview;
	g_signal_parse_name ("popup-menu", gtk_widget_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _snapshot_list_box_treeview_popup_menu_gtk_widget_popup_menu, self);
	_tmp2_ = self->treeview;
	g_signal_parse_name ("button-press-event", gtk_widget_get_type (), &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _snapshot_list_box_treeview_button_press_event_gtk_widget_button_press_event, self);
}

GeeArrayList*
snapshot_list_box_selected_snapshots (SnapshotListBox* self)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	GtkTreeIter iter = {0};
	GtkListStore* store = NULL;
	GtkTreeView* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkListStore* _tmp4_;
	GtkTreeSelection* sel = NULL;
	GtkTreeView* _tmp5_;
	GtkTreeSelection* _tmp6_;
	GtkTreeSelection* _tmp7_;
	gboolean iterExists = FALSE;
	GtkListStore* _tmp8_;
	GtkTreeIter _tmp9_ = {0};
	gboolean _tmp10_;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (TYPE_SNAPSHOT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp0_;
	_tmp1_ = self->treeview;
	_tmp2_ = gtk_tree_view_get_model (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_list_store_get_type (), GtkListStore));
	store = _tmp4_;
	_tmp5_ = self->treeview;
	_tmp6_ = gtk_tree_view_get_selection (_tmp5_);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	sel = _tmp7_;
	_tmp8_ = store;
	_tmp10_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp8_, &_tmp9_);
	iter = _tmp9_;
	iterExists = _tmp10_;
	while (TRUE) {
		GtkTreeSelection* _tmp11_;
		GtkTreeIter _tmp12_;
		GtkListStore* _tmp18_;
		gboolean _tmp19_;
		if (!iterExists) {
			break;
		}
		_tmp11_ = sel;
		_tmp12_ = iter;
		if (gtk_tree_selection_iter_is_selected (_tmp11_, &_tmp12_)) {
			Snapshot* bak = NULL;
			GtkListStore* _tmp13_;
			GtkTreeIter _tmp14_;
			Snapshot* _tmp15_ = NULL;
			GeeArrayList* _tmp16_;
			Snapshot* _tmp17_;
			_tmp13_ = store;
			_tmp14_ = iter;
			gtk_tree_model_get ((GtkTreeModel*) _tmp13_, &_tmp14_, 0, &_tmp15_, -1);
			_g_object_unref0 (bak);
			bak = _tmp15_;
			_tmp16_ = list;
			_tmp17_ = bak;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp17_);
			_g_object_unref0 (bak);
		}
		_tmp18_ = store;
		_tmp19_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp18_, &iter);
		iterExists = _tmp19_;
	}
	result = list;
	_g_object_unref0 (sel);
	_g_object_unref0 (store);
	return result;
}

static void
snapshot_list_box_class_init (SnapshotListBoxClass * klass,
                              gpointer klass_data)
{
	snapshot_list_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SnapshotListBox_private_offset);
	G_OBJECT_CLASS (klass)->finalize = snapshot_list_box_finalize;
	snapshot_list_box_signals[SNAPSHOT_LIST_BOX_DELETE_SELECTED_SIGNAL] = g_signal_new ("delete-selected", TYPE_SNAPSHOT_LIST_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	snapshot_list_box_signals[SNAPSHOT_LIST_BOX_MARK_SELECTED_SIGNAL] = g_signal_new ("mark-selected", TYPE_SNAPSHOT_LIST_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	snapshot_list_box_signals[SNAPSHOT_LIST_BOX_BROWSE_SELECTED_SIGNAL] = g_signal_new ("browse-selected", TYPE_SNAPSHOT_LIST_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	snapshot_list_box_signals[SNAPSHOT_LIST_BOX_VIEW_SNAPSHOT_LOG_SIGNAL] = g_signal_new ("view-snapshot-log", TYPE_SNAPSHOT_LIST_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}

static void
snapshot_list_box_instance_init (SnapshotListBox * self,
                                 gpointer klass)
{
	self->priv = snapshot_list_box_get_instance_private (self);
	self->priv->treeview_sort_column_index = 0;
	self->priv->treeview_sort_column_desc = TRUE;
}

static void
snapshot_list_box_finalize (GObject * obj)
{
	SnapshotListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SNAPSHOT_LIST_BOX, SnapshotListBox);
	_g_object_unref0 (self->treeview);
	_g_object_unref0 (self->priv->col_date);
	_g_object_unref0 (self->priv->col_tags);
	_g_object_unref0 (self->priv->col_size);
	_g_object_unref0 (self->priv->col_unshared);
	_g_object_unref0 (self->priv->col_system);
	_g_object_unref0 (self->priv->col_desc);
	_g_object_unref0 (self->priv->menu_snapshots);
	_g_object_unref0 (self->priv->mi_browse);
	_g_object_unref0 (self->priv->mi_remove);
	_g_object_unref0 (self->priv->mi_mark);
	_g_object_unref0 (self->priv->mi_view_log_create);
	_g_object_unref0 (self->priv->mi_view_log_restore);
	_g_object_unref0 (self->priv->parent_window);
	G_OBJECT_CLASS (snapshot_list_box_parent_class)->finalize (obj);
}

static GType
snapshot_list_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SnapshotListBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) snapshot_list_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SnapshotListBox), 0, (GInstanceInitFunc) snapshot_list_box_instance_init, NULL };
	GType snapshot_list_box_type_id;
	snapshot_list_box_type_id = g_type_register_static (gtk_box_get_type (), "SnapshotListBox", &g_define_type_info, 0);
	SnapshotListBox_private_offset = g_type_add_instance_private (snapshot_list_box_type_id, sizeof (SnapshotListBoxPrivate));
	return snapshot_list_box_type_id;
}

GType
snapshot_list_box_get_type (void)
{
	static volatile gsize snapshot_list_box_type_id__once = 0;
	if (g_once_init_enter (&snapshot_list_box_type_id__once)) {
		GType snapshot_list_box_type_id;
		snapshot_list_box_type_id = snapshot_list_box_get_type_once ();
		g_once_init_leave (&snapshot_list_box_type_id__once, snapshot_list_box_type_id);
	}
	return snapshot_list_box_type_id__once;
}

