/*
The MIT License (MIT)

Copyright (c) 2016-2020 Containous SAS; 2020-2026 Traefik Labs

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"

	applyconfigurationtraefikiov1alpha1 "github.com/traefik/traefik/v3/pkg/provider/kubernetes/crd/generated/applyconfiguration/traefikio/v1alpha1"
	scheme "github.com/traefik/traefik/v3/pkg/provider/kubernetes/crd/generated/clientset/versioned/scheme"
	traefikiov1alpha1 "github.com/traefik/traefik/v3/pkg/provider/kubernetes/crd/traefikio/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// TLSStoresGetter has a method to return a TLSStoreInterface.
// A group's client should implement this interface.
type TLSStoresGetter interface {
	TLSStores(namespace string) TLSStoreInterface
}

// TLSStoreInterface has methods to work with TLSStore resources.
type TLSStoreInterface interface {
	Create(ctx context.Context, tLSStore *traefikiov1alpha1.TLSStore, opts v1.CreateOptions) (*traefikiov1alpha1.TLSStore, error)
	Update(ctx context.Context, tLSStore *traefikiov1alpha1.TLSStore, opts v1.UpdateOptions) (*traefikiov1alpha1.TLSStore, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*traefikiov1alpha1.TLSStore, error)
	List(ctx context.Context, opts v1.ListOptions) (*traefikiov1alpha1.TLSStoreList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *traefikiov1alpha1.TLSStore, err error)
	Apply(ctx context.Context, tLSStore *applyconfigurationtraefikiov1alpha1.TLSStoreApplyConfiguration, opts v1.ApplyOptions) (result *traefikiov1alpha1.TLSStore, err error)
	TLSStoreExpansion
}

// tLSStores implements TLSStoreInterface
type tLSStores struct {
	*gentype.ClientWithListAndApply[*traefikiov1alpha1.TLSStore, *traefikiov1alpha1.TLSStoreList, *applyconfigurationtraefikiov1alpha1.TLSStoreApplyConfiguration]
}

// newTLSStores returns a TLSStores
func newTLSStores(c *TraefikV1alpha1Client, namespace string) *tLSStores {
	return &tLSStores{
		gentype.NewClientWithListAndApply[*traefikiov1alpha1.TLSStore, *traefikiov1alpha1.TLSStoreList, *applyconfigurationtraefikiov1alpha1.TLSStoreApplyConfiguration](
			"tlsstores",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *traefikiov1alpha1.TLSStore { return &traefikiov1alpha1.TLSStore{} },
			func() *traefikiov1alpha1.TLSStoreList { return &traefikiov1alpha1.TLSStoreList{} },
		),
	}
}
