// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from property.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include "LineProperty.h"

#include "PropertiesTypes.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

class Union::Properties::LinePropertyPrivate
{
public:
    std::optional<qreal> size;
    std::optional<Union::Color> color;
    std::optional<Union::Properties::LineStyle> style;
    std::optional<ImageProperty> image;
};

LineProperty::LineProperty()
    : d(std::make_unique<LinePropertyPrivate>())
{
}

LineProperty::LineProperty(const LineProperty &other)
    : d(std::make_unique<LinePropertyPrivate>())
{
    d->size = other.d->size;
    d->color = other.d->color;
    d->style = other.d->style;
    d->image = other.d->image;
}

LineProperty::LineProperty(LineProperty &&other)
    : d(std::move(other.d))
{
}

LineProperty::~LineProperty() = default;

LineProperty &LineProperty::operator=(const LineProperty &other)
{
    if (this != &other) {
        d->size = other.d->size;
        d->color = other.d->color;
        d->style = other.d->style;
        d->image = other.d->image;
    }
    return *this;
}

LineProperty &LineProperty::operator=(LineProperty &&other)
{
    std::swap(d, other.d);
    return *this;
}

std::optional<qreal> LineProperty::size() const
{
    return d->size;
}

void LineProperty::setSize(const std::optional<qreal> &newValue)
{
    if (newValue == d->size) {
        return;
    }

    d->size = newValue;
}
std::optional<Union::Color> LineProperty::color() const
{
    return d->color;
}

void LineProperty::setColor(const std::optional<Union::Color> &newValue)
{
    if (newValue == d->color) {
        return;
    }

    d->color = newValue;
}
std::optional<Union::Properties::LineStyle> LineProperty::style() const
{
    return d->style;
}

void LineProperty::setStyle(const std::optional<Union::Properties::LineStyle> &newValue)
{
    if (newValue == d->style) {
        return;
    }

    d->style = newValue;
}
std::optional<ImageProperty> LineProperty::image() const
{
    return d->image;
}

ImageProperty LineProperty::image_or_new() const
{
    return d->image.value_or(ImageProperty{});
}

void LineProperty::setImage(const std::optional<ImageProperty> &newValue)
{
    if (newValue == d->image) {
        return;
    }

    d->image = newValue;
}

bool LineProperty::hasAnyValue() const
{
    if (d->size.has_value()) {
        return true;
    }
    if (d->color.has_value()) {
        return true;
    }
    if (d->style.has_value()) {
        return true;
    }
    if (d->image.has_value() && d->image->hasAnyValue()) {
        return true;
    }
    return false;
}

bool LineProperty::isEmpty() const
{
    if (!hasAnyValue()) {
        return true;
    }

    if (d->size.has_value() && d->size.value() != emptyValue<qreal>()) {
        return false;
    }
    if (d->color.has_value() && d->color.value() != emptyValue<Union::Color>()) {
        return false;
    }
    if (d->style.has_value() && d->style.value() != emptyValue<Union::Properties::LineStyle>()) {
        return false;
    }
    if (d->image.has_value() && !d->image->isEmpty()) {
        return false;
    }

    return true;
}

void LineProperty::resolveProperties(const LineProperty &source, LineProperty &destination)
{
    if (!destination.d->size.has_value()) {
        destination.d->size = source.d->size;
    }
    if (!destination.d->color.has_value()) {
        destination.d->color = source.d->color;
    }
    if (!destination.d->style.has_value()) {
        destination.d->style = source.d->style;
    }
    if (source.d->image.has_value()) {
        ImageProperty property;
        if (destination.d->image.has_value()) {
            property = destination.d->image.value();
        }
        ImageProperty::resolveProperties(source.d->image.value(), property);
        if (property.hasAnyValue()) {
            destination.d->image = property;
        }
    }
}

LineProperty LineProperty::empty()
{
    LineProperty result;
    result.d->size = emptyValue<qreal>();
    result.d->color = emptyValue<Union::Color>();
    result.d->style = emptyValue<Union::Properties::LineStyle>();
    result.d->image = emptyValue<ImageProperty>();
    return result;
}

bool Union::Properties::operator==(const LineProperty &left, const LineProperty &right)
{
    if (left.size() != right.size()) {
        return false;
    }
    if (left.color() != right.color()) {
        return false;
    }
    if (left.style() != right.style()) {
        return false;
    }
    if (left.image() != right.image()) {
        return false;
    }
    return true;
}

QDebug operator<<(QDebug debug, const Union::Properties::LineProperty &type)
{
    QDebugStateSaver saver(debug);
    debug.nospace() << "LineProperty(" //
                    << "size: " << type.size() //
                    << ", color: " << type.color() //
                    << ", style: " << type.style() //
                    << ", image: " << type.image() //
                    << ")";
    return debug;
}