﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appstream/AppStream_EXPORTS.h>
#include <aws/appstream/model/AccessEndpoint.h>
#include <aws/appstream/model/AppBlockBuilderPlatformType.h>
#include <aws/appstream/model/AppBlockBuilderState.h>
#include <aws/appstream/model/AppBlockBuilderStateChangeReason.h>
#include <aws/appstream/model/ResourceError.h>
#include <aws/appstream/model/VpcConfig.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace AppStream {
namespace Model {

/**
 * <p>Describes an app block builder.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/AppBlockBuilder">AWS
 * API Reference</a></p>
 */
class AppBlockBuilder {
 public:
  AWS_APPSTREAM_API AppBlockBuilder() = default;
  AWS_APPSTREAM_API AppBlockBuilder(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPSTREAM_API AppBlockBuilder& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPSTREAM_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ARN of the app block builder.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  AppBlockBuilder& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the app block builder.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  AppBlockBuilder& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The display name of the app block builder.</p>
   */
  inline const Aws::String& GetDisplayName() const { return m_displayName; }
  inline bool DisplayNameHasBeenSet() const { return m_displayNameHasBeenSet; }
  template <typename DisplayNameT = Aws::String>
  void SetDisplayName(DisplayNameT&& value) {
    m_displayNameHasBeenSet = true;
    m_displayName = std::forward<DisplayNameT>(value);
  }
  template <typename DisplayNameT = Aws::String>
  AppBlockBuilder& WithDisplayName(DisplayNameT&& value) {
    SetDisplayName(std::forward<DisplayNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description of the app block builder.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  AppBlockBuilder& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The platform of the app block builder.</p> <p>
   * <code>WINDOWS_SERVER_2019</code> is the only valid value.</p>
   */
  inline AppBlockBuilderPlatformType GetPlatform() const { return m_platform; }
  inline bool PlatformHasBeenSet() const { return m_platformHasBeenSet; }
  inline void SetPlatform(AppBlockBuilderPlatformType value) {
    m_platformHasBeenSet = true;
    m_platform = value;
  }
  inline AppBlockBuilder& WithPlatform(AppBlockBuilderPlatformType value) {
    SetPlatform(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The instance type of the app block builder.</p>
   */
  inline const Aws::String& GetInstanceType() const { return m_instanceType; }
  inline bool InstanceTypeHasBeenSet() const { return m_instanceTypeHasBeenSet; }
  template <typename InstanceTypeT = Aws::String>
  void SetInstanceType(InstanceTypeT&& value) {
    m_instanceTypeHasBeenSet = true;
    m_instanceType = std::forward<InstanceTypeT>(value);
  }
  template <typename InstanceTypeT = Aws::String>
  AppBlockBuilder& WithInstanceType(InstanceTypeT&& value) {
    SetInstanceType(std::forward<InstanceTypeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Indicates whether default internet access is enabled for the app block
   * builder.</p>
   */
  inline bool GetEnableDefaultInternetAccess() const { return m_enableDefaultInternetAccess; }
  inline bool EnableDefaultInternetAccessHasBeenSet() const { return m_enableDefaultInternetAccessHasBeenSet; }
  inline void SetEnableDefaultInternetAccess(bool value) {
    m_enableDefaultInternetAccessHasBeenSet = true;
    m_enableDefaultInternetAccess = value;
  }
  inline AppBlockBuilder& WithEnableDefaultInternetAccess(bool value) {
    SetEnableDefaultInternetAccess(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the IAM role that is applied to the app block builder.</p>
   */
  inline const Aws::String& GetIamRoleArn() const { return m_iamRoleArn; }
  inline bool IamRoleArnHasBeenSet() const { return m_iamRoleArnHasBeenSet; }
  template <typename IamRoleArnT = Aws::String>
  void SetIamRoleArn(IamRoleArnT&& value) {
    m_iamRoleArnHasBeenSet = true;
    m_iamRoleArn = std::forward<IamRoleArnT>(value);
  }
  template <typename IamRoleArnT = Aws::String>
  AppBlockBuilder& WithIamRoleArn(IamRoleArnT&& value) {
    SetIamRoleArn(std::forward<IamRoleArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The VPC configuration for the app block builder.</p>
   */
  inline const VpcConfig& GetVpcConfig() const { return m_vpcConfig; }
  inline bool VpcConfigHasBeenSet() const { return m_vpcConfigHasBeenSet; }
  template <typename VpcConfigT = VpcConfig>
  void SetVpcConfig(VpcConfigT&& value) {
    m_vpcConfigHasBeenSet = true;
    m_vpcConfig = std::forward<VpcConfigT>(value);
  }
  template <typename VpcConfigT = VpcConfig>
  AppBlockBuilder& WithVpcConfig(VpcConfigT&& value) {
    SetVpcConfig(std::forward<VpcConfigT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The state of the app block builder.</p>
   */
  inline AppBlockBuilderState GetState() const { return m_state; }
  inline bool StateHasBeenSet() const { return m_stateHasBeenSet; }
  inline void SetState(AppBlockBuilderState value) {
    m_stateHasBeenSet = true;
    m_state = value;
  }
  inline AppBlockBuilder& WithState(AppBlockBuilderState value) {
    SetState(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The creation time of the app block builder.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedTime() const { return m_createdTime; }
  inline bool CreatedTimeHasBeenSet() const { return m_createdTimeHasBeenSet; }
  template <typename CreatedTimeT = Aws::Utils::DateTime>
  void SetCreatedTime(CreatedTimeT&& value) {
    m_createdTimeHasBeenSet = true;
    m_createdTime = std::forward<CreatedTimeT>(value);
  }
  template <typename CreatedTimeT = Aws::Utils::DateTime>
  AppBlockBuilder& WithCreatedTime(CreatedTimeT&& value) {
    SetCreatedTime(std::forward<CreatedTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The app block builder errors.</p>
   */
  inline const Aws::Vector<ResourceError>& GetAppBlockBuilderErrors() const { return m_appBlockBuilderErrors; }
  inline bool AppBlockBuilderErrorsHasBeenSet() const { return m_appBlockBuilderErrorsHasBeenSet; }
  template <typename AppBlockBuilderErrorsT = Aws::Vector<ResourceError>>
  void SetAppBlockBuilderErrors(AppBlockBuilderErrorsT&& value) {
    m_appBlockBuilderErrorsHasBeenSet = true;
    m_appBlockBuilderErrors = std::forward<AppBlockBuilderErrorsT>(value);
  }
  template <typename AppBlockBuilderErrorsT = Aws::Vector<ResourceError>>
  AppBlockBuilder& WithAppBlockBuilderErrors(AppBlockBuilderErrorsT&& value) {
    SetAppBlockBuilderErrors(std::forward<AppBlockBuilderErrorsT>(value));
    return *this;
  }
  template <typename AppBlockBuilderErrorsT = ResourceError>
  AppBlockBuilder& AddAppBlockBuilderErrors(AppBlockBuilderErrorsT&& value) {
    m_appBlockBuilderErrorsHasBeenSet = true;
    m_appBlockBuilderErrors.emplace_back(std::forward<AppBlockBuilderErrorsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The state change reason.</p>
   */
  inline const AppBlockBuilderStateChangeReason& GetStateChangeReason() const { return m_stateChangeReason; }
  inline bool StateChangeReasonHasBeenSet() const { return m_stateChangeReasonHasBeenSet; }
  template <typename StateChangeReasonT = AppBlockBuilderStateChangeReason>
  void SetStateChangeReason(StateChangeReasonT&& value) {
    m_stateChangeReasonHasBeenSet = true;
    m_stateChangeReason = std::forward<StateChangeReasonT>(value);
  }
  template <typename StateChangeReasonT = AppBlockBuilderStateChangeReason>
  AppBlockBuilder& WithStateChangeReason(StateChangeReasonT&& value) {
    SetStateChangeReason(std::forward<StateChangeReasonT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The list of interface VPC endpoint (interface endpoint) objects.
   * Administrators can connect to the app block builder only through the specified
   * endpoints.</p>
   */
  inline const Aws::Vector<AccessEndpoint>& GetAccessEndpoints() const { return m_accessEndpoints; }
  inline bool AccessEndpointsHasBeenSet() const { return m_accessEndpointsHasBeenSet; }
  template <typename AccessEndpointsT = Aws::Vector<AccessEndpoint>>
  void SetAccessEndpoints(AccessEndpointsT&& value) {
    m_accessEndpointsHasBeenSet = true;
    m_accessEndpoints = std::forward<AccessEndpointsT>(value);
  }
  template <typename AccessEndpointsT = Aws::Vector<AccessEndpoint>>
  AppBlockBuilder& WithAccessEndpoints(AccessEndpointsT&& value) {
    SetAccessEndpoints(std::forward<AccessEndpointsT>(value));
    return *this;
  }
  template <typename AccessEndpointsT = AccessEndpoint>
  AppBlockBuilder& AddAccessEndpoints(AccessEndpointsT&& value) {
    m_accessEndpointsHasBeenSet = true;
    m_accessEndpoints.emplace_back(std::forward<AccessEndpointsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;
  bool m_arnHasBeenSet = false;

  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  Aws::String m_displayName;
  bool m_displayNameHasBeenSet = false;

  Aws::String m_description;
  bool m_descriptionHasBeenSet = false;

  AppBlockBuilderPlatformType m_platform{AppBlockBuilderPlatformType::NOT_SET};
  bool m_platformHasBeenSet = false;

  Aws::String m_instanceType;
  bool m_instanceTypeHasBeenSet = false;

  bool m_enableDefaultInternetAccess{false};
  bool m_enableDefaultInternetAccessHasBeenSet = false;

  Aws::String m_iamRoleArn;
  bool m_iamRoleArnHasBeenSet = false;

  VpcConfig m_vpcConfig;
  bool m_vpcConfigHasBeenSet = false;

  AppBlockBuilderState m_state{AppBlockBuilderState::NOT_SET};
  bool m_stateHasBeenSet = false;

  Aws::Utils::DateTime m_createdTime{};
  bool m_createdTimeHasBeenSet = false;

  Aws::Vector<ResourceError> m_appBlockBuilderErrors;
  bool m_appBlockBuilderErrorsHasBeenSet = false;

  AppBlockBuilderStateChangeReason m_stateChangeReason;
  bool m_stateChangeReasonHasBeenSet = false;

  Aws::Vector<AccessEndpoint> m_accessEndpoints;
  bool m_accessEndpointsHasBeenSet = false;
};

}  // namespace Model
}  // namespace AppStream
}  // namespace Aws
