/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.text;

import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.features.format.FormatController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.SummaryNode;
import org.freeplane.features.text.AbstractContentTransformer;
import org.freeplane.features.text.IContentTransformer;
import org.freeplane.features.text.TextController;

class FormatContentTransformer
extends AbstractContentTransformer {
    private final TextController textController;

    public FormatContentTransformer(TextController textController, int priority) {
        super(priority);
        this.textController = textController;
    }

    @Override
    public Object transformContent(NodeModel node, Object nodeProperty, Object obj, TextController textController, IContentTransformer.Mode mode, Component component) {
        if (obj == null || node == null || node != nodeProperty) {
            return obj;
        }
        String format = textController.getNodeFormat(node);
        boolean nodeNumbering = textController.getNodeNumbering(node);
        return this.expandFormat(obj, node, format, nodeNumbering);
    }

    private Object expandFormat(Object obj, NodeModel node, String format, boolean nodeNumbering) {
        boolean isHtml;
        boolean hasFormat;
        boolean bl = hasFormat = format != null && format.length() != 0 && !(obj instanceof Icon) && !"NO_FORMAT".equals(format) && !"STANDARD_FORMAT".equals(format);
        if (!hasFormat && !nodeNumbering) {
            return obj;
        }
        boolean bl2 = isHtml = obj instanceof String && HtmlUtils.isHtml((String)obj);
        if (isHtml) {
            obj = HtmlUtils.extractRawBody((String)obj);
        }
        if (hasFormat) {
            obj = FormatController.format(obj, format);
        }
        if (nodeNumbering && !node.isRoot()) {
            StringBuilder builder = new StringBuilder(node.getNodeLevel() * 2);
            this.addNumbers(builder, node);
            builder.append(' ');
            obj = isHtml ? this.insertPrefix(obj.toString(), builder.toString()) : builder.toString() + obj;
        }
        if (isHtml) {
            obj = "<html><head></head><body>" + obj + "</body></html>";
        }
        return obj.toString();
    }

    private String insertPrefix(String html, String prefix) {
        int i;
        StringBuilder sb = new StringBuilder(html.length() + prefix.length() + 1);
        int level = 0;
        block4: for (i = 0; i < html.length(); ++i) {
            char c = html.charAt(i);
            switch (c) {
                case '<': {
                    ++level;
                    continue block4;
                }
                case '>': {
                    --level;
                    continue block4;
                }
                default: {
                    if (level == 0 && !Character.isWhitespace(c)) break block4;
                }
            }
        }
        sb.append(html.subSequence(0, i));
        sb.append(prefix);
        sb.append(html.subSequence(i, html.length()));
        return sb.toString();
    }

    private void addNumbers(StringBuilder builder, NodeModel node) {
        NodeModel parentNode = node.getParentNode();
        if (parentNode == null) {
            return;
        }
        this.addMajorNumbers(parentNode, builder);
        List<NodeModel> children = parentNode.getChildren();
        int counter = 1;
        for (NodeModel child : children) {
            if (child.createID().equals(node.createID())) break;
            if (!this.textController.getNodeNumbering(child)) continue;
            ++counter;
        }
        builder.append(counter);
    }

    private void addMajorNumbers(NodeModel node, StringBuilder builder) {
        if (SummaryNode.isSummaryNode(node)) {
            NodeModel summaryParentNode = node.getParentNode();
            if (summaryParentNode == null) {
                return;
            }
            this.addMajorNumbers(summaryParentNode, builder);
        } else if (this.textController.getNodeNumbering(node)) {
            this.addNumbers(builder, node);
            if (builder.length() > 0) {
                builder.append('.');
            }
        }
    }
}

