/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.filepreview;

import java.awt.Color;
import java.awt.Dimension;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import javax.swing.JComponent;
import javax.swing.border.MatteBorder;
import org.freeplane.core.util.LogUtils;
import org.freeplane.view.swing.features.filepreview.BitmapViewerComponent;
import org.freeplane.view.swing.features.filepreview.IViewerFactory;

public class ImageRendererFactory {
    private static final int BORDER_WIDTH = 2;

    public void configureRenderer(IViewerFactory viewerFactory, URI uri, Dimension size, JComponent renderer) {
        renderer.setBorder(new MatteBorder(2, 2, 2, 2, Color.BLACK));
        renderer.setPreferredSize(size);
        renderer.setSize(size);
        Dimension viewerSize = new Dimension(size.width - 4, size.height - 4);
        JComponent viewer = this.createViewer(viewerFactory, uri, viewerSize);
        if (viewer != null) {
            renderer.add(viewer);
            viewer.setLocation(2, 2);
        }
    }

    private JComponent createViewer(IViewerFactory viewerFactory, URI uri, Dimension size) {
        JComponent viewer = null;
        try {
            viewer = (JComponent)((Object)viewerFactory.createViewer(uri, size));
        }
        catch (MalformedURLException e) {
            LogUtils.warn(e);
            return null;
        }
        catch (IOException e) {
            LogUtils.warn(e);
            return null;
        }
        if (viewer == null) {
            return null;
        }
        if (viewer instanceof BitmapViewerComponent) {
            ((BitmapViewerComponent)viewer).setHint(2);
        }
        return viewer;
    }

    public JComponent createRenderer(IViewerFactory viewerFactory, URI absoluteUri, Dimension tooltipSize) {
        JComponent renderer = new JComponent(){};
        this.configureRenderer(viewerFactory, absoluteUri, tooltipSize, renderer);
        return renderer;
    }
}

