/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.dom;

import io.sf.carte.echosvg.css.dom.CSSOMValue;
import io.sf.carte.echosvg.css.engine.value.AbstractValueModificationHandler;
import io.sf.carte.echosvg.css.engine.value.CSSVal;
import io.sf.carte.echosvg.css.engine.value.Value;
import java.util.HashMap;
import java.util.Map;
import org.w3c.css.om.CSSRule;
import org.w3c.css.om.CSSStyleDeclaration;
import org.w3c.dom.DOMException;

public class CSSOMStyleDeclaration
implements CSSStyleDeclaration {
    protected ValueProvider valueProvider;
    protected ModificationHandler handler;
    protected CSSRule parentRule;
    protected Map<String, CSSVal> values;

    public CSSOMStyleDeclaration(ValueProvider vp, CSSRule parent) {
        this.valueProvider = vp;
        this.parentRule = parent;
    }

    public void setModificationHandler(ModificationHandler h) {
        this.handler = h;
    }

    public String getCssText() {
        return this.valueProvider.getText();
    }

    public void setCssText(String cssText) throws DOMException {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        this.values = null;
        this.handler.textChanged(cssText);
    }

    public String getPropertyValue(String propertyName) {
        Value value = this.valueProvider.getValue(propertyName);
        if (value == null) {
            return "";
        }
        return value.getCssText();
    }

    public CSSVal getCSSStyleValue(String propertyName) {
        Value value = this.valueProvider.getValue(propertyName);
        if (value == null) {
            return null;
        }
        return this.getCSSValue(propertyName);
    }

    public String removeProperty(String propertyName) throws DOMException {
        String result = this.getPropertyValue(propertyName);
        if (result.length() > 0) {
            if (this.handler == null) {
                throw new DOMException(7, "");
            }
            if (this.values != null) {
                this.values.remove(propertyName);
            }
            this.handler.propertyRemoved(propertyName);
        }
        return result;
    }

    public String getPropertyPriority(String propertyName) {
        return this.valueProvider.isImportant(propertyName) ? "important" : "";
    }

    public void setProperty(String propertyName, String value, String prio) throws DOMException {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        this.handler.propertyChanged(propertyName, value, prio);
    }

    public int getLength() {
        return this.valueProvider.getLength();
    }

    public String item(int index) {
        return this.valueProvider.item(index);
    }

    public CSSRule getParentRule() {
        return this.parentRule;
    }

    protected CSSVal getCSSValue(String name) {
        CSSVal result = null;
        if (this.values != null) {
            result = this.values.get(name);
        }
        if (result == null) {
            result = this.createCSSValue(name);
            if (this.values == null) {
                this.values = new HashMap<String, CSSVal>(11);
            }
            this.values.put(name, result);
        }
        return result;
    }

    protected CSSVal createCSSValue(String name) {
        return new StyleDeclarationValue(name);
    }

    public static interface ValueProvider {
        public Value getValue(String var1);

        public boolean isImportant(String var1);

        public String getText();

        public int getLength();

        public String item(int var1);
    }

    public static interface ModificationHandler {
        public void textChanged(String var1) throws DOMException;

        public void propertyRemoved(String var1) throws DOMException;

        public void propertyChanged(String var1, String var2, String var3) throws DOMException;
    }

    public class StyleDeclarationValue
    extends CSSOMValue
    implements CSSOMValue.ValueProvider {
        private static final long serialVersionUID = 1L;
        protected String property;

        public StyleDeclarationValue(String prop) {
            super(null);
            this.valueProvider = this;
            this.setModificationHandler(new AbstractValueModificationHandler(){

                @Override
                protected Value getValue() {
                    return StyleDeclarationValue.this.getValue();
                }

                @Override
                protected void setPropertyText(String text) throws DOMException {
                    if (CSSOMStyleDeclaration.this.values == null || StyleDeclarationValue.this.handler == null) {
                        throw new DOMException(7, "");
                    }
                    String prio = CSSOMStyleDeclaration.this.getPropertyPriority(StyleDeclarationValue.this.property);
                    CSSOMStyleDeclaration.this.handler.propertyChanged(StyleDeclarationValue.this.property, text, prio);
                }
            });
            this.property = prop;
        }

        @Override
        public Value getValue() {
            return CSSOMStyleDeclaration.this.valueProvider.getValue(this.property);
        }
    }
}

