/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.StringList;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractRuleList;
import io.sf.carte.doc.style.css.om.MarginRule;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.Collection;

public class MarginRuleList
extends AbstractRuleList<MarginRule> {
    private static final long serialVersionUID = 1L;

    public MarginRuleList(int initialCapacity) {
        super(initialCapacity);
    }

    public MarginRuleList() {
        super(16);
    }

    public MarginRuleList(Collection<MarginRule> c) {
        super(c);
    }

    @Override
    public String toString() {
        int sz = this.size();
        StringBuilder sb = new StringBuilder(sz * 20);
        for (int i = 0; i < sz; ++i) {
            AbstractCSSRule rule = (AbstractCSSRule)this.item(i);
            StringList comments = rule.getPrecedingComments();
            if (comments != null) {
                int nc = comments.size();
                for (int j = 0; j < nc; ++j) {
                    sb.append("/*").append((String)comments.get(j)).append("*/\n");
                }
            }
            sb.append(rule.getCssText()).append('\n');
        }
        return sb.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            AbstractCSSRule rule = (AbstractCSSRule)this.item(i);
            StringList comments = rule.getPrecedingComments();
            if (comments != null) {
                int nc = comments.size();
                for (int j = 0; j < nc; ++j) {
                    context.writeComment(wri, (String)comments.get(j));
                }
            }
            rule.writeCssText(wri, context);
        }
    }
}

