/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.assembler;

import com.sun.istack.internal.logging.Logger;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.assembler.DefaultClientTubelineAssemblyContext;
import com.sun.xml.internal.ws.assembler.DefaultServerTubelineAssemblyContext;
import com.sun.xml.internal.ws.assembler.dev.ClientTubelineAssemblyContext;
import com.sun.xml.internal.ws.assembler.dev.TubeFactory;
import com.sun.xml.internal.ws.assembler.dev.TubelineAssemblyContextUpdater;
import com.sun.xml.internal.ws.resources.TubelineassemblyMessages;
import com.sun.xml.internal.ws.runtime.config.TubeFactoryConfig;

final class TubeCreator {
    private static final Logger LOGGER = Logger.getLogger(TubeCreator.class);
    private final TubeFactory factory;
    private final String msgDumpPropertyBase;

    TubeCreator(TubeFactoryConfig config, ClassLoader tubeFactoryClassLoader) {
        String className = config.getClassName();
        try {
            Class<?> factoryClass = this.isJDKInternal(className) ? Class.forName(className, true, null) : Class.forName(className, true, tubeFactoryClassLoader);
            if (!TubeFactory.class.isAssignableFrom(factoryClass)) {
                throw new RuntimeException(TubelineassemblyMessages.MASM_0015_CLASS_DOES_NOT_IMPLEMENT_INTERFACE(factoryClass.getName(), TubeFactory.class.getName()));
            }
            Class<?> typedClass = factoryClass;
            this.factory = (TubeFactory)typedClass.newInstance();
            this.msgDumpPropertyBase = this.factory.getClass().getName() + ".dump";
        }
        catch (InstantiationException ex) {
            throw LOGGER.logSevereException(new RuntimeException(TubelineassemblyMessages.MASM_0016_UNABLE_TO_INSTANTIATE_TUBE_FACTORY(className), ex), true);
        }
        catch (IllegalAccessException ex) {
            throw LOGGER.logSevereException(new RuntimeException(TubelineassemblyMessages.MASM_0016_UNABLE_TO_INSTANTIATE_TUBE_FACTORY(className), ex), true);
        }
        catch (ClassNotFoundException ex) {
            throw LOGGER.logSevereException(new RuntimeException(TubelineassemblyMessages.MASM_0017_UNABLE_TO_LOAD_TUBE_FACTORY_CLASS(className), ex), true);
        }
    }

    Tube createTube(DefaultClientTubelineAssemblyContext context) {
        return this.factory.createTube(context);
    }

    Tube createTube(DefaultServerTubelineAssemblyContext context) {
        return this.factory.createTube(context);
    }

    void updateContext(ClientTubelineAssemblyContext context) {
        if (this.factory instanceof TubelineAssemblyContextUpdater) {
            ((TubelineAssemblyContextUpdater)((Object)this.factory)).prepareContext(context);
        }
    }

    void updateContext(DefaultServerTubelineAssemblyContext context) {
        if (this.factory instanceof TubelineAssemblyContextUpdater) {
            ((TubelineAssemblyContextUpdater)((Object)this.factory)).prepareContext(context);
        }
    }

    String getMessageDumpPropertyBase() {
        return this.msgDumpPropertyBase;
    }

    private boolean isJDKInternal(String className) {
        return className.startsWith("com.sun.xml.internal.ws");
    }
}

