/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Optional;
import kafka.server.ControllerInformation;
import kafka.server.ControllerNodeProvider;
import kafka.server.KafkaConfig;
import kafka.server.NodeToControllerQueueItem;
import kafka.server.NodeToControllerRequestThread;
import kafka.utils.Logging;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.ControllerRequestCompletionHandler;
import org.apache.kafka.server.common.NodeToControllerChannelManager;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ud\u0001B\f\u0019\u0001uA\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t{\u0001\u0011\t\u0011)A\u0005}!AA\t\u0001B\u0001B\u0003%Q\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011!q\u0005A!A!\u0002\u0013y\u0005\u0002\u0003/\u0001\u0005\u0003\u0005\u000b\u0011B(\t\u0011u\u0003!\u0011!Q\u0001\nyCQA\u0019\u0001\u0005\u0002\rDq\u0001\u001c\u0001C\u0002\u0013%Q\u000e\u0003\u0004r\u0001\u0001\u0006IA\u001c\u0005\be\u0002\u0011\r\u0011\"\u0003t\u0011\u0019Q\b\u0001)A\u0005i\"91\u0010\u0001b\u0001\n\u0013a\bbBA\u0001\u0001\u0001\u0006I! \u0005\n\u0003\u0007\u0001!\u0019!C\u0005\u0003\u000bA\u0001\"!\u0004\u0001A\u0003%\u0011q\u0001\u0005\b\u0003\u001f\u0001A\u0011AA\t\u0011\u001d\tI\u0002\u0001C\u0001\u0003#A\u0001\"a\u0007\u0001\t\u0003A\u0012Q\u0001\u0005\b\u0003;\u0001A\u0011AA\u0010\u0011\u001d\tY\u0006\u0001C\u0001\u0003;Bq!!\u001d\u0001\t\u0003\t\u0019H\u0001\u0012O_\u0012,Gk\\\"p]R\u0014x\u000e\u001c7fe\u000eC\u0017M\u001c8fY6\u000bg.Y4fe&k\u0007\u000f\u001c\u0006\u00033i\taa]3sm\u0016\u0014(\"A\u000e\u0002\u000b-\fgm[1\u0004\u0001M!\u0001A\b\u00143!\tyB%D\u0001!\u0015\t\t#%\u0001\u0003mC:<'\"A\u0012\u0002\t)\fg/Y\u0005\u0003K\u0001\u0012aa\u00142kK\u000e$\bCA\u00141\u001b\u0005A#BA\u0015+\u0003\u0019\u0019w.\\7p]*\u0011\u0011d\u000b\u0006\u000371R!!\f\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0013aA8sO&\u0011\u0011\u0007\u000b\u0002\u001f\u001d>$W\rV8D_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ\u0004\"a\r\u001c\u000e\u0003QR!!\u000e\u000e\u0002\u000bU$\u0018\u000e\\:\n\u0005]\"$a\u0002'pO\u001eLgnZ\u0001\u0017G>tGO]8mY\u0016\u0014hj\u001c3f!J|g/\u001b3feB\u0011!hO\u0007\u00021%\u0011A\b\u0007\u0002\u0017\u0007>tGO]8mY\u0016\u0014hj\u001c3f!J|g/\u001b3fe\u0006!A/[7f!\ty$)D\u0001A\u0015\t)\u0014I\u0003\u0002*W%\u00111\t\u0011\u0002\u0005)&lW-A\u0004nKR\u0014\u0018nY:\u0011\u0005\u0019CU\"A$\u000b\u0005\u0011\u000b\u0015BA%H\u0005\u001diU\r\u001e:jGN\faaY8oM&<\u0007C\u0001\u001eM\u0013\ti\u0005DA\u0006LC\u001a\\\u0017mQ8oM&<\u0017aC2iC:tW\r\u001c(b[\u0016\u0004\"\u0001U-\u000f\u0005E;\u0006C\u0001*V\u001b\u0005\u0019&B\u0001+\u001d\u0003\u0019a$o\\8u})\ta+A\u0003tG\u0006d\u0017-\u0003\u0002Y+\u00061\u0001K]3eK\u001aL!AW.\u0003\rM#(/\u001b8h\u0015\tAV+\u0001\tuQJ,\u0017\r\u001a(b[\u0016\u0004&/\u001a4jq\u0006q!/\u001a;ssRKW.Z8vi6\u001b\bCA0a\u001b\u0005)\u0016BA1V\u0005\u0011auN\\4\u0002\rqJg.\u001b;?)!!WMZ4iS*\\\u0007C\u0001\u001e\u0001\u0011\u0015A\u0004\u00021\u0001:\u0011\u0015i\u0004\u00021\u0001?\u0011\u0015!\u0005\u00021\u0001F\u0011\u0015Q\u0005\u00021\u0001L\u0011\u0015q\u0005\u00021\u0001P\u0011\u0015a\u0006\u00021\u0001P\u0011\u0015i\u0006\u00021\u0001_\u0003)awnZ\"p]R,\u0007\u0010^\u000b\u0002]B\u0011qh\\\u0005\u0003a\u0002\u0013!\u0002T8h\u0007>tG/\u001a=u\u0003-awnZ\"p]R,\u0007\u0010\u001e\u0011\u0002+5\fg.^1m\u001b\u0016$\u0018\rZ1uCV\u0003H-\u0019;feV\tA\u000f\u0005\u0002vq6\taO\u0003\u0002xW\u000591\r\\5f]R\u001c\u0018BA=w\u0005Ui\u0015M\\;bY6+G/\u00193bi\u0006,\u0006\u000fZ1uKJ\fa#\\1ok\u0006dW*\u001a;bI\u0006$\u0018-\u00169eCR,'\u000fI\u0001\fCBLg+\u001a:tS>t7/F\u0001~!\t)h0\u0003\u0002\u0000m\nY\u0011\t]5WKJ\u001c\u0018n\u001c8t\u00031\t\u0007/\u001b,feNLwN\\:!\u00035\u0011X-];fgR$\u0006N]3bIV\u0011\u0011q\u0001\t\u0004u\u0005%\u0011bAA\u00061\tibj\u001c3f)>\u001cuN\u001c;s_2dWM\u001d*fcV,7\u000f\u001e+ie\u0016\fG-\u0001\bsKF,Xm\u001d;UQJ,\u0017\r\u001a\u0011\u0002\u000bM$\u0018M\u001d;\u0015\u0005\u0005M\u0001cA0\u0002\u0016%\u0019\u0011qC+\u0003\tUs\u0017\u000e^\u0001\tg\",H\u000fZ8x]\u0006\u0001b.Z<SKF,Xm\u001d;UQJ,\u0017\rZ\u0001\fg\u0016tGMU3rk\u0016\u001cH\u000f\u0006\u0004\u0002\u0014\u0005\u0005\u0012\u0011\u000b\u0005\b\u0003G!\u0002\u0019AA\u0013\u0003\u001d\u0011X-];fgR\u0004D!a\n\u0002@A1\u0011\u0011FA\u001b\u0003wqA!a\u000b\u000225\u0011\u0011Q\u0006\u0006\u0004\u0003_\t\u0015\u0001\u0003:fcV,7\u000f^:\n\t\u0005M\u0012QF\u0001\u0010\u0003\n\u001cHO]1diJ+\u0017/^3ti&!\u0011qGA\u001d\u0005\u001d\u0011U/\u001b7eKJTA!a\r\u0002.A!\u0011QHA \u0019\u0001!A\"!\u0011\u0002\"\u0005\u0005\t\u0011!B\u0001\u0003\u0007\u00121a\u0018\u00132#\u0011\t)%a\u0013\u0011\u0007}\u000b9%C\u0002\u0002JU\u0013qAT8uQ&tw\r\u0005\u0003\u0002,\u00055\u0013\u0002BA(\u0003[\u0011q\"\u00112tiJ\f7\r\u001e*fcV,7\u000f\u001e\u0005\b\u0003'\"\u0002\u0019AA+\u0003!\u0019\u0017\r\u001c7cC\u000e\\\u0007cA\u0014\u0002X%\u0019\u0011\u0011\f\u0015\u0003E\r{g\u000e\u001e:pY2,'OU3rk\u0016\u001cHoQ8na2,G/[8o\u0011\u0006tG\r\\3s\u0003U\u0019wN\u001c;s_2dWM]!qSZ+'o]5p]N$\"!a\u0018\u0011\r\u0005\u0005\u0014qMA6\u001b\t\t\u0019GC\u0002\u0002f\t\nA!\u001e;jY&!\u0011\u0011NA2\u0005!y\u0005\u000f^5p]\u0006d\u0007cA;\u0002n%\u0019\u0011q\u000e<\u0003\u001f9{G-Z!qSZ+'o]5p]N\fAbZ3u)&lWm\\;u\u001bN$\u0012A\u0018")
public class NodeToControllerChannelManagerImpl
implements NodeToControllerChannelManager,
Logging {
    private final ControllerNodeProvider controllerNodeProvider;
    private final Time time;
    private final Metrics metrics;
    private final KafkaConfig config;
    private final String channelName;
    private final String threadNamePrefix;
    private final long retryTimeoutMs;
    private final LogContext logContext;
    private final ManualMetadataUpdater manualMetadataUpdater;
    private final ApiVersions apiVersions;
    private final NodeToControllerRequestThread requestThread;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private ManualMetadataUpdater manualMetadataUpdater() {
        return this.manualMetadataUpdater;
    }

    private ApiVersions apiVersions() {
        return this.apiVersions;
    }

    private NodeToControllerRequestThread requestThread() {
        return this.requestThread;
    }

    public void start() {
        this.requestThread().start();
    }

    public void shutdown() {
        this.requestThread().shutdown();
        this.info((Function0<String>)(Function0 & Serializable)() -> "Node to controller channel manager for " + $this.channelName + " shutdown");
    }

    public NodeToControllerRequestThread newRequestThread() {
        String threadName = this.threadNamePrefix + "to-controller-" + this.channelName + "-channel-manager";
        ControllerInformation controllerInformation = this.controllerNodeProvider.getControllerInfo();
        return new NodeToControllerRequestThread((KafkaClient)this.buildNetworkClient$1(controllerInformation), this.manualMetadataUpdater(), this.controllerNodeProvider, this.config, this.time, threadName, this.retryTimeoutMs);
    }

    public void sendRequest(AbstractRequest.Builder<? extends AbstractRequest> request, ControllerRequestCompletionHandler callback) {
        this.requestThread().enqueue(new NodeToControllerQueueItem(this.time.milliseconds(), request, callback));
    }

    public Optional<NodeApiVersions> controllerApiVersions() {
        return OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(this.requestThread().activeControllerAddress().flatMap((Function1 & Serializable)activeController -> Option$.MODULE$.apply((Object)this.apiVersions().get(activeController.idString())))));
    }

    public long getTimeoutMs() {
        return this.retryTimeoutMs;
    }

    private final NetworkClient buildNetworkClient$1(ControllerInformation controllerInfo) {
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)controllerInfo.securityProtocol(), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)this.config, (ListenerName)controllerInfo.listenerName(), (String)controllerInfo.saslMechanism(), (Time)this.time, (LogContext)this.logContext());
        if (channelBuilder instanceof Reconfigurable) {
            this.config.addReconfigurable((Reconfigurable)channelBuilder);
        }
        Selector selector = new Selector(-1, -1L, this.metrics, this.time, this.channelName, CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"BrokerId"), (Object)Integer.toString(this.config.brokerId()))}))).asJava(), false, channelBuilder, this.logContext());
        return new NetworkClient((Selectable)selector, (MetadataUpdater)this.manualMetadataUpdater(), Integer.toString(this.config.brokerId()), 1, 50L, 50L, -1, -1, (int)Math.min(Integer.MAX_VALUE, Math.min((long)this.config.controllerSocketTimeoutMs(), this.retryTimeoutMs)), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, true, this.apiVersions(), this.logContext(), MetadataRecoveryStrategy.NONE);
    }

    public NodeToControllerChannelManagerImpl(ControllerNodeProvider controllerNodeProvider, Time time, Metrics metrics, KafkaConfig config, String channelName, String threadNamePrefix, long retryTimeoutMs) {
        this.controllerNodeProvider = controllerNodeProvider;
        this.time = time;
        this.metrics = metrics;
        this.config = config;
        this.channelName = channelName;
        this.threadNamePrefix = threadNamePrefix;
        this.retryTimeoutMs = retryTimeoutMs;
        this.logContext = new LogContext("[NodeToControllerChannelManager id=" + config.nodeId() + " name=" + channelName + "] ");
        this.manualMetadataUpdater = new ManualMetadataUpdater();
        this.apiVersions = new ApiVersions();
        this.requestThread = this.newRequestThread();
    }
}

