/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.server.common.Feature;
import org.apache.kafka.server.common.MetadataVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerFeatures {
    private final Features<SupportedVersionRange> supportedFeatures;
    private static final Logger log = LoggerFactory.getLogger(BrokerFeatures.class);

    private BrokerFeatures(Features<SupportedVersionRange> supportedFeatures) {
        this.supportedFeatures = supportedFeatures;
    }

    public static BrokerFeatures createDefault(boolean unstableFeatureVersionsEnabled) {
        return new BrokerFeatures(BrokerFeatures.defaultSupportedFeatures(unstableFeatureVersionsEnabled));
    }

    public static BrokerFeatures createDefault(boolean unstableFeatureVersionsEnabled, Features<SupportedVersionRange> newFeatures) {
        HashMap combined = new HashMap(BrokerFeatures.defaultSupportedFeatures(unstableFeatureVersionsEnabled).features());
        combined.putAll(newFeatures.features());
        return new BrokerFeatures((Features<SupportedVersionRange>)Features.supportedFeatures(combined));
    }

    public static Map<String, VersionRange> createDefaultFeatureMap(BrokerFeatures features) {
        return features.supportedFeatures.features().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> VersionRange.of((short)((SupportedVersionRange)e.getValue()).min(), (short)((SupportedVersionRange)e.getValue()).max())));
    }

    public static Features<SupportedVersionRange> defaultSupportedFeatures(boolean unstableFeatureVersionsEnabled) {
        HashMap<String, SupportedVersionRange> features = new HashMap<String, SupportedVersionRange>();
        features.put("metadata.version", new SupportedVersionRange(MetadataVersion.MINIMUM_VERSION.featureLevel(), unstableFeatureVersionsEnabled ? MetadataVersion.latestTesting().featureLevel() : MetadataVersion.latestProduction().featureLevel()));
        Feature.PRODUCTION_FEATURES.forEach(feature -> {
            short maxVersion;
            short s = maxVersion = unstableFeatureVersionsEnabled ? feature.latestTesting() : feature.latestProduction();
            if (maxVersion > 0) {
                features.put(feature.featureName(), new SupportedVersionRange(feature.minimumProduction(), maxVersion));
            }
        });
        return Features.supportedFeatures(features);
    }

    public static BrokerFeatures createEmpty() {
        return new BrokerFeatures((Features<SupportedVersionRange>)Features.emptySupportedFeatures());
    }

    public static boolean hasIncompatibleFeatures(Features<SupportedVersionRange> supportedFeatures, Map<String, Short> finalizedFeatures) {
        return !BrokerFeatures.incompatibleFeatures(supportedFeatures, finalizedFeatures, false).isEmpty();
    }

    public Map<String, Short> defaultFinalizedFeatures() {
        return this.supportedFeatures.features().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((String)e.getKey()).equals("kraft.version") ? (short)0 : ((SupportedVersionRange)e.getValue()).max()));
    }

    public Map<String, Short> incompatibleFeatures(Map<String, Short> finalized) {
        return BrokerFeatures.incompatibleFeatures(this.supportedFeatures, finalized, true);
    }

    public Features<SupportedVersionRange> supportedFeatures() {
        return this.supportedFeatures;
    }

    private static Map<String, Short> incompatibleFeatures(Features<SupportedVersionRange> supportedFeatures, Map<String, Short> finalizedFeatures, boolean logIncompatibilities) {
        HashMap<String, Short> incompatibleFeaturesInfo = new HashMap<String, Short>();
        finalizedFeatures.forEach((feature, versionLevels) -> {
            SupportedVersionRange supportedVersions = (SupportedVersionRange)supportedFeatures.get(feature);
            if (supportedVersions == null) {
                incompatibleFeaturesInfo.put((String)feature, (Short)versionLevels);
                if (logIncompatibilities) {
                    log.warn("Feature incompatibilities seen: {feature={}, reason='Unknown feature'}", feature);
                }
            } else if (supportedVersions.isIncompatibleWith(versionLevels.shortValue())) {
                incompatibleFeaturesInfo.put((String)feature, (Short)versionLevels);
                if (logIncompatibilities) {
                    log.warn("Feature incompatibilities seen: {feature={}, reason='{} is incompatible with {}'}", new Object[]{feature, versionLevels, supportedVersions});
                }
            }
        });
        return incompatibleFeaturesInfo;
    }
}

