/*
 * Decompiled with CFR 0.152.
 */
package io.setl.rdf.normalization;

import com.apicatalog.rdf.RdfNQuad;
import com.apicatalog.rdf.RdfResource;
import com.apicatalog.rdf.RdfValue;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;

public enum Position {
    SUBJECT('s'){

        @Override
        public boolean isBlank(RdfNQuad quad) {
            return quad.getSubject().isBlankNode();
        }

        @Override
        RdfValue get(RdfNQuad quad) {
            return quad.getSubject();
        }
    }
    ,
    OBJECT('o'){

        @Override
        RdfValue get(RdfNQuad quad) {
            return quad.getObject();
        }

        @Override
        public boolean isBlank(RdfNQuad quad) {
            return quad.getObject().isBlankNode();
        }
    }
    ,
    GRAPH('g'){

        @Override
        RdfValue get(RdfNQuad quad) {
            return quad.getGraphName().orElse(null);
        }

        @Override
        public boolean isBlank(RdfNQuad quad) {
            Optional name = quad.getGraphName();
            return name.isPresent() && ((RdfResource)name.get()).isBlankNode();
        }
    }
    ,
    PREDICATE('p'){

        @Override
        RdfValue get(RdfNQuad quad) {
            return quad.getPredicate();
        }

        @Override
        public boolean isBlank(RdfNQuad quad) {
            return false;
        }
    };

    public static final Set<Position> CAN_BE_BLANK;
    private final byte tag;

    private Position(char ch) {
        this.tag = (byte)ch;
    }

    abstract RdfValue get(RdfNQuad var1);

    abstract boolean isBlank(RdfNQuad var1);

    public byte tag() {
        return this.tag;
    }

    static {
        CAN_BE_BLANK = Collections.unmodifiableSet(EnumSet.of(SUBJECT, OBJECT, GRAPH));
    }
}

