/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.spi;

import org.hibernate.AssertionFailure;
import org.hibernate.internal.util.StringHelper;

public class SqlAliasStemHelper {
    public static final SqlAliasStemHelper INSTANCE = new SqlAliasStemHelper();

    public String generateStemFromEntityName(String entityName) {
        return this.acronym(this.toSimpleEntityName(entityName));
    }

    private String toSimpleEntityName(String entityName) {
        String simpleName = StringHelper.unqualify(entityName);
        if (simpleName.contains("$")) {
            simpleName = simpleName.substring(simpleName.lastIndexOf(36) + 1);
        }
        if (StringHelper.isEmpty(simpleName)) {
            throw new AssertionFailure("Could not determine simple name as base for alias [" + entityName + "]");
        }
        return simpleName;
    }

    public String generateStemFromAttributeName(String attributeName) {
        return this.acronym(attributeName);
    }

    private String acronym(String name) {
        StringBuilder string = new StringBuilder();
        char last = '\u0000';
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Character.isLetter(ch) && (string.length() == 0 || Character.isUpperCase(ch) && !Character.isUpperCase(last))) {
                string.append(Character.toLowerCase(ch));
            }
            last = ch;
        }
        return string.length() == 0 ? "z" : string.toString();
    }
}

