/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.Objects;
import java.util.OptionalLong;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.CompletableApplicationEvent;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;

public class CurrentLagEvent
extends CompletableApplicationEvent<OptionalLong> {
    private final TopicPartition partition;
    private final IsolationLevel isolationLevel;

    public CurrentLagEvent(TopicPartition partition, IsolationLevel isolationLevel, long deadlineMs) {
        super(ApplicationEvent.Type.CURRENT_LAG, deadlineMs);
        this.partition = Objects.requireNonNull(partition);
        this.isolationLevel = Objects.requireNonNull(isolationLevel);
    }

    public TopicPartition partition() {
        return this.partition;
    }

    public IsolationLevel isolationLevel() {
        return this.isolationLevel;
    }

    @Override
    public String toStringBase() {
        return super.toStringBase() + ", partition=" + String.valueOf(this.partition) + ", isolationLevel=" + String.valueOf((Object)this.isolationLevel);
    }
}

