/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSArray;
import com.dd.plist.NSNull;
import com.dd.plist.NSObject;
import java.io.IOException;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class NSSet
extends NSObject {
    private final Set<NSObject> set;
    private boolean ordered = false;

    public NSSet() {
        this.set = new LinkedHashSet<NSObject>();
    }

    public NSSet(boolean ordered) {
        this.ordered = ordered;
        this.set = ordered ? new TreeSet() : new LinkedHashSet();
    }

    public NSSet(NSObject ... objects) {
        this.set = new LinkedHashSet<NSObject>();
        this.set.addAll(Arrays.asList(objects));
    }

    public NSSet(boolean ordered, NSObject ... objects) {
        this(ordered);
        this.set.addAll(Arrays.stream(objects).map(NSNull::wrap).collect(Collectors.toCollection(ArrayList::new)));
    }

    public synchronized void addObject(NSObject obj) {
        this.set.add(NSNull.wrap(obj));
    }

    public synchronized void removeObject(NSObject obj) {
        this.set.remove(NSNull.wrap(obj));
    }

    public synchronized NSObject[] allObjects() {
        return (NSObject[])this.set.stream().map(NSNull::unwrap).toArray(NSObject[]::new);
    }

    public synchronized NSObject anyObject() {
        if (this.set.isEmpty()) {
            return null;
        }
        return NSNull.unwrap(this.set.iterator().next());
    }

    public boolean containsObject(NSObject obj) {
        return this.set.contains(NSNull.wrap(obj));
    }

    public synchronized NSObject member(NSObject obj) {
        for (NSObject o : this.set) {
            if (!o.equals(NSNull.wrap(obj))) continue;
            return o;
        }
        return null;
    }

    public synchronized boolean intersectsSet(NSSet otherSet) {
        for (NSObject o : this.set) {
            if (!otherSet.containsObject(o)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isSubsetOfSet(NSSet otherSet) {
        for (NSObject o : this.set) {
            if (otherSet.containsObject(o)) continue;
            return false;
        }
        return true;
    }

    public synchronized Iterator<NSObject> objectIterator() {
        return this.set.stream().map(NSNull::unwrap).iterator();
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.set != null ? this.set.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo((NSObject)obj) == 0;
    }

    @Override
    public int compareTo(NSObject o) {
        Objects.requireNonNull(o);
        if (o == this) {
            return 0;
        }
        if (o instanceof NSSet) {
            NSSet other = (NSSet)o;
            if (other.count() != this.count()) {
                return Integer.compare(this.count(), other.count());
            }
            NSObject[] thisObjects = this.allObjects();
            NSObject[] otherObjects = other.allObjects();
            for (int i2 = 0; i2 < this.count(); ++i2) {
                int itemDiff = NSNull.wrap(thisObjects[i2]).compareTo(NSNull.wrap(otherObjects[i2]));
                if (itemDiff == 0) continue;
                return itemDiff;
            }
            return 0;
        }
        return this.getClass().getName().compareTo(o.getClass().getName());
    }

    public synchronized int count() {
        return this.set.size();
    }

    @Override
    public NSSet clone() {
        NSObject[] clonedSet = new NSObject[this.set.size()];
        int i2 = 0;
        for (NSObject element : this.set) {
            clonedSet[i2++] = element != null ? element.clone() : null;
        }
        return new NSSet(this.ordered, clonedSet);
    }

    @Override
    public Object toJavaObject() {
        AbstractSet clonedSet = this.ordered ? new TreeSet() : new LinkedHashSet(this.set.size());
        for (NSObject o : this.set) {
            clonedSet.add(o.toJavaObject());
        }
        return clonedSet;
    }

    @Override
    void toXML(StringBuilder xml, int level) {
        new NSArray(this.allObjects()).toXML(xml, level);
    }

    @Override
    void assignIDs(BinaryPropertyListWriter out) {
        super.assignIDs(out);
        for (NSObject obj : this.set) {
            obj.assignIDs(out);
        }
    }

    @Override
    void toBinary(BinaryPropertyListWriter out) throws IOException {
        if (this.ordered) {
            out.writeIntHeader(11, this.set.size());
        } else {
            out.writeIntHeader(12, this.set.size());
        }
        for (NSObject obj : this.set) {
            out.writeID(out.getID(obj));
        }
    }

    @Override
    protected void toASCII(StringBuilder ascii, int level) {
        new NSArray(this.allObjects()).toASCII(ascii, level);
    }

    @Override
    protected void toASCIIGnuStep(StringBuilder ascii, int level) {
        new NSArray(this.allObjects()).toASCIIGnuStep(ascii, level);
    }
}

