/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsNotifier;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitConflictResolver;
import git4idea.stash.UnstashMergeDialogCustomizer;
import git4idea.ui.StashInfo;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lgit4idea/stash/UnstashConflictResolver;", "Lgit4idea/merge/GitConflictResolver;", "project", "Lcom/intellij/openapi/project/Project;", "stashInfo", "Lgit4idea/ui/StashInfo;", "<init>", "(Lcom/intellij/openapi/project/Project;Lgit4idea/ui/StashInfo;)V", "notifyUnresolvedRemain", "", "Companion", "intellij.vcs.git"})
final class UnstashConflictResolver
extends GitConflictResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StashInfo stashInfo;

    public UnstashConflictResolver(@NotNull Project project, @NotNull StashInfo stashInfo) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)stashInfo, (String)"stashInfo");
        super(project, SetsKt.setOf((Object)stashInfo.getRoot()), UnstashConflictResolver.Companion.makeParams(project, stashInfo));
        this.stashInfo = stashInfo;
    }

    @Override
    protected void notifyUnresolvedRemain() {
        NotificationGroup notificationGroup = VcsNotifier.importantNotification();
        String string = GitBundle.message("unstash.dialog.unresolved.conflict.warning.notification.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = GitBundle.message("unstash.dialog.unresolved.conflict.warning.notification.message", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        notificationGroup.createNotification(string, string2, NotificationType.WARNING).setDisplayId("git.unstash.with.unresolved.conflicts").addAction((AnAction)NotificationAction.createSimple(GitBundle.messagePointer("unstash.dialog.unresolved.conflict.warning.resolve.conflicts.action", new Object[0]), () -> UnstashConflictResolver.notifyUnresolvedRemain$lambda$0(this))).notify(this.myProject);
    }

    private static final void notifyUnresolvedRemain$lambda$0(UnstashConflictResolver this$0) {
        Project project = this$0.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        new UnstashConflictResolver(project, this$0.stashInfo).mergeNoProceedInBackground();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lgit4idea/stash/UnstashConflictResolver$Companion;", "", "<init>", "()V", "makeParams", "Lgit4idea/merge/GitConflictResolver$Params;", "project", "Lcom/intellij/openapi/project/Project;", "stashInfo", "Lgit4idea/ui/StashInfo;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        private final GitConflictResolver.Params makeParams(Project project, StashInfo stashInfo) {
            GitConflictResolver.Params params = new GitConflictResolver.Params(project);
            params.setErrorNotificationTitle(GitBundle.message("unstash.unstashed.with.conflicts.error.title", new Object[0]));
            params.setMergeDialogCustomizer(new UnstashMergeDialogCustomizer(stashInfo));
            return params;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

