/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.profiler.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.graalvm.options.OptionType;

class WildcardFilter {
    static final OptionType<WildcardFilter> WILDCARD_FILTER_TYPE = new OptionType("Expression", (Function)new Function<String, WildcardFilter>(){

        @Override
        public WildcardFilter apply(String filterWildcardExpression) {
            if (filterWildcardExpression == null) {
                return null;
            }
            String[] expressions = filterWildcardExpression.split(",");
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            ArrayList<String> strings = new ArrayList<String>();
            for (int i = 0; i < expressions.length; ++i) {
                String expression = expressions[i];
                if ((expression = expression.trim()).contains("?") || expression.contains("*")) {
                    try {
                        patterns.add(Pattern.compile(WildcardFilter.wildcardToRegex(expression)));
                        continue;
                    }
                    catch (PatternSyntaxException e) {
                        throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Invalid wildcard pattern %s.", expression), e);
                    }
                }
                strings.add(expression);
            }
            return new WildcardFilter(strings, patterns, filterWildcardExpression);
        }
    });
    static final WildcardFilter DEFAULT = new WildcardFilter(new ArrayList<String>(0), new ArrayList<Pattern>(0), "*");
    final List<String> strings;
    final List<Pattern> patterns;
    private final String expression;

    private static String wildcardToRegex(String wildcard) {
        StringBuilder s = new StringBuilder(wildcard.length());
        s.append('^');
        int is = wildcard.length();
        block5: for (int i = 0; i < is; ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    s.append("\\S*");
                    continue block5;
                }
                case '?': {
                    s.append("\\S");
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    s.append("\\");
                    s.append(c);
                    continue block5;
                }
                default: {
                    s.append(c);
                }
            }
        }
        s.append('$');
        return s.toString();
    }

    boolean testWildcardExpressions(String value) {
        if (this.strings.isEmpty() && this.patterns.isEmpty()) {
            return true;
        }
        if (value == null) {
            return false;
        }
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(value).matches()) continue;
            return true;
        }
        for (String string : this.strings) {
            if (!string.equals(value)) continue;
            return true;
        }
        return false;
    }

    WildcardFilter(List<String> strings, List<Pattern> patterns, String expression) {
        Objects.requireNonNull(strings);
        Objects.requireNonNull(patterns);
        this.strings = strings;
        this.patterns = patterns;
        this.expression = expression;
    }

    public String toString() {
        return this.expression;
    }
}

