/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.tomcat.util.ExceptionUtils;

public class SendMailFactory
implements ObjectFactory {
    protected static final String DataSourceClassName = "javax.mail.internet.MimePartDataSource";

    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws Exception {
        Reference reference = (Reference)object;
        if (reference.getClassName().equals(DataSourceClassName)) {
            return AccessController.doPrivileged(() -> {
                Properties properties = new Properties();
                Enumeration<RefAddr> enumeration = reference.getAll();
                properties.put("mail.transport.protocol", "smtp");
                while (enumeration.hasMoreElements()) {
                    RefAddr refAddr = enumeration.nextElement();
                    properties.put(refAddr.getType(), refAddr.getContent());
                }
                MimeMessage mimeMessage = new MimeMessage(Session.getInstance((Properties)properties));
                try {
                    RefAddr refAddr = reference.get("mail.from");
                    String string = null;
                    if (refAddr != null) {
                        string = (String)refAddr.getContent();
                    }
                    if (string != null) {
                        mimeMessage.setFrom(new InternetAddress(string));
                    }
                    mimeMessage.setSubject("");
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                }
                return new MimePartDataSource((MimePart)mimeMessage);
            });
        }
        return null;
    }
}

